from X3Dpackage import *
X3D0 = X3D()
X3D0.setProfile("Immersive")
X3D0.setVersion("3.3")
head1 = head()
meta2 = meta()
meta2.setContent("CameraExamples.x3d")
meta2.setName("title")
head1.addMeta(meta2)
meta3 = meta()
meta3.setContent("Camera, CameraShot and CameraMove examples that demonstrate storyboard capabilities and precise camera operation. This is a developmental effort for potential X3D Specification improvement.")
meta3.setName("description")
head1.addMeta(meta3)
meta4 = meta()
meta4.setContent("Two demos are found in the scene, click the \"red text\" on left or right to start. (a) SimpleShotsTest shows Zoom in/out, Pan left/right, Boom up/down, Tilt left/right, with each is defined by a CameraShot collecting a series of CameraMovements. (b) AimPointTest gradually slews the camera view to look at the sliding cube, then follows it around before returning to original viewpoint.")
meta4.setName("documentation")
head1.addMeta(meta4)
meta5 = meta()
meta5.setContent("Don Brutzman and Jeff Weekley")
meta5.setName("creator")
head1.addMeta(meta5)
meta6 = meta()
meta6.setContent("18 June 2009")
meta6.setName("created")
head1.addMeta(meta6)
meta7 = meta()
meta7.setContent("12 January 2014")
meta7.setName("modified")
head1.addMeta(meta7)
meta8 = meta()
meta8.setContent("Schematron rules, backed up by initialize() checks")
meta8.setName("TODO")
head1.addMeta(meta8)
meta9 = meta()
meta9.setContent("BeyondViewpointCameraNodesWeb3D2009.pdf")
meta9.setName("reference")
head1.addMeta(meta9)
meta10 = meta()
meta10.setContent("CameraExamplesDemo.mp4")
meta10.setName("MovingImage")
head1.addMeta(meta10)
meta11 = meta()
meta11.setContent("http://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/navigation.html")
meta11.setName("reference")
head1.addMeta(meta11)
meta12 = meta()
meta12.setContent("Camera nodes for Viewpoint navigation control")
meta12.setName("subject")
head1.addMeta(meta12)
meta13 = meta()
meta13.setContent("CameraPrototypes.x3d")
meta13.setName("reference")
head1.addMeta(meta13)
meta14 = meta()
meta14.setContent("CameraExamplesConsoleLog.txt")
meta14.setName("reference")
head1.addMeta(meta14)
meta15 = meta()
meta15.setContent("http://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.avi")
meta15.setName("reference")
head1.addMeta(meta15)
meta16 = meta()
meta16.setContent("http://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d")
meta16.setName("reference")
head1.addMeta(meta16)
# TODO warn if more than one identifier present 
meta17 = meta()
meta17.setContent("http://www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.x3d")
meta17.setName("identifier")
head1.addMeta(meta17)
meta18 = meta()
meta18.setContent("http://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.x3d")
meta18.setName("identifier")
head1.addMeta(meta18)
meta19 = meta()
meta19.setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit")
meta19.setName("generator")
head1.addMeta(meta19)
meta20 = meta()
meta20.setContent("../license.html")
meta20.setName("license")
head1.addMeta(meta20)
X3D0.setHead(head1)
Scene21 = Scene()
# =============== Camera ============== 
ExternProtoDeclare22 = ExternProtoDeclare()
ExternProtoDeclare22.setAppinfo("Camera node provides direct control of scene view to enable cinematic camera animation shot by shot and move by move along with still digital-photography settings for offline rendering of camera images")
ExternProtoDeclare22.setName("Camera")
ExternProtoDeclare22.setUrl(["CameraPrototypes.x3d#Camera","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#Camera","CameraPrototypes.wrl#Camera","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#Camera"])
# Viewpoint-related fields, NavigationInfo-related fields and Camera-unique fields 
field23 = field()
field23.setAccessType("inputOutput")
field23.setAppinfo("Text description to be displayed for this Camera")
field23.setName("description")
field23.setType("SFString")
ExternProtoDeclare22.addField(field23)
field24 = field()
field24.setAccessType("inputOutput")
field24.setAppinfo("Camera position in local transformation frame, which is default prior to first CameraShot initialPosition getting activated")
field24.setName("position")
field24.setType("SFVec3f")
ExternProtoDeclare22.addField(field24)
field25 = field()
field25.setAccessType("inputOutput")
field25.setAppinfo("Camera rotation in local transformation frame, which is default prior to first CameraShot initialPosition getting activated")
field25.setName("orientation")
field25.setType("SFRotation")
ExternProtoDeclare22.addField(field25)
field26 = field()
field26.setAccessType("inputOutput")
field26.setAppinfo("pi/4")
field26.setName("fieldOfView")
field26.setType("SFFloat")
ExternProtoDeclare22.addField(field26)
field27 = field()
field27.setAccessType("inputOnly")
field27.setAppinfo("input fraction drives interpolators")
field27.setName("set_fraction")
field27.setType("SFFloat")
ExternProtoDeclare22.addField(field27)
field28 = field()
field28.setAccessType("inputOnly")
field28.setAppinfo("input event binds or unbinds this Camera")
field28.setName("set_bind")
field28.setType("SFBool")
ExternProtoDeclare22.addField(field28)
field29 = field()
field29.setAccessType("outputOnly")
field29.setAppinfo("output event indicates when this Camera is bound")
field29.setName("bindTime")
field29.setType("SFTime")
ExternProtoDeclare22.addField(field29)
field30 = field()
field30.setAccessType("outputOnly")
field30.setAppinfo("output event indicates whether this Camera is bound or unbound")
field30.setName("isBound")
field30.setType("SFBool")
ExternProtoDeclare22.addField(field30)
field31 = field()
field31.setAccessType("inputOutput")
field31.setAppinfo("Vector distance to near clipping plane corresponds to NavigationInfo.avatarSize[0]")
field31.setName("nearClipPlane")
field31.setType("SFFloat")
ExternProtoDeclare22.addField(field31)
field32 = field()
field32.setAccessType("inputOutput")
field32.setAppinfo("Vector distance to far clipping plane corresponds to NavigationInfo.visibilityLimit")
field32.setName("farClipPlane")
field32.setType("SFFloat")
ExternProtoDeclare22.addField(field32)
field33 = field()
field33.setAccessType("inputOutput")
field33.setAppinfo("Array of CameraShot nodes which in turn contain CameraMovement nodes")
field33.setName("shots")
field33.setType("MFNode")
ExternProtoDeclare22.addField(field33)
field34 = field()
field34.setAccessType("inputOutput")
field34.setAppinfo("Whether camera headlight is on or off")
field34.setName("headlight")
field34.setType("SFBool")
ExternProtoDeclare22.addField(field34)
field35 = field()
field35.setAccessType("inputOutput")
field35.setAppinfo("Camera headlight color")
field35.setName("headlightColor")
field35.setType("SFColor")
ExternProtoDeclare22.addField(field35)
field36 = field()
field36.setAccessType("inputOutput")
field36.setAppinfo("Camera headlight intensity")
field36.setName("headlightIntensity")
field36.setType("SFFloat")
ExternProtoDeclare22.addField(field36)
field37 = field()
field37.setAccessType("inputOutput")
field37.setAppinfo("Camera filter color that modifies virtual lens capture")
field37.setName("filterColor")
field37.setType("SFColor")
ExternProtoDeclare22.addField(field37)
field38 = field()
field38.setAccessType("inputOutput")
field38.setAppinfo("Camera filter transparency that modifies virtual lens capture")
field38.setName("filterTransparency")
field38.setType("SFFloat")
ExternProtoDeclare22.addField(field38)
field39 = field()
field39.setAccessType("inputOutput")
field39.setAppinfo("upVector changes modify camera orientation (and possibly vice versa)")
field39.setName("upVector")
field39.setType("SFVec3f")
ExternProtoDeclare22.addField(field39)
field40 = field()
field40.setAccessType("inputOutput")
field40.setAppinfo("Focal length divided effective aperture diameter indicating width of focal plane")
field40.setName("fStop")
field40.setType("SFFloat")
ExternProtoDeclare22.addField(field40)
field41 = field()
field41.setAccessType("inputOutput")
field41.setAppinfo("Distance to focal plane of sharpest focus")
field41.setName("focusDistance")
field41.setType("SFFloat")
ExternProtoDeclare22.addField(field41)
field42 = field()
field42.setAccessType("outputOnly")
field42.setAppinfo("Mark start/stop with true/false output respectively useful to trigger external animations")
field42.setName("isActive")
field42.setType("SFBool")
ExternProtoDeclare22.addField(field42)
field43 = field()
field43.setAccessType("outputOnly")
field43.setAppinfo("Total duration of contained enabled CameraShot (and thus CameraMovement) move durations")
field43.setName("totalDuration")
field43.setType("SFTime")
ExternProtoDeclare22.addField(field43)
field44 = field()
field44.setAccessType("inputOutput")
field44.setAppinfo("OfflineRender node")
field44.setName("offlineRender")
field44.setType("SFNode")
ExternProtoDeclare22.addField(field44)
field45 = field()
field45.setAccessType("initializeOnly")
field45.setAppinfo("enable console output to trace script computations and prototype progress")
field45.setName("traceEnabled")
field45.setType("SFBool")
ExternProtoDeclare22.addField(field45)
Scene21.addChildren(ExternProtoDeclare22)
# =============== CameraShot ============== 
ExternProtoDeclare46 = ExternProtoDeclare()
ExternProtoDeclare46.setAppinfo("CameraShot collects a specific set of CameraMovement animations that make up an individual shot")
ExternProtoDeclare46.setName("CameraShot")
ExternProtoDeclare46.setUrl(["CameraPrototypes.x3d#CameraShot","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#CameraShot","CameraPrototypes.wrl#CameraShot","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#CameraShot"])
field47 = field()
field47.setAccessType("inputOutput")
field47.setAppinfo("Text description to be displayed for this CameraShot")
field47.setName("description")
field47.setType("SFString")
ExternProtoDeclare46.addField(field47)
field48 = field()
field48.setAccessType("inputOutput")
field48.setAppinfo("Whether this CameraShot can be activated")
field48.setName("enabled")
field48.setType("SFBool")
ExternProtoDeclare46.addField(field48)
field49 = field()
field49.setAccessType("inputOutput")
field49.setAppinfo("Set of CameraMovement nodes")
field49.setName("moves")
field49.setType("MFNode")
# initializing CameraMovement nodes are inserted here by scene author using ProtoInstance 
ExternProtoDeclare46.addField(field49)
field50 = field()
field50.setAccessType("inputOutput")
field50.setAppinfo("Setup to reinitialize camera position for this shot")
field50.setName("initialPosition")
field50.setType("SFVec3f")
ExternProtoDeclare46.addField(field50)
field51 = field()
field51.setAccessType("inputOutput")
field51.setAppinfo("Setup to reinitialize camera rotation for this shot")
field51.setName("initialOrientation")
field51.setType("SFRotation")
ExternProtoDeclare46.addField(field51)
field52 = field()
field52.setAccessType("inputOutput")
field52.setAppinfo("Setup to reinitialize aimpoint (relative location for camera direction) for this shot")
field52.setName("initialAimPoint")
field52.setType("SFVec3f")
ExternProtoDeclare46.addField(field52)
field53 = field()
field53.setAccessType("inputOutput")
field53.setAppinfo("pi/4")
field53.setName("initialFieldOfView")
field53.setType("SFFloat")
ExternProtoDeclare46.addField(field53)
field54 = field()
field54.setAccessType("inputOutput")
field54.setAppinfo("Focal length divided effective aperture diameter indicating width of focal plane")
field54.setName("initialFStop")
field54.setType("SFFloat")
ExternProtoDeclare46.addField(field54)
field55 = field()
field55.setAccessType("inputOutput")
field55.setAppinfo("Distance to focal plane of sharpest focus")
field55.setName("initialFocusDistance")
field55.setType("SFFloat")
ExternProtoDeclare46.addField(field55)
field56 = field()
field56.setAccessType("outputOnly")
field56.setAppinfo("Subtotal duration of contained CameraMovement move durations")
field56.setName("shotDuration")
field56.setType("SFTime")
ExternProtoDeclare46.addField(field56)
field57 = field()
field57.setAccessType("outputOnly")
field57.setAppinfo("Mark start/stop with true/false output respectively useful to trigger external animations")
field57.setName("isActive")
field57.setType("SFBool")
ExternProtoDeclare46.addField(field57)
field58 = field()
field58.setAccessType("initializeOnly")
field58.setAppinfo("enable console output to trace script computations and prototype progress")
field58.setName("traceEnabled")
field58.setType("SFBool")
ExternProtoDeclare46.addField(field58)
Scene21.addChildren(ExternProtoDeclare46)
# =============== CameraMovement ============== 
ExternProtoDeclare59 = ExternProtoDeclare()
ExternProtoDeclare59.setAppinfo("CameraMovement defines a single camera movement animation")
ExternProtoDeclare59.setName("CameraMovement")
ExternProtoDeclare59.setUrl(["CameraPrototypes.x3d#CameraMovement","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#CameraMovement","CameraPrototypes.wrl#CameraMovement","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#CameraMovement"])
field60 = field()
field60.setAccessType("inputOutput")
field60.setAppinfo("Text description to be displayed for this CameraMovement")
field60.setName("description")
field60.setType("SFString")
ExternProtoDeclare59.addField(field60)
field61 = field()
field61.setAccessType("inputOutput")
field61.setAppinfo("Whether this CameraMovement can be activated")
field61.setName("enabled")
field61.setType("SFBool")
ExternProtoDeclare59.addField(field61)
field62 = field()
field62.setAccessType("inputOutput")
field62.setAppinfo("Duration in seconds for this move")
field62.setName("duration")
field62.setType("SFFloat")
ExternProtoDeclare59.addField(field62)
field63 = field()
field63.setAccessType("inputOutput")
field63.setAppinfo("Goal camera position for this move")
field63.setName("goalPosition")
field63.setType("SFVec3f")
ExternProtoDeclare59.addField(field63)
field64 = field()
field64.setAccessType("inputOutput")
field64.setAppinfo("Goal camera rotation for this move")
field64.setName("goalOrientation")
field64.setType("SFRotation")
ExternProtoDeclare59.addField(field64)
field65 = field()
field65.setAccessType("inputOutput")
field65.setAppinfo("Whether or not camera direction is tracking towards the aimPoint")
field65.setName("tracking")
field65.setType("SFBool")
ExternProtoDeclare59.addField(field65)
field66 = field()
field66.setAccessType("inputOutput")
field66.setAppinfo("Goal aimPoint for this move, ignored if tracking=false")
field66.setName("goalAimPoint")
field66.setType("SFVec3f")
ExternProtoDeclare59.addField(field66)
field67 = field()
field67.setAccessType("inputOutput")
field67.setAppinfo("Goal fieldOfView for this move")
field67.setName("goalFieldOfView")
field67.setType("SFFloat")
ExternProtoDeclare59.addField(field67)
field68 = field()
field68.setAccessType("inputOutput")
field68.setAppinfo("Focal length divided effective aperture diameter indicating width of focal plane")
field68.setName("goalFStop")
field68.setType("SFFloat")
ExternProtoDeclare59.addField(field68)
field69 = field()
field69.setAccessType("inputOutput")
field69.setAppinfo("Distance to focal plane of sharpest focus")
field69.setName("goalFocusDistance")
field69.setType("SFFloat")
ExternProtoDeclare59.addField(field69)
field70 = field()
field70.setAccessType("outputOnly")
field70.setAppinfo("Mark start/stop with true/false output respectively useful to trigger external animations")
field70.setName("isActive")
field70.setType("SFBool")
ExternProtoDeclare59.addField(field70)
field71 = field()
field71.setAccessType("initializeOnly")
field71.setAppinfo("enable console output to trace script computations and prototype progress")
field71.setName("traceEnabled")
field71.setType("SFBool")
ExternProtoDeclare59.addField(field71)
Scene21.addChildren(ExternProtoDeclare59)
# =============== OfflineRender ============== 
ExternProtoDeclare72 = ExternProtoDeclare()
ExternProtoDeclare72.setAppinfo("OfflineRender defines a parameters for offline rendering of Camera animation output to a movie file (or possibly a still shot)")
ExternProtoDeclare72.setName("OfflineRender")
ExternProtoDeclare72.setUrl(["CameraPrototypes.x3d#OfflineRender","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#OfflineRender","CameraPrototypes.wrl#OfflineRender","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#OfflineRender"])
# TODO non-photorealistic rendering (NPR) parameters 
field73 = field()
field73.setAccessType("inputOutput")
field73.setAppinfo("Text description to be displayed for this OfflineRender")
field73.setName("description")
field73.setType("SFString")
ExternProtoDeclare72.addField(field73)
field74 = field()
field74.setAccessType("inputOutput")
field74.setAppinfo("Whether this OfflineRender can be activated")
field74.setName("enabled")
field74.setType("SFBool")
ExternProtoDeclare72.addField(field74)
field75 = field()
field75.setAccessType("inputOutput")
field75.setAppinfo("Frames per second recorded for this rendering")
field75.setName("frameRate")
field75.setType("SFFloat")
ExternProtoDeclare72.addField(field75)
field76 = field()
field76.setAccessType("inputOutput")
field76.setAppinfo("Size of frame in number of pixels width and height")
field76.setName("frameSize")
field76.setType("SFVec2f")
ExternProtoDeclare72.addField(field76)
field77 = field()
field77.setAccessType("inputOutput")
field77.setAppinfo("Relative dimensions of pixel height/width typically 1.33 or 1")
field77.setName("pixelAspectRatio")
field77.setType("SFFloat")
ExternProtoDeclare72.addField(field77)
field78 = field()
field78.setAccessType("inputOnly")
field78.setAppinfo("Begin render operation")
field78.setName("set_startTime")
field78.setType("SFTime")
ExternProtoDeclare72.addField(field78)
field79 = field()
field79.setAccessType("outputOnly")
field79.setAppinfo("Progress performing render operation (0..1)")
field79.setName("progress")
field79.setType("SFFloat")
ExternProtoDeclare72.addField(field79)
field80 = field()
field80.setAccessType("outputOnly")
field80.setAppinfo("Render operation complete")
field80.setName("renderCompleteTime")
field80.setType("SFTime")
ExternProtoDeclare72.addField(field80)
field81 = field()
field81.setAccessType("initializeOnly")
field81.setAppinfo("Format of rendered output movie (mpeg mp4 etc.), use first supported format")
field81.setName("movieFormat")
field81.setType("MFString")
ExternProtoDeclare72.addField(field81)
field82 = field()
field82.setAccessType("initializeOnly")
field82.setAppinfo("Format of rendered output images (png jpeg gif tiff etc.) use first supported format")
field82.setName("imageFormat")
field82.setType("MFString")
ExternProtoDeclare72.addField(field82)
field83 = field()
field83.setAccessType("initializeOnly")
field83.setAppinfo("enable console output to trace script computations and prototype progress")
field83.setName("traceEnabled")
field83.setType("SFBool")
ExternProtoDeclare72.addField(field83)
Scene21.addChildren(ExternProtoDeclare72)
# =============== Lights, camera, action! ============== 
DirectionalLight84 = DirectionalLight()
DirectionalLight84.setDirection([0,-1,0])
DirectionalLight84.setGlobal(True)
DirectionalLight84.setIntensity(0.8)
Scene21.addChildren(DirectionalLight84)
NavigationInfo85 = NavigationInfo()
NavigationInfo85.setType(["EXAMINE","FLY","ANY"])
Scene21.addChildren(NavigationInfo85)
Viewpoint86 = Viewpoint()
Viewpoint86.setDescription("Camera test scene entry view")
Viewpoint86.setPosition([0,2,12])
Scene21.addChildren(Viewpoint86)
Viewpoint87 = Viewpoint()
Viewpoint87.setDescription("Camera test scene from above")
Viewpoint87.setOrientation([1,0,0,-1.57079])
Viewpoint87.setPosition([0,150,0])
Scene21.addChildren(Viewpoint87)
# Keep prototype instances in same file while developing, then move later 
# We will create examples matching those in the paper 
# =============== Camera.SimpleShotsTest ============== 
ProtoInstance88 = ProtoInstance()
ProtoInstance88.setDEF("Camera.SimpleShotsTest")
ProtoInstance88.setName("Camera")
fieldValue89 = fieldValue()
fieldValue89.setName("description")
fieldValue89.setValue("SimpleShotsTest for camera Zoom Dolly Pan Boom and Tilt")
ProtoInstance88.addFieldValue(fieldValue89)
fieldValue90 = fieldValue()
fieldValue90.setName("headlight")
fieldValue90.setValue("true")
ProtoInstance88.addFieldValue(fieldValue90)
fieldValue91 = fieldValue()
fieldValue91.setName("position")
fieldValue91.setValue("-4 4 10")
ProtoInstance88.addFieldValue(fieldValue91)
fieldValue92 = fieldValue()
fieldValue92.setName("shots")
ProtoInstance93 = ProtoInstance()
ProtoInstance93.setDEF("Zoom")
ProtoInstance93.setName("CameraShot")
fieldValue94 = fieldValue()
fieldValue94.setName("description")
fieldValue94.setValue("Simple shot of Camera Zoom")
ProtoInstance93.addFieldValue(fieldValue94)
fieldValue95 = fieldValue()
fieldValue95.setName("initialPosition")
fieldValue95.setValue("-50 1 -10")
ProtoInstance93.addFieldValue(fieldValue95)
fieldValue96 = fieldValue()
fieldValue96.setName("initialOrientation")
fieldValue96.setValue("0 1 0 0")
ProtoInstance93.addFieldValue(fieldValue96)
fieldValue97 = fieldValue()
fieldValue97.setName("moves")
ProtoInstance98 = ProtoInstance()
ProtoInstance98.setName("CameraMovement")
fieldValue99 = fieldValue()
fieldValue99.setName("description")
fieldValue99.setValue("Camera Zoom In")
ProtoInstance98.addFieldValue(fieldValue99)
fieldValue100 = fieldValue()
fieldValue100.setName("duration")
fieldValue100.setValue("3")
ProtoInstance98.addFieldValue(fieldValue100)
fieldValue101 = fieldValue()
fieldValue101.setName("goalPosition")
fieldValue101.setValue("-50 1 -15")
ProtoInstance98.addFieldValue(fieldValue101)
fieldValue102 = fieldValue()
fieldValue102.setName("goalOrientation")
fieldValue102.setValue("0 1 0 0")
ProtoInstance98.addFieldValue(fieldValue102)
fieldValue97.addChildren(ProtoInstance98)
ProtoInstance103 = ProtoInstance()
ProtoInstance103.setName("CameraMovement")
fieldValue104 = fieldValue()
fieldValue104.setName("description")
fieldValue104.setValue("Camera Zoom Out")
ProtoInstance103.addFieldValue(fieldValue104)
fieldValue105 = fieldValue()
fieldValue105.setName("duration")
fieldValue105.setValue("3")
ProtoInstance103.addFieldValue(fieldValue105)
fieldValue106 = fieldValue()
fieldValue106.setName("goalPosition")
fieldValue106.setValue("-50 1 -10")
ProtoInstance103.addFieldValue(fieldValue106)
fieldValue107 = fieldValue()
fieldValue107.setName("goalOrientation")
fieldValue107.setValue("0 1 0 0")
ProtoInstance103.addFieldValue(fieldValue107)
fieldValue97.addChildren(ProtoInstance103)
ProtoInstance108 = ProtoInstance()
ProtoInstance108.setName("CameraMovement")
fieldValue109 = fieldValue()
fieldValue109.setName("description")
fieldValue109.setValue("Camera Pause")
ProtoInstance108.addFieldValue(fieldValue109)
fieldValue110 = fieldValue()
fieldValue110.setName("duration")
fieldValue110.setValue("1")
ProtoInstance108.addFieldValue(fieldValue110)
fieldValue111 = fieldValue()
fieldValue111.setName("goalPosition")
fieldValue111.setValue("-50 1 -10")
ProtoInstance108.addFieldValue(fieldValue111)
fieldValue112 = fieldValue()
fieldValue112.setName("goalOrientation")
fieldValue112.setValue("0 1 0 0")
ProtoInstance108.addFieldValue(fieldValue112)
fieldValue97.addChildren(ProtoInstance108)
ProtoInstance93.addFieldValue(fieldValue97)
fieldValue92.addChildren(ProtoInstance93)
ProtoInstance113 = ProtoInstance()
ProtoInstance113.setDEF("Dolly")
ProtoInstance113.setName("CameraShot")
fieldValue114 = fieldValue()
fieldValue114.setName("description")
fieldValue114.setValue("Simple shot of Camera Dolly")
ProtoInstance113.addFieldValue(fieldValue114)
fieldValue115 = fieldValue()
fieldValue115.setName("initialPosition")
fieldValue115.setValue("-40 1 -10")
ProtoInstance113.addFieldValue(fieldValue115)
fieldValue116 = fieldValue()
fieldValue116.setName("initialOrientation")
fieldValue116.setValue("0 1 0 0")
ProtoInstance113.addFieldValue(fieldValue116)
fieldValue117 = fieldValue()
fieldValue117.setName("moves")
ProtoInstance118 = ProtoInstance()
ProtoInstance118.setDEF("DollyMove1")
ProtoInstance118.setName("CameraMovement")
fieldValue119 = fieldValue()
fieldValue119.setName("description")
fieldValue119.setValue("Camera Dolly from Right to Left")
ProtoInstance118.addFieldValue(fieldValue119)
fieldValue120 = fieldValue()
fieldValue120.setName("duration")
fieldValue120.setValue("3")
ProtoInstance118.addFieldValue(fieldValue120)
fieldValue121 = fieldValue()
fieldValue121.setName("goalPosition")
fieldValue121.setValue("-45 1 -10")
ProtoInstance118.addFieldValue(fieldValue121)
fieldValue122 = fieldValue()
fieldValue122.setName("goalOrientation")
fieldValue122.setValue("0 1 0 0")
ProtoInstance118.addFieldValue(fieldValue122)
fieldValue117.addChildren(ProtoInstance118)
ProtoInstance123 = ProtoInstance()
ProtoInstance123.setName("CameraMovement")
fieldValue124 = fieldValue()
fieldValue124.setName("description")
fieldValue124.setValue("Camera Dolly from Left to Right")
ProtoInstance123.addFieldValue(fieldValue124)
fieldValue125 = fieldValue()
fieldValue125.setName("duration")
fieldValue125.setValue("3")
ProtoInstance123.addFieldValue(fieldValue125)
fieldValue126 = fieldValue()
fieldValue126.setName("goalPosition")
fieldValue126.setValue("-40 1 -10")
ProtoInstance123.addFieldValue(fieldValue126)
fieldValue127 = fieldValue()
fieldValue127.setName("goalOrientation")
fieldValue127.setValue("0 1 0 0")
ProtoInstance123.addFieldValue(fieldValue127)
fieldValue117.addChildren(ProtoInstance123)
ProtoInstance128 = ProtoInstance()
ProtoInstance128.setName("CameraMovement")
fieldValue129 = fieldValue()
fieldValue129.setName("description")
fieldValue129.setValue("Camera Pause")
ProtoInstance128.addFieldValue(fieldValue129)
fieldValue130 = fieldValue()
fieldValue130.setName("duration")
fieldValue130.setValue("1")
ProtoInstance128.addFieldValue(fieldValue130)
fieldValue131 = fieldValue()
fieldValue131.setName("goalPosition")
fieldValue131.setValue("-40 1 -10")
ProtoInstance128.addFieldValue(fieldValue131)
fieldValue132 = fieldValue()
fieldValue132.setName("goalOrientation")
fieldValue132.setValue("0 1 0 0")
ProtoInstance128.addFieldValue(fieldValue132)
fieldValue117.addChildren(ProtoInstance128)
ProtoInstance113.addFieldValue(fieldValue117)
fieldValue92.addChildren(ProtoInstance113)
ProtoInstance133 = ProtoInstance()
ProtoInstance133.setDEF("Pan")
ProtoInstance133.setName("CameraShot")
fieldValue134 = fieldValue()
fieldValue134.setName("description")
fieldValue134.setValue("Simple shot of Camera Pan left right and back to center")
ProtoInstance133.addFieldValue(fieldValue134)
fieldValue135 = fieldValue()
fieldValue135.setName("initialPosition")
fieldValue135.setValue("-30 1 -10")
ProtoInstance133.addFieldValue(fieldValue135)
fieldValue136 = fieldValue()
fieldValue136.setName("initialOrientation")
fieldValue136.setValue("0 1 0 0")
ProtoInstance133.addFieldValue(fieldValue136)
fieldValue137 = fieldValue()
fieldValue137.setName("moves")
ProtoInstance138 = ProtoInstance()
ProtoInstance138.setDEF("PanLeft")
ProtoInstance138.setName("CameraMovement")
fieldValue139 = fieldValue()
fieldValue139.setName("description")
fieldValue139.setValue("Pan Left")
ProtoInstance138.addFieldValue(fieldValue139)
fieldValue140 = fieldValue()
fieldValue140.setName("duration")
fieldValue140.setValue("2")
ProtoInstance138.addFieldValue(fieldValue140)
fieldValue141 = fieldValue()
fieldValue141.setName("goalPosition")
fieldValue141.setValue("-30 1 -10")
ProtoInstance138.addFieldValue(fieldValue141)
fieldValue142 = fieldValue()
fieldValue142.setName("goalOrientation")
fieldValue142.setValue("0 1 0 0.4")
ProtoInstance138.addFieldValue(fieldValue142)
fieldValue137.addChildren(ProtoInstance138)
ProtoInstance143 = ProtoInstance()
ProtoInstance143.setDEF("PanRight")
ProtoInstance143.setName("CameraMovement")
fieldValue144 = fieldValue()
fieldValue144.setName("description")
fieldValue144.setValue("Pan Right")
ProtoInstance143.addFieldValue(fieldValue144)
fieldValue145 = fieldValue()
fieldValue145.setName("duration")
fieldValue145.setValue("3")
ProtoInstance143.addFieldValue(fieldValue145)
fieldValue146 = fieldValue()
fieldValue146.setName("goalPosition")
fieldValue146.setValue("-30 1 -10")
ProtoInstance143.addFieldValue(fieldValue146)
fieldValue147 = fieldValue()
fieldValue147.setName("goalOrientation")
fieldValue147.setValue("0 1 0 -0.4")
ProtoInstance143.addFieldValue(fieldValue147)
fieldValue137.addChildren(ProtoInstance143)
ProtoInstance148 = ProtoInstance()
ProtoInstance148.setName("CameraMovement")
fieldValue149 = fieldValue()
fieldValue149.setName("description")
fieldValue149.setValue("Camera Pan back to Center")
ProtoInstance148.addFieldValue(fieldValue149)
fieldValue150 = fieldValue()
fieldValue150.setName("duration")
fieldValue150.setValue("2")
ProtoInstance148.addFieldValue(fieldValue150)
fieldValue151 = fieldValue()
fieldValue151.setName("goalPosition")
fieldValue151.setValue("-30 1 -10")
ProtoInstance148.addFieldValue(fieldValue151)
fieldValue152 = fieldValue()
fieldValue152.setName("goalOrientation")
fieldValue152.setValue("0 1 0 0")
ProtoInstance148.addFieldValue(fieldValue152)
fieldValue137.addChildren(ProtoInstance148)
ProtoInstance153 = ProtoInstance()
ProtoInstance153.setName("CameraMovement")
fieldValue154 = fieldValue()
fieldValue154.setName("description")
fieldValue154.setValue("Camera Pause")
ProtoInstance153.addFieldValue(fieldValue154)
fieldValue155 = fieldValue()
fieldValue155.setName("duration")
fieldValue155.setValue("2")
ProtoInstance153.addFieldValue(fieldValue155)
fieldValue156 = fieldValue()
fieldValue156.setName("goalPosition")
fieldValue156.setValue("-30 1 -10")
ProtoInstance153.addFieldValue(fieldValue156)
fieldValue157 = fieldValue()
fieldValue157.setName("goalOrientation")
fieldValue157.setValue("0 1 0 0")
ProtoInstance153.addFieldValue(fieldValue157)
fieldValue137.addChildren(ProtoInstance153)
ProtoInstance133.addFieldValue(fieldValue137)
fieldValue92.addChildren(ProtoInstance133)
ProtoInstance158 = ProtoInstance()
ProtoInstance158.setDEF("CameraBoom")
ProtoInstance158.setName("CameraShot")
fieldValue159 = fieldValue()
fieldValue159.setName("description")
fieldValue159.setValue("Camera Boom")
ProtoInstance158.addFieldValue(fieldValue159)
fieldValue160 = fieldValue()
fieldValue160.setName("initialPosition")
fieldValue160.setValue("-20 1 -10")
ProtoInstance158.addFieldValue(fieldValue160)
fieldValue161 = fieldValue()
fieldValue161.setName("initialOrientation")
fieldValue161.setValue("0 1 0 0")
ProtoInstance158.addFieldValue(fieldValue161)
fieldValue162 = fieldValue()
fieldValue162.setName("moves")
ProtoInstance163 = ProtoInstance()
ProtoInstance163.setDEF("CameraBoomUp")
ProtoInstance163.setName("CameraMovement")
fieldValue164 = fieldValue()
fieldValue164.setName("description")
fieldValue164.setValue("Camera Boom Up")
ProtoInstance163.addFieldValue(fieldValue164)
fieldValue165 = fieldValue()
fieldValue165.setName("duration")
fieldValue165.setValue("3")
ProtoInstance163.addFieldValue(fieldValue165)
fieldValue166 = fieldValue()
fieldValue166.setName("goalPosition")
fieldValue166.setValue("-20 5 -10")
ProtoInstance163.addFieldValue(fieldValue166)
fieldValue167 = fieldValue()
fieldValue167.setName("goalOrientation")
fieldValue167.setValue("0 1 0 0")
ProtoInstance163.addFieldValue(fieldValue167)
fieldValue162.addChildren(ProtoInstance163)
ProtoInstance168 = ProtoInstance()
ProtoInstance168.setDEF("BoomDown")
ProtoInstance168.setName("CameraMovement")
fieldValue169 = fieldValue()
fieldValue169.setName("description")
fieldValue169.setValue("Camera Boom Down")
ProtoInstance168.addFieldValue(fieldValue169)
fieldValue170 = fieldValue()
fieldValue170.setName("duration")
fieldValue170.setValue("3")
ProtoInstance168.addFieldValue(fieldValue170)
fieldValue171 = fieldValue()
fieldValue171.setName("goalPosition")
fieldValue171.setValue("-20 1 -10")
ProtoInstance168.addFieldValue(fieldValue171)
fieldValue172 = fieldValue()
fieldValue172.setName("goalOrientation")
fieldValue172.setValue("0 1 0 0")
ProtoInstance168.addFieldValue(fieldValue172)
fieldValue162.addChildren(ProtoInstance168)
ProtoInstance173 = ProtoInstance()
ProtoInstance173.setDEF("BoomPause")
ProtoInstance173.setName("CameraMovement")
fieldValue174 = fieldValue()
fieldValue174.setName("description")
fieldValue174.setValue("Camera Pause")
ProtoInstance173.addFieldValue(fieldValue174)
fieldValue175 = fieldValue()
fieldValue175.setName("duration")
fieldValue175.setValue("2")
ProtoInstance173.addFieldValue(fieldValue175)
fieldValue176 = fieldValue()
fieldValue176.setName("goalPosition")
fieldValue176.setValue("-20 1 -10")
ProtoInstance173.addFieldValue(fieldValue176)
fieldValue177 = fieldValue()
fieldValue177.setName("goalOrientation")
fieldValue177.setValue("0 1 0 0")
ProtoInstance173.addFieldValue(fieldValue177)
fieldValue162.addChildren(ProtoInstance173)
ProtoInstance158.addFieldValue(fieldValue162)
fieldValue92.addChildren(ProtoInstance158)
ProtoInstance178 = ProtoInstance()
ProtoInstance178.setDEF("CameraTilt")
ProtoInstance178.setName("CameraShot")
fieldValue179 = fieldValue()
fieldValue179.setName("description")
fieldValue179.setValue("Camera Tilt")
ProtoInstance178.addFieldValue(fieldValue179)
fieldValue180 = fieldValue()
fieldValue180.setName("initialPosition")
fieldValue180.setValue("-10 1 -10")
ProtoInstance178.addFieldValue(fieldValue180)
fieldValue181 = fieldValue()
fieldValue181.setName("initialOrientation")
fieldValue181.setValue("0 0 1 0")
ProtoInstance178.addFieldValue(fieldValue181)
fieldValue182 = fieldValue()
fieldValue182.setName("traceEnabled")
fieldValue182.setValue("true")
ProtoInstance178.addFieldValue(fieldValue182)
fieldValue183 = fieldValue()
fieldValue183.setName("moves")
ProtoInstance184 = ProtoInstance()
ProtoInstance184.setName("CameraMovement")
fieldValue185 = fieldValue()
fieldValue185.setName("description")
fieldValue185.setValue("Camera Tilt Pause")
ProtoInstance184.addFieldValue(fieldValue185)
fieldValue186 = fieldValue()
fieldValue186.setName("duration")
fieldValue186.setValue("1")
ProtoInstance184.addFieldValue(fieldValue186)
fieldValue187 = fieldValue()
fieldValue187.setName("goalPosition")
fieldValue187.setValue("-10 1 -10")
ProtoInstance184.addFieldValue(fieldValue187)
fieldValue188 = fieldValue()
fieldValue188.setName("goalOrientation")
fieldValue188.setValue("0 0 1 0")
ProtoInstance184.addFieldValue(fieldValue188)
fieldValue183.addChildren(ProtoInstance184)
ProtoInstance189 = ProtoInstance()
ProtoInstance189.setDEF("TiltDown")
ProtoInstance189.setName("CameraMovement")
fieldValue190 = fieldValue()
fieldValue190.setName("description")
fieldValue190.setValue("Camera Tilt Left")
ProtoInstance189.addFieldValue(fieldValue190)
fieldValue191 = fieldValue()
fieldValue191.setName("duration")
fieldValue191.setValue("3")
ProtoInstance189.addFieldValue(fieldValue191)
fieldValue192 = fieldValue()
fieldValue192.setName("goalPosition")
fieldValue192.setValue("-10 1 -10")
ProtoInstance189.addFieldValue(fieldValue192)
fieldValue193 = fieldValue()
fieldValue193.setName("goalOrientation")
fieldValue193.setValue("0 0 1 0.785")
ProtoInstance189.addFieldValue(fieldValue193)
fieldValue183.addChildren(ProtoInstance189)
ProtoInstance194 = ProtoInstance()
ProtoInstance194.setDEF("TiltPause")
ProtoInstance194.setName("CameraMovement")
fieldValue195 = fieldValue()
fieldValue195.setName("description")
fieldValue195.setValue("Camera Tilt Pause")
ProtoInstance194.addFieldValue(fieldValue195)
fieldValue196 = fieldValue()
fieldValue196.setName("duration")
fieldValue196.setValue("1")
ProtoInstance194.addFieldValue(fieldValue196)
fieldValue197 = fieldValue()
fieldValue197.setName("goalPosition")
fieldValue197.setValue("-10 1 -10")
ProtoInstance194.addFieldValue(fieldValue197)
fieldValue198 = fieldValue()
fieldValue198.setName("goalOrientation")
fieldValue198.setValue("0 0 1 0.785")
ProtoInstance194.addFieldValue(fieldValue198)
fieldValue183.addChildren(ProtoInstance194)
ProtoInstance199 = ProtoInstance()
ProtoInstance199.setName("CameraMovement")
fieldValue200 = fieldValue()
fieldValue200.setName("description")
fieldValue200.setValue("Camera Tilt Right")
ProtoInstance199.addFieldValue(fieldValue200)
fieldValue201 = fieldValue()
fieldValue201.setName("duration")
fieldValue201.setValue("3")
ProtoInstance199.addFieldValue(fieldValue201)
fieldValue202 = fieldValue()
fieldValue202.setName("goalPosition")
fieldValue202.setValue("-10 1 -10")
ProtoInstance199.addFieldValue(fieldValue202)
fieldValue203 = fieldValue()
fieldValue203.setName("goalOrientation")
fieldValue203.setValue("0 0 1 -0.785")
ProtoInstance199.addFieldValue(fieldValue203)
fieldValue183.addChildren(ProtoInstance199)
ProtoInstance204 = ProtoInstance()
ProtoInstance204.setName("CameraMovement")
fieldValue205 = fieldValue()
fieldValue205.setName("description")
fieldValue205.setValue("Camera Tilt Pause")
ProtoInstance204.addFieldValue(fieldValue205)
fieldValue206 = fieldValue()
fieldValue206.setName("duration")
fieldValue206.setValue("1")
ProtoInstance204.addFieldValue(fieldValue206)
fieldValue207 = fieldValue()
fieldValue207.setName("goalPosition")
fieldValue207.setValue("-10 1 -10")
ProtoInstance204.addFieldValue(fieldValue207)
fieldValue208 = fieldValue()
fieldValue208.setName("goalOrientation")
fieldValue208.setValue("0 0 1 -0.785")
ProtoInstance204.addFieldValue(fieldValue208)
fieldValue183.addChildren(ProtoInstance204)
ProtoInstance209 = ProtoInstance()
ProtoInstance209.setDEF("TiltReset")
ProtoInstance209.setName("CameraMovement")
fieldValue210 = fieldValue()
fieldValue210.setName("description")
fieldValue210.setValue("Camera Tilt Reset")
ProtoInstance209.addFieldValue(fieldValue210)
fieldValue211 = fieldValue()
fieldValue211.setName("duration")
fieldValue211.setValue("1")
ProtoInstance209.addFieldValue(fieldValue211)
fieldValue212 = fieldValue()
fieldValue212.setName("goalPosition")
fieldValue212.setValue("-10 1 -10")
ProtoInstance209.addFieldValue(fieldValue212)
fieldValue213 = fieldValue()
fieldValue213.setName("goalOrientation")
fieldValue213.setValue("0 0 1 0")
ProtoInstance209.addFieldValue(fieldValue213)
fieldValue183.addChildren(ProtoInstance209)
ProtoInstance214 = ProtoInstance()
ProtoInstance214.setDEF("TiltUp")
ProtoInstance214.setName("CameraMovement")
fieldValue215 = fieldValue()
fieldValue215.setName("description")
fieldValue215.setValue("Return to home")
ProtoInstance214.addFieldValue(fieldValue215)
fieldValue216 = fieldValue()
fieldValue216.setName("duration")
fieldValue216.setValue("2")
ProtoInstance214.addFieldValue(fieldValue216)
fieldValue217 = fieldValue()
fieldValue217.setName("goalPosition")
fieldValue217.setValue("0 2 12")
ProtoInstance214.addFieldValue(fieldValue217)
fieldValue218 = fieldValue()
fieldValue218.setName("goalOrientation")
fieldValue218.setValue("0 0 1 0")
ProtoInstance214.addFieldValue(fieldValue218)
fieldValue183.addChildren(ProtoInstance214)
ProtoInstance178.addFieldValue(fieldValue183)
fieldValue92.addChildren(ProtoInstance178)
ProtoInstance88.addFieldValue(fieldValue92)
Scene21.addChildren(ProtoInstance88)
Group219 = Group()
Group219.setDEF("AnimationGroup.SimpleShots")
TimeSensor220 = TimeSensor()
TimeSensor220.setDEF("CameraTimer.SimpleShots")
Group219.addChildren(TimeSensor220)
# initialize clock to match totalDuration of combined Shot Moves 
ROUTE221 = ROUTE()
ROUTE221.setFromField("totalDuration")
ROUTE221.setFromNode("Camera.SimpleShotsTest")
ROUTE221.setToField("cycleInterval")
ROUTE221.setToNode("CameraTimer.SimpleShots")
Group219.addChildren(ROUTE221)
# TimeSensor animates the CameraClock since that maintains the computed PositionInterpolator and OrientationInterpolator 
ROUTE222 = ROUTE()
ROUTE222.setFromField("fraction_changed")
ROUTE222.setFromNode("CameraTimer.SimpleShots")
ROUTE222.setToField("set_fraction")
ROUTE222.setToNode("Camera.SimpleShotsTest")
Group219.addChildren(ROUTE222)
Transform223 = Transform()
Transform223.setDEF("Trigger.SimpleShots")
Transform223.setTranslation([-4,4,0])
BooleanFilter224 = BooleanFilter()
BooleanFilter224.setDEF("TextTouchActive.SimpleShotsFilter")
Transform223.addChildren(BooleanFilter224)
TouchSensor225 = TouchSensor()
TouchSensor225.setDEF("TextTouch.SimpleShots")
TouchSensor225.setDescription("touch to animate Camera SimpleShotsTest")
Transform223.addChildren(TouchSensor225)
ROUTE226 = ROUTE()
ROUTE226.setFromField("inputTrue")
ROUTE226.setFromNode("TextTouchActive.SimpleShotsFilter")
ROUTE226.setToField("set_bind")
ROUTE226.setToNode("Camera.SimpleShotsTest")
Transform223.addChildren(ROUTE226)
ROUTE227 = ROUTE()
ROUTE227.setFromField("isActive")
ROUTE227.setFromNode("TextTouch.SimpleShots")
ROUTE227.setToField("set_boolean")
ROUTE227.setToNode("TextTouchActive.SimpleShotsFilter")
Transform223.addChildren(ROUTE227)
ROUTE228 = ROUTE()
ROUTE228.setFromField("touchTime")
ROUTE228.setFromNode("TextTouch.SimpleShots")
ROUTE228.setToField("startTime")
ROUTE228.setToNode("CameraTimer.SimpleShots")
Transform223.addChildren(ROUTE228)
Shape229 = Shape()
Text230 = Text()
Text230.setString(["Click to animate","SimpleShotsTest"])
FontStyle231 = FontStyle(justify = ["MIDDLE","MIDDLE"])
Text230.setFontStyle(FontStyle231)
Shape229.setGeometry(Text230)
Appearance232 = Appearance()
Material233 = Material()
Material233.setDEF("ArtDeco5")
Material233.setAmbientIntensity(0.24)
Material233.setDiffuseColor([0.945455,0.318988,0.321717])
Material233.setShininess(0.01)
Material233.setSpecularColor([0.072727,0.021705,0.010732])
# Universal Media Library: ArtDeco 5 
Appearance232.setMaterial(Material233)
Shape229.setAppearance(Appearance232)
Transform223.addChildren(Shape229)
# Simplify intersection test for user selecting text 
Shape234 = Shape()
Shape234.setDEF("TransparentBox")
Appearance235 = Appearance()
Material236 = Material()
Material236.setTransparency(1)
Appearance235.setMaterial(Material236)
Shape234.setAppearance(Appearance235)
Box237 = Box(size = [6,2,0.0001])
Shape234.setGeometry(Box237)
Transform223.addChildren(Shape234)
Group219.addChildren(Transform223)
Scene21.addChildren(Group219)
Group238 = Group()
Group238.setDEF("SimpleShotsTargets")
Transform239 = Transform()
Transform239.setDEF("TargetBoxZoom")
Transform239.setTranslation([-50,1,-20])
Shape240 = Shape()
Box241 = Box()
Shape240.setGeometry(Box241)
Appearance242 = Appearance()
Material243 = Material()
Appearance242.setMaterial(Material243)
ImageTexture244 = ImageTexture()
ImageTexture244.setUrl(["images/CameraMoveZoom.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveZoom.png"])
Appearance242.setTexture(ImageTexture244)
Shape240.setAppearance(Appearance242)
Transform239.addChildren(Shape240)
Transform245 = Transform()
Transform245.setTranslation([0,2,0])
Shape246 = Shape()
Text247 = Text()
Text247.setString(["Zoom in, out"])
FontStyle248 = FontStyle(justify = ["MIDDLE","MIDDLE"])
Text247.setFontStyle(FontStyle248)
Shape246.setGeometry(Text247)
Appearance249 = Appearance()
Material250 = Material()
Appearance249.setMaterial(Material250)
Shape246.setAppearance(Appearance249)
Transform245.addChildren(Shape246)
Transform239.addChildren(Transform245)
Group238.addChildren(Transform239)
Transform251 = Transform()
Transform251.setDEF("TargetBoxDolly")
Transform251.setTranslation([-40,1,-20])
Shape252 = Shape()
Box253 = Box()
Shape252.setGeometry(Box253)
Appearance254 = Appearance()
Material255 = Material()
Appearance254.setMaterial(Material255)
ImageTexture256 = ImageTexture()
ImageTexture256.setUrl(["images/CameraMoveDolly.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveDolly.png"])
Appearance254.setTexture(ImageTexture256)
Shape252.setAppearance(Appearance254)
Transform251.addChildren(Shape252)
Transform257 = Transform()
Transform257.setTranslation([0,2,0])
Shape258 = Shape()
Text259 = Text()
Text259.setString(["Dolly left, right"])
FontStyle260 = FontStyle(justify = ["MIDDLE","MIDDLE"])
Text259.setFontStyle(FontStyle260)
Shape258.setGeometry(Text259)
Appearance261 = Appearance()
Material262 = Material()
Appearance261.setMaterial(Material262)
Shape258.setAppearance(Appearance261)
Transform257.addChildren(Shape258)
Transform251.addChildren(Transform257)
Group238.addChildren(Transform251)
Transform263 = Transform()
Transform263.setDEF("TargetBoxPan")
Transform263.setTranslation([-30,1,-20])
Shape264 = Shape()
Box265 = Box()
Shape264.setGeometry(Box265)
Appearance266 = Appearance()
Material267 = Material()
Appearance266.setMaterial(Material267)
ImageTexture268 = ImageTexture()
ImageTexture268.setUrl(["images/CameraMovePan.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMovePan.png"])
Appearance266.setTexture(ImageTexture268)
Shape264.setAppearance(Appearance266)
Transform263.addChildren(Shape264)
Transform269 = Transform()
Transform269.setTranslation([0,2,0])
Shape270 = Shape()
Text271 = Text()
Text271.setString(["Pan left, right"])
FontStyle272 = FontStyle(justify = ["MIDDLE","MIDDLE"])
Text271.setFontStyle(FontStyle272)
Shape270.setGeometry(Text271)
Appearance273 = Appearance()
Material274 = Material()
Appearance273.setMaterial(Material274)
Shape270.setAppearance(Appearance273)
Transform269.addChildren(Shape270)
Transform263.addChildren(Transform269)
Group238.addChildren(Transform263)
Transform275 = Transform()
Transform275.setDEF("TargetBoxBoom")
Transform275.setTranslation([-20,1,-20])
Shape276 = Shape()
Box277 = Box()
Shape276.setGeometry(Box277)
Appearance278 = Appearance()
Material279 = Material()
Appearance278.setMaterial(Material279)
ImageTexture280 = ImageTexture()
ImageTexture280.setUrl(["images/CameraMoveBoom.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveBoom.png"])
Appearance278.setTexture(ImageTexture280)
Shape276.setAppearance(Appearance278)
Transform275.addChildren(Shape276)
Transform281 = Transform()
Transform281.setTranslation([0,2,0])
Shape282 = Shape()
Text283 = Text()
Text283.setString(["Boom up, down"])
FontStyle284 = FontStyle(justify = ["MIDDLE","MIDDLE"])
Text283.setFontStyle(FontStyle284)
Shape282.setGeometry(Text283)
Appearance285 = Appearance()
Material286 = Material()
Appearance285.setMaterial(Material286)
Shape282.setAppearance(Appearance285)
Transform281.addChildren(Shape282)
Transform275.addChildren(Transform281)
Group238.addChildren(Transform275)
Transform287 = Transform()
Transform287.setDEF("TargetBoxTilt")
Transform287.setTranslation([-10,1,-20])
Shape288 = Shape()
Box289 = Box()
Shape288.setGeometry(Box289)
Appearance290 = Appearance()
Material291 = Material()
Appearance290.setMaterial(Material291)
ImageTexture292 = ImageTexture()
ImageTexture292.setUrl(["images/CameraMoveTilt.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveTilt.png"])
Appearance290.setTexture(ImageTexture292)
Shape288.setAppearance(Appearance290)
Transform287.addChildren(Shape288)
Transform293 = Transform()
Transform293.setTranslation([0,2,0])
Shape294 = Shape()
Text295 = Text()
Text295.setString(["Tilt left, right"])
FontStyle296 = FontStyle(justify = ["MIDDLE","MIDDLE"])
Text295.setFontStyle(FontStyle296)
Shape294.setGeometry(Text295)
Appearance297 = Appearance()
Material298 = Material()
Appearance297.setMaterial(Material298)
Shape294.setAppearance(Appearance297)
Transform293.addChildren(Shape294)
Transform287.addChildren(Transform293)
Group238.addChildren(Transform287)
Scene21.addChildren(Group238)
# =============== Camera.AimPointTest ============== 
ProtoInstance299 = ProtoInstance()
ProtoInstance299.setDEF("Camera.AimPointTest")
ProtoInstance299.setName("Camera")
fieldValue300 = fieldValue()
fieldValue300.setName("description")
fieldValue300.setValue("AimPointTest for moving camera tracking moving target")
ProtoInstance299.addFieldValue(fieldValue300)
fieldValue301 = fieldValue()
fieldValue301.setName("position")
fieldValue301.setValue("4 4 10")
ProtoInstance299.addFieldValue(fieldValue301)
fieldValue302 = fieldValue()
fieldValue302.setName("shots")
ProtoInstance303 = ProtoInstance()
ProtoInstance303.setDEF("Shot5")
ProtoInstance303.setName("CameraShot")
fieldValue304 = fieldValue()
fieldValue304.setName("description")
fieldValue304.setValue("#3 Tracking shot")
ProtoInstance303.addFieldValue(fieldValue304)
fieldValue305 = fieldValue()
fieldValue305.setName("initialPosition")
fieldValue305.setValue("6 6 10")
ProtoInstance303.addFieldValue(fieldValue305)
fieldValue306 = fieldValue()
fieldValue306.setName("initialOrientation")
fieldValue306.setValue("0 1 0 0")
ProtoInstance303.addFieldValue(fieldValue306)
fieldValue307 = fieldValue()
fieldValue307.setName("moves")
ProtoInstance308 = ProtoInstance()
ProtoInstance308.setDEF("MoveAimPoint3.1")
ProtoInstance308.setName("CameraMovement")
fieldValue309 = fieldValue()
fieldValue309.setName("description")
fieldValue309.setValue("AimPoint 3.1 moving BoxPath")
ProtoInstance308.addFieldValue(fieldValue309)
fieldValue310 = fieldValue()
fieldValue310.setName("tracking")
fieldValue310.setValue("true")
ProtoInstance308.addFieldValue(fieldValue310)
fieldValue311 = fieldValue()
fieldValue311.setName("duration")
fieldValue311.setValue("8")
ProtoInstance308.addFieldValue(fieldValue311)
fieldValue312 = fieldValue()
fieldValue312.setName("goalPosition")
fieldValue312.setValue("6 6 10")
ProtoInstance308.addFieldValue(fieldValue312)
# goalAimPoint modified by ROUTE to match moving Box 
fieldValue307.addChildren(ProtoInstance308)
ProtoInstance313 = ProtoInstance()
ProtoInstance313.setDEF("MoveAimPoint3.2")
ProtoInstance313.setName("CameraMovement")
fieldValue314 = fieldValue()
fieldValue314.setName("description")
fieldValue314.setValue("AimPoint 3.2 pan right while tracking")
ProtoInstance313.addFieldValue(fieldValue314)
fieldValue315 = fieldValue()
fieldValue315.setName("tracking")
fieldValue315.setValue("true")
ProtoInstance313.addFieldValue(fieldValue315)
fieldValue316 = fieldValue()
fieldValue316.setName("duration")
fieldValue316.setValue("8")
ProtoInstance313.addFieldValue(fieldValue316)
fieldValue317 = fieldValue()
fieldValue317.setName("goalPosition")
fieldValue317.setValue("40 6 12")
ProtoInstance313.addFieldValue(fieldValue317)
# goalAimPoint modified by ROUTE to match moving Box 
fieldValue307.addChildren(ProtoInstance313)
ProtoInstance318 = ProtoInstance()
ProtoInstance318.setDEF("MoveAimPoint3.3")
ProtoInstance318.setName("CameraMovement")
fieldValue319 = fieldValue()
fieldValue319.setName("description")
fieldValue319.setValue("AimPoint 3.3 boom up while tracking")
ProtoInstance318.addFieldValue(fieldValue319)
fieldValue320 = fieldValue()
fieldValue320.setName("tracking")
fieldValue320.setValue("true")
ProtoInstance318.addFieldValue(fieldValue320)
fieldValue321 = fieldValue()
fieldValue321.setName("duration")
fieldValue321.setValue("3")
ProtoInstance318.addFieldValue(fieldValue321)
fieldValue322 = fieldValue()
fieldValue322.setName("goalPosition")
fieldValue322.setValue("40 20 13")
ProtoInstance318.addFieldValue(fieldValue322)
# goalAimPoint modified by ROUTE to match moving Box 
fieldValue307.addChildren(ProtoInstance318)
ProtoInstance323 = ProtoInstance()
ProtoInstance323.setDEF("MoveAimPoint3.4")
ProtoInstance323.setName("CameraMovement")
fieldValue324 = fieldValue()
fieldValue324.setName("description")
fieldValue324.setValue("AimPoint 3.4 restore camera back to home")
ProtoInstance323.addFieldValue(fieldValue324)
# can test tracking or not using following values 
fieldValue325 = fieldValue()
fieldValue325.setName("tracking")
fieldValue325.setValue("true")
ProtoInstance323.addFieldValue(fieldValue325)
fieldValue326 = fieldValue()
fieldValue326.setName("duration")
fieldValue326.setValue("5")
ProtoInstance323.addFieldValue(fieldValue326)
fieldValue327 = fieldValue()
fieldValue327.setName("goalPosition")
fieldValue327.setValue("4 4 10")
ProtoInstance323.addFieldValue(fieldValue327)
fieldValue328 = fieldValue()
fieldValue328.setName("goalAimPoint")
fieldValue328.setValue("4 4 0")
ProtoInstance323.addFieldValue(fieldValue328)
fieldValue329 = fieldValue()
fieldValue329.setName("goalOrientation")
fieldValue329.setValue("0 1 0 0")
ProtoInstance323.addFieldValue(fieldValue329)
fieldValue307.addChildren(ProtoInstance323)
ProtoInstance303.addFieldValue(fieldValue307)
fieldValue302.addChildren(ProtoInstance303)
ProtoInstance299.addFieldValue(fieldValue302)
Scene21.addChildren(ProtoInstance299)
Group330 = Group()
Group330.setDEF("AnimationGroup.AimPointTest")
TimeSensor331 = TimeSensor()
TimeSensor331.setDEF("CameraTimer.AimPointTest")
Group330.addChildren(TimeSensor331)
# initialize clock to match totalDuration of combined Shot Moves 
ROUTE332 = ROUTE()
ROUTE332.setFromField("totalDuration")
ROUTE332.setFromNode("Camera.AimPointTest")
ROUTE332.setToField("cycleInterval")
ROUTE332.setToNode("CameraTimer.AimPointTest")
Group330.addChildren(ROUTE332)
# TimeSensor animates the CameraClock since that maintains the computed PositionInterpolator and OrientationInterpolator 
ROUTE333 = ROUTE()
ROUTE333.setFromField("fraction_changed")
ROUTE333.setFromNode("CameraTimer.AimPointTest")
ROUTE333.setToField("set_fraction")
ROUTE333.setToNode("Camera.AimPointTest")
Group330.addChildren(ROUTE333)
Transform334 = Transform()
Transform334.setDEF("Trigger.AimPointTest")
Transform334.setTranslation([4,4,0])
BooleanFilter335 = BooleanFilter()
BooleanFilter335.setDEF("TextTouchActive.AimPointFilter")
Transform334.addChildren(BooleanFilter335)
TouchSensor336 = TouchSensor()
TouchSensor336.setDEF("TextTouch.AimPointTest")
TouchSensor336.setDescription("touch to animate Camera AimPointTest")
Transform334.addChildren(TouchSensor336)
ROUTE337 = ROUTE()
ROUTE337.setFromField("inputTrue")
ROUTE337.setFromNode("TextTouchActive.AimPointFilter")
ROUTE337.setToField("set_bind")
ROUTE337.setToNode("Camera.AimPointTest")
Transform334.addChildren(ROUTE337)
ROUTE338 = ROUTE()
ROUTE338.setFromField("isActive")
ROUTE338.setFromNode("TextTouch.AimPointTest")
ROUTE338.setToField("set_boolean")
ROUTE338.setToNode("TextTouchActive.AimPointFilter")
Transform334.addChildren(ROUTE338)
ROUTE339 = ROUTE()
ROUTE339.setFromField("touchTime")
ROUTE339.setFromNode("TextTouch.AimPointTest")
ROUTE339.setToField("startTime")
ROUTE339.setToNode("CameraTimer.AimPointTest")
Transform334.addChildren(ROUTE339)
Shape340 = Shape()
Text341 = Text()
Text341.setString(["Click to animate","AimPointTest"])
FontStyle342 = FontStyle(justify = ["MIDDLE","MIDDLE"])
Text341.setFontStyle(FontStyle342)
Shape340.setGeometry(Text341)
Appearance343 = Appearance()
Material344 = Material()
Material344.setUSE("ArtDeco5")
Appearance343.setMaterial(Material344)
Shape340.setAppearance(Appearance343)
Transform334.addChildren(Shape340)
Shape345 = Shape()
Shape345.setUSE("TransparentBox")
Transform334.addChildren(Shape345)
Group330.addChildren(Transform334)
Scene21.addChildren(Group330)
# TODO build a test once implemented 
ProtoInstance346 = ProtoInstance()
ProtoInstance346.setName("OfflineRender")
Scene21.addChildren(ProtoInstance346)
# =============== animate a camera shape to visualize view changes ============== 
Transform347 = Transform()
Transform347.setDEF("CameraShapeTransform")
Transform347.setTranslation([0,0.5,0])
# move CameraShape using active Camera 
ROUTE348 = ROUTE()
ROUTE348.setFromField("position_changed")
ROUTE348.setFromNode("Camera.SimpleShotsTest")
ROUTE348.setToField("translation")
ROUTE348.setToNode("CameraShapeTransform")
Transform347.addChildren(ROUTE348)
ROUTE349 = ROUTE()
ROUTE349.setFromField("orientation_changed")
ROUTE349.setFromNode("Camera.SimpleShotsTest")
ROUTE349.setToField("rotation")
ROUTE349.setToNode("CameraShapeTransform")
Transform347.addChildren(ROUTE349)
ROUTE350 = ROUTE()
ROUTE350.setFromField("position")
ROUTE350.setFromNode("Camera.AimPointTest")
ROUTE350.setToField("translation")
ROUTE350.setToNode("CameraShapeTransform")
Transform347.addChildren(ROUTE350)
ROUTE351 = ROUTE()
ROUTE351.setFromField("orientation_changed")
ROUTE351.setFromNode("Camera.AimPointTest")
ROUTE351.setToField("rotation")
ROUTE351.setToNode("CameraShapeTransform")
Transform347.addChildren(ROUTE351)
Transform352 = Transform()
Transform352.setDEF("CameraOffsetTransform")
Transform352.setTranslation([0,0,0.25])
TouchSensor353 = TouchSensor()
TouchSensor353.setDEF("CameraShapeTouched")
Transform352.addChildren(TouchSensor353)
Inline354 = Inline()
Inline354.setDEF("CameraShape")
Inline354.setUrl(["CameraShape.x3d","http://www.web3d.org/x3d/content/examples/Basic/development/CameraShape.x3d"])
Transform352.addChildren(Inline354)
Shape355 = Shape()
Shape355.setDEF("SightLine")
IndexedLineSet356 = IndexedLineSet(coordIndex = [0,1])
Coordinate357 = Coordinate()
Coordinate357.setPoint([0,0,0,0,0,-100])
IndexedLineSet356.setCoord(Coordinate357)
Shape355.setGeometry(IndexedLineSet356)
Appearance358 = Appearance()
Material359 = Material()
Material359.setEmissiveColor([0.8,0.8,0.4])
Appearance358.setMaterial(Material359)
Shape355.setAppearance(Appearance358)
Transform352.addChildren(Shape355)
Transform347.addChildren(Transform352)
# Display frustum to show camera view within the scene, toggled by user selecting CameraShape 
ExternProtoDeclare360 = ExternProtoDeclare()
ExternProtoDeclare360.setAppinfo("Display view frustum associated with a given pair of Viewpoint NavigationInfo nodes")
ExternProtoDeclare360.setName("ViewFrustum")
ExternProtoDeclare360.setUrl(["../../X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.x3d#ViewFrustum","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.x3d#ViewFrustum","../../X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.wrl#ViewFrustum","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.wrl#ViewFrustum"])
field361 = field()
field361.setAccessType("initializeOnly")
field361.setAppinfo("required: insert Viewpoint DEF or USE node for view of interest")
field361.setName("ViewpointNode")
field361.setType("SFNode")
ExternProtoDeclare360.addField(field361)
field362 = field()
field362.setAccessType("initializeOnly")
field362.setAppinfo("required: insert NavigationInfo DEF or USE node of interest")
field362.setName("NavigationInfoNode")
field362.setType("SFNode")
ExternProtoDeclare360.addField(field362)
field363 = field()
field363.setAccessType("inputOutput")
field363.setAppinfo("whether or not frustum geometry is rendered")
field363.setName("visible")
field363.setType("SFBool")
ExternProtoDeclare360.addField(field363)
field364 = field()
field364.setAccessType("inputOutput")
field364.setAppinfo("RGB color of ViewFrustum outline, default value 0.9 0.9 0.9")
field364.setName("lineColor")
field364.setType("SFColor")
ExternProtoDeclare360.addField(field364)
field365 = field()
field365.setAccessType("inputOutput")
field365.setAppinfo("RGB color of ViewFrustum hull geometry, default value 0.8 0.8 0.8")
field365.setName("frustumColor")
field365.setType("SFColor")
ExternProtoDeclare360.addField(field365)
field366 = field()
field366.setAccessType("inputOutput")
field366.setAppinfo("transparency of ViewFrustum hull geometry, default value 0.5")
field366.setName("transparency")
field366.setType("SFFloat")
ExternProtoDeclare360.addField(field366)
field367 = field()
field367.setAccessType("inputOutput")
field367.setAppinfo("assumed ratio height/width, default value 0.75")
field367.setName("aspectRatio")
field367.setType("SFFloat")
ExternProtoDeclare360.addField(field367)
field368 = field()
field368.setAccessType("initializeOnly")
field368.setAppinfo("debug support, default false")
field368.setName("trace")
field368.setType("SFBool")
ExternProtoDeclare360.addField(field368)
Transform347.addChildren(ExternProtoDeclare360)
ProtoInstance369 = ProtoInstance()
ProtoInstance369.setDEF("ViewFrustumNode")
ProtoInstance369.setName("ViewFrustum")
fieldValue370 = fieldValue()
fieldValue370.setName("ViewpointNode")
Viewpoint371 = Viewpoint()
Viewpoint371.setDEF("FrustumViewpoint")
Viewpoint371.setDescription("viewpoint for ViewFrustum")
Viewpoint371.setPosition([0,0,0])
fieldValue370.addChildren(Viewpoint371)
ProtoInstance369.addFieldValue(fieldValue370)
fieldValue372 = fieldValue()
fieldValue372.setName("NavigationInfoNode")
NavigationInfo373 = NavigationInfo()
NavigationInfo373.setDEF("TestNavigationInfo")
NavigationInfo373.setTransitionType(["ANIMATE"])
NavigationInfo373.setVisibilityLimit(100)
fieldValue372.addChildren(NavigationInfo373)
ProtoInstance369.addFieldValue(fieldValue372)
fieldValue374 = fieldValue()
fieldValue374.setName("visible")
fieldValue374.setValue("false")
ProtoInstance369.addFieldValue(fieldValue374)
fieldValue375 = fieldValue()
fieldValue375.setName("lineColor")
fieldValue375.setValue("0.9 0.9 0.9")
ProtoInstance369.addFieldValue(fieldValue375)
fieldValue376 = fieldValue()
fieldValue376.setName("frustumColor")
fieldValue376.setValue("0.8 0.8 0.8")
ProtoInstance369.addFieldValue(fieldValue376)
fieldValue377 = fieldValue()
fieldValue377.setName("transparency")
fieldValue377.setValue("0.95")
ProtoInstance369.addFieldValue(fieldValue377)
Transform347.addChildren(ProtoInstance369)
BooleanToggle378 = BooleanToggle()
BooleanToggle378.setDEF("ViewFrustumToggle")
Transform347.addChildren(BooleanToggle378)
ROUTE379 = ROUTE()
ROUTE379.setFromField("isActive")
ROUTE379.setFromNode("CameraShapeTouched")
ROUTE379.setToField("set_boolean")
ROUTE379.setToNode("ViewFrustumToggle")
Transform347.addChildren(ROUTE379)
ROUTE380 = ROUTE()
ROUTE380.setFromField("toggle")
ROUTE380.setFromNode("ViewFrustumToggle")
ROUTE380.setToField("set_visible")
ROUTE380.setToNode("ViewFrustumNode")
Transform347.addChildren(ROUTE380)
Scene21.addChildren(Transform347)
# =============== add checkerboard, axes and other things to look at while animating ============== 
Background381 = Background()
Background381.setSkyColor([0.282353,0.380392,0.470588])
Scene21.addChildren(Background381)
Transform382 = Transform()
Transform382.setRotation([1,0,0,-1.57079])
Transform382.setScale([10,10,10])
Shape383 = Shape()
Appearance384 = Appearance()
Material385 = Material()
Material385.setAmbientIntensity(0.01)
Material385.setDiffuseColor([1.0,1.0,1.0])
Material385.setShininess(0.05)
Appearance384.setMaterial(Material385)
Shape383.setAppearance(Appearance384)
IndexedFaceSet386 = IndexedFaceSet(colorIndex = [0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0], colorPerVertex = False, coordIndex = [0,8,9,1,-1,1,9,10,2,-1,2,10,11,3,-1,3,11,12,4,-1,4,12,13,5,-1,5,13,14,6,-1,6,14,15,7,-1,8,16,17,9,-1,9,17,18,10,-1,10,18,19,11,-1,11,19,20,12,-1,12,20,21,13,-1,13,21,22,14,-1,14,22,23,15,-1,16,24,25,17,-1,17,25,26,18,-1,18,26,27,19,-1,19,27,28,20,-1,20,28,29,21,-1,21,29,30,22,-1,22,30,31,23,-1,24,32,33,25,-1,25,33,34,26,-1,26,34,35,27,-1,27,35,36,28,-1,28,36,37,29,-1,29,37,38,30,-1,30,38,39,31,-1,32,40,41,33,-1,33,41,42,34,-1,34,42,43,35,-1,35,43,44,36,-1,36,44,45,37,-1,37,45,46,38,-1,38,46,47,39,-1,40,48,49,41,-1,41,49,50,42,-1,42,50,51,43,-1,43,51,52,44,-1,44,52,53,45,-1,45,53,54,46,-1,46,54,55,47,-1,48,56,57,49,-1,49,57,58,50,-1,50,58,59,51,-1,51,59,60,52,-1,52,60,61,53,-1,53,61,62,54,-1,54,62,63,55,-1], normalPerVertex = False, solid = False)
Coordinate387 = Coordinate()
Coordinate387.setPoint([-5.25,5.25,0.0,-3.75,5.25,0.0,-2.25,5.25,0.0,-0.75,5.25,0.0,0.75,5.25,0.0,2.25,5.25,0.0,3.75,5.25,0.0,5.25,5.25,0.0,-5.25,3.75,0.0,-3.75,3.75,0.0,-2.25,3.75,0.0,-0.75,3.75,0.0,0.75,3.75,0.0,2.25,3.75,0.0,3.75,3.75,0.0,5.25,3.75,0.0,-5.25,2.25,0.0,-3.75,2.25,0.0,-2.25,2.25,0.0,-0.75,2.25,0.0,0.75,2.25,0.0,2.25,2.25,0.0,3.75,2.25,0.0,5.25,2.25,0.0,-5.25,0.75,0.0,-3.75,0.75,0.0,-2.25,0.75,0.0,-0.75,0.75,0.0,0.75,0.75,0.0,2.25,0.75,0.0,3.75,0.75,0.0,5.25,0.75,0.0,-5.25,-0.75,0.0,-3.75,-0.75,0.0,-2.25,-0.75,0.0,-0.75,-0.75,0.0,0.75,-0.75,0.0,2.25,-0.75,0.0,3.75,-0.75,0.0,5.25,-0.75,0.0,-5.25,-2.25,0.0,-3.75,-2.25,0.0,-2.25,-2.25,0.0,-0.75,-2.25,0.0,0.75,-2.25,0.0,2.25,-2.25,0.0,3.75,-2.25,0.0,5.25,-2.25,0.0,-5.25,-3.75,0.0,-3.75,-3.75,0.0,-2.25,-3.75,0.0,-0.75,-3.75,0.0,0.75,-3.75,0.0,2.25,-3.75,0.0,3.75,-3.75,0.0,5.25,-3.75,0.0,-5.25,-5.25,0.0,-3.75,-5.25,0.0,-2.25,-5.25,0.0,-0.75,-5.25,0.0,0.75,-5.25,0.0,2.25,-5.25,0.0,3.75,-5.25,0.0,5.25,-5.25,0.0])
IndexedFaceSet386.setCoord(Coordinate387)
Color388 = Color()
Color388.setColor([0.435294,0.741176,0,0,0.560784,0.580392])
IndexedFaceSet386.setColor(Color388)
Shape383.setGeometry(IndexedFaceSet386)
Transform382.addChildren(Shape383)
Scene21.addChildren(Transform382)
Transform389 = Transform()
Transform389.setScale([3,3,3])
Transform389.setTranslation([0,0.25,0])
Inline390 = Inline()
Inline390.setDEF("CoordinateAxes")
Inline390.setUrl(["../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","../../Savage/Tools/Authoring/CoordinateAxes.x3d","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.x3d","../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","../../Savage/Tools/Authoring/CoordinateAxes.wrl","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.wrl"])
Transform389.addChildren(Inline390)
Scene21.addChildren(Transform389)
Transform391 = Transform()
Transform391.setDEF("MovingBoxTransform")
PositionInterpolator392 = PositionInterpolator()
PositionInterpolator392.setDEF("BoxPath")
PositionInterpolator392.setKey([0,0.25,0.5,0.75,1])
PositionInterpolator392.setKeyValue([-5,1,5,45,1,5,45,1,-45,-5,1,-45,-5,1,5])
Transform391.addChildren(PositionInterpolator392)
TimeSensor393 = TimeSensor()
TimeSensor393.setDEF("BoxTimer")
TimeSensor393.setCycleInterval(10)
TimeSensor393.setLoop(True)
Transform391.addChildren(TimeSensor393)
ROUTE394 = ROUTE()
ROUTE394.setFromField("value_changed")
ROUTE394.setFromNode("BoxPath")
ROUTE394.setToField("translation")
ROUTE394.setToNode("MovingBoxTransform")
Transform391.addChildren(ROUTE394)
ROUTE395 = ROUTE()
ROUTE395.setFromField("value_changed")
ROUTE395.setFromNode("BoxPath")
ROUTE395.setToField("goalAimPoint")
ROUTE395.setToNode("MoveAimPoint3.1")
Transform391.addChildren(ROUTE395)
ROUTE396 = ROUTE()
ROUTE396.setFromField("value_changed")
ROUTE396.setFromNode("BoxPath")
ROUTE396.setToField("goalAimPoint")
ROUTE396.setToNode("MoveAimPoint3.2")
Transform391.addChildren(ROUTE396)
ROUTE397 = ROUTE()
ROUTE397.setFromField("value_changed")
ROUTE397.setFromNode("BoxPath")
ROUTE397.setToField("goalAimPoint")
ROUTE397.setToNode("MoveAimPoint3.3")
Transform391.addChildren(ROUTE397)
ROUTE398 = ROUTE()
ROUTE398.setFromField("fraction_changed")
ROUTE398.setFromNode("BoxTimer")
ROUTE398.setToField("set_fraction")
ROUTE398.setToNode("BoxPath")
Transform391.addChildren(ROUTE398)
Shape399 = Shape()
Box400 = Box()
Shape399.setGeometry(Box400)
Appearance401 = Appearance()
Material402 = Material()
Appearance401.setMaterial(Material402)
ImageTexture403 = ImageTexture()
ImageTexture403.setUrl(["../earth-topo.png","http://www.web3d.org/x3d/content/examples/Basic/earth-topo.png"])
Appearance401.setTexture(ImageTexture403)
Shape399.setAppearance(Appearance401)
Transform391.addChildren(Shape399)
Scene21.addChildren(Transform391)
# ================ CrossHair visualization for center of screen ================ 
ExternProtoDeclare404 = ExternProtoDeclare()
ExternProtoDeclare404.setAppinfo("CrossHair prototype provides a heads-up display (HUD) crosshair at the view center, which is useful for assessing NavigationInfo lookAt point")
ExternProtoDeclare404.setName("CrossHair")
ExternProtoDeclare404.setUrl(["../../Savage/Tools/HeadsUpDisplays/CrossHairPrototype.x3d#CrossHair","https://savage.nps.edu/Savage/Tools/HeadsUpDisplays/CrossHairPrototype.x3d#CrossHair","../../Savage/Tools/HeadsUpDisplays/CrossHairPrototype.wrl#CrossHair","https://savage.nps.edu/Savage/Tools/HeadsUpDisplays/CrossHairPrototype.wrl#CrossHair"])
field405 = field()
field405.setAccessType("initializeOnly")
field405.setAppinfo("whether CrissHair orititype is enabled or not")
field405.setName("enabled")
field405.setType("SFBool")
ExternProtoDeclare404.addField(field405)
field406 = field()
field406.setAccessType("inputOnly")
field406.setAppinfo("control whether enabled/disabled")
field406.setName("set_enabled")
field406.setType("SFBool")
ExternProtoDeclare404.addField(field406)
field407 = field()
field407.setAccessType("inputOutput")
field407.setAppinfo("color of CrossHair marker")
field407.setName("markerColor")
field407.setType("SFColor")
ExternProtoDeclare404.addField(field407)
field408 = field()
field408.setAccessType("inputOutput")
field408.setAppinfo("size of CrossHair in meters")
field408.setName("scale")
field408.setType("SFVec3f")
ExternProtoDeclare404.addField(field408)
field409 = field()
field409.setAccessType("inputOutput")
field409.setAppinfo("distance in front of HUD viewpoint")
field409.setName("positionOffsetFromCamera")
field409.setType("SFVec3f")
ExternProtoDeclare404.addField(field409)
Scene21.addChildren(ExternProtoDeclare404)
ProtoInstance410 = ProtoInstance()
ProtoInstance410.setDEF("CrossHairInstance")
ProtoInstance410.setName("CrossHair")
fieldValue411 = fieldValue()
fieldValue411.setName("enabled")
fieldValue411.setValue("true")
ProtoInstance410.addFieldValue(fieldValue411)
fieldValue412 = fieldValue()
fieldValue412.setName("markerColor")
fieldValue412.setValue("1 0.5 0")
ProtoInstance410.addFieldValue(fieldValue412)
fieldValue413 = fieldValue()
fieldValue413.setName("scale")
fieldValue413.setValue("1 1 1")
ProtoInstance410.addFieldValue(fieldValue413)
fieldValue414 = fieldValue()
fieldValue414.setName("positionOffsetFromCamera")
fieldValue414.setValue("0 0 -6")
ProtoInstance410.addFieldValue(fieldValue414)
Scene21.addChildren(ProtoInstance410)
# turn on CrossHairInstance when animated camera viewpoints are bound 
ROUTE415 = ROUTE()
ROUTE415.setFromField("isBound")
ROUTE415.setFromNode("Camera.SimpleShotsTest")
ROUTE415.setToField("set_enabled")
ROUTE415.setToNode("CrossHairInstance")
Scene21.addChildren(ROUTE415)
ROUTE416 = ROUTE()
ROUTE416.setFromField("isBound")
ROUTE416.setFromNode("Camera.AimPointTest")
ROUTE416.setToField("set_enabled")
ROUTE416.setToNode("CrossHairInstance")
Scene21.addChildren(ROUTE416)
# turn off CrossHairInstance when animated camera viewpoints are unbound <BooleanFilter DEF='NegateCrossHair'/> <ROUTE fromField='isBound' fromNode='Camera.SimpleShotsTest' toField='set_boolean' toNode='NegateCrossHair'/> <ROUTE fromField='isBound' fromNode='Camera.AimPointTest' toField='set_boolean' toNode='NegateCrossHair'/> <ROUTE fromField='inputNegate' fromNode='NegateCrossHair' toField='set_enabled' toNode='CrossHairInstance'/> 
# =============== TODO Launch Prototype Example ============== 
Anchor417 = Anchor()
Anchor417.setDescription("launch CameraExample scene")
Anchor417.setParameter(["target=_blank"])
Anchor417.setUrl(["CameraExample.x3d","http://www.web3d.org/x3d/content/examples/Basic/development/CameraExample.x3d","CameraExample.wrl","http://www.web3d.org/x3d/content/examples/Basic/development/CameraExample.wrl"])
Transform418 = Transform()
Transform418.setTranslation([0,-3,0])
Shape419 = Shape()
Text420 = Text()
Text420.setString(["CameraPrototype","defines a prototype","","Click on this text to see","CameraExample scene"])
FontStyle421 = FontStyle(justify = ["MIDDLE","MIDDLE"], size = 0.5)
Text420.setFontStyle(FontStyle421)
Shape419.setGeometry(Text420)
Appearance422 = Appearance()
Material423 = Material()
Material423.setDiffuseColor([1,1,0.2])
Appearance422.setMaterial(Material423)
Shape419.setAppearance(Appearance422)
Transform418.addChildren(Shape419)
Anchor417.addChildren(Transform418)
Scene21.addChildren(Anchor417)
X3D0.setScene(Scene21)
