/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.VolumeRendering;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Shape.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing3D.*;

/**
 * All fields fully supported except shadows supported with at least Phong shading at level 3. All fields fully supported with at least Phong shading and Henyey-Greenstein phase function, shadows fully supported at level 4.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>ShadedVolumeStyle node tooltip</i>: (X3D version 3.3 or later) [X3DComposableVolumeRenderStyleNode] ShadedVolumeStyle applies Blinn-Phong illumination model to volume rendering.
 * <ul>
 *  <li> <i>Hint:</i> ShadedVolumeStyle can contain a single Texture3D node with containerField='surfaceNormals' and a single Material node. </li> 
 *  <li> <i>Warning:</i>  requires X3D profile='Full' or else include &amp;lt;component name='VolumeRendering' level='3'/&amp;gt; or level='4' to include shadows. </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#ShadedVolumeStyle" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/volume.html#ShadedVolumeStyle" target="blank">X3D Abstract Specification: ShadedVolumeStyle</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#ShadedVolumeStyle" target="_blank">X3D Tooltips: ShadedVolumeStyle</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Volume" target="_blank">X3D Scene Authoring Hints: Volume</a>
 */
public interface ShadedVolumeStyle extends  org.web3d.x3d.sai.VolumeRendering.X3DComposableVolumeRenderStyleNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=ShadedVolumeStyle, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link ShadedVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShadedVolumeStyle setEnabled(boolean newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>lighting</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether rendering calculates and applies shading effects to visual output.  * <br>

	 * @return value of lighting field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=ShadedVolumeStyle, $CamelCaseName=Lighting, $memberObjectName=lighting, $memberObjectName=lighting)
	public boolean getLighting();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>lighting</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether rendering calculates and applies shading effects to visual output.  * <br>

	 * @param newValue is new value for the lighting field.
	 * @return {@link ShadedVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ShadedVolumeStyle setLighting(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Shape.X3DMaterialNode instance (using a properly typed node) from inputOutput SFNode field <i>material</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMaterialNode] Colour and opacity is determined based on whether a value has been specified for the material field.  * <br>

	 * @return value of material field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=ShadedVolumeStyle, $CamelCaseName=Material, $memberObjectName=material, $memberObjectName=material)
	public  org.web3d.x3d.sai.Shape.X3DMaterialNode getMaterial(); // acceptable node types #1: X3DMaterialNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.X3DMaterialNode instance (using a properly typed node) to inputOutput SFNode field <i>material</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMaterialNode] Colour and opacity is determined based on whether a value has been specified for the material field.  * <br>

	 * @param newValue is new value for the material field.
	 * @return {@link ShadedVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ShadedVolumeStyle setMaterial( org.web3d.x3d.sai.Shape.X3DMaterialNode newValue); // acceptable node types #2: X3DMaterialNode

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=ShadedVolumeStyle, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link ShadedVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShadedVolumeStyle setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide String enumeration value (baseType SFString) ["Henyey-Greenstein" | "NONE" | 'etc.'] from initializeOnly SFString field named <i>phaseFunction</i>.
	 * <br><br>
	 * <i>Tooltip:</i> define scattering model for implementations using global illumination (NONE or Henyey-Greenstein phase function).#10;
 * <ul>
 *  <li> <i>Warning:</i>  do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. </li> 
 * </ul>
	 * @return value of phaseFunction field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=ShadedVolumeStyle, $CamelCaseName=PhaseFunction, $memberObjectName=phaseFunction, $memberObjectName=phaseFunction)
	public String getPhaseFunction();

	/**
	 * Accessor method to assign String enumeration value ("Henyey-Greenstein" | "NONE") to initializeOnly SFString field named <i>phaseFunction</i>.
	 * <br><br>
	 * <i>Tooltip:</i> define scattering model for implementations using global illumination (NONE or Henyey-Greenstein phase function).#10;
 * <ul>
 *  <li> <i>Warning:</i>  do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. </li> 
 * </ul>
	 * @param newValue is new value for the phaseFunction field.
	 * @return {@link ShadedVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ShadedVolumeStyle setPhaseFunction(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>shadows</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether rendering calculates and applies shadows to visual output (using global illumination model).  * <br>

	 * @return value of shadows field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=ShadedVolumeStyle, $CamelCaseName=Shadows, $memberObjectName=shadows, $memberObjectName=shadows)
	public boolean getShadows();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>shadows</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether rendering calculates and applies shadows to visual output (using global illumination model).  * <br>

	 * @param newValue is new value for the shadows field.
	 * @return {@link ShadedVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ShadedVolumeStyle setShadows(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode instance (using a properly typed node) from inputOutput SFNode field <i>surfaceNormals</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTexture3DNode] The surfaceNormals field contains a 3D texture with at least three component values. Each voxel in the texture represents the surface normal direction for the corresponding voxel in the base data source.  * <br>

	 * @return value of surfaceNormals field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=ShadedVolumeStyle, $CamelCaseName=SurfaceNormals, $memberObjectName=surfaceNormals, $memberObjectName=surfaceNormals)
	public  org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode getSurfaceNormals(); // acceptable node types #1: X3DTexture3DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode instance (using a properly typed node) to inputOutput SFNode field <i>surfaceNormals</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTexture3DNode] The surfaceNormals field contains a 3D texture with at least three component values. Each voxel in the texture represents the surface normal direction for the corresponding voxel in the base data source.  * <br>

	 * @param newValue is new value for the surfaceNormals field.
	 * @return {@link ShadedVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ShadedVolumeStyle setSurfaceNormals( org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode newValue); // acceptable node types #2: X3DTexture3DNode

}
