/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.RigidBodyPhysics;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.RigidBodyPhysics.*;
// import org.web3d.x3d.sai.RigidBodyPhysics.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * BallJoint represents an unconstrained joint between two bodies that pivot about a common anchor point.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>BallJoint node tooltip</i>: (X3D version 3.2 or later) [X3DRigidJointNode] BallJoint represents an unconstrained joint between two bodies that pivot about a common anchor point. Contains two RigidBody nodes (containerField values body1, body2).
 * <ul>
 *  <li> <i> Hint:</i>  RigidBodyPhysics component, level 2. </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#BallJoint" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/rigidBodyPhysics.html#BallJoint" target="blank">X3D Abstract Specification: BallJoint</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#BallJoint" target="_blank">X3D Tooltips: BallJoint</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface BallJoint extends  org.web3d.x3d.sai.RigidBodyPhysics.X3DRigidJointNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>anchorPoint</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  anchorPoint is joint center, specified in world coordinates.  * <br>

	 * @return value of anchorPoint field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DRigidJointNode, $additionalInheritanceBaseType=, $thisClassName=BallJoint, $CamelCaseName=AnchorPoint, $memberObjectName=anchorPoint, $memberObjectName=anchorPoint)
	public float[] getAnchorPoint();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>anchorPoint</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  anchorPoint is joint center, specified in world coordinates.  * <br>

	 * @param newValue is new value for the anchorPoint field.
	 * @return {@link BallJoint} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BallJoint setAnchorPoint(float[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.RigidBodyPhysics.RigidBody instance (using a properly typed node) from inputOutput SFNode field <i>body1</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [RigidBody] The body1 and body2 fields indicate the two RigidBody nodes connected by this joint.  * <br>

	 * @return value of body1 field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DRigidJointNode, $additionalInheritanceBaseType=, $thisClassName=BallJoint, $CamelCaseName=Body1, $memberObjectName=body1, $memberObjectName=body1)

	public  org.web3d.x3d.sai.RigidBodyPhysics.RigidBody getBody1(); // acceptable node types #1: RigidBody

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.RigidBodyPhysics.RigidBody instance (using a properly typed node) to inputOutput SFNode field <i>body1</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [RigidBody] The body1 and body2 fields indicate the two RigidBody nodes connected by this joint.  * <br>

	 * @param newValue is new value for the body1 field.
	 * @return {@link BallJoint} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BallJoint setBody1( org.web3d.x3d.sai.RigidBodyPhysics.RigidBody newValue); // acceptable node types #2: RigidBody

	/**
	 * Provide array of 3-tuple float results from outputOnly SFVec3f field named <i>body1AnchorPoint</i>.
	 * <br><br>
	 * <i>Tooltip:</i> body1AnchorPoint describes anchorPoint position relative to local coordinate reference frame.
 * <ul>
 *  <li> <i>Hint:</i> can detect separation if body1AnchorPoint!=body2AnchorPoint. </li> 
 *  <li> <i>Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of body1AnchorPoint field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DRigidJointNode, $additionalInheritanceBaseType=, $thisClassName=BallJoint, $CamelCaseName=Body1AnchorPoint, $memberObjectName=body1AnchorPoint, $memberObjectName=body1AnchorPoint)
	public float[] getBody1AnchorPoint();
	/**
	 * Provide  org.web3d.x3d.sai.RigidBodyPhysics.RigidBody instance (using a properly typed node) from inputOutput SFNode field <i>body2</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [RigidBody] The body1 and body2 fields indicate the two RigidBody nodes connected by this joint.  * <br>

	 * @return value of body2 field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DRigidJointNode, $additionalInheritanceBaseType=, $thisClassName=BallJoint, $CamelCaseName=Body2, $memberObjectName=body2, $memberObjectName=body2)

	public  org.web3d.x3d.sai.RigidBodyPhysics.RigidBody getBody2(); // acceptable node types #1: RigidBody

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.RigidBodyPhysics.RigidBody instance (using a properly typed node) to inputOutput SFNode field <i>body2</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [RigidBody] The body1 and body2 fields indicate the two RigidBody nodes connected by this joint.  * <br>

	 * @param newValue is new value for the body2 field.
	 * @return {@link BallJoint} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BallJoint setBody2( org.web3d.x3d.sai.RigidBodyPhysics.RigidBody newValue); // acceptable node types #2: RigidBody

	/**
	 * Provide array of 3-tuple float results from outputOnly SFVec3f field named <i>body2AnchorPoint</i>.
	 * <br><br>
	 * <i>Tooltip:</i> body2AnchorPoint describes anchorPoint position relative to local coordinate reference frame.
 * <ul>
 *  <li> <i>Hint:</i> can detect separation if body1AnchorPoint!=body2AnchorPoint. </li> 
 *  <li> <i>Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of body2AnchorPoint field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DRigidJointNode, $additionalInheritanceBaseType=, $thisClassName=BallJoint, $CamelCaseName=Body2AnchorPoint, $memberObjectName=body2AnchorPoint, $memberObjectName=body2AnchorPoint)
	public float[] getBody2AnchorPoint();
	/**
	 * Provide array of String enumeration results (baseType MFString) ['"ALL"' | '"NONE"' | '"etc."'] from inputOutput MFString field named <i>forceOutput</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  forceOutput controls which output fields are generated for the next frame. Values are ALL, NONE, or exact names of output fields updated at start of next frame.  * <br>

	 * @return value of forceOutput field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DRigidJointNode, $additionalInheritanceBaseType=, $thisClassName=BallJoint, $CamelCaseName=ForceOutput, $memberObjectName=forceOutput, $memberObjectName=forceOutput)

	public String[] getForceOutput();

	/**
	 * Accessor method to assign String enumeration array (""ALL"" | ""NONE"") to inputOutput MFString field named <i>forceOutput</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  forceOutput controls which output fields are generated for the next frame. Values are ALL, NONE, or exact names of output fields updated at start of next frame.  * <br>

	 * @param newValue is new value for the forceOutput field.
	 * @return {@link BallJoint} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BallJoint setForceOutput(String[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DRigidJointNode, $additionalInheritanceBaseType=, $thisClassName=BallJoint, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link BallJoint} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BallJoint setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

}
