/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.HAnim;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.HAnim.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.HAnim.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;

/**
 * HAnimDisplacer nodes alter the shape of coordinate-based geometry within parent HAnimJoint or HAnimSegment nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>HAnimDisplacer node tooltip</i>: [X3DGeometricPropertyNode] HAnimDisplacer nodes alter the shape of coordinate-based geometry within parent HAnimJoint or HAnimSegment nodes. Displacer effects are scaled by the corresponding weight field.
 * <ul>
 *  <li> <i>Hint:</i> HAnimDisplacer can be used in three different ways: (a) identify vertices corresponding to a particular feature in a parent HAnimSegment node, (b) represent a particular muscular action for a parent HAnimJoint node by displacing corresponding HAnimHumanoid skin vertices in various directions (linearly or radially), or (c) represent a complete configuration of coordinate vertices in parent HAnimSegment or HAnimJoint nodes. Example: in the case of a face, there might be a separate HAnimDisplacer node for each facial expression. </li> 
 *  <li> <i>Warning:</i> allowed name suffixes include _feature, _action and _config. </li> 
 *  <li> <i>Hint:</i> multiple HAnimDisplacer nodes must appear consecutively inside parent HAnimSegment for proper content validation in XML encoding. </li> 
 *  <li> <i>Warning:</i> index values for HanimHumanoid skin IndexedFaceSet, skinCoord and skinNormal nodes must all be consistently defined together with HAnimJoint HAnimSegment and HAnimDisplacer nodes for proper skin animation. </li> 
 *  <li> <i>Hint:</i> HAnim Specification <a href="https://www.web3d.org/documents/specifications/19774/V2.0" target="_blank">https://www.web3d.org/documents/specifications/19774/V2.0</a> </li> 
 *  <li> <i>Hint:</i> HAnim Specification part 1, Displacer <a href="https://www.web3d.org/documents/specifications/19774/V2.0/Architecture/ObjectInterfaces.html#Displacer" target="_blank">https://www.web3d.org/documents/specifications/19774/V2.0/Architecture/ObjectInterfaces.html#Displacer</a> </li> 
 *  <li> <i>Hint:</i> X3D for Advanced Modeling (X3D4AM) slideset <a href="https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/HumanoidAnimation.pdf" target="_blank">https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/HumanoidAnimation.pdf</a> </li> 
 *  <li> <i>Warning:</i> requires X3D profile='Full' or else include &amp;lt;component name='HAnim' level='1'/&amp;gt; </li> 
 *  <li> <i>Warning:</i>  for X3D3 HAnim1, previous spelling of component name was 'H-Anim' (including hyphen). </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/hanim.html#HAnimDisplacer" target="blank">X3D Abstract Specification: HAnimDisplacer</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#HAnimDisplacer" target="_blank">X3D Tooltips: HAnimDisplacer</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class HAnimDisplacer extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.HAnim.HAnimDisplacer
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList;

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=coordIndex, @type=MFInt32, $javaType=ArrayList<Integer>, $javaReferenceType=Integer, $javaPrimitiveType=ArrayList<Integer>, $normalizedMemberObjectName=coordIndex, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<Integer> coordIndex = new ArrayList<>(); //  X3D field type: MFInt32

    /* @name=description, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=description, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String description = new String(); //  X3D field type: SFString

    /* @name=displacements, @type=MFVec3f, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=displacements, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] displacements; //  X3D field type: MFVec3f

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=name, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=name, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String name = new String(); //  X3D field type: SFString

    /* @name=weight, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=weight, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float weight; //  X3D field type: SFFloat

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean nameWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> CAESAR 2003 skull_vertex matches ISO 7250-1 part 5.22 Vertex (top of head). No corresponding landmark provided in CAESAR 2018.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"skull_vertex"</i> (Java syntax) or <i>skull_vertex</i> (XML syntax).
	 * @see #NAME_SKULL_VERTEX_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Vertex_(anatomy)" target="_blank">https://en.wikipedia.org/wiki/Vertex_(anatomy)</a>  */
	public static final String NAME_SKULL_VERTEX = "skull_vertex";
	/** SFString xs:NMTOKEN enumeration value "<i>skull_vertex</i>" has unique index 0
	 * @see #NAME_SKULL_VERTEX */
	public static final int NAME_SKULL_VERTEX_INDEX = 0;
	/** SFString xs:NMTOKEN enumeration value "<i>skull_vertex</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_SKULL_VERTEX */
	public static final int NAME_SKULL_VERTEX_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>skull_vertex</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_SKULL_VERTEX
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_SKULL_VERTEX_PARENT = "skull";
	/** SFString xs:NMTOKEN enumeration value "<i>skull_vertex</i>" has alias  (TODO tokenize array)"<i>skull_tip,vertex</i>" */
	public static final String NAME_SKULL_VERTEX_ALIAS = "skull_tip,vertex";

	/** 
	 * <i>Tooltip:</i> glabella is between the eyebrows and above the nose.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"glabella"</i> (Java syntax) or <i>glabella</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Glabella" target="_blank">https://en.wikipedia.org/wiki/Glabella</a>  */
	public static final String NAME_GLABELLA = "glabella";
	/** SFString xs:NMTOKEN enumeration value "<i>glabella</i>" has unique index 1
	 * @see #NAME_GLABELLA */
	public static final int NAME_GLABELLA_INDEX = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>glabella</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_GLABELLA */
	public static final int NAME_GLABELLA_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>glabella</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_GLABELLA
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_GLABELLA_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> osseocartilaginous junction of the nasal dorsum.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"sellion"</i> (Java syntax) or <i>sellion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Human_head" target="_blank">https://en.wikipedia.org/wiki/Human_head</a>  */
	public static final String NAME_SELLION = "sellion";
	/** SFString xs:NMTOKEN enumeration value "<i>sellion</i>" has unique index 2
	 * @see #NAME_SELLION */
	public static final int NAME_SELLION_INDEX = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>sellion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_SELLION */
	public static final int NAME_SELLION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>sellion</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_SELLION
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_SELLION_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> Left Infraorbitale foramen is opening in maxillary bone of skull located below the infraorbital margin of the orbit.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_infraorbitale"</i> (Java syntax) or <i>l_infraorbitale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Infraorbital_foramen" target="_blank">https://en.wikipedia.org/wiki/Infraorbital_foramen</a>  */
	public static final String NAME_L_INFRAORBITALE = "l_infraorbitale";
	/** SFString xs:NMTOKEN enumeration value "<i>l_infraorbitale</i>" has unique index 3
	 * @see #NAME_L_INFRAORBITALE */
	public static final int NAME_L_INFRAORBITALE_INDEX = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>l_infraorbitale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_INFRAORBITALE */
	public static final int NAME_L_INFRAORBITALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_infraorbitale</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_L_INFRAORBITALE
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_L_INFRAORBITALE_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> notch just above the tragus of the ear.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_tragion"</i> (Java syntax) or <i>l_tragion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wiktionary.org/wiki/tragion" target="_blank">https://en.wiktionary.org/wiki/tragion</a>  */
	public static final String NAME_L_TRAGION = "l_tragion";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tragion</i>" has unique index 4
	 * @see #NAME_L_TRAGION */
	public static final int NAME_L_TRAGION_INDEX = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tragion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_TRAGION */
	public static final int NAME_L_TRAGION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tragion</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_L_TRAGION
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_L_TRAGION_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> Left Gonion is midpoint of mandibular angle of the jaw.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_gonion"</i> (Java syntax) or <i>l_gonion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Angle_of_the_mandible" target="_blank">https://en.wikipedia.org/wiki/Angle_of_the_mandible</a>  */
	public static final String NAME_L_GONION = "l_gonion";
	/** SFString xs:NMTOKEN enumeration value "<i>l_gonion</i>" has unique index 5
	 * @see #NAME_L_GONION */
	public static final int NAME_L_GONION_INDEX = 5;
	/** SFString xs:NMTOKEN enumeration value "<i>l_gonion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_GONION */
	public static final int NAME_L_GONION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_gonion</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_L_GONION
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_L_GONION_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> Right Infraorbitale foramen is opening in maxillary bone of skull located below the infraorbital margin of the orbit.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_infraorbitale"</i> (Java syntax) or <i>r_infraorbitale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Infraorbital_foramen" target="_blank">https://en.wikipedia.org/wiki/Infraorbital_foramen</a>  */
	public static final String NAME_R_INFRAORBITALE = "r_infraorbitale";
	/** SFString xs:NMTOKEN enumeration value "<i>r_infraorbitale</i>" has unique index 6
	 * @see #NAME_R_INFRAORBITALE */
	public static final int NAME_R_INFRAORBITALE_INDEX = 6;
	/** SFString xs:NMTOKEN enumeration value "<i>r_infraorbitale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_INFRAORBITALE */
	public static final int NAME_R_INFRAORBITALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_infraorbitale</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_R_INFRAORBITALE
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_R_INFRAORBITALE_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> notch just above the tragus of the ear.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_tragion"</i> (Java syntax) or <i>r_tragion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wiktionary.org/wiki/tragion" target="_blank">https://en.wiktionary.org/wiki/tragion</a>  */
	public static final String NAME_R_TRAGION = "r_tragion";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tragion</i>" has unique index 7
	 * @see #NAME_R_TRAGION */
	public static final int NAME_R_TRAGION_INDEX = 7;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tragion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_TRAGION */
	public static final int NAME_R_TRAGION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tragion</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_R_TRAGION
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_R_TRAGION_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> Right Gonion is midpoint of the mandibular angle of the jaw.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_gonion"</i> (Java syntax) or <i>r_gonion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Angle_of_the_mandible" target="_blank">https://en.wikipedia.org/wiki/Angle_of_the_mandible</a>  */
	public static final String NAME_R_GONION = "r_gonion";
	/** SFString xs:NMTOKEN enumeration value "<i>r_gonion</i>" has unique index 8
	 * @see #NAME_R_GONION */
	public static final int NAME_R_GONION_INDEX = 8;
	/** SFString xs:NMTOKEN enumeration value "<i>r_gonion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_GONION */
	public static final int NAME_R_GONION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_gonion</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_R_GONION
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_R_GONION_PARENT = "skull";

	/** 
	 * <i>Tooltip:</i> center point above tip of chin.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"supramenton"</i> (Java syntax) or <i>supramenton</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.cs.uu.nl/groups/MG/multimedia/publications/art/rsfp05.pdf" target="_blank">https://www.cs.uu.nl/groups/MG/multimedia/publications/art/rsfp05.pdf</a>  */
	public static final String NAME_SUPRAMENTON = "supramenton";
	/** SFString xs:NMTOKEN enumeration value "<i>supramenton</i>" has unique index 9
	 * @see #NAME_SUPRAMENTON */
	public static final int NAME_SUPRAMENTON_INDEX = 9;
	/** SFString xs:NMTOKEN enumeration value "<i>supramenton</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_SUPRAMENTON */
	public static final int NAME_SUPRAMENTON_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>supramenton</i>" has unique parent "<i>jaw</i>" in HAnimSegment
	 * @see #NAME_SUPRAMENTON
	 * @see HAnimSegment#NAME_JAW */
	public static final String NAME_SUPRAMENTON_PARENT = "jaw";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"cervicale"</i> (Java syntax) or <i>cervicale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.merriam-webster.com/dictionary/cervicale" target="_blank">https://www.merriam-webster.com/dictionary/cervicale</a>  */
	public static final String NAME_CERVICALE = "cervicale";
	/** SFString xs:NMTOKEN enumeration value "<i>cervicale</i>" has unique index 10
	 * @see #NAME_CERVICALE */
	public static final int NAME_CERVICALE_INDEX = 10;
	/** SFString xs:NMTOKEN enumeration value "<i>cervicale</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_CERVICALE */
	public static final int NAME_CERVICALE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>cervicale</i>" has unique parent "<i>t1</i>" in HAnimSegment
	 * @see #NAME_CERVICALE
	 * @see HAnimSegment#NAME_T1 */
	public static final String NAME_CERVICALE_PARENT = "t1";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"adams_apple"</i> (Java syntax) or <i>adams_apple</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Adam_s_apple" target="_blank">https://en.wikipedia.org/wiki/Adam_s_apple</a>  */
	public static final String NAME_ADAMS_APPLE = "adams_apple";
	/** SFString xs:NMTOKEN enumeration value "<i>adams_apple</i>" has unique index 11
	 * @see #NAME_ADAMS_APPLE */
	public static final int NAME_ADAMS_APPLE_INDEX = 11;
	/** SFString xs:NMTOKEN enumeration value "<i>adams_apple</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_ADAMS_APPLE */
	public static final int NAME_ADAMS_APPLE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>adams_apple</i>" has unique parent "<i>c2</i>" in HAnimSegment
	 * @see #NAME_ADAMS_APPLE
	 * @see HAnimSegment#NAME_C2 */
	public static final String NAME_ADAMS_APPLE_PARENT = "c2";

	/** 
	 * <i>Tooltip:</i> Suprasternale.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"suprasternale"</i> (Java syntax) or <i>suprasternale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://medical-dictionary.thefreedictionary.com/spatium+suprasternale" target="_blank">https://medical-dictionary.thefreedictionary.com/spatium+suprasternale</a>  */
	public static final String NAME_SUPRASTERNALE = "suprasternale";
	/** SFString xs:NMTOKEN enumeration value "<i>suprasternale</i>" has unique index 12
	 * @see #NAME_SUPRASTERNALE */
	public static final int NAME_SUPRASTERNALE_INDEX = 12;
	/** SFString xs:NMTOKEN enumeration value "<i>suprasternale</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_SUPRASTERNALE */
	public static final int NAME_SUPRASTERNALE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>suprasternale</i>" has unique parent "<i>t1</i>" in HAnimSegment
	 * @see #NAME_SUPRASTERNALE
	 * @see HAnimSegment#NAME_T1 */
	public static final String NAME_SUPRASTERNALE_PARENT = "t1";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"substernale"</i> (Java syntax) or <i>substernale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://medical-dictionary.thefreedictionary.com/spatium+substernale" target="_blank">https://medical-dictionary.thefreedictionary.com/spatium+substernale</a>  */
	public static final String NAME_SUBSTERNALE = "substernale";
	/** SFString xs:NMTOKEN enumeration value "<i>substernale</i>" has unique index 13
	 * @see #NAME_SUBSTERNALE */
	public static final int NAME_SUBSTERNALE_INDEX = 13;
	/** SFString xs:NMTOKEN enumeration value "<i>substernale</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_SUBSTERNALE */
	public static final int NAME_SUBSTERNALE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>substernale</i>" has unique parent "<i>t10</i>" in HAnimSegment
	 * @see #NAME_SUBSTERNALE
	 * @see HAnimSegment#NAME_T10 */
	public static final String NAME_SUBSTERNALE_PARENT = "t10";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_clavicle"</i> (Java syntax) or <i>l_clavicle</i> (XML syntax).
	 * @see #NAME_L_CLAVICLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Clavicle" target="_blank">https://en.wikipedia.org/wiki/Clavicle</a>  */
	public static final String NAME_L_CLAVICLE = "l_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_clavicle</i>" has unique index 14
	 * @see #NAME_L_CLAVICLE */
	public static final int NAME_L_CLAVICLE_INDEX = 14;
	/** SFString xs:NMTOKEN enumeration value "<i>l_clavicle</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_CLAVICLE */
	public static final int NAME_L_CLAVICLE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_clavicle</i>" has unique parent "<i>l_clavicle</i>" in HAnimSegment
	 * @see #NAME_L_CLAVICLE
	 * @see HAnimSegment#NAME_L_CLAVICLE */
	public static final String NAME_L_CLAVICLE_PARENT = "l_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_clavicle</i>" has alias "<i>l_clavicale</i>"
	 * @see #NAME_L_CLAVICLE */
	public static final String NAME_L_CLAVICLE_ALIAS = "l_clavicale";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_acromion"</i> (Java syntax) or <i>l_acromion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Acromion" target="_blank">https://en.wikipedia.org/wiki/Acromion</a>  */
	public static final String NAME_L_ACROMION = "l_acromion";
	/** SFString xs:NMTOKEN enumeration value "<i>l_acromion</i>" has unique index 15
	 * @see #NAME_L_ACROMION */
	public static final int NAME_L_ACROMION_INDEX = 15;
	/** SFString xs:NMTOKEN enumeration value "<i>l_acromion</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_ACROMION */
	public static final int NAME_L_ACROMION_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_acromion</i>" has unique parent "<i>l_clavicle</i>" in HAnimSegment
	 * @see #NAME_L_ACROMION
	 * @see HAnimSegment#NAME_L_CLAVICLE */
	public static final String NAME_L_ACROMION_PARENT = "l_clavicle";

	/** 
	 * <i>Tooltip:</i> Left Axilla Proximal (Anterior).
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_axilla_proximal"</i> (Java syntax) or <i>l_axilla_proximal</i> (XML syntax).
	 * @see #NAME_L_AXILLA_PROXIMAL_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Axilla" target="_blank">https://en.wikipedia.org/wiki/Axilla</a>  */
	public static final String NAME_L_AXILLA_PROXIMAL = "l_axilla_proximal";
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_proximal</i>" has unique index 16
	 * @see #NAME_L_AXILLA_PROXIMAL */
	public static final int NAME_L_AXILLA_PROXIMAL_INDEX = 16;
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_proximal</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_AXILLA_PROXIMAL */
	public static final int NAME_L_AXILLA_PROXIMAL_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_proximal</i>" has unique parent "<i>l_clavicle</i>" in HAnimSegment
	 * @see #NAME_L_AXILLA_PROXIMAL
	 * @see HAnimSegment#NAME_L_CLAVICLE */
	public static final String NAME_L_AXILLA_PROXIMAL_PARENT = "l_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_proximal</i>" has alias "<i>l_axilla_ant</i>"
	 * @see #NAME_L_AXILLA_PROXIMAL */
	public static final String NAME_L_AXILLA_PROXIMAL_ALIAS = "l_axilla_ant";

	/** 
	 * <i>Tooltip:</i> Left Axilla Distal (Posterior).
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_axilla_distal"</i> (Java syntax) or <i>l_axilla_distal</i> (XML syntax).
	 * @see #NAME_L_AXILLA_DISTAL_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Axilla" target="_blank">https://en.wikipedia.org/wiki/Axilla</a>  */
	public static final String NAME_L_AXILLA_DISTAL = "l_axilla_distal";
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_distal</i>" has unique index 17
	 * @see #NAME_L_AXILLA_DISTAL */
	public static final int NAME_L_AXILLA_DISTAL_INDEX = 17;
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_distal</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_AXILLA_DISTAL */
	public static final int NAME_L_AXILLA_DISTAL_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_distal</i>" has unique parent "<i>l_clavicle</i>" in HAnimSegment
	 * @see #NAME_L_AXILLA_DISTAL
	 * @see HAnimSegment#NAME_L_CLAVICLE */
	public static final String NAME_L_AXILLA_DISTAL_PARENT = "l_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_distal</i>" has alias "<i>l_axilla_post</i>"
	 * @see #NAME_L_AXILLA_DISTAL */
	public static final String NAME_L_AXILLA_DISTAL_ALIAS = "l_axilla_post";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_axilla_posterior_folds"</i> (Java syntax) or <i>l_axilla_posterior_folds</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Axilla" target="_blank">https://en.wikipedia.org/wiki/Axilla</a>  */
	public static final String NAME_L_AXILLA_POSTERIOR_FOLDS = "l_axilla_posterior_folds";
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_posterior_folds</i>" has unique index 18
	 * @see #NAME_L_AXILLA_POSTERIOR_FOLDS */
	public static final int NAME_L_AXILLA_POSTERIOR_FOLDS_INDEX = 18;
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_posterior_folds</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_AXILLA_POSTERIOR_FOLDS */
	public static final int NAME_L_AXILLA_POSTERIOR_FOLDS_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_axilla_posterior_folds</i>" has unique parent "<i>l_clavicle</i>" in HAnimSegment
	 * @see #NAME_L_AXILLA_POSTERIOR_FOLDS
	 * @see HAnimSegment#NAME_L_CLAVICLE */
	public static final String NAME_L_AXILLA_POSTERIOR_FOLDS_PARENT = "l_clavicle";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_clavicle"</i> (Java syntax) or <i>r_clavicle</i> (XML syntax).
	 * @see #NAME_R_CLAVICLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Clavicle" target="_blank">https://en.wikipedia.org/wiki/Clavicle</a>  */
	public static final String NAME_R_CLAVICLE = "r_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_clavicle</i>" has unique index 19
	 * @see #NAME_R_CLAVICLE */
	public static final int NAME_R_CLAVICLE_INDEX = 19;
	/** SFString xs:NMTOKEN enumeration value "<i>r_clavicle</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_CLAVICLE */
	public static final int NAME_R_CLAVICLE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_clavicle</i>" has unique parent "<i>r_clavicle</i>" in HAnimSegment
	 * @see #NAME_R_CLAVICLE
	 * @see HAnimSegment#NAME_R_CLAVICLE */
	public static final String NAME_R_CLAVICLE_PARENT = "r_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_clavicle</i>" has alias "<i>r_clavicale</i>"
	 * @see #NAME_R_CLAVICLE */
	public static final String NAME_R_CLAVICLE_ALIAS = "r_clavicale";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_acromion"</i> (Java syntax) or <i>r_acromion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Acromion" target="_blank">https://en.wikipedia.org/wiki/Acromion</a>  */
	public static final String NAME_R_ACROMION = "r_acromion";
	/** SFString xs:NMTOKEN enumeration value "<i>r_acromion</i>" has unique index 20
	 * @see #NAME_R_ACROMION */
	public static final int NAME_R_ACROMION_INDEX = 20;
	/** SFString xs:NMTOKEN enumeration value "<i>r_acromion</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_ACROMION */
	public static final int NAME_R_ACROMION_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_acromion</i>" has unique parent "<i>r_clavicle</i>" in HAnimSegment
	 * @see #NAME_R_ACROMION
	 * @see HAnimSegment#NAME_R_CLAVICLE */
	public static final String NAME_R_ACROMION_PARENT = "r_clavicle";

	/** 
	 * <i>Tooltip:</i> Right Axilla Proximal (Anterior).
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_axilla_proximal"</i> (Java syntax) or <i>r_axilla_proximal</i> (XML syntax).
	 * @see #NAME_R_AXILLA_PROXIMAL_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Axilla" target="_blank">https://en.wikipedia.org/wiki/Axilla</a>  */
	public static final String NAME_R_AXILLA_PROXIMAL = "r_axilla_proximal";
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_proximal</i>" has unique index 21
	 * @see #NAME_R_AXILLA_PROXIMAL */
	public static final int NAME_R_AXILLA_PROXIMAL_INDEX = 21;
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_proximal</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_AXILLA_PROXIMAL */
	public static final int NAME_R_AXILLA_PROXIMAL_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_proximal</i>" has unique parent "<i>r_clavicle</i>" in HAnimSegment
	 * @see #NAME_R_AXILLA_PROXIMAL
	 * @see HAnimSegment#NAME_R_CLAVICLE */
	public static final String NAME_R_AXILLA_PROXIMAL_PARENT = "r_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_proximal</i>" has alias "<i>r_axilla_ant</i>"
	 * @see #NAME_R_AXILLA_PROXIMAL */
	public static final String NAME_R_AXILLA_PROXIMAL_ALIAS = "r_axilla_ant";

	/** 
	 * <i>Tooltip:</i> Right Axilla Distal (Posterior).
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_axilla_distal"</i> (Java syntax) or <i>r_axilla_distal</i> (XML syntax).
	 * @see #NAME_R_AXILLA_DISTAL_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Axilla" target="_blank">https://en.wikipedia.org/wiki/Axilla</a>  */
	public static final String NAME_R_AXILLA_DISTAL = "r_axilla_distal";
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_distal</i>" has unique index 22
	 * @see #NAME_R_AXILLA_DISTAL */
	public static final int NAME_R_AXILLA_DISTAL_INDEX = 22;
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_distal</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_AXILLA_DISTAL */
	public static final int NAME_R_AXILLA_DISTAL_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_distal</i>" has unique parent "<i>r_clavicle</i>" in HAnimSegment
	 * @see #NAME_R_AXILLA_DISTAL
	 * @see HAnimSegment#NAME_R_CLAVICLE */
	public static final String NAME_R_AXILLA_DISTAL_PARENT = "r_clavicle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_distal</i>" has alias "<i>r_axilla_post</i>"
	 * @see #NAME_R_AXILLA_DISTAL */
	public static final String NAME_R_AXILLA_DISTAL_ALIAS = "r_axilla_post";

	/** 
	 * <i>Tooltip:</i> Right Posterior Axillary Folds.
	 * SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_axilla_posterior_folds"</i> (Java syntax) or <i>r_axilla_posterior_folds</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Axilla" target="_blank">https://en.wikipedia.org/wiki/Axilla</a>  */
	public static final String NAME_R_AXILLA_POSTERIOR_FOLDS = "r_axilla_posterior_folds";
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_posterior_folds</i>" has unique index 23
	 * @see #NAME_R_AXILLA_POSTERIOR_FOLDS */
	public static final int NAME_R_AXILLA_POSTERIOR_FOLDS_INDEX = 23;
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_posterior_folds</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_AXILLA_POSTERIOR_FOLDS */
	public static final int NAME_R_AXILLA_POSTERIOR_FOLDS_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_axilla_posterior_folds</i>" has unique parent "<i>r_clavicle</i>" in HAnimSegment
	 * @see #NAME_R_AXILLA_POSTERIOR_FOLDS
	 * @see HAnimSegment#NAME_R_CLAVICLE */
	public static final String NAME_R_AXILLA_POSTERIOR_FOLDS_PARENT = "r_clavicle";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"spine_1_middle_back"</i> (Java syntax) or <i>spine_1_middle_back</i> (XML syntax).
	 * @see #NAME_SPINE_1_MIDDLE_BACK_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Vertebral_column" target="_blank">https://en.wikipedia.org/wiki/Vertebral_column</a>  */
	public static final String NAME_SPINE_1_MIDDLE_BACK = "spine_1_middle_back";
	/** SFString xs:NMTOKEN enumeration value "<i>spine_1_middle_back</i>" has unique index 24
	 * @see #NAME_SPINE_1_MIDDLE_BACK */
	public static final int NAME_SPINE_1_MIDDLE_BACK_INDEX = 24;
	/** SFString xs:NMTOKEN enumeration value "<i>spine_1_middle_back</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_SPINE_1_MIDDLE_BACK */
	public static final int NAME_SPINE_1_MIDDLE_BACK_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>spine_1_middle_back</i>" has unique parent "<i>t5</i>" in HAnimSegment
	 * @see #NAME_SPINE_1_MIDDLE_BACK
	 * @see HAnimSegment#NAME_T5 */
	public static final String NAME_SPINE_1_MIDDLE_BACK_PARENT = "t5";
	/** SFString xs:NMTOKEN enumeration value "<i>spine_1_middle_back</i>" has alias "<i>middle back</i>"
	 * @see #NAME_SPINE_1_MIDDLE_BACK */
	public static final String NAME_SPINE_1_MIDDLE_BACK_ALIAS = "middle back";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"spine_2_lower_back"</i> (Java syntax) or <i>spine_2_lower_back</i> (XML syntax).
	 * @see #NAME_SPINE_2_LOWER_BACK_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Vertebral_column" target="_blank">https://en.wikipedia.org/wiki/Vertebral_column</a>  */
	public static final String NAME_SPINE_2_LOWER_BACK = "spine_2_lower_back";
	/** SFString xs:NMTOKEN enumeration value "<i>spine_2_lower_back</i>" has unique index 25
	 * @see #NAME_SPINE_2_LOWER_BACK */
	public static final int NAME_SPINE_2_LOWER_BACK_INDEX = 25;
	/** SFString xs:NMTOKEN enumeration value "<i>spine_2_lower_back</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_SPINE_2_LOWER_BACK */
	public static final int NAME_SPINE_2_LOWER_BACK_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>spine_2_lower_back</i>" has unique parent "<i>l2</i>" in HAnimSegment
	 * @see #NAME_SPINE_2_LOWER_BACK
	 * @see HAnimSegment#NAME_L2 */
	public static final String NAME_SPINE_2_LOWER_BACK_PARENT = "l2";
	/** SFString xs:NMTOKEN enumeration value "<i>spine_2_lower_back</i>" has alias "<i>lower back</i>"
	 * @see #NAME_SPINE_2_LOWER_BACK */
	public static final String NAME_SPINE_2_LOWER_BACK_ALIAS = "lower back";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"waist_preferred_anterior"</i> (Java syntax) or <i>waist_preferred_anterior</i> (XML syntax).
	 * @see #NAME_WAIST_PREFERRED_ANTERIOR_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Waist" target="_blank">https://en.wikipedia.org/wiki/Waist</a>  */
	public static final String NAME_WAIST_PREFERRED_ANTERIOR = "waist_preferred_anterior";
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_anterior</i>" has unique index 26
	 * @see #NAME_WAIST_PREFERRED_ANTERIOR */
	public static final int NAME_WAIST_PREFERRED_ANTERIOR_INDEX = 26;
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_anterior</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_WAIST_PREFERRED_ANTERIOR */
	public static final int NAME_WAIST_PREFERRED_ANTERIOR_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_anterior</i>" has unique parent "<i>l2</i>" in HAnimSegment
	 * @see #NAME_WAIST_PREFERRED_ANTERIOR
	 * @see HAnimSegment#NAME_L2 */
	public static final String NAME_WAIST_PREFERRED_ANTERIOR_PARENT = "l2";
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_anterior</i>" has alias "<i>waist_preferred_ant</i>"
	 * @see #NAME_WAIST_PREFERRED_ANTERIOR */
	public static final String NAME_WAIST_PREFERRED_ANTERIOR_ALIAS = "waist_preferred_ant";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"waist_preferred_posterior"</i> (Java syntax) or <i>waist_preferred_posterior</i> (XML syntax).
	 * @see #NAME_WAIST_PREFERRED_POSTERIOR_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Waist" target="_blank">https://en.wikipedia.org/wiki/Waist</a>  */
	public static final String NAME_WAIST_PREFERRED_POSTERIOR = "waist_preferred_posterior";
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_posterior</i>" has unique index 27
	 * @see #NAME_WAIST_PREFERRED_POSTERIOR */
	public static final int NAME_WAIST_PREFERRED_POSTERIOR_INDEX = 27;
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_posterior</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_WAIST_PREFERRED_POSTERIOR */
	public static final int NAME_WAIST_PREFERRED_POSTERIOR_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_posterior</i>" has unique parent "<i>l2</i>" in HAnimSegment
	 * @see #NAME_WAIST_PREFERRED_POSTERIOR
	 * @see HAnimSegment#NAME_L2 */
	public static final String NAME_WAIST_PREFERRED_POSTERIOR_PARENT = "l2";
	/** SFString xs:NMTOKEN enumeration value "<i>waist_preferred_posterior</i>" has alias "<i>waist_preferred_post</i>"
	 * @see #NAME_WAIST_PREFERRED_POSTERIOR */
	public static final String NAME_WAIST_PREFERRED_POSTERIOR_ALIAS = "waist_preferred_post";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_rib10"</i> (Java syntax) or <i>l_rib10</i> (XML syntax).
	 * @see #NAME_L_RIB10_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Rib" target="_blank">https://en.wikipedia.org/wiki/Rib</a>  */
	public static final String NAME_L_RIB10 = "l_rib10";
	/** SFString xs:NMTOKEN enumeration value "<i>l_rib10</i>" has unique index 28
	 * @see #NAME_L_RIB10 */
	public static final int NAME_L_RIB10_INDEX = 28;
	/** SFString xs:NMTOKEN enumeration value "<i>l_rib10</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_L_RIB10 */
	public static final int NAME_L_RIB10_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>l_rib10</i>" has unique parent "<i>l2</i>" in HAnimSegment
	 * @see #NAME_L_RIB10
	 * @see HAnimSegment#NAME_L2 */
	public static final String NAME_L_RIB10_PARENT = "l2";
	/** SFString xs:NMTOKEN enumeration value "<i>l_rib10</i>" has alias "<i>l_rib10_midspine</i>"
	 * @see #NAME_L_RIB10 */
	public static final String NAME_L_RIB10_ALIAS = "l_rib10_midspine";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_thelion"</i> (Java syntax) or <i>l_thelion</i> (XML syntax).
	 * @see #NAME_L_THELION_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.cdc.gov/niosh/data/datasets/rd-1008-2016-0/pdfs/EMT-Data-Dictionary-508.pdf" target="_blank">https://www.cdc.gov/niosh/data/datasets/rd-1008-2016-0/pdfs/EMT-Data-Dictionary-508.pdf</a>  */
	public static final String NAME_L_THELION = "l_thelion";
	/** SFString xs:NMTOKEN enumeration value "<i>l_thelion</i>" has unique index 29
	 * @see #NAME_L_THELION */
	public static final int NAME_L_THELION_INDEX = 29;
	/** SFString xs:NMTOKEN enumeration value "<i>l_thelion</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_L_THELION */
	public static final int NAME_L_THELION_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>l_thelion</i>" has unique parent "<i>t9</i>" in HAnimSegment
	 * @see #NAME_L_THELION
	 * @see HAnimSegment#NAME_T9 */
	public static final String NAME_L_THELION_PARENT = "t9";
	/** SFString xs:NMTOKEN enumeration value "<i>l_thelion</i>" has alias "<i>Left Bustpoint</i>"
	 * @see #NAME_L_THELION */
	public static final String NAME_L_THELION_ALIAS = "Left Bustpoint";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_rib10"</i> (Java syntax) or <i>r_rib10</i> (XML syntax).
	 * @see #NAME_R_RIB10_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Rib" target="_blank">https://en.wikipedia.org/wiki/Rib</a>  */
	public static final String NAME_R_RIB10 = "r_rib10";
	/** SFString xs:NMTOKEN enumeration value "<i>r_rib10</i>" has unique index 30
	 * @see #NAME_R_RIB10 */
	public static final int NAME_R_RIB10_INDEX = 30;
	/** SFString xs:NMTOKEN enumeration value "<i>r_rib10</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_R_RIB10 */
	public static final int NAME_R_RIB10_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>r_rib10</i>" has unique parent "<i>l2</i>" in HAnimSegment
	 * @see #NAME_R_RIB10
	 * @see HAnimSegment#NAME_L2 */
	public static final String NAME_R_RIB10_PARENT = "l2";
	/** SFString xs:NMTOKEN enumeration value "<i>r_rib10</i>" has alias "<i>r_rib10_midspine</i>"
	 * @see #NAME_R_RIB10 */
	public static final String NAME_R_RIB10_ALIAS = "r_rib10_midspine";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_thelion"</i> (Java syntax) or <i>r_thelion</i> (XML syntax).
	 * @see #NAME_R_THELION_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.cdc.gov/niosh/data/datasets/rd-1008-2016-0/pdfs/EMT-Data-Dictionary-508.pdf" target="_blank">https://www.cdc.gov/niosh/data/datasets/rd-1008-2016-0/pdfs/EMT-Data-Dictionary-508.pdf</a>  */
	public static final String NAME_R_THELION = "r_thelion";
	/** SFString xs:NMTOKEN enumeration value "<i>r_thelion</i>" has unique index 31
	 * @see #NAME_R_THELION */
	public static final int NAME_R_THELION_INDEX = 31;
	/** SFString xs:NMTOKEN enumeration value "<i>r_thelion</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_R_THELION */
	public static final int NAME_R_THELION_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>r_thelion</i>" has unique parent "<i>t9</i>" in HAnimSegment
	 * @see #NAME_R_THELION
	 * @see HAnimSegment#NAME_T9 */
	public static final String NAME_R_THELION_PARENT = "t9";
	/** SFString xs:NMTOKEN enumeration value "<i>r_thelion</i>" has alias "<i>Right Bustpoint</i>"
	 * @see #NAME_R_THELION */
	public static final String NAME_R_THELION_ALIAS = "Right Bustpoint";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_asis"</i> (Java syntax) or <i>l_asis</i> (XML syntax).
	 * @see #NAME_L_ASIS_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Anterior_superior_iliac_spine" target="_blank">https://en.wikipedia.org/wiki/Anterior_superior_iliac_spine</a>  */
	public static final String NAME_L_ASIS = "l_asis";
	/** SFString xs:NMTOKEN enumeration value "<i>l_asis</i>" has unique index 32
	 * @see #NAME_L_ASIS */
	public static final int NAME_L_ASIS_INDEX = 32;
	/** SFString xs:NMTOKEN enumeration value "<i>l_asis</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_ASIS */
	public static final int NAME_L_ASIS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_asis</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_L_ASIS
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_L_ASIS_PARENT = "pelvis";
	/** SFString xs:NMTOKEN enumeration value "<i>l_asis</i>" has alias "<i>Left Anterior Superior Iliac Spine</i>"
	 * @see #NAME_L_ASIS */
	public static final String NAME_L_ASIS_ALIAS = "Left Anterior Superior Iliac Spine";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_iliocristale"</i> (Java syntax) or <i>l_iliocristale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.topendsports.com/testing/skinfold-iliac-crest.htm" target="_blank">https://www.topendsports.com/testing/skinfold-iliac-crest.htm</a>  */
	public static final String NAME_L_ILIOCRISTALE = "l_iliocristale";
	/** SFString xs:NMTOKEN enumeration value "<i>l_iliocristale</i>" has unique index 33
	 * @see #NAME_L_ILIOCRISTALE */
	public static final int NAME_L_ILIOCRISTALE_INDEX = 33;
	/** SFString xs:NMTOKEN enumeration value "<i>l_iliocristale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_ILIOCRISTALE */
	public static final int NAME_L_ILIOCRISTALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_iliocristale</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_L_ILIOCRISTALE
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_L_ILIOCRISTALE_PARENT = "pelvis";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_psis"</i> (Java syntax) or <i>l_psis</i> (XML syntax).
	 * @see #NAME_L_PSIS_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Posterior_superior_iliac_spine" target="_blank">https://en.wikipedia.org/wiki/Posterior_superior_iliac_spine</a>  */
	public static final String NAME_L_PSIS = "l_psis";
	/** SFString xs:NMTOKEN enumeration value "<i>l_psis</i>" has unique index 34
	 * @see #NAME_L_PSIS */
	public static final int NAME_L_PSIS_INDEX = 34;
	/** SFString xs:NMTOKEN enumeration value "<i>l_psis</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_PSIS */
	public static final int NAME_L_PSIS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_psis</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_L_PSIS
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_L_PSIS_PARENT = "pelvis";
	/** SFString xs:NMTOKEN enumeration value "<i>l_psis</i>" has alias "<i>Left Posterior Superior Iliac Spine</i>"
	 * @see #NAME_L_PSIS */
	public static final String NAME_L_PSIS_ALIAS = "Left Posterior Superior Iliac Spine";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_asis"</i> (Java syntax) or <i>r_asis</i> (XML syntax).
	 * @see #NAME_R_ASIS_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Anterior_superior_iliac_spine" target="_blank">https://en.wikipedia.org/wiki/Anterior_superior_iliac_spine</a>  */
	public static final String NAME_R_ASIS = "r_asis";
	/** SFString xs:NMTOKEN enumeration value "<i>r_asis</i>" has unique index 35
	 * @see #NAME_R_ASIS */
	public static final int NAME_R_ASIS_INDEX = 35;
	/** SFString xs:NMTOKEN enumeration value "<i>r_asis</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_ASIS */
	public static final int NAME_R_ASIS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_asis</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_R_ASIS
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_R_ASIS_PARENT = "pelvis";
	/** SFString xs:NMTOKEN enumeration value "<i>r_asis</i>" has alias "<i>Right Anterior Superior Iliac Spine</i>"
	 * @see #NAME_R_ASIS */
	public static final String NAME_R_ASIS_ALIAS = "Right Anterior Superior Iliac Spine";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_iliocristale"</i> (Java syntax) or <i>r_iliocristale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.topendsports.com/testing/skinfold-iliac-crest.htm" target="_blank">https://www.topendsports.com/testing/skinfold-iliac-crest.htm</a>  */
	public static final String NAME_R_ILIOCRISTALE = "r_iliocristale";
	/** SFString xs:NMTOKEN enumeration value "<i>r_iliocristale</i>" has unique index 36
	 * @see #NAME_R_ILIOCRISTALE */
	public static final int NAME_R_ILIOCRISTALE_INDEX = 36;
	/** SFString xs:NMTOKEN enumeration value "<i>r_iliocristale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_ILIOCRISTALE */
	public static final int NAME_R_ILIOCRISTALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_iliocristale</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_R_ILIOCRISTALE
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_R_ILIOCRISTALE_PARENT = "pelvis";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_psis"</i> (Java syntax) or <i>r_psis</i> (XML syntax).
	 * @see #NAME_R_PSIS_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Posterior_superior_iliac_spine" target="_blank">https://en.wikipedia.org/wiki/Posterior_superior_iliac_spine</a>  */
	public static final String NAME_R_PSIS = "r_psis";
	/** SFString xs:NMTOKEN enumeration value "<i>r_psis</i>" has unique index 37
	 * @see #NAME_R_PSIS */
	public static final int NAME_R_PSIS_INDEX = 37;
	/** SFString xs:NMTOKEN enumeration value "<i>r_psis</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_PSIS */
	public static final int NAME_R_PSIS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_psis</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_R_PSIS
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_R_PSIS_PARENT = "pelvis";
	/** SFString xs:NMTOKEN enumeration value "<i>r_psis</i>" has alias "<i>Right Posterior Superior Iliac Spine</i>"
	 * @see #NAME_R_PSIS */
	public static final String NAME_R_PSIS_ALIAS = "Right Posterior Superior Iliac Spine";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"crotch"</i> (Java syntax) or <i>crotch</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Crotch" target="_blank">https://en.wikipedia.org/wiki/Crotch</a>  */
	public static final String NAME_CROTCH = "crotch";
	/** SFString xs:NMTOKEN enumeration value "<i>crotch</i>" has unique index 38
	 * @see #NAME_CROTCH */
	public static final int NAME_CROTCH_INDEX = 38;
	/** SFString xs:NMTOKEN enumeration value "<i>crotch</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_CROTCH */
	public static final int NAME_CROTCH_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>crotch</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_CROTCH
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_CROTCH_PARENT = "pelvis";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_femoral_lateral_epicondyle"</i> (Java syntax) or <i>l_femoral_lateral_epicondyle</i> (XML syntax).
	 * @see #NAME_L_FEMORAL_LATERAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_femur" target="_blank">https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_femur</a>  */
	public static final String NAME_L_FEMORAL_LATERAL_EPICONDYLE = "l_femoral_lateral_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_lateral_epicondyle</i>" has unique index 39
	 * @see #NAME_L_FEMORAL_LATERAL_EPICONDYLE */
	public static final int NAME_L_FEMORAL_LATERAL_EPICONDYLE_INDEX = 39;
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_lateral_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_FEMORAL_LATERAL_EPICONDYLE */
	public static final int NAME_L_FEMORAL_LATERAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_lateral_epicondyle</i>" has unique parent "<i>l_thigh</i>" in HAnimSegment
	 * @see #NAME_L_FEMORAL_LATERAL_EPICONDYLE
	 * @see HAnimSegment#NAME_L_THIGH */
	public static final String NAME_L_FEMORAL_LATERAL_EPICONDYLE_PARENT = "l_thigh";
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_lateral_epicondyle</i>" has alias  (TODO tokenize array)"<i>l_femoral_lateral_epicn,l_femoral_lateral_epicondyles</i>" */
	public static final String NAME_L_FEMORAL_LATERAL_EPICONDYLE_ALIAS = "l_femoral_lateral_epicn,l_femoral_lateral_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_femoral_medial_epicondyle"</i> (Java syntax) or <i>l_femoral_medial_epicondyle</i> (XML syntax).
	 * @see #NAME_L_FEMORAL_MEDIAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_femur" target="_blank">https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_femur</a>  */
	public static final String NAME_L_FEMORAL_MEDIAL_EPICONDYLE = "l_femoral_medial_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_medial_epicondyle</i>" has unique index 40
	 * @see #NAME_L_FEMORAL_MEDIAL_EPICONDYLE */
	public static final int NAME_L_FEMORAL_MEDIAL_EPICONDYLE_INDEX = 40;
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_medial_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_FEMORAL_MEDIAL_EPICONDYLE */
	public static final int NAME_L_FEMORAL_MEDIAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_medial_epicondyle</i>" has unique parent "<i>l_thigh</i>" in HAnimSegment
	 * @see #NAME_L_FEMORAL_MEDIAL_EPICONDYLE
	 * @see HAnimSegment#NAME_L_THIGH */
	public static final String NAME_L_FEMORAL_MEDIAL_EPICONDYLE_PARENT = "l_thigh";
	/** SFString xs:NMTOKEN enumeration value "<i>l_femoral_medial_epicondyle</i>" has alias  (TODO tokenize array)"<i>l_femoral_medial_epicn,l_femoral_medial_epicondyles</i>" */
	public static final String NAME_L_FEMORAL_MEDIAL_EPICONDYLE_ALIAS = "l_femoral_medial_epicn,l_femoral_medial_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_suprapatella"</i> (Java syntax) or <i>l_suprapatella</i> (XML syntax).
	 * @see #NAME_L_SUPRAPATELLA_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Patella" target="_blank">https://en.wikipedia.org/wiki/Patella</a>  */
	public static final String NAME_L_SUPRAPATELLA = "l_suprapatella";
	/** SFString xs:NMTOKEN enumeration value "<i>l_suprapatella</i>" has unique index 41
	 * @see #NAME_L_SUPRAPATELLA */
	public static final int NAME_L_SUPRAPATELLA_INDEX = 41;
	/** SFString xs:NMTOKEN enumeration value "<i>l_suprapatella</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_SUPRAPATELLA */
	public static final int NAME_L_SUPRAPATELLA_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_suprapatella</i>" has unique parent "<i>l_thigh</i>" in HAnimSegment
	 * @see #NAME_L_SUPRAPATELLA
	 * @see HAnimSegment#NAME_L_THIGH */
	public static final String NAME_L_SUPRAPATELLA_PARENT = "l_thigh";
	/** SFString xs:NMTOKEN enumeration value "<i>l_suprapatella</i>" has alias "<i>l_kneecap</i>"
	 * @see #NAME_L_SUPRAPATELLA */
	public static final String NAME_L_SUPRAPATELLA_ALIAS = "l_kneecap";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_trochanterion"</i> (Java syntax) or <i>l_trochanterion</i> (XML syntax).
	 * @see #NAME_L_TROCHANTERION_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Trochanter" target="_blank">https://en.wikipedia.org/wiki/Trochanter</a>  */
	public static final String NAME_L_TROCHANTERION = "l_trochanterion";
	/** SFString xs:NMTOKEN enumeration value "<i>l_trochanterion</i>" has unique index 42
	 * @see #NAME_L_TROCHANTERION */
	public static final int NAME_L_TROCHANTERION_INDEX = 42;
	/** SFString xs:NMTOKEN enumeration value "<i>l_trochanterion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_TROCHANTERION */
	public static final int NAME_L_TROCHANTERION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_trochanterion</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_L_TROCHANTERION
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_L_TROCHANTERION_PARENT = "pelvis";
	/** SFString xs:NMTOKEN enumeration value "<i>l_trochanterion</i>" has alias "<i>l_trochanter</i>"
	 * @see #NAME_L_TROCHANTERION */
	public static final String NAME_L_TROCHANTERION_ALIAS = "l_trochanter";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_femoral_lateral_epicondyle"</i> (Java syntax) or <i>r_femoral_lateral_epicondyle</i> (XML syntax).
	 * @see #NAME_R_FEMORAL_LATERAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_femur" target="_blank">https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_femur</a>  */
	public static final String NAME_R_FEMORAL_LATERAL_EPICONDYLE = "r_femoral_lateral_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_lateral_epicondyle</i>" has unique index 43
	 * @see #NAME_R_FEMORAL_LATERAL_EPICONDYLE */
	public static final int NAME_R_FEMORAL_LATERAL_EPICONDYLE_INDEX = 43;
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_lateral_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_FEMORAL_LATERAL_EPICONDYLE */
	public static final int NAME_R_FEMORAL_LATERAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_lateral_epicondyle</i>" has unique parent "<i>r_thigh</i>" in HAnimSegment
	 * @see #NAME_R_FEMORAL_LATERAL_EPICONDYLE
	 * @see HAnimSegment#NAME_R_THIGH */
	public static final String NAME_R_FEMORAL_LATERAL_EPICONDYLE_PARENT = "r_thigh";
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_lateral_epicondyle</i>" has alias  (TODO tokenize array)"<i>r_femoral_lateral_epicn,r_femoral_lateral_epicondyles</i>" */
	public static final String NAME_R_FEMORAL_LATERAL_EPICONDYLE_ALIAS = "r_femoral_lateral_epicn,r_femoral_lateral_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_femoral_medial_epicondyle"</i> (Java syntax) or <i>r_femoral_medial_epicondyle</i> (XML syntax).
	 * @see #NAME_R_FEMORAL_MEDIAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_femur" target="_blank">https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_femur</a>  */
	public static final String NAME_R_FEMORAL_MEDIAL_EPICONDYLE = "r_femoral_medial_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_medial_epicondyle</i>" has unique index 44
	 * @see #NAME_R_FEMORAL_MEDIAL_EPICONDYLE */
	public static final int NAME_R_FEMORAL_MEDIAL_EPICONDYLE_INDEX = 44;
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_medial_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_FEMORAL_MEDIAL_EPICONDYLE */
	public static final int NAME_R_FEMORAL_MEDIAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_medial_epicondyle</i>" has unique parent "<i>r_thigh</i>" in HAnimSegment
	 * @see #NAME_R_FEMORAL_MEDIAL_EPICONDYLE
	 * @see HAnimSegment#NAME_R_THIGH */
	public static final String NAME_R_FEMORAL_MEDIAL_EPICONDYLE_PARENT = "r_thigh";
	/** SFString xs:NMTOKEN enumeration value "<i>r_femoral_medial_epicondyle</i>" has alias  (TODO tokenize array)"<i>r_femoral_medial_epicn,r_femoral_medial_epicondyles</i>" */
	public static final String NAME_R_FEMORAL_MEDIAL_EPICONDYLE_ALIAS = "r_femoral_medial_epicn,r_femoral_medial_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_suprapatella"</i> (Java syntax) or <i>r_suprapatella</i> (XML syntax).
	 * @see #NAME_R_SUPRAPATELLA_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Patella" target="_blank">https://en.wikipedia.org/wiki/Patella</a>  */
	public static final String NAME_R_SUPRAPATELLA = "r_suprapatella";
	/** SFString xs:NMTOKEN enumeration value "<i>r_suprapatella</i>" has unique index 45
	 * @see #NAME_R_SUPRAPATELLA */
	public static final int NAME_R_SUPRAPATELLA_INDEX = 45;
	/** SFString xs:NMTOKEN enumeration value "<i>r_suprapatella</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_SUPRAPATELLA */
	public static final int NAME_R_SUPRAPATELLA_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_suprapatella</i>" has unique parent "<i>r_thigh</i>" in HAnimSegment
	 * @see #NAME_R_SUPRAPATELLA
	 * @see HAnimSegment#NAME_R_THIGH */
	public static final String NAME_R_SUPRAPATELLA_PARENT = "r_thigh";
	/** SFString xs:NMTOKEN enumeration value "<i>r_suprapatella</i>" has alias "<i>r_kneecap</i>"
	 * @see #NAME_R_SUPRAPATELLA */
	public static final String NAME_R_SUPRAPATELLA_ALIAS = "r_kneecap";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_trochanterion"</i> (Java syntax) or <i>r_trochanterion</i> (XML syntax).
	 * @see #NAME_R_TROCHANTERION_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Trochanter" target="_blank">https://en.wikipedia.org/wiki/Trochanter</a>  */
	public static final String NAME_R_TROCHANTERION = "r_trochanterion";
	/** SFString xs:NMTOKEN enumeration value "<i>r_trochanterion</i>" has unique index 46
	 * @see #NAME_R_TROCHANTERION */
	public static final int NAME_R_TROCHANTERION_INDEX = 46;
	/** SFString xs:NMTOKEN enumeration value "<i>r_trochanterion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_TROCHANTERION */
	public static final int NAME_R_TROCHANTERION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_trochanterion</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_R_TROCHANTERION
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_R_TROCHANTERION_PARENT = "pelvis";
	/** SFString xs:NMTOKEN enumeration value "<i>r_trochanterion</i>" has alias "<i>r_trochanter</i>"
	 * @see #NAME_R_TROCHANTERION */
	public static final String NAME_R_TROCHANTERION_ALIAS = "r_trochanter";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_tibiale"</i> (Java syntax) or <i>l_tibiale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Accessory_navicular_bone" target="_blank">https://en.wikipedia.org/wiki/Accessory_navicular_bone</a>  */
	public static final String NAME_L_TIBIALE = "l_tibiale";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tibiale</i>" has unique index 47
	 * @see #NAME_L_TIBIALE */
	public static final int NAME_L_TIBIALE_INDEX = 47;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tibiale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_TIBIALE */
	public static final int NAME_L_TIBIALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tibiale</i>" has unique parent "<i>l_calf</i>" in HAnimSegment
	 * @see #NAME_L_TIBIALE
	 * @see HAnimSegment#NAME_L_CALF */
	public static final String NAME_L_TIBIALE_PARENT = "l_calf";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_medial_malleolus"</i> (Java syntax) or <i>l_medial_malleolus</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Malleolus" target="_blank">https://en.wikipedia.org/wiki/Malleolus</a>  */
	public static final String NAME_L_MEDIAL_MALLEOLUS = "l_medial_malleolus";
	/** SFString xs:NMTOKEN enumeration value "<i>l_medial_malleolus</i>" has unique index 48
	 * @see #NAME_L_MEDIAL_MALLEOLUS */
	public static final int NAME_L_MEDIAL_MALLEOLUS_INDEX = 48;
	/** SFString xs:NMTOKEN enumeration value "<i>l_medial_malleolus</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_MEDIAL_MALLEOLUS */
	public static final int NAME_L_MEDIAL_MALLEOLUS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_medial_malleolus</i>" has unique parent "<i>l_calf</i>" in HAnimSegment
	 * @see #NAME_L_MEDIAL_MALLEOLUS
	 * @see HAnimSegment#NAME_L_CALF */
	public static final String NAME_L_MEDIAL_MALLEOLUS_PARENT = "l_calf";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_lateral_malleolus"</i> (Java syntax) or <i>l_lateral_malleolus</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Malleolus" target="_blank">https://en.wikipedia.org/wiki/Malleolus</a>  */
	public static final String NAME_L_LATERAL_MALLEOLUS = "l_lateral_malleolus";
	/** SFString xs:NMTOKEN enumeration value "<i>l_lateral_malleolus</i>" has unique index 49
	 * @see #NAME_L_LATERAL_MALLEOLUS */
	public static final int NAME_L_LATERAL_MALLEOLUS_INDEX = 49;
	/** SFString xs:NMTOKEN enumeration value "<i>l_lateral_malleolus</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_LATERAL_MALLEOLUS */
	public static final int NAME_L_LATERAL_MALLEOLUS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_lateral_malleolus</i>" has unique parent "<i>l_calf</i>" in HAnimSegment
	 * @see #NAME_L_LATERAL_MALLEOLUS
	 * @see HAnimSegment#NAME_L_CALF */
	public static final String NAME_L_LATERAL_MALLEOLUS_PARENT = "l_calf";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_sphyrion"</i> (Java syntax) or <i>l_sphyrion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.oxfordreference.com/view/10.1093/oi/authority.20110803100523385" target="_blank">https://www.oxfordreference.com/view/10.1093/oi/authority.20110803100523385</a>  */
	public static final String NAME_L_SPHYRION = "l_sphyrion";
	/** SFString xs:NMTOKEN enumeration value "<i>l_sphyrion</i>" has unique index 50
	 * @see #NAME_L_SPHYRION */
	public static final int NAME_L_SPHYRION_INDEX = 50;
	/** SFString xs:NMTOKEN enumeration value "<i>l_sphyrion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_SPHYRION */
	public static final int NAME_L_SPHYRION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_sphyrion</i>" has unique parent "<i>l_talus</i>" in HAnimSegment
	 * @see #NAME_L_SPHYRION
	 * @see HAnimSegment#NAME_L_TALUS */
	public static final String NAME_L_SPHYRION_PARENT = "l_talus";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_tibiale"</i> (Java syntax) or <i>r_tibiale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Accessory_navicular_bone" target="_blank">https://en.wikipedia.org/wiki/Accessory_navicular_bone</a>  */
	public static final String NAME_R_TIBIALE = "r_tibiale";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tibiale</i>" has unique index 51
	 * @see #NAME_R_TIBIALE */
	public static final int NAME_R_TIBIALE_INDEX = 51;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tibiale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_TIBIALE */
	public static final int NAME_R_TIBIALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tibiale</i>" has unique parent "<i>r_calf</i>" in HAnimSegment
	 * @see #NAME_R_TIBIALE
	 * @see HAnimSegment#NAME_R_CALF */
	public static final String NAME_R_TIBIALE_PARENT = "r_calf";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_medial_malleolus"</i> (Java syntax) or <i>r_medial_malleolus</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Malleolus" target="_blank">https://en.wikipedia.org/wiki/Malleolus</a>  */
	public static final String NAME_R_MEDIAL_MALLEOLUS = "r_medial_malleolus";
	/** SFString xs:NMTOKEN enumeration value "<i>r_medial_malleolus</i>" has unique index 52
	 * @see #NAME_R_MEDIAL_MALLEOLUS */
	public static final int NAME_R_MEDIAL_MALLEOLUS_INDEX = 52;
	/** SFString xs:NMTOKEN enumeration value "<i>r_medial_malleolus</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_MEDIAL_MALLEOLUS */
	public static final int NAME_R_MEDIAL_MALLEOLUS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_medial_malleolus</i>" has unique parent "<i>r_calf</i>" in HAnimSegment
	 * @see #NAME_R_MEDIAL_MALLEOLUS
	 * @see HAnimSegment#NAME_R_CALF */
	public static final String NAME_R_MEDIAL_MALLEOLUS_PARENT = "r_calf";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_lateral_malleolus"</i> (Java syntax) or <i>r_lateral_malleolus</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Malleolus" target="_blank">https://en.wikipedia.org/wiki/Malleolus</a>  */
	public static final String NAME_R_LATERAL_MALLEOLUS = "r_lateral_malleolus";
	/** SFString xs:NMTOKEN enumeration value "<i>r_lateral_malleolus</i>" has unique index 53
	 * @see #NAME_R_LATERAL_MALLEOLUS */
	public static final int NAME_R_LATERAL_MALLEOLUS_INDEX = 53;
	/** SFString xs:NMTOKEN enumeration value "<i>r_lateral_malleolus</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_LATERAL_MALLEOLUS */
	public static final int NAME_R_LATERAL_MALLEOLUS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_lateral_malleolus</i>" has unique parent "<i>r_calf</i>" in HAnimSegment
	 * @see #NAME_R_LATERAL_MALLEOLUS
	 * @see HAnimSegment#NAME_R_CALF */
	public static final String NAME_R_LATERAL_MALLEOLUS_PARENT = "r_calf";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_sphyrion"</i> (Java syntax) or <i>r_sphyrion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.oxfordreference.com/view/10.1093/oi/authority.20110803100523385" target="_blank">https://www.oxfordreference.com/view/10.1093/oi/authority.20110803100523385</a>  */
	public static final String NAME_R_SPHYRION = "r_sphyrion";
	/** SFString xs:NMTOKEN enumeration value "<i>r_sphyrion</i>" has unique index 54
	 * @see #NAME_R_SPHYRION */
	public static final int NAME_R_SPHYRION_INDEX = 54;
	/** SFString xs:NMTOKEN enumeration value "<i>r_sphyrion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_SPHYRION */
	public static final int NAME_R_SPHYRION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_sphyrion</i>" has unique parent "<i>r_talus</i>" in HAnimSegment
	 * @see #NAME_R_SPHYRION
	 * @see HAnimSegment#NAME_R_TALUS */
	public static final String NAME_R_SPHYRION_PARENT = "r_talus";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_metatarsal_phalanx_1"</i> (Java syntax) or <i>l_metatarsal_phalanx_1</i> (XML syntax).
	 * @see #NAME_L_METATARSAL_PHALANX_1_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metatarsal_bones" target="_blank">https://en.wikipedia.org/wiki/Metatarsal_bones</a>  */
	public static final String NAME_L_METATARSAL_PHALANX_1 = "l_metatarsal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_1</i>" has unique index 55
	 * @see #NAME_L_METATARSAL_PHALANX_1 */
	public static final int NAME_L_METATARSAL_PHALANX_1_INDEX = 55;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_1</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_L_METATARSAL_PHALANX_1 */
	public static final int NAME_L_METATARSAL_PHALANX_1_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_1</i>" has unique parent "<i>l_tarsal_proximal_phalanx_1</i>" in HAnimSegment
	 * @see #NAME_L_METATARSAL_PHALANX_1
	 * @see HAnimSegment#NAME_L_TARSAL_PROXIMAL_PHALANX_1 */
	public static final String NAME_L_METATARSAL_PHALANX_1_PARENT = "l_tarsal_proximal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_1</i>" has alias "<i>l_metatarsal_pha1</i>"
	 * @see #NAME_L_METATARSAL_PHALANX_1 */
	public static final String NAME_L_METATARSAL_PHALANX_1_ALIAS = "l_metatarsal_pha1";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_metatarsal_phalanx_5"</i> (Java syntax) or <i>l_metatarsal_phalanx_5</i> (XML syntax).
	 * @see #NAME_L_METATARSAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metatarsal_bones" target="_blank">https://en.wikipedia.org/wiki/Metatarsal_bones</a>  */
	public static final String NAME_L_METATARSAL_PHALANX_5 = "l_metatarsal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_5</i>" has unique index 56
	 * @see #NAME_L_METATARSAL_PHALANX_5 */
	public static final int NAME_L_METATARSAL_PHALANX_5_INDEX = 56;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_5</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_L_METATARSAL_PHALANX_5 */
	public static final int NAME_L_METATARSAL_PHALANX_5_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_5</i>" has unique parent "<i>l_tarsal_proximal_phalanx_5</i>" in HAnimSegment
	 * @see #NAME_L_METATARSAL_PHALANX_5
	 * @see HAnimSegment#NAME_L_TARSAL_PROXIMAL_PHALANX_5 */
	public static final String NAME_L_METATARSAL_PHALANX_5_PARENT = "l_tarsal_proximal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metatarsal_phalanx_5</i>" has alias "<i>l_metatarsal_pha5</i>"
	 * @see #NAME_L_METATARSAL_PHALANX_5 */
	public static final String NAME_L_METATARSAL_PHALANX_5_ALIAS = "l_metatarsal_pha5";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_dactylion"</i> (Java syntax) or <i>l_dactylion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wiktionary.org/wiki/dactylion" target="_blank">https://en.wiktionary.org/wiki/dactylion</a>  */
	public static final String NAME_L_DACTYLION = "l_dactylion";
	/** SFString xs:NMTOKEN enumeration value "<i>l_dactylion</i>" has unique index 57
	 * @see #NAME_L_DACTYLION */
	public static final int NAME_L_DACTYLION_INDEX = 57;
	/** SFString xs:NMTOKEN enumeration value "<i>l_dactylion</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_DACTYLION */
	public static final int NAME_L_DACTYLION_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_dactylion</i>" has unique parent "<i>l_carpal_distal_phalanx_2</i>" in HAnimSegment
	 * @see #NAME_L_DACTYLION
	 * @see HAnimSegment#NAME_L_CARPAL_DISTAL_PHALANX_2 */
	public static final String NAME_L_DACTYLION_PARENT = "l_carpal_distal_phalanx_2";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_calcaneus_posterior"</i> (Java syntax) or <i>l_calcaneus_posterior</i> (XML syntax).
	 * @see #NAME_L_CALCANEUS_POSTERIOR_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Calcaneus" target="_blank">https://en.wikipedia.org/wiki/Calcaneus</a>  */
	public static final String NAME_L_CALCANEUS_POSTERIOR = "l_calcaneus_posterior";
	/** SFString xs:NMTOKEN enumeration value "<i>l_calcaneus_posterior</i>" has unique index 58
	 * @see #NAME_L_CALCANEUS_POSTERIOR */
	public static final int NAME_L_CALCANEUS_POSTERIOR_INDEX = 58;
	/** SFString xs:NMTOKEN enumeration value "<i>l_calcaneus_posterior</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_CALCANEUS_POSTERIOR */
	public static final int NAME_L_CALCANEUS_POSTERIOR_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_calcaneus_posterior</i>" has unique parent "<i>l_talus</i>" in HAnimSegment
	 * @see #NAME_L_CALCANEUS_POSTERIOR
	 * @see HAnimSegment#NAME_L_TALUS */
	public static final String NAME_L_CALCANEUS_POSTERIOR_PARENT = "l_talus";
	/** SFString xs:NMTOKEN enumeration value "<i>l_calcaneus_posterior</i>" has alias "<i>l_calcaneous_post</i>"
	 * @see #NAME_L_CALCANEUS_POSTERIOR */
	public static final String NAME_L_CALCANEUS_POSTERIOR_ALIAS = "l_calcaneous_post";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_metatarsal_phalanx_1"</i> (Java syntax) or <i>r_metatarsal_phalanx_1</i> (XML syntax).
	 * @see #NAME_R_METATARSAL_PHALANX_1_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metatarsal_bones" target="_blank">https://en.wikipedia.org/wiki/Metatarsal_bones</a>  */
	public static final String NAME_R_METATARSAL_PHALANX_1 = "r_metatarsal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_1</i>" has unique index 59
	 * @see #NAME_R_METATARSAL_PHALANX_1 */
	public static final int NAME_R_METATARSAL_PHALANX_1_INDEX = 59;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_1</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_R_METATARSAL_PHALANX_1 */
	public static final int NAME_R_METATARSAL_PHALANX_1_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_1</i>" has unique parent "<i>r_tarsal_proximal_phalanx_1</i>" in HAnimSegment
	 * @see #NAME_R_METATARSAL_PHALANX_1
	 * @see HAnimSegment#NAME_R_TARSAL_PROXIMAL_PHALANX_1 */
	public static final String NAME_R_METATARSAL_PHALANX_1_PARENT = "r_tarsal_proximal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_1</i>" has alias "<i>r_metatarsal_pha1</i>"
	 * @see #NAME_R_METATARSAL_PHALANX_1 */
	public static final String NAME_R_METATARSAL_PHALANX_1_ALIAS = "r_metatarsal_pha1";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_metatarsal_phalanx_5"</i> (Java syntax) or <i>r_metatarsal_phalanx_5</i> (XML syntax).
	 * @see #NAME_R_METATARSAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metatarsal_bones" target="_blank">https://en.wikipedia.org/wiki/Metatarsal_bones</a>  */
	public static final String NAME_R_METATARSAL_PHALANX_5 = "r_metatarsal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_5</i>" has unique index 60
	 * @see #NAME_R_METATARSAL_PHALANX_5 */
	public static final int NAME_R_METATARSAL_PHALANX_5_INDEX = 60;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_5</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_R_METATARSAL_PHALANX_5 */
	public static final int NAME_R_METATARSAL_PHALANX_5_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_5</i>" has unique parent "<i>r_tarsal_proximal_phalanx_5</i>" in HAnimSegment
	 * @see #NAME_R_METATARSAL_PHALANX_5
	 * @see HAnimSegment#NAME_R_TARSAL_PROXIMAL_PHALANX_5 */
	public static final String NAME_R_METATARSAL_PHALANX_5_PARENT = "r_tarsal_proximal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metatarsal_phalanx_5</i>" has alias "<i>r_metatarsal_pha5</i>"
	 * @see #NAME_R_METATARSAL_PHALANX_5 */
	public static final String NAME_R_METATARSAL_PHALANX_5_ALIAS = "r_metatarsal_pha5";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_dactylion"</i> (Java syntax) or <i>r_dactylion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wiktionary.org/wiki/dactylion" target="_blank">https://en.wiktionary.org/wiki/dactylion</a>  */
	public static final String NAME_R_DACTYLION = "r_dactylion";
	/** SFString xs:NMTOKEN enumeration value "<i>r_dactylion</i>" has unique index 61
	 * @see #NAME_R_DACTYLION */
	public static final int NAME_R_DACTYLION_INDEX = 61;
	/** SFString xs:NMTOKEN enumeration value "<i>r_dactylion</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_DACTYLION */
	public static final int NAME_R_DACTYLION_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_dactylion</i>" has unique parent "<i>r_carpal_distal_phalanx_2</i>" in HAnimSegment
	 * @see #NAME_R_DACTYLION
	 * @see HAnimSegment#NAME_R_CARPAL_DISTAL_PHALANX_2 */
	public static final String NAME_R_DACTYLION_PARENT = "r_carpal_distal_phalanx_2";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_calcaneus_posterior"</i> (Java syntax) or <i>r_calcaneus_posterior</i> (XML syntax).
	 * @see #NAME_R_CALCANEUS_POSTERIOR_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Calcaneus" target="_blank">https://en.wikipedia.org/wiki/Calcaneus</a>  */
	public static final String NAME_R_CALCANEUS_POSTERIOR = "r_calcaneus_posterior";
	/** SFString xs:NMTOKEN enumeration value "<i>r_calcaneus_posterior</i>" has unique index 62
	 * @see #NAME_R_CALCANEUS_POSTERIOR */
	public static final int NAME_R_CALCANEUS_POSTERIOR_INDEX = 62;
	/** SFString xs:NMTOKEN enumeration value "<i>r_calcaneus_posterior</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_CALCANEUS_POSTERIOR */
	public static final int NAME_R_CALCANEUS_POSTERIOR_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_calcaneus_posterior</i>" has unique parent "<i>r_talus</i>" in HAnimSegment
	 * @see #NAME_R_CALCANEUS_POSTERIOR
	 * @see HAnimSegment#NAME_R_TALUS */
	public static final String NAME_R_CALCANEUS_POSTERIOR_PARENT = "r_talus";
	/** SFString xs:NMTOKEN enumeration value "<i>r_calcaneus_posterior</i>" has alias "<i>r_calcaneous_post</i>"
	 * @see #NAME_R_CALCANEUS_POSTERIOR */
	public static final String NAME_R_CALCANEUS_POSTERIOR_ALIAS = "r_calcaneous_post";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_humeral_lateral_epicondyle"</i> (Java syntax) or <i>l_humeral_lateral_epicondyle</i> (XML syntax).
	 * @see #NAME_L_HUMERAL_LATERAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_humerus" target="_blank">https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_humerus</a>  */
	public static final String NAME_L_HUMERAL_LATERAL_EPICONDYLE = "l_humeral_lateral_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_lateral_epicondyle</i>" has unique index 63
	 * @see #NAME_L_HUMERAL_LATERAL_EPICONDYLE */
	public static final int NAME_L_HUMERAL_LATERAL_EPICONDYLE_INDEX = 63;
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_lateral_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_HUMERAL_LATERAL_EPICONDYLE */
	public static final int NAME_L_HUMERAL_LATERAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_lateral_epicondyle</i>" has unique parent "<i>l_upperarm</i>" in HAnimSegment
	 * @see #NAME_L_HUMERAL_LATERAL_EPICONDYLE
	 * @see HAnimSegment#NAME_L_UPPERARM */
	public static final String NAME_L_HUMERAL_LATERAL_EPICONDYLE_PARENT = "l_upperarm";
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_lateral_epicondyle</i>" has alias  (TODO tokenize array)"<i>l_humeral_lateral_epicn,l_humeral_lateral_epicondyles</i>" */
	public static final String NAME_L_HUMERAL_LATERAL_EPICONDYLE_ALIAS = "l_humeral_lateral_epicn,l_humeral_lateral_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_humeral_medial_epicondyle"</i> (Java syntax) or <i>l_humeral_medial_epicondyle</i> (XML syntax).
	 * @see #NAME_L_HUMERAL_MEDIAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_humerus" target="_blank">https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_humerus</a>  */
	public static final String NAME_L_HUMERAL_MEDIAL_EPICONDYLE = "l_humeral_medial_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_medial_epicondyle</i>" has unique index 64
	 * @see #NAME_L_HUMERAL_MEDIAL_EPICONDYLE */
	public static final int NAME_L_HUMERAL_MEDIAL_EPICONDYLE_INDEX = 64;
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_medial_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_HUMERAL_MEDIAL_EPICONDYLE */
	public static final int NAME_L_HUMERAL_MEDIAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_medial_epicondyle</i>" has unique parent "<i>l_forearm</i>" in HAnimSegment
	 * @see #NAME_L_HUMERAL_MEDIAL_EPICONDYLE
	 * @see HAnimSegment#NAME_L_FOREARM */
	public static final String NAME_L_HUMERAL_MEDIAL_EPICONDYLE_PARENT = "l_forearm";
	/** SFString xs:NMTOKEN enumeration value "<i>l_humeral_medial_epicondyle</i>" has alias  (TODO tokenize array)"<i>l_humeral_medial_epicn,l_humeral_medial_epicondyles</i>" */
	public static final String NAME_L_HUMERAL_MEDIAL_EPICONDYLE_ALIAS = "l_humeral_medial_epicn,l_humeral_medial_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_olecranon"</i> (Java syntax) or <i>l_olecranon</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Olecranon" target="_blank">https://en.wikipedia.org/wiki/Olecranon</a>  */
	public static final String NAME_L_OLECRANON = "l_olecranon";
	/** SFString xs:NMTOKEN enumeration value "<i>l_olecranon</i>" has unique index 65
	 * @see #NAME_L_OLECRANON */
	public static final int NAME_L_OLECRANON_INDEX = 65;
	/** SFString xs:NMTOKEN enumeration value "<i>l_olecranon</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_OLECRANON */
	public static final int NAME_L_OLECRANON_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_olecranon</i>" has unique parent "<i>l_forearm</i>" in HAnimSegment
	 * @see #NAME_L_OLECRANON
	 * @see HAnimSegment#NAME_L_FOREARM */
	public static final String NAME_L_OLECRANON_PARENT = "l_forearm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_humeral_lateral_epicondyle"</i> (Java syntax) or <i>r_humeral_lateral_epicondyle</i> (XML syntax).
	 * @see #NAME_R_HUMERAL_LATERAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_humerus" target="_blank">https://en.wikipedia.org/wiki/Lateral_epicondyle_of_the_humerus</a>  */
	public static final String NAME_R_HUMERAL_LATERAL_EPICONDYLE = "r_humeral_lateral_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_lateral_epicondyle</i>" has unique index 66
	 * @see #NAME_R_HUMERAL_LATERAL_EPICONDYLE */
	public static final int NAME_R_HUMERAL_LATERAL_EPICONDYLE_INDEX = 66;
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_lateral_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_HUMERAL_LATERAL_EPICONDYLE */
	public static final int NAME_R_HUMERAL_LATERAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_lateral_epicondyle</i>" has unique parent "<i>r_upperarm</i>" in HAnimSegment
	 * @see #NAME_R_HUMERAL_LATERAL_EPICONDYLE
	 * @see HAnimSegment#NAME_R_UPPERARM */
	public static final String NAME_R_HUMERAL_LATERAL_EPICONDYLE_PARENT = "r_upperarm";
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_lateral_epicondyle</i>" has alias  (TODO tokenize array)"<i>r_humeral_lateral_epicn,r_humeral_lateral_epicondyles</i>" */
	public static final String NAME_R_HUMERAL_LATERAL_EPICONDYLE_ALIAS = "r_humeral_lateral_epicn,r_humeral_lateral_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_humeral_medial_epicondyle"</i> (Java syntax) or <i>r_humeral_medial_epicondyle</i> (XML syntax).
	 * @see #NAME_R_HUMERAL_MEDIAL_EPICONDYLE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_humerus" target="_blank">https://en.wikipedia.org/wiki/Medial_epicondyle_of_the_humerus</a>  */
	public static final String NAME_R_HUMERAL_MEDIAL_EPICONDYLE = "r_humeral_medial_epicondyle";
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_medial_epicondyle</i>" has unique index 67
	 * @see #NAME_R_HUMERAL_MEDIAL_EPICONDYLE */
	public static final int NAME_R_HUMERAL_MEDIAL_EPICONDYLE_INDEX = 67;
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_medial_epicondyle</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_HUMERAL_MEDIAL_EPICONDYLE */
	public static final int NAME_R_HUMERAL_MEDIAL_EPICONDYLE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_medial_epicondyle</i>" has unique parent "<i>r_forearm</i>" in HAnimSegment
	 * @see #NAME_R_HUMERAL_MEDIAL_EPICONDYLE
	 * @see HAnimSegment#NAME_R_FOREARM */
	public static final String NAME_R_HUMERAL_MEDIAL_EPICONDYLE_PARENT = "r_forearm";
	/** SFString xs:NMTOKEN enumeration value "<i>r_humeral_medial_epicondyle</i>" has alias  (TODO tokenize array)"<i>r_humeral_medial_epicn,r_humeral_medial_epicondyles</i>" */
	public static final String NAME_R_HUMERAL_MEDIAL_EPICONDYLE_ALIAS = "r_humeral_medial_epicn,r_humeral_medial_epicondyles";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_olecranon"</i> (Java syntax) or <i>r_olecranon</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Olecranon" target="_blank">https://en.wikipedia.org/wiki/Olecranon</a>  */
	public static final String NAME_R_OLECRANON = "r_olecranon";
	/** SFString xs:NMTOKEN enumeration value "<i>r_olecranon</i>" has unique index 68
	 * @see #NAME_R_OLECRANON */
	public static final int NAME_R_OLECRANON_INDEX = 68;
	/** SFString xs:NMTOKEN enumeration value "<i>r_olecranon</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_OLECRANON */
	public static final int NAME_R_OLECRANON_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_olecranon</i>" has unique parent "<i>r_forearm</i>" in HAnimSegment
	 * @see #NAME_R_OLECRANON
	 * @see HAnimSegment#NAME_R_FOREARM */
	public static final String NAME_R_OLECRANON_PARENT = "r_forearm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_radiale"</i> (Java syntax) or <i>l_radiale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Carpal_bones" target="_blank">https://en.wikipedia.org/wiki/Carpal_bones</a>  */
	public static final String NAME_L_RADIALE = "l_radiale";
	/** SFString xs:NMTOKEN enumeration value "<i>l_radiale</i>" has unique index 69
	 * @see #NAME_L_RADIALE */
	public static final int NAME_L_RADIALE_INDEX = 69;
	/** SFString xs:NMTOKEN enumeration value "<i>l_radiale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_RADIALE */
	public static final int NAME_L_RADIALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_radiale</i>" has unique parent "<i>l_forearm</i>" in HAnimSegment
	 * @see #NAME_L_RADIALE
	 * @see HAnimSegment#NAME_L_FOREARM */
	public static final String NAME_L_RADIALE_PARENT = "l_forearm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_ulnar_styloid"</i> (Java syntax) or <i>l_ulnar_styloid</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Ulnar_styloid_process" target="_blank">https://en.wikipedia.org/wiki/Ulnar_styloid_process</a>  */
	public static final String NAME_L_ULNAR_STYLOID = "l_ulnar_styloid";
	/** SFString xs:NMTOKEN enumeration value "<i>l_ulnar_styloid</i>" has unique index 70
	 * @see #NAME_L_ULNAR_STYLOID */
	public static final int NAME_L_ULNAR_STYLOID_INDEX = 70;
	/** SFString xs:NMTOKEN enumeration value "<i>l_ulnar_styloid</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_ULNAR_STYLOID */
	public static final int NAME_L_ULNAR_STYLOID_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_ulnar_styloid</i>" has unique parent "<i>l_carpal</i>" in HAnimSegment
	 * @see #NAME_L_ULNAR_STYLOID
	 * @see HAnimSegment#NAME_L_CARPAL */
	public static final String NAME_L_ULNAR_STYLOID_PARENT = "l_carpal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_radial_styloid"</i> (Java syntax) or <i>l_radial_styloid</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Radial_styloid_process" target="_blank">https://en.wikipedia.org/wiki/Radial_styloid_process</a>  */
	public static final String NAME_L_RADIAL_STYLOID = "l_radial_styloid";
	/** SFString xs:NMTOKEN enumeration value "<i>l_radial_styloid</i>" has unique index 71
	 * @see #NAME_L_RADIAL_STYLOID */
	public static final int NAME_L_RADIAL_STYLOID_INDEX = 71;
	/** SFString xs:NMTOKEN enumeration value "<i>l_radial_styloid</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_RADIAL_STYLOID */
	public static final int NAME_L_RADIAL_STYLOID_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_radial_styloid</i>" has unique parent "<i>l_forearm</i>" in HAnimSegment
	 * @see #NAME_L_RADIAL_STYLOID
	 * @see HAnimSegment#NAME_L_FOREARM */
	public static final String NAME_L_RADIAL_STYLOID_PARENT = "l_forearm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_radiale"</i> (Java syntax) or <i>r_radiale</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Carpal_bones" target="_blank">https://en.wikipedia.org/wiki/Carpal_bones</a>  */
	public static final String NAME_R_RADIALE = "r_radiale";
	/** SFString xs:NMTOKEN enumeration value "<i>r_radiale</i>" has unique index 72
	 * @see #NAME_R_RADIALE */
	public static final int NAME_R_RADIALE_INDEX = 72;
	/** SFString xs:NMTOKEN enumeration value "<i>r_radiale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_RADIALE */
	public static final int NAME_R_RADIALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_radiale</i>" has unique parent "<i>r_forearm</i>" in HAnimSegment
	 * @see #NAME_R_RADIALE
	 * @see HAnimSegment#NAME_R_FOREARM */
	public static final String NAME_R_RADIALE_PARENT = "r_forearm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_ulnar_styloid"</i> (Java syntax) or <i>r_ulnar_styloid</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Ulnar_styloid_process" target="_blank">https://en.wikipedia.org/wiki/Ulnar_styloid_process</a>  */
	public static final String NAME_R_ULNAR_STYLOID = "r_ulnar_styloid";
	/** SFString xs:NMTOKEN enumeration value "<i>r_ulnar_styloid</i>" has unique index 73
	 * @see #NAME_R_ULNAR_STYLOID */
	public static final int NAME_R_ULNAR_STYLOID_INDEX = 73;
	/** SFString xs:NMTOKEN enumeration value "<i>r_ulnar_styloid</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_ULNAR_STYLOID */
	public static final int NAME_R_ULNAR_STYLOID_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_ulnar_styloid</i>" has unique parent "<i>r_carpal</i>" in HAnimSegment
	 * @see #NAME_R_ULNAR_STYLOID
	 * @see HAnimSegment#NAME_R_CARPAL */
	public static final String NAME_R_ULNAR_STYLOID_PARENT = "r_carpal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_radial_styloid"</i> (Java syntax) or <i>r_radial_styloid</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Radial_styloid_process" target="_blank">https://en.wikipedia.org/wiki/Radial_styloid_process</a>  */
	public static final String NAME_R_RADIAL_STYLOID = "r_radial_styloid";
	/** SFString xs:NMTOKEN enumeration value "<i>r_radial_styloid</i>" has unique index 74
	 * @see #NAME_R_RADIAL_STYLOID */
	public static final int NAME_R_RADIAL_STYLOID_INDEX = 74;
	/** SFString xs:NMTOKEN enumeration value "<i>r_radial_styloid</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_RADIAL_STYLOID */
	public static final int NAME_R_RADIAL_STYLOID_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_radial_styloid</i>" has unique parent "<i>r_forearm</i>" in HAnimSegment
	 * @see #NAME_R_RADIAL_STYLOID
	 * @see HAnimSegment#NAME_R_FOREARM */
	public static final String NAME_R_RADIAL_STYLOID_PARENT = "r_forearm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_metacarpal_phalanx_2"</i> (Java syntax) or <i>l_metacarpal_phalanx_2</i> (XML syntax).
	 * @see #NAME_L_METACARPAL_PHALANX_2_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metacarpal_bones" target="_blank">https://en.wikipedia.org/wiki/Metacarpal_bones</a>  */
	public static final String NAME_L_METACARPAL_PHALANX_2 = "l_metacarpal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_2</i>" has unique index 75
	 * @see #NAME_L_METACARPAL_PHALANX_2 */
	public static final int NAME_L_METACARPAL_PHALANX_2_INDEX = 75;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_2</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_METACARPAL_PHALANX_2 */
	public static final int NAME_L_METACARPAL_PHALANX_2_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_2</i>" has unique parent "<i>l_metacarpal_2</i>" in HAnimSegment
	 * @see #NAME_L_METACARPAL_PHALANX_2
	 * @see HAnimSegment#NAME_L_METACARPAL_2 */
	public static final String NAME_L_METACARPAL_PHALANX_2_PARENT = "l_metacarpal_2";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_2</i>" has alias  (TODO tokenize array)"<i>l_metacarpal_pha2,l_metacarpal_phalanx</i>" */
	public static final String NAME_L_METACARPAL_PHALANX_2_ALIAS = "l_metacarpal_pha2,l_metacarpal_phalanx";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_metacarpal_phalanx_3"</i> (Java syntax) or <i>l_metacarpal_phalanx_3</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metacarpal_bones" target="_blank">https://en.wikipedia.org/wiki/Metacarpal_bones</a>  */
	public static final String NAME_L_METACARPAL_PHALANX_3 = "l_metacarpal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_3</i>" has unique index 76
	 * @see #NAME_L_METACARPAL_PHALANX_3 */
	public static final int NAME_L_METACARPAL_PHALANX_3_INDEX = 76;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_3</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_METACARPAL_PHALANX_3 */
	public static final int NAME_L_METACARPAL_PHALANX_3_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_3</i>" has unique parent "<i>l_metacarpal_3</i>" in HAnimSegment
	 * @see #NAME_L_METACARPAL_PHALANX_3
	 * @see HAnimSegment#NAME_L_METACARPAL_3 */
	public static final String NAME_L_METACARPAL_PHALANX_3_PARENT = "l_metacarpal_3";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_metacarpal_phalanx_5"</i> (Java syntax) or <i>l_metacarpal_phalanx_5</i> (XML syntax).
	 * @see #NAME_L_METACARPAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metacarpal_bones" target="_blank">https://en.wikipedia.org/wiki/Metacarpal_bones</a>  */
	public static final String NAME_L_METACARPAL_PHALANX_5 = "l_metacarpal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_5</i>" has unique index 77
	 * @see #NAME_L_METACARPAL_PHALANX_5 */
	public static final int NAME_L_METACARPAL_PHALANX_5_INDEX = 77;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_5</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_METACARPAL_PHALANX_5 */
	public static final int NAME_L_METACARPAL_PHALANX_5_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_5</i>" has unique parent "<i>l_metacarpal_5</i>" in HAnimSegment
	 * @see #NAME_L_METACARPAL_PHALANX_5
	 * @see HAnimSegment#NAME_L_METACARPAL_5 */
	public static final String NAME_L_METACARPAL_PHALANX_5_PARENT = "l_metacarpal_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_metacarpal_phalanx_5</i>" has alias "<i>l_metacarpal_pha5</i>"
	 * @see #NAME_L_METACARPAL_PHALANX_5 */
	public static final String NAME_L_METACARPAL_PHALANX_5_ALIAS = "l_metacarpal_pha5";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_metacarpal_phalanx_2"</i> (Java syntax) or <i>r_metacarpal_phalanx_2</i> (XML syntax).
	 * @see #NAME_R_METACARPAL_PHALANX_2_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metacarpal_bones" target="_blank">https://en.wikipedia.org/wiki/Metacarpal_bones</a>  */
	public static final String NAME_R_METACARPAL_PHALANX_2 = "r_metacarpal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_2</i>" has unique index 78
	 * @see #NAME_R_METACARPAL_PHALANX_2 */
	public static final int NAME_R_METACARPAL_PHALANX_2_INDEX = 78;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_2</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_METACARPAL_PHALANX_2 */
	public static final int NAME_R_METACARPAL_PHALANX_2_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_2</i>" has unique parent "<i>r_metacarpal_2</i>" in HAnimSegment
	 * @see #NAME_R_METACARPAL_PHALANX_2
	 * @see HAnimSegment#NAME_R_METACARPAL_2 */
	public static final String NAME_R_METACARPAL_PHALANX_2_PARENT = "r_metacarpal_2";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_2</i>" has alias  (TODO tokenize array)"<i>r_metacarpal_pha2,r_metacarpal_phalanx</i>" */
	public static final String NAME_R_METACARPAL_PHALANX_2_ALIAS = "r_metacarpal_pha2,r_metacarpal_phalanx";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_metacarpal_phalanx_3"</i> (Java syntax) or <i>r_metacarpal_phalanx_3</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metacarpal_bones" target="_blank">https://en.wikipedia.org/wiki/Metacarpal_bones</a>  */
	public static final String NAME_R_METACARPAL_PHALANX_3 = "r_metacarpal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_3</i>" has unique index 79
	 * @see #NAME_R_METACARPAL_PHALANX_3 */
	public static final int NAME_R_METACARPAL_PHALANX_3_INDEX = 79;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_3</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_METACARPAL_PHALANX_3 */
	public static final int NAME_R_METACARPAL_PHALANX_3_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_3</i>" has unique parent "<i>r_metacarpal_3</i>" in HAnimSegment
	 * @see #NAME_R_METACARPAL_PHALANX_3
	 * @see HAnimSegment#NAME_R_METACARPAL_3 */
	public static final String NAME_R_METACARPAL_PHALANX_3_PARENT = "r_metacarpal_3";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_metacarpal_phalanx_5"</i> (Java syntax) or <i>r_metacarpal_phalanx_5</i> (XML syntax).
	 * @see #NAME_R_METACARPAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Metacarpal_bones" target="_blank">https://en.wikipedia.org/wiki/Metacarpal_bones</a>  */
	public static final String NAME_R_METACARPAL_PHALANX_5 = "r_metacarpal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_5</i>" has unique index 80
	 * @see #NAME_R_METACARPAL_PHALANX_5 */
	public static final int NAME_R_METACARPAL_PHALANX_5_INDEX = 80;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_5</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_METACARPAL_PHALANX_5 */
	public static final int NAME_R_METACARPAL_PHALANX_5_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_5</i>" has unique parent "<i>r_metacarpal_5</i>" in HAnimSegment
	 * @see #NAME_R_METACARPAL_PHALANX_5
	 * @see HAnimSegment#NAME_R_METACARPAL_5 */
	public static final String NAME_R_METACARPAL_PHALANX_5_PARENT = "r_metacarpal_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_metacarpal_phalanx_5</i>" has alias "<i>r_metacarpal_pha5</i>"
	 * @see #NAME_R_METACARPAL_PHALANX_5 */
	public static final String NAME_R_METACARPAL_PHALANX_5_ALIAS = "r_metacarpal_pha5";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"nuchale"</i> (Java syntax) or <i>nuchale</i> (XML syntax).
	 * @see #NAME_NUCHALE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Squamous_part_of_occipital_bone" target="_blank">https://en.wikipedia.org/wiki/Squamous_part_of_occipital_bone</a>  */
	public static final String NAME_NUCHALE = "nuchale";
	/** SFString xs:NMTOKEN enumeration value "<i>nuchale</i>" has unique index 81
	 * @see #NAME_NUCHALE */
	public static final int NAME_NUCHALE_INDEX = 81;
	/** SFString xs:NMTOKEN enumeration value "<i>nuchale</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_NUCHALE */
	public static final int NAME_NUCHALE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>nuchale</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_NUCHALE
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_NUCHALE_PARENT = "skull";
	/** SFString xs:NMTOKEN enumeration value "<i>nuchale</i>" has alias "<i>nuchal</i>"
	 * @see #NAME_NUCHALE */
	public static final String NAME_NUCHALE_ALIAS = "nuchal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_neck_base"</i> (Java syntax) or <i>l_neck_base</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Neck" target="_blank">https://en.wikipedia.org/wiki/Neck</a>  */
	public static final String NAME_L_NECK_BASE = "l_neck_base";
	/** SFString xs:NMTOKEN enumeration value "<i>l_neck_base</i>" has unique index 82
	 * @see #NAME_L_NECK_BASE */
	public static final int NAME_L_NECK_BASE_INDEX = 82;
	/** SFString xs:NMTOKEN enumeration value "<i>l_neck_base</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_L_NECK_BASE */
	public static final int NAME_L_NECK_BASE_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>l_neck_base</i>" has unique parent "<i>c7</i>" in HAnimSegment
	 * @see #NAME_L_NECK_BASE
	 * @see HAnimSegment#NAME_C7 */
	public static final String NAME_L_NECK_BASE_PARENT = "c7";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_neck_base"</i> (Java syntax) or <i>r_neck_base</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Neck" target="_blank">https://en.wikipedia.org/wiki/Neck</a>  */
	public static final String NAME_R_NECK_BASE = "r_neck_base";
	/** SFString xs:NMTOKEN enumeration value "<i>r_neck_base</i>" has unique index 83
	 * @see #NAME_R_NECK_BASE */
	public static final int NAME_R_NECK_BASE_INDEX = 83;
	/** SFString xs:NMTOKEN enumeration value "<i>r_neck_base</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_R_NECK_BASE */
	public static final int NAME_R_NECK_BASE_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>r_neck_base</i>" has unique parent "<i>c7</i>" in HAnimSegment
	 * @see #NAME_R_NECK_BASE
	 * @see HAnimSegment#NAME_C7 */
	public static final String NAME_R_NECK_BASE_PARENT = "c7";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"navel"</i> (Java syntax) or <i>navel</i> (XML syntax).
	 * @see #NAME_NAVEL_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Navel" target="_blank">https://en.wikipedia.org/wiki/Navel</a>  */
	public static final String NAME_NAVEL = "navel";
	/** SFString xs:NMTOKEN enumeration value "<i>navel</i>" has unique index 84
	 * @see #NAME_NAVEL */
	public static final int NAME_NAVEL_INDEX = 84;
	/** SFString xs:NMTOKEN enumeration value "<i>navel</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_NAVEL */
	public static final int NAME_NAVEL_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>navel</i>" has unique parent "<i>l5</i>" in HAnimSegment
	 * @see #NAME_NAVEL
	 * @see HAnimSegment#NAME_L5 */
	public static final String NAME_NAVEL_PARENT = "l5";
	/** SFString xs:NMTOKEN enumeration value "<i>navel</i>" has alias "<i>belly button</i>"
	 * @see #NAME_NAVEL */
	public static final String NAME_NAVEL_ALIAS = "belly button";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_ectocanthus"</i> (Java syntax) or <i>l_ectocanthus</i> (XML syntax).
	 * @see #NAME_L_ECTOCANTHUS_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Canthus" target="_blank">https://en.wikipedia.org/wiki/Canthus</a>  */
	public static final String NAME_L_ECTOCANTHUS = "l_ectocanthus";
	/** SFString xs:NMTOKEN enumeration value "<i>l_ectocanthus</i>" has unique index 85
	 * @see #NAME_L_ECTOCANTHUS */
	public static final int NAME_L_ECTOCANTHUS_INDEX = 85;
	/** SFString xs:NMTOKEN enumeration value "<i>l_ectocanthus</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_ECTOCANTHUS */
	public static final int NAME_L_ECTOCANTHUS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_ectocanthus</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_L_ECTOCANTHUS
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_L_ECTOCANTHUS_PARENT = "skull";
	/** SFString xs:NMTOKEN enumeration value "<i>l_ectocanthus</i>" has alias "<i>l_canthus</i>"
	 * @see #NAME_L_ECTOCANTHUS */
	public static final String NAME_L_ECTOCANTHUS_ALIAS = "l_canthus";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_ectocanthus"</i> (Java syntax) or <i>r_ectocanthus</i> (XML syntax).
	 * @see #NAME_R_ECTOCANTHUS_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Canthus" target="_blank">https://en.wikipedia.org/wiki/Canthus</a>  */
	public static final String NAME_R_ECTOCANTHUS = "r_ectocanthus";
	/** SFString xs:NMTOKEN enumeration value "<i>r_ectocanthus</i>" has unique index 86
	 * @see #NAME_R_ECTOCANTHUS */
	public static final int NAME_R_ECTOCANTHUS_INDEX = 86;
	/** SFString xs:NMTOKEN enumeration value "<i>r_ectocanthus</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_ECTOCANTHUS */
	public static final int NAME_R_ECTOCANTHUS_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_ectocanthus</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_R_ECTOCANTHUS
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_R_ECTOCANTHUS_PARENT = "skull";
	/** SFString xs:NMTOKEN enumeration value "<i>r_ectocanthus</i>" has alias "<i>r_canthus</i>"
	 * @see #NAME_R_ECTOCANTHUS */
	public static final String NAME_R_ECTOCANTHUS_ALIAS = "r_canthus";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"menton"</i> (Java syntax) or <i>menton</i> (XML syntax).
	 * @see #NAME_MENTON_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Human_head" target="_blank">https://en.wikipedia.org/wiki/Human_head</a>  */
	public static final String NAME_MENTON = "menton";
	/** SFString xs:NMTOKEN enumeration value "<i>menton</i>" has unique index 87
	 * @see #NAME_MENTON */
	public static final int NAME_MENTON_INDEX = 87;
	/** SFString xs:NMTOKEN enumeration value "<i>menton</i>" has unique Level Of Articulation loa=3
	 * @see #NAME_MENTON */
	public static final int NAME_MENTON_LOA = 3;
	/** SFString xs:NMTOKEN enumeration value "<i>menton</i>" has unique parent "<i>jaw</i>" in HAnimSegment
	 * @see #NAME_MENTON
	 * @see HAnimSegment#NAME_JAW */
	public static final String NAME_MENTON_PARENT = "jaw";
	/** SFString xs:NMTOKEN enumeration value "<i>menton</i>" has alias "<i>chin</i>"
	 * @see #NAME_MENTON */
	public static final String NAME_MENTON_ALIAS = "chin";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"mesosternale"</i> (Java syntax) or <i>mesosternale</i> (XML syntax).
	 * @see #NAME_MESOSTERNALE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wiktionary.org/wiki/mesosternum" target="_blank">https://en.wiktionary.org/wiki/mesosternum</a>  */
	public static final String NAME_MESOSTERNALE = "mesosternale";
	/** SFString xs:NMTOKEN enumeration value "<i>mesosternale</i>" has unique index 88
	 * @see #NAME_MESOSTERNALE */
	public static final int NAME_MESOSTERNALE_INDEX = 88;
	/** SFString xs:NMTOKEN enumeration value "<i>mesosternale</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_MESOSTERNALE */
	public static final int NAME_MESOSTERNALE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>mesosternale</i>" has unique parent "<i>t6</i>" in HAnimSegment
	 * @see #NAME_MESOSTERNALE
	 * @see HAnimSegment#NAME_T6 */
	public static final String NAME_MESOSTERNALE_PARENT = "t6";
	/** SFString xs:NMTOKEN enumeration value "<i>mesosternale</i>" has alias "<i>mesosternum</i>"
	 * @see #NAME_MESOSTERNALE */
	public static final String NAME_MESOSTERNALE_ALIAS = "mesosternum";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"opisthocranion"</i> (Java syntax) or <i>opisthocranion</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://www.columbia.edu/itc/hs/medical/humanAnatomy/yuan/craniologyISlides.pdf" target="_blank">https://www.columbia.edu/itc/hs/medical/humanAnatomy/yuan/craniologyISlides.pdf</a>  */
	public static final String NAME_OPISTHOCRANION = "opisthocranion";
	/** SFString xs:NMTOKEN enumeration value "<i>opisthocranion</i>" has unique index 89
	 * @see #NAME_OPISTHOCRANION */
	public static final int NAME_OPISTHOCRANION_INDEX = 89;
	/** SFString xs:NMTOKEN enumeration value "<i>opisthocranion</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_OPISTHOCRANION */
	public static final int NAME_OPISTHOCRANION_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>opisthocranion</i>" has unique parent "<i>skull</i>" in HAnimSegment
	 * @see #NAME_OPISTHOCRANION
	 * @see HAnimSegment#NAME_SKULL */
	public static final String NAME_OPISTHOCRANION_PARENT = "skull";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_knee_crease"</i> (Java syntax) or <i>l_knee_crease</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Popliteal_fossa" target="_blank">https://en.wikipedia.org/wiki/Popliteal_fossa</a>  */
	public static final String NAME_L_KNEE_CREASE = "l_knee_crease";
	/** SFString xs:NMTOKEN enumeration value "<i>l_knee_crease</i>" has unique index 90
	 * @see #NAME_L_KNEE_CREASE */
	public static final int NAME_L_KNEE_CREASE_INDEX = 90;
	/** SFString xs:NMTOKEN enumeration value "<i>l_knee_crease</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_KNEE_CREASE */
	public static final int NAME_L_KNEE_CREASE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_knee_crease</i>" has unique parent "<i>l_thigh</i>" in HAnimSegment
	 * @see #NAME_L_KNEE_CREASE
	 * @see HAnimSegment#NAME_L_THIGH */
	public static final String NAME_L_KNEE_CREASE_PARENT = "l_thigh";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_knee_crease"</i> (Java syntax) or <i>r_knee_crease</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Popliteal_fossa" target="_blank">https://en.wikipedia.org/wiki/Popliteal_fossa</a>  */
	public static final String NAME_R_KNEE_CREASE = "r_knee_crease";
	/** SFString xs:NMTOKEN enumeration value "<i>r_knee_crease</i>" has unique index 91
	 * @see #NAME_R_KNEE_CREASE */
	public static final int NAME_R_KNEE_CREASE_INDEX = 91;
	/** SFString xs:NMTOKEN enumeration value "<i>r_knee_crease</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_KNEE_CREASE */
	public static final int NAME_R_KNEE_CREASE_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_knee_crease</i>" has unique parent "<i>r_thigh</i>" in HAnimSegment
	 * @see #NAME_R_KNEE_CREASE
	 * @see HAnimSegment#NAME_R_THIGH */
	public static final String NAME_R_KNEE_CREASE_PARENT = "r_thigh";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"rear_center_midsagittal_plane"</i> (Java syntax) or <i>rear_center_midsagittal_plane</i> (XML syntax).
	 * @see #NAME_REAR_CENTER_MIDSAGITTAL_PLANE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Median_plane" target="_blank">https://en.wikipedia.org/wiki/Median_plane</a>  */
	public static final String NAME_REAR_CENTER_MIDSAGITTAL_PLANE = "rear_center_midsagittal_plane";
	/** SFString xs:NMTOKEN enumeration value "<i>rear_center_midsagittal_plane</i>" has unique index 92
	 * @see #NAME_REAR_CENTER_MIDSAGITTAL_PLANE */
	public static final int NAME_REAR_CENTER_MIDSAGITTAL_PLANE_INDEX = 92;
	/** SFString xs:NMTOKEN enumeration value "<i>rear_center_midsagittal_plane</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_REAR_CENTER_MIDSAGITTAL_PLANE */
	public static final int NAME_REAR_CENTER_MIDSAGITTAL_PLANE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>rear_center_midsagittal_plane</i>" has unique parent "<i>t6</i>" in HAnimSegment
	 * @see #NAME_REAR_CENTER_MIDSAGITTAL_PLANE
	 * @see HAnimSegment#NAME_T6 */
	public static final String NAME_REAR_CENTER_MIDSAGITTAL_PLANE_PARENT = "t6";
	/** SFString xs:NMTOKEN enumeration value "<i>rear_center_midsagittal_plane</i>" has alias "<i>median plane</i>"
	 * @see #NAME_REAR_CENTER_MIDSAGITTAL_PLANE */
	public static final String NAME_REAR_CENTER_MIDSAGITTAL_PLANE_ALIAS = "median plane";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"buttocks_standing_wall_contact_point"</i> (Java syntax) or <i>buttocks_standing_wall_contact_point</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Buttocks" target="_blank">https://en.wikipedia.org/wiki/Buttocks</a>  */
	public static final String NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT = "buttocks_standing_wall_contact_point";
	/** SFString xs:NMTOKEN enumeration value "<i>buttocks_standing_wall_contact_point</i>" has unique index 93
	 * @see #NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT */
	public static final int NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT_INDEX = 93;
	/** SFString xs:NMTOKEN enumeration value "<i>buttocks_standing_wall_contact_point</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT */
	public static final int NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>buttocks_standing_wall_contact_point</i>" has unique parent "<i>pelvis</i>" in HAnimSegment
	 * @see #NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT
	 * @see HAnimSegment#NAME_PELVIS */
	public static final String NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT_PARENT = "pelvis";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_chest_midsagittal_plane"</i> (Java syntax) or <i>l_chest_midsagittal_plane</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Sagittal_plane" target="_blank">https://en.wikipedia.org/wiki/Sagittal_plane</a>  */
	public static final String NAME_L_CHEST_MIDSAGITTAL_PLANE = "l_chest_midsagittal_plane";
	/** SFString xs:NMTOKEN enumeration value "<i>l_chest_midsagittal_plane</i>" has unique index 94
	 * @see #NAME_L_CHEST_MIDSAGITTAL_PLANE */
	public static final int NAME_L_CHEST_MIDSAGITTAL_PLANE_INDEX = 94;
	/** SFString xs:NMTOKEN enumeration value "<i>l_chest_midsagittal_plane</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_CHEST_MIDSAGITTAL_PLANE */
	public static final int NAME_L_CHEST_MIDSAGITTAL_PLANE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_chest_midsagittal_plane</i>" has unique parent "<i>t6</i>" in HAnimSegment
	 * @see #NAME_L_CHEST_MIDSAGITTAL_PLANE
	 * @see HAnimSegment#NAME_T6 */
	public static final String NAME_L_CHEST_MIDSAGITTAL_PLANE_PARENT = "t6";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_chest_midsagittal_plane"</i> (Java syntax) or <i>r_chest_midsagittal_plane</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Sagittal_plane" target="_blank">https://en.wikipedia.org/wiki/Sagittal_plane</a>  */
	public static final String NAME_R_CHEST_MIDSAGITTAL_PLANE = "r_chest_midsagittal_plane";
	/** SFString xs:NMTOKEN enumeration value "<i>r_chest_midsagittal_plane</i>" has unique index 95
	 * @see #NAME_R_CHEST_MIDSAGITTAL_PLANE */
	public static final int NAME_R_CHEST_MIDSAGITTAL_PLANE_INDEX = 95;
	/** SFString xs:NMTOKEN enumeration value "<i>r_chest_midsagittal_plane</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_CHEST_MIDSAGITTAL_PLANE */
	public static final int NAME_R_CHEST_MIDSAGITTAL_PLANE_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_chest_midsagittal_plane</i>" has unique parent "<i>t6</i>" in HAnimSegment
	 * @see #NAME_R_CHEST_MIDSAGITTAL_PLANE
	 * @see HAnimSegment#NAME_T6 */
	public static final String NAME_R_CHEST_MIDSAGITTAL_PLANE_PARENT = "t6";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_bideltoid"</i> (Java syntax) or <i>l_bideltoid</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wiktionary.org/wiki/bideltoid" target="_blank">https://en.wiktionary.org/wiki/bideltoid</a>  */
	public static final String NAME_L_BIDELTOID = "l_bideltoid";
	/** SFString xs:NMTOKEN enumeration value "<i>l_bideltoid</i>" has unique index 96
	 * @see #NAME_L_BIDELTOID */
	public static final int NAME_L_BIDELTOID_INDEX = 96;
	/** SFString xs:NMTOKEN enumeration value "<i>l_bideltoid</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_L_BIDELTOID */
	public static final int NAME_L_BIDELTOID_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>l_bideltoid</i>" has unique parent "<i>l_upperarm</i>" in HAnimSegment
	 * @see #NAME_L_BIDELTOID
	 * @see HAnimSegment#NAME_L_UPPERARM */
	public static final String NAME_L_BIDELTOID_PARENT = "l_upperarm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_bideltoid"</i> (Java syntax) or <i>r_bideltoid</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wiktionary.org/wiki/bideltoid" target="_blank">https://en.wiktionary.org/wiki/bideltoid</a>  */
	public static final String NAME_R_BIDELTOID = "r_bideltoid";
	/** SFString xs:NMTOKEN enumeration value "<i>r_bideltoid</i>" has unique index 97
	 * @see #NAME_R_BIDELTOID */
	public static final int NAME_R_BIDELTOID_INDEX = 97;
	/** SFString xs:NMTOKEN enumeration value "<i>r_bideltoid</i>" has unique Level Of Articulation loa=1
	 * @see #NAME_R_BIDELTOID */
	public static final int NAME_R_BIDELTOID_LOA = 1;
	/** SFString xs:NMTOKEN enumeration value "<i>r_bideltoid</i>" has unique parent "<i>r_upperarm</i>" in HAnimSegment
	 * @see #NAME_R_BIDELTOID
	 * @see HAnimSegment#NAME_R_UPPERARM */
	public static final String NAME_R_BIDELTOID_PARENT = "r_upperarm";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_carpal_distal_phalanx_1"</i> (Java syntax) or <i>l_carpal_distal_phalanx_1</i> (XML syntax).
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_1_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_1 = "l_carpal_distal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_1</i>" has unique index 101
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_1 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_1_INDEX = 101;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_1</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_1 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_1_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_1</i>" has unique parent "<i>l_carpal_distal_phalanx_1</i>" in HAnimSegment
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_1
	 * @see HAnimSegment#NAME_L_CARPAL_DISTAL_PHALANX_1 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_1_PARENT = "l_carpal_distal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_1</i>" has alias "<i>l_thumb_distal</i>"
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_1 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_1_ALIAS = "l_thumb_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_carpal_distal_phalanx_2"</i> (Java syntax) or <i>l_carpal_distal_phalanx_2</i> (XML syntax).
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_2_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_2 = "l_carpal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_2</i>" has unique index 102
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_2 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_2_INDEX = 102;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_2</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_2 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_2_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_2</i>" has unique parent "<i>l_carpal_distal_phalanx_2</i>" in HAnimSegment
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_2
	 * @see HAnimSegment#NAME_L_CARPAL_DISTAL_PHALANX_2 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_2_PARENT = "l_carpal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_2</i>" has alias "<i>l_index_distal</i>"
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_2 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_2_ALIAS = "l_index_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_carpal_distal_phalanx_3"</i> (Java syntax) or <i>l_carpal_distal_phalanx_3</i> (XML syntax).
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_3_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_3 = "l_carpal_distal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_3</i>" has unique index 103
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_3 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_3_INDEX = 103;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_3</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_3 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_3_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_3</i>" has unique parent "<i>l_carpal_distal_phalanx_3</i>" in HAnimSegment
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_3
	 * @see HAnimSegment#NAME_L_CARPAL_DISTAL_PHALANX_3 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_3_PARENT = "l_carpal_distal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_3</i>" has alias "<i>l_middle_distal</i>"
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_3 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_3_ALIAS = "l_middle_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_carpal_distal_phalanx_4"</i> (Java syntax) or <i>l_carpal_distal_phalanx_4</i> (XML syntax).
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_4_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_4 = "l_carpal_distal_phalanx_4";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_4</i>" has unique index 104
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_4 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_4_INDEX = 104;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_4</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_4 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_4_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_4</i>" has unique parent "<i>l_carpal_distal_phalanx_4</i>" in HAnimSegment
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_4
	 * @see HAnimSegment#NAME_L_CARPAL_DISTAL_PHALANX_4 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_4_PARENT = "l_carpal_distal_phalanx_4";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_4</i>" has alias "<i>l_ring_distal</i>"
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_4 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_4_ALIAS = "l_ring_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_carpal_distal_phalanx_5"</i> (Java syntax) or <i>l_carpal_distal_phalanx_5</i> (XML syntax).
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_5 = "l_carpal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_5</i>" has unique index 105
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_5 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_5_INDEX = 105;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_5</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_5 */
	public static final int NAME_L_CARPAL_DISTAL_PHALANX_5_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_5</i>" has unique parent "<i>l_carpal_distal_phalanx_5</i>" in HAnimSegment
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_5
	 * @see HAnimSegment#NAME_L_CARPAL_DISTAL_PHALANX_5 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_5_PARENT = "l_carpal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_carpal_distal_phalanx_5</i>" has alias "<i>l_pinky_distal</i>"
	 * @see #NAME_L_CARPAL_DISTAL_PHALANX_5 */
	public static final String NAME_L_CARPAL_DISTAL_PHALANX_5_ALIAS = "l_pinky_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_carpal_distal_phalanx_1"</i> (Java syntax) or <i>r_carpal_distal_phalanx_1</i> (XML syntax).
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_1_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_1 = "r_carpal_distal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_1</i>" has unique index 106
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_1 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_1_INDEX = 106;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_1</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_1 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_1_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_1</i>" has unique parent "<i>r_carpal_distal_phalanx_1</i>" in HAnimSegment
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_1
	 * @see HAnimSegment#NAME_R_CARPAL_DISTAL_PHALANX_1 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_1_PARENT = "r_carpal_distal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_1</i>" has alias "<i>r_thumb_distal</i>"
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_1 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_1_ALIAS = "r_thumb_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_carpal_distal_phalanx_2"</i> (Java syntax) or <i>r_carpal_distal_phalanx_2</i> (XML syntax).
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_2_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_2 = "r_carpal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_2</i>" has unique index 107
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_2 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_2_INDEX = 107;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_2</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_2 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_2_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_2</i>" has unique parent "<i>r_carpal_distal_phalanx_2</i>" in HAnimSegment
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_2
	 * @see HAnimSegment#NAME_R_CARPAL_DISTAL_PHALANX_2 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_2_PARENT = "r_carpal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_2</i>" has alias "<i>r_index_distal</i>"
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_2 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_2_ALIAS = "r_index_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_carpal_distal_phalanx_3"</i> (Java syntax) or <i>r_carpal_distal_phalanx_3</i> (XML syntax).
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_3_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_3 = "r_carpal_distal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_3</i>" has unique index 108
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_3 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_3_INDEX = 108;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_3</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_3 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_3_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_3</i>" has unique parent "<i>r_carpal_distal_phalanx_3</i>" in HAnimSegment
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_3
	 * @see HAnimSegment#NAME_R_CARPAL_DISTAL_PHALANX_3 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_3_PARENT = "r_carpal_distal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_3</i>" has alias "<i>r_middle_distal</i>"
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_3 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_3_ALIAS = "r_middle_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_carpal_distal_phalanx_4"</i> (Java syntax) or <i>r_carpal_distal_phalanx_4</i> (XML syntax).
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_4_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_4 = "r_carpal_distal_phalanx_4";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_4</i>" has unique index 109
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_4 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_4_INDEX = 109;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_4</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_4 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_4_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_4</i>" has unique parent "<i>r_carpal_distal_phalanx_4</i>" in HAnimSegment
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_4
	 * @see HAnimSegment#NAME_R_CARPAL_DISTAL_PHALANX_4 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_4_PARENT = "r_carpal_distal_phalanx_4";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_4</i>" has alias "<i>r_ring_distal</i>"
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_4 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_4_ALIAS = "r_ring_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_carpal_distal_phalanx_5"</i> (Java syntax) or <i>r_carpal_distal_phalanx_5</i> (XML syntax).
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_5 = "r_carpal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_5</i>" has unique index 110
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_5 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_5_INDEX = 110;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_5</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_5 */
	public static final int NAME_R_CARPAL_DISTAL_PHALANX_5_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_5</i>" has unique parent "<i>r_carpal_distal_phalanx_5</i>" in HAnimSegment
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_5
	 * @see HAnimSegment#NAME_R_CARPAL_DISTAL_PHALANX_5 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_5_PARENT = "r_carpal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_carpal_distal_phalanx_5</i>" has alias "<i>r_pinky_distal</i>"
	 * @see #NAME_R_CARPAL_DISTAL_PHALANX_5 */
	public static final String NAME_R_CARPAL_DISTAL_PHALANX_5_ALIAS = "r_pinky_distal";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_tarsal_distal_phalanx_1"</i> (Java syntax) or <i>l_tarsal_distal_phalanx_1</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_1 = "l_tarsal_distal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_1</i>" has unique index 111
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_1 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_1_INDEX = 111;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_1</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_1 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_1_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_1</i>" has unique parent "<i>l_tarsal_distal_phalanx_1</i>" in HAnimSegment
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_1
	 * @see HAnimSegment#NAME_L_TARSAL_DISTAL_PHALANX_1 */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_1_PARENT = "l_tarsal_distal_phalanx_1";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_tarsal_distal_phalanx_2"</i> (Java syntax) or <i>l_tarsal_distal_phalanx_2</i> (XML syntax).
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_2_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_2 = "l_tarsal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_2</i>" has unique index 112
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_2 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_2_INDEX = 112;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_2</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_2 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_2_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_2</i>" has unique parent "<i>l_tarsal_distal_phalanx_2</i>" in HAnimSegment
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_2
	 * @see HAnimSegment#NAME_L_TARSAL_DISTAL_PHALANX_2 */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_2_PARENT = "l_tarsal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_2</i>" has alias "<i>l_digit2</i>"
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_2 */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_2_ALIAS = "l_digit2";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_tarsal_distal_phalanx_3"</i> (Java syntax) or <i>l_tarsal_distal_phalanx_3</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_3 = "l_tarsal_distal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_3</i>" has unique index 113
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_3 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_3_INDEX = 113;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_3</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_3 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_3_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_3</i>" has unique parent "<i>l_tarsal_distal_phalanx_3</i>" in HAnimSegment
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_3
	 * @see HAnimSegment#NAME_L_TARSAL_DISTAL_PHALANX_3 */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_3_PARENT = "l_tarsal_distal_phalanx_3";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_tarsal_distal_phalanx_4"</i> (Java syntax) or <i>l_tarsal_distal_phalanx_4</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_4 = "l_tarsal_distal_phalanx_4";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_4</i>" has unique index 114
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_4 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_4_INDEX = 114;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_4</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_4 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_4_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_4</i>" has unique parent "<i>l_tarsal_distal_phalanx_4</i>" in HAnimSegment
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_4
	 * @see HAnimSegment#NAME_L_TARSAL_DISTAL_PHALANX_4 */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_4_PARENT = "l_tarsal_distal_phalanx_4";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"l_tarsal_distal_phalanx_5"</i> (Java syntax) or <i>l_tarsal_distal_phalanx_5</i> (XML syntax).
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_5 = "l_tarsal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_5</i>" has unique index 115
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_5 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_5_INDEX = 115;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_5</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_5 */
	public static final int NAME_L_TARSAL_DISTAL_PHALANX_5_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_5</i>" has unique parent "<i>l_tarsal_distal_phalanx_5</i>" in HAnimSegment
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_5
	 * @see HAnimSegment#NAME_L_TARSAL_DISTAL_PHALANX_5 */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_5_PARENT = "l_tarsal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>l_tarsal_distal_phalanx_5</i>" has alias "<i>l_tarsal_distal_pha5</i>"
	 * @see #NAME_L_TARSAL_DISTAL_PHALANX_5 */
	public static final String NAME_L_TARSAL_DISTAL_PHALANX_5_ALIAS = "l_tarsal_distal_pha5";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_tarsal_distal_phalanx_1"</i> (Java syntax) or <i>r_tarsal_distal_phalanx_1</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_1 = "r_tarsal_distal_phalanx_1";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_1</i>" has unique index 116
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_1 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_1_INDEX = 116;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_1</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_1 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_1_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_1</i>" has unique parent "<i>r_tarsal_distal_phalanx_1</i>" in HAnimSegment
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_1
	 * @see HAnimSegment#NAME_R_TARSAL_DISTAL_PHALANX_1 */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_1_PARENT = "r_tarsal_distal_phalanx_1";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_tarsal_distal_phalanx_2"</i> (Java syntax) or <i>r_tarsal_distal_phalanx_2</i> (XML syntax).
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_2_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_2 = "r_tarsal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_2</i>" has unique index 117
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_2 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_2_INDEX = 117;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_2</i>" has unique Level Of Articulation loa=2
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_2 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_2_LOA = 2;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_2</i>" has unique parent "<i>r_tarsal_distal_phalanx_2</i>" in HAnimSegment
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_2
	 * @see HAnimSegment#NAME_R_TARSAL_DISTAL_PHALANX_2 */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_2_PARENT = "r_tarsal_distal_phalanx_2";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_2</i>" has alias "<i>r_digit2</i>"
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_2 */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_2_ALIAS = "r_digit2";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_tarsal_distal_phalanx_3"</i> (Java syntax) or <i>r_tarsal_distal_phalanx_3</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_3 = "r_tarsal_distal_phalanx_3";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_3</i>" has unique index 118
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_3 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_3_INDEX = 118;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_3</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_3 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_3_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_3</i>" has unique parent "<i>r_tarsal_distal_phalanx_3</i>" in HAnimSegment
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_3
	 * @see HAnimSegment#NAME_R_TARSAL_DISTAL_PHALANX_3 */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_3_PARENT = "r_tarsal_distal_phalanx_3";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_tarsal_distal_phalanx_4"</i> (Java syntax) or <i>r_tarsal_distal_phalanx_4</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_4 = "r_tarsal_distal_phalanx_4";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_4</i>" has unique index 119
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_4 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_4_INDEX = 119;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_4</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_4 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_4_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_4</i>" has unique parent "<i>r_tarsal_distal_phalanx_4</i>" in HAnimSegment
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_4
	 * @see HAnimSegment#NAME_R_TARSAL_DISTAL_PHALANX_4 */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_4_PARENT = "r_tarsal_distal_phalanx_4";

	/** SFString field named <i>name</i> with X3DUOM simpleType <i>hanimFeaturePointNameValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"r_tarsal_distal_phalanx_5"</i> (Java syntax) or <i>r_tarsal_distal_phalanx_5</i> (XML syntax).
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_hanimFeaturePointNameValues.html">XML Schema: hanimFeaturePointNameValues</a>
	 * @see  <a href="https://en.wikipedia.org/wiki/Phalanx_bone" target="_blank">https://en.wikipedia.org/wiki/Phalanx_bone</a>  */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_5 = "r_tarsal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_5</i>" has unique index 120
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_5 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_5_INDEX = 120;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_5</i>" has unique Level Of Articulation loa=4
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_5 */
	public static final int NAME_R_TARSAL_DISTAL_PHALANX_5_LOA = 4;
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_5</i>" has unique parent "<i>r_tarsal_distal_phalanx_5</i>" in HAnimSegment
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_5
	 * @see HAnimSegment#NAME_R_TARSAL_DISTAL_PHALANX_5 */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_5_PARENT = "r_tarsal_distal_phalanx_5";
	/** SFString xs:NMTOKEN enumeration value "<i>r_tarsal_distal_phalanx_5</i>" has alias "<i>r_tarsal_distal_pha5</i>"
	 * @see #NAME_R_TARSAL_DISTAL_PHALANX_5 */
	public static final String NAME_R_TARSAL_DISTAL_PHALANX_5_ALIAS = "r_tarsal_distal_pha5";

	// special enumeration utility methods

        String  namingMessage = new String();
        boolean namingMessageAlreadyProvided = false;

	/** Get index for this name
	 * @param name of interest
	 * @return index value, otherwise -1 if not found
	 */
	public static int getNameIndex(String name)
	{
		if      (name.equalsIgnoreCase(NAME_SKULL_VERTEX)) return NAME_SKULL_VERTEX_INDEX;
		else if (name.equalsIgnoreCase(NAME_GLABELLA)) return NAME_GLABELLA_INDEX;
		else if (name.equalsIgnoreCase(NAME_SELLION)) return NAME_SELLION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_INFRAORBITALE)) return NAME_L_INFRAORBITALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TRAGION)) return NAME_L_TRAGION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_GONION)) return NAME_L_GONION_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_INFRAORBITALE)) return NAME_R_INFRAORBITALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TRAGION)) return NAME_R_TRAGION_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_GONION)) return NAME_R_GONION_INDEX;
		else if (name.equalsIgnoreCase(NAME_SUPRAMENTON)) return NAME_SUPRAMENTON_INDEX;
		else if (name.equalsIgnoreCase(NAME_CERVICALE)) return NAME_CERVICALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_ADAMS_APPLE)) return NAME_ADAMS_APPLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_SUPRASTERNALE)) return NAME_SUPRASTERNALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_SUBSTERNALE)) return NAME_SUBSTERNALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CLAVICLE)) return NAME_L_CLAVICLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_ACROMION)) return NAME_L_ACROMION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_PROXIMAL)) return NAME_L_AXILLA_PROXIMAL_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_DISTAL)) return NAME_L_AXILLA_DISTAL_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_POSTERIOR_FOLDS)) return NAME_L_AXILLA_POSTERIOR_FOLDS_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CLAVICLE)) return NAME_R_CLAVICLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_ACROMION)) return NAME_R_ACROMION_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_PROXIMAL)) return NAME_R_AXILLA_PROXIMAL_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_DISTAL)) return NAME_R_AXILLA_DISTAL_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_POSTERIOR_FOLDS)) return NAME_R_AXILLA_POSTERIOR_FOLDS_INDEX;
		else if (name.equalsIgnoreCase(NAME_SPINE_1_MIDDLE_BACK)) return NAME_SPINE_1_MIDDLE_BACK_INDEX;
		else if (name.equalsIgnoreCase(NAME_SPINE_2_LOWER_BACK)) return NAME_SPINE_2_LOWER_BACK_INDEX;
		else if (name.equalsIgnoreCase(NAME_WAIST_PREFERRED_ANTERIOR)) return NAME_WAIST_PREFERRED_ANTERIOR_INDEX;
		else if (name.equalsIgnoreCase(NAME_WAIST_PREFERRED_POSTERIOR)) return NAME_WAIST_PREFERRED_POSTERIOR_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_RIB10)) return NAME_L_RIB10_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_THELION)) return NAME_L_THELION_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_RIB10)) return NAME_R_RIB10_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_THELION)) return NAME_R_THELION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_ASIS)) return NAME_L_ASIS_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_ILIOCRISTALE)) return NAME_L_ILIOCRISTALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_PSIS)) return NAME_L_PSIS_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_ASIS)) return NAME_R_ASIS_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_ILIOCRISTALE)) return NAME_R_ILIOCRISTALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_PSIS)) return NAME_R_PSIS_INDEX;
		else if (name.equalsIgnoreCase(NAME_CROTCH)) return NAME_CROTCH_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_FEMORAL_LATERAL_EPICONDYLE)) return NAME_L_FEMORAL_LATERAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_L_FEMORAL_MEDIAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_SUPRAPATELLA)) return NAME_L_SUPRAPATELLA_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TROCHANTERION)) return NAME_L_TROCHANTERION_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_FEMORAL_LATERAL_EPICONDYLE)) return NAME_R_FEMORAL_LATERAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_R_FEMORAL_MEDIAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_SUPRAPATELLA)) return NAME_R_SUPRAPATELLA_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TROCHANTERION)) return NAME_R_TROCHANTERION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TIBIALE)) return NAME_L_TIBIALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_MEDIAL_MALLEOLUS)) return NAME_L_MEDIAL_MALLEOLUS_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_LATERAL_MALLEOLUS)) return NAME_L_LATERAL_MALLEOLUS_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_SPHYRION)) return NAME_L_SPHYRION_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TIBIALE)) return NAME_R_TIBIALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_MEDIAL_MALLEOLUS)) return NAME_R_MEDIAL_MALLEOLUS_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_LATERAL_MALLEOLUS)) return NAME_R_LATERAL_MALLEOLUS_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_SPHYRION)) return NAME_R_SPHYRION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_1)) return NAME_L_METATARSAL_PHALANX_1_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_5)) return NAME_L_METATARSAL_PHALANX_5_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_DACTYLION)) return NAME_L_DACTYLION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CALCANEUS_POSTERIOR)) return NAME_L_CALCANEUS_POSTERIOR_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_1)) return NAME_R_METATARSAL_PHALANX_1_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_5)) return NAME_R_METATARSAL_PHALANX_5_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_DACTYLION)) return NAME_R_DACTYLION_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CALCANEUS_POSTERIOR)) return NAME_R_CALCANEUS_POSTERIOR_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_HUMERAL_LATERAL_EPICONDYLE)) return NAME_L_HUMERAL_LATERAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_L_HUMERAL_MEDIAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_OLECRANON)) return NAME_L_OLECRANON_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_HUMERAL_LATERAL_EPICONDYLE)) return NAME_R_HUMERAL_LATERAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_R_HUMERAL_MEDIAL_EPICONDYLE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_OLECRANON)) return NAME_R_OLECRANON_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_RADIALE)) return NAME_L_RADIALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_ULNAR_STYLOID)) return NAME_L_ULNAR_STYLOID_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_RADIAL_STYLOID)) return NAME_L_RADIAL_STYLOID_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_RADIALE)) return NAME_R_RADIALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_ULNAR_STYLOID)) return NAME_R_ULNAR_STYLOID_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_RADIAL_STYLOID)) return NAME_R_RADIAL_STYLOID_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_2)) return NAME_L_METACARPAL_PHALANX_2_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_3)) return NAME_L_METACARPAL_PHALANX_3_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_5)) return NAME_L_METACARPAL_PHALANX_5_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_2)) return NAME_R_METACARPAL_PHALANX_2_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_3)) return NAME_R_METACARPAL_PHALANX_3_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_5)) return NAME_R_METACARPAL_PHALANX_5_INDEX;
		else if (name.equalsIgnoreCase(NAME_NUCHALE)) return NAME_NUCHALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_NECK_BASE)) return NAME_L_NECK_BASE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_NECK_BASE)) return NAME_R_NECK_BASE_INDEX;
		else if (name.equalsIgnoreCase(NAME_NAVEL)) return NAME_NAVEL_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_ECTOCANTHUS)) return NAME_L_ECTOCANTHUS_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_ECTOCANTHUS)) return NAME_R_ECTOCANTHUS_INDEX;
		else if (name.equalsIgnoreCase(NAME_MENTON)) return NAME_MENTON_INDEX;
		else if (name.equalsIgnoreCase(NAME_MESOSTERNALE)) return NAME_MESOSTERNALE_INDEX;
		else if (name.equalsIgnoreCase(NAME_OPISTHOCRANION)) return NAME_OPISTHOCRANION_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_KNEE_CREASE)) return NAME_L_KNEE_CREASE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_KNEE_CREASE)) return NAME_R_KNEE_CREASE_INDEX;
		else if (name.equalsIgnoreCase(NAME_REAR_CENTER_MIDSAGITTAL_PLANE)) return NAME_REAR_CENTER_MIDSAGITTAL_PLANE_INDEX;
		else if (name.equalsIgnoreCase(NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT)) return NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CHEST_MIDSAGITTAL_PLANE)) return NAME_L_CHEST_MIDSAGITTAL_PLANE_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CHEST_MIDSAGITTAL_PLANE)) return NAME_R_CHEST_MIDSAGITTAL_PLANE_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_BIDELTOID)) return NAME_L_BIDELTOID_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_BIDELTOID)) return NAME_R_BIDELTOID_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_1)) return NAME_L_CARPAL_DISTAL_PHALANX_1_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_2)) return NAME_L_CARPAL_DISTAL_PHALANX_2_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_3)) return NAME_L_CARPAL_DISTAL_PHALANX_3_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_4)) return NAME_L_CARPAL_DISTAL_PHALANX_4_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_5)) return NAME_L_CARPAL_DISTAL_PHALANX_5_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_1)) return NAME_R_CARPAL_DISTAL_PHALANX_1_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_2)) return NAME_R_CARPAL_DISTAL_PHALANX_2_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_3)) return NAME_R_CARPAL_DISTAL_PHALANX_3_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_4)) return NAME_R_CARPAL_DISTAL_PHALANX_4_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_5)) return NAME_R_CARPAL_DISTAL_PHALANX_5_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_1)) return NAME_L_TARSAL_DISTAL_PHALANX_1_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_2)) return NAME_L_TARSAL_DISTAL_PHALANX_2_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_3)) return NAME_L_TARSAL_DISTAL_PHALANX_3_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_4)) return NAME_L_TARSAL_DISTAL_PHALANX_4_INDEX;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_5)) return NAME_L_TARSAL_DISTAL_PHALANX_5_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_1)) return NAME_R_TARSAL_DISTAL_PHALANX_1_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_2)) return NAME_R_TARSAL_DISTAL_PHALANX_2_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_3)) return NAME_R_TARSAL_DISTAL_PHALANX_3_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_4)) return NAME_R_TARSAL_DISTAL_PHALANX_4_INDEX;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_5)) return NAME_R_TARSAL_DISTAL_PHALANX_5_INDEX;
		else return -1; // not found
	}
	/** Whether an index exists for this name
	 * @param name of interest
	 * @return true if found
	 */
	public static boolean hasNameIndex(String name)
	{
		return (getNameIndex(name) > -1);
	}

	/** Get Level of Articulation (loa) for this name
	 * @param name of interest
	 * @return loa value, otherwise -1 if not found
	 */
	public static int getNameLoa(String name)
	{
		if      (name.equalsIgnoreCase(NAME_SKULL_VERTEX)) return NAME_SKULL_VERTEX_LOA;
		else if (name.equalsIgnoreCase(NAME_GLABELLA)) return NAME_GLABELLA_LOA;
		else if (name.equalsIgnoreCase(NAME_SELLION)) return NAME_SELLION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_INFRAORBITALE)) return NAME_L_INFRAORBITALE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TRAGION)) return NAME_L_TRAGION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_GONION)) return NAME_L_GONION_LOA;
		else if (name.equalsIgnoreCase(NAME_R_INFRAORBITALE)) return NAME_R_INFRAORBITALE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TRAGION)) return NAME_R_TRAGION_LOA;
		else if (name.equalsIgnoreCase(NAME_R_GONION)) return NAME_R_GONION_LOA;
		else if (name.equalsIgnoreCase(NAME_SUPRAMENTON)) return NAME_SUPRAMENTON_LOA;
		else if (name.equalsIgnoreCase(NAME_CERVICALE)) return NAME_CERVICALE_LOA;
		else if (name.equalsIgnoreCase(NAME_ADAMS_APPLE)) return NAME_ADAMS_APPLE_LOA;
		else if (name.equalsIgnoreCase(NAME_SUPRASTERNALE)) return NAME_SUPRASTERNALE_LOA;
		else if (name.equalsIgnoreCase(NAME_SUBSTERNALE)) return NAME_SUBSTERNALE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CLAVICLE)) return NAME_L_CLAVICLE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_ACROMION)) return NAME_L_ACROMION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_PROXIMAL)) return NAME_L_AXILLA_PROXIMAL_LOA;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_DISTAL)) return NAME_L_AXILLA_DISTAL_LOA;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_POSTERIOR_FOLDS)) return NAME_L_AXILLA_POSTERIOR_FOLDS_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CLAVICLE)) return NAME_R_CLAVICLE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_ACROMION)) return NAME_R_ACROMION_LOA;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_PROXIMAL)) return NAME_R_AXILLA_PROXIMAL_LOA;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_DISTAL)) return NAME_R_AXILLA_DISTAL_LOA;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_POSTERIOR_FOLDS)) return NAME_R_AXILLA_POSTERIOR_FOLDS_LOA;
		else if (name.equalsIgnoreCase(NAME_SPINE_1_MIDDLE_BACK)) return NAME_SPINE_1_MIDDLE_BACK_LOA;
		else if (name.equalsIgnoreCase(NAME_SPINE_2_LOWER_BACK)) return NAME_SPINE_2_LOWER_BACK_LOA;
		else if (name.equalsIgnoreCase(NAME_WAIST_PREFERRED_ANTERIOR)) return NAME_WAIST_PREFERRED_ANTERIOR_LOA;
		else if (name.equalsIgnoreCase(NAME_WAIST_PREFERRED_POSTERIOR)) return NAME_WAIST_PREFERRED_POSTERIOR_LOA;
		else if (name.equalsIgnoreCase(NAME_L_RIB10)) return NAME_L_RIB10_LOA;
		else if (name.equalsIgnoreCase(NAME_L_THELION)) return NAME_L_THELION_LOA;
		else if (name.equalsIgnoreCase(NAME_R_RIB10)) return NAME_R_RIB10_LOA;
		else if (name.equalsIgnoreCase(NAME_R_THELION)) return NAME_R_THELION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_ASIS)) return NAME_L_ASIS_LOA;
		else if (name.equalsIgnoreCase(NAME_L_ILIOCRISTALE)) return NAME_L_ILIOCRISTALE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_PSIS)) return NAME_L_PSIS_LOA;
		else if (name.equalsIgnoreCase(NAME_R_ASIS)) return NAME_R_ASIS_LOA;
		else if (name.equalsIgnoreCase(NAME_R_ILIOCRISTALE)) return NAME_R_ILIOCRISTALE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_PSIS)) return NAME_R_PSIS_LOA;
		else if (name.equalsIgnoreCase(NAME_CROTCH)) return NAME_CROTCH_LOA;
		else if (name.equalsIgnoreCase(NAME_L_FEMORAL_LATERAL_EPICONDYLE)) return NAME_L_FEMORAL_LATERAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_L_FEMORAL_MEDIAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_SUPRAPATELLA)) return NAME_L_SUPRAPATELLA_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TROCHANTERION)) return NAME_L_TROCHANTERION_LOA;
		else if (name.equalsIgnoreCase(NAME_R_FEMORAL_LATERAL_EPICONDYLE)) return NAME_R_FEMORAL_LATERAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_R_FEMORAL_MEDIAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_SUPRAPATELLA)) return NAME_R_SUPRAPATELLA_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TROCHANTERION)) return NAME_R_TROCHANTERION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TIBIALE)) return NAME_L_TIBIALE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_MEDIAL_MALLEOLUS)) return NAME_L_MEDIAL_MALLEOLUS_LOA;
		else if (name.equalsIgnoreCase(NAME_L_LATERAL_MALLEOLUS)) return NAME_L_LATERAL_MALLEOLUS_LOA;
		else if (name.equalsIgnoreCase(NAME_L_SPHYRION)) return NAME_L_SPHYRION_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TIBIALE)) return NAME_R_TIBIALE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_MEDIAL_MALLEOLUS)) return NAME_R_MEDIAL_MALLEOLUS_LOA;
		else if (name.equalsIgnoreCase(NAME_R_LATERAL_MALLEOLUS)) return NAME_R_LATERAL_MALLEOLUS_LOA;
		else if (name.equalsIgnoreCase(NAME_R_SPHYRION)) return NAME_R_SPHYRION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_1)) return NAME_L_METATARSAL_PHALANX_1_LOA;
		else if (name.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_5)) return NAME_L_METATARSAL_PHALANX_5_LOA;
		else if (name.equalsIgnoreCase(NAME_L_DACTYLION)) return NAME_L_DACTYLION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CALCANEUS_POSTERIOR)) return NAME_L_CALCANEUS_POSTERIOR_LOA;
		else if (name.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_1)) return NAME_R_METATARSAL_PHALANX_1_LOA;
		else if (name.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_5)) return NAME_R_METATARSAL_PHALANX_5_LOA;
		else if (name.equalsIgnoreCase(NAME_R_DACTYLION)) return NAME_R_DACTYLION_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CALCANEUS_POSTERIOR)) return NAME_R_CALCANEUS_POSTERIOR_LOA;
		else if (name.equalsIgnoreCase(NAME_L_HUMERAL_LATERAL_EPICONDYLE)) return NAME_L_HUMERAL_LATERAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_L_HUMERAL_MEDIAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_OLECRANON)) return NAME_L_OLECRANON_LOA;
		else if (name.equalsIgnoreCase(NAME_R_HUMERAL_LATERAL_EPICONDYLE)) return NAME_R_HUMERAL_LATERAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_R_HUMERAL_MEDIAL_EPICONDYLE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_OLECRANON)) return NAME_R_OLECRANON_LOA;
		else if (name.equalsIgnoreCase(NAME_L_RADIALE)) return NAME_L_RADIALE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_ULNAR_STYLOID)) return NAME_L_ULNAR_STYLOID_LOA;
		else if (name.equalsIgnoreCase(NAME_L_RADIAL_STYLOID)) return NAME_L_RADIAL_STYLOID_LOA;
		else if (name.equalsIgnoreCase(NAME_R_RADIALE)) return NAME_R_RADIALE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_ULNAR_STYLOID)) return NAME_R_ULNAR_STYLOID_LOA;
		else if (name.equalsIgnoreCase(NAME_R_RADIAL_STYLOID)) return NAME_R_RADIAL_STYLOID_LOA;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_2)) return NAME_L_METACARPAL_PHALANX_2_LOA;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_3)) return NAME_L_METACARPAL_PHALANX_3_LOA;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_5)) return NAME_L_METACARPAL_PHALANX_5_LOA;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_2)) return NAME_R_METACARPAL_PHALANX_2_LOA;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_3)) return NAME_R_METACARPAL_PHALANX_3_LOA;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_5)) return NAME_R_METACARPAL_PHALANX_5_LOA;
		else if (name.equalsIgnoreCase(NAME_NUCHALE)) return NAME_NUCHALE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_NECK_BASE)) return NAME_L_NECK_BASE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_NECK_BASE)) return NAME_R_NECK_BASE_LOA;
		else if (name.equalsIgnoreCase(NAME_NAVEL)) return NAME_NAVEL_LOA;
		else if (name.equalsIgnoreCase(NAME_L_ECTOCANTHUS)) return NAME_L_ECTOCANTHUS_LOA;
		else if (name.equalsIgnoreCase(NAME_R_ECTOCANTHUS)) return NAME_R_ECTOCANTHUS_LOA;
		else if (name.equalsIgnoreCase(NAME_MENTON)) return NAME_MENTON_LOA;
		else if (name.equalsIgnoreCase(NAME_MESOSTERNALE)) return NAME_MESOSTERNALE_LOA;
		else if (name.equalsIgnoreCase(NAME_OPISTHOCRANION)) return NAME_OPISTHOCRANION_LOA;
		else if (name.equalsIgnoreCase(NAME_L_KNEE_CREASE)) return NAME_L_KNEE_CREASE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_KNEE_CREASE)) return NAME_R_KNEE_CREASE_LOA;
		else if (name.equalsIgnoreCase(NAME_REAR_CENTER_MIDSAGITTAL_PLANE)) return NAME_REAR_CENTER_MIDSAGITTAL_PLANE_LOA;
		else if (name.equalsIgnoreCase(NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT)) return NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CHEST_MIDSAGITTAL_PLANE)) return NAME_L_CHEST_MIDSAGITTAL_PLANE_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CHEST_MIDSAGITTAL_PLANE)) return NAME_R_CHEST_MIDSAGITTAL_PLANE_LOA;
		else if (name.equalsIgnoreCase(NAME_L_BIDELTOID)) return NAME_L_BIDELTOID_LOA;
		else if (name.equalsIgnoreCase(NAME_R_BIDELTOID)) return NAME_R_BIDELTOID_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_1)) return NAME_L_CARPAL_DISTAL_PHALANX_1_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_2)) return NAME_L_CARPAL_DISTAL_PHALANX_2_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_3)) return NAME_L_CARPAL_DISTAL_PHALANX_3_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_4)) return NAME_L_CARPAL_DISTAL_PHALANX_4_LOA;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_5)) return NAME_L_CARPAL_DISTAL_PHALANX_5_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_1)) return NAME_R_CARPAL_DISTAL_PHALANX_1_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_2)) return NAME_R_CARPAL_DISTAL_PHALANX_2_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_3)) return NAME_R_CARPAL_DISTAL_PHALANX_3_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_4)) return NAME_R_CARPAL_DISTAL_PHALANX_4_LOA;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_5)) return NAME_R_CARPAL_DISTAL_PHALANX_5_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_1)) return NAME_L_TARSAL_DISTAL_PHALANX_1_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_2)) return NAME_L_TARSAL_DISTAL_PHALANX_2_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_3)) return NAME_L_TARSAL_DISTAL_PHALANX_3_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_4)) return NAME_L_TARSAL_DISTAL_PHALANX_4_LOA;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_5)) return NAME_L_TARSAL_DISTAL_PHALANX_5_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_1)) return NAME_R_TARSAL_DISTAL_PHALANX_1_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_2)) return NAME_R_TARSAL_DISTAL_PHALANX_2_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_3)) return NAME_R_TARSAL_DISTAL_PHALANX_3_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_4)) return NAME_R_TARSAL_DISTAL_PHALANX_4_LOA;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_5)) return NAME_R_TARSAL_DISTAL_PHALANX_5_LOA;
		else return -1; // not found
	}
	/** Whether an loa exists for this name
	 * @param name of interest
	 * @return true if found
	 */
	public static boolean hasNameLoa(String name)
	{
		return (getNameLoa(name) > -1);
	}

	/** Get alias for this name
	 * @param nameValue of interest
	 * @return alias value, otherwise empty string if not found
	 */
	public static String getNameAlias(String nameValue)
	{
		if      (nameValue.equalsIgnoreCase(NAME_SKULL_VERTEX)) return NAME_SKULL_VERTEX_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_CLAVICLE)) return NAME_L_CLAVICLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_AXILLA_PROXIMAL)) return NAME_L_AXILLA_PROXIMAL_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_AXILLA_DISTAL)) return NAME_L_AXILLA_DISTAL_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_CLAVICLE)) return NAME_R_CLAVICLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_AXILLA_PROXIMAL)) return NAME_R_AXILLA_PROXIMAL_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_AXILLA_DISTAL)) return NAME_R_AXILLA_DISTAL_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_SPINE_1_MIDDLE_BACK)) return NAME_SPINE_1_MIDDLE_BACK_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_SPINE_2_LOWER_BACK)) return NAME_SPINE_2_LOWER_BACK_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_WAIST_PREFERRED_ANTERIOR)) return NAME_WAIST_PREFERRED_ANTERIOR_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_WAIST_PREFERRED_POSTERIOR)) return NAME_WAIST_PREFERRED_POSTERIOR_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_RIB10)) return NAME_L_RIB10_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_THELION)) return NAME_L_THELION_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_RIB10)) return NAME_R_RIB10_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_THELION)) return NAME_R_THELION_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_ASIS)) return NAME_L_ASIS_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_PSIS)) return NAME_L_PSIS_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_ASIS)) return NAME_R_ASIS_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_PSIS)) return NAME_R_PSIS_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_FEMORAL_LATERAL_EPICONDYLE)) return NAME_L_FEMORAL_LATERAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_L_FEMORAL_MEDIAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_SUPRAPATELLA)) return NAME_L_SUPRAPATELLA_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_TROCHANTERION)) return NAME_L_TROCHANTERION_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_FEMORAL_LATERAL_EPICONDYLE)) return NAME_R_FEMORAL_LATERAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_R_FEMORAL_MEDIAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_SUPRAPATELLA)) return NAME_R_SUPRAPATELLA_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_TROCHANTERION)) return NAME_R_TROCHANTERION_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_1)) return NAME_L_METATARSAL_PHALANX_1_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_5)) return NAME_L_METATARSAL_PHALANX_5_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_CALCANEUS_POSTERIOR)) return NAME_L_CALCANEUS_POSTERIOR_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_1)) return NAME_R_METATARSAL_PHALANX_1_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_5)) return NAME_R_METATARSAL_PHALANX_5_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_CALCANEUS_POSTERIOR)) return NAME_R_CALCANEUS_POSTERIOR_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_HUMERAL_LATERAL_EPICONDYLE)) return NAME_L_HUMERAL_LATERAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_L_HUMERAL_MEDIAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_HUMERAL_LATERAL_EPICONDYLE)) return NAME_R_HUMERAL_LATERAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_R_HUMERAL_MEDIAL_EPICONDYLE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_2)) return NAME_L_METACARPAL_PHALANX_2_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_5)) return NAME_L_METACARPAL_PHALANX_5_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_2)) return NAME_R_METACARPAL_PHALANX_2_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_5)) return NAME_R_METACARPAL_PHALANX_5_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_NUCHALE)) return NAME_NUCHALE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_NAVEL)) return NAME_NAVEL_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_ECTOCANTHUS)) return NAME_L_ECTOCANTHUS_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_ECTOCANTHUS)) return NAME_R_ECTOCANTHUS_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_MENTON)) return NAME_MENTON_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_MESOSTERNALE)) return NAME_MESOSTERNALE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_REAR_CENTER_MIDSAGITTAL_PLANE)) return NAME_REAR_CENTER_MIDSAGITTAL_PLANE_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_1)) return NAME_L_CARPAL_DISTAL_PHALANX_1_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_2)) return NAME_L_CARPAL_DISTAL_PHALANX_2_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_3)) return NAME_L_CARPAL_DISTAL_PHALANX_3_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_4)) return NAME_L_CARPAL_DISTAL_PHALANX_4_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_5)) return NAME_L_CARPAL_DISTAL_PHALANX_5_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_1)) return NAME_R_CARPAL_DISTAL_PHALANX_1_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_2)) return NAME_R_CARPAL_DISTAL_PHALANX_2_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_3)) return NAME_R_CARPAL_DISTAL_PHALANX_3_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_4)) return NAME_R_CARPAL_DISTAL_PHALANX_4_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_5)) return NAME_R_CARPAL_DISTAL_PHALANX_5_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_2)) return NAME_L_TARSAL_DISTAL_PHALANX_2_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_5)) return NAME_L_TARSAL_DISTAL_PHALANX_5_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_2)) return NAME_R_TARSAL_DISTAL_PHALANX_2_ALIAS;
		else if (nameValue.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_5)) return NAME_R_TARSAL_DISTAL_PHALANX_5_ALIAS;
		else return ""; // not found
	}
	/** Whether a alias exists for this name
	 * @param name of interest
	 * @return true if found
	 */
	public static boolean hasNameAlias(String name)
	{
		return !getNameAlias(name).isEmpty();
	}

	/** Get parent for this name
	 * @param name of interest
	 * @return parent value, otherwise empty string if not found
	 */
	public static String getParentName(String name)
	{
		if      (name.equalsIgnoreCase(NAME_SKULL_VERTEX)) return NAME_SKULL_VERTEX_PARENT;
		else if (name.equalsIgnoreCase(NAME_GLABELLA)) return NAME_GLABELLA_PARENT;
		else if (name.equalsIgnoreCase(NAME_SELLION)) return NAME_SELLION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_INFRAORBITALE)) return NAME_L_INFRAORBITALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TRAGION)) return NAME_L_TRAGION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_GONION)) return NAME_L_GONION_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_INFRAORBITALE)) return NAME_R_INFRAORBITALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TRAGION)) return NAME_R_TRAGION_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_GONION)) return NAME_R_GONION_PARENT;
		else if (name.equalsIgnoreCase(NAME_SUPRAMENTON)) return NAME_SUPRAMENTON_PARENT;
		else if (name.equalsIgnoreCase(NAME_CERVICALE)) return NAME_CERVICALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_ADAMS_APPLE)) return NAME_ADAMS_APPLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_SUPRASTERNALE)) return NAME_SUPRASTERNALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_SUBSTERNALE)) return NAME_SUBSTERNALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CLAVICLE)) return NAME_L_CLAVICLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_ACROMION)) return NAME_L_ACROMION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_PROXIMAL)) return NAME_L_AXILLA_PROXIMAL_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_DISTAL)) return NAME_L_AXILLA_DISTAL_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_AXILLA_POSTERIOR_FOLDS)) return NAME_L_AXILLA_POSTERIOR_FOLDS_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CLAVICLE)) return NAME_R_CLAVICLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_ACROMION)) return NAME_R_ACROMION_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_PROXIMAL)) return NAME_R_AXILLA_PROXIMAL_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_DISTAL)) return NAME_R_AXILLA_DISTAL_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_AXILLA_POSTERIOR_FOLDS)) return NAME_R_AXILLA_POSTERIOR_FOLDS_PARENT;
		else if (name.equalsIgnoreCase(NAME_SPINE_1_MIDDLE_BACK)) return NAME_SPINE_1_MIDDLE_BACK_PARENT;
		else if (name.equalsIgnoreCase(NAME_SPINE_2_LOWER_BACK)) return NAME_SPINE_2_LOWER_BACK_PARENT;
		else if (name.equalsIgnoreCase(NAME_WAIST_PREFERRED_ANTERIOR)) return NAME_WAIST_PREFERRED_ANTERIOR_PARENT;
		else if (name.equalsIgnoreCase(NAME_WAIST_PREFERRED_POSTERIOR)) return NAME_WAIST_PREFERRED_POSTERIOR_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_RIB10)) return NAME_L_RIB10_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_THELION)) return NAME_L_THELION_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_RIB10)) return NAME_R_RIB10_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_THELION)) return NAME_R_THELION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_ASIS)) return NAME_L_ASIS_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_ILIOCRISTALE)) return NAME_L_ILIOCRISTALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_PSIS)) return NAME_L_PSIS_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_ASIS)) return NAME_R_ASIS_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_ILIOCRISTALE)) return NAME_R_ILIOCRISTALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_PSIS)) return NAME_R_PSIS_PARENT;
		else if (name.equalsIgnoreCase(NAME_CROTCH)) return NAME_CROTCH_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_FEMORAL_LATERAL_EPICONDYLE)) return NAME_L_FEMORAL_LATERAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_L_FEMORAL_MEDIAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_SUPRAPATELLA)) return NAME_L_SUPRAPATELLA_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TROCHANTERION)) return NAME_L_TROCHANTERION_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_FEMORAL_LATERAL_EPICONDYLE)) return NAME_R_FEMORAL_LATERAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_FEMORAL_MEDIAL_EPICONDYLE)) return NAME_R_FEMORAL_MEDIAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_SUPRAPATELLA)) return NAME_R_SUPRAPATELLA_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TROCHANTERION)) return NAME_R_TROCHANTERION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TIBIALE)) return NAME_L_TIBIALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_MEDIAL_MALLEOLUS)) return NAME_L_MEDIAL_MALLEOLUS_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_LATERAL_MALLEOLUS)) return NAME_L_LATERAL_MALLEOLUS_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_SPHYRION)) return NAME_L_SPHYRION_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TIBIALE)) return NAME_R_TIBIALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_MEDIAL_MALLEOLUS)) return NAME_R_MEDIAL_MALLEOLUS_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_LATERAL_MALLEOLUS)) return NAME_R_LATERAL_MALLEOLUS_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_SPHYRION)) return NAME_R_SPHYRION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_1)) return NAME_L_METATARSAL_PHALANX_1_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_METATARSAL_PHALANX_5)) return NAME_L_METATARSAL_PHALANX_5_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_DACTYLION)) return NAME_L_DACTYLION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CALCANEUS_POSTERIOR)) return NAME_L_CALCANEUS_POSTERIOR_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_1)) return NAME_R_METATARSAL_PHALANX_1_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_METATARSAL_PHALANX_5)) return NAME_R_METATARSAL_PHALANX_5_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_DACTYLION)) return NAME_R_DACTYLION_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CALCANEUS_POSTERIOR)) return NAME_R_CALCANEUS_POSTERIOR_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_HUMERAL_LATERAL_EPICONDYLE)) return NAME_L_HUMERAL_LATERAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_L_HUMERAL_MEDIAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_OLECRANON)) return NAME_L_OLECRANON_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_HUMERAL_LATERAL_EPICONDYLE)) return NAME_R_HUMERAL_LATERAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_HUMERAL_MEDIAL_EPICONDYLE)) return NAME_R_HUMERAL_MEDIAL_EPICONDYLE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_OLECRANON)) return NAME_R_OLECRANON_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_RADIALE)) return NAME_L_RADIALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_ULNAR_STYLOID)) return NAME_L_ULNAR_STYLOID_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_RADIAL_STYLOID)) return NAME_L_RADIAL_STYLOID_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_RADIALE)) return NAME_R_RADIALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_ULNAR_STYLOID)) return NAME_R_ULNAR_STYLOID_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_RADIAL_STYLOID)) return NAME_R_RADIAL_STYLOID_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_2)) return NAME_L_METACARPAL_PHALANX_2_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_3)) return NAME_L_METACARPAL_PHALANX_3_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_METACARPAL_PHALANX_5)) return NAME_L_METACARPAL_PHALANX_5_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_2)) return NAME_R_METACARPAL_PHALANX_2_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_3)) return NAME_R_METACARPAL_PHALANX_3_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_METACARPAL_PHALANX_5)) return NAME_R_METACARPAL_PHALANX_5_PARENT;
		else if (name.equalsIgnoreCase(NAME_NUCHALE)) return NAME_NUCHALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_NECK_BASE)) return NAME_L_NECK_BASE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_NECK_BASE)) return NAME_R_NECK_BASE_PARENT;
		else if (name.equalsIgnoreCase(NAME_NAVEL)) return NAME_NAVEL_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_ECTOCANTHUS)) return NAME_L_ECTOCANTHUS_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_ECTOCANTHUS)) return NAME_R_ECTOCANTHUS_PARENT;
		else if (name.equalsIgnoreCase(NAME_MENTON)) return NAME_MENTON_PARENT;
		else if (name.equalsIgnoreCase(NAME_MESOSTERNALE)) return NAME_MESOSTERNALE_PARENT;
		else if (name.equalsIgnoreCase(NAME_OPISTHOCRANION)) return NAME_OPISTHOCRANION_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_KNEE_CREASE)) return NAME_L_KNEE_CREASE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_KNEE_CREASE)) return NAME_R_KNEE_CREASE_PARENT;
		else if (name.equalsIgnoreCase(NAME_REAR_CENTER_MIDSAGITTAL_PLANE)) return NAME_REAR_CENTER_MIDSAGITTAL_PLANE_PARENT;
		else if (name.equalsIgnoreCase(NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT)) return NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CHEST_MIDSAGITTAL_PLANE)) return NAME_L_CHEST_MIDSAGITTAL_PLANE_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CHEST_MIDSAGITTAL_PLANE)) return NAME_R_CHEST_MIDSAGITTAL_PLANE_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_BIDELTOID)) return NAME_L_BIDELTOID_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_BIDELTOID)) return NAME_R_BIDELTOID_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_1)) return NAME_L_CARPAL_DISTAL_PHALANX_1_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_2)) return NAME_L_CARPAL_DISTAL_PHALANX_2_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_3)) return NAME_L_CARPAL_DISTAL_PHALANX_3_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_4)) return NAME_L_CARPAL_DISTAL_PHALANX_4_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_CARPAL_DISTAL_PHALANX_5)) return NAME_L_CARPAL_DISTAL_PHALANX_5_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_1)) return NAME_R_CARPAL_DISTAL_PHALANX_1_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_2)) return NAME_R_CARPAL_DISTAL_PHALANX_2_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_3)) return NAME_R_CARPAL_DISTAL_PHALANX_3_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_4)) return NAME_R_CARPAL_DISTAL_PHALANX_4_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_CARPAL_DISTAL_PHALANX_5)) return NAME_R_CARPAL_DISTAL_PHALANX_5_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_1)) return NAME_L_TARSAL_DISTAL_PHALANX_1_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_2)) return NAME_L_TARSAL_DISTAL_PHALANX_2_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_3)) return NAME_L_TARSAL_DISTAL_PHALANX_3_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_4)) return NAME_L_TARSAL_DISTAL_PHALANX_4_PARENT;
		else if (name.equalsIgnoreCase(NAME_L_TARSAL_DISTAL_PHALANX_5)) return NAME_L_TARSAL_DISTAL_PHALANX_5_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_1)) return NAME_R_TARSAL_DISTAL_PHALANX_1_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_2)) return NAME_R_TARSAL_DISTAL_PHALANX_2_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_3)) return NAME_R_TARSAL_DISTAL_PHALANX_3_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_4)) return NAME_R_TARSAL_DISTAL_PHALANX_4_PARENT;
		else if (name.equalsIgnoreCase(NAME_R_TARSAL_DISTAL_PHALANX_5)) return NAME_R_TARSAL_DISTAL_PHALANX_5_PARENT;
		else return ""; // not found
	}
	/** Whether a parent exists for this name
	 * @param name of interest
	 * @return true if found
	 */
	public static boolean hasParentMatchingName(String name)
	{
		return !getParentName(name).isEmpty();
	}

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>HAnimDisplacer</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "HAnimDisplacer";

	/** Provides name of this element: <i>HAnimDisplacer</i>
	 * @return name of this element
	 */
	@Override
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>HAnimDisplacer</i> element: <i>HAnim</i> */
	public static final String COMPONENT = "HAnim";

	/** Defines X3D component for the <i>HAnimDisplacer</i> element: <i>HAnim</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>HAnim</i> component level for this element: <i>1</i> */
	public static final int LEVEL = 1;

	/** Provides default X3D component level for this element: <i>1</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** MFInt32 field named <i>coordIndex</i> has default value equal to an empty list. */
	public static final ArrayList<Integer> COORDINDEX_DEFAULT_VALUE = new ArrayList<>(Arrays.asList());

	/** SFString field named <i>description</i> has default value equal to an empty string. */
	public static final String DESCRIPTION_DEFAULT_VALUE = "";

	/** MFVec3f field named <i>displacements</i> has default value equal to an empty list. */
	public static final float[] DISPLACEMENTS_DEFAULT_VALUE = {};

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFString field named <i>name</i> has default value equal to an empty string. */
	public static final String NAME_DEFAULT_VALUE = "";

	/** SFFloat field named <i>weight</i> has default value <i>0.0f</i> (Java syntax) or <i>0.0</i> (XML syntax). */
	public static final float WEIGHT_DEFAULT_VALUE = 0.0f;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks

			case "containerField":
				result = "SFString";
				break;
			case "coordIndex":
				result = "MFInt32";
				break;
			case "description":
				result = "SFString";
				break;
			case "displacements":
				result = "MFVec3f";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "name":
				result = "SFString";
				break;
			case "weight":
				result = "SFFloat";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "coordIndex":
				result = "inputOutput";
				break;
			case "description":
				result = "inputOutput";
				break;
			case "displacements":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "name":
				result = "inputOutput";
				break;
			case "weight":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, this default value is provided for informational purposes only.
         * <br />
         * containerField_DEFAULT_VALUE = "displacers";
         * <br />
         * containerField_ALLOWED_VALUES = {"displacers", "displacers" *HAnimJoint or HAnimSegment parent* };  type xs:NMTOKEN
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
	 */

	public static final String containerField_DEFAULT_VALUE = "displacers"; // type xs:NMTOKEN
	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Programmer usage is not ordinarily needed when using this API, since this default value is provided for informational purposes only.
	 * @see #containerField_DEFAULT_VALUE
         * @see org.web3d.x3d.jsail.X3DConcreteNode#containerField_ALLOWED_VALUES
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
         * @return default containerField value
	 */
        @Override
        public final String getContainerFieldDefault()
        {
            return containerField_DEFAULT_VALUE;
        }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for MFInt32 field named <i>coordIndex</i>. */
	public static final String fromField_COORDINDEX = "coordIndex";

	/** toField ROUTE name for MFInt32 field named <i>coordIndex</i>. */
	public static final String toField_COORDINDEX = "coordIndex";

	/** fromField ROUTE name for SFString field named <i>description</i>. */
	public static final String fromField_DESCRIPTION = "description";

	/** toField ROUTE name for SFString field named <i>description</i>. */
	public static final String toField_DESCRIPTION = "description";

	/** fromField ROUTE name for MFVec3f field named <i>displacements</i>. */
	public static final String fromField_DISPLACEMENTS = "displacements";

	/** toField ROUTE name for MFVec3f field named <i>displacements</i>. */
	public static final String toField_DISPLACEMENTS = "displacements";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFString field named <i>name</i>. */
	public static final String fromField_NAME = "name";

	/** toField ROUTE name for SFString field named <i>name</i>. */
	public static final String toField_NAME = "name";

	/** fromField ROUTE name for SFFloat field named <i>weight</i>. */
	public static final String fromField_WEIGHT = "weight";

	/** toField ROUTE name for SFFloat field named <i>weight</i>. */
	public static final String toField_WEIGHT = "weight";

	/** Constructor for HAnimDisplacer to initialize member variables with default values. */
	public HAnimDisplacer()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        super.includesNameField();
        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALLOWED_VALUES = new String[] { "displacers", "displacers" /*HAnimJoint or HAnimSegment parent*/ }; // type xs:NMTOKEN

		coordIndex = new ArrayList<>();
		description = DESCRIPTION_DEFAULT_VALUE;
		displacements =  new float[] { };
		IS = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		name = NAME_DEFAULT_VALUE;
		weight = WEIGHT_DEFAULT_VALUE;

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of Integer results from inputOutput MFInt32 field named <i>coordIndex</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Defines index values into the parent HAnimSegment or HAnimBody/HAnimHumanoid coordinate array for the mesh of vertices affected by this HAnimDisplacer. Values start at index 0.
 * <ul>
 *  <li> <i> Warning:</i>  -1 sentinel values are not allowed. </li> 
 * </ul>
	 * @return value of coordIndex field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=CoordIndex, $memberObjectName=coordIndex, $memberObjectName=coordIndex)

	public int[] getCoordIndex()
	{
		final int[] valuesArray = new int[coordIndex.size()];
		int i = 0;
		for (Integer arrayElement : coordIndex) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFInt32 coordIndex field, similar to {@link #getCoordIndex()}.
	 * @return value of coordIndex field
	 */
	public ArrayList<Integer> getCoordIndexList()
	{
		return coordIndex;
	}
	/**
	 * Utility method to get String value of MFInt32 coordIndex field, similar to {@link #getCoordIndex()}.
	 * @return value of coordIndex field
	 */
	public String getCoordIndexString()
    {
        StringBuilder result = new StringBuilder();
		for (Integer arrayElement : coordIndex) {
			result.append(arrayElement.toString());
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign Integer array to inputOutput MFInt32 field named <i>coordIndex</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Defines index values into the parent HAnimSegment or HAnimBody/HAnimHumanoid coordinate array for the mesh of vertices affected by this HAnimDisplacer. Values start at index 0.
 * <ul>
 *  <li> <i> Warning:</i>  -1 sentinel values are not allowed. </li> 
 * </ul>
	 * @param newValue is new value for the coordIndex field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public HAnimDisplacer setCoordIndex(int[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)		{
			clearCoordIndex(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearCoordIndex(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			coordIndex.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFInt32 coordIndex field, similar to {@link #setCoordIndex(int[])}.
	 * @param newValue is new value for the coordIndex field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setCoordIndex(MFInt32 newValue)
	{
		if (newValue == null)		{
			clearCoordIndex(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCoordIndex(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign ArrayList value of MFInt32 coordIndex field, similar to {@link #setCoordIndex(int[])}.
	 * @param newValue is new value for the coordIndex field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setCoordIndex(ArrayList<Integer> newValue)
	{
		if (newValue == null)		{
			clearCoordIndex(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
        if (newValue.isEmpty())
            clearCoordIndex(); // reset
        else
        {
            int[] newArray = new int[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setCoordIndex(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFInt32 value of coordIndex field.  This method does not initialize withCOORDINDEX_DEFAULT_VALUE.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public HAnimDisplacer clearCoordIndex()
	{
		coordIndex.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton int value to MFInt32 coordIndex field.
	 * @param newValue is new value to add to the coordIndex field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer addCoordIndex(int newValue)
	{
		coordIndex.add(newValue); // add simple type if tupleSize = 1
		return this;
	}
	/**
	 * Add singleton SFInt32 value to MFInt32 coordIndex field.
	 * @param newValue is new value to add to the coordIndex field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer addCoordIndex(SFInt32 newValue)
	{
		if (newValue == null)
		{
			return this; // nothing else to do
		}
		coordIndex.add(newValue.getPrimitiveValue());
		return this;
	}

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of this node.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription()
	{
		return description;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of this node.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public HAnimDisplacer setDescription(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		description = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString description field, similar to {@link #setDescription(String)}.
	 * @param newValue is new value for the description field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setDescription(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDescription(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of 3-tuple float results from inputOutput MFVec3f field named <i>displacements</i>.
	 * <br><br>
	 * <i>Tooltip:</i> displacements are a set of SFVec3f values added to neutral/resting position of each of the corresponding HAnimSegment vertices (or HAnimJoint/HAnimHumanoid vertices) referenced by coordIndex field.
 * <ul>
 *  <li> <i>Hint:</i> Individual displacement values are scaled by the weight factor, if present. </li> 
 *  <li> <i>Hint:</i>  since default pose faces along +Z axis, -x values are right side and +x values are left side within HAnimHumanoid. </li> 
 * </ul>
	 * @return value of displacements field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=Displacements, $memberObjectName=displacements, $memberObjectName=displacements)

	public float[] getDisplacements()
	{
		return displacements;
	}

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput MFVec3f field named <i>displacements</i>.
	 * <br><br>
	 * <i>Tooltip:</i> displacements are a set of SFVec3f values added to neutral/resting position of each of the corresponding HAnimSegment vertices (or HAnimJoint/HAnimHumanoid vertices) referenced by coordIndex field.
 * <ul>
 *  <li> <i>Hint:</i> Individual displacement values are scaled by the weight factor, if present. </li> 
 *  <li> <i>Hint:</i>  since default pose faces along +Z axis, -x values are right side and +x values are left side within HAnimHumanoid. </li> 
 * </ul>
	 * @param newValue is new value for the displacements field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public HAnimDisplacer setDisplacements(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length % 3 != 0) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("HAnimDisplacer displacements newValue=" + MFVec3f.toString(newValue) + " has length=" + newValue.length + ", must be a multiple of 3");
		}
		displacements = newValue;
		return this;
	}

	/**
	 * Assign typed object value to MFVec3f displacements field, similar to {@link #setDisplacements(float[])}.
	 * @param newValue is new value for the displacements field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setDisplacements(MFVec3f newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDisplacements(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Add singleton SFVec3f value to MFVec3f displacements field.
	 * @param newValue is new value to add to the displacements field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer addDisplacements(SFVec3f newValue)
	{
		if (newValue == null)
		{
			return this; // nothing else to do
		}
		float[] result =  Arrays.copyOf(displacements, displacements.length + 3);
		System.arraycopy(newValue.getPrimitiveValue(), 0, result, displacements.length, 3);
		displacements =  result;
		return this;
	}


	/**
	 * Utility method: double-precision set-array accessor for X3D floating-point type, similar to {@link #setDisplacements(float[])}.
	 * @param newArray is new value for field
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setDisplacements(double[] newArray)
	{
		return setDisplacements(new MFVec3f(newArray));
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public HAnimDisplacer clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public HAnimDisplacer setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public HAnimDisplacer clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public HAnimDisplacer setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["skull_vertex" | "glabella" | "sellion" | "l_infraorbitale" | "l_tragion" | "l_gonion" | "r_infraorbitale" | "r_tragion" | "r_gonion" | "supramenton" | "cervicale" | "adams_apple" | "suprasternale" | "substernale" | "l_clavicle" | "l_acromion" | "l_axilla_proximal" | "l_axilla_distal" | "l_axilla_posterior_folds" | "r_clavicle" | "r_acromion" | "r_axilla_proximal" | "r_axilla_distal" | "r_axilla_posterior_folds" | "spine_1_middle_back" | "spine_2_lower_back" | "waist_preferred_anterior" | "waist_preferred_posterior" | "l_rib10" | "l_thelion" | "r_rib10" | "r_thelion" | "l_asis" | "l_iliocristale" | "l_psis" | "r_asis" | "r_iliocristale" | "r_psis" | "crotch" | "l_femoral_lateral_epicondyle" | "l_femoral_medial_epicondyle" | "l_suprapatella" | "l_trochanterion" | "r_femoral_lateral_epicondyle" | "r_femoral_medial_epicondyle" | "r_suprapatella" | "r_trochanterion" | "l_tibiale" | "l_medial_malleolus" | "l_lateral_malleolus" | "l_sphyrion" | "r_tibiale" | "r_medial_malleolus" | "r_lateral_malleolus" | "r_sphyrion" | "l_metatarsal_phalanx_1" | "l_metatarsal_phalanx_5" | "l_dactylion" | "l_calcaneus_posterior" | "r_metatarsal_phalanx_1" | "r_metatarsal_phalanx_5" | "r_dactylion" | "r_calcaneus_posterior" | "l_humeral_lateral_epicondyle" | "l_humeral_medial_epicondyle" | "l_olecranon" | "r_humeral_lateral_epicondyle" | "r_humeral_medial_epicondyle" | "r_olecranon" | "l_radiale" | "l_ulnar_styloid" | "l_radial_styloid" | "r_radiale" | "r_ulnar_styloid" | "r_radial_styloid" | "l_metacarpal_phalanx_2" | "l_metacarpal_phalanx_3" | "l_metacarpal_phalanx_5" | "r_metacarpal_phalanx_2" | "r_metacarpal_phalanx_3" | "r_metacarpal_phalanx_5" | "nuchale" | "l_neck_base" | "r_neck_base" | "navel" | "l_ectocanthus" | "r_ectocanthus" | "menton" | "mesosternale" | "opisthocranion" | "l_knee_crease" | "r_knee_crease" | "rear_center_midsagittal_plane" | "buttocks_standing_wall_contact_point" | "l_chest_midsagittal_plane" | "r_chest_midsagittal_plane" | "l_bideltoid" | "r_bideltoid" | "l_carpal_distal_phalanx_1" | "l_carpal_distal_phalanx_2" | "l_carpal_distal_phalanx_3" | "l_carpal_distal_phalanx_4" | "l_carpal_distal_phalanx_5" | "r_carpal_distal_phalanx_1" | "r_carpal_distal_phalanx_2" | "r_carpal_distal_phalanx_3" | "r_carpal_distal_phalanx_4" | "r_carpal_distal_phalanx_5" | "l_tarsal_distal_phalanx_1" | "l_tarsal_distal_phalanx_2" | "l_tarsal_distal_phalanx_3" | "l_tarsal_distal_phalanx_4" | "l_tarsal_distal_phalanx_5" | "r_tarsal_distal_phalanx_1" | "r_tarsal_distal_phalanx_2" | "r_tarsal_distal_phalanx_3" | "r_tarsal_distal_phalanx_4" | "r_tarsal_distal_phalanx_5" | 'etc.'] from inputOutput SFString field named <i>name</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Unique name attribute must be defined so that HAnimDisplacer node can be identified at run time for animation purposes.
 * <ul>
 *  <li> <i>Hint:</i> HAnimDisplacer names are based on feature point names. </li> 
 *  <li> <i>Hint:</i> <a href="https://www.web3d.org/documents/specifications/19774/V2.0/Architecture/FeaturePoints.html" target="_blank">https://www.web3d.org/documents/specifications/19774/V2.0/Architecture/FeaturePoints.html</a> </li> 
 *  <li> <i>Warning:</i> allowed name suffixes include _feature, _action and _config. </li> 
 *  <li> <i>Warning:</i> name prefix must match ancestor HAnimHumanoid name followed by underscore character, if more than one humanoid appears within a scene file. For example, 'Nancy_' prepended before location name. </li> 
 *  <li> <i>Warning:</i> name field is not included if this instance is a USE node, in order to avoid potential mismatches. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i> X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 *  <li> <i>Hint:</i>  HAnim2 Names HAnim1 Alias Tables <a href="https://www.web3d.org/x3d/content/examples/HumanoidAnimation/HAnim2NameHAnim1AliasTables.txt" target="_blank">https://www.web3d.org/x3d/content/examples/HumanoidAnimation/HAnim2NameHAnim1AliasTables.txt</a> </li> 
 * </ul>
	 * <br><br>
	 * Available enumeration values for string comparison: {@link #NAME_SKULL_VERTEX SKULL_VERTEX}, {@link #NAME_GLABELLA GLABELLA}, {@link #NAME_SELLION SELLION}, {@link #NAME_L_INFRAORBITALE L_INFRAORBITALE}, {@link #NAME_L_TRAGION L_TRAGION}, {@link #NAME_L_GONION L_GONION}, {@link #NAME_R_INFRAORBITALE R_INFRAORBITALE}, {@link #NAME_R_TRAGION R_TRAGION}, {@link #NAME_R_GONION R_GONION}, {@link #NAME_SUPRAMENTON SUPRAMENTON}, {@link #NAME_CERVICALE CERVICALE}, {@link #NAME_ADAMS_APPLE ADAMS_APPLE}, {@link #NAME_SUPRASTERNALE SUPRASTERNALE}, {@link #NAME_SUBSTERNALE SUBSTERNALE}, {@link #NAME_L_CLAVICLE L_CLAVICLE}, {@link #NAME_L_ACROMION L_ACROMION}, {@link #NAME_L_AXILLA_PROXIMAL L_AXILLA_PROXIMAL}, {@link #NAME_L_AXILLA_DISTAL L_AXILLA_DISTAL}, {@link #NAME_L_AXILLA_POSTERIOR_FOLDS L_AXILLA_POSTERIOR_FOLDS}, {@link #NAME_R_CLAVICLE R_CLAVICLE}, {@link #NAME_R_ACROMION R_ACROMION}, {@link #NAME_R_AXILLA_PROXIMAL R_AXILLA_PROXIMAL}, {@link #NAME_R_AXILLA_DISTAL R_AXILLA_DISTAL}, {@link #NAME_R_AXILLA_POSTERIOR_FOLDS R_AXILLA_POSTERIOR_FOLDS}, {@link #NAME_SPINE_1_MIDDLE_BACK SPINE_1_MIDDLE_BACK}, {@link #NAME_SPINE_2_LOWER_BACK SPINE_2_LOWER_BACK}, {@link #NAME_WAIST_PREFERRED_ANTERIOR WAIST_PREFERRED_ANTERIOR}, {@link #NAME_WAIST_PREFERRED_POSTERIOR WAIST_PREFERRED_POSTERIOR}, {@link #NAME_L_RIB10 L_RIB10}, {@link #NAME_L_THELION L_THELION}, {@link #NAME_R_RIB10 R_RIB10}, {@link #NAME_R_THELION R_THELION}, {@link #NAME_L_ASIS L_ASIS}, {@link #NAME_L_ILIOCRISTALE L_ILIOCRISTALE}, {@link #NAME_L_PSIS L_PSIS}, {@link #NAME_R_ASIS R_ASIS}, {@link #NAME_R_ILIOCRISTALE R_ILIOCRISTALE}, {@link #NAME_R_PSIS R_PSIS}, {@link #NAME_CROTCH CROTCH}, {@link #NAME_L_FEMORAL_LATERAL_EPICONDYLE L_FEMORAL_LATERAL_EPICONDYLE}, {@link #NAME_L_FEMORAL_MEDIAL_EPICONDYLE L_FEMORAL_MEDIAL_EPICONDYLE}, {@link #NAME_L_SUPRAPATELLA L_SUPRAPATELLA}, {@link #NAME_L_TROCHANTERION L_TROCHANTERION}, {@link #NAME_R_FEMORAL_LATERAL_EPICONDYLE R_FEMORAL_LATERAL_EPICONDYLE}, {@link #NAME_R_FEMORAL_MEDIAL_EPICONDYLE R_FEMORAL_MEDIAL_EPICONDYLE}, {@link #NAME_R_SUPRAPATELLA R_SUPRAPATELLA}, {@link #NAME_R_TROCHANTERION R_TROCHANTERION}, {@link #NAME_L_TIBIALE L_TIBIALE}, {@link #NAME_L_MEDIAL_MALLEOLUS L_MEDIAL_MALLEOLUS}, {@link #NAME_L_LATERAL_MALLEOLUS L_LATERAL_MALLEOLUS}, {@link #NAME_L_SPHYRION L_SPHYRION}, {@link #NAME_R_TIBIALE R_TIBIALE}, {@link #NAME_R_MEDIAL_MALLEOLUS R_MEDIAL_MALLEOLUS}, {@link #NAME_R_LATERAL_MALLEOLUS R_LATERAL_MALLEOLUS}, {@link #NAME_R_SPHYRION R_SPHYRION}, {@link #NAME_L_METATARSAL_PHALANX_1 L_METATARSAL_PHALANX_1}, {@link #NAME_L_METATARSAL_PHALANX_5 L_METATARSAL_PHALANX_5}, {@link #NAME_L_DACTYLION L_DACTYLION}, {@link #NAME_L_CALCANEUS_POSTERIOR L_CALCANEUS_POSTERIOR}, {@link #NAME_R_METATARSAL_PHALANX_1 R_METATARSAL_PHALANX_1}, {@link #NAME_R_METATARSAL_PHALANX_5 R_METATARSAL_PHALANX_5}, {@link #NAME_R_DACTYLION R_DACTYLION}, {@link #NAME_R_CALCANEUS_POSTERIOR R_CALCANEUS_POSTERIOR}, {@link #NAME_L_HUMERAL_LATERAL_EPICONDYLE L_HUMERAL_LATERAL_EPICONDYLE}, {@link #NAME_L_HUMERAL_MEDIAL_EPICONDYLE L_HUMERAL_MEDIAL_EPICONDYLE}, {@link #NAME_L_OLECRANON L_OLECRANON}, {@link #NAME_R_HUMERAL_LATERAL_EPICONDYLE R_HUMERAL_LATERAL_EPICONDYLE}, {@link #NAME_R_HUMERAL_MEDIAL_EPICONDYLE R_HUMERAL_MEDIAL_EPICONDYLE}, {@link #NAME_R_OLECRANON R_OLECRANON}, {@link #NAME_L_RADIALE L_RADIALE}, {@link #NAME_L_ULNAR_STYLOID L_ULNAR_STYLOID}, {@link #NAME_L_RADIAL_STYLOID L_RADIAL_STYLOID}, {@link #NAME_R_RADIALE R_RADIALE}, {@link #NAME_R_ULNAR_STYLOID R_ULNAR_STYLOID}, {@link #NAME_R_RADIAL_STYLOID R_RADIAL_STYLOID}, {@link #NAME_L_METACARPAL_PHALANX_2 L_METACARPAL_PHALANX_2}, {@link #NAME_L_METACARPAL_PHALANX_3 L_METACARPAL_PHALANX_3}, {@link #NAME_L_METACARPAL_PHALANX_5 L_METACARPAL_PHALANX_5}, {@link #NAME_R_METACARPAL_PHALANX_2 R_METACARPAL_PHALANX_2}, {@link #NAME_R_METACARPAL_PHALANX_3 R_METACARPAL_PHALANX_3}, {@link #NAME_R_METACARPAL_PHALANX_5 R_METACARPAL_PHALANX_5}, {@link #NAME_NUCHALE NUCHALE}, {@link #NAME_L_NECK_BASE L_NECK_BASE}, {@link #NAME_R_NECK_BASE R_NECK_BASE}, {@link #NAME_NAVEL NAVEL}, {@link #NAME_L_ECTOCANTHUS L_ECTOCANTHUS}, {@link #NAME_R_ECTOCANTHUS R_ECTOCANTHUS}, {@link #NAME_MENTON MENTON}, {@link #NAME_MESOSTERNALE MESOSTERNALE}, {@link #NAME_OPISTHOCRANION OPISTHOCRANION}, {@link #NAME_L_KNEE_CREASE L_KNEE_CREASE}, {@link #NAME_R_KNEE_CREASE R_KNEE_CREASE}, {@link #NAME_REAR_CENTER_MIDSAGITTAL_PLANE REAR_CENTER_MIDSAGITTAL_PLANE}, {@link #NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT BUTTOCKS_STANDING_WALL_CONTACT_POINT}, {@link #NAME_L_CHEST_MIDSAGITTAL_PLANE L_CHEST_MIDSAGITTAL_PLANE}, {@link #NAME_R_CHEST_MIDSAGITTAL_PLANE R_CHEST_MIDSAGITTAL_PLANE}, {@link #NAME_L_BIDELTOID L_BIDELTOID}, {@link #NAME_R_BIDELTOID R_BIDELTOID}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_1 L_CARPAL_DISTAL_PHALANX_1}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_2 L_CARPAL_DISTAL_PHALANX_2}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_3 L_CARPAL_DISTAL_PHALANX_3}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_4 L_CARPAL_DISTAL_PHALANX_4}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_5 L_CARPAL_DISTAL_PHALANX_5}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_1 R_CARPAL_DISTAL_PHALANX_1}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_2 R_CARPAL_DISTAL_PHALANX_2}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_3 R_CARPAL_DISTAL_PHALANX_3}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_4 R_CARPAL_DISTAL_PHALANX_4}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_5 R_CARPAL_DISTAL_PHALANX_5}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_1 L_TARSAL_DISTAL_PHALANX_1}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_2 L_TARSAL_DISTAL_PHALANX_2}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_3 L_TARSAL_DISTAL_PHALANX_3}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_4 L_TARSAL_DISTAL_PHALANX_4}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_5 L_TARSAL_DISTAL_PHALANX_5}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_1 R_TARSAL_DISTAL_PHALANX_1}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_2 R_TARSAL_DISTAL_PHALANX_2}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_3 R_TARSAL_DISTAL_PHALANX_3}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_4 R_TARSAL_DISTAL_PHALANX_4}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_5 R_TARSAL_DISTAL_PHALANX_5}.
	 * @return value of name field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=Name, $memberObjectName=name, $memberObjectName=name)

	public String getName()
	{
		return name;
	}

	/**
	 * Accessor method to assign String enumeration value ("skull_vertex" | "glabella" | "sellion" | "l_infraorbitale" | "l_tragion" | "l_gonion" | "r_infraorbitale" | "r_tragion" | "r_gonion" | "supramenton" | "cervicale" | "adams_apple" | "suprasternale" | "substernale" | "l_clavicle" | "l_acromion" | "l_axilla_proximal" | "l_axilla_distal" | "l_axilla_posterior_folds" | "r_clavicle" | "r_acromion" | "r_axilla_proximal" | "r_axilla_distal" | "r_axilla_posterior_folds" | "spine_1_middle_back" | "spine_2_lower_back" | "waist_preferred_anterior" | "waist_preferred_posterior" | "l_rib10" | "l_thelion" | "r_rib10" | "r_thelion" | "l_asis" | "l_iliocristale" | "l_psis" | "r_asis" | "r_iliocristale" | "r_psis" | "crotch" | "l_femoral_lateral_epicondyle" | "l_femoral_medial_epicondyle" | "l_suprapatella" | "l_trochanterion" | "r_femoral_lateral_epicondyle" | "r_femoral_medial_epicondyle" | "r_suprapatella" | "r_trochanterion" | "l_tibiale" | "l_medial_malleolus" | "l_lateral_malleolus" | "l_sphyrion" | "r_tibiale" | "r_medial_malleolus" | "r_lateral_malleolus" | "r_sphyrion" | "l_metatarsal_phalanx_1" | "l_metatarsal_phalanx_5" | "l_dactylion" | "l_calcaneus_posterior" | "r_metatarsal_phalanx_1" | "r_metatarsal_phalanx_5" | "r_dactylion" | "r_calcaneus_posterior" | "l_humeral_lateral_epicondyle" | "l_humeral_medial_epicondyle" | "l_olecranon" | "r_humeral_lateral_epicondyle" | "r_humeral_medial_epicondyle" | "r_olecranon" | "l_radiale" | "l_ulnar_styloid" | "l_radial_styloid" | "r_radiale" | "r_ulnar_styloid" | "r_radial_styloid" | "l_metacarpal_phalanx_2" | "l_metacarpal_phalanx_3" | "l_metacarpal_phalanx_5" | "r_metacarpal_phalanx_2" | "r_metacarpal_phalanx_3" | "r_metacarpal_phalanx_5" | "nuchale" | "l_neck_base" | "r_neck_base" | "navel" | "l_ectocanthus" | "r_ectocanthus" | "menton" | "mesosternale" | "opisthocranion" | "l_knee_crease" | "r_knee_crease" | "rear_center_midsagittal_plane" | "buttocks_standing_wall_contact_point" | "l_chest_midsagittal_plane" | "r_chest_midsagittal_plane" | "l_bideltoid" | "r_bideltoid" | "l_carpal_distal_phalanx_1" | "l_carpal_distal_phalanx_2" | "l_carpal_distal_phalanx_3" | "l_carpal_distal_phalanx_4" | "l_carpal_distal_phalanx_5" | "r_carpal_distal_phalanx_1" | "r_carpal_distal_phalanx_2" | "r_carpal_distal_phalanx_3" | "r_carpal_distal_phalanx_4" | "r_carpal_distal_phalanx_5" | "l_tarsal_distal_phalanx_1" | "l_tarsal_distal_phalanx_2" | "l_tarsal_distal_phalanx_3" | "l_tarsal_distal_phalanx_4" | "l_tarsal_distal_phalanx_5" | "r_tarsal_distal_phalanx_1" | "r_tarsal_distal_phalanx_2" | "r_tarsal_distal_phalanx_3" | "r_tarsal_distal_phalanx_4" | "r_tarsal_distal_phalanx_5") to inputOutput SFString field named <i>name</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #NAME_SKULL_VERTEX SKULL_VERTEX}, {@link #NAME_GLABELLA GLABELLA}, {@link #NAME_SELLION SELLION}, {@link #NAME_L_INFRAORBITALE L_INFRAORBITALE}, {@link #NAME_L_TRAGION L_TRAGION}, {@link #NAME_L_GONION L_GONION}, {@link #NAME_R_INFRAORBITALE R_INFRAORBITALE}, {@link #NAME_R_TRAGION R_TRAGION}, {@link #NAME_R_GONION R_GONION}, {@link #NAME_SUPRAMENTON SUPRAMENTON}, {@link #NAME_CERVICALE CERVICALE}, {@link #NAME_ADAMS_APPLE ADAMS_APPLE}, {@link #NAME_SUPRASTERNALE SUPRASTERNALE}, {@link #NAME_SUBSTERNALE SUBSTERNALE}, {@link #NAME_L_CLAVICLE L_CLAVICLE}, {@link #NAME_L_ACROMION L_ACROMION}, {@link #NAME_L_AXILLA_PROXIMAL L_AXILLA_PROXIMAL}, {@link #NAME_L_AXILLA_DISTAL L_AXILLA_DISTAL}, {@link #NAME_L_AXILLA_POSTERIOR_FOLDS L_AXILLA_POSTERIOR_FOLDS}, {@link #NAME_R_CLAVICLE R_CLAVICLE}, {@link #NAME_R_ACROMION R_ACROMION}, {@link #NAME_R_AXILLA_PROXIMAL R_AXILLA_PROXIMAL}, {@link #NAME_R_AXILLA_DISTAL R_AXILLA_DISTAL}, {@link #NAME_R_AXILLA_POSTERIOR_FOLDS R_AXILLA_POSTERIOR_FOLDS}, {@link #NAME_SPINE_1_MIDDLE_BACK SPINE_1_MIDDLE_BACK}, {@link #NAME_SPINE_2_LOWER_BACK SPINE_2_LOWER_BACK}, {@link #NAME_WAIST_PREFERRED_ANTERIOR WAIST_PREFERRED_ANTERIOR}, {@link #NAME_WAIST_PREFERRED_POSTERIOR WAIST_PREFERRED_POSTERIOR}, {@link #NAME_L_RIB10 L_RIB10}, {@link #NAME_L_THELION L_THELION}, {@link #NAME_R_RIB10 R_RIB10}, {@link #NAME_R_THELION R_THELION}, {@link #NAME_L_ASIS L_ASIS}, {@link #NAME_L_ILIOCRISTALE L_ILIOCRISTALE}, {@link #NAME_L_PSIS L_PSIS}, {@link #NAME_R_ASIS R_ASIS}, {@link #NAME_R_ILIOCRISTALE R_ILIOCRISTALE}, {@link #NAME_R_PSIS R_PSIS}, {@link #NAME_CROTCH CROTCH}, {@link #NAME_L_FEMORAL_LATERAL_EPICONDYLE L_FEMORAL_LATERAL_EPICONDYLE}, {@link #NAME_L_FEMORAL_MEDIAL_EPICONDYLE L_FEMORAL_MEDIAL_EPICONDYLE}, {@link #NAME_L_SUPRAPATELLA L_SUPRAPATELLA}, {@link #NAME_L_TROCHANTERION L_TROCHANTERION}, {@link #NAME_R_FEMORAL_LATERAL_EPICONDYLE R_FEMORAL_LATERAL_EPICONDYLE}, {@link #NAME_R_FEMORAL_MEDIAL_EPICONDYLE R_FEMORAL_MEDIAL_EPICONDYLE}, {@link #NAME_R_SUPRAPATELLA R_SUPRAPATELLA}, {@link #NAME_R_TROCHANTERION R_TROCHANTERION}, {@link #NAME_L_TIBIALE L_TIBIALE}, {@link #NAME_L_MEDIAL_MALLEOLUS L_MEDIAL_MALLEOLUS}, {@link #NAME_L_LATERAL_MALLEOLUS L_LATERAL_MALLEOLUS}, {@link #NAME_L_SPHYRION L_SPHYRION}, {@link #NAME_R_TIBIALE R_TIBIALE}, {@link #NAME_R_MEDIAL_MALLEOLUS R_MEDIAL_MALLEOLUS}, {@link #NAME_R_LATERAL_MALLEOLUS R_LATERAL_MALLEOLUS}, {@link #NAME_R_SPHYRION R_SPHYRION}, {@link #NAME_L_METATARSAL_PHALANX_1 L_METATARSAL_PHALANX_1}, {@link #NAME_L_METATARSAL_PHALANX_5 L_METATARSAL_PHALANX_5}, {@link #NAME_L_DACTYLION L_DACTYLION}, {@link #NAME_L_CALCANEUS_POSTERIOR L_CALCANEUS_POSTERIOR}, {@link #NAME_R_METATARSAL_PHALANX_1 R_METATARSAL_PHALANX_1}, {@link #NAME_R_METATARSAL_PHALANX_5 R_METATARSAL_PHALANX_5}, {@link #NAME_R_DACTYLION R_DACTYLION}, {@link #NAME_R_CALCANEUS_POSTERIOR R_CALCANEUS_POSTERIOR}, {@link #NAME_L_HUMERAL_LATERAL_EPICONDYLE L_HUMERAL_LATERAL_EPICONDYLE}, {@link #NAME_L_HUMERAL_MEDIAL_EPICONDYLE L_HUMERAL_MEDIAL_EPICONDYLE}, {@link #NAME_L_OLECRANON L_OLECRANON}, {@link #NAME_R_HUMERAL_LATERAL_EPICONDYLE R_HUMERAL_LATERAL_EPICONDYLE}, {@link #NAME_R_HUMERAL_MEDIAL_EPICONDYLE R_HUMERAL_MEDIAL_EPICONDYLE}, {@link #NAME_R_OLECRANON R_OLECRANON}, {@link #NAME_L_RADIALE L_RADIALE}, {@link #NAME_L_ULNAR_STYLOID L_ULNAR_STYLOID}, {@link #NAME_L_RADIAL_STYLOID L_RADIAL_STYLOID}, {@link #NAME_R_RADIALE R_RADIALE}, {@link #NAME_R_ULNAR_STYLOID R_ULNAR_STYLOID}, {@link #NAME_R_RADIAL_STYLOID R_RADIAL_STYLOID}, {@link #NAME_L_METACARPAL_PHALANX_2 L_METACARPAL_PHALANX_2}, {@link #NAME_L_METACARPAL_PHALANX_3 L_METACARPAL_PHALANX_3}, {@link #NAME_L_METACARPAL_PHALANX_5 L_METACARPAL_PHALANX_5}, {@link #NAME_R_METACARPAL_PHALANX_2 R_METACARPAL_PHALANX_2}, {@link #NAME_R_METACARPAL_PHALANX_3 R_METACARPAL_PHALANX_3}, {@link #NAME_R_METACARPAL_PHALANX_5 R_METACARPAL_PHALANX_5}, {@link #NAME_NUCHALE NUCHALE}, {@link #NAME_L_NECK_BASE L_NECK_BASE}, {@link #NAME_R_NECK_BASE R_NECK_BASE}, {@link #NAME_NAVEL NAVEL}, {@link #NAME_L_ECTOCANTHUS L_ECTOCANTHUS}, {@link #NAME_R_ECTOCANTHUS R_ECTOCANTHUS}, {@link #NAME_MENTON MENTON}, {@link #NAME_MESOSTERNALE MESOSTERNALE}, {@link #NAME_OPISTHOCRANION OPISTHOCRANION}, {@link #NAME_L_KNEE_CREASE L_KNEE_CREASE}, {@link #NAME_R_KNEE_CREASE R_KNEE_CREASE}, {@link #NAME_REAR_CENTER_MIDSAGITTAL_PLANE REAR_CENTER_MIDSAGITTAL_PLANE}, {@link #NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT BUTTOCKS_STANDING_WALL_CONTACT_POINT}, {@link #NAME_L_CHEST_MIDSAGITTAL_PLANE L_CHEST_MIDSAGITTAL_PLANE}, {@link #NAME_R_CHEST_MIDSAGITTAL_PLANE R_CHEST_MIDSAGITTAL_PLANE}, {@link #NAME_L_BIDELTOID L_BIDELTOID}, {@link #NAME_R_BIDELTOID R_BIDELTOID}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_1 L_CARPAL_DISTAL_PHALANX_1}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_2 L_CARPAL_DISTAL_PHALANX_2}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_3 L_CARPAL_DISTAL_PHALANX_3}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_4 L_CARPAL_DISTAL_PHALANX_4}, {@link #NAME_L_CARPAL_DISTAL_PHALANX_5 L_CARPAL_DISTAL_PHALANX_5}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_1 R_CARPAL_DISTAL_PHALANX_1}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_2 R_CARPAL_DISTAL_PHALANX_2}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_3 R_CARPAL_DISTAL_PHALANX_3}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_4 R_CARPAL_DISTAL_PHALANX_4}, {@link #NAME_R_CARPAL_DISTAL_PHALANX_5 R_CARPAL_DISTAL_PHALANX_5}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_1 L_TARSAL_DISTAL_PHALANX_1}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_2 L_TARSAL_DISTAL_PHALANX_2}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_3 L_TARSAL_DISTAL_PHALANX_3}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_4 L_TARSAL_DISTAL_PHALANX_4}, {@link #NAME_L_TARSAL_DISTAL_PHALANX_5 L_TARSAL_DISTAL_PHALANX_5}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_1 R_TARSAL_DISTAL_PHALANX_1}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_2 R_TARSAL_DISTAL_PHALANX_2}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_3 R_TARSAL_DISTAL_PHALANX_3}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_4 R_TARSAL_DISTAL_PHALANX_4}, {@link #NAME_R_TARSAL_DISTAL_PHALANX_5 R_TARSAL_DISTAL_PHALANX_5}).
	 * <br><br>
	 * <i>Tooltip:</i> Unique name attribute must be defined so that HAnimDisplacer node can be identified at run time for animation purposes.
 * <ul>
 *  <li> <i>Hint:</i> HAnimDisplacer names are based on feature point names. </li> 
 *  <li> <i>Hint:</i> <a href="https://www.web3d.org/documents/specifications/19774/V2.0/Architecture/FeaturePoints.html" target="_blank">https://www.web3d.org/documents/specifications/19774/V2.0/Architecture/FeaturePoints.html</a> </li> 
 *  <li> <i>Warning:</i> allowed name suffixes include _feature, _action and _config. </li> 
 *  <li> <i>Warning:</i> name prefix must match ancestor HAnimHumanoid name followed by underscore character, if more than one humanoid appears within a scene file. For example, 'Nancy_' prepended before location name. </li> 
 *  <li> <i>Warning:</i> name field is not included if this instance is a USE node, in order to avoid potential mismatches. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i> X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 *  <li> <i>Hint:</i>  HAnim2 Names HAnim1 Alias Tables <a href="https://www.web3d.org/x3d/content/examples/HumanoidAnimation/HAnim2NameHAnim1AliasTables.txt" target="_blank">https://www.web3d.org/x3d/content/examples/HumanoidAnimation/HAnim2NameHAnim1AliasTables.txt</a> </li> 
 * </ul>
	 * <br><br>@see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">X3D Scene Authoring Hints: Naming Conventions</a>
	 * @param newValue is new value for the name field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final HAnimDisplacer setName(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph

//		String  namingMessage = new String();
//              boolean namingMessageAlreadyProvided = false;

                if (!newValue.toString().replace("\"","").equals(newValue.toLowerCase()) && !namingMessageAlreadyProvided)
		{
				namingMessage += "[info] recommended HAnim name values are lower case, note capitalization/spelling of HAnimDisplacer name='" + newValue + "'";
                                namingMessageAlreadyProvided = true;
		}
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(NAME_SKULL_VERTEX) ||
			newValue.toString().replace("\"","").equals(NAME_GLABELLA) ||
			newValue.toString().replace("\"","").equals(NAME_SELLION) ||
			newValue.toString().replace("\"","").equals(NAME_L_INFRAORBITALE) ||
			newValue.toString().replace("\"","").equals(NAME_L_TRAGION) ||
			newValue.toString().replace("\"","").equals(NAME_L_GONION) ||
			newValue.toString().replace("\"","").equals(NAME_R_INFRAORBITALE) ||
			newValue.toString().replace("\"","").equals(NAME_R_TRAGION) ||
			newValue.toString().replace("\"","").equals(NAME_R_GONION) ||
			newValue.toString().replace("\"","").equals(NAME_SUPRAMENTON) ||
			newValue.toString().replace("\"","").equals(NAME_CERVICALE) ||
			newValue.toString().replace("\"","").equals(NAME_ADAMS_APPLE) ||
			newValue.toString().replace("\"","").equals(NAME_SUPRASTERNALE) ||
			newValue.toString().replace("\"","").equals(NAME_SUBSTERNALE) ||
			newValue.toString().replace("\"","").equals(NAME_L_CLAVICLE) ||
			newValue.toString().replace("\"","").equals(NAME_L_ACROMION) ||
			newValue.toString().replace("\"","").equals(NAME_L_AXILLA_PROXIMAL) ||
			newValue.toString().replace("\"","").equals(NAME_L_AXILLA_DISTAL) ||
			newValue.toString().replace("\"","").equals(NAME_L_AXILLA_POSTERIOR_FOLDS) ||
			newValue.toString().replace("\"","").equals(NAME_R_CLAVICLE) ||
			newValue.toString().replace("\"","").equals(NAME_R_ACROMION) ||
			newValue.toString().replace("\"","").equals(NAME_R_AXILLA_PROXIMAL) ||
			newValue.toString().replace("\"","").equals(NAME_R_AXILLA_DISTAL) ||
			newValue.toString().replace("\"","").equals(NAME_R_AXILLA_POSTERIOR_FOLDS) ||
			newValue.toString().replace("\"","").equals(NAME_SPINE_1_MIDDLE_BACK) ||
			newValue.toString().replace("\"","").equals(NAME_SPINE_2_LOWER_BACK) ||
			newValue.toString().replace("\"","").equals(NAME_WAIST_PREFERRED_ANTERIOR) ||
			newValue.toString().replace("\"","").equals(NAME_WAIST_PREFERRED_POSTERIOR) ||
			newValue.toString().replace("\"","").equals(NAME_L_RIB10) ||
			newValue.toString().replace("\"","").equals(NAME_L_THELION) ||
			newValue.toString().replace("\"","").equals(NAME_R_RIB10) ||
			newValue.toString().replace("\"","").equals(NAME_R_THELION) ||
			newValue.toString().replace("\"","").equals(NAME_L_ASIS) ||
			newValue.toString().replace("\"","").equals(NAME_L_ILIOCRISTALE) ||
			newValue.toString().replace("\"","").equals(NAME_L_PSIS) ||
			newValue.toString().replace("\"","").equals(NAME_R_ASIS) ||
			newValue.toString().replace("\"","").equals(NAME_R_ILIOCRISTALE) ||
			newValue.toString().replace("\"","").equals(NAME_R_PSIS) ||
			newValue.toString().replace("\"","").equals(NAME_CROTCH) ||
			newValue.toString().replace("\"","").equals(NAME_L_FEMORAL_LATERAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_L_FEMORAL_MEDIAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_L_SUPRAPATELLA) ||
			newValue.toString().replace("\"","").equals(NAME_L_TROCHANTERION) ||
			newValue.toString().replace("\"","").equals(NAME_R_FEMORAL_LATERAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_R_FEMORAL_MEDIAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_R_SUPRAPATELLA) ||
			newValue.toString().replace("\"","").equals(NAME_R_TROCHANTERION) ||
			newValue.toString().replace("\"","").equals(NAME_L_TIBIALE) ||
			newValue.toString().replace("\"","").equals(NAME_L_MEDIAL_MALLEOLUS) ||
			newValue.toString().replace("\"","").equals(NAME_L_LATERAL_MALLEOLUS) ||
			newValue.toString().replace("\"","").equals(NAME_L_SPHYRION) ||
			newValue.toString().replace("\"","").equals(NAME_R_TIBIALE) ||
			newValue.toString().replace("\"","").equals(NAME_R_MEDIAL_MALLEOLUS) ||
			newValue.toString().replace("\"","").equals(NAME_R_LATERAL_MALLEOLUS) ||
			newValue.toString().replace("\"","").equals(NAME_R_SPHYRION) ||
			newValue.toString().replace("\"","").equals(NAME_L_METATARSAL_PHALANX_1) ||
			newValue.toString().replace("\"","").equals(NAME_L_METATARSAL_PHALANX_5) ||
			newValue.toString().replace("\"","").equals(NAME_L_DACTYLION) ||
			newValue.toString().replace("\"","").equals(NAME_L_CALCANEUS_POSTERIOR) ||
			newValue.toString().replace("\"","").equals(NAME_R_METATARSAL_PHALANX_1) ||
			newValue.toString().replace("\"","").equals(NAME_R_METATARSAL_PHALANX_5) ||
			newValue.toString().replace("\"","").equals(NAME_R_DACTYLION) ||
			newValue.toString().replace("\"","").equals(NAME_R_CALCANEUS_POSTERIOR) ||
			newValue.toString().replace("\"","").equals(NAME_L_HUMERAL_LATERAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_L_HUMERAL_MEDIAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_L_OLECRANON) ||
			newValue.toString().replace("\"","").equals(NAME_R_HUMERAL_LATERAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_R_HUMERAL_MEDIAL_EPICONDYLE) ||
			newValue.toString().replace("\"","").equals(NAME_R_OLECRANON) ||
			newValue.toString().replace("\"","").equals(NAME_L_RADIALE) ||
			newValue.toString().replace("\"","").equals(NAME_L_ULNAR_STYLOID) ||
			newValue.toString().replace("\"","").equals(NAME_L_RADIAL_STYLOID) ||
			newValue.toString().replace("\"","").equals(NAME_R_RADIALE) ||
			newValue.toString().replace("\"","").equals(NAME_R_ULNAR_STYLOID) ||
			newValue.toString().replace("\"","").equals(NAME_R_RADIAL_STYLOID) ||
			newValue.toString().replace("\"","").equals(NAME_L_METACARPAL_PHALANX_2) ||
			newValue.toString().replace("\"","").equals(NAME_L_METACARPAL_PHALANX_3) ||
			newValue.toString().replace("\"","").equals(NAME_L_METACARPAL_PHALANX_5) ||
			newValue.toString().replace("\"","").equals(NAME_R_METACARPAL_PHALANX_2) ||
			newValue.toString().replace("\"","").equals(NAME_R_METACARPAL_PHALANX_3) ||
			newValue.toString().replace("\"","").equals(NAME_R_METACARPAL_PHALANX_5) ||
			newValue.toString().replace("\"","").equals(NAME_NUCHALE) ||
			newValue.toString().replace("\"","").equals(NAME_L_NECK_BASE) ||
			newValue.toString().replace("\"","").equals(NAME_R_NECK_BASE) ||
			newValue.toString().replace("\"","").equals(NAME_NAVEL) ||
			newValue.toString().replace("\"","").equals(NAME_L_ECTOCANTHUS) ||
			newValue.toString().replace("\"","").equals(NAME_R_ECTOCANTHUS) ||
			newValue.toString().replace("\"","").equals(NAME_MENTON) ||
			newValue.toString().replace("\"","").equals(NAME_MESOSTERNALE) ||
			newValue.toString().replace("\"","").equals(NAME_OPISTHOCRANION) ||
			newValue.toString().replace("\"","").equals(NAME_L_KNEE_CREASE) ||
			newValue.toString().replace("\"","").equals(NAME_R_KNEE_CREASE) ||
			newValue.toString().replace("\"","").equals(NAME_REAR_CENTER_MIDSAGITTAL_PLANE) ||
			newValue.toString().replace("\"","").equals(NAME_BUTTOCKS_STANDING_WALL_CONTACT_POINT) ||
			newValue.toString().replace("\"","").equals(NAME_L_CHEST_MIDSAGITTAL_PLANE) ||
			newValue.toString().replace("\"","").equals(NAME_R_CHEST_MIDSAGITTAL_PLANE) ||
			newValue.toString().replace("\"","").equals(NAME_L_BIDELTOID) ||
			newValue.toString().replace("\"","").equals(NAME_R_BIDELTOID) ||
			newValue.toString().replace("\"","").equals(NAME_L_CARPAL_DISTAL_PHALANX_1) ||
			newValue.toString().replace("\"","").equals(NAME_L_CARPAL_DISTAL_PHALANX_2) ||
			newValue.toString().replace("\"","").equals(NAME_L_CARPAL_DISTAL_PHALANX_3) ||
			newValue.toString().replace("\"","").equals(NAME_L_CARPAL_DISTAL_PHALANX_4) ||
			newValue.toString().replace("\"","").equals(NAME_L_CARPAL_DISTAL_PHALANX_5) ||
			newValue.toString().replace("\"","").equals(NAME_R_CARPAL_DISTAL_PHALANX_1) ||
			newValue.toString().replace("\"","").equals(NAME_R_CARPAL_DISTAL_PHALANX_2) ||
			newValue.toString().replace("\"","").equals(NAME_R_CARPAL_DISTAL_PHALANX_3) ||
			newValue.toString().replace("\"","").equals(NAME_R_CARPAL_DISTAL_PHALANX_4) ||
			newValue.toString().replace("\"","").equals(NAME_R_CARPAL_DISTAL_PHALANX_5) ||
			newValue.toString().replace("\"","").equals(NAME_L_TARSAL_DISTAL_PHALANX_1) ||
			newValue.toString().replace("\"","").equals(NAME_L_TARSAL_DISTAL_PHALANX_2) ||
			newValue.toString().replace("\"","").equals(NAME_L_TARSAL_DISTAL_PHALANX_3) ||
			newValue.toString().replace("\"","").equals(NAME_L_TARSAL_DISTAL_PHALANX_4) ||
			newValue.toString().replace("\"","").equals(NAME_L_TARSAL_DISTAL_PHALANX_5) ||
			newValue.toString().replace("\"","").equals(NAME_R_TARSAL_DISTAL_PHALANX_1) ||
			newValue.toString().replace("\"","").equals(NAME_R_TARSAL_DISTAL_PHALANX_2) ||
			newValue.toString().replace("\"","").equals(NAME_R_TARSAL_DISTAL_PHALANX_3) ||
			newValue.toString().replace("\"","").equals(NAME_R_TARSAL_DISTAL_PHALANX_4) ||
			newValue.toString().replace("\"","").equals(NAME_R_TARSAL_DISTAL_PHALANX_5)))
		{
			String warningMessage = "[info] HAnimDisplacer name newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!nameWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "       Supported values are skull_vertex, glabella, sellion, l_infraorbitale, l_tragion, l_gonion, r_infraorbitale, r_tragion, r_gonion, supramenton, cervicale, adams_apple, suprasternale, substernale, l_clavicle, l_acromion, l_axilla_proximal, l_axilla_distal, l_axilla_posterior_folds, r_clavicle, r_acromion, r_axilla_proximal, r_axilla_distal, r_axilla_posterior_folds, spine_1_middle_back, spine_2_lower_back, waist_preferred_anterior, waist_preferred_posterior, l_rib10, l_thelion, r_rib10, r_thelion, l_asis, l_iliocristale, l_psis, r_asis, r_iliocristale, r_psis, crotch, l_femoral_lateral_epicondyle, l_femoral_medial_epicondyle, l_suprapatella, l_trochanterion, r_femoral_lateral_epicondyle, r_femoral_medial_epicondyle, r_suprapatella, r_trochanterion, l_tibiale, l_medial_malleolus, l_lateral_malleolus, l_sphyrion, r_tibiale, r_medial_malleolus, r_lateral_malleolus, r_sphyrion, l_metatarsal_phalanx_1, l_metatarsal_phalanx_5, l_dactylion, l_calcaneus_posterior, r_metatarsal_phalanx_1, r_metatarsal_phalanx_5, r_dactylion, r_calcaneus_posterior, l_humeral_lateral_epicondyle, l_humeral_medial_epicondyle, l_olecranon, r_humeral_lateral_epicondyle, r_humeral_medial_epicondyle, r_olecranon, l_radiale, l_ulnar_styloid, l_radial_styloid, r_radiale, r_ulnar_styloid, r_radial_styloid, l_metacarpal_phalanx_2, l_metacarpal_phalanx_3, l_metacarpal_phalanx_5, r_metacarpal_phalanx_2, r_metacarpal_phalanx_3, r_metacarpal_phalanx_5, nuchale, l_neck_base, r_neck_base, navel, l_ectocanthus, r_ectocanthus, menton, mesosternale, opisthocranion, l_knee_crease, r_knee_crease, rear_center_midsagittal_plane, buttocks_standing_wall_contact_point, l_chest_midsagittal_plane, r_chest_midsagittal_plane, l_bideltoid, r_bideltoid, l_carpal_distal_phalanx_1, l_carpal_distal_phalanx_2, l_carpal_distal_phalanx_3, l_carpal_distal_phalanx_4, l_carpal_distal_phalanx_5, r_carpal_distal_phalanx_1, r_carpal_distal_phalanx_2, r_carpal_distal_phalanx_3, r_carpal_distal_phalanx_4, r_carpal_distal_phalanx_5, l_tarsal_distal_phalanx_1, l_tarsal_distal_phalanx_2, l_tarsal_distal_phalanx_3, l_tarsal_distal_phalanx_4, l_tarsal_distal_phalanx_5, r_tarsal_distal_phalanx_1, r_tarsal_distal_phalanx_2, r_tarsal_distal_phalanx_3, r_tarsal_distal_phalanx_4, r_tarsal_distal_phalanx_5";
			    nameWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
			if (!namingMessage.trim().isEmpty() && ConfigurationProperties.isConsoleOutputVerbose())
              System.out.println(namingMessage);
		}
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to HAnimDisplacer name
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("HAnimDisplacer name newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}

        if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.meetsX3dInteroperabilityNamingConventions(newValue))
		{
			if (ConfigurationProperties.isConsoleOutputVerbose())
                          System.out.println("[warning] HAnimDisplacer name newValue='" + newValue + "'" + 
				" has name value that does not meet X3D naming conventions.");
		}
		name = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString name field, similar to {@link #setName(String)}.
	 * @param newValue is new value for the name field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setName(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setName(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value from inputOutput SFFloat field named <i>weight</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The weigh factor has typical range [0,1] and defines the scale factor applied to displacement values before adding them to neutral vertex positions.
 * <ul>
 *  <li> <i> Hint:</i>  apply a non-zero weight factor to see the effect of HAnimDisplacer displacements. </li> 
 * </ul>
	 * @return value of weight field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=Weight, $memberObjectName=weight, $memberObjectName=weight)

	public float getWeight()
	{
		return weight;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>weight</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The weigh factor has typical range [0,1] and defines the scale factor applied to displacement values before adding them to neutral vertex positions.
 * <ul>
 *  <li> <i> Hint:</i>  apply a non-zero weight factor to see the effect of HAnimDisplacer displacements. </li> 
 * </ul>
	 * @param newValue is new value for the weight field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public HAnimDisplacer setWeight(float newValue)
	{
		// set-newValue-validity-checks #0.a
		weight = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat weight field, similar to {@link #setWeight(float)}.
	 * @param newValue is new value for the weight field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setWeight(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setWeight(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setWeight(float)}.
	 * @param newValue is new value for field
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setWeight(double newValue)
	{
		return setWeight((float) newValue);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes.  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes.  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final HAnimDisplacer setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to HAnimDisplacer DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("HAnimDisplacer DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final HAnimDisplacer setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to HAnimDisplacer USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("HAnimDisplacer USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final HAnimDisplacer setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final HAnimDisplacer setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometricPropertyNode, $additionalInheritanceBaseType=, $thisClassName=HAnimDisplacer, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final HAnimDisplacer setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	/** Return reference to ancestor HAnimHumanoid
	 * @return HAnimHumanoid if found, otherwise null
	 */
	public HAnimHumanoid getAncestorHAnimHumanoid()
	{
		X3DConcreteElement parentElement = ((X3DConcreteElement)this).getParent();;
		while (parentElement != null)
		{
			if (parentElement instanceof HAnimHumanoid)
				return (HAnimHumanoid) parentElement;
			parentElement = ((X3DConcreteElement)this).getParent();
		}
		return null;
	}
	/** Return whether ancestor HAnimHumanoid is available
	 * @return true if ancestor HAnimHumanoid found
	 */
	public boolean hasAncestorHAnimHumanoid()
	{
		return (getAncestorHAnimHumanoid() != null);
	}

	/** Return version of ancestor HAnimHumanoid
	 * @return version if found, otherwise "-1"
	 */
	public String getHAnimVersion()
	{
		if (hasAncestorHAnimHumanoid())
			return getAncestorHAnimHumanoid().getVersion();
		else return "-1";
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public HAnimDisplacer setUSE(HAnimDisplacer DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "*** setUSE(DEFnode) invoked on HAnimDisplacer" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public HAnimDisplacer (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Utility constructor that assigns both DEF label and name, after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 * @param newName  name for this meta element
	 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#HAnimDisplacer">X3D Tooltips: HAnimDisplacer</a>
	 */
	public HAnimDisplacer (String DEFlabel, String newName)
	{
		initialize();
		setDEF  (DEFlabel);
		setName (newName);
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public HAnimDisplacer addComments (String newComment)
	{
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public HAnimDisplacer addComments (String[] newComments)
	{
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link HAnimDisplacer} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public HAnimDisplacer addComments (CommentsBlock newCommentsBlock)
	{
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}

	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null) || 
		                        !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<HAnimDisplacer"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
			if (!getName().equals(NAME_DEFAULT_VALUE))
			{
				stringX3D.append(" name='").append(SFString.toString(getName())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isBlank() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((((getCoordIndex().length > 0) && !getCoordIndexList().equals(COORDINDEX_DEFAULT_VALUE)) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList .x3d compare */ && !hasUSE())
			{
				stringX3D.append(" coordIndex='").append(MFInt32.toString(getCoordIndex())).append("'");
			}
			if ((!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" description='").append(new SFString(getDescription()).toStringX3D()).append("'");
			}
			if ((((getDisplacements().length > 0) && !getDisplacements().equals(DISPLACEMENTS_DEFAULT_VALUE)) || !ConfigurationProperties.getStripDefaultAttributes()) /* otherwise */ && !hasUSE())
			{
				stringX3D.append(" displacements='").append(MFVec3f.toString(getDisplacements())).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
			if (((getWeight() != WEIGHT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" weight='").append(SFFloat.toString(getWeight())).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

                        if (!commentsList.isEmpty())
                        {
                                CommentsBlock commentsBlock = new CommentsBlock(commentsList);
                                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
                        }
			// recursively iterate over child elements
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</HAnimDisplacer>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=HAnimDisplacer, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null) || 
		                        !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
                if (!serializingVRML97output)
                    handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("HAnimDisplacer").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("coordIndex"))
						{
							stringClassicVRML.append(indentCharacter).append("coordIndex").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (((getCoordIndex().length > 0) && !getCoordIndexList().equals(COORDINDEX_DEFAULT_VALUE)) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList .x3dv compare */
				{
					stringClassicVRML.append("coordIndex ").append("[ ").append(MFInt32.toString(getCoordIndex())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("description"))
						{
							stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("description ").append("\"").append(SFString.toString(getDescription())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("displacements"))
						{
							stringClassicVRML.append(indentCharacter).append("displacements").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getDisplacements().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("displacements ").append("[ ").append(MFVec3f.toString(getDisplacements())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("name"))
						{
							stringClassicVRML.append(indentCharacter).append("name").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getName().equals(NAME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("name ").append("\"").append(SFString.toString(getName())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("weight"))
						{
							stringClassicVRML.append(indentCharacter).append("weight").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getWeight() != WEIGHT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("weight ").append(SFFloat.toString(getWeight())).append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s) (including USE), comment(s), IS/connect and/or source code
		{
                        // recursively iterate over child elements

			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}stringClassicVRML.append("\n").append(indent).append("\n"); // .append(" ### trace field initialization value #8")

			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (getUSE().isEmpty() && (hasAttributes || hasChild))
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}


    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms

	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
            serializingVRML97output = true;
            String result = toStringClassicVRML(indentLevel);
            serializingVRML97output = false;

            return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (elementName == null)
			elementName = "";
		if (getName().equals(nameValue) &&
			(elementName.isEmpty() || elementName.equals(getElementName())))
			return this;
		X3DConcreteElement referenceElement;
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}


	/**
	 * Recursive method to validate this element plus all contained nodes and statements,
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
         * TODO document specific validation methods.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setCoordIndex(getCoordIndex()); // exercise field checks, simple types
        
		setDescription(getDescription()); // exercise field checks, simple types
        
		setDisplacements(getDisplacements()); // exercise field checks, simple types
        
		if (getName().isEmpty() && !hasUSE()) // required attribute
		{
			String errorNotice = ConfigurationProperties.ERROR_VALUE_NOT_FOUND +
					     ", " + NAME + " name field is required but no value found.";
			validationResult.append(errorNotice).append("\n");
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		// TODO duplicated name checks in setValue() method
		setName(getName()); // exercise field checks, simple types
        
		setWeight(getWeight()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
            if (hasUSE() && hasIS()) // test USE restrictions
            {
                String errorNotice = "*** HAnimDisplacer USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasMetadata()) // test USE restrictions
            {
                String errorNotice = "*** HAnimDisplacer USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
         // test for correct parent
         X3DConcreteElement parent = getParent();
         if (hasParent())
         {
            if (!parent.getElementName().equals(HAnimJoint.NAME) && !parent.getElementName().equals(HAnimSegment.NAME) &&
                !parent.getElementName().equals(ProtoBody.NAME) && !parent.getElementName().equals(field.NAME) && !parent.getElementName().equals(fieldValue.NAME))
            {
                String errorNotice = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE +
                    ": illegal parent for HAnimDisplacer DEF='" + getDEF() + "', found " + parent.getElementName() + " instead of HAnimJoint or HAnimSegment" ;
                validationResult.append(errorNotice).append("\n");
                throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
            }
        }

		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "*** IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isBlank() &&
			!Arrays.asList(containerField_ALLOWED_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALLOWED_VALUES='" +
				new MFString(containerField_ALLOWED_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);

			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'HAnimDisplacer' node, ensure sufficient support by adding head statement <component name='HAnim' level='1'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"HAnim\").setLevel(1);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
