/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Geospatial;
// import org.web3d.x3d.sai.Networking.X3DUrlObject;

import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
import java.util.Arrays;

/**
 * GeoMetadata includes a generic subset of metadata about the geographic data.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>GeoMetadata node tooltip</i>: [X3DInfoNode] GeoMetadata includes a generic subset of metadata about the geographic data.
 * <ul>
 *  <li> <i>Hint:</i> X3D for Advanced Modeling (X3D4AM) slideset <a href="https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/GeospatialComponentX3dEarth.pdf" target="_blank">https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/GeospatialComponentX3dEarth.pdf</a> </li> 
 *  <li> <i>Warning:</i> requires X3D profile='Full' or else include &amp;lt;component name='Geospatial' level='1'/&amp;gt; </li> 
 *  <li> <i>Hint:</i>  when parent node is LoadSensor, apply containerField='children' (X3Dv4) or containerField='watchList' (X3Dv3). <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#GeoMetadata" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geospatial.html#GeoMetadata" target="blank">X3D Abstract Specification: GeoMetadata</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#GeoMetadata" target="_blank">X3D Tooltips: GeoMetadata</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface GeoMetadata extends  org.web3d.x3d.sai.Core.X3DInfoNode,  org.web3d.x3d.sai.Networking.X3DUrlObject
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefresh defines interval in seconds before automatic reload of current url asset is performed.
 * <ul>
 *  <li> <i>Hint:</i> if preceding file loading fails or load field is false, no refresh is performed. </li> 
 *  <li> <i>Hint:</i> repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @return value of autoRefresh field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=AutoRefresh, $memberObjectName=autoRefresh, $memberObjectName=autoRefresh)

	public double getAutoRefresh();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefresh defines interval in seconds before automatic reload of current url asset is performed.
 * <ul>
 *  <li> <i>Hint:</i> if preceding file loading fails or load field is false, no refresh is performed. </li> 
 *  <li> <i>Hint:</i> repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @param newValue is new value for the autoRefresh field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeoMetadata setAutoRefresh(double newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur.
 * <ul>
 *  <li> <i>Hint:</i> Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @return value of autoRefreshTimeLimit field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=AutoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit)

	public double getAutoRefreshTimeLimit();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur.
 * <ul>
 *  <li> <i>Hint:</i> Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @param newValue is new value for the autoRefreshTimeLimit field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeoMetadata setAutoRefreshTimeLimit(double newValue);

	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) from inputOutput MFNode field <i>data</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF list of all nodes that implement this data. If no specific geospatial nodes are identified, then this GeoMetadata node pertains to entire scene.  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DNode.
	 * @see org.web3d.x3d.sai.Core.X3DNode
	 * @return value of data field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=Data, $memberObjectName=data, $memberObjectName=data)
	public org.web3d.x3d.sai.Core.X3DNode[] getData(); // acceptable node types #1: X3DNode

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>data</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF list of all nodes that implement this data. If no specific geospatial nodes are identified, then this GeoMetadata node pertains to entire scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DNode.
	 * @param newValue is new value for the data field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public GeoMetadata setData(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #2: X3DNode

	/**
	 * Add array of child data nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DNode.
	 * @param newValue is new value array to be appended the data field.
	 */
	public void addData(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #3: X3DNode
	/**
	 * Set single child data node, replacing prior array of existing nodes (if any).
	 * @param newValue is new node for the data field
	 */
	public void setData(org.web3d.x3d.sai.Core.X3DNode newValue); // acceptable node types #5: X3DNode
	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeoMetadata setDescription(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i> load=true means load immediately, load=false means defer loading or else unload a previously loaded scene.
 * <ul>
 *  <li> <i>Hint:</i> allows author to design when Inline loading occurs via user interaction, event chains or scripting. </li> 
 *  <li> <i>Hint:</i>  use a separate LoadSensor node to detect when loading is complete. </li> 
 * </ul>
	 * @return value of load field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=Load, $memberObjectName=load, $memberObjectName=load)

	public boolean getLoad();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i> load=true means load immediately, load=false means defer loading or else unload a previously loaded scene.
 * <ul>
 *  <li> <i>Hint:</i> allows author to design when Inline loading occurs via user interaction, event chains or scripting. </li> 
 *  <li> <i>Hint:</i>  use a separate LoadSensor node to detect when loading is complete. </li> 
 * </ul>
	 * @param newValue is new value for the load field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeoMetadata setLoad(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeoMetadata setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide array of String results from inputOutput MFString field named <i>summary</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The summary string array contains a set of keyword/value pairs, with each keyword and its subsequent value contained in separate strings.
 * <ul>
 *  <li> <i>Hint:</i> example &amp;lt;GeoMetadata summary=' "title" "San Francisco, California USA" '/&amp;gt;. </li> 
 *  <li> <i>Hint:</i>  Table 25.5, GeoMetadata keywords and values <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geospatial.html#t-keywordsandvaluesHint" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geospatial.html#t-keywordsandvaluesHint</a>: there should always be an even (or zero) number of strings to match key-value paired strings. </li> 
 * </ul>
	 * @return value of summary field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=Summary, $memberObjectName=summary, $memberObjectName=summary)
	public String[] getSummary();

	/**
	 * Accessor method to assign String array to inputOutput MFString field named <i>summary</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The summary string array contains a set of keyword/value pairs, with each keyword and its subsequent value contained in separate strings.
 * <ul>
 *  <li> <i>Hint:</i> example &amp;lt;GeoMetadata summary=' "title" "San Francisco, California USA" '/&amp;gt;. </li> 
 *  <li> <i>Hint:</i>  Table 25.5, GeoMetadata keywords and values <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geospatial.html#t-keywordsandvaluesHint" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geospatial.html#t-keywordsandvaluesHint</a>: there should always be an even (or zero) number of strings to match key-value paired strings. </li> 
 * </ul>
	 * @param newValue is new value for the summary field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public GeoMetadata setSummary(String[] newValue);

	/**
	 * Provide array of String results from inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Hypertext link to an external, complete metadata description.
 * <ul>
 *  <li> <i>Hint:</i> MFString arrays can have multiple values, so separate each individual string by quote marks "<a href="https://www.web3d.org" target="_blank">https://www.web3d.org</a>" "<a href="https://www.web3d.org/about" target="_blank">https://www.web3d.org/about</a>" "etc." </li> 
 *  <li> <i>Hint:</i> alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). </li> 
 *  <li> <i>Warning:</i> strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. </li> 
 *  <li> <i>Hint:</i> can replace embedded blank(s) in url queries with %20 for each blank character. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, urls <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls</a> </li> 
 * </ul>
	 * @return value of url field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DInfoNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=GeoMetadata, $CamelCaseName=Url, $memberObjectName=url, $memberObjectName=url)

	public String[] getUrl();

	/**
	 * Accessor method to assign String array to inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Hypertext link to an external, complete metadata description.
 * <ul>
 *  <li> <i>Hint:</i> MFString arrays can have multiple values, so separate each individual string by quote marks "<a href="https://www.web3d.org" target="_blank">https://www.web3d.org</a>" "<a href="https://www.web3d.org/about" target="_blank">https://www.web3d.org/about</a>" "etc." </li> 
 *  <li> <i>Hint:</i> alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). </li> 
 *  <li> <i>Warning:</i> strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. </li> 
 *  <li> <i>Hint:</i> can replace embedded blank(s) in url queries with %20 for each blank character. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, urls <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls</a> </li> 
 * </ul>
	 * @param newValue is new value for the url field.
	 * @return {@link GeoMetadata} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeoMetadata setUrl(String[] newValue);

}
