////////////////////////////////////////////////////////////////////////////
// VRML browser 
//
public class VrmlBrowser extends vrml.external.Browser
{
	////////////////////////////////////////////////////////////////////////////
	// VrmlBrowser(); constructor
	// Parameters:
	//     applet - the applet reference to use
	// Return values:
	//     none
	// Remarks:
	//     Get a browser from the given java applet reference as a base in the
	//     current HTML page. Used when attempting to access a browser on the 
	//     current page as this applet and is the first browser on the page.
	public VrmlBrowser(EaiSample applet, int index)
	{
		super(applet, "", index);
		m_applet = applet;
	}

	////////////////////////////////////////////////////////////////////////////
	// VrmlBrowser(); constructor
	// Parameters:
	//     applet - the applet reference to use
	//     frame - the name of the frame to look into for the browser
	// Return values:
	//     none
	// Remarks:
	//     Get a browser from the given java applet reference one some named 
	//     page and at some embbed location. Used when attempting to access
	//     a browser on another HTML page within a multi-framed environment.
	public VrmlBrowser(EaiSample applet, String frame)
	{
		super(applet, frame, 0);
		m_applet = applet;
	}

	////////////////////////////////////////////////////////////////////////////
	// initialize()
	// Parameters:
	//     none
	// Return values:
	//     none
	// Remarks:
	//     This method is called when the browser complete the initial loading
	//     of the world.
	public void initialize()
	{
		m_applet.onBrowserReady();
	}
	private EaiSample m_applet;
}
