import java.awt.*;
import java.applet.*;

import vrml.external.Browser;
import vrml.external.Node;
import PseudoTimer;

public class LoadURL extends Applet
	{
	Browser browser = null;
	String BrowserName, BrowserVersion;
	TextField FileName;
	Button Load;
	PseudoTimer timer = null;
	protected int getBrowserIndexParameter()
	{
		try
		{
			return Integer.parseInt(getParameter("BrowserIndex"));
			
		}
		catch (NumberFormatException e)
		{
			return 0;
		}
	}
	public void init()
	{
		int index = getBrowserIndexParameter();
		setBackground(Color.white);
		for ( int i=0; i<20; i++ )
			{
			browser = (Browser)vrml.external.Browser.getBrowser(this, "", index);
			if ( browser != null ) break;
			try {Thread.sleep (200);}
			catch (InterruptedException ignored) {break;}
			}
		
		if ( browser == null )
			{
			BrowserName = "Browser not found";
			BrowserVersion = "0.0";
			}
		else
			{
			BrowserName = browser.getName();
			BrowserVersion = browser.getVersion();
			timer = new PseudoTimer ( this );
			timer.start ();
			}
		add ( FileName = new TextField ( browser.getWorldURL(),28) );
		add ( Load = new Button ( "loadURL" ) );
		Load.setBackground(Color.white);
	}

	public void start()
		{
		}
	
	public void paint ( Graphics  g )
		{
		String s = "Browser: ";
		s = s + BrowserName;
		g.drawString(s, 5, 15);
		s = "Version: ";
		s = s + BrowserVersion;
		g.drawString(s, 5, 30);
		FileName.move(5, 35);
		Load.move(5, 60);
		}

	public boolean handleEvent ( Event  evt )
		{
		if ( evt.id == 3000 )
			{ repaint (); return true; }

		if ( evt.target instanceof Button && evt.id == 1001 )
			{
			Button b = (Button) evt.target;
			if ( b.getLabel() == Load.getLabel() )
				{
				String[] urls = { FileName.getText() };
				System.err.println("url = "+FileName.getText());
				if ( browser != null )
					browser.loadURL (urls, null);
				}
			}
		return false;
		}
	}