import java.awt.*;
import java.applet.*;
import vrml.external.*;

public class FromString extends Applet
{
	protected int getBrowserIndexParameter()
	{
		try
		{
			return Integer.parseInt(getParameter("BrowserIndex"));
		}
		catch (NumberFormatException e)
		{
			return 0;
		}
	}

	public void init()
	{
//		setLayout(new BorderLayout());
		setBackground(new Color(252, 252, 252));	
		int index = getBrowserIndexParameter();
		for (int i = 0; i < 20; i++)
		{
			browser = (Browser)vrml.external.Browser.getBrowser(this, null, index);
			if (browser != null) 
				break;
			try
			{
				Thread.sleep (200);
			}
			catch (InterruptedException e)
			{
				break;
			}
		}
		
		if (browser != null)
		{
			text = new TextArea("#VRML V2.0 utf8\nShape { geometry Cone {}\n\tappearance Appearance {\n\t\tmaterial Material {\n\t\t\tdiffuseColor 1 0 0\n\t\t}\n\t}\n}");
			create = new Button("createVrmlFromString");
			create.setBackground(Color.white);
			add(text);
//			Container container = new Panel();
//			add("South", container);
//			container.setLayout(new FlowLayout());
//			container.setLayout(new GridLayout(1, 2));
//			container.add("1", create);
//			container.add(new Panel());
//			container.add(new Panel());
			
//			container.add(new Label("Create VRML from string"));
			add(create);
		}
	}

	public void paint (Graphics g)
	{
		text.reshape(5, 0, 250, 120);
		create.move(5, 122);
	}

	public void doExample()
	{
			browser.replaceWorld (browser.createVrmlFromString (text.getText()));
	}
	
	public boolean action(Event event, Object object)
	{
		if (browser != null)
		{
			if (event.target instanceof Button)
			{
				Button button = (Button)event.target;
				if (button.getLabel() == create.getLabel())
					doExample();
			}
		}
		return true;
	}

	Browser browser;
	TextArea text;
	Button create;

}