import java.applet.*;
import java.awt.*;
import java.util.Vector;
import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.field.EventOutMFNode;
import vrml.external.field.EventInSFBool;

public class EaiSample extends Applet
{
	protected int getBrowserIndexParameter()
	{
		try
		{
			return Integer.parseInt(getParameter("BrowserIndex"));
		}
		catch (NumberFormatException e)
		{
			return 0;
		}
	}

	public void init()
	{
		Button b;
    	resize(400, 40);
		setBackground(Color.white);
//		setLayout(new BorderLayout());
		for (int i = 1; ; ++i)
		{
			String param = getParameter("viewpoint" + i);
			if (param == null)
				break;
			add(b = new Button(m_strButtonPrefix + i));
			b.setBackground(Color.white);
			m_viewpoints.addElement(param);
		}
		m_strTestNode = getParameter("testnode");
	}

	public void destroy()
	{
		m_viewpoints.removeAllElements();
		eaiUninitialize();
	}

	public void start()
	{
		eaiInitialize();
	}
	
	private boolean eaiInitialize()
	{
		if (m_bInitialized)
			return true;
		int index = getBrowserIndexParameter();
		try
		{
			if (m_browser == null)
				m_browser = new VrmlBrowser(this, index);
			if (m_strTestNode != null)
				m_browser.getNode(m_strTestNode);
			m_bInitialized = true;
		}
		catch (Exception e)
		{
			System.out.println("EaiSample.eaiInitialize() failed");
			e.printStackTrace(System.err);
			return false;
		}
		return true;
	}

	private void eaiUninitialize()
	{
		m_browser = null;
		m_bInitialized = false;
	}

	public boolean switchToViewpoint(String nodename)
	{
		if (!m_bInitialized)
			return false;
		try
		{
			Node viewpoint = m_browser.getNode(nodename);
			EventInSFBool bind = (EventInSFBool)viewpoint.getEventIn("bind");
			bind.setValue(true);
		}
		catch (Exception e)
		{
			System.err.println("switchToViewpoint failed");
			e.printStackTrace(System.err);
			return false;
		}
		return true;
	}

	public boolean action(Event event, Object what)
	{
		if (event.target instanceof Button)
		{
			Button button = (Button)event.target;
			String label = button.getLabel();
			if (label.startsWith(m_strButtonPrefix))
			{
				int index = -1;
				try
				{
					index = Integer.parseInt(label.substring(m_strButtonPrefix.length())) - 1;
				}
				catch (Exception e)
				{
				}
				if (index >= 0)
					switchToViewpoint((String)m_viewpoints.elementAt(index));
			}
		}
		return true;
	}

	public void onBrowserReady()
	{
		eaiInitialize();
	}

	private VrmlBrowser m_browser;
	private boolean     m_bInitialized = false;
	private String      m_strTestNode;
	private Vector      m_viewpoints = new Vector();
	private static String m_strButtonPrefix = "Viewpoint ";
}
