import java.awt.*;
import java.applet.*;
import vrml.external.*;

public class AddRoute extends Applet
{
	Browser browser;
	Button addRoute;
	Button delRoute;

	protected int getBrowserIndexParameter()
	{
		try
		{
			return Integer.parseInt(getParameter("BrowserIndex"));
		}
		catch (NumberFormatException e)
		{
			return 0;
		}
	}

	public void init()
	{
		setBackground(backgroundColor);
		int index = getBrowserIndexParameter();
		for (int i = 0; i < 20; ++i)
		{
			browser = Browser.getBrowser(this, "", index);
			if (browser != null)
				break;
			try 
			{
				Thread.sleep(200);
			}
			catch (InterruptedException e)
			{
				break;
			}
		}
		addRoute = new Button ("addRoute");
		addRoute.setBackground(buttonColor);
		add(addRoute);
		delRoute = new Button ("deleteRoute");
		delRoute.setBackground(buttonColor);
		add(delRoute);
	}

	public boolean action(Event event, Object what)
	{
		if (browser != null)
		{
			if (event.target instanceof Button)
			{
				Node nodeFrom = browser.getNode("MainInterpolator");
				Node nodeTo = browser.getNode("MainTransform");
				Button button = (Button)event.target;
				if (button.getLabel() == addRoute.getLabel())
				{
					browser.addRoute(nodeFrom, eventFrom, nodeTo, eventTo);
				}
				else if (button.getLabel() == delRoute.getLabel())
					browser.deleteRoute(nodeFrom, eventFrom, nodeTo, eventTo);
			}
		}
		return true;
	}

	static final String eventFrom = "value_changed";
	static final String eventTo = "rotation";
	static final Color buttonColor = Color.white;
	static final Color backgroundColor = new Color(252, 252, 252);
}