####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python TestScriptFieldSFTime.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='TestScriptFieldSFTime.x3d',name='title'),
    meta(content='Test correct conversion of X3D SFTime field initializations from XML to Java to ClassicVRML',name='description'),
    meta(content='Don Brutzman',name='creator'),
    meta(content='17 November 2024',name='created'),
    meta(content='17 November 2024',name='modified'),
    meta(content='../Followers/CoasterDamper.x3d',name='reference'),
    meta(content='X3D conversion test',name='subject'),
    meta(content='under development',name='warning'),
    meta(content='TestScriptFieldSFTime.x3d',name='identifier'),
    meta(content='X3D-Edit 4.0, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='TestScriptFieldSFTime.x3d'),
    Script(DEF='TestScript',
      field=[
      field(accessType='initializeOnly',name='initialTime',type='SFTime',value=0),
      field(accessType='inputOutput',name='timeIncrement',type='SFTime',value=1),
      field(accessType='inputOnly',name='timeStepTrigger',type='SFTime'),
      field(accessType='outputOnly',name='currentTime',type='SFTime')],

    sourceCode="""
ecmascript:
function initialize (eventValue)
{
  currentTime initialTime; // sends output event
}
function timeStepTrigger (eventValue)
{
  currentTime += timeIncrement; // sends output event
}
""")])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for TestScriptFieldSFTime.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python TestScriptFieldSFTime.py load and self-test diagnostics complete.")
