####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python TestFillPropertiesLinePropertiesValidation.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    component(level=3,name='Shape'),
    meta(content='TestFillPropertiesLinePropertiesValidation.x3d',name='title'),
    meta(content='Test proper validation of Appearance, LineProperties, FillProperties, LineProperties',name='description'),
    meta(content='Don Brutzman',name='creator'),
    meta(content='12 April 2014',name='created'),
    meta(content='21 April 2024',name='modified'),
    meta(content='http://www.web3d.org/realtime-3d/member-only/mantis/view.php?id=675',name='reference'),
    meta(content='FillProperties LineProperties Validation Test',name='subject'),
    meta(content='http://www.web3d.org/x3d/content/examples/Basic/development/TestFillPropertiesLinePropertiesValidation.x3d',name='identifier'),
    meta(content='X3D-Edit 4.0, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    Shape(
      geometry=Box(),
      appearance=Appearance(DEF='TestBothProperties',
        material=Material(),
        fillProperties=FillProperties(),
        lineProperties=LineProperties(),)),
    Shape(
      geometry=Cone(),
      appearance=Appearance(DEF='TestFillProperties',
        material=Material(),
        fillProperties=FillProperties(),)),
    Shape(
      geometry=Cylinder(),
      appearance=Appearance(DEF='TestLineProperties',
        material=Material(),
        lineProperties=LineProperties(),)),
    Shape(
      geometry=Sphere(),
      appearance=Appearance(DEF='TestNoProperties',
        material=Material(),))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for TestFillPropertiesLinePropertiesValidation.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python TestFillPropertiesLinePropertiesValidation.py load and self-test diagnostics complete.")
