package Basic.development;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Expose functionality of Browser class in Java/ECMAscript annexes of VRML 97 specification. Consider promotion to a native node in X3D/VRML 200x scenes. </p>
 <p> Related links: Catalog page <a href="../../../development/SceneNodePrototypeIndex.html" target="_blank">SceneNodePrototype</a>,  source <a href="../../../development/SceneNodePrototype.java">SceneNodePrototype.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../development/SceneNodePrototype.x3d">SceneNodePrototype.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 19 December 2000 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Expose functionality of Browser class in Java/ECMAscript annexes of VRML 97 specification. Consider promotion to a native node in X3D/VRML 200x scenes. </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Under development, many of these exposed attributes will be eliminated. Scene node will not be used in X3D proper, but may become a valuable prototype via SAI scripting. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/development/SceneNodePrototype.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/development/SceneNodePrototype.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../development/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Don Brutzman
 */

public class SceneNodePrototype
{
	/** Default constructor to create this object. */
	public SceneNodePrototype ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SceneNodePrototype.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("19 December 2000"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Expose functionality of Browser class in Java/ECMAscript annexes of VRML 97 specification. Consider promotion to a native node in X3D/VRML 200x scenes."))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Under development, many of these exposed attributes will be eliminated. Scene node will not be used in X3D proper, but may become a valuable prototype via SAI scripting."))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/development/SceneNodePrototype.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SceneNodePrototype.x3d"))
    .addChild(new ProtoDeclare("Scene").setName("Scene")
      .setProtoInterface(new ProtoInterface()
        .addComments(" Standard browser attributes exposed via VRML 97 Script annexes ")
        .addField(new field().setName("createVrmlFromString").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("createVrmlFromURL").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("createdVrmlNodes").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("currentFrameRate").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("currentSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("description").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("evaluate").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("loadUrl").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("loadUrlParameter").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("name").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("replaceWorld").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("version").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("worldUrl").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("addRoute").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("deleteRoute").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("fromNode").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("fromEventOut").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("toNode").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("toEventIn").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addComments(" Candidate additions ")
        .addField(new field().setName("boundBackground").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("boundFog").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("boundGeoViewpoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("boundNavigationInfo").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("boundViewpoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("response").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("dashboardVisible").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(true))
        .addField(new field().setName("pixelWidth").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(-1))
        .addField(new field().setName("pixelHeight").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(-1)))
      .setProtoBody(new ProtoBody()
        .addChild(new Script("BrowserScript").setDirectOutput(true).setSourceCode("""
ecmascript:

function evaluate (inputValue, timeStamp)
{
	if (inputValue)  // Boolean
	{
		currentFrameRate = Browser.getCurrentFrameRate ();
		currentSpeed = Browser.getCurrentSpeed ();
		version = Browser.getVersion ();
		name = Browser.getName ();
		worldUrl = Browser.getWorldURL ();

		Browser.println ('currentFrameRate = ' + currentFrameRate);
		Browser.println ('currentSpeed = ' + currentSpeed);
		Browser.println ('version = ' + version);
		Browser.println ('name = ' + name);
		Browser.println ('worldUrl = ' + worldUrl);
	}
}

function createVrmlFromString (inputValue, timeStamp)
{
	// note VRML 97 method name didn't follow capitalization convention
	createdVrmlNodes = Browser.createVrmlFromString (inputValue);
}

function createVrmlFromUrl (inputValue, timeStamp)
{
	// note VRML 97 method name didn't follow capitalization convention
	createdVrmlNodes = Browser.createVrmlFromURL (inputValue);
}

function description (inputValue, timeStamp)
{
	Browser.println ('description = ' + inputValue);
	Browser.setDescription (inputValue);
}

function replaceWorld (inputValue, timeStamp)
{
	Browser.replaceWorld (inputValue);
}

function addRoute (inputValue, timeStamp)
{
	if (inputValue)  // Boolean
	{
		Browser.addRoute (fromNode, fromEventOut, toNode, toEventIn);
	}
}

function deleteRoute (inputValue, timeStamp)
{
	if (inputValue)  // Boolean
	{
		Browser.deleteRoute (fromNode, fromEventOut, toNode, toEventIn);
	}
}

function loadURL (inputValue, timeStamp)
{
	Browser.println ('loadURL = ' + inputValue);
	Browser.println ('loadUrlParameter = ' + loadUrlParameter);
	Browser.loadURL (inputValue, loadUrlParameter);
}
function createVrmlFromURL (SFStringValue, timestamp)
{

}

function loadUrl (SFStringValue, timestamp)
{

}

function loadUrlParameter (SFStringValue, timestamp)
{

}

function fromNode (SFNodeValue, timestamp)
{

}

function fromEventOut (SFStringValue, timestamp)
{

}

function toNode (SFNodeValue, timestamp)
{

}

function toEventIn (SFStringValue, timestamp)
{

}
""")
          .addField(new field().setName("createVrmlFromString").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("createVrmlFromURL").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("createdVrmlNodes").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("currentFrameRate").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("currentSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("description").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("evaluate").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("loadUrl").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("loadUrlParameter").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("name").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("replaceWorld").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("version").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("worldUrl").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("addRoute").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("deleteRoute").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("fromNode").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("fromEventOut").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("toNode").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("toEventIn").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("response").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("createVrmlFromString").setProtoField("createVrmlFromString"))
            .addConnect(new connect().setNodeField("createVrmlFromURL").setProtoField("createVrmlFromURL"))
            .addConnect(new connect().setNodeField("createdVrmlNodes").setProtoField("createdVrmlNodes"))
            .addConnect(new connect().setNodeField("currentFrameRate").setProtoField("currentFrameRate"))
            .addConnect(new connect().setNodeField("currentSpeed").setProtoField("currentSpeed"))
            .addConnect(new connect().setNodeField("description").setProtoField("description"))
            .addConnect(new connect().setNodeField("evaluate").setProtoField("evaluate"))
            .addConnect(new connect().setNodeField("loadUrl").setProtoField("loadUrl"))
            .addConnect(new connect().setNodeField("loadUrlParameter").setProtoField("loadUrlParameter"))
            .addConnect(new connect().setNodeField("name").setProtoField("name"))
            .addConnect(new connect().setNodeField("replaceWorld").setProtoField("replaceWorld"))
            .addConnect(new connect().setNodeField("version").setProtoField("version"))
            .addConnect(new connect().setNodeField("worldUrl").setProtoField("worldUrl"))
            .addConnect(new connect().setNodeField("addRoute").setProtoField("addRoute"))
            .addConnect(new connect().setNodeField("deleteRoute").setProtoField("deleteRoute"))
            .addConnect(new connect().setNodeField("fromNode").setProtoField("fromNode"))
            .addConnect(new connect().setNodeField("fromEventOut").setProtoField("fromEventOut"))
            .addConnect(new connect().setNodeField("toNode").setProtoField("toNode"))
            .addConnect(new connect().setNodeField("toEventIn").setProtoField("toEventIn"))
            .addConnect(new connect().setNodeField("response").setProtoField("response"))))))
    .addComments(" Example invocation ")
    .addChild(new ProtoInstance("Scene", "SceneNode").setContainerField("children"))
    .addChild(new Shape()
      .setGeometry(new Text("Output3dText").setString(new String[] {"Click text for partial Scene node test"})
        .setFontStyle(new FontStyle().setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.5)))
      .setAppearance(new Appearance()
        .setMaterial(new Material().setDiffuseColor(0.0,0.6,0.6))))
    .addChild(new TouchSensor("ClickTextSensor").setDescription("Click text for partial Scene node test"))
    .addChild(new Script("AssembleBrowserOutputText").setSourceCode("""
ecmascript:

function initialize ()
{
	evaluatedResult = new MFString (
		'Click for partial Scene node test:',
		' ', ' ', ' ', ' ', ' ', ' ', ' ');
}
function currentFrameRate (inputValue, timeStamp)
{
	evaluatedResult [2] = 'currentFrameRate=' + inputValue;
}
function currentSpeed (inputValue, timeStamp)
{
	evaluatedResult [3] = 'currentSpeed=' + inputValue;
}
function version (inputValue, timeStamp)
{
	evaluatedResult [4] = 'version=' + inputValue;
}
function name (inputValue, timeStamp)
{
	evaluatedResult [5] = 'name=' + inputValue;
}
function worldUrl (inputValue, timeStamp)
{
	evaluatedResult [6] = 'worldUrl=';
	evaluatedResult [7] = inputValue;
}
""")
      .addField(new field().setName("currentFrameRate").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("currentSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("name").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("version").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("worldUrl").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("evaluatedResult").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
    .addChild(new ROUTE().setFromNode("ClickTextSensor").setFromField("isActive").setToNode("SceneNode").setToField("evaluate"))
    .addChild(new ROUTE().setFromNode("SceneNode").setFromField("currentFrameRate").setToNode("AssembleBrowserOutputText").setToField("currentFrameRate"))
    .addChild(new ROUTE().setFromNode("SceneNode").setFromField("currentSpeed").setToNode("AssembleBrowserOutputText").setToField("currentSpeed"))
    .addChild(new ROUTE().setFromNode("SceneNode").setFromField("version").setToNode("AssembleBrowserOutputText").setToField("version"))
    .addChild(new ROUTE().setFromNode("SceneNode").setFromField("name").setToNode("AssembleBrowserOutputText").setToField("name"))
    .addChild(new ROUTE().setFromNode("SceneNode").setFromField("worldUrl").setToNode("AssembleBrowserOutputText").setToField("worldUrl"))
    .addChild(new ROUTE().setFromNode("AssembleBrowserOutputText").setFromField("evaluatedResult").setToNode("Output3dText").setToField("string")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SceneNodePrototype model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SceneNodePrototype().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.development.SceneNodePrototype\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.development.SceneNodePrototype self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // development/SceneNodePrototype_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "development/SceneNodePrototype_JavaExport.x3d"; 
                String filenameX3DV = "development/SceneNodePrototype_JavaExport.x3dv"; 
                String filenameJSON = "development/SceneNodePrototype_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
