####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python KeySensorActivationKeySwitchTestInteractive.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interactive',version='3.0',
  head=head(
    children=[
    component(level=2,name='Core'),
    meta(content='KeySensorActivationKeySwitchTestInteractive.x3d',name='title'),
    meta(content='A simple developmental model to show KeySensor functionality using Interactive Profile.',name='description'),
    meta(content='Mr. Philip Sand Hansel II, mr.phillip@home.com',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='8 July 2001',name='created'),
    meta(content='4 December 2024',name='modified'),
    meta(content='This model was a developmental scene for design of node functionality, and not a proper test of the final X3D KeySensor node.',name='info'),
    meta(content='https://www.web3d.org/x3d/specification-2000july/part1/nodesDef.html#KeySensor',name='reference'),
    meta(content='https://www.web3d.org/x3d/sai/javadoc/org/web3d/x3d/sai/Core/KeySensor.html',name='reference'),
    meta(content='KeySensor Interactive Profile',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/development/KeySensorActivationKeySwitchTestInteractive.x3d',name='identifier'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ConformanceNist/Sensors/Keyboard/KeySensorActivationKeySwitchTestInteractive.x3d',name='reference'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='KeySensorActivationKeySwitchTestInteractive.x3d'),
    ExternProtoDeclare(name='KeySensor',url=["KeySensorActivationKeySwitchTest.wrl#KeySensor","https://www.web3d.org/x3d/content/examples/Basic/development/KeySensorActivationKeySwitchTest.wrl#KeySensor","KeySensorActivationKeySwitchTest.x3d#KeySensor","https://www.web3d.org/x3d/content/examples/Basic/development/KeySensorActivationKeySwitchTest.x3d#KeySensor"],
      field=[
      field(accessType='outputOnly',name='altKey',type='SFBool'),
      field(accessType='outputOnly',name='keyPress',type='SFInt32'),
      field(accessType='inputOnly',name='set_enabled',type='SFBool'),
      field(accessType='outputOnly',name='keyRelease',type='SFInt32'),
      field(accessType='inputOutput',name='enabled',type='SFBool'),
      field(accessType='outputOnly',name='shiftKey',type='SFBool'),
      field(accessType='outputOnly',name='actionKeyRelease',type='SFInt32'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='outputOnly',name='enabled_changed',type='SFBool'),
      field(accessType='outputOnly',name='actionKeyPress',type='SFInt32'),
      field(accessType='outputOnly',name='controlKey',type='SFBool')]),
    Viewpoint(DEF='Viewpoint1',description='Viewpoint1',fieldOfView=0.79,position=(0.0,0.0,30.0)),
    KeySensor(DEF='SingleKeySensor',enabled=False),
    Shape(DEF='A',
      appearance=Appearance(
        material=Material(DEF='red',diffuseColor=(1.0,0.0,0.0)),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(DEF='slab',coordIndex=[0,1,2,-1,0,2,3,-1],creaseAngle=0.5,
        coord=Coordinate(point=[(-0.5,0.5,0.5),(-0.5,-0.5,0.5),(0.5,-0.5,0.5),(0.5,0.5,0.5)]))),
    Shape(DEF='B',
      appearance=Appearance(
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='C',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='D',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='E',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='F',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='G',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,255,255,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='H',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='I',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='J',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='K',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,255,0,0,0,0,0,255,0,255,0,0,0,0,0,255,255,0,0,0,0,0,0,255,0,255,0,0,0,0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='L',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='M',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,255,0,255,0,0,0,255,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='N',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,255,255,0,0,0,0,255,255,0,255,0,0,0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='O',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='P',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Q',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,255,0,0,0,0,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='R',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,255,0,0,0,0,0,255,255,0,0,0,0,0,0,255,0,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='S',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='T',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='U',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='V',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='W',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,255,0,0,0,255,0,255,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='X',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,255,0,0,0,255,0,0,0,0,255,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Y',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Z',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='One',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Two',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Three',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Four',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Five',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Six',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Seven',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Eight',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,0,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Nine',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,0,0,0,0,255,0,0,255,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Zero',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Colon',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Comma',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Shape(DEF='Dot',
      appearance=Appearance(
        textureTransform=TextureTransform(scale=(0.75,1.0)),
        material=Material(USE='red'),
        texture=PixelTexture(image=[8,8,1,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])),
      geometry=IndexedFaceSet(USE='slab')),
    Group(
      children=[
      Transform(translation=(0.0,5.0,0.0),
        children=[
        Transform(translation=(-12.0,0.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(-11.0,0.0,0.0),
          children=[
          Shape(USE='O')]),
        Transform(translation=(-10.0,0.0,0.0),
          children=[
          Shape(USE='U')]),
        Transform(translation=(-9.0,0.0,0.0),
          children=[
          Shape(USE='C')]),
        Transform(translation=(-8.0,0.0,0.0),
          children=[
          Shape(USE='H')]),
        Transform(translation=(-6.0,0.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(-5.0,0.0,0.0),
          children=[
          Shape(USE='H')]),
        Transform(translation=(-4.0,0.0,0.0),
          children=[
          Shape(USE='I')]),
        Transform(translation=(-3.0,0.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(-1.0,0.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(
          children=[
          Shape(USE='E')]),
        Transform(translation=(1.0,0.0,0.0),
          children=[
          Shape(USE='X')]),
        Transform(translation=(2.0,0.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(4.0,0.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(5.0,0.0,0.0),
          children=[
          Shape(USE='O')]),
        Transform(translation=(7.0,0.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(8.0,0.0,0.0),
          children=[
          Shape(USE='N')]),
        Transform(translation=(9.0,0.0,0.0),
          children=[
          Shape(USE='A')]),
        Transform(translation=(10.0,0.0,0.0),
          children=[
          Shape(USE='B')]),
        Transform(translation=(11.0,0.0,0.0),
          children=[
          Shape(USE='L')]),
        Transform(translation=(12.0,0.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(-15.0,-1.0,0.0),
          children=[
          Shape(USE='K')]),
        Transform(translation=(-14.0,-1.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(-13.0,-1.0,0.0),
          children=[
          Shape(USE='Y')]),
        Transform(translation=(-12.0,-1.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(-11.0,-1.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(-10.0,-1.0,0.0),
          children=[
          Shape(USE='N')]),
        Transform(translation=(-9.0,-1.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(-8.0,-1.0,0.0),
          children=[
          Shape(USE='O')]),
        Transform(translation=(-7.0,-1.0,0.0),
          children=[
          Shape(USE='R')]),
        Transform(translation=(-5.0,-1.0,0.0),
          children=[
          Shape(USE='A')]),
        Transform(translation=(-4.0,-1.0,0.0),
          children=[
          Shape(USE='C')]),
        Transform(translation=(-3.0,-1.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(-2.0,-1.0,0.0),
          children=[
          Shape(USE='I')]),
        Transform(translation=(-1.0,-1.0,0.0),
          children=[
          Shape(USE='V')]),
        Transform(translation=(0.0,-1.0,0.0),
          children=[
          Shape(USE='A')]),
        Transform(translation=(1.0,-1.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(2.0,-1.0,0.0),
          children=[
          Shape(USE='I')]),
        Transform(translation=(3.0,-1.0,0.0),
          children=[
          Shape(USE='O')]),
        Transform(translation=(4.0,-1.0,0.0),
          children=[
          Shape(USE='N')]),
        Transform(translation=(6.0,-1.0,0.0),
          children=[
          Shape(USE='K')]),
        Transform(translation=(7.0,-1.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(8.0,-1.0,0.0),
          children=[
          Shape(USE='Y')]),
        Transform(translation=(9.0,-1.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(10.0,-1.0,0.0),
          children=[
          Shape(USE='Comma')]),
        Transform(translation=(12.0,-1.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(13.0,-1.0,0.0),
          children=[
          Shape(USE='H')]),
        Transform(translation=(14.0,-1.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(15.0,-1.0,0.0),
          children=[
          Shape(USE='N')]),
        Transform(translation=(-15.0,-2.0,0.0),
          children=[
          Shape(USE='P')]),
        Transform(translation=(-14.0,-2.0,0.0),
          children=[
          Shape(USE='R')]),
        Transform(translation=(-13.0,-2.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(-12.0,-2.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(-11.0,-2.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(-9.0,-2.0,0.0),
          children=[
          Shape(USE='A')]),
        Transform(translation=(-8.0,-2.0,0.0),
          children=[
          Shape(USE='C')]),
        Transform(translation=(-7.0,-2.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(-6.0,-2.0,0.0),
          children=[
          Shape(USE='I')]),
        Transform(translation=(-5.0,-2.0,0.0),
          children=[
          Shape(USE='V')]),
        Transform(translation=(-4.0,-2.0,0.0),
          children=[
          Shape(USE='A')]),
        Transform(translation=(-3.0,-2.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(-2.0,-2.0,0.0),
          children=[
          Shape(USE='I')]),
        Transform(translation=(-1.0,-2.0,0.0),
          children=[
          Shape(USE='O')]),
        Transform(translation=(0.0,-2.0,0.0),
          children=[
          Shape(USE='N')]),
        Transform(translation=(2.0,-2.0,0.0),
          children=[
          Shape(USE='K')]),
        Transform(translation=(3.0,-2.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(4.0,-2.0,0.0),
          children=[
          Shape(USE='Y')]),
        Transform(translation=(5.0,-2.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(7.0,-2.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(8.0,-2.0,0.0),
          children=[
          Shape(USE='O')]),
        Transform(translation=(10.0,-2.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(11.0,-2.0,0.0),
          children=[
          Shape(USE='E')]),
        Transform(translation=(12.0,-2.0,0.0),
          children=[
          Shape(USE='S')]),
        Transform(translation=(13.0,-2.0,0.0),
          children=[
          Shape(USE='T')]),
        Transform(translation=(14.0,-2.0,0.0),
          children=[
          Shape(USE='Dot')])]),
      Switch(DEF='ActivationKeyMessageSwitch',whichChoice=0,
        children=[
        Transform(DEF='Nokeypress',translation=(-2,0,0),
          children=[
          Transform(translation=(-13.0,-4.0,0.0),
            children=[
            Shape(USE='N')]),
          Transform(translation=(-12.0,-4.0,0.0),
            children=[
            Shape(USE='O')]),
          Transform(translation=(-10.0,-4.0,0.0),
            children=[
            Shape(USE='A')]),
          Transform(translation=(-9.0,-4.0,0.0),
            children=[
            Shape(USE='C')]),
          Transform(translation=(-8.0,-4.0,0.0),
            children=[
            Shape(USE='T')]),
          Transform(translation=(-7.0,-4.0,0.0),
            children=[
            Shape(USE='I')]),
          Transform(translation=(-6.0,-4.0,0.0),
            children=[
            Shape(USE='V')]),
          Transform(translation=(-5.0,-4.0,0.0),
            children=[
            Shape(USE='A')]),
          Transform(translation=(-4.0,-4.0,0.0),
            children=[
            Shape(USE='T')]),
          Transform(translation=(-3.0,-4.0,0.0),
            children=[
            Shape(USE='I')]),
          Transform(translation=(-2.0,-4.0,0.0),
            children=[
            Shape(USE='O')]),
          Transform(translation=(-1.0,-4.0,0.0),
            children=[
            Shape(USE='N')]),
          Transform(translation=(1.0,-4.0,0.0),
            children=[
            Shape(USE='K')]),
          Transform(translation=(2.0,-4.0,0.0),
            children=[
            Shape(USE='E')]),
          Transform(translation=(3.0,-4.0,0.0),
            children=[
            Shape(USE='Y')]),
          Transform(translation=(4.0,-4.0,0.0),
            children=[
            Shape(USE='P')]),
          Transform(translation=(5.0,-4.0,0.0),
            children=[
            Shape(USE='R')]),
          Transform(translation=(6.0,-4.0,0.0),
            children=[
            Shape(USE='E')]),
          Transform(translation=(7.0,-4.0,0.0),
            children=[
            Shape(USE='S')]),
          Transform(translation=(8.0,-4.0,0.0),
            children=[
            Shape(USE='S')]),
          Transform(translation=(10.0,-4.0,0.0),
            children=[
            Shape(USE='S')]),
          Transform(translation=(11.0,-4.0,0.0),
            children=[
            Shape(USE='E')]),
          Transform(translation=(12.0,-4.0,0.0),
            children=[
            Shape(USE='N')]),
          Transform(translation=(13.0,-4.0,0.0),
            children=[
            Shape(USE='S')]),
          Transform(translation=(14.0,-4.0,0.0),
            children=[
            Shape(USE='E')]),
          Transform(translation=(15.0,-4.0,0.0),
            children=[
            Shape(USE='D')]),
          Transform(translation=(16.0,-4.0,0.0),
            children=[
            Shape(USE='Dot')]),
          Transform(translation=(17.0,-4.0,0.0),
            children=[
            Shape(USE='Dot')])]),
        Transform(DEF='Functions',translation=(0.0,-6.0,0.0),
          children=[
          Transform(DEF='F1',
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='One')])]),
          Transform(DEF='F2',translation=(0.0,-1.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Two')])]),
          Transform(DEF='F3',translation=(0.0,-2.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Three')])]),
          Transform(DEF='F4',translation=(0.0,-3.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Four')])]),
          Transform(DEF='F5',translation=(0.0,-4.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Five')])]),
          Transform(DEF='F6',translation=(0.0,-5.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Six')])]),
          Transform(DEF='F7',translation=(0.0,-6.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Seven')])]),
          Transform(DEF='F8',translation=(0.0,-7.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Eight')])]),
          Transform(DEF='F9',translation=(0.0,-8.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='Nine')])]),
          Transform(DEF='F10',translation=(0.0,-9.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='One')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='Zero')])]),
          Transform(DEF='F11',translation=(0.0,-10.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='One')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='One')])]),
          Transform(DEF='F12',translation=(0.0,-11.0,0.0),
            children=[
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(
              children=[
              Shape(USE='One')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='Two')])]),
          Transform(DEF='Home',translation=(0.0,-12.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='One')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Three')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='H')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='O')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='M')]),
            Transform(translation=(3.0,0.0,0.0),
              children=[
              Shape(USE='E')])]),
          Transform(DEF='End',translation=(0.0,-13.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='One')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Four')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='E')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='N')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='D')])]),
          Transform(DEF='Left',translation=(0.0,-14.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='One')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Five')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='L')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='E')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='F')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='T')])]),
          Transform(DEF='Right',translation=(0.0,-15.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='One')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Six')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='R')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='I')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='G')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='H')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='T')])]),
          Transform(DEF='Up',translation=(0.0,-16.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='One')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Seven')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='U')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='P')])]),
          Transform(DEF='Down',translation=(0.0,-17.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='One')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Eight')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='D')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='O')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='W')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='N')])]),
          Transform(DEF='PGUP',translation=(0.0,-18.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='One')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Nine')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='P')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='G')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='U')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='P')])]),
          Transform(DEF='PGDN',translation=(0.0,-19.0,0.0),
            children=[
            Transform(translation=(-3.0,0.0,0.0),
              children=[
              Shape(USE='Two')]),
            Transform(translation=(-2.0,0.0,0.0),
              children=[
              Shape(USE='Zero')]),
            Transform(translation=(-1.0,0.0,0.0),
              children=[
              Shape(USE='Colon')]),
            Transform(
              children=[
              Shape(USE='P')]),
            Transform(translation=(1.0,0.0,0.0),
              children=[
              Shape(USE='G')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='D')]),
            Transform(translation=(2.0,0.0,0.0),
              children=[
              Shape(USE='N')])])])])]),
    ROUTE(fromField='actionKeyPress',fromNode='SingleKeySensor',toField='whichChoice',toNode='ActivationKeyMessageSwitch')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for KeySensorActivationKeySwitchTestInteractive.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python KeySensorActivationKeySwitchTestInteractive.py load and self-test diagnostics complete.")
