package Basic.course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> X Y Z axis arrows and labels of X3D coordinate system to illustrate default entity center of gravity at 0 0 0, with default nose orientation pointing along the +X-axis. Ground vehicles have their position raised to allow bottom to touch the ground. </p>
 <p> Related links: Catalog page <a href="../../../course/ModelOrientationIndex.html" target="_blank">ModelOrientation</a>,  source <a href="../../../course/ModelOrientation.java">ModelOrientation.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../course/ModelOrientation.x3d">ModelOrientation.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Jeffrey Weekley </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 15 July 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> X Y Z axis arrows and labels of X3D coordinate system to illustrate default entity center of gravity at 0 0 0, with default nose orientation pointing along the +X-axis. Ground vehicles have their position raised to allow bottom to touch the ground. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../course/ModelOrientation.jpg">ModelOrientation.jpg</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../course/../X3dSceneAuthoringHints.html#CoordinateSystems">../X3dSceneAuthoringHints.html#CoordinateSystems</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/course/ModelOrientation.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/course/ModelOrientation.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Jeffrey Weekley
 */

public class ModelOrientation
{
	/** Default constructor to create this object. */
	public ModelOrientation ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERACTIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("ModelOrientation.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Jeffrey Weekley"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("15 July 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("X Y Z axis arrows and labels of X3D coordinate system to illustrate default entity center of gravity at 0 0 0, with default nose orientation pointing along the +X-axis. Ground vehicles have their position raised to allow bottom to touch the ground."))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("ModelOrientation.jpg"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("../X3dSceneAuthoringHints.html#CoordinateSystems"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/course/ModelOrientation.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("ModelOrientation.x3d"))
    .addChild(new Viewpoint().setDescription("Default model orientation: nose +X axis, up +Y axis, right-hand side +Z axis"))
    .addComments(" Each arrow goes from +1m to -1m to allow linear scaling to fit a scene ")
    .addComments(" Note each label rotates about the scene's vertical Y axis for consistency, enabling local orientation by user ")
    .addChild(new Transform().setScale(2.0,2.0,2.0)
      .addChild(new Inline("CoordinateAxes").setUrl(new String[] {"../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.x3d","../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.wrl"})))
    .addChild(new Transform().setScale(1.2,1.6,1.6)
      .addChild(new Transform().setRotation(0.0,0.0,-1.0,1.57).setScale(0.25,0.25,0.25)
        .addChild(new Shape()
          .setGeometry(new Cylinder().setHeight(8).setRadius(0.4425).setTop(false))
          .setAppearance(new Appearance("Cammi")
            .setMaterial(new Material().setDiffuseColor(0.45,0.55,0.55))))
        .addChild(new Transform().setTranslation(0.0,4.9,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(0.4425).setHeight(1.8))
            .setAppearance(new Appearance().setUSE("Cammi"))))
        .addChild(new Transform().setTranslation(0.0,-4.1,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(0.2).setHeight(0.66))
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(0.15,0.15,0.15).setShininess(0.66).setSpecularColor(0.22,0.22,0.22)))))
        .addChild(new Transform("TailFin").setTranslation(0.175,-4.5,0.0)
          .addChild(new Shape()
            .setGeometry(new IndexedFaceSet().setSolid(false).setCoordIndex(new int[] {0,1,2,3,4,5,-1})
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.4,0.0,0.25,0.0,0.0,0.75,0.0,0.0,0.75,1.0,0.0,0.0,1.65,0.0,0.0,0.4,0.0}))))
            .setAppearance(new Appearance().setUSE("Cammi"))))
        .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57)
          .addChild(new Transform().setUSE("TailFin")))
        .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14)
          .addChild(new Transform().setUSE("TailFin")))
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.57)
          .addChild(new Transform().setUSE("TailFin"))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return ModelOrientation model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new ModelOrientation().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.course.ModelOrientation\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.course.ModelOrientation self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // course/ModelOrientation_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "course/ModelOrientation_JavaExport.x3d"; 
                String filenameX3DV = "course/ModelOrientation_JavaExport.x3dv"; 
                String filenameJSON = "course/ModelOrientation_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
