package Basic.course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Ship model as example use of ExtrusionCrossSectionPrototype for drawing several different Extrusion spines and cross sections. </p>
 <p> Related links: Catalog page <a href="../../../course/ExtrusionCrossSectionExampleShipIndex.html" target="_blank">ExtrusionCrossSectionExampleShip</a>,  source <a href="../../../course/ExtrusionCrossSectionExampleShip.java">ExtrusionCrossSectionExampleShip.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../course/ExtrusionCrossSectionExampleShip.x3d">ExtrusionCrossSectionExampleShip.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 20 December 1999 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Ship model as example use of ExtrusionCrossSectionPrototype for drawing several different Extrusion spines and cross sections. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../course/ExtrusionCrossSectionExampleShip.png">ExtrusionCrossSectionExampleShip.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> hint </i> </td>
			<td> Utilize ExtrusionCrossSection ProtoInstance as a Shape node (with containerField="children") rather than an Extrusion node (with containerField="geometry"). </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../course/ExtrusionExampleShip.x3d">ExtrusionExampleShip.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../course/ExtrusionCrossSectionExampleTorus.x3d">ExtrusionCrossSectionExampleTorus.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../course/ExtrusionCrossSectionPrototype.x3d">ExtrusionCrossSectionPrototype.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> VRML 97 Specification, 6.18 Extrusion </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/technicalinfo/specifications/vrml97/part1/nodesRef.html#Extrusion" target="_blank">https://www.web3d.org/technicalinfo/specifications/vrml97/part1/nodesRef.html#Extrusion</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> VRML 97 Specification, Figure 6.6 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="https://www.web3d.org/technicalinfo/specifications/vrml97/part1/Images/Extrusion.gif" target="_blank">https://www.web3d.org/technicalinfo/specifications/vrml97/part1/Images/Extrusion.gif</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/course/ExtrusionCrossSectionExampleShip.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/course/ExtrusionCrossSectionExampleShip.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Don Brutzman
 */

public class ExtrusionCrossSectionExampleShip
{
	/** Default constructor to create this object. */
	public ExtrusionCrossSectionExampleShip ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("ExtrusionCrossSectionExampleShip.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("20 December 1999"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Ship model as example use of ExtrusionCrossSectionPrototype for drawing several different Extrusion spines and cross sections."))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("ExtrusionCrossSectionExampleShip.png"))
    .addMeta(new meta().setName(meta.NAME_HINT       ).setContent("Utilize ExtrusionCrossSection ProtoInstance as a Shape node (with containerField=\"children\") rather than an Extrusion node (with containerField=\"geometry\")."))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("ExtrusionExampleShip.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("ExtrusionCrossSectionExampleTorus.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("ExtrusionCrossSectionPrototype.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("VRML 97 Specification, 6.18 Extrusion"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/technicalinfo/specifications/vrml97/part1/nodesRef.html#Extrusion"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("VRML 97 Specification, Figure 6.6"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("https://www.web3d.org/technicalinfo/specifications/vrml97/part1/Images/Extrusion.gif"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/course/ExtrusionCrossSectionExampleShip.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addComments(" Utilize ExtrusionCrossSection ProtoInstance as a Shape node (with containerField=\"children\") rather than an Extrusion node (with containerField=\"geometry\"). ")
    .addChild(new WorldInfo().setTitle("ExtrusionCrossSectionExampleShip.x3d"))
    .addChild(new ExternProtoDeclare("ExtrusionCrossSection").setName("ExtrusionCrossSection").setAppinfo("Shape prototype for Extrusion node that also draws spine line plus oriented scaled cross sections at each spine point").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/course/ExtrusionCrossSectionPrototype.x3d").setUrl(new String[] {"ExtrusionCrossSectionPrototype.x3d#ExtrusionCrossSection","https://www.web3d.org/x3d/content/examples/Basic/course/ExtrusionCrossSectionPrototype.x3d#ExtrusionCrossSection","ExtrusionCrossSectionPrototype.wrl#ExtrusionCrossSection","https://www.web3d.org/x3d/content/examples/Basic/course/ExtrusionCrossSectionPrototype.wrl#ExtrusionCrossSection"})
      .addComments(" run-time eventIn Extrusion-modification interfaces for VRML 97 compatibility ")
      .addField(new field().setName("name").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion name"))
      .addField(new field().setName("crossSection").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("spine").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("scale").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("orientation").setType(field.TYPE_MFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("beginCap").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("endCap").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("ccw").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("convex").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("creaseAngle").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("spineColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("emissiveColor of spine"))
      .addField(new field().setName("crossSectionColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("diffuseColor of crossSection"))
      .addField(new field().setName("crossSectionTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("transparency of crossSection"))
      .addField(new field().setName("extrusionColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("diffuseColor of extrusion hull"))
      .addField(new field().setName("extrusionTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("transparency of extrusion hull"))
      .addField(new field().setName("extrusionImageTexture").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Image to apply to Extrusion"))
      .addField(new field().setName("extrusionTextureTransform").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("TextureTransform coordinates of image applied to Extrusion"))
      .addField(new field().setName("set_crossSection").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("set_spine").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("set_scale").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("set_orientation").setType(field.TYPE_MFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("Extrusion field"))
      .addField(new field().setName("traceEnabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Whether to provide initialization trace statements showing node construction")))
    .addComments(" ==================== ")
    .addComments(" Example instance ")
    .addChild(new NavigationInfo().setSpeed(4))
    .addChild(new Viewpoint().setDescription("ship hull").setPosition(0.0,0.0,40.0))
    .addChild(new Viewpoint().setDescription("stack").setPosition(8.0,5.0,20.0))
    .addChild(new Viewpoint().setDescription("smoke extrusion start").setPosition(6.8,7.0,10.0))
    .addChild(new Viewpoint().setDescription("forward starboard quarter").setOrientation(0.0,1.0,0.0,0.5).setPosition(20.0,3.0,25.0))
    .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(15.0,30.0,0.0)
      .addChild(new Viewpoint().setDescription("touch smoke to animate").setOrientation(1.0,0.0,0.0,-1.0).setPosition(0.0,0.0,0.0)))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.7,0.7,0.7})).setSkyAngle(new double[] {0.05,1.5,1.59}).setSkyColor(new MFColor(new double[] {0.6,0.6,0.4,0.4,0.4,0.7,0.3,0.3,0.6,0.1,0.1,0.3})))
    .addComments(" ==================== ")
    .addChild(new Transform("SmokePosition").setTranslation(5.8,7.0,0.0)
      .addComments(" Smoke shows that crossSection, spine, scale and orientation can be animated ")
      .addChild(new ProtoInstance("ExtrusionCrossSection", "Smoke").setContainerField("children")
        .addFieldValue(new fieldValue().setName("name").setValue("Smoke"))
        .addFieldValue(new fieldValue().setName("crossSection").setValue(new MFVec2f(new MFVec2f(new double[] {0.0,1.0,-1.0,0.0,0.0,-0.5,1.5,0.0,0.0,1.0}))))
        .addFieldValue(new fieldValue().setName("spine").setValue(new MFVec3f(new MFVec3f(new double[] {0.0,0.0,0.0,-1.0,0.0,0.0,-2.0,0.0,0.0,-3.0,0.0,0.0,-5.0,0.0,0.0}))))
        .addFieldValue(new fieldValue().setName("scale").setValue(new MFVec2f(new MFVec2f(new double[] {0.8,0.7,0.7,0.6,0.6,0.5,0.5,0.3,0.4,0.2}))))
        .addFieldValue(new fieldValue().setName("orientation").setValue(new MFRotation(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.4,0.0,1.0,0.0,0.0,1.0,0.0,0.0,0.4}))))
        .addFieldValue(new fieldValue().setName("creaseAngle").setValue(1))
        .addFieldValue(new fieldValue().setName("solid").setValue(false))
        .addFieldValue(new fieldValue().setName("spineColor").setValue(new SFColor(1.0,1.0,1.0)))
        .addFieldValue(new fieldValue().setName("crossSectionColor").setValue(new SFColor(0.2,0.2,0.6)))
        .addFieldValue(new fieldValue().setName("extrusionColor").setValue(new SFColor(0.0,0.9,0.9)))
        .addFieldValue(new fieldValue().setName("extrusionTransparency").setValue(0.5))
        .addFieldValue(new fieldValue().setName("traceEnabled").setValue(false)))
      .addChild(new TouchSensor("TouchSmoke").setDescription("click smoke to animate"))
      .addChild(new TimeSensor("SmokeClock").setCycleInterval(30).setStartTime(-1))
      .addChild(new CoordinateInterpolator("SmokeSpineInterpolator").setKey(new double[] {0.0,0.2,0.5,0.8,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-1.0,0.0,0.0,-2.0,0.0,0.0,-3.0,0.0,0.0,-5.0,0.0,0.0,0.0,0.0,0.0,-2.0,0.0,0.0,-4.0,-0.5,0.0,-6.0,-1.0,0.0,-8.0,-2.0,0.0,0.0,0.0,0.0,-4.0,0.0,0.0,-8.0,-1.0,0.0,-13.0,-2.0,0.0,-20.0,-2.5,0.0,0.0,0.0,0.0,-2.0,0.0,0.0,-4.0,-0.5,0.0,-6.0,-1.0,0.0,-8.0,-2.0,0.0,0.0,0.0,0.0,-1.0,0.0,0.0,-2.0,0.0,0.0,-3.0,0.0,0.0,-5.0,0.0,0.0})))
      .addChild(new ROUTE().setFromNode("TouchSmoke").setFromField("touchTime").setToNode("SmokeClock").setToField("startTime"))
      .addChild(new ROUTE().setFromNode("SmokeClock").setFromField("fraction_changed").setToNode("SmokeSpineInterpolator").setToField("set_fraction"))
      .addChild(new ROUTE().setFromNode("SmokeSpineInterpolator").setFromField("value_changed").setToNode("Smoke").setToField("set_spine")))
    .addChild(new Transform("SuperstructurePosition").setTranslation(12.0,1.0,0.0)
      .addChild(new ProtoInstance("ExtrusionCrossSection", "Superstructure").setContainerField("children")
        .addFieldValue(new fieldValue().setName("name").setValue("Superstructure"))
        .addFieldValue(new fieldValue().setName("crossSection").setValue(new MFVec2f(new MFVec2f(new double[] {0.1,1.0,0.1,-1.0,-1.0,-1.0,-1.0,1.0,0.1,1.0}))))
        .addFieldValue(new fieldValue().setName("spine").setValue(new MFVec3f(new MFVec3f(new double[] {0.0,0.0,0.0,0.0,1.0,0.0,0.0,1.95,0.0,0.0,1.96,0.0,0.0,3.0,0.0}))))
        .addFieldValue(new fieldValue().setName("scale").setValue(new MFVec2f(new MFVec2f(new double[] {6.0,2.0,6.0,2.0,6.0,2.0,1.0,1.8,1.0,1.8}))))
        .addFieldValue(new fieldValue().setName("spineColor").setValue(new SFColor(0.7,0.7,0.0)))
        .addFieldValue(new fieldValue().setName("ccw").setValue(true))
        .addFieldValue(new fieldValue().setName("crossSectionColor").setValue(new SFColor(0.6,0.6,0.2)))
        .addFieldValue(new fieldValue().setName("extrusionColor").setValue(new SFColor(0.3,0.6,0.6)))
        .addFieldValue(new fieldValue().setName("extrusionTransparency").setValue(0.6))
        .addFieldValue(new fieldValue().setName("traceEnabled").setValue(false))))
    .addChild(new Transform("StackPosition").setTranslation(8.0,1.0,0.0)
      .addChild(new ProtoInstance("ExtrusionCrossSection", "Stack").setContainerField("children")
        .addFieldValue(new fieldValue().setName("name").setValue("Stack"))
        .addFieldValue(new fieldValue().setName("crossSection").setValue(new MFVec2f(new MFVec2f(new double[] {0.0,1.0,0.38,0.92,0.71,0.71,0.92,0.38,1.0,0.0,0.92,-0.38,0.71,-0.71,0.38,-0.92,0.0,-1.0,-0.38,-0.92,-0.71,-0.71,-0.92,-0.38,-1.0,0.0,-0.92,0.38,-0.71,0.71,-0.38,0.92,0.0,1.0}))))
        .addFieldValue(new fieldValue().setName("spine").setValue(new MFVec3f(new MFVec3f(new double[] {0.1,2.0,0.0,0.0,5.0,0.0,-0.4,5.6,0.0,-1.0,6.0,0.0}))))
        .addFieldValue(new fieldValue().setName("scale").setValue(new MFVec2f(new MFVec2f(new double[] {1.0,1.0,1.0,1.0,0.9,0.85,0.8,0.4}))))
        .addFieldValue(new fieldValue().setName("orientation").setValue(new MFRotation(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.4}))))
        .addFieldValue(new fieldValue().setName("spineColor").setValue(new SFColor(1.0,1.0,1.0)))
        .addFieldValue(new fieldValue().setName("creaseAngle").setValue(1))
        .addFieldValue(new fieldValue().setName("crossSectionColor").setValue(new SFColor(0.8,0.2,0.2)))
        .addFieldValue(new fieldValue().setName("crossSectionTransparency").setValue(0.1))
        .addFieldValue(new fieldValue().setName("extrusionColor").setValue(new SFColor(0.3,0.3,0.3)))
        .addFieldValue(new fieldValue().setName("extrusionTransparency").setValue(0.5))
        .addFieldValue(new fieldValue().setName("traceEnabled").setValue(false))))
    .addChild(new Transform("HullPosition").setTranslation(0.0,1.0,0.0)
      .addChild(new ProtoInstance("ExtrusionCrossSection", "Hull").setContainerField("children")
        .addFieldValue(new fieldValue().setName("name").setValue("Hull"))
        .addFieldValue(new fieldValue().setName("solid").setValue(false))
        .addFieldValue(new fieldValue().setName("crossSection").setValue(new MFVec2f(new MFVec2f(new double[] {0.0,1.0,0.38,0.92,0.71,0.71,0.92,0.38,1.0,0.0,0.92,-0.38,0.71,-0.71,0.38,-0.92,0.0,-1.0}))))
        .addFieldValue(new fieldValue().setName("spine").setValue(new MFVec3f(new MFVec3f(new double[] {-20.0,0.0,0.0,-17.0,0.0,0.0,0.0,0.0,0.0,10.0,0.0,0.0,22.0,1.0,0.0}))))
        .addFieldValue(new fieldValue().setName("scale").setValue(new MFVec2f(new MFVec2f(new double[] {3.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,5.0,.1}))))
        .addFieldValue(new fieldValue().setName("orientation").setValue(new MFRotation(new MFRotation(new double[] {1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,-0.5}))))
        .addFieldValue(new fieldValue().setName("traceEnabled").setValue(false))))
    .addComments(" ==================== ")
    .addComments(" Display world coordinate axes at (0 0 0) ")
    .addChild(new Transform().setScale(5.0,5.0,5.0)
      .addChild(new Inline("CoordinateAxes").setUrl(new String[] {"../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","../../Savage/Tools/Authoring/CoordinateAxes.x3d","https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.x3d","../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","../../Savage/Tools/Authoring/CoordinateAxes.wrl","https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.wrl"})))
    .addComments(" Display smoke extrusion coordinate axes: y along spine, x pointing up ")
    .addChild(new Transform().setTranslation(6.0,8.5,0.0)
      .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
        .addChild(new Inline().setUSE("CoordinateAxes")))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return ExtrusionCrossSectionExampleShip model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new ExtrusionCrossSectionExampleShip().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.course.ExtrusionCrossSectionExampleShip\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.course.ExtrusionCrossSectionExampleShip self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // course/ExtrusionCrossSectionExampleShip_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "course/ExtrusionCrossSectionExampleShip_JavaExport.x3d"; 
                String filenameX3DV = "course/ExtrusionCrossSectionExampleShip_JavaExport.x3dv"; 
                String filenameJSON = "course/ExtrusionCrossSectionExampleShip_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
