package Basic.course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Sample world constructed in a Script node using the EcmaScript Browser call createX3DFromString. </p>
 <p> Related links: Catalog page <a href="../../../course/CreateX3DFromStringRandomSpheresIndex.html" target="_blank">CreateX3DFromStringRandomSpheres</a>,  source <a href="../../../course/CreateX3DFromStringRandomSpheres.java">CreateX3DFromStringRandomSpheres.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../course/CreateX3DFromStringRandomSpheres.x3d">CreateX3DFromStringRandomSpheres.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Sample world constructed in a Script node using the EcmaScript Browser call createX3DFromString. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> originally by Vincent Gardet, revised by Curt Blais, adapted to X3D by Don Brutzman and MV4205 class </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 3 May 2007 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 12 October 2023 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../course/CreateVrmlFromStringRandomBoxes.x3d">CreateVrmlFromStringRandomBoxes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../course/CreateX3DFromStringRandomSpheres.png">CreateX3DFromStringRandomSpheres.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> See CreateVrmlFromString tutorial at </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.gardet.nom.fr/vrmlcity/tut_cvfs.htm" target="_blank">http://www.gardet.nom.fr/vrmlcity/tut_cvfs.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> create X3D from string, ecmascript </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> X3D browser support for Browser.createX3DFromString() is poor </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Xj3D fails on embedded quote marks in sceneString Script </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> this scene will not work in VRML97 browsers </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/course/CreateX3DFromStringRandomSpheres.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/course/CreateX3DFromStringRandomSpheres.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 4.0, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author originally by Vincent Gardet, revised by Curt Blais, adapted to X3D by Don Brutzman and MV4205 class
 */

public class CreateX3DFromStringRandomSpheres
{
	/** Default constructor to create this object. */
	public CreateX3DFromStringRandomSpheres ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_1)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("CreateX3DFromStringRandomSpheres.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Sample world constructed in a Script node using the EcmaScript Browser call createX3DFromString."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("originally by Vincent Gardet, revised by Curt Blais, adapted to X3D by Don Brutzman and MV4205 class"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("3 May 2007"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("12 October 2023"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("CreateVrmlFromStringRandomBoxes.x3d"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("CreateX3DFromStringRandomSpheres.png"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("See CreateVrmlFromString tutorial at"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.gardet.nom.fr/vrmlcity/tut_cvfs.htm"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("create X3D from string, ecmascript"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("X3D browser support for Browser.createX3DFromString() is poor"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Xj3D fails on embedded quote marks in sceneString Script"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("this scene will not work in VRML97 browsers"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/course/CreateX3DFromStringRandomSpheres.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 4.0, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("CreateX3DFromStringRandomSpheres.x3d"))
    .addChild(new NavigationInfo().setAvatarSize(new double[] {0.1,1.6,2.0}).setHeadlight(false).setSpeed(5).setType("\"EXAMINE\" \"WALK\" \"ANY\""))
    .addChild(new Background().setSkyAngle(new double[] {1.1,1.57}).setSkyColor(new MFColor(new double[] {.3,.3,1.0,.4,.4,1.0,.7,.7,.9})))
    .addChild(new DirectionalLight().setDirection(0.0,-.5,-1.0))
    .addChild(new DirectionalLight().setDirection(-1.0,-.5,.5).setIntensity(.9))
    .addChild(new DirectionalLight().setDirection(1.0,-.5,.5).setIntensity(.8))
    .addChild(new Viewpoint().setDescription("Interaction view").setPosition(50.0,1.6,150.0))
    .addChild(new Viewpoint().setDescription("Plan (top-down) view").setOrientation(1.0,0.0,0.0,-1.54).setPosition(50.0,200.0,50.0))
    .addChild(new Shape()
      .setAppearance(new Appearance()
        .setMaterial(new Material().setDiffuseColor(.3,.3,1.0).setTransparency(0.5)))
      .setGeometry(new Box().setSize(1000.0,0.01,1000.0)))
    .addChild(new Transform().setTranslation(50.0,1.6,140.0)
      .addComments(" the following is a common interaction design pattern in X3D ")
      .addChild(new Billboard()
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.1,0.3,0.2).setEmissiveColor(0.3,0.6,0.9)))
          .setGeometry(new Text().setString(new String[] {"Ten random spheres","computed at runtime","","(view console for results)"})
            .setFontStyle(new FontStyle().setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE))))
        .addChild(new TouchSensor("TouchText").setDescription("Touch text to recompute random spheres"))
        .addComments(" Transparent Box makes the text much more accessible/clickable ")
        .addChild(new Shape()
          .setGeometry(new Box().setSize(8.0,2.0,0.1))
          .setAppearance(new Appearance()
            .setMaterial(new Material().setTransparency(1))))))
    .addComments(" ROOT is used at initialize time as parent for randomly generated Shape children ")
    .addChild(new Group("HoldsAutogeneratedContent"))
    .addChild(new Script("SphereGeneratorScript").setDirectOutput(true).setSourceCode("""
ecmascript:

function R ()
{
	return Math.random();
}
function recompute (isActive)
{
	if (isActive==true) initialize();
}

function initialize()
{
  for (i=0; i < 10; i++)
  {
    rand1 = 100*R();
    rand2 = 100*R();
    rand3 = 20*R();
    rand4 = 40*R();
    rand5 = 20*R();
    sceneString =    '<X3D version="3.1" profile="Interchange">\n' +
                     '  <Scene>\n' +
                     '      <Transform translation="' + rand1 + ' 0 ' + rand2 + '" >\n' +
                     '           <Shape>\n' +
                     '                   <Appearance>\n' +
                     '                      <Material diffuseColor="' + R() + ' ' + R() + ' ' + R() + '"/>\n' +
                     '                   </Appearance>\n' +
                     '                   <Sphere radius="' + (rand3 / 2) + '"/>\n' +
                     '           </Shape>\n' +
                     '      </Transform>\n' +
                     '  </Scene>\n' +
                     '</X3D>\n' +
                     '<!--==============================================-->\n';

       Browser.println (sceneString);
//     newNode = Browser.createVrmlFromString(sceneString);
       newNode = Browser.createX3DFromString(sceneString);
       ModifiableExternalNode.children[i] = newNode[0];
  }
}
""")
      .addField(new field().setName("ModifiableExternalNode").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new Group().setUSE("HoldsAutogeneratedContent")))
      .addField(new field().setName("recompute").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new ROUTE().setFromNode("TouchText").setFromField("isActive").setToNode("SphereGeneratorScript").setToField("recompute")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return CreateX3DFromStringRandomSpheres model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new CreateX3DFromStringRandomSpheres().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.course.CreateX3DFromStringRandomSpheres\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.course.CreateX3DFromStringRandomSpheres self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // course/CreateX3DFromStringRandomSpheres_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "course/CreateX3DFromStringRandomSpheres_JavaExport.x3d"; 
                String filenameX3DV = "course/CreateX3DFromStringRandomSpheres_JavaExport.x3dv"; 
                String filenameJSON = "course/CreateX3DFromStringRandomSpheres_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
