package Basic.course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Sixth grade project to build a highway overpass. </p>
 <p> Related links: Catalog page <a href="../../../course/BeckyRoadOverpassIndex.html" target="_blank">BeckyRoadOverpass</a>,  source <a href="../../../course/BeckyRoadOverpass.java">BeckyRoadOverpass.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../course/BeckyRoadOverpass.x3d">BeckyRoadOverpass.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Becky and Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 10 September 2000 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Sixth grade project to build a highway overpass. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../course/BeckyRoadOverpass.png">BeckyRoadOverpass.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/course/BeckyRoadOverpass.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/course/BeckyRoadOverpass.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Becky and Don Brutzman
 */

public class BeckyRoadOverpass
{
	/** Default constructor to create this object. */
	public BeckyRoadOverpass ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("BeckyRoadOverpass.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Becky and Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("10 September 2000"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Sixth grade project to build a highway overpass."))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("BeckyRoadOverpass.png"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/course/BeckyRoadOverpass.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("BeckyRoadOverpass.x3d"))
    .addChild(new Viewpoint().setDescription("Front view, 4 inches above ground").setPosition(0.0,4.0,20.0))
    .addChild(new Viewpoint().setDescription("Side view, 6 inches above ground").setOrientation(0.0,1.0,0.0,1.57).setPosition(25.0,6.0,0.0))
    .addChild(new Viewpoint().setDescription("Top-down view, 20 inches above").setOrientation(1.0,0.0,0.0,-1.57).setPosition(0.0,28.0,0.0))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.1,0.1,0.0,0.4,0.25,0.2,0.6,0.6,0.6})).setSkyAngle(new double[] {1.309,1.571}).setSkyColor(new MFColor(new double[] {0.0,0.2,0.7,0.0,0.5,1.0,1.0,1.0,1.0})))
    .addComments(" Upper road surface is elevated y=8 inches in the air ")
    .addChild(new Transform().setTranslation(0.0,8.0,0.0)
      .addChild(new Group("Road")
        .addChild(new Shape()
          .addComments(" Road model is x=20 inches long by z=7 inches wide, with posterboard y=0.25 inches thick ")
          .setGeometry(new Box().setSize(20.0,0.2,7.0))
          .addComments(" Road surface color is grey ")
          .setAppearance(new Appearance("GreyAppearance")
            .setMaterial(new Material().setDiffuseColor(0.4,0.4,0.4))))
        .addChild(new Transform().setTranslation(0.0,0.2,0.3)
          .addChild(new Shape("WhiteLine")
            .setGeometry(new Box().setSize(20.0,0.01,0.4))
            .setAppearance(new Appearance("WhiteAppearance")
              .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(0.5,0.5,0.5)))))
        .addChild(new Transform().setTranslation(0.0,0.2,-0.3)
          .addChild(new Shape().setUSE("WhiteLine")))))
    .addComments(" Lower road is on the ground at y=0 inches, rotated 90 degrees around y axis ")
    .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(0.0,0.1,0.0)
      .addChild(new Group().setUSE("Road")))
    .addComments(" Vertical center of y=8 inch tall pillar is y=4 inches in the air ")
    .addComments(" Center of each column matches top-down diagram ")
    .addChild(new Transform("ColumnA").setTranslation(-6.0,4.0,-2.0)
      .addChild(new Shape("Column")
        .setGeometry(new Cylinder().setHeight(8))
        .setAppearance(new Appearance().setUSE("GreyAppearance"))))
    .addChild(new Transform("ColumnB").setTranslation(6.0,4.0,-2.0)
      .addChild(new Shape().setUSE("Column")))
    .addChild(new Transform("ColumnC").setTranslation(-6.0,4.0,2.0)
      .addChild(new Shape().setUSE("Column")))
    .addChild(new Transform("ColumnD").setTranslation(6.0,4.0,2.0)
      .addChild(new Shape().setUSE("Column"))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return BeckyRoadOverpass model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new BeckyRoadOverpass().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.course.BeckyRoadOverpass\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.course.BeckyRoadOverpass self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // course/BeckyRoadOverpass_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "course/BeckyRoadOverpass_JavaExport.x3d"; 
                String filenameX3DV = "course/BeckyRoadOverpass_JavaExport.x3dv"; 
                String filenameJSON = "course/BeckyRoadOverpass_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
