/**
 *<p>
 *	These examples are used in the X3D Specifications to illustrate correct X3D usage and capabilities.
 *</p>
 *<p>
 *	The 
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/Architecture.html" target="_blank">X3D Abstract Specification</a>
 *	authoritatively defines the functionality of X3D scenes.
 *	It specifically describes how geometry rendering and user interaction can be accomplished on any 3D&nbsp;device.  
 *	Multiple file encodings (.x3d, .x3dv, .x3db) and multiple language bindings (ECMAScript .js, Java .java)
 *	can equivalently represent an X3D scene.
 *
 *	These examples support five different X3D specifications:       
 *</p>              
 *
 *<ul>
 *
 *	<li>
 *		<a href="https://www.web3d.org/documents/specifications/19776-1/V3.3//Part01/X3D_XML.html" target="_blank">XML encoding</a>
 *		(<code>.x3d</code> file extension)
 *		scenes found in the
 *		<a href="https://www.web3d.org/documents/specifications/19776-1/V3.3//Part01/examples.html" target="_blank">XML encoding examples</a>.
 *
 *	</li>
 *
 *	<li>
 *		<a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html" target="_blank">Classic VRML encoding</a>
 *		(<code>.x3dv</code> file extension).
 *
 *		Autogenerated examples matching the master .x3d model can be compared favorably to the
 *		<a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/examples.html" target="_blank">Classic VRML encoding examples</a>.
 *
 *
 *	</li>
 *
 *	<li>
 *		<a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/X3D_Binary.html" target="_blank">Compressed Binary Encoding (CBE)</a>
 *		(<code>.x3db</code> file extension).
 *
 *		Autogenerated examples matching the master .x3d model can be compared favorably to the
 *		<a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/examples.html" target="_blank">Binary encoding examples</a>.
 *
 *	</li>
 *
 *	<li>
 *		<a href="https://www.web3d.org/documents/specifications/19777-1/V3.3/Part1/X3D_ECMAScript.html" target="_blank">ECMAScript Scene Access Interface (SAI)</a>
 *		scenes and source (<code>.js</code> file extension) are provided that match the
 *		<a href="https://www.web3d.org/documents/specifications/19777-1/V3.3/Part1/examples.html" target="_blank">X3D ECMAScript language binding examples</a>.
 *		<br />
 *		TODO, transcription work in progress.
 *
 *	</li>
 *
 *	<li>
 *		<a href="https://www.web3d.org/documents/specifications/19777-2/V3.0/Part2/X3D_Java.html" target="_blank">Java Scene Access Interface (SAI)</a>
 *		scenes and source (<code>.java</code> file extension) are provided that match the
 *		<a href="https://www.web3d.org/documents/specifications/19777-2/V3.0/Part2/examples.html" target="_blank">X3D Java language binding examples</a>.
 *		<br />
 *		TODO, testing in progress.
 *
 *	</li>
 *
 *</ul>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications" target="_blank">X3D Basic: X3D Specifications</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.X3dSpecifications;

