####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python TwoLeggedTablePrototype.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='TwoLeggedTablePrototype.x3d',name='title'),
    meta(content='X3D encodings example: defining a Prototype, demonstration of IS/connect definitions.',name='description'),
    meta(content='Don Brutzman and Joe Williams',name='creator'),
    meta(content='1 June 2002',name='created'),
    meta(content='31 January 2025',name='modified'),
    meta(content='X3D encodings, ISO/IEC 19776-1.3, Part 1: XML encoding, Annex C.4 Prototype example',name='specificationSection'),
    meta(content='https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/examples.html#PrototypeExample',name='specificationUrl'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/TwoLeggedTablePrototype.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='TwoLeggedTablePrototype.x3d'),
    NavigationInfo(),
    #  Use the Examine viewer 
    ProtoDeclare(name='TwoColorTable',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='initializeOnly',name='legColor',type='SFColor',value=(.8,.4,.7)),
        field(accessType='initializeOnly',name='topColor',type='SFColor',value=(.6,.6,.1))]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Transform(translation=(0.0,0.6,0.0),
            #  table top 
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='TableTopMaterial',
                  IS=IS(
                    connect=[
                    connect(nodeField='diffuseColor',protoField='topColor')]))),
              geometry=Box(size=(1.2,0.2,1.2)))]),
          Transform(translation=(-0.5,0.0,-0.5),
            #  first table leg 
            children=[
            Shape(DEF='Leg',
              appearance=Appearance(
                material=Material(DEF='LegMaterial',diffuseColor=(1.0,0.0,0.0),
                  IS=IS(
                    connect=[
                    connect(nodeField='diffuseColor',protoField='legColor')]))),
              geometry=Cylinder(height=1.0,radius=0.1))]),
          Transform(translation=(0.5,0.0,-0.5),
            #  another table leg 
            children=[
            Shape(USE='Leg')]),
          Transform(translation=(-0.5,0.0,0.5),
            children=[
            Shape(USE='Leg')]
            #  another table leg 
            ),
          Transform(translation=(0.5,0.0,0.5),
            children=[
            Shape(USE='Leg')]
            #  another table leg 
            )]
          #  End of root Transform's children 
          )]
        #  End of root Transform 
        )),
    #  End of prototype 
    #  The prototype is now defined. Although it contains a number of nodes, only the legColor and topColor fields are public. Instead of using the default legColor and topColor, this instance of the table has red legs and a green top: 
    #  show both DEF ProtoInstance and USE ProtoInstance 
    Group(DEF='TwoTables',
      children=[
      Transform(translation=(-1,0,0),
        children=[
        ProtoInstance(DEF='TCT',name='TwoColorTable',
          fieldValue=[
          fieldValue(name='legColor',value=(1,0,0)),
          fieldValue(name='topColor',value=(0,1,0))])]),
      Transform(translation=(1,0,0),
        children=[
        ProtoInstance(USE='TCT',name='NewProtoInstance')])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for TwoLeggedTablePrototype.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python TwoLeggedTablePrototype.py load and self-test diagnostics complete.")
