####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python NurbsSwungSurfaceExample.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    component(level=3,name='NURBS'),
    meta(content='NurbsSwungSurfaceExample.x3d',name='title'),
    meta(content='X3D Architecture example: NurbsSwungSurface demonstration.',name='description'),
    meta(content='Doug Sanden and Don Brutzman',name='creator'),
    meta(content='13 April 2022',name='created'),
    meta(content='22 November 2023',name='modified'),
    meta(content='NurbsSwungSurfaceExample.png',name='Image'),
    meta(content='X3D Architecture, 27 NURBS component, 27.4.11 NurbsSwungSurface',name='specificationSection'),
    meta(content='https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/nurbs.html#NurbsSwungSurface',name='specificationUrl'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/NurbsSwungSurfaceExample.x3d',name='identifier'),
    meta(content='X3D-Edit 4.0, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    Group(
      children=[
      Shape(
        geometry=LineSet(vertexCount=[2],
          coord=Coordinate(point=[(0,0,0),(4,0,0)])),
        appearance=Appearance(
          material=Material(emissiveColor=(1,0,0)),
          lineProperties=LineProperties(linewidthScaleFactor=4))),
      Shape(
        geometry=LineSet(vertexCount=[2],
          coord=Coordinate(point=[(0,0,0),(0,4,0)])),
        appearance=Appearance(
          material=Material(emissiveColor=(0,1,0)),
          lineProperties=LineProperties(linewidthScaleFactor=4))),
      Shape(
        geometry=LineSet(vertexCount=[2],
          coord=Coordinate(point=[(0,0,0),(0,0,4)])),
        appearance=Appearance(
          material=Material(emissiveColor=(0,0,1)),
          lineProperties=LineProperties(linewidthScaleFactor=4)))]),
    Background(skyColor=[(1,1,1)],transparency=1.0),
    Viewpoint(),
    Transform(
      children=[
      Shape(
        appearance=Appearance(
          material=Material(transparency=.5)),
        geometry=NurbsSwungSurface(
          profileCurve=NurbsCurve2D(controlPoint=[(.5,.25),(0,.25),(0,1),(.25,1),(.25,2),(0,2)],knot=[0,0,0,.25,.5,.75,1,1,1],tessellation=8,weight=[1,1,1,1,1,1]),
          trajectoryCurve=NurbsCurve2D(controlPoint=[(2,-.5),(1.5,-.25),(1.5,-.25),(1.5,1.0),(2.0,1.5),(2.0,2.0),(1.0,2.0),(1.0,1.5),(-.25,1.5),(-.25,2.0),(-.5,2.0)],knot=[0,0,0,1,2,3,4,5,6,7,8,9,9,9],tessellation=8,weight=[1,1,1,1,1,1,1,1,1,1,1])))]),
    Transform(
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='CYAN',diffuseColor=(0,.8,.8)),
          lineProperties=LineProperties(linewidthScaleFactor=6)),
        #  To convert a NurbsCurve2D control curve to a displayable NurbsCurve 1. rename element NurbsCurve2D -> NurbsCurve 2. cut controlPoint= field and paste into child node CoordinateDouble point field 3. edit point field adding a 3rd (z) = 0 to each xy point 
        geometry=NurbsCurve(DEF='PROFILE',knot=[0,0,0,.25,.5,.75,1,1,1],weight=[1,1,1,1,1,1],
          controlPoint=CoordinateDouble(point=[(.5,.25,0),(0,.25,0),(0,1,0),(.25,1,0),(.25,2,0),(0,2,0)]))),
      Shape(
        appearance=Appearance(
          material=Material(DEF='MAGENTA',diffuseColor=(.8,0,.8)),
          lineProperties=LineProperties(linewidthScaleFactor=6)),
        geometry=NurbsCurve(DEF='TRAJECTORY',knot=[0,0,0,1,2,3,4,5,6,7,8,9,9,9],weight=[1,1,1,1,1,1,1,1,1,1,1],
          controlPoint=CoordinateDouble(point=[(2,-.5,0),(1.5,-.25,0),(1.5,-.25,0),(1.5,1.0,0),(2.0,1.5,0),(2.0,2.0,0),(1.0,2.0,0),(1.0,1.5,0),(-.25,1.5,0),(-.25,2.0,0),(-.5,2.0,0)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for NurbsSwungSurfaceExample.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python NurbsSwungSurfaceExample.py load and self-test diagnostics complete.")
