####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python JavaSaiTouchSensorIsOverEvent.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='JavaSaiTouchSensorIsOverEvent.x3d',name='title'),
    meta(content='Java Scene Authoring Interface (JSAI) scene and source code example that demonstrate a scripted response to a TouchSensor isOver event by changing the color of a Box from blue to red.',name='description'),
    meta(content='X3D Working Group',name='creator'),
    meta(content='Xeena VRML importer',name='translator'),
    meta(content='23 February 2005',name='imported'),
    meta(content='23 February 2005',name='created'),
    meta(content='28 October 2019',name='modified'),
    meta(content='SAIExample1.java',name='reference'),
    meta(content='build, compile, test',name='TODO'),
    meta(content='https://www.web3d.org/files/specifications/19777-2/V3.0/Part2/X3D_Java.html',name='reference'),
    meta(content='X3D language bindings, ISO/IEC 19777-2, Part 2: Java, D.2 TouchSensor isOver event',name='specificationSection'),
    meta(content='https://www.web3d.org/files/specifications/19777-2/V3.0/Part2/examples.html#TouchSensorIsOverEvent',name='specificationUrl'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://www.web3d.org/TaskGroups/x3d/translation/README.X3D-Edit.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/JavaSaiTouchSensorIsOverEvent.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='JavaSaiTouchSensorIsOverEvent.x3d'),
    Group(
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='MAT',diffuseColor=(0,0,1))),
        geometry=Box(),),
      TouchSensor(DEF='TS')]),
    Script(DEF='SC',url=["SAIExample1.class","https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/SAIExample1.class"],
      field=[
      field(accessType='inputOnly',name='isOver',type='SFBool'),
      field(accessType='outputOnly',name='diffuseColor_changed',type='SFColor')],

    sourceCode="""
ecmascript:

"""),
    ROUTE(fromField='isOver',fromNode='TS',toField='isOver',toNode='SC'),
    ROUTE(fromField='diffuseColor_changed',fromNode='SC',toField='set_diffuseColor',toNode='MAT')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for JavaSaiTouchSensorIsOverEvent.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python JavaSaiTouchSensorIsOverEvent.py load and self-test diagnostics complete.")
