package Basic.X3dSpecifications;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> X3D encodings example: demonstrate reuse and adaptation of content instances through Inline IMPORT, EXPORT statements. This scene animates only a portion of model InlineExport.x3d that exposes a Transform scene subgraph. </p>
 <p> Related links: Catalog page <a href="../../../X3dSpecifications/InlineImportIndex.html" target="_blank">InlineImport</a>,  source <a href="../../../X3dSpecifications/InlineImport.java">InlineImport.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineImport.x3d">InlineImport.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> X3D encodings example: demonstrate reuse and adaptation of content instances through Inline IMPORT, EXPORT statements. This scene animates only a portion of model InlineExport.x3d that exposes a Transform scene subgraph. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> info </i> </td>
			<td> The exchange of events can be passed not only from parent Inline to contained model, but also from child to parent, and to external HTML5 web pages as well. If authors and model libraries use consistent naming conventions for EXPORT of exposed nodes, this extensibility enables large-scale composition of X3D worlds containing consistently animatable models. Applying this design pattern in concert with naming conventions and metadata vocabularies holds excellent potential for use in Smart City visualization. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 27 May 2024 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineImportInlineExportAnimation.png">InlineImportInlineExportAnimation.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> drawing </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineImportInlineExportAnimation.vsdx">InlineImportInlineExportAnimation.vsdx</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineImportX_ITE.png">InlineImportX_ITE.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineImportX3DOM.png">InlineImportX3DOM.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineImportX_ITE.png">InlineImportX_ITE.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineImportCastleModelViewer.png">InlineImportCastleModelViewer.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../X3dSpecifications/InlineExport.x3d">InlineExport.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationSection </i> </td>
			<td> X3D Architecture version 4.0 ISO/IEC 19775-1, clause 4 Concepts, 4.4.6 Import/Export semantics </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationUrl </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/concepts.html#ImportExportsemantics" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/concepts.html#ImportExportsemantics</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationSection </i> </td>
			<td> X3D encodings, ISO/IEC 19776-1, Part 1: XML encoding, clause 4.3.2.6 EXPORT/IMPORT statement syntax </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationUrl </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19776-1v4.0-WD1/Part01/concepts.html#EXPORT_IMPORT_StatementSyntax" target="_blank">https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19776-1v4.0-WD1/Part01/concepts.html#EXPORT_IMPORT_StatementSyntax</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationSection </i> </td>
			<td> X3D encodings, ISO/IEC 19776-2, Part 1: ClassicVRML encoding, clause 4.3.2.6 EXPORT/IMPORT statement syntax </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationUrl </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19776-2v4.0-WD1/Part02/concepts.html#EXPORT_IMPORT_StatementSyntax" target="_blank">https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19776-2v4.0-WD1/Part02/concepts.html#EXPORT_IMPORT_StatementSyntax</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 4.0, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/InlineImport.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/InlineImport.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../X3dSpecifications/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Don Brutzman
 */

public class InlineImport
{
	/** Default constructor to create this object. */
	public InlineImport ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("InlineImport.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("X3D encodings example: demonstrate reuse and adaptation of content instances through Inline IMPORT, EXPORT statements. This scene animates only a portion of model InlineExport.x3d that exposes a Transform scene subgraph."))
    .addMeta(new meta().setName(meta.NAME_INFO       ).setContent("The exchange of events can be passed not only from parent Inline to contained model, but also from child to parent, and to external HTML5 web pages as well. If authors and model libraries use consistent naming conventions for EXPORT of exposed nodes, this extensibility enables large-scale composition of X3D worlds containing consistently animatable models. Applying this design pattern in concert with naming conventions and metadata vocabularies holds excellent potential for use in Smart City visualization."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("27 May 2024"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("InlineImportInlineExportAnimation.png"))
    .addMeta(new meta().setName(meta.NAME_DRAWING    ).setContent("InlineImportInlineExportAnimation.vsdx"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("InlineImportX_ITE.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("InlineImportX3DOM.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("InlineImportX_ITE.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("InlineImportCastleModelViewer.png"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("InlineExport.x3d"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONSECTION).setContent("X3D Architecture version 4.0 ISO/IEC 19775-1, clause 4 Concepts, 4.4.6 Import/Export semantics"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONURL).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/concepts.html#ImportExportsemantics"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONSECTION).setContent("X3D encodings, ISO/IEC 19776-1, Part 1: XML encoding, clause 4.3.2.6 EXPORT/IMPORT statement syntax"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONURL).setContent("https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19776-1v4.0-WD1/Part01/concepts.html#EXPORT_IMPORT_StatementSyntax"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONSECTION).setContent("X3D encodings, ISO/IEC 19776-2, Part 1: ClassicVRML encoding, clause 4.3.2.6 EXPORT/IMPORT statement syntax"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONURL).setContent("https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19776-2v4.0-WD1/Part02/concepts.html#EXPORT_IMPORT_StatementSyntax"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 4.0, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/InlineImport.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("InlineImport.x3d"))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {1.0,1.0,1.0})))
    .addChild(new Inline("MyInlineModel").setDescription("Load model that provides external access to a node via an EXPORT statement, accessed by IMPORT statement in this model").setUrl(new String[] {"InlineExport.x3d","https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/InlineExport.x3d","InlineExport.wrl","https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/InlineExport.wrl"})
      .setMetadata(new MetadataString().setName("profile").setValue(new String[] {"Immersive"})))
    .addComments(" Hint: when using IMPORT statement, the author must keep track of correct node type for importedDEF node within the external Inline scene, otherwise a runtime error can occur in this scene. ")
    .addComments(" Hint: IMPORT inlineDEF is DEF name of Inline node in this scene. ")
    .addComments(" Hint: importedDEF is DEF name exported by the external model, AS is the exposed DEF name in this scene. ")
    .addChild(new IMPORT().setImportedDEF("RootTransform").setInlineDEF("MyInlineModel").setAS("MyInlineRootTransform"))
    .addChild(new OrientationInterpolator("MySpinner").setKey(new double[] {0.0,0.3333,0.6667,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,2.094395,0.0,1.0,0.0,4.18879,0.0,1.0,0.0,0.0})))
    .addChild(new ROUTE().setFromNode("MySpinner").setFromField("value_changed").setToNode("MyInlineRootTransform").setToField("set_rotation"))
    .addChild(new TimeSensor("SpinClock").setCycleInterval(8).setLoop(true))
    .addChild(new ROUTE().setFromNode("SpinClock").setFromField("fraction_changed").setToNode("MySpinner").setToField("set_fraction")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return InlineImport model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new InlineImport().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.X3dSpecifications.InlineImport\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.X3dSpecifications.InlineImport self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // X3dSpecifications/InlineImport_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "X3dSpecifications/InlineImport_JavaExport.x3d"; 
                String filenameX3DV = "X3dSpecifications/InlineImport_JavaExport.x3dv"; 
                String filenameJSON = "X3dSpecifications/InlineImport_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
