package Basic.X3dSpecifications;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> X3D Extrusion spine-aligned cross-section plane (SCP) at a spine point. Modeled after Figure 13.5 in X3D Specification. </p>
 <p> Related links: Catalog page <a href="../../../X3dSpecifications/ExtrusionFigureX3dSpecificationIndex.html" target="_blank">ExtrusionFigureX3dSpecification</a>,  source <a href="../../../X3dSpecifications/ExtrusionFigureX3dSpecification.java">ExtrusionFigureX3dSpecification.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../X3dSpecifications/ExtrusionFigureX3dSpecification.x3d">ExtrusionFigureX3dSpecification.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> X3D Extrusion spine-aligned cross-section plane (SCP) at a spine point. Modeled after Figure 13.5 in X3D Specification. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Al Shaffer </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 4 February 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 28 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../X3dSpecifications/Extrusion.gif">Extrusion.gif</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationSection </i> </td>
			<td> X3D encodings, ISO/IEC 19776-1.3, Part 1: XML encoding, Figure 13.5 - Spine-aligned cross-section plane at a spine point. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationUrl </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geometry3D.html#f-Spine-alignedcross-section" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geometry3D.html#f-Spine-alignedcross-section</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/ExtrusionFigureX3dSpecification.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/ExtrusionFigureX3dSpecification.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../X3dSpecifications/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Al Shaffer
 */

public class ExtrusionFigureX3dSpecification
{
	/** Default constructor to create this object. */
	public ExtrusionFigureX3dSpecification ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("ExtrusionFigureX3dSpecification.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("X3D Extrusion spine-aligned cross-section plane (SCP) at a spine point. Modeled after Figure 13.5 in X3D Specification."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Al Shaffer"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("4 February 2005"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("28 October 2019"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("Extrusion.gif"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONSECTION).setContent("X3D encodings, ISO/IEC 19776-1.3, Part 1: XML encoding, Figure 13.5 - Spine-aligned cross-section plane at a spine point."))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONURL).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geometry3D.html#f-Spine-alignedcross-section"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/ExtrusionFigureX3dSpecification.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("ExtrusionFigureX3dSpecification.x3d"))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {1.0,1.0,1.0})).setSkyColor(new MFColor(new double[] {1.0,1.0,1.0})))
    .addChild(new Viewpoint().setDescription("X3D Specification Figure 13.5, Extrusion Spine-aligned Cross-section Plane (SCP)").setOrientation(1.0,0.0,0.0,-0.43).setPosition(-0.5,5.5,12.0))
    .addChild(new Viewpoint().setDescription("Front view, Spine-aligned Cross-section Plane (SCP)").setPosition(0.0,0.0,14.0))
    .addChild(new Viewpoint().setDescription("Overhead view, Spine-aligned Cross-section Plane (SCP)").setOrientation(1.0,0.0,0.0,-1.428899).setPosition(0.0,14.0,2.0))
    .addChild(new Transform()
      .addComments(" Draw partial coordinate axis. Code derived from CoordinateAxes.x3d by Don Brutzman, 21 January 2002 ")
      .addChild(new Transform("HALF_COORD_AXIS")
        .addChild(new Group()
          .addComments(" Vertical Y arrow and labels ")
          .addChild(new Group("ARROW")
            .addChild(new Transform().setTranslation(0.0,1.0,0.0)
              .addChild(new Shape()
                .setAppearance(new Appearance("ARROW_APPEARANCE")
                  .setMaterial(new Material().setDiffuseColor(0.0,1.0,.7)))
                .setGeometry(new Cylinder().setBottom(false).setRadius(.05).setTop(false))))
            .addChild(new Transform().setTranslation(0.0,2.0,0.0)
              .addChild(new Shape("ARROW_POINTER")
                .setGeometry(new Cone().setBottomRadius(.16).setHeight(.4))
                .setAppearance(new Appearance().setUSE("ARROW_APPEARANCE")))))
          .addChild(new Transform().setTranslation(0.15,2.1,0.15)
            .addChild(new Billboard().setAxisOfRotation(0.0,0.0,0.0)
              .addChild(new Shape()
                .setAppearance(new Appearance("LABEL_APPEARANCE")
                  .setMaterial(new Material().setDiffuseColor(0.0,0.0,0.0)))
                .setGeometry(new Text().setString(new String[] {"+Y axis"})
                  .setFontStyle(new FontStyle("LABEL_FONT").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_BEGIN_END).setSize(.4).setCssStyle("ITALIC")))))))
        .addChild(new Transform().setRotation(0.0,0.0,1.0,-1.57079)
          .addComments(" Horizontal X arrow and label ")
          .addChild(new Group()
            .addChild(new Group().setUSE("ARROW"))
            .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57079).setTranslation(-0.15,2.1,0.15)
              .addChild(new Billboard().setAxisOfRotation(0.0,0.0,0.0)
                .addChild(new Shape()
                  .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE"))
                  .setGeometry(new Text().setString(new String[] {"+X axis"})
                    .setFontStyle(new FontStyle().setUSE("LABEL_FONT"))))))))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,1.57079)
          .addComments(" Perpendicular Z arrow and label ")
          .addChild(new Group()
            .addChild(new Group().setUSE("ARROW"))
            .addChild(new Transform().setRotation(1.0,0.0,0.0,-1.57079).setTranslation(0.15,2.1,-0.15)
              .addChild(new Billboard().setAxisOfRotation(0.0,0.0,0.0)
                .addChild(new Shape()
                  .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE"))
                  .setGeometry(new Text().setString(new String[] {"+Z axis"})
                    .setFontStyle(new FontStyle().setUSE("LABEL_FONT")))))))))
      .addComments(" Draw spine-aligned cross-section plane at a spine point ")
      .addChild(new Transform("SPINE_CROSS_SECTION")
        .addChild(new Group()
          .addComments(" Draw sphere and label at center of coordinate axis ")
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape("DARK_GRAY_SPHERE")
                .setGeometry(new Sphere().setRadius(0.3))
                .setAppearance(new Appearance("DARK_GRAY")
                  .setMaterial(new Material().setDiffuseColor(0.15,0.15,0.15)))))
            .addChild(new Transform().setTranslation(-1.0,0.0,0.0)
              .addChild(new Billboard().setAxisOfRotation(0.0,0.0,0.0)
                .addChild(new Shape()
                  .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE"))
                  .setGeometry(new Text().setString(new String[] {"spine[i]"})
                    .setFontStyle(new FontStyle("LABEL_FONT2").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.4).setCssStyle("ITALIC")))))))
          .addComments(" Draw spine rods ")
          .addChild(new Group()
            .addChild(new Transform().setRotation(0.0,0.0,1.0,0.64)
              .addChild(new Transform().setTranslation(0.0,2.5,0.0)
                .addChild(new Shape("RED_ROD")
                  .setGeometry(new Cylinder().setBottom(false).setHeight(5.0).setRadius(0.08).setTop(false))
                  .setAppearance(new Appearance()
                    .setMaterial(new Material().setDiffuseColor(0.82,0.13,0.56))))))
            .addChild(new Transform().setRotation(0.0,0.0,1.0,-0.64)
              .addChild(new Transform().setTranslation(0.0,-2.5,0.0)
                .addChild(new Shape().setUSE("RED_ROD")))))
          .addComments(" Draw two spheres and labels at ends of spines ")
          .addChild(new Group()
            .addChild(new Transform().setTranslation(-3.0,4.0,0.0)
              .addChild(new Shape().setUSE("DARK_GRAY_SPHERE"))
              .addChild(new Transform().setTranslation(0.0,0.7,0.0)
                .addChild(new Billboard().setAxisOfRotation(0.0,0.0,0.0)
                  .addChild(new Shape()
                    .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE"))
                    .setGeometry(new Text().setString(new String[] {"spine[i+1]"})
                      .setFontStyle(new FontStyle().setUSE("LABEL_FONT2")))))))
            .addChild(new Transform().setTranslation(-3.0,-4.0,0.0)
              .addChild(new Shape().setUSE("DARK_GRAY_SPHERE"))
              .addChild(new Transform().setTranslation(0.0,-0.7,0.0)
                .addChild(new Billboard().setAxisOfRotation(0.0,0.0,0.0)
                  .addChild(new Shape()
                    .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE"))
                    .setGeometry(new Text().setString(new String[] {"spine[i-1]"})
                      .setFontStyle(new FontStyle().setUSE("LABEL_FONT2"))))))))
          .addComments(" Draw tangent and label between spines ")
          .addChild(new Group()
            .addChild(new Transform().setTranslation(-3.0,0.0,0.0)
              .addChild(new Shape()
                .setGeometry(new Cylinder().setHeight(8).setRadius(.02))
                .setAppearance(new Appearance().setUSE("DARK_GRAY"))))
            .addChild(new Transform().setRotation(0.0,0.0,1.0,3.14).setTranslation(-3.0,-3.55,0.0)
              .addChild(new Shape()
                .setGeometry(new Cone().setBottomRadius(.15).setHeight(.5))
                .setAppearance(new Appearance().setUSE("DARK_GRAY"))))
            .addChild(new Transform().setTranslation(-3.2,0.0,0.0)
              .addChild(new Billboard()
                .addChild(new Shape()
                  .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE"))
                  .setGeometry(new Text().setString(new String[] {"t a n g e n t"})
                    .setFontStyle(new FontStyle().setFamily(new String[] {"SANS"}).setHorizontal(false).setJustify(FontStyle.JUSTIFY_MIDDLE_END).setSize(0.5).setCssStyle("ITALIC"))))))
            .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-1.5,0.0,0.0)
              .addChild(new Shape()
                .setGeometry(new Cylinder().setHeight(3).setRadius(.015))
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(.2,.2,.2).setTransparency(.5)))))
            .addChild(new Transform().setTranslation(-2.7,0.15,0.0)
              .addChild(new Shape()
                .setGeometry(new Cylinder().setHeight(.3).setRadius(.02))
                .setAppearance(new Appearance().setUSE("DARK_GRAY"))))
            .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-2.85,0.3,0.0)
              .addChild(new Shape()
                .setGeometry(new Cylinder().setHeight(.3).setRadius(.02))
                .setAppearance(new Appearance().setUSE("DARK_GRAY")))))
          .addComments(" Draw SCP (spine-aligned cross-section plane) and label ")
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setGeometry(new IndexedFaceSet().setSolid(false).setCoordIndex(new int[] {0,1,2,3,4,-1})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {1.35,0.0,1.35,1.35,0.0,-1.35,-1.35,0.0,-1.35,-1.35,0.0,1.35,1.35,0.0,1.35}))))
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.27,0.51,0.71).setTransparency(.5)))))
            .addChild(new Transform().setRotation(1.0,0.0,0.0,-1.57).setTranslation(.5,0.0,-1.0)
              .addChild(new Shape()
                .setGeometry(new Text().setString(new String[] {"SCP"})
                  .setFontStyle(new FontStyle().setFamily(new String[] {"SANS"}).setSize(0.4).setCssStyle("BOLDITALIC")))
                .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE")))))))
      .addComments(" Draw title of model ")
      .addChild(new Group()
        .addChild(new Transform().setTranslation(-0.2,-5.5,0.0)
          .addChild(new Shape()
            .setGeometry(new Text().setString(new String[] {"Spine-aligned Cross-section Plane (SCP) at Spine Point"})
              .setFontStyle(new FontStyle("LABEL_FONT3").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.45).setCssStyle("BOLD")))
            .setAppearance(new Appearance().setUSE("LABEL_APPEARANCE")))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return ExtrusionFigureX3dSpecification model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new ExtrusionFigureX3dSpecification().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.X3dSpecifications.ExtrusionFigureX3dSpecification\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.X3dSpecifications.ExtrusionFigureX3dSpecification self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // X3dSpecifications/ExtrusionFigureX3dSpecification_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "X3dSpecifications/ExtrusionFigureX3dSpecification_JavaExport.x3d"; 
                String filenameX3DV = "X3dSpecifications/ExtrusionFigureX3dSpecification_JavaExport.x3dv"; 
                String filenameJSON = "X3dSpecifications/ExtrusionFigureX3dSpecification_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
