####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python ChopperBody.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='ChopperBody.x3d',name='title'),
    meta(content='X3D encodings example: main body for Chopper example, used as an Inline to show scene composition.',name='description'),
    meta(content='Don Brutzman and Joe Williams',name='creator'),
    meta(content='1 June 2002',name='created'),
    meta(content='28 October 2019',name='modified'),
    meta(content='X3D encodings, ISO/IEC 19776-1.3, Part 1: XML encoding, Annex C.16 Chopper',name='specificationSection'),
    meta(content='https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/examples.html#Chopper',name='specificationUrl'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/ChopperBody.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='ChopperBody.x3d'),
    Transform(translation=(-0.1,-0.85,4.95952),
      children=[
      Transform(rotation=(0.8321951,-0.39732206,0.38676405,1.77988),scale=(1.0,0.999999,0.999998),scaleOrientation=(0.41401106,0.41635105,0.8094731,0.298078),translation=(-0.319032,-0.0473949,-4.51302),
        children=[
        Shape(
          geometry=Extrusion(crossSection=[(0.0,0.2),(0.6,0.2),(0.8,0.0),(0.8,-0.4),(0.6,-0.6),(0.2,-0.6),(0.0,-0.4),(-0.2,0.0),(0.0,0.2)],orientation=[(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0)],scale=[(0.0215112,0.0215112),(0.659496,0.659496),(0.872158,0.872158),(1.0,1.0),(1.0,1.0),(0.872158,0.872158),(0.659496,0.659496),(0.0480939,0.0480939)],solid=False,spine=[(0.0,-1.0,0.0),(-0.0032141,-0.953553,0.0),(-0.00285517,-0.876386,0.0),(-0.0032141,-0.74785,0.0),(-0.0032141,-0.445722,0.0),(-0.0032141,-0.323585,0.0),(-0.0032141,-0.252875,0.0),(0.0,-0.2,0.0)]),
          appearance=Appearance(
            material=Material(DEF='_0')))]),
      Transform(rotation=(0.8273403,-0.41326016,0.38042614,1.77274),scaleOrientation=(-0.17204592,0.27246588,0.94665855,0.228295),translation=(-0.877833,0.458808,-4.77874),
        children=[
        Shape(
          geometry=Extrusion(convex=False,crossSection=[(0.6,0.6),(0.6,0.4),(-0.8,0.4),(-1.0,0.0),(-1.2,0.0),(-1.0,0.6),(0.6,0.6)],orientation=[(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0)],scale=[(1.0,1.0),(1.0,1.0)],solid=False,spine=[(0.0,-1.0,0.0),(0.0,-0.8,0.0)]),
          appearance=Appearance(
            material=Material(USE='_0')))]),
      Transform(rotation=(0.0,-1.0,0.0,0.873008),scale=(0.0980455,0.370358,0.213029),translation=(0.120967,0.410068,-4.95952),
        children=[
        Shape(
          geometry=Extrusion(crossSection=[(1.0,0.0),(0.92388,0.382683),(0.707107,0.707106),(0.382684,0.923879),(1.26759E-6,1.0),(-0.382682,0.92388),(-0.707105,0.707108),(-0.923879,0.382685),(-1.0,2.53518E-6),(-0.923881,-0.382681),(-0.707109,-0.707105),(-0.382687,-0.923878),(-3.80277E-6,-1.0),(0.38268,-0.923881),(0.707104,-0.70711),(0.923878,-0.382688),(1.0,0.0)],orientation=[(0.0,0.0,1.0,0.0),(0.0,0.0,1.0,0.0)],scale=[(1.0,1.0),(0.4,0.181007)],solid=False,spine=[(0.0,-1.0,0.0),(0.0,1.0,0.0)]),
          appearance=Appearance(
            material=Material(USE='_0')))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for ChopperBody.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python ChopperBody.py load and self-test diagnostics complete.")
