/**
 *<p>
 *       This directory collects models and scenes for outreach by the 
 *       <a href="https://www.Web3D.org" target="_blank">Web3D Consortium</a>,
 *       a non-profit Standards Development Organization (SDO) that supports real-time graphics communication on the Web.
 *</p>
 *<p>
 *	The
 *	<a href="https://www.web3d.org" target="_blank">Web3D&nbsp;Consortium</a>
 *	is a nonprofit organization that develops and maintains the X3D, VRML, and H-Anim standards.
 *	These are 3D file formats and runtime specifications for the delivery and integration of
 *	interactive 3D data over networks.
 *</p>
 *<p>
 *	<a href="https://www.web3d.org/x3d/getting-started" target="_blank">Extensible 3D (X3D) Graphics (X3D)</a>
 *	is the open, royalty-free, ISO-standard data language and run-time architecture for 3D graphics. 
 *	It provides for real-time, interactive, animatable 3D objects displayed in a browser or 
 *	other network connected or stand-alone display.
 *	<!-- 
 *	You can easily create, display, and interact 
 *	with 3D graphical objects without writing computer programs.
 *	-->
 *	The simple examples in this directory support the creation of outreach and marketing models for the
 *	Web3D Consortium
 *	and
 *	X3D&nbsp;Graphics.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Web3dOutreach" target="_blank">X3D Basic: Web3D Outreach</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Web3dOutreach;

