package Basic.Web3dOutreach;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Extruded 3D text for Web3D Consortium logo, fits inside 8m x 2m x 0.5m box centered at origin. </p>
 <p> Related links: Catalog page <a href="../../../Web3dOutreach/Web3dLogoIndex.html" target="_blank">Web3dLogo</a>,  source <a href="../../../Web3dOutreach/Web3dLogo.java">Web3dLogo.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Web3dOutreach/Web3dLogo.x3d">Web3dLogo.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Extruded 3D text for Web3D Consortium logo, fits inside 8m x 2m x 0.5m box centered at origin </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Michael Zoellner, Anita Havele, Byounghyun Yoo, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 May 2008 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org" target="_blank">https://www.web3d.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../Web3dOutreach/x3d2-s.gif">x3d2-s.gif</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../Web3dOutreach/Web3dLogo.png">Web3dLogo.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../Web3dOutreach/web3d_logo-blue_234x64.jpg">web3d_logo-blue_234x64.jpg</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../Web3dOutreach/web3d_logo.jpg">web3d_logo.jpg</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../Web3dOutreach/images/Web3dLogo.Meshlab.png">images/Web3dLogo.Meshlab.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="https://www.web3d.org/styles/img/web3d_logo.jpg" target="_blank">https://www.web3d.org/styles/img/web3d_logo.jpg</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Web3dOutreach/Web3dLogo.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Web3dOutreach/Web3dLogo.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> InstantReality </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Web3dOutreach/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Michael Zoellner, Anita Havele, Byounghyun Yoo, Don Brutzman
 */

public class Web3dLogo
{
	/** Default constructor to create this object. */
	public Web3dLogo ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Web3dLogo.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Extruded 3D text for Web3D Consortium logo, fits inside 8m x 2m x 0.5m box centered at origin"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Michael Zoellner, Anita Havele, Byounghyun Yoo, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 May 2008"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("x3d2-s.gif"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("Web3dLogo.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("web3d_logo-blue_234x64.jpg"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("web3d_logo.jpg"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/Web3dLogo.Meshlab.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("https://www.web3d.org/styles/img/web3d_logo.jpg"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Web3dOutreach/Web3dLogo.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("InstantReality"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("Web3dLogo.x3d"))
    .addChild(new Viewpoint().setDescription("Web3D Logo"))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {1.0,1.0,0.996078})))
    .addChild(new Transform("Extrude_NURBS").setRotation(0.0,1.0,0.0,1.57).setScale(0.02,0.02,0.02).setTranslation(0.0,0.0,0.2)
      .addChild(new Transform("web3d_logo__Konvertiert_")
        .addChild(new Transform("web3d_logo__Konvertiert_1")
          .addChild(new Transform("Path_1").setTranslation(0.0,-6.950928,-146.9591)
            .addChild(new Shape()
              .setAppearance(new Appearance("MAT_Mat")
                .setMaterial(new Material().setDiffuseColor(0.337,0.392,0.556).setShininess(0.0)))
              .setGeometry(new IndexedFaceSet("FACESET_Path_1").setDEF("FACESET_Path_1").setCcw(false).setCreaseAngle(1.047198).setSolid(false).setCoordIndex(getFACESET_Path_1_8_23_coordIndex()).setTexCoordIndex(getFACESET_Path_1_8_23_texCoordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_23_point()))
                .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_9_24_point()))))
            .addChild(new Transform("Cap_13")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_13").setDEF("FACESET_Cap_13").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(new int[] {79,78,72,-1,79,72,71,-1,79,71,70,-1,79,70,6,-1,79,6,5,-1,79,5,4,-1,79,4,3,-1,79,3,2,-1,79,2,1,-1,79,1,0,-1,78,77,76,-1,78,76,75,-1,78,75,74,-1,78,74,73,-1,78,73,72,-1,70,69,7,-1,70,7,6,-1,69,68,8,-1,69,8,7,-1,68,67,9,-1,68,9,8,-1,67,66,10,-1,67,10,9,-1,66,65,11,-1,66,11,10,-1,65,64,12,-1,65,12,11,-1,64,63,12,-1,63,62,13,-1,63,13,12,-1,62,61,14,-1,62,14,13,-1,61,60,14,-1,60,59,14,-1,59,58,16,-1,59,16,15,-1,59,15,14,-1,58,57,17,-1,58,17,16,-1,57,56,17,-1,56,55,17,-1,55,54,19,-1,55,19,18,-1,55,18,17,-1,54,53,20,-1,54,20,19,-1,53,52,20,-1,52,51,20,-1,51,50,20,-1,50,21,20,-1,50,49,21,-1,49,48,21,-1,48,47,21,-1,47,22,21,-1,47,46,22,-1,46,23,22,-1,46,45,23,-1,45,24,23,-1,45,44,24,-1,44,43,24,-1,43,25,24,-1,43,42,25,-1,42,26,25,-1,42,41,26,-1,41,34,27,-1,41,27,26,-1,41,40,34,-1,40,39,35,-1,40,35,34,-1,39,38,35,-1,38,37,35,-1,37,36,35,-1,34,33,32,-1,34,32,31,-1,34,31,30,-1,34,30,29,-1,34,29,28,-1,34,28,27,-1})
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_28_point())))))
            .addChild(new Transform("Cap_2")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_2").setDEF("FACESET_Cap_2").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(new int[] {0,1,79,-1,1,2,79,-1,2,3,79,-1,3,4,79,-1,4,5,79,-1,5,6,79,-1,6,7,70,-1,6,70,79,-1,7,8,69,-1,7,69,70,-1,8,9,68,-1,8,68,69,-1,9,10,67,-1,9,67,68,-1,10,11,66,-1,10,66,67,-1,11,12,65,-1,11,65,66,-1,12,13,63,-1,12,63,64,-1,12,64,65,-1,13,14,62,-1,13,62,63,-1,14,15,59,-1,14,59,60,-1,14,60,61,-1,14,61,62,-1,15,16,59,-1,16,17,58,-1,16,58,59,-1,17,18,55,-1,17,55,56,-1,17,56,57,-1,17,57,58,-1,18,19,55,-1,19,20,54,-1,19,54,55,-1,20,21,50,-1,20,50,51,-1,20,51,52,-1,20,52,53,-1,20,53,54,-1,21,22,47,-1,21,47,48,-1,21,48,49,-1,21,49,50,-1,22,23,46,-1,22,46,47,-1,23,24,45,-1,23,45,46,-1,24,25,43,-1,24,43,44,-1,24,44,45,-1,25,26,42,-1,25,42,43,-1,26,27,41,-1,26,41,42,-1,27,28,34,-1,27,34,41,-1,28,29,34,-1,29,30,34,-1,30,31,34,-1,31,32,34,-1,32,33,34,-1,34,35,40,-1,34,40,41,-1,35,36,37,-1,35,37,38,-1,35,38,39,-1,35,39,40,-1,70,71,79,-1,71,72,79,-1,72,73,78,-1,72,78,79,-1,73,74,78,-1,74,75,78,-1,75,76,78,-1,76,77,78,-1})
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_33_point()))))))
          .addChild(new Transform("Path_2").setTranslation(0.0,-6.950439,-79.746956)
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("MAT_Mat"))
              .setGeometry(new IndexedFaceSet("FACESET_Path_2").setDEF("FACESET_Path_2").setCcw(false).setCreaseAngle(1.047198).setSolid(false).setCoordIndex(getFACESET_Path_2_8_39_coordIndex()).setTexCoordIndex(getFACESET_Path_2_8_39_texCoordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_39_point()))
                .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_9_40_point()))))
            .addChild(new Transform("Cap_11")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_11").setDEF("FACESET_Cap_11").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(getFACESET_Cap_11_9_44_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_44_point())))))
            .addChild(new Transform("Cap_24")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_24").setDEF("FACESET_Cap_24").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(getFACESET_Cap_24_9_49_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_49_point()))))))
          .addChild(new Transform("Path_5").setTranslation(0.0,3.83197,-26.05336)
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("MAT_Mat"))
              .setGeometry(new IndexedFaceSet("FACESET_Path_5").setDEF("FACESET_Path_5").setCcw(false).setCreaseAngle(1.047198).setSolid(false).setCoordIndex(getFACESET_Path_5_8_55_coordIndex()).setTexCoordIndex(getFACESET_Path_5_8_55_texCoordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_55_point()))
                .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_9_56_point()))))
            .addChild(new Transform("Cap_1")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_1").setDEF("FACESET_Cap_1").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(getFACESET_Cap_1_9_60_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_60_point())))))
            .addChild(new Transform("Cap_25")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_25").setDEF("FACESET_Cap_25").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(getFACESET_Cap_25_9_65_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_65_point()))))))
          .addChild(new Transform("Path_6").setTranslation(0.0,6.950958,69.08409)
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("MAT_Mat"))
              .setGeometry(new IndexedFaceSet("FACESET_Path_6").setDEF("FACESET_Path_6").setCcw(false).setCreaseAngle(1.047198).setSolid(false).setCoordIndex(getFACESET_Path_6_8_71_coordIndex()).setTexCoordIndex(getFACESET_Path_6_8_71_texCoordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_71_point()))
                .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_9_72_point()))))
            .addChild(new Transform("Cap_14")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_14").setDEF("FACESET_Cap_14").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(getFACESET_Cap_14_9_76_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_76_point())))))
            .addChild(new Transform("Cap_23")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_23").setDEF("FACESET_Cap_23").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(getFACESET_Cap_23_9_81_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_81_point()))))))
          .addChild(new Transform("Path_7").setTranslation(0.0,6.245331,146.95909)
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("MAT_Mat"))
              .setGeometry(new IndexedFaceSet("FACESET_Path_7").setDEF("FACESET_Path_7").setCcw(false).setCreaseAngle(1.047198).setSolid(false).setCoordIndex(getFACESET_Path_7_8_87_coordIndex()).setTexCoordIndex(getFACESET_Path_7_8_87_texCoordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_87_point()))
                .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_9_88_point()))))
            .addChild(new Transform("Cap_12")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_12").setDEF("FACESET_Cap_12").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(new int[] {34,33,37,-1,34,37,36,-1,34,36,35,-1,34,35,0,-1,33,32,39,-1,33,39,38,-1,33,38,37,-1,32,31,40,-1,32,40,39,-1,31,30,42,-1,31,42,41,-1,31,41,40,-1,30,29,43,-1,30,43,42,-1,29,28,44,-1,29,44,43,-1,28,27,45,-1,28,45,44,-1,27,26,46,-1,27,46,45,-1,26,25,47,-1,26,47,46,-1,25,24,48,-1,25,48,47,-1,24,23,48,-1,23,22,49,-1,23,49,48,-1,22,21,50,-1,22,50,49,-1,21,20,50,-1,20,19,51,-1,20,51,50,-1,19,18,52,-1,19,52,51,-1,18,17,52,-1,17,16,53,-1,17,53,52,-1,16,15,53,-1,15,14,54,-1,15,54,53,-1,14,13,54,-1,13,12,55,-1,13,55,54,-1,12,11,55,-1,11,10,56,-1,11,56,55,-1,10,9,57,-1,10,57,56,-1,9,8,58,-1,9,58,57,-1,8,7,59,-1,8,59,58,-1,7,6,60,-1,7,60,59,-1,6,5,61,-1,6,61,60,-1,5,4,62,-1,5,62,61,-1,4,3,64,-1,4,64,63,-1,4,63,62,-1,3,2,66,-1,3,66,65,-1,3,65,64,-1,2,67,66,-1,2,1,68,-1,2,68,67,-1,1,0,68,-1,0,35,68,-1})
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_92_point())))))
            .addChild(new Transform("Cap_21")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_21").setDEF("FACESET_Cap_21").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(new int[] {0,1,68,-1,0,68,35,-1,0,35,34,-1,1,2,68,-1,2,3,66,-1,2,66,67,-1,2,67,68,-1,3,4,64,-1,3,64,65,-1,3,65,66,-1,4,5,62,-1,4,62,63,-1,4,63,64,-1,5,6,61,-1,5,61,62,-1,6,7,60,-1,6,60,61,-1,7,8,59,-1,7,59,60,-1,8,9,58,-1,8,58,59,-1,9,10,57,-1,9,57,58,-1,10,11,56,-1,10,56,57,-1,11,12,55,-1,11,55,56,-1,12,13,55,-1,13,14,54,-1,13,54,55,-1,14,15,54,-1,15,16,53,-1,15,53,54,-1,16,17,53,-1,17,18,52,-1,17,52,53,-1,18,19,52,-1,19,20,51,-1,19,51,52,-1,20,21,50,-1,20,50,51,-1,21,22,50,-1,22,23,49,-1,22,49,50,-1,23,24,48,-1,23,48,49,-1,24,25,48,-1,25,26,47,-1,25,47,48,-1,26,27,46,-1,26,46,47,-1,27,28,45,-1,27,45,46,-1,28,29,44,-1,28,44,45,-1,29,30,43,-1,29,43,44,-1,30,31,42,-1,30,42,43,-1,31,32,40,-1,31,40,41,-1,31,41,42,-1,32,33,39,-1,32,39,40,-1,33,34,37,-1,33,37,38,-1,33,38,39,-1,34,36,37,-1,34,35,36,-1})
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_97_point()))))))
          .addChild(new Transform("Path_10").setTranslation(-0.123751,3.67804,21.920288)
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("MAT_Mat"))
              .setGeometry(new IndexedFaceSet("FACESET_Path_10").setDEF("FACESET_Path_10").setCcw(false).setCreaseAngle(1.047198).setSolid(false).setCoordIndex(new int[] {0,1,5,4,-1,1,2,6,5,-1,2,3,7,6,-1,3,0,4,7,-1}).setTexCoordIndex(new int[] {1,2,7,6,-1,2,3,8,7,-1,3,4,9,8,-1,4,0,5,9,-1})
                .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,-40.12863,1.695801,0.0,40.128662,1.695801,0.0,40.128662,-1.695801,0.0,-40.12863,-1.695801,20.0,-40.12863,1.695801,20.0,40.128662,1.695801,20.0,40.128662,-1.695801,20.0,-40.12863,-1.695801})))
                .setTexCoord(new TextureCoordinate().setPoint(new MFVec2f(new double[] {1.0,1.0,0.0,1.0,0.479727,1.0,0.5,1.0,0.979727,1.0,1.0,0.0,0.0,0.0,0.479727,0.0,0.5,0.0,0.979727,0.0})))))
            .addChild(new Transform("Cap_15")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_15").setDEF("FACESET_Cap_15").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(new int[] {3,2,0,-1,2,1,0,-1})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,-40.12863,1.695801,0.0,40.128662,1.695801,0.0,40.128662,-1.695801,0.0,-40.12863,-1.695801}))))))
            .addChild(new Transform("Cap_22")
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("MAT_Mat"))
                .setGeometry(new IndexedFaceSet("FACESET_Cap_22").setDEF("FACESET_Cap_22").setCcw(false).setCreaseAngle(1.56207).setSolid(false).setCoordIndex(new int[] {0,1,3,-1,1,2,3,-1})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {20.0,-40.12863,1.695801,20.0,40.128662,1.695801,20.0,40.128662,-1.695801,20.0,-40.12863,-1.695801})))))))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_1_8_23_coordIndex_1()
		{
			int[] value = {0,1,81,80,-1,1,2,82,81,-1,2,3,83,82,-1,3,4,84,83,-1,4,5,85,84,-1,5,6,86,85,-1,6,7,87,86,-1,7,8,88,87,-1,8,9,89,88,-1,9,10,90,89,-1,10,11,91,90,-1,11,12,92,91,-1,12,13,93,92,-1,13,14,94,93,-1,14,15,95,94,-1,15,16,96,95,-1,16,17,97,96,-1,17,18,98,97,-1,18,19,99,98,-1,19,20,100,99,-1,20,21,101,100,-1,21,22,102,101,-1,22,23,103,102,-1,23,24,104,103,-1,24,25,105,104,-1,25,26,106,105,-1,26,27,107,106,-1,27,28,108,107,-1,28,29,109,108,-1,29,30,110,109,-1,30,31,111,110,-1,31,32,112,111,-1,32,33,113,112,-1,33,34,114,113,-1,34,35,115,114,-1,35,36,116,115,-1,36,37,117,116,-1,37,38,118,117,-1,38,39,119,118,-1,39,40,120,119,-1,40,41,121,120,-1,41,42,122,121,-1,42,43,123,122,-1,43,44,124,123,-1,44,45,125,124,-1,45,46,126,125,-1,46,47,127,126,-1,47,48,128,127,-1,48,49,129,128,-1,49,50,130,129,-1,50,51,131,130,-1,51,52,132,131,-1,52,53,133,132,-1,53,54,134,133,-1,54,55,135,134,-1,55,56,136,135,-1,56,57,137,136,-1,57,58,138,137,-1,58,59,139,138,-1,59,60,140,139,-1,60,61,141,140,-1,61,62,142,141,-1,62,63,143,142,-1,63,64,144,143,-1,64,65,145,144,-1,65,66,146,145,-1,66,67,147,146,-1,67,68,148,147,-1,68,69,149,148,-1,69,70,150,149,-1,70,71,151,150,-1,71,72,152,151,-1,72,73,153,152,-1,73,74,154,153,-1,74,75,155,154,-1,75,76,156,155,-1,76,77,157,156,-1,77,78,158,157,-1,78,79,159,158,-1,79,0,80,159,-1};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_1_8_23_texCoordIndex_1()
		{
			int[] value = {1,2,83,82,-1,2,3,84,83,-1,3,4,85,84,-1,4,5,86,85,-1,5,6,87,86,-1,6,7,88,87,-1,7,8,89,88,-1,8,9,90,89,-1,9,10,91,90,-1,10,11,92,91,-1,11,12,93,92,-1,12,13,94,93,-1,13,14,95,94,-1,14,15,96,95,-1,15,16,97,96,-1,16,17,98,97,-1,17,18,99,98,-1,18,19,100,99,-1,19,20,101,100,-1,20,21,102,101,-1,21,22,103,102,-1,22,23,104,103,-1,23,24,105,104,-1,24,25,106,105,-1,25,26,107,106,-1,26,27,108,107,-1,27,28,109,108,-1,28,29,110,109,-1,29,30,111,110,-1,30,31,112,111,-1,31,32,113,112,-1,32,33,114,113,-1,33,34,115,114,-1,34,35,116,115,-1,35,36,117,116,-1,36,37,118,117,-1,37,38,119,118,-1,38,39,120,119,-1,39,40,121,120,-1,40,41,122,121,-1,41,42,123,122,-1,42,43,124,123,-1,43,44,125,124,-1,44,45,126,125,-1,45,46,127,126,-1,46,47,128,127,-1,47,48,129,128,-1,48,49,130,129,-1,49,50,131,130,-1,50,51,132,131,-1,51,52,133,132,-1,52,53,134,133,-1,53,54,135,134,-1,54,55,136,135,-1,55,56,137,136,-1,56,57,138,137,-1,57,58,139,138,-1,58,59,140,139,-1,59,60,141,140,-1,60,61,142,141,-1,61,62,143,142,-1,62,63,144,143,-1,63,64,145,144,-1,64,65,146,145,-1,65,66,147,146,-1,66,67,148,147,-1,67,68,149,148,-1,68,69,150,149,-1,69,70,151,150,-1,70,71,152,151,-1,71,72,153,152,-1,72,73,154,153,-1,73,74,155,154,-1,74,75,156,155,-1,75,76,157,156,-1,76,77,158,157,-1,77,78,159,158,-1,78,79,160,159,-1,79,80,161,160,-1,80,0,81,161,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_9_23_point_1()
		{
			double[] value = {0.0,21.178467,-41.147198,0.0,21.12664,-40.164177,0.0,21.020084,-39.475796,0.0,20.855932,-38.8275,0.0,20.634548,-38.217655,0.0,20.356314,-37.644634,0.0,20.021597,-37.106808,0.0,19.630774,-36.60254,0.0,19.184216,-36.130196,0.0,18.682297,-35.688152,0.0,17.9276,-35.143063,0.0,17.076033,-34.64507,0.0,15.876696,-34.082905,0.0,14.810403,-33.676727,0.0,13.345459,-33.217094,0.0,-24.175537,-20.935318,0.0,-24.175537,-13.780046,0.0,10.34787,-0.240997,0.0,-24.175537,12.330303,0.0,-24.175537,19.487003,0.0,13.249268,32.6379,0.0,16.314926,33.869556,0.0,17.629301,34.55615,0.0,18.500906,35.12066,0.0,19.225481,35.707726,0.0,19.679565,36.167828,0.0,20.06264,36.648804,0.0,20.379713,37.154156,0.0,20.635798,37.687397,0.0,20.835905,38.252037,0.0,20.98505,38.85158,0.0,21.11329,39.711334,0.0,21.163008,40.405968,0.0,21.178467,41.1472,0.0,24.175568,41.1472,0.0,24.175568,20.550003,0.0,21.178467,20.550003,0.0,21.091251,22.840458,0.0,20.900711,24.112778,0.0,20.709892,24.841082,0.0,20.448227,25.52607,0.0,20.228977,25.951796,0.0,19.97007,26.347965,0.0,19.668236,26.710457,0.0,19.32021,27.035152,0.0,18.92272,27.317924,0.0,18.472504,27.554657,0.0,17.966291,27.741224,0.0,17.400814,27.873508,0.0,16.772804,27.947386,0.0,16.078995,27.958735,0.0,14.907757,27.8495,0.0,13.570088,27.576397,0.0,11.508575,26.933304,0.0,-10.249725,19.583202,0.0,-10.249725,19.389904,0.0,24.175568,7.109604,0.0,24.175568,-0.144797,0.0,-9.670135,-13.296157,0.0,-9.670135,-13.489027,0.0,12.668671,-20.355728,0.0,14.88086,-20.985714,0.0,16.346033,-21.235563,0.0,17.282059,-21.28134,0.0,17.833817,-21.246788,0.0,18.331062,-21.161657,0.0,18.776617,-21.027212,0.0,19.173302,-20.844713,0.0,19.523941,-20.615425,0.0,19.831354,-20.34061,0.0,20.098366,-20.021534,0.0,20.327799,-19.659458,0.0,20.522474,-19.255644,0.0,20.685213,-18.81136,0.0,20.875618,-18.071808,0.0,21.04406,-16.955877,0.0,21.149061,-15.366466,0.0,21.178467,-13.199966,0.0,24.175568,-13.199966,0.0,24.175568,-41.147198,20.0,21.178467,-41.147198,20.0,21.12664,-40.164177,20.0,21.020084,-39.475796,20.0,20.855932,-38.8275,20.0,20.634548,-38.217655,20.0,20.356314,-37.644634,20.0,20.021597,-37.106808,20.0,19.630774,-36.60254,20.0,19.184216,-36.130196,20.0,18.682297,-35.688152,20.0,17.9276,-35.143063,20.0,17.076033,-34.64507,20.0,15.876696,-34.082905,20.0,14.810403,-33.676727,20.0,13.345459,-33.217094,20.0,-24.175537,-20.935318,20.0,-24.175537,-13.780046,20.0,10.34787,-0.240997,20.0,-24.175537,12.330303,20.0,-24.175537,19.487003};
			return value;
		}
		private double[] getCoordinate_9_23_point_2()
		{
			double[] value = {20.0,13.249268,32.6379,20.0,16.314926,33.869556,20.0,17.629301,34.55615,20.0,18.500906,35.12066,20.0,19.225481,35.707726,20.0,19.679565,36.167828,20.0,20.06264,36.648804,20.0,20.379713,37.154156,20.0,20.635798,37.687397,20.0,20.835905,38.252037,20.0,20.98505,38.85158,20.0,21.11329,39.711334,20.0,21.163008,40.405968,20.0,21.178467,41.1472,20.0,24.175568,41.1472,20.0,24.175568,20.550003,20.0,21.178467,20.550003,20.0,21.091251,22.840458,20.0,20.900711,24.112778,20.0,20.709892,24.841082,20.0,20.448227,25.52607,20.0,20.228977,25.951796,20.0,19.97007,26.347965,20.0,19.668236,26.710457,20.0,19.32021,27.035152,20.0,18.92272,27.317924,20.0,18.472504,27.554657,20.0,17.966291,27.741224,20.0,17.400814,27.873508,20.0,16.772804,27.947386,20.0,16.078995,27.958735,20.0,14.907757,27.8495,20.0,13.570088,27.576397,20.0,11.508575,26.933304,20.0,-10.249725,19.583202,20.0,-10.249725,19.389904,20.0,24.175568,7.109604,20.0,24.175568,-0.144797,20.0,-9.670135,-13.296157,20.0,-9.670135,-13.489027,20.0,12.668671,-20.355728,20.0,14.88086,-20.985714,20.0,16.346033,-21.235563,20.0,17.282059,-21.28134,20.0,17.833817,-21.246788,20.0,18.331062,-21.161657,20.0,18.776617,-21.027212,20.0,19.173302,-20.844713,20.0,19.523941,-20.615425,20.0,19.831354,-20.34061,20.0,20.098366,-20.021534,20.0,20.327799,-19.659458,20.0,20.522474,-19.255644,20.0,20.685213,-18.81136,20.0,20.875618,-18.071808,20.0,21.04406,-16.955877,20.0,21.149061,-15.366466,20.0,21.178467,-13.199966,20.0,24.175568,-13.199966,20.0,24.175568,-41.147198};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_9_24_point_1()
		{
			double[] value = {1.0,1.0,0.0,1.0,0.002403,1.0,0.004104,1.0,0.005737,1.0,0.007321,1.0,0.008876,1.0,0.010423,1.0,0.011981,1.0,0.013568,1.0,0.015201,1.0,0.017474,1.0,0.019882,1.0,0.023116,1.0,0.025902,1.0,0.029651,1.0,0.126044,1.0,0.143514,1.0,0.234056,1.0,0.323762,1.0,0.341236,1.0,0.438088,1.0,0.446155,1.0,0.449776,1.0,0.452311,1.0,0.454588,1.0,0.456166,1.0,0.457668,1.0,0.459124,1.0,0.460568,1.0,0.462031,1.0,0.46354,1.0,0.465662,1.0,0.467362,1.0,0.469172,1.0,0.47649,1.0,0.52678,1.0,0.534097,1.0,0.539694,1.0,0.542835,1.0,0.544673,1.0,0.546463,1.0,0.547633,1.0,0.548788,1.0,0.54994,1.0,0.551102,1.0,0.552293,1.0,0.553535,1.0,0.554852,1.0,0.55627,1.0,0.557814,1.0,0.559508,1.0,0.56238,1.0,0.565714,1.0,0.570986,1.0,0.62706,1.0,0.627532,1.0,0.716772,1.0,0.734484,1.0,0.82314,1.0,0.823611,1.0,0.880671,1.0,0.886287,1.0,0.889916,1.0,0.892204,1.0,0.893554,1.0,0.894786,1.0,0.895922,1.0,0.896988,1.0,0.898011,1.0,0.899018,1.0,0.900034,1.0,0.90108,1.0,0.902175,1.0,0.90333,1.0,0.905195,1.0,0.90795,1.0,0.911839,1.0,0.917129,1.0,0.924447,1.0,0.992682,1.0,1.0,0.0,0.0,0.0,0.002403,0.0,0.004104,0.0,0.005737,0.0,0.007321,0.0,0.008876,0.0,0.010423,0.0,0.011981,0.0,0.013568,0.0,0.015201,0.0,0.017474,0.0,0.019882,0.0,0.023116,0.0,0.025902,0.0,0.029651,0.0,0.126044,0.0,0.143514,0.0,0.234056,0.0};
			return value;
		}
		private double[] getTextureCoordinate_9_24_point_2()
		{
			double[] value = {0.323762,0.0,0.341236,0.0,0.438088,0.0,0.446155,0.0,0.449776,0.0,0.452311,0.0,0.454588,0.0,0.456166,0.0,0.457668,0.0,0.459124,0.0,0.460568,0.0,0.462031,0.0,0.46354,0.0,0.465662,0.0,0.467362,0.0,0.469172,0.0,0.47649,0.0,0.52678,0.0,0.534097,0.0,0.539694,0.0,0.542835,0.0,0.544673,0.0,0.546463,0.0,0.547633,0.0,0.548788,0.0,0.54994,0.0,0.551102,0.0,0.552293,0.0,0.553535,0.0,0.554852,0.0,0.55627,0.0,0.557814,0.0,0.559508,0.0,0.56238,0.0,0.565714,0.0,0.570986,0.0,0.62706,0.0,0.627532,0.0,0.716772,0.0,0.734484,0.0,0.82314,0.0,0.823611,0.0,0.880671,0.0,0.886287,0.0,0.889916,0.0,0.892204,0.0,0.893554,0.0,0.894786,0.0,0.895922,0.0,0.896988,0.0,0.898011,0.0,0.899018,0.0,0.900034,0.0,0.90108,0.0,0.902175,0.0,0.90333,0.0,0.905195,0.0,0.90795,0.0,0.911839,0.0,0.917129,0.0,0.924447,0.0,0.992682,0.0};
			return value;
		}




		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_2_8_39_coordIndex_1()
		{
			int[] value = {0,1,125,124,-1,1,2,126,125,-1,2,3,127,126,-1,3,4,128,127,-1,4,5,129,128,-1,5,6,130,129,-1,6,7,131,130,-1,7,8,132,131,-1,8,9,133,132,-1,9,10,134,133,-1,10,11,135,134,-1,11,12,136,135,-1,12,13,137,136,-1,13,14,138,137,-1,14,15,139,138,-1,15,16,140,139,-1,16,17,141,140,-1,17,18,142,141,-1,18,19,143,142,-1,19,20,144,143,-1,20,21,145,144,-1,21,22,146,145,-1,22,23,147,146,-1,23,24,148,147,-1,24,25,149,148,-1,25,26,150,149,-1,26,27,151,150,-1,27,28,152,151,-1,28,29,153,152,-1,29,30,154,153,-1,30,31,155,154,-1,31,32,156,155,-1,32,33,157,156,-1,33,34,158,157,-1,34,35,159,158,-1,35,36,160,159,-1,36,37,161,160,-1,37,38,162,161,-1,38,39,163,162,-1,39,40,164,163,-1,40,41,165,164,-1,41,42,166,165,-1,42,43,167,166,-1,43,44,168,167,-1,44,45,169,168,-1,45,46,170,169,-1,46,47,171,170,-1,47,48,172,171,-1,48,49,173,172,-1,49,50,174,173,-1,50,51,175,174,-1,51,52,176,175,-1,52,53,177,176,-1,53,54,178,177,-1,54,55,179,178,-1,55,56,180,179,-1,56,57,181,180,-1,57,58,182,181,-1,58,59,183,182,-1,59,60,184,183,-1,60,61,185,184,-1,61,62,186,185,-1,62,63,187,186,-1,63,64,188,187,-1,64,65,189,188,-1,65,66,190,189,-1,66,67,191,190,-1,67,68,192,191,-1,68,69,193,192,-1,69,70,194,193,-1,70,71,195,194,-1,71,72,196,195,-1,72,73,197,196,-1,73,74,198,197,-1,74,75,199,198,-1,75,76,200,199,-1,76,0,124,200,-1,77,78,202,201,-1,78,79,203,202,-1,79,80,204,203,-1,80,81,205,204,-1,81,82,206,205,-1,82,83,207,206,-1,83,84,208,207,-1,84,85,209,208,-1,85,86,210,209,-1,86,87,211,210,-1,87,88,212,211,-1,88,89,213,212,-1,89,90,214,213,-1,90,91,215,214,-1,91,92,216,215,-1,92,93,217,216,-1,93,94,218,217,-1,94,95,219,218,-1,95,96,220,219,-1,96,97,221,220,-1,97,98,222,221,-1,98,99,223,222,-1,99,100,224,223,-1,100,101,225,224,-1,101,102,226,225,-1,102,103,227,226,-1,103,104,228,227,-1,104,105,229,228,-1,105,106,230,229,-1,106,107,231,230,-1,107,108,232,231,-1,108,109,233,232,-1,109,110,234,233,-1,110,111,235,234,-1,111,112,236,235,-1,112,113,237,236,-1,113,114,238,237,-1,114,115,239,238,-1,115,116,240,239,-1,116,117,241,240,-1,117,118,242,241,-1,118,119,243,242,-1,119,120,244,243,-1,120,121,245,244,-1,121,122,246,245,-1,122,123,247,246,-1,123,77,201,247,-1};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_2_8_39_texCoordIndex_1()
		{
			int[] value = {1,2,128,127,-1,2,3,129,128,-1,3,4,130,129,-1,4,5,131,130,-1,5,6,132,131,-1,6,7,133,132,-1,7,8,134,133,-1,8,9,135,134,-1,9,10,136,135,-1,10,11,137,136,-1,11,12,138,137,-1,12,13,139,138,-1,13,14,140,139,-1,14,15,141,140,-1,15,16,142,141,-1,16,17,143,142,-1,17,18,144,143,-1,18,19,145,144,-1,19,20,146,145,-1,20,21,147,146,-1,21,22,148,147,-1,22,23,149,148,-1,23,24,150,149,-1,24,25,151,150,-1,25,26,152,151,-1,26,27,153,152,-1,27,28,154,153,-1,28,29,155,154,-1,29,30,156,155,-1,30,31,157,156,-1,31,32,158,157,-1,32,33,159,158,-1,33,34,160,159,-1,34,35,161,160,-1,35,36,162,161,-1,36,37,163,162,-1,37,38,164,163,-1,38,39,165,164,-1,39,40,166,165,-1,40,41,167,166,-1,41,42,168,167,-1,42,43,169,168,-1,43,44,170,169,-1,44,45,171,170,-1,45,46,172,171,-1,46,47,173,172,-1,47,48,174,173,-1,48,49,175,174,-1,49,50,176,175,-1,50,51,177,176,-1,51,52,178,177,-1,52,53,179,178,-1,53,54,180,179,-1,54,55,181,180,-1,55,56,182,181,-1,56,57,183,182,-1,57,58,184,183,-1,58,59,185,184,-1,59,60,186,185,-1,60,61,187,186,-1,61,62,188,187,-1,62,63,189,188,-1,63,64,190,189,-1,64,65,191,190,-1,65,66,192,191,-1,66,67,193,192,-1,67,68,194,193,-1,68,69,195,194,-1,69,70,196,195,-1,70,71,197,196,-1,71,72,198,197,-1,72,73,199,198,-1,73,74,200,199,-1,74,75,201,200,-1,75,76,202,201,-1,76,77,203,202,-1,77,0,126,203,-1,79,80,206,205,-1,80,81,207,206,-1,81,82,208,207,-1,82,83,209,208,-1,83,84,210,209,-1,84,85,211,210,-1,85,86,212,211,-1,86,87,213,212,-1,87,88,214,213,-1,88,89,215,214,-1,89,90,216,215,-1,90,91,217,216,-1,91,92,218,217,-1,92,93,219,218,-1,93,94,220,219,-1,94,95,221,220,-1,95,96,222,221,-1,96,97,223,222,-1,97,98,224,223,-1,98,99,225,224,-1,99,100,226,225,-1,100,101,227,226,-1,101,102,228,227,-1,102,103,229,228,-1,103,104,230,229,-1,104,105,231,230,-1,105,106,232,231,-1,106,107,233,232,-1,107,108,234,233,-1,108,109,235,234,-1,109,110,236,235,-1,110,111,237,236,-1,111,112,238,237,-1,112,113,239,238,-1,113,114,240,239,-1,114,115,241,240,-1,115,116,242,241,-1,116,117,243,242,-1,117,118,244,243,-1,118,119,245,244,-1,119,120,246,245,-1,120,121,247,246,-1,121,122,248,247,-1,122,123,249,248,-1,123,124,250,249,-1,124,125,251,250,-1,125,78,204,251,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_9_39_point_1()
		{
			double[] value = {0.0,2.514374,21.70945,0.0,5.221893,21.70945,0.0,8.00381,21.587126,0.0,10.630615,21.220943,0.0,13.088353,20.612085,0.0,14.81231,19.996897,0.0,16.427427,19.246368,0.0,17.927816,18.360998,0.0,19.30759,17.341288,0.0,20.560858,16.18773,0.0,21.681736,14.90083,0.0,22.664331,13.481085,0.0,23.50276,11.928993,0.0,24.19113,10.245054,0.0,24.723557,8.429769,0.0,25.094149,6.483633,0.0,25.248396,5.113761,0.0,25.336182,2.950653,0.0,25.195318,-0.19669,0.0,24.785757,-3.098037,0.0,24.127052,-5.760158,0.0,23.238752,-8.189819,0.0,22.140406,-10.393793,0.0,20.851564,-12.378847,0.0,19.391779,-14.15175,0.0,17.780598,-15.719272,0.0,16.03757,-17.08818,0.0,14.182248,-18.265247,0.0,12.234181,-19.25724,0.0,9.526278,-20.303703,0.0,6.734592,-21.049227,0.0,3.905462,-21.509853,0.0,2.491338,-21.638346,0.0,0.386993,-21.709446,0.0,-2.065929,-21.589645,0.0,-4.94797,-21.158255,0.0,-7.718472,-20.461369,0.0,-10.746912,-19.380985,0.0,-13.484629,-18.090006,0.0,-15.543152,-16.877378,0.0,-17.28603,-15.620799,0.0,-18.024382,-14.992005,0.0,-18.857605,-14.16745,0.0,-20.89521,-11.787745,0.0,-22.464643,-9.520025,0.0,-23.423256,-7.783749,0.0,-24.151073,-6.114463,0.0,-24.67869,-4.510091,0.0,-25.103281,-2.59274,0.0,-25.322615,-0.769503,0.0,-25.390894,2.288117,0.0,-25.336212,5.077652,0.0,-25.336212,8.462852,0.0,-17.986603,21.70945,0.0,-14.505615,19.680153,0.0,-16.812584,15.684487,0.0,-17.524714,14.034758,0.0,-18.040024,12.456334,0.0,-18.424137,10.716675,0.0,-18.587006,9.462876,0.0,-18.664307,7.785156,0.0,-18.594322,6.159091,0.0,-18.390383,4.643435,0.0,-18.061516,3.234443,0.0,-17.616745,1.928363,0.0,-17.065094,0.721449,0.0,-16.415588,-0.39005,0.0,-15.677254,-1.409882,0.0,-14.859114,-2.341795,0.0,-13.502011,-3.583017,0.0,-12.016113,-4.647509,0.0,-10.431877,-5.547923,0.0,-8.219237,-6.515108,0.0,-5.958122,-7.24308,0.0,-3.173549,-7.862337,0.0,-0.079536,-8.256391,0.0,2.514374,-8.36525,0.0,6.092987,-8.36525,0.0,9.380302,-8.219,0.0,12.235374,-7.798831,0.0,14.221862,-7.284199,0.0,15.955106,-6.626362,0.0,17.095102,-6.047588,0.0,18.102882,-5.402307,0.0,18.982834,-4.696537,0.0,19.739342,-3.936299,0.0,20.376793,-3.12761,0.0,20.899572,-2.276492,0.0,21.312067,-1.388962,0.0,21.618662,-0.471041,0.0,21.823744,0.471252,0.0,21.906235,1.110015,0.0,21.951874,2.079552,0.0,21.903452,2.904008,0.0,21.760862,3.704063,0.0,21.528116,4.476208,0.0,21.209227,5.216934,0.0,20.808203,5.922733,0.0,20.32906,6.590097,0.0,19.775808,7.215518};
			return value;
		}
		private double[] getCoordinate_9_39_point_2()
		{
			double[] value = {0.0,19.15246,7.795487,0.0,18.463028,8.326496,0.0,17.711523,8.805037,0.0,16.619892,9.355412,0.0,15.434553,9.797957,0.0,14.165014,10.124356,0.0,12.820785,10.326294,0.0,11.411377,10.395454,0.0,10.48947,10.354156,0.0,9.670573,10.235798,0.0,8.949923,10.04869,0.0,8.471042,9.868238,0.0,8.042736,9.657294,0.0,7.662995,9.419361,0.0,7.329809,9.157944,0.0,7.041167,8.876548,0.0,6.79506,8.578678,0.0,6.589479,8.267839,0.0,6.422414,7.947537,0.0,6.291854,7.621276,0.0,6.195791,7.292562,0.0,6.132215,6.964898,0.0,6.106886,6.748771,0.0,6.092987,6.430649,20.0,2.514374,21.70945,20.0,5.221893,21.70945,20.0,8.00381,21.587126,20.0,10.630615,21.220943,20.0,13.088353,20.612085,20.0,14.81231,19.996897,20.0,16.427427,19.246368,20.0,17.927816,18.360998,20.0,19.30759,17.341288,20.0,20.560858,16.18773,20.0,21.681736,14.90083,20.0,22.664331,13.481085,20.0,23.50276,11.928993,20.0,24.19113,10.245054,20.0,24.723557,8.429769,20.0,25.094149,6.483633,20.0,25.248396,5.113761,20.0,25.336182,2.950653,20.0,25.195318,-0.19669,20.0,24.785757,-3.098037,20.0,24.127052,-5.760158,20.0,23.238752,-8.189819,20.0,22.140406,-10.393793,20.0,20.851564,-12.378847,20.0,19.391779,-14.15175,20.0,17.780598,-15.719272,20.0,16.03757,-17.08818,20.0,14.182248,-18.265247,20.0,12.234181,-19.25724,20.0,9.526278,-20.303703,20.0,6.734592,-21.049227,20.0,3.905462,-21.509853,20.0,2.491338,-21.638346,20.0,0.386993,-21.709446,20.0,-2.065929,-21.589645,20.0,-4.94797,-21.158255,20.0,-7.718472,-20.461369,20.0,-10.746912,-19.380985,20.0,-13.484629,-18.090006,20.0,-15.543152,-16.877378,20.0,-17.28603,-15.620799,20.0,-18.024382,-14.992005,20.0,-18.857605,-14.16745,20.0,-20.89521,-11.787745,20.0,-22.464643,-9.520025,20.0,-23.423256,-7.783749,20.0,-24.151073,-6.114463,20.0,-24.67869,-4.510091,20.0,-25.103281,-2.59274,20.0,-25.322615,-0.769503,20.0,-25.390894,2.288117,20.0,-25.336212,5.077652,20.0,-25.336212,8.462852,20.0,-17.986603,21.70945,20.0,-14.505615,19.680153,20.0,-16.812584,15.684487,20.0,-17.524714,14.034758,20.0,-18.040024,12.456334,20.0,-18.424137,10.716675,20.0,-18.587006,9.462876,20.0,-18.664307,7.785156,20.0,-18.594322,6.159091,20.0,-18.390383,4.643435,20.0,-18.061516,3.234443,20.0,-17.616745,1.928363,20.0,-17.065094,0.721449,20.0,-16.415588,-0.39005,20.0,-15.677254,-1.409882,20.0,-14.859114,-2.341795,20.0,-13.502011,-3.583017,20.0,-12.016113,-4.647509,20.0,-10.431877,-5.547923,20.0,-8.219237,-6.515108,20.0,-5.958122,-7.24308,20.0,-3.173549,-7.862337,20.0,-0.079536,-8.256391};
			return value;
		}
		private double[] getCoordinate_9_39_point_3()
		{
			double[] value = {20.0,2.514374,-8.36525,20.0,6.092987,-8.36525,20.0,9.380302,-8.219,20.0,12.235374,-7.798831,20.0,14.221862,-7.284199,20.0,15.955106,-6.626362,20.0,17.095102,-6.047588,20.0,18.102882,-5.402307,20.0,18.982834,-4.696537,20.0,19.739342,-3.936299,20.0,20.376793,-3.12761,20.0,20.899572,-2.276492,20.0,21.312067,-1.388962,20.0,21.618662,-0.471041,20.0,21.823744,0.471252,20.0,21.906235,1.110015,20.0,21.951874,2.079552,20.0,21.903452,2.904008,20.0,21.760862,3.704063,20.0,21.528116,4.476208,20.0,21.209227,5.216934,20.0,20.808203,5.922733,20.0,20.32906,6.590097,20.0,19.775808,7.215518,20.0,19.15246,7.795487,20.0,18.463028,8.326496,20.0,17.711523,8.805037,20.0,16.619892,9.355412,20.0,15.434553,9.797957,20.0,14.165014,10.124356,20.0,12.820785,10.326294,20.0,11.411377,10.395454,20.0,10.48947,10.354156,20.0,9.670573,10.235798,20.0,8.949923,10.04869,20.0,8.471042,9.868238,20.0,8.042736,9.657294,20.0,7.662995,9.419361,20.0,7.329809,9.157944,20.0,7.041167,8.876548,20.0,6.79506,8.578678,20.0,6.589479,8.267839,20.0,6.422414,7.947537,20.0,6.291854,7.621276,20.0,6.195791,7.292562,20.0,6.132215,6.964898,20.0,6.106886,6.748771,20.0,6.092987,6.430649};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_9_40_point_1()
		{
			double[] value = {1.0,1.0,0.0,1.0,0.012831,1.0,0.026028,1.0,0.038597,1.0,0.050597,1.0,0.059271,1.0,0.067711,1.0,0.075968,1.0,0.084099,1.0,0.092171,1.0,0.100259,1.0,0.108441,1.0,0.116801,1.0,0.125423,1.0,0.134388,1.0,0.143777,1.0,0.15031,1.0,0.160569,1.0,0.1755,1.0,0.189386,1.0,0.202383,1.0,0.214643,1.0,0.226313,1.0,0.237529,1.0,0.248413,1.0,0.259066,1.0,0.269569,1.0,0.279982,1.0,0.290342,1.0,0.3041,1.0,0.317794,1.0,0.331378,1.0,0.338107,1.0,0.348086,1.0,0.359724,1.0,0.373535,1.0,0.387073,1.0,0.402311,1.0,0.416656,1.0,0.427978,1.0,0.438161,1.0,0.442757,1.0,0.448312,1.0,0.46316,1.0,0.476229,1.0,0.485628,1.0,0.494259,1.0,0.502263,1.0,0.511569,1.0,0.520272,1.0,0.534766,1.0,0.547989,1.0,0.564031,1.0,0.635824,1.0,0.654919,1.0,0.676785,1.0,0.6853,1.0,0.693169,1.0,0.701612,1.0,0.707604,1.0,0.715563,1.0,0.723277,1.0,0.730524,1.0,0.737381,1.0,0.74392,1.0,0.750209,1.0,0.75631,1.0,0.762276,1.0,0.768153,1.0,0.776869,1.0,0.785531,1.0,0.794167,1.0,0.805611,1.0,0.816869,1.0,0.830387,1.0,0.845169,1.0,0.857472,1.0,1.0,1.0,0.0,1.0,0.056295,1.0,0.105666,1.0,0.140773,1.0,0.172489,1.0,0.194362,1.0,0.214834,1.0,0.234132,1.0,0.252481,1.0,0.270097,1.0,0.287186,1.0,0.303929,1.0,0.320486,1.0,0.336984,1.0,0.348003,1.0,0.364608,1.0,0.378737,1.0,0.39264,1.0,0.406437,1.0,0.420234,1.0,0.434122,1.0};
			return value;
		}
		private double[] getTextureCoordinate_9_40_point_2()
		{
			double[] value = {0.448177,1.0,0.462462,1.0,0.477029,1.0,0.491916,1.0,0.507158,1.0,0.528073,1.0,0.54972,1.0,0.572145,1.0,0.5954,1.0,0.619542,1.0,0.635329,1.0,0.649485,1.0,0.662222,1.0,0.670977,1.0,0.679145,1.0,0.686812,1.0,0.694057,1.0,0.700953,1.0,0.707564,1.0,0.713939,1.0,0.72012,1.0,0.726132,1.0,0.731991,1.0,0.737701,1.0,0.741424,1.0,0.746871,1.0,1.0,0.0,0.0,0.0,0.012831,0.0,0.026028,0.0,0.038597,0.0,0.050597,0.0,0.059271,0.0,0.067711,0.0,0.075968,0.0,0.084099,0.0,0.092171,0.0,0.100259,0.0,0.108441,0.0,0.116801,0.0,0.125423,0.0,0.134388,0.0,0.143777,0.0,0.15031,0.0,0.160569,0.0,0.1755,0.0,0.189386,0.0,0.202383,0.0,0.214643,0.0,0.226313,0.0,0.237529,0.0,0.248413,0.0,0.259066,0.0,0.269569,0.0,0.279982,0.0,0.290342,0.0,0.3041,0.0,0.317794,0.0,0.331378,0.0,0.338107,0.0,0.348086,0.0,0.359724,0.0,0.373535,0.0,0.387073,0.0,0.402311,0.0,0.416656,0.0,0.427978,0.0,0.438161,0.0,0.442757,0.0,0.448312,0.0,0.46316,0.0,0.476229,0.0,0.485628,0.0,0.494259,0.0,0.502263,0.0,0.511569,0.0,0.520272,0.0,0.534766,0.0,0.547989,0.0,0.564031,0.0,0.635824,0.0,0.654919,0.0,0.676785,0.0,0.6853,0.0,0.693169,0.0,0.701612,0.0,0.707604,0.0,0.715563,0.0,0.723277,0.0,0.730524,0.0,0.737381,0.0,0.74392,0.0,0.750209,0.0,0.75631,0.0,0.762276,0.0,0.768153,0.0,0.776869,0.0,0.785531,0.0,0.794167,0.0,0.805611,0.0};
			return value;
		}
		private double[] getTextureCoordinate_9_40_point_3()
		{
			double[] value = {0.816869,0.0,0.830387,0.0,0.845169,0.0,0.857472,0.0,1.0,0.0,0.0,0.0,0.056295,0.0,0.105666,0.0,0.140773,0.0,0.172489,0.0,0.194362,0.0,0.214834,0.0,0.234132,0.0,0.252481,0.0,0.270097,0.0,0.287186,0.0,0.303929,0.0,0.320486,0.0,0.336984,0.0,0.348003,0.0,0.364608,0.0,0.378737,0.0,0.39264,0.0,0.406437,0.0,0.420234,0.0,0.434122,0.0,0.448177,0.0,0.462462,0.0,0.477029,0.0,0.491916,0.0,0.507158,0.0,0.528073,0.0,0.54972,0.0,0.572145,0.0,0.5954,0.0,0.619542,0.0,0.635329,0.0,0.649485,0.0,0.662222,0.0,0.670977,0.0,0.679145,0.0,0.686812,0.0,0.694057,0.0,0.700953,0.0,0.707564,0.0,0.713939,0.0,0.72012,0.0,0.726132,0.0,0.731991,0.0,0.737701,0.0,0.741424,0.0,0.746871,0.0};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Cap_11_9_44_coordIndex_1()
		{
			int[] value = {76,77,123,-1,76,123,0,-1,76,75,33,-1,76,33,32,-1,76,32,31,-1,76,31,30,-1,76,30,77,-1,75,74,34,-1,75,34,33,-1,74,73,36,-1,74,36,35,-1,74,35,34,-1,73,72,37,-1,73,37,36,-1,72,71,39,-1,72,39,38,-1,72,38,37,-1,71,70,41,-1,71,41,40,-1,71,40,39,-1,70,69,43,-1,70,43,42,-1,70,42,41,-1,69,68,44,-1,69,44,43,-1,68,67,45,-1,68,45,44,-1,67,66,47,-1,67,47,46,-1,67,46,45,-1,66,65,48,-1,66,48,47,-1,65,64,49,-1,65,49,48,-1,64,63,50,-1,64,50,49,-1,63,62,50,-1,62,61,51,-1,62,51,50,-1,61,60,52,-1,61,52,51,-1,60,59,52,-1,59,58,52,-1,58,57,52,-1,57,56,52,-1,56,55,53,-1,56,53,52,-1,55,54,53,-1,30,29,77,-1,29,28,78,-1,29,78,77,-1,28,27,78,-1,27,26,79,-1,27,79,78,-1,26,25,79,-1,25,24,80,-1,25,80,79,-1,24,23,81,-1,24,81,80,-1,23,22,82,-1,23,82,81,-1,22,21,83,-1,22,83,82,-1,21,20,85,-1,21,85,84,-1,21,84,83,-1,20,19,86,-1,20,86,85,-1,19,18,89,-1,19,89,88,-1,19,88,87,-1,19,87,86,-1,18,17,91,-1,18,91,90,-1,18,90,89,-1,17,16,94,-1,17,94,93,-1,17,93,92,-1,17,92,91,-1,16,15,95,-1,16,95,94,-1,15,14,97,-1,15,97,96,-1,15,96,95,-1,14,13,98,-1,14,98,97,-1,13,12,100,-1,13,100,99,-1,13,99,98,-1,12,11,101,-1,12,101,100,-1,11,10,102,-1,11,102,101,-1,10,9,103,-1,10,103,102,-1,9,8,104,-1,9,104,103,-1,8,7,104,-1,7,6,105,-1,7,105,104,-1,6,5,106,-1,6,106,105,-1,5,4,107,-1,5,107,106,-1,4,3,108,-1,4,108,107,-1,3,2,109,-1,3,109,108,-1,2,1,111,-1,2,111,110,-1,2,110,109,-1,1,0,113,-1,1,113,112,-1,1,112,111,-1,0,123,122,-1,0,122,121,-1,0,121,120,-1,0,120,119,-1,0,119,118,-1,0,118,117,-1,0,117,116,-1,0,116,115,-1,0,115,114,-1,0,114,113,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_44_point_1()
		{
			double[] value = {0.0,2.514374,21.70945,0.0,5.221893,21.70945,0.0,8.00381,21.587126,0.0,10.630615,21.220943,0.0,13.088353,20.612085,0.0,14.81231,19.996897,0.0,16.427427,19.246368,0.0,17.927816,18.360998,0.0,19.30759,17.341288,0.0,20.560858,16.18773,0.0,21.681736,14.90083,0.0,22.664331,13.481085,0.0,23.50276,11.928993,0.0,24.19113,10.245054,0.0,24.723557,8.429769,0.0,25.094149,6.483633,0.0,25.248396,5.113761,0.0,25.336182,2.950653,0.0,25.195318,-0.19669,0.0,24.785757,-3.098037,0.0,24.127052,-5.760158,0.0,23.238752,-8.189819,0.0,22.140406,-10.393793,0.0,20.851564,-12.378847,0.0,19.391779,-14.15175,0.0,17.780598,-15.719272,0.0,16.03757,-17.08818,0.0,14.182248,-18.265247,0.0,12.234181,-19.25724,0.0,9.526278,-20.303703,0.0,6.734592,-21.049227,0.0,3.905462,-21.509853,0.0,2.491338,-21.638346,0.0,0.386993,-21.709446,0.0,-2.065929,-21.589645,0.0,-4.94797,-21.158255,0.0,-7.718472,-20.461369,0.0,-10.746912,-19.380985,0.0,-13.484629,-18.090006,0.0,-15.543152,-16.877378,0.0,-17.28603,-15.620799,0.0,-18.024382,-14.992005,0.0,-18.857605,-14.16745,0.0,-20.89521,-11.787745,0.0,-22.464643,-9.520025,0.0,-23.423256,-7.783749,0.0,-24.151073,-6.114463,0.0,-24.67869,-4.510091,0.0,-25.103281,-2.59274,0.0,-25.322615,-0.769503,0.0,-25.390894,2.288117,0.0,-25.336212,5.077652,0.0,-25.336212,8.462852,0.0,-17.986603,21.70945,0.0,-14.505615,19.680153,0.0,-16.812584,15.684487,0.0,-17.524714,14.034758,0.0,-18.040024,12.456334,0.0,-18.424137,10.716675,0.0,-18.587006,9.462876,0.0,-18.664307,7.785156,0.0,-18.594322,6.159091,0.0,-18.390383,4.643435,0.0,-18.061516,3.234443,0.0,-17.616745,1.928363,0.0,-17.065094,0.721449,0.0,-16.415588,-0.39005,0.0,-15.677254,-1.409882,0.0,-14.859114,-2.341795,0.0,-13.502011,-3.583017,0.0,-12.016113,-4.647509,0.0,-10.431877,-5.547923,0.0,-8.219237,-6.515108,0.0,-5.958122,-7.24308,0.0,-3.173549,-7.862337,0.0,-0.079536,-8.256391,0.0,2.514374,-8.36525,0.0,6.092987,-8.36525,0.0,9.380302,-8.219,0.0,12.235374,-7.798831,0.0,14.221862,-7.284199,0.0,15.955106,-6.626362,0.0,17.095102,-6.047588,0.0,18.102882,-5.402307,0.0,18.982834,-4.696537,0.0,19.739342,-3.936299,0.0,20.376793,-3.12761,0.0,20.899572,-2.276492,0.0,21.312067,-1.388962,0.0,21.618662,-0.471041,0.0,21.823744,0.471252,0.0,21.906235,1.110015,0.0,21.951874,2.079552,0.0,21.903452,2.904008,0.0,21.760862,3.704063,0.0,21.528116,4.476208,0.0,21.209227,5.216934,0.0,20.808203,5.922733,0.0,20.32906,6.590097,0.0,19.775808,7.215518};
			return value;
		}
		private double[] getCoordinate_10_44_point_2()
		{
			double[] value = {0.0,19.15246,7.795487,0.0,18.463028,8.326496,0.0,17.711523,8.805037,0.0,16.619892,9.355412,0.0,15.434553,9.797957,0.0,14.165014,10.124356,0.0,12.820785,10.326294,0.0,11.411377,10.395454,0.0,10.48947,10.354156,0.0,9.670573,10.235798,0.0,8.949923,10.04869,0.0,8.471042,9.868238,0.0,8.042736,9.657294,0.0,7.662995,9.419361,0.0,7.329809,9.157944,0.0,7.041167,8.876548,0.0,6.79506,8.578678,0.0,6.589479,8.267839,0.0,6.422414,7.947537,0.0,6.291854,7.621276,0.0,6.195791,7.292562,0.0,6.132215,6.964898,0.0,6.106886,6.748771,0.0,6.092987,6.430649};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Cap_24_9_49_coordIndex_1()
		{
			int[] value = {0,1,113,-1,0,113,114,-1,0,114,115,-1,0,115,116,-1,0,116,117,-1,0,117,118,-1,0,118,119,-1,0,119,120,-1,0,120,121,-1,0,121,122,-1,0,122,123,-1,0,123,76,-1,1,2,111,-1,1,111,112,-1,1,112,113,-1,2,3,109,-1,2,109,110,-1,2,110,111,-1,3,4,108,-1,3,108,109,-1,4,5,107,-1,4,107,108,-1,5,6,106,-1,5,106,107,-1,6,7,105,-1,6,105,106,-1,7,8,104,-1,7,104,105,-1,8,9,104,-1,9,10,103,-1,9,103,104,-1,10,11,102,-1,10,102,103,-1,11,12,101,-1,11,101,102,-1,12,13,100,-1,12,100,101,-1,13,14,98,-1,13,98,99,-1,13,99,100,-1,14,15,97,-1,14,97,98,-1,15,16,95,-1,15,95,96,-1,15,96,97,-1,16,17,94,-1,16,94,95,-1,17,18,91,-1,17,91,92,-1,17,92,93,-1,17,93,94,-1,18,90,91,-1,18,19,89,-1,18,89,90,-1,19,87,88,-1,19,88,89,-1,19,20,86,-1,19,86,87,-1,20,85,86,-1,20,21,85,-1,21,83,84,-1,21,84,85,-1,21,22,83,-1,22,82,83,-1,22,23,82,-1,23,81,82,-1,23,24,81,-1,24,80,81,-1,24,25,80,-1,25,79,80,-1,25,26,79,-1,26,27,79,-1,27,78,79,-1,27,28,78,-1,28,29,78,-1,29,77,78,-1,29,30,77,-1,30,76,77,-1,30,31,76,-1,31,32,76,-1,32,33,76,-1,33,34,75,-1,33,75,76,-1,34,35,74,-1,34,74,75,-1,35,36,74,-1,36,37,73,-1,36,73,74,-1,37,38,72,-1,37,72,73,-1,38,39,72,-1,39,40,71,-1,39,71,72,-1,40,41,71,-1,41,42,70,-1,41,70,71,-1,42,43,70,-1,43,44,69,-1,43,69,70,-1,44,45,68,-1,44,68,69,-1,45,46,67,-1,45,67,68,-1,46,47,67,-1,47,48,66,-1,47,66,67,-1,48,49,65,-1,48,65,66,-1,49,50,64,-1,49,64,65,-1,50,51,62,-1,50,62,63,-1,50,63,64,-1,51,52,61,-1,51,61,62,-1,52,53,56,-1,52,56,57,-1,52,57,58,-1,52,58,59,-1,52,59,60,-1,52,60,61,-1,53,54,55,-1,53,55,56,-1,76,123,77,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_49_point_1()
		{
			double[] value = {20.0,2.514374,21.70945,20.0,5.221893,21.70945,20.0,8.00381,21.587126,20.0,10.630615,21.220943,20.0,13.088353,20.612085,20.0,14.81231,19.996897,20.0,16.427427,19.246368,20.0,17.927816,18.360998,20.0,19.30759,17.341288,20.0,20.560858,16.18773,20.0,21.681736,14.90083,20.0,22.664331,13.481085,20.0,23.50276,11.928993,20.0,24.19113,10.245054,20.0,24.723557,8.429769,20.0,25.094149,6.483633,20.0,25.248396,5.113761,20.0,25.336182,2.950653,20.0,25.195318,-0.19669,20.0,24.785757,-3.098037,20.0,24.127052,-5.760158,20.0,23.238752,-8.189819,20.0,22.140406,-10.393793,20.0,20.851564,-12.378847,20.0,19.391779,-14.15175,20.0,17.780598,-15.719272,20.0,16.03757,-17.08818,20.0,14.182248,-18.265247,20.0,12.234181,-19.25724,20.0,9.526278,-20.303703,20.0,6.734592,-21.049227,20.0,3.905462,-21.509853,20.0,2.491338,-21.638346,20.0,0.386993,-21.709446,20.0,-2.065929,-21.589645,20.0,-4.94797,-21.158255,20.0,-7.718472,-20.461369,20.0,-10.746912,-19.380985,20.0,-13.484629,-18.090006,20.0,-15.543152,-16.877378,20.0,-17.28603,-15.620799,20.0,-18.024382,-14.992005,20.0,-18.857605,-14.16745,20.0,-20.89521,-11.787745,20.0,-22.464643,-9.520025,20.0,-23.423256,-7.783749,20.0,-24.151073,-6.114463,20.0,-24.67869,-4.510091,20.0,-25.103281,-2.59274,20.0,-25.322615,-0.769503,20.0,-25.390894,2.288117,20.0,-25.336212,5.077652,20.0,-25.336212,8.462852,20.0,-17.986603,21.70945,20.0,-14.505615,19.680153,20.0,-16.812584,15.684487,20.0,-17.524714,14.034758,20.0,-18.040024,12.456334,20.0,-18.424137,10.716675,20.0,-18.587006,9.462876,20.0,-18.664307,7.785156,20.0,-18.594322,6.159091,20.0,-18.390383,4.643435,20.0,-18.061516,3.234443,20.0,-17.616745,1.928363,20.0,-17.065094,0.721449,20.0,-16.415588,-0.39005,20.0,-15.677254,-1.409882,20.0,-14.859114,-2.341795,20.0,-13.502011,-3.583017,20.0,-12.016113,-4.647509,20.0,-10.431877,-5.547923,20.0,-8.219237,-6.515108,20.0,-5.958122,-7.24308,20.0,-3.173549,-7.862337,20.0,-0.079536,-8.256391,20.0,2.514374,-8.36525,20.0,6.092987,-8.36525,20.0,9.380302,-8.219,20.0,12.235374,-7.798831,20.0,14.221862,-7.284199,20.0,15.955106,-6.626362,20.0,17.095102,-6.047588,20.0,18.102882,-5.402307,20.0,18.982834,-4.696537,20.0,19.739342,-3.936299,20.0,20.376793,-3.12761,20.0,20.899572,-2.276492,20.0,21.312067,-1.388962,20.0,21.618662,-0.471041,20.0,21.823744,0.471252,20.0,21.906235,1.110015,20.0,21.951874,2.079552,20.0,21.903452,2.904008,20.0,21.760862,3.704063,20.0,21.528116,4.476208,20.0,21.209227,5.216934,20.0,20.808203,5.922733,20.0,20.32906,6.590097,20.0,19.775808,7.215518};
			return value;
		}
		private double[] getCoordinate_10_49_point_2()
		{
			double[] value = {20.0,19.15246,7.795487,20.0,18.463028,8.326496,20.0,17.711523,8.805037,20.0,16.619892,9.355412,20.0,15.434553,9.797957,20.0,14.165014,10.124356,20.0,12.820785,10.326294,20.0,11.411377,10.395454,20.0,10.48947,10.354156,20.0,9.670573,10.235798,20.0,8.949923,10.04869,20.0,8.471042,9.868238,20.0,8.042736,9.657294,20.0,7.662995,9.419361,20.0,7.329809,9.157944,20.0,7.041167,8.876548,20.0,6.79506,8.578678,20.0,6.589479,8.267839,20.0,6.422414,7.947537,20.0,6.291854,7.621276,20.0,6.195791,7.292562,20.0,6.132215,6.964898,20.0,6.106886,6.748771,20.0,6.092987,6.430649};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_5_8_55_coordIndex_1()
		{
			int[] value = {0,1,138,137,-1,1,2,139,138,-1,2,3,140,139,-1,3,4,141,140,-1,4,5,142,141,-1,5,6,143,142,-1,6,7,144,143,-1,7,8,145,144,-1,8,9,146,145,-1,9,10,147,146,-1,10,11,148,147,-1,11,12,149,148,-1,12,13,150,149,-1,13,14,151,150,-1,14,15,152,151,-1,15,16,153,152,-1,16,17,154,153,-1,17,18,155,154,-1,18,19,156,155,-1,19,20,157,156,-1,20,21,158,157,-1,21,22,159,158,-1,22,23,160,159,-1,23,24,161,160,-1,24,25,162,161,-1,25,26,163,162,-1,26,27,164,163,-1,27,28,165,164,-1,28,29,166,165,-1,29,30,167,166,-1,30,31,168,167,-1,31,32,169,168,-1,32,33,170,169,-1,33,34,171,170,-1,34,35,172,171,-1,35,36,173,172,-1,36,37,174,173,-1,37,38,175,174,-1,38,39,176,175,-1,39,40,177,176,-1,40,41,178,177,-1,41,42,179,178,-1,42,43,180,179,-1,43,44,181,180,-1,44,45,182,181,-1,45,46,183,182,-1,46,47,184,183,-1,47,48,185,184,-1,48,49,186,185,-1,49,50,187,186,-1,50,51,188,187,-1,51,52,189,188,-1,52,53,190,189,-1,53,54,191,190,-1,54,55,192,191,-1,55,56,193,192,-1,56,57,194,193,-1,57,58,195,194,-1,58,59,196,195,-1,59,60,197,196,-1,60,61,198,197,-1,61,62,199,198,-1,62,63,200,199,-1,63,64,201,200,-1,64,65,202,201,-1,65,66,203,202,-1,66,67,204,203,-1,67,68,205,204,-1,68,69,206,205,-1,69,70,207,206,-1,70,71,208,207,-1,71,0,137,208,-1,72,73,210,209,-1,73,74,211,210,-1,74,75,212,211,-1,75,76,213,212,-1,76,77,214,213,-1,77,78,215,214,-1,78,79,216,215,-1,79,80,217,216,-1,80,81,218,217,-1,81,82,219,218,-1,82,83,220,219,-1,83,84,221,220,-1,84,85,222,221,-1,85,86,223,222,-1,86,87,224,223,-1,87,88,225,224,-1,88,89,226,225,-1,89,90,227,226,-1,90,91,228,227,-1,91,92,229,228,-1,92,93,230,229,-1,93,94,231,230,-1,94,95,232,231,-1,95,96,233,232,-1,96,97,234,233,-1,97,98,235,234,-1,98,99,236,235,-1,99,100,237,236,-1,100,101,238,237,-1,101,102,239,238,-1,102,103,240,239,-1,103,104,241,240,-1,104,105,242,241,-1,105,106,243,242,-1,106,107,244,243,-1,107,108,245,244,-1,108,109,246,245,-1,109,110,247,246,-1,110,111,248,247,-1,111,112,249,248,-1,112,113,250,249,-1,113,114,251,250,-1,114,115,252,251,-1,115,116,253,252,-1,116,117,254,253,-1,117,118,255,254,-1,118,119,256,255,-1,119,120,257,256,-1,120,121,258,257,-1,121,122,259,258,-1,122,123,260,259,-1,123,124,261,260,-1,124,125,262,261,-1,125,126,263,262,-1,126,127,264,263,-1,127,128,265,264,-1,128,129,266,265,-1,129,130,267,266,-1,130,131,268,267,-1,131,132,269,268,-1,132,133,270,269,-1,133,134,271,270,-1,134,135,272,271,-1,135,136,273,272,-1,136,72,209,273,-1};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_5_8_55_texCoordIndex_1()
		{
			int[] value = {1,2,141,140,-1,2,3,142,141,-1,3,4,143,142,-1,4,5,144,143,-1,5,6,145,144,-1,6,7,146,145,-1,7,8,147,146,-1,8,9,148,147,-1,9,10,149,148,-1,10,11,150,149,-1,11,12,151,150,-1,12,13,152,151,-1,13,14,153,152,-1,14,15,154,153,-1,15,16,155,154,-1,16,17,156,155,-1,17,18,157,156,-1,18,19,158,157,-1,19,20,159,158,-1,20,21,160,159,-1,21,22,161,160,-1,22,23,162,161,-1,23,24,163,162,-1,24,25,164,163,-1,25,26,165,164,-1,26,27,166,165,-1,27,28,167,166,-1,28,29,168,167,-1,29,30,169,168,-1,30,31,170,169,-1,31,32,171,170,-1,32,33,172,171,-1,33,34,173,172,-1,34,35,174,173,-1,35,36,175,174,-1,36,37,176,175,-1,37,38,177,176,-1,38,39,178,177,-1,39,40,179,178,-1,40,41,180,179,-1,41,42,181,180,-1,42,43,182,181,-1,43,44,183,182,-1,44,45,184,183,-1,45,46,185,184,-1,46,47,186,185,-1,47,48,187,186,-1,48,49,188,187,-1,49,50,189,188,-1,50,51,190,189,-1,51,52,191,190,-1,52,53,192,191,-1,53,54,193,192,-1,54,55,194,193,-1,55,56,195,194,-1,56,57,196,195,-1,57,58,197,196,-1,58,59,198,197,-1,59,60,199,198,-1,60,61,200,199,-1,61,62,201,200,-1,62,63,202,201,-1,63,64,203,202,-1,64,65,204,203,-1,65,66,205,204,-1,66,67,206,205,-1,67,68,207,206,-1,68,69,208,207,-1,69,70,209,208,-1,70,71,210,209,-1,71,72,211,210,-1,72,0,139,211,-1,74,75,214,213,-1,75,76,215,214,-1,76,77,216,215,-1,77,78,217,216,-1,78,79,218,217,-1,79,80,219,218,-1,80,81,220,219,-1,81,82,221,220,-1,82,83,222,221,-1,83,84,223,222,-1,84,85,224,223,-1,85,86,225,224,-1,86,87,226,225,-1,87,88,227,226,-1,88,89,228,227,-1,89,90,229,228,-1,90,91,230,229,-1,91,92,231,230,-1,92,93,232,231,-1,93,94,233,232,-1,94,95,234,233,-1,95,96,235,234,-1,96,97,236,235,-1,97,98,237,236,-1,98,99,238,237,-1,99,100,239,238,-1,100,101,240,239,-1,101,102,241,240,-1,102,103,242,241,-1,103,104,243,242,-1,104,105,244,243,-1,105,106,245,244,-1,106,107,246,245,-1,107,108,247,246,-1,108,109,248,247,-1,109,110,249,248,-1,110,111,250,249,-1,111,112,251,250,-1,112,113,252,251,-1,113,114,253,252,-1,114,115,254,253,-1,115,116,255,254,-1,116,117,256,255,-1,117,118,257,256,-1,118,119,258,257,-1,119,120,259,258,-1,120,121,260,259,-1,121,122,261,260,-1,122,123,262,261,-1,123,124,263,262,-1,124,125,264,263,-1,125,126,265,264,-1,126,127,266,265,-1,127,128,267,266,-1,128,129,268,267,-1,129,130,269,268,-1,130,131,270,269,-1,131,132,271,270,-1,132,133,272,271,-1,133,134,273,272,-1,134,135,274,273,-1,135,136,275,274,-1,136,137,276,275,-1,137,138,277,276,-1,138,73,212,277,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_9_55_point_1()
		{
			double[] value = {0.0,-34.958435,-21.130142,0.0,-34.662018,-18.945055,0.0,-34.558693,-16.356499,0.0,-34.7821,-12.471241,0.0,-35.612206,-5.705176,0.0,-36.11862,1.885956,0.0,-36.00183,4.484949,0.0,-35.656384,7.017258,0.0,-35.08968,9.470471,0.0,-34.309116,11.832181,0.0,-33.32209,14.089974,0.0,-32.136,16.231443,0.0,-30.758242,18.244179,0.0,-29.19621,20.115767,0.0,-27.457308,21.8338,0.0,-25.548925,23.38587,0.0,-23.478464,24.759563,0.0,-21.25332,25.94247,0.0,-18.880892,26.922182,0.0,-16.368574,27.686289,0.0,-13.723763,28.222378,0.0,-11.890603,28.446968,0.0,-9.041412,28.575455,0.0,-4.597414,28.342192,0.0,-1.370033,27.831718,0.0,1.564347,27.048819,0.0,3.571957,26.291445,0.0,5.413297,25.39487,0.0,7.087739,24.365116,0.0,8.594658,23.208197,0.0,9.933429,21.93013,0.0,11.103427,20.536934,0.0,12.104025,19.034628,0.0,12.934598,17.429226,0.0,13.594523,15.726747,0.0,14.083173,13.933207,0.0,14.399921,12.054626,0.0,14.515279,10.757964,0.0,14.553772,9.427963,0.0,14.456788,7.352993,0.0,14.172409,5.313364,0.0,13.710497,3.32127,0.0,12.935745,1.010679,0.0,11.936587,-1.192821,0.0,10.730063,-3.268154,0.0,9.333216,-5.194243,0.0,8.036082,-6.670107,0.0,6.334564,-8.267845,0.0,35.925903,-8.267845,0.0,36.118652,-8.462143,0.0,35.159554,-11.567473,0.0,34.285122,-15.711983,0.0,33.594418,-21.23771,0.0,33.217346,-28.575447,0.0,30.2193,-28.575447,0.0,30.2193,-25.771744,0.0,30.179644,-25.046967,0.0,30.064932,-24.401209,0.0,29.949917,-24.012379,0.0,29.806278,-23.655327,0.0,29.635908,-23.32872,0.0,29.440699,-23.03122,0.0,29.222546,-22.76149,0.0,28.983341,-22.518194,0.0,28.72498,-22.3,0.0,28.305656,-22.016838,0.0,27.853878,-21.782635,0.0,27.376032,-21.592875,0.0,26.7094,-21.401201,0.0,25.849993,-21.24516,0.0,24.819445,-21.152882,0.0,23.837982,-21.130142,0.0,-8.655212,-8.267845,0.0,-4.273302,-8.094326,0.0,-1.476993,-7.725779,0.0,0.523578,-7.265256,0.0,1.572415,-6.928572,0.0,2.562561,-6.527542,0.0,3.402097,-6.116277,0.0,4.199377,-5.628322,0.0,4.949359,-5.068738,0.0,5.647003,-4.442589,0.0,6.28727,-3.754936,0.0,6.865119,-3.010844,0.0,7.375508,-2.215373,0.0,7.813399,-1.373588,0.0,8.173751,-0.49055,0.0,8.451522,0.428677,0.0,8.641673,1.379032,0.0,8.723754,2.109179,0.0,8.751587,2.851852,0.0,8.677854,4.023096,0.0,8.458325,5.165585,0.0,8.095508,6.273554,0.0,7.591908,7.341241,0.0,6.95003,8.362882,0.0,6.172383,9.332713,0.0,5.261472,10.24497,0.0,4.219803,11.093891,0.0,3.049883,11.873711};
			return value;
		}
		private double[] getCoordinate_9_55_point_2()
		{
			double[] value = {0.0,1.294817,12.796019,0.0,-0.677853,13.571571,0.0,-2.862191,14.186709,0.0,-5.252253,14.627768,0.0,-7.176232,14.836103,0.0,-9.912018,14.939651,0.0,-14.504126,14.719472,0.0,-17.77936,14.249578,0.0,-20.709423,13.548503,0.0,-23.302628,12.643873,0.0,-25.567287,11.563313,0.0,-27.055178,10.654059,0.0,-28.366446,9.67304,0.0,-29.5046,8.631911,0.0,-30.473148,7.542327,0.0,-31.275597,6.415942,0.0,-31.915453,5.264412,0.0,-32.396225,4.099391,0.0,-32.72142,2.932535,0.0,-32.85352,2.159366,0.0,-32.927216,1.01535,0.0,-32.860325,-0.419677,0.0,-32.66495,-1.783819,0.0,-32.401268,-2.877351,0.0,-32.05405,-3.884039,0.0,-31.70451,-4.64503,0.0,-31.303345,-5.325285,0.0,-30.94719,-5.80512,0.0,-30.561333,-6.222585,0.0,-30.253347,-6.491895,0.0,-29.930115,-6.721443,0.0,-29.414194,-7.004668,0.0,-28.697529,-7.309728,0.0,-27.752176,-7.609317,0.0,-26.389643,-7.907441,0.0,-24.074951,-8.184704,0.0,-21.708923,-8.267845,20.0,-34.958435,-21.130142,20.0,-34.662018,-18.945055,20.0,-34.558693,-16.356499,20.0,-34.7821,-12.471241,20.0,-35.612206,-5.705176,20.0,-36.11862,1.885956,20.0,-36.00183,4.484949,20.0,-35.656384,7.017258,20.0,-35.08968,9.470471,20.0,-34.309116,11.832181,20.0,-33.32209,14.089974,20.0,-32.136,16.231443,20.0,-30.758242,18.244179,20.0,-29.19621,20.115767,20.0,-27.457308,21.8338,20.0,-25.548925,23.38587,20.0,-23.478464,24.759563,20.0,-21.25332,25.94247,20.0,-18.880892,26.922182,20.0,-16.368574,27.686289,20.0,-13.723763,28.222378,20.0,-11.890603,28.446968,20.0,-9.041412,28.575455,20.0,-4.597414,28.342192,20.0,-1.370033,27.831718,20.0,1.564347,27.048819,20.0,3.571957,26.291445,20.0,5.413297,25.39487,20.0,7.087739,24.365116,20.0,8.594658,23.208197,20.0,9.933429,21.93013,20.0,11.103427,20.536934,20.0,12.104025,19.034628,20.0,12.934598,17.429226,20.0,13.594523,15.726747,20.0,14.083173,13.933207,20.0,14.399921,12.054626,20.0,14.515279,10.757964,20.0,14.553772,9.427963,20.0,14.456788,7.352993,20.0,14.172409,5.313364,20.0,13.710497,3.32127,20.0,12.935745,1.010679,20.0,11.936587,-1.192821,20.0,10.730063,-3.268154,20.0,9.333216,-5.194243,20.0,8.036082,-6.670107,20.0,6.334564,-8.267845,20.0,35.925903,-8.267845,20.0,36.118652,-8.462143,20.0,35.159554,-11.567473,20.0,34.285122,-15.711983,20.0,33.594418,-21.23771,20.0,33.217346,-28.575447,20.0,30.2193,-28.575447,20.0,30.2193,-25.771744,20.0,30.179644,-25.046967,20.0,30.064932,-24.401209,20.0,29.949917,-24.012379,20.0,29.806278,-23.655327,20.0,29.635908,-23.32872,20.0,29.440699,-23.03122,20.0,29.222546,-22.76149};
			return value;
		}
		private double[] getCoordinate_9_55_point_3()
		{
			double[] value = {20.0,28.983341,-22.518194,20.0,28.72498,-22.3,20.0,28.305656,-22.016838,20.0,27.853878,-21.782635,20.0,27.376032,-21.592875,20.0,26.7094,-21.401201,20.0,25.849993,-21.24516,20.0,24.819445,-21.152882,20.0,23.837982,-21.130142,20.0,-8.655212,-8.267845,20.0,-4.273302,-8.094326,20.0,-1.476993,-7.725779,20.0,0.523578,-7.265256,20.0,1.572415,-6.928572,20.0,2.562561,-6.527542,20.0,3.402097,-6.116277,20.0,4.199377,-5.628322,20.0,4.949359,-5.068738,20.0,5.647003,-4.442589,20.0,6.28727,-3.754936,20.0,6.865119,-3.010844,20.0,7.375508,-2.215373,20.0,7.813399,-1.373588,20.0,8.173751,-0.49055,20.0,8.451522,0.428677,20.0,8.641673,1.379032,20.0,8.723754,2.109179,20.0,8.751587,2.851852,20.0,8.677854,4.023096,20.0,8.458325,5.165585,20.0,8.095508,6.273554,20.0,7.591908,7.341241,20.0,6.95003,8.362882,20.0,6.172383,9.332713,20.0,5.261472,10.24497,20.0,4.219803,11.093891,20.0,3.049883,11.873711,20.0,1.294817,12.796019,20.0,-0.677853,13.571571,20.0,-2.862191,14.186709,20.0,-5.252253,14.627768,20.0,-7.176232,14.836103,20.0,-9.912018,14.939651,20.0,-14.504126,14.719472,20.0,-17.77936,14.249578,20.0,-20.709423,13.548503,20.0,-23.302628,12.643873,20.0,-25.567287,11.563313,20.0,-27.055178,10.654059,20.0,-28.366446,9.67304,20.0,-29.5046,8.631911,20.0,-30.473148,7.542327,20.0,-31.275597,6.415942,20.0,-31.915453,5.264412,20.0,-32.396225,4.099391,20.0,-32.72142,2.932535,20.0,-32.85352,2.159366,20.0,-32.927216,1.01535,20.0,-32.860325,-0.419677,20.0,-32.66495,-1.783819,20.0,-32.401268,-2.877351,20.0,-32.05405,-3.884039,20.0,-31.70451,-4.64503,20.0,-31.303345,-5.325285,20.0,-30.94719,-5.80512,20.0,-30.561333,-6.222585,20.0,-30.253347,-6.491895,20.0,-29.930115,-6.721443,20.0,-29.414194,-7.004668,20.0,-28.697529,-7.309728,20.0,-27.752176,-7.609317,20.0,-26.389643,-7.907441,20.0,-24.074951,-8.184704,20.0,-21.708923,-8.267845};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_9_56_point_1()
		{
			double[] value = {1.0,1.0,0.0,1.0,0.009041,1.0,0.019663,1.0,0.035619,1.0,0.063568,1.0,0.094761,1.0,0.105428,1.0,0.115907,1.0,0.12623,1.0,0.136428,1.0,0.146531,1.0,0.156568,1.0,0.166569,1.0,0.176564,1.0,0.186586,1.0,0.196672,1.0,0.206859,1.0,0.217192,1.0,0.227715,1.0,0.238482,1.0,0.249546,1.0,0.257119,1.0,0.268812,1.0,0.287058,1.0,0.300455,1.0,0.312907,1.0,0.321705,1.0,0.330102,1.0,0.338161,1.0,0.345951,1.0,0.353539,1.0,0.360999,1.0,0.368399,1.0,0.37581,1.0,0.383297,1.0,0.390918,1.0,0.398729,1.0,0.404067,1.0,0.409522,1.0,0.418039,1.0,0.426482,1.0,0.434867,1.0,0.444859,1.0,0.454778,1.0,0.464621,1.0,0.474376,1.0,0.482432,1.0,0.492002,1.0,0.613328,1.0,0.61445,1.0,0.627776,1.0,0.645143,1.0,0.667975,1.0,0.6981,1.0,0.710392,1.0,0.721887,1.0,0.724863,1.0,0.727552,1.0,0.729215,1.0,0.730793,1.0,0.732303,1.0,0.733762,1.0,0.735184,1.0,0.736583,1.0,0.73797,1.0,0.740044,1.0,0.742131,1.0,0.744239,1.0,0.747083,1.0,0.750664,1.0,0.754906,1.0,0.758931,1.0,1.0,1.0,0.0,1.0,0.040709,1.0,0.066892,1.0,0.085949,1.0,0.096175,1.0,0.106091,1.0,0.11477,1.0,0.123447,1.0,0.132133,1.0,0.140836,1.0,0.149558,1.0,0.158303,1.0,0.167077,1.0,0.175885,1.0,0.184739,1.0,0.193653,1.0,0.20265,1.0,0.209471,1.0,0.21637,1.0,0.227264,1.0,0.238064,1.0,0.248887,1.0,0.259845,1.0,0.271046,1.0,0.282585,1.0,0.294553,1.0};
			return value;
		}
		private double[] getTextureCoordinate_9_56_point_2()
		{
			double[] value = {0.307027,1.0,0.320079,1.0,0.338484,1.0,0.358161,1.0,0.379227,1.0,0.401788,1.0,0.419753,1.0,0.445167,1.0,0.487845,1.0,0.51856,1.0,0.546528,1.0,0.572023,1.0,0.595317,1.0,0.611504,1.0,0.626706,1.0,0.641025,1.0,0.654558,1.0,0.667396,1.0,0.679625,1.0,0.691325,1.0,0.70257,1.0,0.709851,1.0,0.720493,1.0,0.733829,1.0,0.746621,1.0,0.757064,1.0,0.766949,1.0,0.774723,1.0,0.782054,1.0,0.787601,1.0,0.792878,1.0,0.796676,1.0,0.800356,1.0,0.80582,1.0,0.81305,1.0,0.822256,1.0,0.835204,1.0,0.856845,1.0,0.878822,1.0,1.0,0.0,0.0,0.0,0.009041,0.0,0.019663,0.0,0.035619,0.0,0.063568,0.0,0.094761,0.0,0.105428,0.0,0.115907,0.0,0.12623,0.0,0.136428,0.0,0.146531,0.0,0.156568,0.0,0.166569,0.0,0.176564,0.0,0.186586,0.0,0.196672,0.0,0.206859,0.0,0.217192,0.0,0.227715,0.0,0.238482,0.0,0.249546,0.0,0.257119,0.0,0.268812,0.0,0.287058,0.0,0.300455,0.0,0.312907,0.0,0.321705,0.0,0.330102,0.0,0.338161,0.0,0.345951,0.0,0.353539,0.0,0.360999,0.0,0.368399,0.0,0.37581,0.0,0.383297,0.0,0.390918,0.0,0.398729,0.0,0.404067,0.0,0.409522,0.0,0.418039,0.0,0.426482,0.0,0.434867,0.0,0.444859,0.0,0.454778,0.0,0.464621,0.0,0.474376,0.0,0.482432,0.0,0.492002,0.0,0.613328,0.0,0.61445,0.0,0.627776,0.0,0.645143,0.0,0.667975,0.0,0.6981,0.0,0.710392,0.0,0.721887,0.0,0.724863,0.0,0.727552,0.0,0.729215,0.0,0.730793,0.0};
			return value;
		}
		private double[] getTextureCoordinate_9_56_point_3()
		{
			double[] value = {0.732303,0.0,0.733762,0.0,0.735184,0.0,0.736583,0.0,0.73797,0.0,0.740044,0.0,0.742131,0.0,0.744239,0.0,0.747083,0.0,0.750664,0.0,0.754906,0.0,0.758931,0.0,1.0,0.0,0.0,0.0,0.040709,0.0,0.066892,0.0,0.085949,0.0,0.096175,0.0,0.106091,0.0,0.11477,0.0,0.123447,0.0,0.132133,0.0,0.140836,0.0,0.149558,0.0,0.158303,0.0,0.167077,0.0,0.175885,0.0,0.184739,0.0,0.193653,0.0,0.20265,0.0,0.209471,0.0,0.21637,0.0,0.227264,0.0,0.238064,0.0,0.248887,0.0,0.259845,0.0,0.271046,0.0,0.282585,0.0,0.294553,0.0,0.307027,0.0,0.320079,0.0,0.338484,0.0,0.358161,0.0,0.379227,0.0,0.401788,0.0,0.419753,0.0,0.445167,0.0,0.487845,0.0,0.51856,0.0,0.546528,0.0,0.572023,0.0,0.595317,0.0,0.611504,0.0,0.626706,0.0,0.641025,0.0,0.654558,0.0,0.667396,0.0,0.679625,0.0,0.691325,0.0,0.70257,0.0,0.709851,0.0,0.720493,0.0,0.733829,0.0,0.746621,0.0,0.757064,0.0,0.766949,0.0,0.774723,0.0,0.782054,0.0,0.787601,0.0,0.792878,0.0,0.796676,0.0,0.800356,0.0,0.80582,0.0,0.81305,0.0,0.822256,0.0,0.835204,0.0,0.856845,0.0,0.878822,0.0};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Cap_1_9_60_coordIndex_1()
		{
			int[] value = {71,50,48,-1,71,48,47,-1,71,47,73,-1,71,73,72,-1,71,72,0,-1,71,70,50,-1,70,51,50,-1,70,69,51,-1,69,68,51,-1,68,67,51,-1,67,66,51,-1,66,65,51,-1,65,52,51,-1,65,64,52,-1,64,63,52,-1,63,62,52,-1,62,61,52,-1,61,60,52,-1,60,59,52,-1,59,58,52,-1,58,57,52,-1,57,56,52,-1,56,55,53,-1,56,53,52,-1,55,54,53,-1,50,49,48,-1,47,46,80,-1,47,80,79,-1,47,79,78,-1,47,78,77,-1,47,77,76,-1,47,76,75,-1,47,75,74,-1,47,74,73,-1,46,45,82,-1,46,82,81,-1,46,81,80,-1,45,44,84,-1,45,84,83,-1,45,83,82,-1,44,43,86,-1,44,86,85,-1,44,85,84,-1,43,42,88,-1,43,88,87,-1,43,87,86,-1,42,41,90,-1,42,90,89,-1,42,89,88,-1,41,40,91,-1,41,91,90,-1,40,39,93,-1,40,93,92,-1,40,92,91,-1,39,38,94,-1,39,94,93,-1,38,37,95,-1,38,95,94,-1,37,36,95,-1,36,35,96,-1,36,96,95,-1,35,34,97,-1,35,97,96,-1,34,33,97,-1,33,32,98,-1,33,98,97,-1,32,31,99,-1,32,99,98,-1,31,30,99,-1,30,29,100,-1,30,100,99,-1,29,28,100,-1,28,27,100,-1,27,26,101,-1,27,101,100,-1,26,25,101,-1,25,24,102,-1,25,102,101,-1,24,23,103,-1,24,103,102,-1,23,22,104,-1,23,104,103,-1,22,21,105,-1,22,105,104,-1,21,20,105,-1,20,19,106,-1,20,106,105,-1,19,18,106,-1,18,17,107,-1,18,107,106,-1,17,16,107,-1,16,15,108,-1,16,108,107,-1,15,14,108,-1,14,13,109,-1,14,109,108,-1,13,12,110,-1,13,110,109,-1,12,11,110,-1,11,10,111,-1,11,111,110,-1,10,9,112,-1,10,112,111,-1,9,8,114,-1,9,114,113,-1,9,113,112,-1,8,7,115,-1,8,115,114,-1,7,6,116,-1,7,116,115,-1,6,5,118,-1,6,118,117,-1,6,117,116,-1,5,119,118,-1,5,4,122,-1,5,122,121,-1,5,121,120,-1,5,120,119,-1,4,126,125,-1,4,125,124,-1,4,124,123,-1,4,123,122,-1,4,3,128,-1,4,128,127,-1,4,127,126,-1,3,133,132,-1,3,132,131,-1,3,131,130,-1,3,130,129,-1,3,129,128,-1,3,2,133,-1,2,135,134,-1,2,134,133,-1,2,1,135,-1,1,136,135,-1,1,0,136,-1,0,72,136,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_60_point_1()
		{
			double[] value = {0.0,-34.958435,-21.130142,0.0,-34.662018,-18.945055,0.0,-34.558693,-16.356499,0.0,-34.7821,-12.471241,0.0,-35.612206,-5.705176,0.0,-36.11862,1.885956,0.0,-36.00183,4.484949,0.0,-35.656384,7.017258,0.0,-35.08968,9.470471,0.0,-34.309116,11.832181,0.0,-33.32209,14.089974,0.0,-32.136,16.231443,0.0,-30.758242,18.244179,0.0,-29.19621,20.115767,0.0,-27.457308,21.8338,0.0,-25.548925,23.38587,0.0,-23.478464,24.759563,0.0,-21.25332,25.94247,0.0,-18.880892,26.922182,0.0,-16.368574,27.686289,0.0,-13.723763,28.222378,0.0,-11.890603,28.446968,0.0,-9.041412,28.575455,0.0,-4.597414,28.342192,0.0,-1.370033,27.831718,0.0,1.564347,27.048819,0.0,3.571957,26.291445,0.0,5.413297,25.39487,0.0,7.087739,24.365116,0.0,8.594658,23.208197,0.0,9.933429,21.93013,0.0,11.103427,20.536934,0.0,12.104025,19.034628,0.0,12.934598,17.429226,0.0,13.594523,15.726747,0.0,14.083173,13.933207,0.0,14.399921,12.054626,0.0,14.515279,10.757964,0.0,14.553772,9.427963,0.0,14.456788,7.352993,0.0,14.172409,5.313364,0.0,13.710497,3.32127,0.0,12.935745,1.010679,0.0,11.936587,-1.192821,0.0,10.730063,-3.268154,0.0,9.333216,-5.194243,0.0,8.036082,-6.670107,0.0,6.334564,-8.267845,0.0,35.925903,-8.267845,0.0,36.118652,-8.462143,0.0,35.159554,-11.567473,0.0,34.285122,-15.711983,0.0,33.594418,-21.23771,0.0,33.217346,-28.575447,0.0,30.2193,-28.575447,0.0,30.2193,-25.771744,0.0,30.179644,-25.046967,0.0,30.064932,-24.401209,0.0,29.949917,-24.012379,0.0,29.806278,-23.655327,0.0,29.635908,-23.32872,0.0,29.440699,-23.03122,0.0,29.222546,-22.76149,0.0,28.983341,-22.518194,0.0,28.72498,-22.3,0.0,28.305656,-22.016838,0.0,27.853878,-21.782635,0.0,27.376032,-21.592875,0.0,26.7094,-21.401201,0.0,25.849993,-21.24516,0.0,24.819445,-21.152882,0.0,23.837982,-21.130142,0.0,-8.655212,-8.267845,0.0,-4.273302,-8.094326,0.0,-1.476993,-7.725779,0.0,0.523578,-7.265256,0.0,1.572415,-6.928572,0.0,2.562561,-6.527542,0.0,3.402097,-6.116277,0.0,4.199377,-5.628322,0.0,4.949359,-5.068738,0.0,5.647003,-4.442589,0.0,6.28727,-3.754936,0.0,6.865119,-3.010844,0.0,7.375508,-2.215373,0.0,7.813399,-1.373588,0.0,8.173751,-0.49055,0.0,8.451522,0.428677,0.0,8.641673,1.379032,0.0,8.723754,2.109179,0.0,8.751587,2.851852,0.0,8.677854,4.023096,0.0,8.458325,5.165585,0.0,8.095508,6.273554,0.0,7.591908,7.341241,0.0,6.95003,8.362882,0.0,6.172383,9.332713,0.0,5.261472,10.24497,0.0,4.219803,11.093891,0.0,3.049883,11.873711};
			return value;
		}
		private double[] getCoordinate_10_60_point_2()
		{
			double[] value = {0.0,1.294817,12.796019,0.0,-0.677853,13.571571,0.0,-2.862191,14.186709,0.0,-5.252253,14.627768,0.0,-7.176232,14.836103,0.0,-9.912018,14.939651,0.0,-14.504126,14.719472,0.0,-17.77936,14.249578,0.0,-20.709423,13.548503,0.0,-23.302628,12.643873,0.0,-25.567287,11.563313,0.0,-27.055178,10.654059,0.0,-28.366446,9.67304,0.0,-29.5046,8.631911,0.0,-30.473148,7.542327,0.0,-31.275597,6.415942,0.0,-31.915453,5.264412,0.0,-32.396225,4.099391,0.0,-32.72142,2.932535,0.0,-32.85352,2.159366,0.0,-32.927216,1.01535,0.0,-32.860325,-0.419677,0.0,-32.66495,-1.783819,0.0,-32.401268,-2.877351,0.0,-32.05405,-3.884039,0.0,-31.70451,-4.64503,0.0,-31.303345,-5.325285,0.0,-30.94719,-5.80512,0.0,-30.561333,-6.222585,0.0,-30.253347,-6.491895,0.0,-29.930115,-6.721443,0.0,-29.414194,-7.004668,0.0,-28.697529,-7.309728,0.0,-27.752176,-7.609317,0.0,-26.389643,-7.907441,0.0,-24.074951,-8.184704,0.0,-21.708923,-8.267845};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Cap_25_9_65_coordIndex_1()
		{
			int[] value = {0,1,136,-1,0,136,72,-1,0,72,71,-1,1,2,135,-1,1,135,136,-1,2,3,133,-1,2,133,134,-1,2,134,135,-1,3,4,128,-1,3,128,129,-1,3,129,130,-1,3,130,131,-1,3,131,132,-1,3,132,133,-1,4,5,122,-1,4,122,123,-1,4,123,124,-1,4,124,125,-1,4,125,126,-1,4,126,127,-1,4,127,128,-1,5,6,118,-1,5,118,119,-1,5,119,120,-1,5,120,121,-1,5,121,122,-1,6,7,116,-1,6,116,117,-1,6,117,118,-1,7,8,115,-1,7,115,116,-1,8,9,114,-1,8,114,115,-1,9,10,112,-1,9,112,113,-1,9,113,114,-1,10,11,111,-1,10,111,112,-1,11,12,110,-1,11,110,111,-1,12,13,110,-1,13,14,109,-1,13,109,110,-1,14,15,108,-1,14,108,109,-1,15,16,108,-1,16,17,107,-1,16,107,108,-1,17,18,107,-1,18,19,106,-1,18,106,107,-1,19,20,106,-1,20,21,105,-1,20,105,106,-1,21,22,105,-1,22,23,104,-1,22,104,105,-1,23,24,103,-1,23,103,104,-1,24,25,102,-1,24,102,103,-1,25,26,101,-1,25,101,102,-1,26,27,101,-1,27,28,100,-1,27,100,101,-1,28,29,100,-1,29,30,100,-1,30,31,99,-1,30,99,100,-1,31,32,99,-1,32,33,98,-1,32,98,99,-1,33,34,97,-1,33,97,98,-1,34,35,97,-1,35,36,96,-1,35,96,97,-1,36,37,95,-1,36,95,96,-1,37,38,95,-1,38,39,94,-1,38,94,95,-1,39,40,93,-1,39,93,94,-1,40,41,91,-1,40,91,92,-1,40,92,93,-1,41,42,90,-1,41,90,91,-1,42,88,89,-1,42,89,90,-1,42,43,88,-1,43,86,87,-1,43,87,88,-1,43,44,86,-1,44,84,85,-1,44,85,86,-1,44,45,84,-1,45,82,83,-1,45,83,84,-1,45,46,82,-1,46,80,81,-1,46,81,82,-1,46,47,80,-1,47,73,74,-1,47,74,75,-1,47,75,76,-1,47,76,77,-1,47,77,78,-1,47,78,79,-1,47,79,80,-1,47,48,71,-1,47,71,73,-1,48,49,50,-1,48,50,71,-1,50,51,70,-1,50,70,71,-1,51,52,65,-1,51,65,66,-1,51,66,67,-1,51,67,68,-1,51,68,69,-1,51,69,70,-1,52,53,56,-1,52,56,57,-1,52,57,58,-1,52,58,59,-1,52,59,60,-1,52,60,61,-1,52,61,62,-1,52,62,63,-1,52,63,64,-1,52,64,65,-1,53,54,55,-1,53,55,56,-1,71,72,73,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_65_point_1()
		{
			double[] value = {20.0,-34.958435,-21.130142,20.0,-34.662018,-18.945055,20.0,-34.558693,-16.356499,20.0,-34.7821,-12.471241,20.0,-35.612206,-5.705176,20.0,-36.11862,1.885956,20.0,-36.00183,4.484949,20.0,-35.656384,7.017258,20.0,-35.08968,9.470471,20.0,-34.309116,11.832181,20.0,-33.32209,14.089974,20.0,-32.136,16.231443,20.0,-30.758242,18.244179,20.0,-29.19621,20.115767,20.0,-27.457308,21.8338,20.0,-25.548925,23.38587,20.0,-23.478464,24.759563,20.0,-21.25332,25.94247,20.0,-18.880892,26.922182,20.0,-16.368574,27.686289,20.0,-13.723763,28.222378,20.0,-11.890603,28.446968,20.0,-9.041412,28.575455,20.0,-4.597414,28.342192,20.0,-1.370033,27.831718,20.0,1.564347,27.048819,20.0,3.571957,26.291445,20.0,5.413297,25.39487,20.0,7.087739,24.365116,20.0,8.594658,23.208197,20.0,9.933429,21.93013,20.0,11.103427,20.536934,20.0,12.104025,19.034628,20.0,12.934598,17.429226,20.0,13.594523,15.726747,20.0,14.083173,13.933207,20.0,14.399921,12.054626,20.0,14.515279,10.757964,20.0,14.553772,9.427963,20.0,14.456788,7.352993,20.0,14.172409,5.313364,20.0,13.710497,3.32127,20.0,12.935745,1.010679,20.0,11.936587,-1.192821,20.0,10.730063,-3.268154,20.0,9.333216,-5.194243,20.0,8.036082,-6.670107,20.0,6.334564,-8.267845,20.0,35.925903,-8.267845,20.0,36.118652,-8.462143,20.0,35.159554,-11.567473,20.0,34.285122,-15.711983,20.0,33.594418,-21.23771,20.0,33.217346,-28.575447,20.0,30.2193,-28.575447,20.0,30.2193,-25.771744,20.0,30.179644,-25.046967,20.0,30.064932,-24.401209,20.0,29.949917,-24.012379,20.0,29.806278,-23.655327,20.0,29.635908,-23.32872,20.0,29.440699,-23.03122,20.0,29.222546,-22.76149,20.0,28.983341,-22.518194,20.0,28.72498,-22.3,20.0,28.305656,-22.016838,20.0,27.853878,-21.782635,20.0,27.376032,-21.592875,20.0,26.7094,-21.401201,20.0,25.849993,-21.24516,20.0,24.819445,-21.152882,20.0,23.837982,-21.130142,20.0,-8.655212,-8.267845,20.0,-4.273302,-8.094326,20.0,-1.476993,-7.725779,20.0,0.523578,-7.265256,20.0,1.572415,-6.928572,20.0,2.562561,-6.527542,20.0,3.402097,-6.116277,20.0,4.199377,-5.628322,20.0,4.949359,-5.068738,20.0,5.647003,-4.442589,20.0,6.28727,-3.754936,20.0,6.865119,-3.010844,20.0,7.375508,-2.215373,20.0,7.813399,-1.373588,20.0,8.173751,-0.49055,20.0,8.451522,0.428677,20.0,8.641673,1.379032,20.0,8.723754,2.109179,20.0,8.751587,2.851852,20.0,8.677854,4.023096,20.0,8.458325,5.165585,20.0,8.095508,6.273554,20.0,7.591908,7.341241,20.0,6.95003,8.362882,20.0,6.172383,9.332713,20.0,5.261472,10.24497,20.0,4.219803,11.093891,20.0,3.049883,11.873711};
			return value;
		}
		private double[] getCoordinate_10_65_point_2()
		{
			double[] value = {20.0,1.294817,12.796019,20.0,-0.677853,13.571571,20.0,-2.862191,14.186709,20.0,-5.252253,14.627768,20.0,-7.176232,14.836103,20.0,-9.912018,14.939651,20.0,-14.504126,14.719472,20.0,-17.77936,14.249578,20.0,-20.709423,13.548503,20.0,-23.302628,12.643873,20.0,-25.567287,11.563313,20.0,-27.055178,10.654059,20.0,-28.366446,9.67304,20.0,-29.5046,8.631911,20.0,-30.473148,7.542327,20.0,-31.275597,6.415942,20.0,-31.915453,5.264412,20.0,-32.396225,4.099391,20.0,-32.72142,2.932535,20.0,-32.85352,2.159366,20.0,-32.927216,1.01535,20.0,-32.860325,-0.419677,20.0,-32.66495,-1.783819,20.0,-32.401268,-2.877351,20.0,-32.05405,-3.884039,20.0,-31.70451,-4.64503,20.0,-31.303345,-5.325285,20.0,-30.94719,-5.80512,20.0,-30.561333,-6.222585,20.0,-30.253347,-6.491895,20.0,-29.930115,-6.721443,20.0,-29.414194,-7.004668,20.0,-28.697529,-7.309728,20.0,-27.752176,-7.609317,20.0,-26.389643,-7.907441,20.0,-24.074951,-8.184704,20.0,-21.708923,-8.267845};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_6_8_71_coordIndex_1()
		{
			int[] value = {0,1,145,144,-1,1,2,146,145,-1,2,3,147,146,-1,3,4,148,147,-1,4,5,149,148,-1,5,6,150,149,-1,6,7,151,150,-1,7,8,152,151,-1,8,9,153,152,-1,9,10,154,153,-1,10,11,155,154,-1,11,12,156,155,-1,12,13,157,156,-1,13,14,158,157,-1,14,15,159,158,-1,15,16,160,159,-1,16,17,161,160,-1,17,18,162,161,-1,18,19,163,162,-1,19,20,164,163,-1,20,21,165,164,-1,21,22,166,165,-1,22,23,167,166,-1,23,24,168,167,-1,24,25,169,168,-1,25,26,170,169,-1,26,27,171,170,-1,27,28,172,171,-1,28,29,173,172,-1,29,30,174,173,-1,30,31,175,174,-1,31,32,176,175,-1,32,33,177,176,-1,33,34,178,177,-1,34,35,179,178,-1,35,36,180,179,-1,36,37,181,180,-1,37,38,182,181,-1,38,39,183,182,-1,39,40,184,183,-1,40,41,185,184,-1,41,42,186,185,-1,42,43,187,186,-1,43,44,188,187,-1,44,45,189,188,-1,45,46,190,189,-1,46,47,191,190,-1,47,48,192,191,-1,48,49,193,192,-1,49,50,194,193,-1,50,51,195,194,-1,51,52,196,195,-1,52,53,197,196,-1,53,54,198,197,-1,54,55,199,198,-1,55,56,200,199,-1,56,57,201,200,-1,57,58,202,201,-1,58,59,203,202,-1,59,60,204,203,-1,60,61,205,204,-1,61,62,206,205,-1,62,63,207,206,-1,63,64,208,207,-1,64,65,209,208,-1,65,66,210,209,-1,66,67,211,210,-1,67,68,212,211,-1,68,69,213,212,-1,69,70,214,213,-1,70,71,215,214,-1,71,72,216,215,-1,72,73,217,216,-1,73,74,218,217,-1,74,75,219,218,-1,75,76,220,219,-1,76,77,221,220,-1,77,78,222,221,-1,78,79,223,222,-1,79,80,224,223,-1,80,81,225,224,-1,81,82,226,225,-1,82,83,227,226,-1,83,84,228,227,-1,84,85,229,228,-1,85,86,230,229,-1,86,87,231,230,-1,87,88,232,231,-1,88,89,233,232,-1,89,90,234,233,-1,90,91,235,234,-1,91,92,236,235,-1,92,93,237,236,-1,93,94,238,237,-1,94,95,239,238,-1,95,96,240,239,-1,96,97,241,240,-1,97,98,242,241,-1,98,99,243,242,-1,99,100,244,243,-1,100,101,245,244,-1,101,102,246,245,-1,102,103,247,246,-1,103,104,248,247,-1,104,105,249,248,-1,105,106,250,249,-1,106,107,251,250,-1,107,108,252,251,-1,108,109,253,252,-1,109,110,254,253,-1,110,111,255,254,-1,111,112,256,255,-1,112,113,257,256,-1,113,114,258,257,-1,114,115,259,258,-1,115,116,260,259,-1,116,117,261,260,-1,117,118,262,261,-1,118,119,263,262,-1,119,120,264,263,-1,120,121,265,264,-1,121,122,266,265,-1,122,123,267,266,-1,123,124,268,267,-1,124,125,269,268,-1,125,126,270,269,-1,126,127,271,270,-1,127,128,272,271,-1,128,129,273,272,-1,129,130,274,273,-1,130,131,275,274,-1,131,132,276,275,-1,132,133,277,276,-1,133,134,278,277,-1,134,135,279,278,-1,135,136,280,279,-1,136,137,281,280,-1,137,138,282,281,-1,138,139,283,282,-1,139,140,284,283,-1,140,141,285,284,-1,141,142,286,285,-1,142,143,287,286,-1,143,0,144,287,-1};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_6_8_71_texCoordIndex_1()
		{
			int[] value = {1,2,147,146,-1,2,3,148,147,-1,3,4,149,148,-1,4,5,150,149,-1,5,6,151,150,-1,6,7,152,151,-1,7,8,153,152,-1,8,9,154,153,-1,9,10,155,154,-1,10,11,156,155,-1,11,12,157,156,-1,12,13,158,157,-1,13,14,159,158,-1,14,15,160,159,-1,15,16,161,160,-1,16,17,162,161,-1,17,18,163,162,-1,18,19,164,163,-1,19,20,165,164,-1,20,21,166,165,-1,21,22,167,166,-1,22,23,168,167,-1,23,24,169,168,-1,24,25,170,169,-1,25,26,171,170,-1,26,27,172,171,-1,27,28,173,172,-1,28,29,174,173,-1,29,30,175,174,-1,30,31,176,175,-1,31,32,177,176,-1,32,33,178,177,-1,33,34,179,178,-1,34,35,180,179,-1,35,36,181,180,-1,36,37,182,181,-1,37,38,183,182,-1,38,39,184,183,-1,39,40,185,184,-1,40,41,186,185,-1,41,42,187,186,-1,42,43,188,187,-1,43,44,189,188,-1,44,45,190,189,-1,45,46,191,190,-1,46,47,192,191,-1,47,48,193,192,-1,48,49,194,193,-1,49,50,195,194,-1,50,51,196,195,-1,51,52,197,196,-1,52,53,198,197,-1,53,54,199,198,-1,54,55,200,199,-1,55,56,201,200,-1,56,57,202,201,-1,57,58,203,202,-1,58,59,204,203,-1,59,60,205,204,-1,60,61,206,205,-1,61,62,207,206,-1,62,63,208,207,-1,63,64,209,208,-1,64,65,210,209,-1,65,66,211,210,-1,66,67,212,211,-1,67,68,213,212,-1,68,69,214,213,-1,69,70,215,214,-1,70,71,216,215,-1,71,72,217,216,-1,72,73,218,217,-1,73,74,219,218,-1,74,75,220,219,-1,75,76,221,220,-1,76,77,222,221,-1,77,78,223,222,-1,78,79,224,223,-1,79,80,225,224,-1,80,81,226,225,-1,81,82,227,226,-1,82,83,228,227,-1,83,84,229,228,-1,84,85,230,229,-1,85,86,231,230,-1,86,87,232,231,-1,87,88,233,232,-1,88,89,234,233,-1,89,90,235,234,-1,90,91,236,235,-1,91,92,237,236,-1,92,93,238,237,-1,93,94,239,238,-1,94,95,240,239,-1,95,96,241,240,-1,96,97,242,241,-1,97,98,243,242,-1,98,99,244,243,-1,99,100,245,244,-1,100,101,246,245,-1,101,102,247,246,-1,102,103,248,247,-1,103,104,249,248,-1,104,105,250,249,-1,105,106,251,250,-1,106,107,252,251,-1,107,108,253,252,-1,108,109,254,253,-1,109,110,255,254,-1,110,111,256,255,-1,111,112,257,256,-1,112,113,258,257,-1,113,114,259,258,-1,114,115,260,259,-1,115,116,261,260,-1,116,117,262,261,-1,117,118,263,262,-1,118,119,264,263,-1,119,120,265,264,-1,120,121,266,265,-1,121,122,267,266,-1,122,123,268,267,-1,123,124,269,268,-1,124,125,270,269,-1,125,126,271,270,-1,126,127,272,271,-1,127,128,273,272,-1,128,129,274,273,-1,129,130,275,274,-1,130,131,276,275,-1,131,132,277,276,-1,132,133,278,277,-1,133,134,279,278,-1,134,135,280,279,-1,135,136,281,280,-1,136,137,282,281,-1,137,138,283,282,-1,138,139,284,283,-1,139,140,285,284,-1,140,141,286,285,-1,141,142,287,286,-1,142,143,288,287,-1,143,144,289,288,-1,144,0,145,289,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_9_71_point_1()
		{
			double[] value = {0.0,-3.155518,-20.289597,0.0,-3.386614,-15.095562,0.0,-4.036538,-10.467353,0.0,-4.808852,-7.276754,0.0,-5.63663,-4.871642,0.0,-6.669124,-2.654009,0.0,-7.587893,-1.145182,0.0,-8.638273,0.206863,0.0,-9.415126,1.010264,0.0,-10.255695,1.727689,0.0,-11.162072,2.352623,0.0,-12.136347,2.878547,0.0,-13.180608,3.298944,0.0,-14.296946,3.607298,0.0,-15.487451,3.797089,0.0,-16.754211,3.861801,0.0,-17.835892,3.804884,0.0,-18.884878,3.636767,0.0,-19.896656,3.361397,0.0,-20.866714,2.982723,0.0,-21.790537,2.504694,0.0,-22.663614,1.931257,0.0,-23.48143,1.266363,0.0,-24.239471,0.513958,0.0,-24.933226,-0.322007,0.0,-25.55818,-1.237587,0.0,-26.109821,-2.22883,0.0,-26.7235,-3.661362,0.0,-27.18812,-5.212031,0.0,-27.492987,-6.871475,0.0,-27.582169,-7.739063,0.0,-27.633118,-9.084488,0.0,-27.534592,-11.314365,0.0,-27.197304,-13.789533,0.0,-26.559275,-16.507212,0.0,-25.561604,-19.469328,0.0,-24.151611,-22.684097,0.0,-35.24933,-28.01419,0.0,-36.778576,-23.948456,0.0,-37.986584,-19.508661,0.0,-38.820343,-14.658971,0.0,-39.224186,-10.224437,0.0,-39.38211,-5.711395,0.0,-39.225246,-0.520048,0.0,-38.6266,4.243522,0.0,-37.628933,8.577644,0.0,-36.275024,12.480653,0.0,-35.051537,15.123986,0.0,-33.66976,17.523176,0.0,-32.147747,19.677517,0.0,-30.503536,21.586306,0.0,-28.755175,23.24884,0.0,-26.920704,24.664413,0.0,-25.018167,25.832323,0.0,-23.065615,26.751867,0.0,-21.081083,27.422337,0.0,-19.08262,27.843033,0.0,-17.751484,27.984386,0.0,-16.42752,28.014206,0.0,-13.895212,27.809511,0.0,-11.579315,27.332561,0.0,-9.470667,26.611834,0.0,-7.560106,25.675806,0.0,-5.838466,24.55295,0.0,-4.296587,23.271748,0.0,-2.925305,21.86067,0.0,-1.715458,20.348198,0.0,-0.337611,18.223057,0.0,0.79125,16.03578,0.0,1.885279,13.317132,0.0,2.789107,10.251437,0.0,3.372284,7.233902,0.0,3.5896,7.233902,0.0,4.230927,9.127302,0.0,5.167855,11.218521,0.0,6.666759,13.853976,0.0,8.215005,16.042578,0.0,10.023395,18.121891,0.0,11.649965,19.64216,0.0,13.430264,20.981926,0.0,14.862958,21.838736,0.0,16.376543,22.545643,0.0,17.96862,23.081917,0.0,19.636799,23.426828,0.0,20.790014,23.54022,0.0,21.97528,23.553207,0.0,23.51245,23.43127,0.0,24.965769,23.174719,0.0,26.337036,22.790993,0.0,27.62805,22.287525,0.0,28.840603,21.671753,0.0,29.976496,20.95111,0.0,31.037521,20.13304,0.0,32.49262,18.739511,0.0,33.78937,17.168589,0.0,34.93385,15.445371,0.0,36.23342,12.954221,0.0,37.287434,10.296426,0.0,38.281513,6.830472,0.0,38.942432,3.313282};
			return value;
		}
		private double[] getCoordinate_9_71_point_2()
		{
			double[] value = {0.0,39.25015,0.54072,0.0,39.38211,-2.775894,0.0,39.136147,-7.672698,0.0,38.176563,-14.412845,0.0,36.60137,-21.140371,0.0,35.354473,-24.932285,0.0,34.93313,-25.969929,0.0,34.378204,-27.143097,0.0,25.022186,-22.574692,0.0,26.735443,-16.754368,0.0,27.358845,-13.53262,0.0,27.549263,-11.882367,0.0,27.633514,-9.955597,0.0,27.58365,-8.885306,0.0,27.417538,-7.672693,0.0,27.110388,-6.377816,0.0,26.746468,-5.323045,0.0,26.263731,-4.284811,0.0,25.816074,-3.535487,0.0,25.28909,-2.825736,0.0,24.677427,-2.168529,0.0,23.97573,-1.576839,0.0,23.178648,-1.063639,0.0,22.591625,-0.771518,0.0,21.95824,-0.52389,0.0,20.91777,-0.244282,0.0,20.161547,-0.124705,0.0,18.929382,-0.055191,0.0,17.909412,-0.101603,0.0,16.938028,-0.238499,0.0,16.014732,-0.462371,0.0,15.13902,-0.769708,0.0,14.310392,-1.157002,0.0,13.528348,-1.620744,0.0,12.792385,-2.157424,0.0,12.102004,-2.763533,0.0,11.150803,-3.795199,0.0,10.299343,-4.963342,0.0,9.545933,-6.256117,0.0,8.690989,-8.153219,0.0,8.003345,-10.222761,0.0,7.372955,-13.009413,0.0,6.942261,-16.573946,0.0,6.854187,-20.289597,20.0,-3.155518,-20.289597,20.0,-3.386614,-15.095562,20.0,-4.036538,-10.467353,20.0,-4.808852,-7.276754,20.0,-5.63663,-4.871642,20.0,-6.669124,-2.654009,20.0,-7.587893,-1.145182,20.0,-8.638273,0.206863,20.0,-9.415126,1.010264,20.0,-10.255695,1.727689,20.0,-11.162072,2.352623,20.0,-12.136347,2.878547,20.0,-13.180608,3.298944,20.0,-14.296946,3.607298,20.0,-15.487451,3.797089,20.0,-16.754211,3.861801,20.0,-17.835892,3.804884,20.0,-18.884878,3.636767,20.0,-19.896656,3.361397,20.0,-20.866714,2.982723,20.0,-21.790537,2.504694,20.0,-22.663614,1.931257,20.0,-23.48143,1.266363,20.0,-24.239471,0.513958,20.0,-24.933226,-0.322007,20.0,-25.55818,-1.237587,20.0,-26.109821,-2.22883,20.0,-26.7235,-3.661362,20.0,-27.18812,-5.212031,20.0,-27.492987,-6.871475,20.0,-27.582169,-7.739063,20.0,-27.633118,-9.084488,20.0,-27.534592,-11.314365,20.0,-27.197304,-13.789533,20.0,-26.559275,-16.507212,20.0,-25.561604,-19.469328,20.0,-24.151611,-22.684097,20.0,-35.24933,-28.01419,20.0,-36.778576,-23.948456,20.0,-37.986584,-19.508661,20.0,-38.820343,-14.658971,20.0,-39.224186,-10.224437,20.0,-39.38211,-5.711395,20.0,-39.225246,-0.520048,20.0,-38.6266,4.243522,20.0,-37.628933,8.577644,20.0,-36.275024,12.480653,20.0,-35.051537,15.123986,20.0,-33.66976,17.523176,20.0,-32.147747,19.677517,20.0,-30.503536,21.586306,20.0,-28.755175,23.24884,20.0,-26.920704,24.664413,20.0,-25.018167,25.832323,20.0,-23.065615,26.751867,20.0,-21.081083,27.422337};
			return value;
		}
		private double[] getCoordinate_9_71_point_3()
		{
			double[] value = {20.0,-19.08262,27.843033,20.0,-17.751484,27.984386,20.0,-16.42752,28.014206,20.0,-13.895212,27.809511,20.0,-11.579315,27.332561,20.0,-9.470667,26.611834,20.0,-7.560106,25.675806,20.0,-5.838466,24.55295,20.0,-4.296587,23.271748,20.0,-2.925305,21.86067,20.0,-1.715458,20.348198,20.0,-0.337611,18.223057,20.0,0.79125,16.03578,20.0,1.885279,13.317132,20.0,2.789107,10.251437,20.0,3.372284,7.233902,20.0,3.5896,7.233902,20.0,4.230927,9.127302,20.0,5.167855,11.218521,20.0,6.666759,13.853976,20.0,8.215005,16.042578,20.0,10.023395,18.121891,20.0,11.649965,19.64216,20.0,13.430264,20.981926,20.0,14.862958,21.838736,20.0,16.376543,22.545643,20.0,17.96862,23.081917,20.0,19.636799,23.426828,20.0,20.790014,23.54022,20.0,21.97528,23.553207,20.0,23.51245,23.43127,20.0,24.965769,23.174719,20.0,26.337036,22.790993,20.0,27.62805,22.287525,20.0,28.840603,21.671753,20.0,29.976496,20.95111,20.0,31.037521,20.13304,20.0,32.49262,18.739511,20.0,33.78937,17.168589,20.0,34.93385,15.445371,20.0,36.23342,12.954221,20.0,37.287434,10.296426,20.0,38.281513,6.830472,20.0,38.942432,3.313282,20.0,39.25015,0.54072,20.0,39.38211,-2.775894,20.0,39.136147,-7.672698,20.0,38.176563,-14.412845,20.0,36.60137,-21.140371,20.0,35.354473,-24.932285,20.0,34.93313,-25.969929,20.0,34.378204,-27.143097,20.0,25.022186,-22.574692,20.0,26.735443,-16.754368,20.0,27.358845,-13.53262,20.0,27.549263,-11.882367,20.0,27.633514,-9.955597,20.0,27.58365,-8.885306,20.0,27.417538,-7.672693,20.0,27.110388,-6.377816,20.0,26.746468,-5.323045,20.0,26.263731,-4.284811,20.0,25.816074,-3.535487,20.0,25.28909,-2.825736,20.0,24.677427,-2.168529,20.0,23.97573,-1.576839,20.0,23.178648,-1.063639,20.0,22.591625,-0.771518,20.0,21.95824,-0.52389,20.0,20.91777,-0.244282,20.0,20.161547,-0.124705,20.0,18.929382,-0.055191,20.0,17.909412,-0.101603,20.0,16.938028,-0.238499,20.0,16.014732,-0.462371,20.0,15.13902,-0.769708,20.0,14.310392,-1.157002,20.0,13.528348,-1.620744,20.0,12.792385,-2.157424,20.0,12.102004,-2.763533,20.0,11.150803,-3.795199,20.0,10.299343,-4.963342,20.0,9.545933,-6.256117,20.0,8.690989,-8.153219,20.0,8.003345,-10.222761,20.0,7.372955,-13.009413,20.0,6.942261,-16.573946,20.0,6.854187,-20.289597};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_9_72_point_1()
		{
			double[] value = {1.0,1.0,0.0,1.0,0.015442,1.0,0.029323,1.0,0.039073,1.0,0.046628,1.0,0.053893,1.0,0.05914,1.0,0.064225,1.0,0.067544,1.0,0.070827,1.0,0.074096,1.0,0.077385,1.0,0.080728,1.0,0.084168,1.0,0.087749,1.0,0.091516,1.0,0.094733,1.0,0.097888,1.0,0.101003,1.0,0.104096,1.0,0.107185,1.0,0.110287,1.0,0.113418,1.0,0.11659,1.0,0.119817,1.0,0.123109,1.0,0.126478,1.0,0.131107,1.0,0.135915,1.0,0.140926,1.0,0.143517,1.0,0.147515,1.0,0.154145,1.0,0.161564,1.0,0.169855,1.0,0.179139,1.0,0.189565,1.0,0.226131,1.0,0.239032,1.0,0.252698,1.0,0.267313,1.0,0.280539,1.0,0.293951,1.0,0.309377,1.0,0.323636,1.0,0.336846,1.0,0.349116,1.0,0.357767,1.0,0.36599,1.0,0.373824,1.0,0.381307,1.0,0.388473,1.0,0.395355,1.0,0.401985,1.0,0.408395,1.0,0.414617,1.0,0.420682,1.0,0.424658,1.0,0.428592,1.0,0.436137,1.0,0.44316,1.0,0.449779,1.0,0.456098,1.0,0.462202,1.0,0.468157,1.0,0.474001,1.0,0.479753,1.0,0.487276,1.0,0.494586,1.0,0.50329,1.0,0.512783,1.0,0.521911,1.0,0.522556,1.0,0.528494,1.0,0.5353,1.0,0.544305,1.0,0.552267,1.0,0.560452,1.0,0.567065,1.0,0.573682,1.0,0.57864,1.0,0.583602,1.0,0.588592,1.0,0.593651,1.0,0.597093,1.0,0.600613,1.0,0.605193,1.0,0.609576,1.0,0.613806,1.0,0.617921,1.0,0.62196,1.0,0.625956,1.0,0.629935,1.0,0.635919,1.0,0.641969,1.0,0.648113,1.0,0.656458,1.0,0.66495,1.0,0.675659,1.0};
			return value;
		}
		private double[] getTextureCoordinate_9_72_point_2()
		{
			double[] value = {0.686289,1.0,0.694574,1.0,0.704432,1.0,0.718995,1.0,0.739215,1.0,0.759737,1.0,0.771593,1.0,0.774919,1.0,0.778773,1.0,0.809697,1.0,0.827718,1.0,0.837464,1.0,0.842398,1.0,0.848126,1.0,0.851308,1.0,0.854944,1.0,0.858896,1.0,0.86221,1.0,0.865611,1.0,0.868203,1.0,0.870829,1.0,0.873495,1.0,0.876221,1.0,0.879037,1.0,0.880985,1.0,0.883004,1.0,0.886204,1.0,0.888478,1.0,0.892144,1.0,0.895176,1.0,0.89809,1.0,0.900912,1.0,0.903668,1.0,0.906385,1.0,0.909085,1.0,0.91179,1.0,0.914519,1.0,0.918687,1.0,0.92298,1.0,0.927424,1.0,0.933605,1.0,0.940082,1.0,0.948567,1.0,0.959231,1.0,0.97027,1.0,1.0,0.0,0.0,0.0,0.015442,0.0,0.029323,0.0,0.039073,0.0,0.046628,0.0,0.053893,0.0,0.05914,0.0,0.064225,0.0,0.067544,0.0,0.070827,0.0,0.074096,0.0,0.077385,0.0,0.080728,0.0,0.084168,0.0,0.087749,0.0,0.091516,0.0,0.094733,0.0,0.097888,0.0,0.101003,0.0,0.104096,0.0,0.107185,0.0,0.110287,0.0,0.113418,0.0,0.11659,0.0,0.119817,0.0,0.123109,0.0,0.126478,0.0,0.131107,0.0,0.135915,0.0,0.140926,0.0,0.143517,0.0,0.147515,0.0,0.154145,0.0,0.161564,0.0,0.169855,0.0,0.179139,0.0,0.189565,0.0,0.226131,0.0,0.239032,0.0,0.252698,0.0,0.267313,0.0,0.280539,0.0,0.293951,0.0,0.309377,0.0,0.323636,0.0,0.336846,0.0,0.349116,0.0,0.357767,0.0,0.36599,0.0,0.373824,0.0,0.381307,0.0,0.388473,0.0,0.395355,0.0,0.401985,0.0};
			return value;
		}
		private double[] getTextureCoordinate_9_72_point_3()
		{
			double[] value = {0.408395,0.0,0.414617,0.0,0.420682,0.0,0.424658,0.0,0.428592,0.0,0.436137,0.0,0.44316,0.0,0.449779,0.0,0.456098,0.0,0.462202,0.0,0.468157,0.0,0.474001,0.0,0.479753,0.0,0.487276,0.0,0.494586,0.0,0.50329,0.0,0.512783,0.0,0.521911,0.0,0.522556,0.0,0.528494,0.0,0.5353,0.0,0.544305,0.0,0.552267,0.0,0.560452,0.0,0.567065,0.0,0.573682,0.0,0.57864,0.0,0.583602,0.0,0.588592,0.0,0.593651,0.0,0.597093,0.0,0.600613,0.0,0.605193,0.0,0.609576,0.0,0.613806,0.0,0.617921,0.0,0.62196,0.0,0.625956,0.0,0.629935,0.0,0.635919,0.0,0.641969,0.0,0.648113,0.0,0.656458,0.0,0.66495,0.0,0.675659,0.0,0.686289,0.0,0.694574,0.0,0.704432,0.0,0.718995,0.0,0.739215,0.0,0.759737,0.0,0.771593,0.0,0.774919,0.0,0.778773,0.0,0.809697,0.0,0.827718,0.0,0.837464,0.0,0.842398,0.0,0.848126,0.0,0.851308,0.0,0.854944,0.0,0.858896,0.0,0.86221,0.0,0.865611,0.0,0.868203,0.0,0.870829,0.0,0.873495,0.0,0.876221,0.0,0.879037,0.0,0.880985,0.0,0.883004,0.0,0.886204,0.0,0.888478,0.0,0.892144,0.0,0.895176,0.0,0.89809,0.0,0.900912,0.0,0.903668,0.0,0.906385,0.0,0.909085,0.0,0.91179,0.0,0.914519,0.0,0.918687,0.0,0.92298,0.0,0.927424,0.0,0.933605,0.0,0.940082,0.0,0.948567,0.0,0.959231,0.0,0.97027,0.0};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Cap_14_9_76_coordIndex_1()
		{
			int[] value = {143,142,0,-1,142,141,1,-1,142,1,0,-1,141,140,2,-1,141,2,1,-1,140,139,3,-1,140,3,2,-1,139,138,3,-1,138,137,71,-1,138,71,4,-1,138,4,3,-1,137,136,72,-1,137,72,71,-1,136,135,72,-1,135,134,72,-1,134,133,72,-1,133,132,72,-1,132,131,73,-1,132,73,72,-1,131,130,74,-1,131,74,73,-1,130,129,75,-1,130,75,74,-1,129,128,76,-1,129,76,75,-1,128,127,77,-1,128,77,76,-1,127,80,79,-1,127,79,78,-1,127,78,77,-1,127,126,80,-1,126,87,86,-1,126,86,85,-1,126,85,84,-1,126,84,83,-1,126,83,82,-1,126,82,81,-1,126,81,80,-1,126,125,87,-1,125,94,93,-1,125,93,92,-1,125,92,91,-1,125,91,90,-1,125,90,89,-1,125,89,88,-1,125,88,87,-1,125,124,94,-1,124,95,94,-1,124,123,95,-1,123,96,95,-1,123,122,96,-1,122,97,96,-1,122,121,97,-1,121,98,97,-1,121,120,98,-1,120,99,98,-1,120,119,99,-1,119,118,99,-1,118,100,99,-1,118,117,100,-1,117,101,100,-1,117,116,101,-1,116,115,101,-1,115,114,102,-1,115,102,101,-1,114,113,102,-1,113,112,102,-1,112,111,103,-1,112,103,102,-1,111,110,103,-1,110,109,103,-1,109,108,104,-1,109,104,103,-1,108,107,106,-1,108,106,105,-1,108,105,104,-1,71,70,8,-1,71,8,7,-1,71,7,6,-1,71,6,5,-1,71,5,4,-1,70,69,10,-1,70,10,9,-1,70,9,8,-1,69,68,11,-1,69,11,10,-1,68,67,11,-1,67,66,12,-1,67,12,11,-1,66,65,13,-1,66,13,12,-1,65,64,13,-1,64,63,13,-1,63,62,14,-1,63,14,13,-1,62,61,14,-1,61,60,14,-1,60,59,14,-1,59,58,15,-1,59,15,14,-1,58,57,15,-1,57,56,15,-1,56,55,15,-1,55,54,16,-1,55,16,15,-1,54,53,16,-1,53,52,16,-1,52,51,17,-1,52,17,16,-1,51,50,17,-1,50,49,18,-1,50,18,17,-1,49,48,19,-1,49,19,18,-1,48,47,20,-1,48,20,19,-1,47,46,21,-1,47,21,20,-1,46,45,22,-1,46,22,21,-1,45,44,24,-1,45,24,23,-1,45,23,22,-1,44,43,26,-1,44,26,25,-1,44,25,24,-1,43,42,28,-1,43,28,27,-1,43,27,26,-1,42,41,30,-1,42,30,29,-1,42,29,28,-1,41,31,30,-1,41,40,32,-1,41,32,31,-1,40,33,32,-1,40,39,33,-1,39,35,34,-1,39,34,33,-1,39,38,35,-1,38,36,35,-1,38,37,36,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_76_point_1()
		{
			double[] value = {0.0,-3.155518,-20.289597,0.0,-3.386614,-15.095562,0.0,-4.036538,-10.467353,0.0,-4.808852,-7.276754,0.0,-5.63663,-4.871642,0.0,-6.669124,-2.654009,0.0,-7.587893,-1.145182,0.0,-8.638273,0.206863,0.0,-9.415126,1.010264,0.0,-10.255695,1.727689,0.0,-11.162072,2.352623,0.0,-12.136347,2.878547,0.0,-13.180608,3.298944,0.0,-14.296946,3.607298,0.0,-15.487451,3.797089,0.0,-16.754211,3.861801,0.0,-17.835892,3.804884,0.0,-18.884878,3.636767,0.0,-19.896656,3.361397,0.0,-20.866714,2.982723,0.0,-21.790537,2.504694,0.0,-22.663614,1.931257,0.0,-23.48143,1.266363,0.0,-24.239471,0.513958,0.0,-24.933226,-0.322007,0.0,-25.55818,-1.237587,0.0,-26.109821,-2.22883,0.0,-26.7235,-3.661362,0.0,-27.18812,-5.212031,0.0,-27.492987,-6.871475,0.0,-27.582169,-7.739063,0.0,-27.633118,-9.084488,0.0,-27.534592,-11.314365,0.0,-27.197304,-13.789533,0.0,-26.559275,-16.507212,0.0,-25.561604,-19.469328,0.0,-24.151611,-22.684097,0.0,-35.24933,-28.01419,0.0,-36.778576,-23.948456,0.0,-37.986584,-19.508661,0.0,-38.820343,-14.658971,0.0,-39.224186,-10.224437,0.0,-39.38211,-5.711395,0.0,-39.225246,-0.520048,0.0,-38.6266,4.243522,0.0,-37.628933,8.577644,0.0,-36.275024,12.480653,0.0,-35.051537,15.123986,0.0,-33.66976,17.523176,0.0,-32.147747,19.677517,0.0,-30.503536,21.586306,0.0,-28.755175,23.24884,0.0,-26.920704,24.664413,0.0,-25.018167,25.832323,0.0,-23.065615,26.751867,0.0,-21.081083,27.422337,0.0,-19.08262,27.843033,0.0,-17.751484,27.984386,0.0,-16.42752,28.014206,0.0,-13.895212,27.809511,0.0,-11.579315,27.332561,0.0,-9.470667,26.611834,0.0,-7.560106,25.675806,0.0,-5.838466,24.55295,0.0,-4.296587,23.271748,0.0,-2.925305,21.86067,0.0,-1.715458,20.348198,0.0,-0.337611,18.223057,0.0,0.79125,16.03578,0.0,1.885279,13.317132,0.0,2.789107,10.251437,0.0,3.372284,7.233902,0.0,3.5896,7.233902,0.0,4.230927,9.127302,0.0,5.167855,11.218521,0.0,6.666759,13.853976,0.0,8.215005,16.042578,0.0,10.023395,18.121891,0.0,11.649965,19.64216,0.0,13.430264,20.981926,0.0,14.862958,21.838736,0.0,16.376543,22.545643,0.0,17.96862,23.081917,0.0,19.636799,23.426828,0.0,20.790014,23.54022,0.0,21.97528,23.553207,0.0,23.51245,23.43127,0.0,24.965769,23.174719,0.0,26.337036,22.790993,0.0,27.62805,22.287525,0.0,28.840603,21.671753,0.0,29.976496,20.95111,0.0,31.037521,20.13304,0.0,32.49262,18.739511,0.0,33.78937,17.168589,0.0,34.93385,15.445371,0.0,36.23342,12.954221,0.0,37.287434,10.296426,0.0,38.281513,6.830472,0.0,38.942432,3.313282};
			return value;
		}
		private double[] getCoordinate_10_76_point_2()
		{
			double[] value = {0.0,39.25015,0.54072,0.0,39.38211,-2.775894,0.0,39.136147,-7.672698,0.0,38.176563,-14.412845,0.0,36.60137,-21.140371,0.0,35.354473,-24.932285,0.0,34.93313,-25.969929,0.0,34.378204,-27.143097,0.0,25.022186,-22.574692,0.0,26.735443,-16.754368,0.0,27.358845,-13.53262,0.0,27.549263,-11.882367,0.0,27.633514,-9.955597,0.0,27.58365,-8.885306,0.0,27.417538,-7.672693,0.0,27.110388,-6.377816,0.0,26.746468,-5.323045,0.0,26.263731,-4.284811,0.0,25.816074,-3.535487,0.0,25.28909,-2.825736,0.0,24.677427,-2.168529,0.0,23.97573,-1.576839,0.0,23.178648,-1.063639,0.0,22.591625,-0.771518,0.0,21.95824,-0.52389,0.0,20.91777,-0.244282,0.0,20.161547,-0.124705,0.0,18.929382,-0.055191,0.0,17.909412,-0.101603,0.0,16.938028,-0.238499,0.0,16.014732,-0.462371,0.0,15.13902,-0.769708,0.0,14.310392,-1.157002,0.0,13.528348,-1.620744,0.0,12.792385,-2.157424,0.0,12.102004,-2.763533,0.0,11.150803,-3.795199,0.0,10.299343,-4.963342,0.0,9.545933,-6.256117,0.0,8.690989,-8.153219,0.0,8.003345,-10.222761,0.0,7.372955,-13.009413,0.0,6.942261,-16.573946,0.0,6.854187,-20.289597};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Cap_23_9_81_coordIndex_1()
		{
			int[] value = {0,1,142,-1,0,142,143,-1,1,2,141,-1,1,141,142,-1,2,3,140,-1,2,140,141,-1,3,4,138,-1,3,138,139,-1,3,139,140,-1,4,5,71,-1,4,71,138,-1,5,6,71,-1,6,7,71,-1,7,8,71,-1,8,9,70,-1,8,70,71,-1,9,10,70,-1,10,11,69,-1,10,69,70,-1,11,12,67,-1,11,67,68,-1,11,68,69,-1,12,13,66,-1,12,66,67,-1,13,14,63,-1,13,63,64,-1,13,64,65,-1,13,65,66,-1,14,15,59,-1,14,59,60,-1,14,60,61,-1,14,61,62,-1,14,62,63,-1,15,55,56,-1,15,56,57,-1,15,57,58,-1,15,58,59,-1,15,16,55,-1,16,52,53,-1,16,53,54,-1,16,54,55,-1,16,17,52,-1,17,50,51,-1,17,51,52,-1,17,18,50,-1,18,49,50,-1,18,19,49,-1,19,48,49,-1,19,20,48,-1,20,47,48,-1,20,21,47,-1,21,46,47,-1,21,22,46,-1,22,45,46,-1,22,23,45,-1,23,24,45,-1,24,44,45,-1,24,25,44,-1,25,26,44,-1,26,43,44,-1,26,27,43,-1,27,28,43,-1,28,29,42,-1,28,42,43,-1,29,30,42,-1,30,31,41,-1,30,41,42,-1,31,32,41,-1,32,33,40,-1,32,40,41,-1,33,34,39,-1,33,39,40,-1,34,35,39,-1,35,36,38,-1,35,38,39,-1,36,37,38,-1,71,72,137,-1,71,137,138,-1,72,73,132,-1,72,132,133,-1,72,133,134,-1,72,134,135,-1,72,135,136,-1,72,136,137,-1,73,74,131,-1,73,131,132,-1,74,75,130,-1,74,130,131,-1,75,76,129,-1,75,129,130,-1,76,77,128,-1,76,128,129,-1,77,78,127,-1,77,127,128,-1,78,79,127,-1,79,80,127,-1,80,81,126,-1,80,126,127,-1,81,82,126,-1,82,83,126,-1,83,84,126,-1,84,85,126,-1,85,86,126,-1,86,87,126,-1,87,88,125,-1,87,125,126,-1,88,89,125,-1,89,90,125,-1,90,91,125,-1,91,92,125,-1,92,93,125,-1,93,94,125,-1,94,95,124,-1,94,124,125,-1,95,96,123,-1,95,123,124,-1,96,97,122,-1,96,122,123,-1,97,98,121,-1,97,121,122,-1,98,99,120,-1,98,120,121,-1,99,100,118,-1,99,118,119,-1,99,119,120,-1,100,101,117,-1,100,117,118,-1,101,102,115,-1,101,115,116,-1,101,116,117,-1,102,114,115,-1,102,103,112,-1,102,112,113,-1,102,113,114,-1,103,110,111,-1,103,111,112,-1,103,104,109,-1,103,109,110,-1,104,105,108,-1,104,108,109,-1,105,106,108,-1,106,107,108,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_81_point_1()
		{
			double[] value = {20.0,-3.155518,-20.289597,20.0,-3.386614,-15.095562,20.0,-4.036538,-10.467353,20.0,-4.808852,-7.276754,20.0,-5.63663,-4.871642,20.0,-6.669124,-2.654009,20.0,-7.587893,-1.145182,20.0,-8.638273,0.206863,20.0,-9.415126,1.010264,20.0,-10.255695,1.727689,20.0,-11.162072,2.352623,20.0,-12.136347,2.878547,20.0,-13.180608,3.298944,20.0,-14.296946,3.607298,20.0,-15.487451,3.797089,20.0,-16.754211,3.861801,20.0,-17.835892,3.804884,20.0,-18.884878,3.636767,20.0,-19.896656,3.361397,20.0,-20.866714,2.982723,20.0,-21.790537,2.504694,20.0,-22.663614,1.931257,20.0,-23.48143,1.266363,20.0,-24.239471,0.513958,20.0,-24.933226,-0.322007,20.0,-25.55818,-1.237587,20.0,-26.109821,-2.22883,20.0,-26.7235,-3.661362,20.0,-27.18812,-5.212031,20.0,-27.492987,-6.871475,20.0,-27.582169,-7.739063,20.0,-27.633118,-9.084488,20.0,-27.534592,-11.314365,20.0,-27.197304,-13.789533,20.0,-26.559275,-16.507212,20.0,-25.561604,-19.469328,20.0,-24.151611,-22.684097,20.0,-35.24933,-28.01419,20.0,-36.778576,-23.948456,20.0,-37.986584,-19.508661,20.0,-38.820343,-14.658971,20.0,-39.224186,-10.224437,20.0,-39.38211,-5.711395,20.0,-39.225246,-0.520048,20.0,-38.6266,4.243522,20.0,-37.628933,8.577644,20.0,-36.275024,12.480653,20.0,-35.051537,15.123986,20.0,-33.66976,17.523176,20.0,-32.147747,19.677517,20.0,-30.503536,21.586306,20.0,-28.755175,23.24884,20.0,-26.920704,24.664413,20.0,-25.018167,25.832323,20.0,-23.065615,26.751867,20.0,-21.081083,27.422337,20.0,-19.08262,27.843033,20.0,-17.751484,27.984386,20.0,-16.42752,28.014206,20.0,-13.895212,27.809511,20.0,-11.579315,27.332561,20.0,-9.470667,26.611834,20.0,-7.560106,25.675806,20.0,-5.838466,24.55295,20.0,-4.296587,23.271748,20.0,-2.925305,21.86067,20.0,-1.715458,20.348198,20.0,-0.337611,18.223057,20.0,0.79125,16.03578,20.0,1.885279,13.317132,20.0,2.789107,10.251437,20.0,3.372284,7.233902,20.0,3.5896,7.233902,20.0,4.230927,9.127302,20.0,5.167855,11.218521,20.0,6.666759,13.853976,20.0,8.215005,16.042578,20.0,10.023395,18.121891,20.0,11.649965,19.64216,20.0,13.430264,20.981926,20.0,14.862958,21.838736,20.0,16.376543,22.545643,20.0,17.96862,23.081917,20.0,19.636799,23.426828,20.0,20.790014,23.54022,20.0,21.97528,23.553207,20.0,23.51245,23.43127,20.0,24.965769,23.174719,20.0,26.337036,22.790993,20.0,27.62805,22.287525,20.0,28.840603,21.671753,20.0,29.976496,20.95111,20.0,31.037521,20.13304,20.0,32.49262,18.739511,20.0,33.78937,17.168589,20.0,34.93385,15.445371,20.0,36.23342,12.954221,20.0,37.287434,10.296426,20.0,38.281513,6.830472,20.0,38.942432,3.313282};
			return value;
		}
		private double[] getCoordinate_10_81_point_2()
		{
			double[] value = {20.0,39.25015,0.54072,20.0,39.38211,-2.775894,20.0,39.136147,-7.672698,20.0,38.176563,-14.412845,20.0,36.60137,-21.140371,20.0,35.354473,-24.932285,20.0,34.93313,-25.969929,20.0,34.378204,-27.143097,20.0,25.022186,-22.574692,20.0,26.735443,-16.754368,20.0,27.358845,-13.53262,20.0,27.549263,-11.882367,20.0,27.633514,-9.955597,20.0,27.58365,-8.885306,20.0,27.417538,-7.672693,20.0,27.110388,-6.377816,20.0,26.746468,-5.323045,20.0,26.263731,-4.284811,20.0,25.816074,-3.535487,20.0,25.28909,-2.825736,20.0,24.677427,-2.168529,20.0,23.97573,-1.576839,20.0,23.178648,-1.063639,20.0,22.591625,-0.771518,20.0,21.95824,-0.52389,20.0,20.91777,-0.244282,20.0,20.161547,-0.124705,20.0,18.929382,-0.055191,20.0,17.909412,-0.101603,20.0,16.938028,-0.238499,20.0,16.014732,-0.462371,20.0,15.13902,-0.769708,20.0,14.310392,-1.157002,20.0,13.528348,-1.620744,20.0,12.792385,-2.157424,20.0,12.102004,-2.763533,20.0,11.150803,-3.795199,20.0,10.299343,-4.963342,20.0,9.545933,-6.256117,20.0,8.690989,-8.153219,20.0,8.003345,-10.222761,20.0,7.372955,-13.009413,20.0,6.942261,-16.573946,20.0,6.854187,-20.289597};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_7_8_87_coordIndex_1()
		{
			int[] value = {0,1,70,69,-1,1,2,71,70,-1,2,3,72,71,-1,3,4,73,72,-1,4,5,74,73,-1,5,6,75,74,-1,6,7,76,75,-1,7,8,77,76,-1,8,9,78,77,-1,9,10,79,78,-1,10,11,80,79,-1,11,12,81,80,-1,12,13,82,81,-1,13,14,83,82,-1,14,15,84,83,-1,15,16,85,84,-1,16,17,86,85,-1,17,18,87,86,-1,18,19,88,87,-1,19,20,89,88,-1,20,21,90,89,-1,21,22,91,90,-1,22,23,92,91,-1,23,24,93,92,-1,24,25,94,93,-1,25,26,95,94,-1,26,27,96,95,-1,27,28,97,96,-1,28,29,98,97,-1,29,30,99,98,-1,30,31,100,99,-1,31,32,101,100,-1,32,33,102,101,-1,33,34,103,102,-1,34,0,69,103,-1,35,36,105,104,-1,36,37,106,105,-1,37,38,107,106,-1,38,39,108,107,-1,39,40,109,108,-1,40,41,110,109,-1,41,42,111,110,-1,42,43,112,111,-1,43,44,113,112,-1,44,45,114,113,-1,45,46,115,114,-1,46,47,116,115,-1,47,48,117,116,-1,48,49,118,117,-1,49,50,119,118,-1,50,51,120,119,-1,51,52,121,120,-1,52,53,122,121,-1,53,54,123,122,-1,54,55,124,123,-1,55,56,125,124,-1,56,57,126,125,-1,57,58,127,126,-1,58,59,128,127,-1,59,60,129,128,-1,60,61,130,129,-1,61,62,131,130,-1,62,63,132,131,-1,63,64,133,132,-1,64,65,134,133,-1,65,66,135,134,-1,66,67,136,135,-1,67,68,137,136,-1,68,35,104,137,-1};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getFACESET_Path_7_8_87_texCoordIndex_1()
		{
			int[] value = {1,2,73,72,-1,2,3,74,73,-1,3,4,75,74,-1,4,5,76,75,-1,5,6,77,76,-1,6,7,78,77,-1,7,8,79,78,-1,8,9,80,79,-1,9,10,81,80,-1,10,11,82,81,-1,11,12,83,82,-1,12,13,84,83,-1,13,14,85,84,-1,14,15,86,85,-1,15,16,87,86,-1,16,17,88,87,-1,17,18,89,88,-1,18,19,90,89,-1,19,20,91,90,-1,20,21,92,91,-1,21,22,93,92,-1,22,23,94,93,-1,23,24,95,94,-1,24,25,96,95,-1,25,26,97,96,-1,26,27,98,97,-1,27,28,99,98,-1,28,29,100,99,-1,29,30,101,100,-1,30,31,102,101,-1,31,32,103,102,-1,32,33,104,103,-1,33,34,105,104,-1,34,35,106,105,-1,35,0,71,106,-1,37,38,109,108,-1,38,39,110,109,-1,39,40,111,110,-1,40,41,112,111,-1,41,42,113,112,-1,42,43,114,113,-1,43,44,115,114,-1,44,45,116,115,-1,45,46,117,116,-1,46,47,118,117,-1,47,48,119,118,-1,48,49,120,119,-1,49,50,121,120,-1,50,51,122,121,-1,51,52,123,122,-1,52,53,124,123,-1,53,54,125,124,-1,54,55,126,125,-1,55,56,127,126,-1,56,57,128,127,-1,57,58,129,128,-1,58,59,130,129,-1,59,60,131,130,-1,60,61,132,131,-1,61,62,133,132,-1,62,63,134,133,-1,63,64,135,134,-1,64,65,136,135,-1,65,66,137,136,-1,66,67,138,137,-1,67,68,139,138,-1,68,69,140,139,-1,69,70,141,140,-1,70,36,107,141,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_9_87_point_1()
		{
			double[] value = {0.0,37.371796,-35.236786,0.0,-37.371796,-35.236786,0.0,-37.371796,-7.047394,0.0,-37.136547,-1.723737,0.0,-36.424683,3.448344,0.0,-35.227016,8.415711,0.0,-33.534367,13.125232,0.0,-31.934525,16.456194,0.0,-30.047218,19.589813,0.0,-27.868572,22.50367,0.0,-25.394714,25.175348,0.0,-22.621769,27.582434,0.0,-19.545864,29.702507,0.0,-16.163128,31.513151,0.0,-12.469683,32.991955,0.0,-8.461657,34.116493,0.0,-4.135179,34.864353,0.0,-1.072027,35.142593,0.0,2.135529,35.236816,0.0,6.441649,35.011864,0.0,10.664772,34.323025,0.0,13.747457,33.489353,0.0,16.734055,32.374104,0.0,19.603392,30.96842,0.0,22.3343,29.263462,0.0,24.905602,27.250378,0.0,27.29613,24.920322,0.0,29.484709,22.264444,0.0,31.450169,19.2739,0.0,33.171337,15.939837,0.0,34.627045,12.253409,0.0,35.796116,8.20577,0.0,36.872406,2.231739,0.0,37.189663,-1.008538,0.0,37.371796,-6.192902,0.0,23.384521,-12.705597,0.0,23.384521,-6.192902,0.0,23.30077,-4.441388,0.0,23.051268,-2.728964,0.0,22.63865,-1.064765,0.0,22.06555,0.542074,0.0,21.334593,2.082419,0.0,20.448416,3.547132,0.0,19.40965,4.927081,0.0,18.220926,6.213129,0.0,16.884878,7.396141,0.0,15.404136,8.466982,0.0,13.781333,9.416517,0.0,12.0191,10.235612,0.0,10.12007,10.915129,0.0,7.379782,11.588244,0.0,5.171793,11.906558,0.0,2.029114,12.064911,0.0,-3.178211,11.800709,0.0,-7.165257,11.173283,0.0,-10.099787,10.401545,0.0,-12.788715,9.387503,0.0,-14.633778,8.466578,0.0,-16.323574,7.407097,0.0,-17.850769,6.208092,0.0,-19.208027,4.868595,0.0,-20.388012,3.387638,0.0,-21.383389,1.764252,0.0,-22.186823,-0.00253,0.0,-22.790977,-1.913678,0.0,-23.188517,-3.970159,0.0,-23.335136,-5.422365,0.0,-23.384491,-6.93988,0.0,-23.384491,-12.705597,20.0,37.371796,-35.236786,20.0,-37.371796,-35.236786,20.0,-37.371796,-7.047394,20.0,-37.136547,-1.723737,20.0,-36.424683,3.448344,20.0,-35.227016,8.415711,20.0,-33.534367,13.125232,20.0,-31.934525,16.456194,20.0,-30.047218,19.589813,20.0,-27.868572,22.50367,20.0,-25.394714,25.175348,20.0,-22.621769,27.582434,20.0,-19.545864,29.702507,20.0,-16.163128,31.513151,20.0,-12.469683,32.991955,20.0,-8.461657,34.116493,20.0,-4.135179,34.864353,20.0,-1.072027,35.142593,20.0,2.135529,35.236816,20.0,6.441649,35.011864,20.0,10.664772,34.323025,20.0,13.747457,33.489353,20.0,16.734055,32.374104,20.0,19.603392,30.96842,20.0,22.3343,29.263462,20.0,24.905602,27.250378,20.0,27.29613,24.920322,20.0,29.484709,22.264444,20.0,31.450169,19.2739,20.0,33.171337,15.939837,20.0,34.627045,12.253409};
			return value;
		}
		private double[] getCoordinate_9_87_point_2()
		{
			double[] value = {20.0,35.796116,8.20577,20.0,36.872406,2.231739,20.0,37.189663,-1.008538,20.0,37.371796,-6.192902,20.0,23.384521,-12.705597,20.0,23.384521,-6.192902,20.0,23.30077,-4.441388,20.0,23.051268,-2.728964,20.0,22.63865,-1.064765,20.0,22.06555,0.542074,20.0,21.334593,2.082419,20.0,20.448416,3.547132,20.0,19.40965,4.927081,20.0,18.220926,6.213129,20.0,16.884878,7.396141,20.0,15.404136,8.466982,20.0,13.781333,9.416517,20.0,12.0191,10.235612,20.0,10.12007,10.915129,20.0,7.379782,11.588244,20.0,5.171793,11.906558,20.0,2.029114,12.064911,20.0,-3.178211,11.800709,20.0,-7.165257,11.173283,20.0,-10.099787,10.401545,20.0,-12.788715,9.387503,20.0,-14.633778,8.466578,20.0,-16.323574,7.407097,20.0,-17.850769,6.208092,20.0,-19.208027,4.868595,20.0,-20.388012,3.387638,20.0,-21.383389,1.764252,20.0,-22.186823,-0.00253,20.0,-22.790977,-1.913678,20.0,-23.188517,-3.970159,20.0,-23.335136,-5.422365,20.0,-23.384491,-6.93988,20.0,-23.384491,-12.705597};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_9_88_point_1()
		{
			double[] value = {1.0,1.0,0.0,1.0,0.288822,1.0,0.397751,1.0,0.418342,1.0,0.438517,1.0,0.458261,1.0,0.477599,1.0,0.491878,1.0,0.506014,1.0,0.520073,1.0,0.534143,1.0,0.548332,1.0,0.562768,1.0,0.577594,1.0,0.592967,1.0,0.609053,1.0,0.626019,1.0,0.637904,1.0,0.650304,1.0,0.666967,1.0,0.683501,1.0,0.695841,1.0,0.70816,1.0,0.720507,1.0,0.732947,1.0,0.745566,1.0,0.758466,1.0,0.771764,1.0,0.785592,1.0,0.800091,1.0,0.815407,1.0,0.831687,1.0,0.855143,1.0,0.867724,1.0,0.887769,1.0,1.0,1.0,0.0,1.0,0.051534,1.0,0.065409,1.0,0.079102,1.0,0.092669,1.0,0.106168,1.0,0.119659,1.0,0.133205,1.0,0.146872,1.0,0.16073,1.0,0.17485,1.0,0.18931,1.0,0.204187,1.0,0.219564,1.0,0.235524,1.0,0.257852,1.0,0.275504,1.0,0.300403,1.0,0.34166,1.0,0.373597,1.0,0.397607,1.0,0.420346,1.0,0.436663,1.0,0.452445,1.0,0.467809,1.0,0.482898,1.0,0.497881,1.0,0.512949,1.0,0.528307,1.0,0.544167,1.0,0.560741,1.0,0.57229,1.0,0.584304,1.0,0.629927,1.0,1.0,0.0,0.0,0.0,0.288822,0.0,0.397751,0.0,0.418342,0.0,0.438517,0.0,0.458261,0.0,0.477599,0.0,0.491878,0.0,0.506014,0.0,0.520073,0.0,0.534143,0.0,0.548332,0.0,0.562768,0.0,0.577594,0.0,0.592967,0.0,0.609053,0.0,0.626019,0.0,0.637904,0.0,0.650304,0.0,0.666967,0.0,0.683501,0.0,0.695841,0.0,0.70816,0.0,0.720507,0.0,0.732947,0.0,0.745566,0.0,0.758466,0.0,0.771764,0.0};
			return value;
		}
		private double[] getTextureCoordinate_9_88_point_2()
		{
			double[] value = {0.785592,0.0,0.800091,0.0,0.815407,0.0,0.831687,0.0,0.855143,0.0,0.867724,0.0,0.887769,0.0,1.0,0.0,0.0,0.0,0.051534,0.0,0.065409,0.0,0.079102,0.0,0.092669,0.0,0.106168,0.0,0.119659,0.0,0.133205,0.0,0.146872,0.0,0.16073,0.0,0.17485,0.0,0.18931,0.0,0.204187,0.0,0.219564,0.0,0.235524,0.0,0.257852,0.0,0.275504,0.0,0.300403,0.0,0.34166,0.0,0.373597,0.0,0.397607,0.0,0.420346,0.0,0.436663,0.0,0.452445,0.0,0.467809,0.0,0.482898,0.0,0.497881,0.0,0.512949,0.0,0.528307,0.0,0.544167,0.0,0.560741,0.0,0.57229,0.0,0.584304,0.0,0.629927,0.0};
			return value;
		}



		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_1' coordIndex field, scene-graph level=8, element #23, 400 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_1_8_23_coordIndex()
		{
			MFInt32 FACESET_Path_1_8_23_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_1_8_23_coordIndex_1()));
			return FACESET_Path_1_8_23_coordIndex;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_1' texCoordIndex field, scene-graph level=8, element #23, 400 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_1_8_23_texCoordIndex()
		{
			MFInt32 FACESET_Path_1_8_23_texCoordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_1_8_23_texCoordIndex_1()));
			return FACESET_Path_1_8_23_texCoordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #23, 480 total numbers made up of 160 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_23_point()
		{
			MFVec3f Coordinate_9_23_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_9_23_point_1()))
				.append(new MFVec3f(getCoordinate_9_23_point_2()));
			return Coordinate_9_23_point;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=9, element #24, 324 total numbers made up of 162 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_9_24_point()
		{
			MFVec2f TextureCoordinate_9_24_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_9_24_point_1()))
				.append(new MFVec2f(getTextureCoordinate_9_24_point_2()));
			return TextureCoordinate_9_24_point;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #28, 240 total numbers made up of 80 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_28_point()
		{
			MFVec3f Coordinate_10_28_point = new MFVec3f(new double[] {0.0,21.178467,-41.147198,0.0,21.12664,-40.164177,0.0,21.020084,-39.475796,0.0,20.855932,-38.8275,0.0,20.634548,-38.217655,0.0,20.356314,-37.644634,0.0,20.021597,-37.106808,0.0,19.630774,-36.60254,0.0,19.184216,-36.130196,0.0,18.682297,-35.688152,0.0,17.9276,-35.143063,0.0,17.076033,-34.64507,0.0,15.876696,-34.082905,0.0,14.810403,-33.676727,0.0,13.345459,-33.217094,0.0,-24.175537,-20.935318,0.0,-24.175537,-13.780046,0.0,10.34787,-0.240997,0.0,-24.175537,12.330303,0.0,-24.175537,19.487003,0.0,13.249268,32.6379,0.0,16.314926,33.869556,0.0,17.629301,34.55615,0.0,18.500906,35.12066,0.0,19.225481,35.707726,0.0,19.679565,36.167828,0.0,20.06264,36.648804,0.0,20.379713,37.154156,0.0,20.635798,37.687397,0.0,20.835905,38.252037,0.0,20.98505,38.85158,0.0,21.11329,39.711334,0.0,21.163008,40.405968,0.0,21.178467,41.1472,0.0,24.175568,41.1472,0.0,24.175568,20.550003,0.0,21.178467,20.550003,0.0,21.091251,22.840458,0.0,20.900711,24.112778,0.0,20.709892,24.841082,0.0,20.448227,25.52607,0.0,20.228977,25.951796,0.0,19.97007,26.347965,0.0,19.668236,26.710457,0.0,19.32021,27.035152,0.0,18.92272,27.317924,0.0,18.472504,27.554657,0.0,17.966291,27.741224,0.0,17.400814,27.873508,0.0,16.772804,27.947386,0.0,16.078995,27.958735,0.0,14.907757,27.8495,0.0,13.570088,27.576397,0.0,11.508575,26.933304,0.0,-10.249725,19.583202,0.0,-10.249725,19.389904,0.0,24.175568,7.109604,0.0,24.175568,-0.144797,0.0,-9.670135,-13.296157,0.0,-9.670135,-13.489027,0.0,12.668671,-20.355728,0.0,14.88086,-20.985714,0.0,16.346033,-21.235563,0.0,17.282059,-21.28134,0.0,17.833817,-21.246788,0.0,18.331062,-21.161657,0.0,18.776617,-21.027212,0.0,19.173302,-20.844713,0.0,19.523941,-20.615425,0.0,19.831354,-20.34061,0.0,20.098366,-20.021534,0.0,20.327799,-19.659458,0.0,20.522474,-19.255644,0.0,20.685213,-18.81136,0.0,20.875618,-18.071808,0.0,21.04406,-16.955877,0.0,21.149061,-15.366466,0.0,21.178467,-13.199966,0.0,24.175568,-13.199966,0.0,24.175568,-41.147198});
			return Coordinate_10_28_point;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #33, 240 total numbers made up of 80 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_33_point()
		{
			MFVec3f Coordinate_10_33_point = new MFVec3f(new double[] {20.0,21.178467,-41.147198,20.0,21.12664,-40.164177,20.0,21.020084,-39.475796,20.0,20.855932,-38.8275,20.0,20.634548,-38.217655,20.0,20.356314,-37.644634,20.0,20.021597,-37.106808,20.0,19.630774,-36.60254,20.0,19.184216,-36.130196,20.0,18.682297,-35.688152,20.0,17.9276,-35.143063,20.0,17.076033,-34.64507,20.0,15.876696,-34.082905,20.0,14.810403,-33.676727,20.0,13.345459,-33.217094,20.0,-24.175537,-20.935318,20.0,-24.175537,-13.780046,20.0,10.34787,-0.240997,20.0,-24.175537,12.330303,20.0,-24.175537,19.487003,20.0,13.249268,32.6379,20.0,16.314926,33.869556,20.0,17.629301,34.55615,20.0,18.500906,35.12066,20.0,19.225481,35.707726,20.0,19.679565,36.167828,20.0,20.06264,36.648804,20.0,20.379713,37.154156,20.0,20.635798,37.687397,20.0,20.835905,38.252037,20.0,20.98505,38.85158,20.0,21.11329,39.711334,20.0,21.163008,40.405968,20.0,21.178467,41.1472,20.0,24.175568,41.1472,20.0,24.175568,20.550003,20.0,21.178467,20.550003,20.0,21.091251,22.840458,20.0,20.900711,24.112778,20.0,20.709892,24.841082,20.0,20.448227,25.52607,20.0,20.228977,25.951796,20.0,19.97007,26.347965,20.0,19.668236,26.710457,20.0,19.32021,27.035152,20.0,18.92272,27.317924,20.0,18.472504,27.554657,20.0,17.966291,27.741224,20.0,17.400814,27.873508,20.0,16.772804,27.947386,20.0,16.078995,27.958735,20.0,14.907757,27.8495,20.0,13.570088,27.576397,20.0,11.508575,26.933304,20.0,-10.249725,19.583202,20.0,-10.249725,19.389904,20.0,24.175568,7.109604,20.0,24.175568,-0.144797,20.0,-9.670135,-13.296157,20.0,-9.670135,-13.489027,20.0,12.668671,-20.355728,20.0,14.88086,-20.985714,20.0,16.346033,-21.235563,20.0,17.282059,-21.28134,20.0,17.833817,-21.246788,20.0,18.331062,-21.161657,20.0,18.776617,-21.027212,20.0,19.173302,-20.844713,20.0,19.523941,-20.615425,20.0,19.831354,-20.34061,20.0,20.098366,-20.021534,20.0,20.327799,-19.659458,20.0,20.522474,-19.255644,20.0,20.685213,-18.81136,20.0,20.875618,-18.071808,20.0,21.04406,-16.955877,20.0,21.149061,-15.366466,20.0,21.178467,-13.199966,20.0,24.175568,-13.199966,20.0,24.175568,-41.147198});
			return Coordinate_10_33_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_2' coordIndex field, scene-graph level=8, element #39, 620 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_2_8_39_coordIndex()
		{
			MFInt32 FACESET_Path_2_8_39_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_2_8_39_coordIndex_1()));
			return FACESET_Path_2_8_39_coordIndex;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_2' texCoordIndex field, scene-graph level=8, element #39, 620 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_2_8_39_texCoordIndex()
		{
			MFInt32 FACESET_Path_2_8_39_texCoordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_2_8_39_texCoordIndex_1()));
			return FACESET_Path_2_8_39_texCoordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #39, 744 total numbers made up of 248 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_39_point()
		{
			MFVec3f Coordinate_9_39_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_9_39_point_1()))
				.append(new MFVec3f(getCoordinate_9_39_point_2()))
				.append(new MFVec3f(getCoordinate_9_39_point_3()));
			return Coordinate_9_39_point;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=9, element #40, 504 total numbers made up of 252 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_9_40_point()
		{
			MFVec2f TextureCoordinate_9_40_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_9_40_point_1()))
				.append(new MFVec2f(getTextureCoordinate_9_40_point_2()))
				.append(new MFVec2f(getTextureCoordinate_9_40_point_3()));
			return TextureCoordinate_9_40_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Cap_11' coordIndex field, scene-graph level=9, element #44, 496 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Cap_11_9_44_coordIndex()
		{
			MFInt32 FACESET_Cap_11_9_44_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Cap_11_9_44_coordIndex_1()));
			return FACESET_Cap_11_9_44_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #44, 372 total numbers made up of 124 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_44_point()
		{
			MFVec3f Coordinate_10_44_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_44_point_1()))
				.append(new MFVec3f(getCoordinate_10_44_point_2()));
			return Coordinate_10_44_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Cap_24' coordIndex field, scene-graph level=9, element #49, 496 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Cap_24_9_49_coordIndex()
		{
			MFInt32 FACESET_Cap_24_9_49_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Cap_24_9_49_coordIndex_1()));
			return FACESET_Cap_24_9_49_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #49, 372 total numbers made up of 124 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_49_point()
		{
			MFVec3f Coordinate_10_49_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_49_point_1()))
				.append(new MFVec3f(getCoordinate_10_49_point_2()));
			return Coordinate_10_49_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_5' coordIndex field, scene-graph level=8, element #55, 685 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_5_8_55_coordIndex()
		{
			MFInt32 FACESET_Path_5_8_55_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_5_8_55_coordIndex_1()));
			return FACESET_Path_5_8_55_coordIndex;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_5' texCoordIndex field, scene-graph level=8, element #55, 685 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_5_8_55_texCoordIndex()
		{
			MFInt32 FACESET_Path_5_8_55_texCoordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_5_8_55_texCoordIndex_1()));
			return FACESET_Path_5_8_55_texCoordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #55, 822 total numbers made up of 274 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_55_point()
		{
			MFVec3f Coordinate_9_55_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_9_55_point_1()))
				.append(new MFVec3f(getCoordinate_9_55_point_2()))
				.append(new MFVec3f(getCoordinate_9_55_point_3()));
			return Coordinate_9_55_point;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=9, element #56, 556 total numbers made up of 278 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_9_56_point()
		{
			MFVec2f TextureCoordinate_9_56_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_9_56_point_1()))
				.append(new MFVec2f(getTextureCoordinate_9_56_point_2()))
				.append(new MFVec2f(getTextureCoordinate_9_56_point_3()));
			return TextureCoordinate_9_56_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Cap_1' coordIndex field, scene-graph level=9, element #60, 548 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Cap_1_9_60_coordIndex()
		{
			MFInt32 FACESET_Cap_1_9_60_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Cap_1_9_60_coordIndex_1()));
			return FACESET_Cap_1_9_60_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #60, 411 total numbers made up of 137 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_60_point()
		{
			MFVec3f Coordinate_10_60_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_60_point_1()))
				.append(new MFVec3f(getCoordinate_10_60_point_2()));
			return Coordinate_10_60_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Cap_25' coordIndex field, scene-graph level=9, element #65, 548 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Cap_25_9_65_coordIndex()
		{
			MFInt32 FACESET_Cap_25_9_65_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Cap_25_9_65_coordIndex_1()));
			return FACESET_Cap_25_9_65_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #65, 411 total numbers made up of 137 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_65_point()
		{
			MFVec3f Coordinate_10_65_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_65_point_1()))
				.append(new MFVec3f(getCoordinate_10_65_point_2()));
			return Coordinate_10_65_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_6' coordIndex field, scene-graph level=8, element #71, 720 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_6_8_71_coordIndex()
		{
			MFInt32 FACESET_Path_6_8_71_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_6_8_71_coordIndex_1()));
			return FACESET_Path_6_8_71_coordIndex;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_6' texCoordIndex field, scene-graph level=8, element #71, 720 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_6_8_71_texCoordIndex()
		{
			MFInt32 FACESET_Path_6_8_71_texCoordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_6_8_71_texCoordIndex_1()));
			return FACESET_Path_6_8_71_texCoordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #71, 864 total numbers made up of 288 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_71_point()
		{
			MFVec3f Coordinate_9_71_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_9_71_point_1()))
				.append(new MFVec3f(getCoordinate_9_71_point_2()))
				.append(new MFVec3f(getCoordinate_9_71_point_3()));
			return Coordinate_9_71_point;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=9, element #72, 580 total numbers made up of 290 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_9_72_point()
		{
			MFVec2f TextureCoordinate_9_72_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_9_72_point_1()))
				.append(new MFVec2f(getTextureCoordinate_9_72_point_2()))
				.append(new MFVec2f(getTextureCoordinate_9_72_point_3()));
			return TextureCoordinate_9_72_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Cap_14' coordIndex field, scene-graph level=9, element #76, 568 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Cap_14_9_76_coordIndex()
		{
			MFInt32 FACESET_Cap_14_9_76_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Cap_14_9_76_coordIndex_1()));
			return FACESET_Cap_14_9_76_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #76, 432 total numbers made up of 144 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_76_point()
		{
			MFVec3f Coordinate_10_76_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_76_point_1()))
				.append(new MFVec3f(getCoordinate_10_76_point_2()));
			return Coordinate_10_76_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Cap_23' coordIndex field, scene-graph level=9, element #81, 568 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Cap_23_9_81_coordIndex()
		{
			MFInt32 FACESET_Cap_23_9_81_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Cap_23_9_81_coordIndex_1()));
			return FACESET_Cap_23_9_81_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #81, 432 total numbers made up of 144 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_81_point()
		{
			MFVec3f Coordinate_10_81_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_81_point_1()))
				.append(new MFVec3f(getCoordinate_10_81_point_2()));
			return Coordinate_10_81_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_7' coordIndex field, scene-graph level=8, element #87, 345 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_7_8_87_coordIndex()
		{
			MFInt32 FACESET_Path_7_8_87_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_7_8_87_coordIndex_1()));
			return FACESET_Path_7_8_87_coordIndex;
		}
		/** Large attribute array: IndexedFaceSet DEF='FACESET_Path_7' texCoordIndex field, scene-graph level=8, element #87, 345 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getFACESET_Path_7_8_87_texCoordIndex()
		{
			MFInt32 FACESET_Path_7_8_87_texCoordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getFACESET_Path_7_8_87_texCoordIndex_1()));
			return FACESET_Path_7_8_87_texCoordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #87, 414 total numbers made up of 138 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_87_point()
		{
			MFVec3f Coordinate_9_87_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_9_87_point_1()))
				.append(new MFVec3f(getCoordinate_9_87_point_2()));
			return Coordinate_9_87_point;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=9, element #88, 284 total numbers made up of 142 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_9_88_point()
		{
			MFVec2f TextureCoordinate_9_88_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_9_88_point_1()))
				.append(new MFVec2f(getTextureCoordinate_9_88_point_2()));
			return TextureCoordinate_9_88_point;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #92, 207 total numbers made up of 69 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_92_point()
		{
			MFVec3f Coordinate_10_92_point = new MFVec3f(new double[] {0.0,37.371796,-35.236786,0.0,-37.371796,-35.236786,0.0,-37.371796,-7.047394,0.0,-37.136547,-1.723737,0.0,-36.424683,3.448344,0.0,-35.227016,8.415711,0.0,-33.534367,13.125232,0.0,-31.934525,16.456194,0.0,-30.047218,19.589813,0.0,-27.868572,22.50367,0.0,-25.394714,25.175348,0.0,-22.621769,27.582434,0.0,-19.545864,29.702507,0.0,-16.163128,31.513151,0.0,-12.469683,32.991955,0.0,-8.461657,34.116493,0.0,-4.135179,34.864353,0.0,-1.072027,35.142593,0.0,2.135529,35.236816,0.0,6.441649,35.011864,0.0,10.664772,34.323025,0.0,13.747457,33.489353,0.0,16.734055,32.374104,0.0,19.603392,30.96842,0.0,22.3343,29.263462,0.0,24.905602,27.250378,0.0,27.29613,24.920322,0.0,29.484709,22.264444,0.0,31.450169,19.2739,0.0,33.171337,15.939837,0.0,34.627045,12.253409,0.0,35.796116,8.20577,0.0,36.872406,2.231739,0.0,37.189663,-1.008538,0.0,37.371796,-6.192902,0.0,23.384521,-12.705597,0.0,23.384521,-6.192902,0.0,23.30077,-4.441388,0.0,23.051268,-2.728964,0.0,22.63865,-1.064765,0.0,22.06555,0.542074,0.0,21.334593,2.082419,0.0,20.448416,3.547132,0.0,19.40965,4.927081,0.0,18.220926,6.213129,0.0,16.884878,7.396141,0.0,15.404136,8.466982,0.0,13.781333,9.416517,0.0,12.0191,10.235612,0.0,10.12007,10.915129,0.0,7.379782,11.588244,0.0,5.171793,11.906558,0.0,2.029114,12.064911,0.0,-3.178211,11.800709,0.0,-7.165257,11.173283,0.0,-10.099787,10.401545,0.0,-12.788715,9.387503,0.0,-14.633778,8.466578,0.0,-16.323574,7.407097,0.0,-17.850769,6.208092,0.0,-19.208027,4.868595,0.0,-20.388012,3.387638,0.0,-21.383389,1.764252,0.0,-22.186823,-0.00253,0.0,-22.790977,-1.913678,0.0,-23.188517,-3.970159,0.0,-23.335136,-5.422365,0.0,-23.384491,-6.93988,0.0,-23.384491,-12.705597});
			return Coordinate_10_92_point;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #97, 207 total numbers made up of 69 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_97_point()
		{
			MFVec3f Coordinate_10_97_point = new MFVec3f(new double[] {20.0,37.371796,-35.236786,20.0,-37.371796,-35.236786,20.0,-37.371796,-7.047394,20.0,-37.136547,-1.723737,20.0,-36.424683,3.448344,20.0,-35.227016,8.415711,20.0,-33.534367,13.125232,20.0,-31.934525,16.456194,20.0,-30.047218,19.589813,20.0,-27.868572,22.50367,20.0,-25.394714,25.175348,20.0,-22.621769,27.582434,20.0,-19.545864,29.702507,20.0,-16.163128,31.513151,20.0,-12.469683,32.991955,20.0,-8.461657,34.116493,20.0,-4.135179,34.864353,20.0,-1.072027,35.142593,20.0,2.135529,35.236816,20.0,6.441649,35.011864,20.0,10.664772,34.323025,20.0,13.747457,33.489353,20.0,16.734055,32.374104,20.0,19.603392,30.96842,20.0,22.3343,29.263462,20.0,24.905602,27.250378,20.0,27.29613,24.920322,20.0,29.484709,22.264444,20.0,31.450169,19.2739,20.0,33.171337,15.939837,20.0,34.627045,12.253409,20.0,35.796116,8.20577,20.0,36.872406,2.231739,20.0,37.189663,-1.008538,20.0,37.371796,-6.192902,20.0,23.384521,-12.705597,20.0,23.384521,-6.192902,20.0,23.30077,-4.441388,20.0,23.051268,-2.728964,20.0,22.63865,-1.064765,20.0,22.06555,0.542074,20.0,21.334593,2.082419,20.0,20.448416,3.547132,20.0,19.40965,4.927081,20.0,18.220926,6.213129,20.0,16.884878,7.396141,20.0,15.404136,8.466982,20.0,13.781333,9.416517,20.0,12.0191,10.235612,20.0,10.12007,10.915129,20.0,7.379782,11.588244,20.0,5.171793,11.906558,20.0,2.029114,12.064911,20.0,-3.178211,11.800709,20.0,-7.165257,11.173283,20.0,-10.099787,10.401545,20.0,-12.788715,9.387503,20.0,-14.633778,8.466578,20.0,-16.323574,7.407097,20.0,-17.850769,6.208092,20.0,-19.208027,4.868595,20.0,-20.388012,3.387638,20.0,-21.383389,1.764252,20.0,-22.186823,-0.00253,20.0,-22.790977,-1.913678,20.0,-23.188517,-3.970159,20.0,-23.335136,-5.422365,20.0,-23.384491,-6.93988,20.0,-23.384491,-12.705597});
			return Coordinate_10_97_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Web3dLogo model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Web3dLogo().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Web3dOutreach.Web3dLogo\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Web3dOutreach.Web3dLogo self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Web3dOutreach/Web3dLogo_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Web3dOutreach/Web3dLogo_JavaExport.x3d"; 
                String filenameX3DV = "Web3dOutreach/Web3dLogo_JavaExport.x3dv"; 
                String filenameJSON = "Web3dOutreach/Web3dLogo_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
