####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python ColladaLogo.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.2',
  head=head(
    children=[
    meta(content='ColladaLogo.x3d',name='title'),
    meta(content='Collada logo converted from Collada dae format to X3D, using Xj3D functionality embedded in X3D-Edit importers.',name='description'),
    meta(content='TODO *enter name of original model author here*',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='12 August 2009',name='created'),
    meta(content='12 August 2009',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='images/Collada_100px_Nov14_250_74.png',name='Image'),
    meta(content='https://www.khronos.org/collada',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Web3dOutreach/ColladaLogo.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='ColladaLogo.x3d'),
    Transform(DEF='COLLADA_UNITS',scale=(0.01,0.01,0.01),
      children=[
      Transform(DEF='object0',
        children=[
        Transform(DEF='object0-rotateZ',
          children=[
          Transform(DEF='object0-rotateY',
            children=[
            Transform(DEF='object0-rotateX',rotation=(1.0,0.0,0.0,-1.5707964),
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(DEF='Default-fx',diffuseColor=(0.0,0.0,0.0),shininess=0.78125)),
                geometry=IndexedFaceSet(coordIndex=[1,0,2,-1,4,3,5,-1,243,242,7,-1,7,242,6,-1,244,245,8,-1,245,9,8,-1,244,8,243,-1,243,8,7,-1,245,9,246,-1,246,9,10,-1,245,246,9,-1,9,246,10,-1,245,243,9,-1,9,243,7,-1,248,247,12,-1,12,247,11,-1,249,250,13,-1,250,14,13,-1,249,13,248,-1,248,13,12,-1,250,14,251,-1,251,14,15,-1,250,251,14,-1,14,251,15,-1,250,248,14,-1,14,248,12,-1,364,128,362,-1,362,128,126,-1,364,363,128,-1,363,127,128,-1,127,363,129,-1,363,365,129,-1,368,132,366,-1,366,132,130,-1,367,366,131,-1,131,366,130,-1,362,126,369,-1,369,126,133,-1,369,133,370,-1,370,133,134,-1,365,371,129,-1,129,371,135,-1,370,134,372,-1,372,134,136,-1,372,136,373,-1,373,136,137,-1,371,374,135,-1,135,374,138,-1,373,137,375,-1,375,137,139,-1,375,139,376,-1,376,139,140,-1,374,377,138,-1,138,377,141,-1,376,140,378,-1,378,140,142,-1,379,378,143,-1,143,378,142,-1,380,379,144,-1,144,379,143,-1,381,145,368,-1,368,145,132,-1,382,367,146,-1,146,367,131,-1,383,147,381,-1,381,147,145,-1,384,382,148,-1,148,382,146,-1,385,149,383,-1,383,149,147,-1,386,150,385,-1,385,150,149,-1,387,384,151,-1,151,384,148,-1,388,152,386,-1,386,152,150,-1,389,153,388,-1,388,153,152,-1,390,387,154,-1,154,387,151,-1,391,155,389,-1,389,155,153,-1,391,392,155,-1,155,392,156,-1,392,393,156,-1,156,393,157,-1,393,394,157,-1,157,394,158,-1,395,380,159,-1,159,380,144,-1,394,396,158,-1,158,396,160,-1,397,395,161,-1,161,395,159,-1,396,398,160,-1,160,398,162,-1,399,397,163,-1,163,397,161,-1,400,399,164,-1,164,399,163,-1,401,400,165,-1,165,400,164,-1,402,401,166,-1,166,401,165,-1,403,402,167,-1,167,402,166,-1,404,403,168,-1,168,403,167,-1,398,404,162,-1,162,404,168,-1,405,169,377,-1,377,169,141,-1,406,170,405,-1,405,170,169,-1,407,171,406,-1,406,171,170,-1,408,172,407,-1,407,172,171,-1,409,173,408,-1,408,173,172,-1,410,174,409,-1,409,174,173,-1,411,175,410,-1,410,175,174,-1,412,176,411,-1,411,176,175,-1,413,177,412,-1,412,177,176,-1,414,178,413,-1,413,178,177,-1,415,179,414,-1,414,179,178,-1,416,180,415,-1,415,180,179,-1,390,154,417,-1,417,154,181,-1,417,181,416,-1,416,181,180,-1,420,184,418,-1,418,184,182,-1,420,419,184,-1,419,183,184,-1,422,186,419,-1,419,186,183,-1,422,421,186,-1,421,185,186,-1,421,423,185,-1,185,423,187,-1,187,423,182,-1,423,418,182,-1,426,190,424,-1,424,190,188,-1,190,426,189,-1,426,425,189,-1,428,192,425,-1,425,192,189,-1,192,428,191,-1,428,427,191,-1,427,429,191,-1,191,429,193,-1,429,424,193,-1,424,188,193,-1,431,430,195,-1,195,430,194,-1,433,197,432,-1,432,197,196,-1,198,434,195,-1,434,431,195,-1,430,435,194,-1,435,199,194,-1,200,436,196,-1,436,432,196,-1,437,201,435,-1,435,201,199,-1,433,438,197,-1,438,202,197,-1,439,436,203,-1,203,436,200,-1,440,204,437,-1,437,204,201,-1,434,198,441,-1,441,198,205,-1,442,206,440,-1,440,206,204,-1,443,207,442,-1,442,207,206,-1,438,444,202,-1,202,444,208,-1,441,205,445,-1,445,205,209,-1,445,209,446,-1,446,209,210,-1,447,211,443,-1,443,211,207,-1,446,210,448,-1,448,210,212,-1,449,213,447,-1,447,213,211,-1,448,212,450,-1,450,212,214,-1,450,214,451,-1,451,214,215,-1,453,217,452,-1,452,217,216,-1,451,215,453,-1,453,215,217,-1,452,216,454,-1,454,216,218,-1,454,218,449,-1,449,218,213,-1,455,439,219,-1,219,439,203,-1,456,455,220,-1,220,455,219,-1,457,456,221,-1,221,456,220,-1,459,458,223,-1,223,458,222,-1,458,460,222,-1,222,460,224,-1,460,461,224,-1,224,461,225,-1,461,462,225,-1,225,462,226,-1,462,463,226,-1,226,463,227,-1,463,464,227,-1,227,464,228,-1,464,465,228,-1,228,465,229,-1,465,457,229,-1,229,457,221,-1,444,459,208,-1,208,459,223,-1,468,232,466,-1,466,232,230,-1,467,231,468,-1,468,231,232,-1,469,470,233,-1,470,234,233,-1,246,469,10,-1,10,469,233,-1,245,9,470,-1,470,9,234,-1,244,466,8,-1,8,466,230,-1,246,10,467,-1,467,10,231,-1,6,242,235,-1,242,471,235,-1,243,7,471,-1,471,7,235,-1,244,8,243,-1,243,8,7,-1,474,238,472,-1,472,238,236,-1,473,237,474,-1,474,237,238,-1,475,476,239,-1,476,240,239,-1,251,475,15,-1,15,475,239,-1,250,14,476,-1,476,14,240,-1,249,472,13,-1,13,472,236,-1,251,15,473,-1,473,15,237,-1,11,247,241,-1,247,477,241,-1,248,12,477,-1,477,12,241,-1,249,13,248,-1,248,13,12,-1,245,243,9,-1,9,243,7,-1,250,248,14,-1,14,248,12,-1,128,127,126,-1,363,364,362,-1,126,127,129,-1,363,362,365,-1,132,131,130,-1,367,368,366,-1,126,129,133,-1,365,362,369,-1,133,129,134,-1,365,369,370,-1,129,135,134,-1,371,365,370,-1,134,135,136,-1,371,370,372,-1,136,135,137,-1,371,372,373,-1,135,138,137,-1,374,371,373,-1,137,138,139,-1,374,373,375,-1,139,138,140,-1,374,375,376,-1,138,141,140,-1,377,374,376,-1,140,141,142,-1,377,376,378,-1,141,143,142,-1,379,377,378,-1,141,144,143,-1,380,377,379,-1,132,145,131,-1,381,368,367,-1,145,146,131,-1,382,381,367,-1,145,147,146,-1,383,381,382,-1,147,148,146,-1,384,383,382,-1,147,149,148,-1,385,383,384,-1,149,150,148,-1,386,385,384,-1,150,151,148,-1,387,386,384,-1,150,152,151,-1,388,386,387,-1,152,153,151,-1,389,388,387,-1,153,154,151,-1,390,389,387,-1,153,155,154,-1,391,389,390,-1,155,156,154,-1,392,391,390,-1,156,157,154,-1,393,392,390,-1,157,158,154,-1,394,393,390,-1,141,159,144,-1,395,377,380,-1,158,160,154,-1,396,394,390,-1,141,161,159,-1,397,377,395,-1,154,160,162,-1,396,390,398,-1,141,163,161,-1,399,377,397,-1,165,164,163,-1,400,401,399,-1,166,165,163,-1,401,402,399,-1,167,166,163,-1,402,403,399,-1,168,167,163,-1,403,404,399,-1,162,168,163,-1,404,398,399,-1,169,163,141,-1,399,405,377,-1,170,163,169,-1,399,406,405,-1,171,163,170,-1,399,407,406,-1,171,172,163,-1,408,407,399,-1,172,173,163,-1,409,408,399,-1,173,162,163,-1,398,409,399,-1,174,162,173,-1,398,410,409,-1,175,162,174,-1,398,411,410,-1,176,162,175,-1,398,412,411,-1,177,162,176,-1,398,413,412,-1,178,162,177,-1,398,414,413,-1,179,162,178,-1,398,415,414,-1,180,162,179,-1,398,416,415,-1,181,154,162,-1,390,417,398,-1,180,181,162,-1,417,416,398,-1,184,183,182,-1,419,420,418,-1,186,185,183,-1,421,422,419,-1,183,185,187,-1,421,419,423,-1,183,187,182,-1,423,419,418,-1,190,189,188,-1,425,426,424,-1,192,191,189,-1,427,428,425,-1,189,191,193,-1,427,425,429,-1,188,189,193,-1,425,424,429,-1,196,195,194,-1,431,432,430,-1,197,195,196,-1,431,433,432,-1,198,195,197,-1,431,434,433,-1,199,196,194,-1,432,435,430,-1,200,196,199,-1,432,436,435,-1,201,200,199,-1,436,437,435,-1,202,198,197,-1,434,438,433,-1,203,200,201,-1,436,439,437,-1,204,203,201,-1,439,440,437,-1,205,198,202,-1,434,441,438,-1,206,203,204,-1,439,442,440,-1,207,203,206,-1,439,443,442,-1,205,202,208,-1,438,441,444,-1,209,205,208,-1,441,445,444,-1,210,209,208,-1,445,446,444,-1,211,203,207,-1,439,447,443,-1,212,210,208,-1,446,448,444,-1,211,213,203,-1,449,447,439,-1,212,208,214,-1,444,448,450,-1,214,208,215,-1,444,450,451,-1,217,215,216,-1,451,453,452,-1,216,215,218,-1,451,452,454,-1,218,215,213,-1,451,454,449,-1,213,219,203,-1,455,449,439,-1,213,220,219,-1,456,449,455,-1,213,221,220,-1,457,449,456,-1,213,215,221,-1,451,449,457,-1,223,222,215,-1,458,459,451,-1,222,224,215,-1,460,458,451,-1,215,224,225,-1,460,451,461,-1,215,225,226,-1,461,451,462,-1,215,226,227,-1,462,451,463,-1,215,227,228,-1,463,451,464,-1,215,228,229,-1,464,451,465,-1,215,229,221,-1,465,451,457,-1,208,223,215,-1,459,444,451,-1,232,231,230,-1,467,468,466,-1,234,10,233,-1,246,470,469,-1,9,10,234,-1,246,245,470,-1,231,8,230,-1,244,467,466,-1,10,235,231,-1,471,246,467,-1,6,235,10,-1,471,242,246,-1,235,8,231,-1,244,471,467,-1,7,8,235,-1,244,243,471,-1,238,237,236,-1,473,474,472,-1,240,15,239,-1,251,476,475,-1,14,15,240,-1,251,250,476,-1,237,13,236,-1,249,473,472,-1,15,241,237,-1,477,251,473,-1,11,241,15,-1,477,247,251,-1,241,13,237,-1,249,477,473,-1,12,13,241,-1,249,248,477,-1,8,9,7,-1,245,244,243,-1,9,6,10,-1,242,245,246,-1,9,7,6,-1,243,245,242,-1,13,14,12,-1,250,249,248,-1,14,11,15,-1,247,250,251,-1,14,12,11,-1,248,250,247,-1],normalIndex=[0,1,2,-1,3,4,5,-1,7,8,6,-1,6,8,9,-1,10,11,13,-1,11,12,13,-1,15,16,14,-1,14,16,17,-1,19,20,18,-1,18,20,21,-1,23,24,22,-1,22,24,25,-1,27,28,26,-1,26,28,29,-1,31,32,30,-1,30,32,33,-1,34,35,37,-1,35,36,37,-1,39,40,38,-1,38,40,41,-1,43,44,42,-1,42,44,45,-1,47,48,46,-1,46,48,49,-1,51,52,50,-1,50,52,53,-1,495,496,494,-1,494,496,497,-1,498,499,501,-1,499,500,501,-1,502,503,505,-1,503,504,505,-1,507,508,506,-1,506,508,509,-1,511,512,510,-1,510,512,513,-1,515,516,514,-1,514,516,517,-1,519,520,518,-1,518,520,521,-1,523,524,522,-1,522,524,525,-1,527,528,526,-1,526,528,529,-1,531,532,530,-1,530,532,533,-1,535,536,534,-1,534,536,537,-1,539,540,538,-1,538,540,541,-1,543,544,542,-1,542,544,545,-1,547,548,546,-1,546,548,549,-1,551,552,550,-1,550,552,553,-1,555,556,554,-1,554,556,557,-1,559,560,558,-1,558,560,561,-1,563,564,562,-1,562,564,565,-1,567,568,566,-1,566,568,569,-1,571,572,570,-1,570,572,573,-1,575,576,574,-1,574,576,577,-1,579,580,578,-1,578,580,581,-1,583,584,582,-1,582,584,585,-1,587,588,586,-1,586,588,589,-1,591,592,590,-1,590,592,593,-1,595,596,594,-1,594,596,597,-1,599,600,598,-1,598,600,601,-1,603,604,602,-1,602,604,605,-1,607,608,606,-1,606,608,609,-1,611,612,610,-1,610,612,613,-1,615,616,614,-1,614,616,617,-1,619,620,618,-1,618,620,621,-1,623,624,622,-1,622,624,625,-1,627,628,626,-1,626,628,629,-1,631,632,630,-1,630,632,633,-1,635,636,634,-1,634,636,637,-1,639,640,638,-1,638,640,641,-1,643,644,642,-1,642,644,645,-1,647,648,646,-1,646,648,649,-1,651,652,650,-1,650,652,653,-1,655,656,654,-1,654,656,657,-1,659,660,658,-1,658,660,661,-1,663,664,662,-1,662,664,665,-1,667,668,666,-1,666,668,669,-1,671,672,670,-1,670,672,673,-1,675,676,674,-1,674,676,677,-1,679,680,678,-1,678,680,681,-1,683,684,682,-1,682,684,685,-1,687,688,686,-1,686,688,689,-1,691,692,690,-1,690,692,693,-1,695,696,694,-1,694,696,697,-1,699,700,698,-1,698,700,701,-1,703,704,702,-1,702,704,705,-1,707,708,706,-1,706,708,709,-1,711,712,710,-1,710,712,713,-1,715,716,714,-1,714,716,717,-1,719,720,718,-1,718,720,721,-1,722,723,725,-1,723,724,725,-1,727,728,726,-1,726,728,729,-1,730,731,733,-1,731,732,733,-1,735,736,734,-1,734,736,737,-1,738,739,741,-1,739,740,741,-1,743,744,742,-1,742,744,745,-1,746,747,749,-1,747,748,749,-1,751,752,750,-1,750,752,753,-1,754,755,757,-1,755,756,757,-1,759,760,758,-1,758,760,761,-1,762,763,765,-1,763,764,765,-1,767,768,766,-1,766,768,769,-1,771,772,770,-1,770,772,773,-1,774,775,777,-1,775,776,777,-1,778,779,781,-1,779,780,781,-1,782,783,785,-1,783,784,785,-1,787,788,786,-1,786,788,789,-1,790,791,793,-1,791,792,793,-1,795,796,794,-1,794,796,797,-1,799,800,798,-1,798,800,801,-1,803,804,802,-1,802,804,805,-1,807,808,806,-1,806,808,809,-1,811,812,810,-1,810,812,813,-1,815,816,814,-1,814,816,817,-1,819,820,818,-1,818,820,821,-1,823,824,822,-1,822,824,825,-1,827,828,826,-1,826,828,829,-1,831,832,830,-1,830,832,833,-1,835,836,834,-1,834,836,837,-1,839,840,838,-1,838,840,841,-1,843,844,842,-1,842,844,845,-1,847,848,846,-1,846,848,849,-1,851,852,850,-1,850,852,853,-1,855,856,854,-1,854,856,857,-1,859,860,858,-1,858,860,861,-1,863,864,862,-1,862,864,865,-1,867,868,866,-1,866,868,869,-1,871,872,870,-1,870,872,873,-1,875,876,874,-1,874,876,877,-1,879,880,878,-1,878,880,881,-1,883,884,882,-1,882,884,885,-1,887,888,886,-1,886,888,889,-1,891,892,890,-1,890,892,893,-1,895,896,894,-1,894,896,897,-1,899,900,898,-1,898,900,901,-1,903,904,902,-1,902,904,905,-1,907,908,906,-1,906,908,909,-1,911,912,910,-1,910,912,913,-1,915,916,914,-1,914,916,917,-1,918,919,921,-1,919,920,921,-1,923,924,922,-1,922,924,925,-1,927,928,926,-1,926,928,929,-1,931,932,930,-1,930,932,933,-1,935,936,934,-1,934,936,937,-1,938,939,941,-1,939,940,941,-1,943,944,942,-1,942,944,945,-1,947,948,946,-1,946,948,949,-1,951,952,950,-1,950,952,953,-1,955,956,954,-1,954,956,957,-1,958,959,961,-1,959,960,961,-1,963,964,962,-1,962,964,965,-1,967,968,966,-1,966,968,969,-1,971,972,970,-1,970,972,973,-1,975,976,974,-1,974,976,977,-1,978,979,981,-1,979,980,981,-1,983,984,982,-1,982,984,985,-1,987,988,986,-1,986,988,989,-1,991,992,990,-1,990,992,993,-1,995,996,994,-1,994,996,997,-1,1634,1635,1636,-1,1637,1638,1639,-1,1640,1641,1642,-1,1643,1644,1645,-1,1646,1647,1648,-1,1649,1650,1651,-1,1652,1653,1654,-1,1655,1656,1657,-1,1658,1659,1660,-1,1661,1662,1663,-1,1664,1665,1666,-1,1667,1668,1669,-1,1670,1671,1672,-1,1673,1674,1675,-1,1676,1677,1678,-1,1679,1680,1681,-1,1682,1683,1684,-1,1685,1686,1687,-1,1688,1689,1690,-1,1691,1692,1693,-1,1694,1695,1696,-1,1697,1698,1699,-1,1700,1701,1702,-1,1703,1704,1705,-1,1706,1707,1708,-1,1709,1710,1711,-1,1712,1713,1714,-1,1715,1716,1717,-1,1718,1719,1720,-1,1721,1722,1723,-1,1724,1725,1726,-1,1727,1728,1729,-1,1730,1731,1732,-1,1733,1734,1735,-1,1736,1737,1738,-1,1739,1740,1741,-1,1742,1743,1744,-1,1745,1746,1747,-1,1748,1749,1750,-1,1751,1752,1753,-1,1754,1755,1756,-1,1757,1758,1759,-1,1760,1761,1762,-1,1763,1764,1765,-1,1766,1767,1768,-1,1769,1770,1771,-1,1772,1773,1774,-1,1775,1776,1777,-1,1778,1779,1780,-1,1781,1782,1783,-1,1784,1785,1786,-1,1787,1788,1789,-1,1790,1791,1792,-1,1793,1794,1795,-1,1796,1797,1798,-1,1799,1800,1801,-1,1802,1803,1804,-1,1805,1806,1807,-1,1808,1809,1810,-1,1811,1812,1813,-1,1814,1815,1816,-1,1817,1818,1819,-1,1820,1821,1822,-1,1823,1824,1825,-1,1826,1827,1828,-1,1829,1830,1831,-1,1832,1833,1834,-1,1835,1836,1837,-1,1838,1839,1840,-1,1841,1842,1843,-1,1844,1845,1846,-1,1847,1848,1849,-1,1850,1851,1852,-1,1853,1854,1855,-1,1856,1857,1858,-1,1859,1860,1861,-1,1862,1863,1864,-1,1865,1866,1867,-1,1868,1869,1870,-1,1871,1872,1873,-1,1874,1875,1876,-1,1877,1878,1879,-1,1880,1881,1882,-1,1883,1884,1885,-1,1886,1887,1888,-1,1889,1890,1891,-1,1892,1893,1894,-1,1895,1896,1897,-1,1898,1899,1900,-1,1901,1902,1903,-1,1904,1905,1906,-1,1907,1908,1909,-1,1910,1911,1912,-1,1913,1914,1915,-1,1916,1917,1918,-1,1919,1920,1921,-1,1922,1923,1924,-1,1925,1926,1927,-1,1928,1929,1930,-1,1931,1932,1933,-1,1934,1935,1936,-1,1937,1938,1939,-1,1940,1941,1942,-1,1943,1944,1945,-1,1946,1947,1948,-1,1949,1950,1951,-1,1952,1953,1954,-1,1955,1956,1957,-1,1958,1959,1960,-1,1961,1962,1963,-1,1964,1965,1966,-1,1967,1968,1969,-1,1970,1971,1972,-1,1973,1974,1975,-1,1976,1977,1978,-1,1979,1980,1981,-1,1982,1983,1984,-1,1985,1986,1987,-1,1988,1989,1990,-1,1991,1992,1993,-1,1994,1995,1996,-1,1997,1998,1999,-1,2000,2001,2002,-1,2003,2004,2005,-1,2006,2007,2008,-1,2009,2010,2011,-1,2012,2013,2014,-1,2015,2016,2017,-1,2018,2019,2020,-1,2021,2022,2023,-1,2024,2025,2026,-1,2027,2028,2029,-1,2030,2031,2032,-1,2033,2034,2035,-1,2036,2037,2038,-1,2039,2040,2041,-1,2042,2043,2044,-1,2045,2046,2047,-1,2048,2049,2050,-1,2051,2052,2053,-1,2054,2055,2056,-1,2057,2058,2059,-1,2060,2061,2062,-1,2063,2064,2065,-1,2066,2067,2068,-1,2069,2070,2071,-1,2072,2073,2074,-1,2075,2076,2077,-1,2078,2079,2080,-1,2081,2082,2083,-1,2084,2085,2086,-1,2087,2088,2089,-1,2090,2091,2092,-1,2093,2094,2095,-1,2096,2097,2098,-1,2099,2100,2101,-1,2102,2103,2104,-1,2105,2106,2107,-1,2108,2109,2110,-1,2111,2112,2113,-1,2114,2115,2116,-1,2117,2118,2119,-1,2120,2121,2122,-1,2123,2124,2125,-1,2126,2127,2128,-1,2129,2130,2131,-1,2132,2133,2134,-1,2135,2136,2137,-1,2138,2139,2140,-1,2141,2142,2143,-1,2144,2145,2146,-1,2147,2148,2149,-1,2150,2151,2152,-1,2153,2154,2155,-1,2156,2157,2158,-1,2159,2160,2161,-1,2162,2163,2164,-1,2165,2166,2167,-1,2168,2169,2170,-1,2171,2172,2173,-1,2174,2175,2176,-1,2177,2178,2179,-1,2180,2181,2182,-1,2183,2184,2185,-1,2186,2187,2188,-1,2189,2190,2191,-1,2192,2193,2194,-1,2195,2196,2197,-1,2198,2199,2200,-1,2201,2202,2203,-1,2204,2205,2206,-1,2207,2208,2209,-1,2210,2211,2212,-1,2213,2214,2215,-1,2216,2217,2218,-1,2219,2220,2221,-1,2222,2223,2224,-1,2225,2226,2227,-1,2228,2229,2230,-1,2231,2232,2233,-1,2234,2235,2236,-1,2237,2238,2239,-1,2240,2241,2242,-1,2243,2244,2245,-1,2246,2247,2248,-1,2249,2250,2251,-1,2252,2253,2254,-1,2255,2256,2257,-1,2258,2259,2260,-1,2261,2262,2263,-1,2264,2265,2266,-1,2267,2268,2269,-1,2270,2271,2272,-1,2273,2274,2275,-1,2276,2277,2278,-1,2279,2280,2281,-1,2282,2283,2284,-1,2285,2286,2287,-1,2288,2289,2290,-1,2291,2292,2293,-1,2294,2295,2296,-1,2297,2298,2299,-1,2300,2301,2302,-1,2303,2304,2305,-1,2306,2307,2308,-1,2309,2310,2311,-1,2312,2313,2314,-1,2315,2316,2317,-1,2318,2319,2320,-1,2321,2322,2323,-1,2324,2325,2326,-1,2327,2328,2329,-1,2330,2331,2332,-1,2333,2334,2335,-1,2336,2337,2338,-1,2339,2340,2341,-1,2342,2343,2344,-1,2345,2346,2347,-1,2348,2349,2350,-1,2351,2352,2353,-1],
                  coord=Coordinate(DEF='polySurfaceShape1-positions',point=[(0.967682,0.0,0.287481),(1.12915,0.0,0.287481),(1.0459,0.0,0.110938),(2.27968,0.0,0.287481),(2.44115,0.0,0.287481),(2.3579,0.0,0.110938),(1.13819,0.0,-0.15186),(1.0459,0.0,0.110938),(0.967682,0.0,0.287481),(1.12915,0.0,0.287481),(1.17931,0.0,-0.269223),(2.45019,0.0,-0.15186),(2.3579,0.0,0.110938),(2.27968,0.0,0.287481),(2.44115,0.0,0.287481),(2.49131,0.0,-0.269223),(-0.428437,0.0,0.112491),(-0.476374,0.0,0.352627),(-0.428832,0.0,0.327999),(-0.602188,0.0,0.408385),(-0.781866,0.0,0.469072),(-1.88291,0.0,-0.103123),(-1.92213,0.0,-0.040892),(-1.93953,0.0,0.019172),(-1.82226,0.0,-0.159647),(-1.74449,0.0,-0.209801),(-1.94407,0.0,0.080764),(-1.65389,0.0,-0.252923),(-0.884276,0.0,0.493076),(-0.991,0.0,0.508487),(-1.93447,0.0,0.142956),(-1.90948,0.0,0.204819),(-1.86783,0.0,0.265425),(-1.80827,0.0,0.323849),(-1.72952,0.0,0.379161),(-1.63034,0.0,0.430435),(-1.48564,0.0,0.477022),(-1.3215,0.0,0.504733),(-1.15194,0.0,0.514809),(-0.428612,0.0,0.097999),(-0.562522,0.0,0.204476),(-1.24933,0.0,-0.34184),(-1.34819,0.0,-0.333471),(-1.45144,0.0,-0.31542),(-1.55478,0.0,-0.28835),(-1.34992,0.0,-0.324065),(-1.24377,0.0,-0.340395),(-0.629447,0.0,0.248404),(-0.708151,0.0,0.292169),(-0.793265,0.0,0.328194),(-0.894446,0.0,0.35572),(-1.02135,0.0,0.373985),(-1.11377,0.0,0.380492),(-1.26499,0.0,0.370445),(-1.3632,0.0,0.352312),(-1.43948,0.0,0.328276),(-1.54228,0.0,0.285758),(-1.61509,0.0,0.246199),(-1.67678,0.0,0.202047),(-1.73991,0.0,0.143023),(-1.76937,0.0,0.101187),(-1.7896,0.0,0.060133),(-1.79926,0.0,0.015166),(-1.797,0.0,-0.038411),(-1.78414,0.0,-0.079632),(-1.76324,0.0,-0.116439),(-1.73096,0.0,-0.152733),(-1.68394,0.0,-0.192416),(-1.63383,0.0,-0.224535),(-1.53819,0.0,-0.269699),(-1.44581,0.0,-0.301687),(-1.91876,0.0,-0.380324),(-1.96935,0.0,-0.35769),(-1.99745,0.0,-0.142787),(-1.78608,0.0,-0.430803),(-1.59905,0.0,-0.484006),(-0.502036,0.0,0.011701),(-0.574233,0.0,0.131346),(-0.527113,0.0,0.070885),(-0.641994,0.0,0.185247),(-0.72602,0.0,0.232102),(-0.489599,0.0,-0.049534),(-0.821934,0.0,0.271425),(-1.49381,0.0,-0.503778),(-0.508159,0.0,-0.174661),(-0.49118,0.0,-0.111947),(-0.541912,0.0,-0.236799),(-0.593818,0.0,-0.297485),(-0.665258,0.0,-0.355844),(-0.757607,0.0,-0.411),(-0.895979,0.0,-0.463318),(-1.05617,0.0,-0.497636),(-1.22403,0.0,-0.514587),(-1.38537,0.0,-0.514809),(-1.85185,0.0,-0.229055),(-1.99911,0.0,-0.128334),(-1.03192,0.0,0.325528),(-1.23694,0.0,0.343663),(-1.13724,0.0,0.339335),(-0.92536,0.0,0.302729),(-1.13431,0.0,0.329999),(-1.24231,0.0,0.341973),(-1.77944,0.0,-0.270151),(-1.69529,0.0,-0.3106),(-1.60577,0.0,-0.343055),(-1.5013,0.0,-0.366385),(-1.37235,0.0,-0.379457),(-1.27933,0.0,-0.382172),(-1.12979,0.0,-0.36599),(-1.03413,0.0,-0.343952),(-0.961125,0.0,-0.316873),(-0.864047,0.0,-0.270278),(-0.796513,0.0,-0.227857),(-0.74064,0.0,-0.181313),(-0.685258,0.0,-0.119916),(-0.661235,0.0,-0.077004),(-0.646327,0.0,-0.035241),(-0.642476,0.0,0.010001),(-0.651625,0.0,0.063355),(-0.669751,0.0,0.103928),(-0.695315,0.0,0.139776),(-0.732174,0.0,0.174652),(-0.784185,0.0,0.21231),(-0.838295,0.0,0.242301),(-0.939501,0.0,0.283442),(-1.03577,0.0,0.311581),(-2.05263,0.0,-0.216715),(-2.19415,0.0,-0.152865),(-2.04169,0.0,-0.152865),(-2.21108,0.0,-0.217719),(-2.0477,0.0,0.046744),(-2.20018,0.0,0.046744),(-2.05999,0.0,0.105341),(-2.07299,0.0,-0.273957),(-2.10211,0.0,-0.324004),(-2.2438,0.0,-0.268467),(-2.13936,0.0,-0.366268),(-2.18409,0.0,-0.400163),(-2.29233,0.0,-0.301537),(-2.23564,0.0,-0.425101),(-2.29338,0.0,-0.440494),(-2.35665,0.0,-0.313354),(-2.35665,0.0,-0.445756),(-2.43543,0.0,-0.438241),(-2.50519,0.0,-0.416668),(-2.08187,0.0,0.15685),(-2.21785,0.0,0.096385),(-2.1123,0.0,0.201045),(-2.25284,0.0,0.13615),(-2.15026,0.0,0.237706),(-2.19471,0.0,0.266608),(-2.30061,0.0,0.162559),(-2.24462,0.0,0.287528),(-2.29894,0.0,0.300244),(-2.35665,0.0,0.172135),(-2.35665,0.0,0.304532),(-2.43543,0.0,0.297006),(-2.50519,0.0,0.27535),(-2.56547,0.0,0.240952),(-2.56547,0.0,-0.382495),(-2.61582,0.0,0.195199),(-2.61582,0.0,-0.337178),(-2.65579,0.0,0.139477),(-2.65579,0.0,-0.282175),(-2.6849,0.0,-0.218944),(-2.7027,0.0,-0.148942),(-2.70874,0.0,-0.073626),(-2.7027,0.0,0.003677),(-2.6849,0.0,0.075174),(-2.40562,0.0,-0.307948),(-2.44673,0.0,-0.292681),(-2.48038,0.0,-0.268973),(-2.50699,0.0,-0.238249),(-2.52697,0.0,-0.201929),(-2.54074,0.0,-0.161437),(-2.55125,0.0,-0.073626),(-2.54074,0.0,0.017672),(-2.52697,0.0,0.059237),(-2.50699,0.0,0.096275),(-2.48038,0.0,0.127437),(-2.44673,0.0,0.151368),(-2.40562,0.0,0.166718),(0.122955,0.0,-0.428695),(-0.226112,0.0,-0.296313),(0.122955,0.0,-0.296313),(-0.383593,0.0,0.287481),(-0.226112,0.0,0.287481),(-0.383593,0.0,-0.428695),(0.662877,0.0,-0.428695),(0.313808,0.0,-0.296313),(0.662877,0.0,-0.296313),(0.156329,0.0,0.287481),(0.313808,0.0,0.287481),(0.156329,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.43125,0.0,0.287481),(1.58874,0.0,-0.296313),(1.58874,0.0,0.155074),(1.7402,0.0,0.287481),(1.7402,0.0,-0.428695),(1.72916,0.0,-0.296313),(1.81695,0.0,-0.421653),(1.7011,0.0,0.155074),(1.79557,0.0,-0.285058),(1.88323,0.0,-0.401319),(1.80744,0.0,0.282017),(1.93912,0.0,-0.368878),(1.9847,0.0,-0.325517),(1.7549,0.0,0.150827),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(2.02002,0.0,-0.272424),(1.97229,0.0,0.199587),(2.04517,0.0,-0.210783),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.0652,0.0,-0.066605),(2.05885,0.0,0.016863),(2.0602,0.0,-0.141781),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.86308,0.0,0.090878),(1.88359,0.0,0.056726),(1.89743,0.0,0.016274),(1.90771,0.0,-0.081653),(1.90378,0.0,-0.136378),(1.89265,0.0,-0.182052),(0.695846,0.0,-0.428695),(0.911489,0.0,-0.269223),(0.855318,0.0,-0.428695),(1.23348,0.0,-0.428695),(1.39699,0.0,-0.428695),(0.952623,0.0,-0.15186),(2.00785,0.0,-0.428695),(2.22349,0.0,-0.269223),(2.16732,0.0,-0.428695),(2.54548,0.0,-0.428695),(2.70899,0.0,-0.428695),(2.26462,0.0,-0.15186),(1.13819,0.04,-0.14686),(1.0459,0.04,0.115938),(0.967682,0.04,0.292481),(1.12915,0.04,0.292481),(1.17931,0.04,-0.264223),(2.45019,0.04,-0.14686),(2.3579,0.04,0.115938),(2.27968,0.04,0.292481),(2.44115,0.04,0.292481),(2.49131,0.04,-0.264223),(-0.428437,0.04,0.117491),(-0.476374,0.04,0.357627),(-0.428832,0.04,0.332999),(-0.602188,0.04,0.413385),(-0.781866,0.04,0.474072),(-1.88291,0.04,-0.098123),(-1.92213,0.04,-0.035892),(-1.93953,0.04,0.024172),(-1.82226,0.04,-0.154647),(-1.74449,0.04,-0.204801),(-1.94407,0.04,0.085764),(-1.65389,0.04,-0.247923),(-0.884276,0.04,0.498076),(-0.991,0.04,0.513487),(-1.93447,0.04,0.147956),(-1.90948,0.04,0.209819),(-1.86783,0.04,0.270425),(-1.80827,0.04,0.328849),(-1.72952,0.04,0.384161),(-1.63034,0.04,0.435435),(-1.48564,0.04,0.482022),(-1.3215,0.04,0.509733),(-1.15194,0.04,0.519809),(-0.428612,0.04,0.102999),(-0.562522,0.04,0.209476),(-1.24933,0.04,-0.33684),(-1.34819,0.04,-0.328471),(-1.45144,0.04,-0.31042),(-1.55478,0.04,-0.28335),(-1.34992,0.04,-0.319065),(-1.24377,0.04,-0.335395),(-0.629447,0.04,0.253404),(-0.708151,0.04,0.297169),(-0.793265,0.04,0.333194),(-0.894446,0.04,0.36072),(-1.02135,0.04,0.378985),(-1.11377,0.04,0.385492),(-1.26499,0.04,0.375445),(-1.3632,0.04,0.357312),(-1.43948,0.04,0.333276),(-1.54228,0.04,0.290758),(-1.61509,0.04,0.251199),(-1.67678,0.04,0.207047),(-1.73991,0.04,0.148023),(-1.76937,0.04,0.106187),(-1.7896,0.04,0.065133),(-1.79926,0.04,0.020166),(-1.797,0.04,-0.033411),(-1.78414,0.04,-0.074632),(-1.76324,0.04,-0.111439),(-1.73096,0.04,-0.147733),(-1.68394,0.04,-0.187416),(-1.63383,0.04,-0.219535),(-1.53819,0.04,-0.264699),(-1.44581,0.04,-0.296687),(-1.91876,0.04,-0.375324),(-1.96935,0.04,-0.35269),(-1.99745,0.04,-0.137787),(-1.78608,0.04,-0.425803),(-1.59905,0.04,-0.479006),(-0.502036,0.04,0.016701),(-0.574233,0.04,0.136346),(-0.527113,0.04,0.075885),(-0.641994,0.04,0.190247),(-0.72602,0.04,0.237102),(-0.489599,0.04,-0.044534),(-0.821934,0.04,0.276425),(-1.49381,0.04,-0.498778),(-0.508159,0.04,-0.169661),(-0.49118,0.04,-0.106947),(-0.541912,0.04,-0.231799),(-0.593818,0.04,-0.292485),(-0.665258,0.04,-0.350844),(-0.757607,0.04,-0.406),(-0.895979,0.04,-0.458318),(-1.05617,0.04,-0.492636),(-1.22403,0.04,-0.509587),(-1.38537,0.04,-0.509809),(-1.85185,0.04,-0.224055),(-1.99911,0.04,-0.123334),(-1.03192,0.04,0.330528),(-1.23694,0.04,0.348663),(-1.13724,0.04,0.344335),(-0.92536,0.04,0.307729),(-1.13431,0.04,0.334999),(-1.24231,0.04,0.346973),(-1.77944,0.04,-0.265151),(-1.69529,0.04,-0.3056),(-1.60577,0.04,-0.338055),(-1.5013,0.04,-0.361385),(-1.37235,0.04,-0.374457),(-1.27933,0.04,-0.377172),(-1.12979,0.04,-0.36099),(-1.03413,0.04,-0.338952),(-0.961125,0.04,-0.311873),(-0.864047,0.04,-0.265278),(-0.796513,0.04,-0.222857),(-0.74064,0.04,-0.176313),(-0.685258,0.04,-0.114916),(-0.661235,0.04,-0.072004),(-0.646327,0.04,-0.030241),(-0.642476,0.04,0.015001),(-0.651625,0.04,0.068355),(-0.669751,0.04,0.108928),(-0.695315,0.04,0.144776),(-0.732174,0.04,0.179652),(-0.784185,0.04,0.21731),(-0.838295,0.04,0.247301),(-0.939501,0.04,0.288442),(-1.03577,0.04,0.316581),(-2.05263,0.04,-0.211715),(-2.19415,0.04,-0.147865),(-2.04169,0.04,-0.147865),(-2.21108,0.04,-0.212719),(-2.0477,0.04,0.051744),(-2.20018,0.04,0.051744),(-2.05999,0.04,0.110341),(-2.07299,0.04,-0.268957),(-2.10211,0.04,-0.319004),(-2.2438,0.04,-0.263467),(-2.13936,0.04,-0.361268),(-2.18409,0.04,-0.395163),(-2.29233,0.04,-0.296537),(-2.23564,0.04,-0.420101),(-2.29338,0.04,-0.435494),(-2.35665,0.04,-0.308354),(-2.35665,0.04,-0.440756),(-2.43543,0.04,-0.433241),(-2.50519,0.04,-0.411668),(-2.08187,0.04,0.161849),(-2.21785,0.04,0.101385),(-2.1123,0.04,0.206045),(-2.25284,0.04,0.14115),(-2.15026,0.04,0.242706),(-2.19471,0.04,0.271608),(-2.30061,0.04,0.167559),(-2.24462,0.04,0.292528),(-2.29894,0.04,0.305244),(-2.35665,0.04,0.177135),(-2.35665,0.04,0.309532),(-2.43543,0.04,0.302006),(-2.50519,0.04,0.28035),(-2.56547,0.04,0.245952),(-2.56547,0.04,-0.377495),(-2.61582,0.04,0.200199),(-2.61582,0.04,-0.332178),(-2.65579,0.04,0.144477),(-2.65579,0.04,-0.277175),(-2.6849,0.04,-0.213944),(-2.7027,0.04,-0.143942),(-2.70874,0.04,-0.068626),(-2.7027,0.04,0.008677),(-2.6849,0.04,0.080174),(-2.40562,0.04,-0.302948),(-2.44673,0.04,-0.287681),(-2.48038,0.04,-0.263973),(-2.50699,0.04,-0.233249),(-2.52697,0.04,-0.196929),(-2.54074,0.04,-0.156437),(-2.55125,0.04,-0.068626),(-2.54074,0.04,0.022672),(-2.52697,0.04,0.064237),(-2.50699,0.04,0.101276),(-2.48038,0.04,0.132437),(-2.44673,0.04,0.156368),(-2.40562,0.04,0.171718),(0.122955,0.04,-0.423695),(-0.226112,0.04,-0.291313),(0.122955,0.04,-0.291313),(-0.383593,0.04,0.292481),(-0.226112,0.04,0.292481),(-0.383593,0.04,-0.423695),(0.662877,0.04,-0.423695),(0.313808,0.04,-0.291313),(0.662877,0.04,-0.291313),(0.156329,0.04,0.292481),(0.313808,0.04,0.292481),(0.156329,0.04,-0.423695),(1.43125,0.04,-0.423695),(1.43125,0.04,0.292481),(1.58874,0.04,-0.291313),(1.58874,0.04,0.160074),(1.7402,0.04,0.292481),(1.7402,0.04,-0.423695),(1.72916,0.04,-0.291313),(1.81695,0.04,-0.416653),(1.7011,0.04,0.160074),(1.79557,0.04,-0.280058),(1.88323,0.04,-0.396319),(1.80744,0.04,0.287017),(1.93912,0.04,-0.363878),(1.9847,0.04,-0.320517),(1.7549,0.04,0.155827),(1.86927,0.04,0.270586),(1.92458,0.04,0.243129),(2.02002,0.04,-0.267424),(1.97229,0.04,0.204587),(2.04517,0.04,-0.205783),(2.0113,0.04,0.154901),(2.04051,0.04,0.094012),(2.0652,0.04,-0.061605),(2.05885,0.04,0.021863),(2.0602,0.04,-0.136781),(1.82577,0.04,-0.265179),(1.85267,0.04,-0.243412),(1.87529,0.04,-0.214216),(1.83523,0.04,0.123259),(1.79939,0.04,0.143399),(1.86308,0.04,0.095878),(1.88359,0.04,0.061726),(1.89743,0.04,0.021274),(1.90771,0.04,-0.076653),(1.90378,0.04,-0.131378),(1.89265,0.04,-0.177052),(0.695846,0.04,-0.423695),(0.911489,0.04,-0.264223),(0.855318,0.04,-0.423695),(1.23348,0.04,-0.423695),(1.39699,0.04,-0.423695),(0.952623,0.04,-0.14686),(2.00785,0.04,-0.423695),(2.22349,0.04,-0.264223),(2.16732,0.04,-0.423695),(2.54548,0.04,-0.423695),(2.70899,0.04,-0.423695),(2.26462,0.04,-0.14686)]),
                  normal=Normal(DEF='polySurfaceShape1-normals',vector=[(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(-0.998662,-0.006413,0.051304),(-0.956869,-0.036034,0.288276),(-0.942707,0.04138,-0.331045),(-0.942707,0.04138,-0.331045),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.962541,-0.03363,0.269044),(0.913106,-0.050571,0.404575),(0.913106,-0.050571,0.404575),(0.99927,-0.004738,0.037909),(0.995902,-0.011217,0.089743),(0.974682,-0.027733,0.221867),(0.974682,-0.027733,0.221867),(0.995902,-0.011217,0.089743),(-0.964443,-0.032781,0.26225),(-0.964443,-0.032781,0.26225),(-0.890046,0.056543,-0.452351),(-0.725689,0.085338,-0.68271),(-0.964443,-0.032781,0.26225),(-0.964443,-0.032781,0.26225),(-0.956869,-0.036034,0.288276),(-0.998662,-0.006413,0.051304),(-0.998662,-0.006413,0.051304),(-0.956869,-0.036034,0.288276),(-0.942707,0.04138,-0.331045),(-0.942707,0.04138,-0.331045),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.962541,-0.03363,0.269043),(0.913106,-0.050571,0.404574),(0.913106,-0.050571,0.404574),(0.99927,-0.004738,0.037909),(0.995902,-0.011217,0.089743),(0.974682,-0.027733,0.221867),(0.974682,-0.027733,0.221867),(0.995902,-0.011217,0.089743),(-0.964443,-0.032781,0.26225),(-0.964443,-0.032781,0.262251),(-0.890046,0.056543,-0.452351),(-0.725689,0.085338,-0.68271),(-0.964443,-0.032781,0.26225),(-0.964443,-0.032781,0.262251),(-0.956869,-0.036034,0.288276),(-0.998662,-0.006413,0.051304),(0.999996,3.5E-4,-0.002802),(0.732215,-0.084476,0.675814),(0.939847,-0.042369,0.338959),(0.999972,9.29E-4,-0.007438),(0.732215,-0.084476,0.675814),(0.420926,-0.112511,0.90009),(0.439137,-0.111435,0.891483),(0.939847,-0.042369,0.338959),(0.420926,-0.112511,0.90009),(0.346352,-0.116357,0.930861),(0.374636,-0.115001,0.920012),(0.439137,-0.111435,0.891483),(0.346352,-0.116357,0.930861),(0.257205,-0.119862,0.958894),(0.287649,-0.118792,0.95034),(0.374636,-0.115001,0.920012),(-0.890564,0.056418,-0.451345),(-0.929493,0.045748,-0.365991),(-0.794981,0.075243,-0.60195),(-0.739512,0.083493,-0.667945),(-0.97714,0.026369,-0.210956),(-0.989653,0.017797,-0.142376),(-0.929493,0.045748,-0.365991),(-0.890564,0.056418,-0.451345),(-0.739512,0.083493,-0.667945),(-0.794981,0.075243,-0.60195),(-0.634519,0.095867,-0.766939),(-0.587696,0.100354,-0.802834),(-0.587696,0.100354,-0.802834),(-0.634519,0.095867,-0.766939),(-0.502595,0.107231,-0.857846),(-0.465218,0.109795,-0.878361),(-0.999998,-2.35E-4,0.00188),(-0.996936,-0.009702,0.077623),(-0.989653,0.017797,-0.142376),(-0.97714,0.026369,-0.210956),(-0.465218,0.109795,-0.878361),(-0.502595,0.107231,-0.857846),(-0.396574,0.113864,-0.910914),(-0.365607,0.115448,-0.923582),(0.257205,-0.119862,0.958894),(0.170211,-0.122225,0.977798),(0.198466,-0.121567,0.972539),(0.287649,-0.118792,0.95034),(0.170211,-0.122225,0.977798),(0.073329,-0.123701,0.989606),(0.107669,-0.123314,0.98651),(0.198466,-0.121567,0.972539),(-0.973307,-0.028467,0.227737),(-0.952536,-0.037759,0.302075),(-0.996936,-0.009702,0.077623),(-0.999998,-2.35E-4,0.00188),(-0.896265,-0.055011,0.440095),(-0.861387,-0.063003,0.504027),(-0.952536,-0.037759,0.302075),(-0.973307,-0.028467,0.227737),(-0.783807,-0.077026,0.616209),(-0.742084,-0.083141,0.665131),(-0.861387,-0.063003,0.504027),(-0.896265,-0.055011,0.440095),(-0.657517,-0.093452,0.747622),(-0.61551,-0.097755,0.782043),(-0.742084,-0.083141,0.665131),(-0.783807,-0.077026,0.616209),(-0.534419,-0.104836,0.838692),(-0.495875,-0.107711,0.861688),(-0.61551,-0.097755,0.782043),(-0.657517,-0.093452,0.747622),(-0.406941,-0.1133,0.906401),(-0.356094,-0.115904,0.927234),(-0.495875,-0.107711,0.861688),(-0.534419,-0.104836,0.838692),(-0.258547,-0.119817,0.958539),(-0.212071,-0.121213,0.969708),(-0.356094,-0.115904,0.927234),(-0.406941,-0.1133,0.906401),(-0.129931,-0.122983,0.983866),(-0.094433,-0.12348,0.987844),(-0.212071,-0.121213,0.969708),(-0.258547,-0.119817,0.958539),(-0.009969,-0.124028,0.992229),(-0.009969,-0.124028,0.992229),(-0.094433,-0.12348,0.987844),(-0.129931,-0.122983,0.983866),(0.999926,0.001509,-0.012074),(0.999996,3.5E-4,-0.002802),(0.999972,9.29E-4,-0.007438),(0.999926,0.001509,-0.012074),(-0.595406,0.099652,-0.79722),(-0.570832,0.101841,-0.814727),(-0.619414,0.097375,-0.779002),(-0.619414,0.097375,-0.779002),(-0.112871,0.123242,-0.985937),(-0.141969,0.122778,-0.982227),(0.084387,0.123592,-0.988738),(0.084387,0.123592,-0.988738),(-0.197957,0.12158,-0.972641),(-0.224864,0.120858,-0.966866),(-0.141969,0.122778,-0.982227),(-0.112871,0.123242,-0.985937),(-0.279374,0.119096,-0.952768),(-0.306959,0.118047,-0.944373),(-0.224864,0.120858,-0.966866),(-0.197957,0.12158,-0.972641),(0.084387,0.123592,-0.988738),(0.25009,0.120093,-0.960746),(0.25009,0.120093,-0.960746),(0.084387,0.123592,-0.988738),(0.150906,-0.122614,0.980914),(0.200833,-0.121507,0.972061),(0.175918,-0.1221,0.976803),(0.150906,-0.122614,0.980914),(-0.525188,0.105552,-0.844415),(-0.504293,0.107108,-0.856864),(-0.570832,0.101841,-0.814727),(-0.595406,0.099652,-0.79722),(-0.45172,0.110659,-0.88527),(-0.419718,0.112581,-0.900646),(-0.504293,0.107108,-0.856864),(-0.525188,0.105552,-0.844415),(0.073329,-0.123701,0.989606),(-0.009969,-0.124028,0.992229),(-0.009969,-0.124028,0.992229),(0.107669,-0.123314,0.98651),(-0.345711,0.116387,-0.931095),(-0.303423,0.118187,-0.945498),(-0.419718,0.112581,-0.900646),(-0.45172,0.110659,-0.88527),(-0.221235,0.120961,-0.96769),(-0.181425,0.121976,-0.975811),(-0.303423,0.118187,-0.945498),(-0.345711,0.116387,-0.931095),(-0.117552,0.123175,-0.985398),(-0.09364,0.12349,-0.987918),(-0.181425,0.121976,-0.975811),(-0.221235,0.120961,-0.96769),(-0.001957,0.124034,-0.992276),(-0.001957,0.124034,-0.992276),(-0.09364,0.12349,-0.987918),(-0.117552,0.123175,-0.985398),(0.10408,0.123361,-0.986889),(-0.001957,0.124034,-0.992276),(-0.001957,0.124034,-0.992276),(0.142279,0.122773,-0.982183),(0.219976,0.120996,-0.967972),(0.10408,0.123361,-0.986889),(0.142279,0.122773,-0.982183),(0.259443,0.119787,-0.958301),(0.325775,0.117268,-0.938146),(0.219976,0.120996,-0.967972),(0.259443,0.119787,-0.958301),(0.352885,0.116055,-0.928441),(0.411807,0.113029,-0.904234),(0.325775,0.117268,-0.938146),(0.352885,0.116055,-0.928441),(0.443468,0.111171,-0.889369),(0.510228,0.106675,-0.853398),(0.411807,0.113029,-0.904234),(0.443468,0.111171,-0.889369),(0.545108,0.103986,-0.831892),(0.613887,0.097912,-0.783298),(0.510228,0.106675,-0.853398),(0.545108,0.103986,-0.831892),(0.647664,0.094505,-0.756042),(0.728683,0.084945,-0.679563),(0.613887,0.097912,-0.783298),(0.647664,0.094505,-0.756042),(0.774007,0.078535,-0.628288),(0.844493,0.066428,-0.531431),(0.728683,0.084945,-0.679563),(0.774007,0.078535,-0.628288),(0.87128,0.060874,-0.486996),(0.929211,0.045837,-0.366695),(0.844493,0.066428,-0.531431),(0.87128,0.060874,-0.486996),(0.956646,0.036125,-0.289003),(0.991803,0.015848,-0.126787),(0.929211,0.045837,-0.366695),(0.956646,0.036125,-0.289003),(0.999097,0.005271,-0.04217),(0.991611,-0.016032,0.128257),(0.991803,0.015848,-0.126787),(0.999097,0.005271,-0.04217),(0.976456,-0.026756,0.214053),(0.93009,-0.045562,0.364496),(0.991611,-0.016032,0.128257),(0.976456,-0.026756,0.214053),(0.90128,-0.053736,0.429892),(0.830978,-0.069001,0.55201),(0.93009,-0.045562,0.364496),(0.90128,-0.053736,0.429892),(0.789647,-0.076102,0.608823),(0.712022,-0.087091,0.696735),(0.830978,-0.069001,0.55201),(0.789647,-0.076102,0.608823),(0.677739,-0.091203,0.729625),(0.608057,-0.09847,0.787763),(0.712022,-0.087091,0.696735),(0.677739,-0.091203,0.729625),(0.572898,-0.101662,0.813297),(0.500166,-0.107405,0.859243),(0.608057,-0.09847,0.787763),(0.572898,-0.101662,0.813297),(0.462626,-0.109963,0.879707),(-0.365607,0.115448,-0.923582),(-0.396574,0.113864,-0.910914),(-0.306959,0.118047,-0.944373),(-0.279374,0.119096,-0.952768),(0.391687,-0.114124,0.912993),(0.500166,-0.107405,0.859243),(0.462626,-0.109963,0.879707),(0.358522,-0.115789,0.926312),(0.292175,-0.118622,0.94898),(0.391687,-0.114124,0.912993),(0.358522,-0.115789,0.926312),(0.259023,-0.119801,0.958413),(0.200833,-0.121507,0.972061),(0.292175,-0.118622,0.94898),(0.259023,-0.119801,0.958413),(0.175918,-0.1221,0.976803),(-0.677259,0.091257,-0.730063),(-0.897274,0.054758,-0.438065),(-0.388367,0.114299,-0.914389),(-0.37085,0.11519,-0.921521),(-0.992102,0.015558,-0.124467),(-0.992744,0.014914,-0.119318),(-0.897274,0.054758,-0.438065),(-0.677259,0.091257,-0.730063),(-0.37085,0.11519,-0.921521),(-0.388367,0.114299,-0.914389),(-0.326285,0.117246,-0.937972),(-0.299075,0.118358,-0.946861),(-0.299075,0.118358,-0.946861),(-0.326285,0.117246,-0.937972),(-0.242403,0.120335,-0.962684),(-0.212916,0.121191,-0.969525),(0.943933,-0.040948,0.327589),(0.837228,-0.067828,0.542631),(0.881978,-0.058456,0.467651),(0.964032,-0.032966,0.263733),(0.837228,-0.067828,0.542631),(0.679417,-0.09101,0.728086),(0.735388,-0.084051,0.672413),(0.881978,-0.058456,0.467651),(0.679417,-0.09101,0.728086),(0.53085,-0.105115,0.840921),(0.576123,-0.101381,0.811051),(0.735388,-0.084051,0.672413),(0.53085,-0.105115,0.840921),(0.413251,-0.112948,0.903585),(0.449082,-0.110824,0.886591),(0.576123,-0.101381,0.811051),(0.992043,-0.015615,0.124925),(0.943933,-0.040948,0.327589),(0.964032,-0.032966,0.263733),(0.998744,-0.006215,0.049726),(0.413251,-0.112948,0.903585),(0.317686,-0.117609,0.940874),(0.347444,-0.116307,0.93046),(0.449082,-0.110824,0.886591),(-0.212916,0.121191,-0.969525),(-0.242403,0.120335,-0.962684),(-0.155773,0.122521,-0.980165),(-0.128142,0.123012,-0.984097),(0.941292,0.041873,-0.334987),(0.994427,0.013077,-0.104616),(0.982706,0.022967,-0.183742),(0.911923,0.050899,-0.407193),(0.994427,0.013077,-0.104616),(0.992043,-0.015615,0.124925),(0.998744,-0.006215,0.049726),(0.982706,0.022967,-0.183742),(0.841399,0.06703,-0.536241),(0.941292,0.041873,-0.334987),(0.911923,0.050899,-0.407193),(0.801293,0.074206,-0.593653),(0.717391,0.086411,-0.691291),(0.841399,0.06703,-0.536241),(0.801293,0.074206,-0.593653),(0.67466,0.091553,-0.732429),(0.591147,0.100042,-0.800336),(0.717391,0.086411,-0.691291),(0.67466,0.091553,-0.732429),(0.551094,0.1035,-0.828),(0.458554,0.110225,-0.881804),(0.591147,0.100042,-0.800336),(0.551094,0.1035,-0.828),(0.405519,0.113378,-0.907028),(0.304243,0.118155,-0.945238),(0.458554,0.110225,-0.881804),(0.405519,0.113378,-0.907028),(0.256342,0.11989,-0.959122),(0.172083,0.122184,-0.977476),(0.304243,0.118155,-0.945238),(0.256342,0.11989,-0.959122),(0.135964,0.122883,-0.983063),(0.067001,0.123756,-0.990048),(0.172083,0.122184,-0.977476),(0.135964,0.122883,-0.983063),(0.034182,0.123962,-0.991698),(-0.128142,0.123012,-0.984097),(-0.155773,0.122521,-0.980165),(-0.0496,0.123882,-0.991057),(-0.0496,0.123882,-0.991057),(0.538364,-0.104526,0.836205),(0.561585,-0.102629,0.82103),(0.561585,-0.102629,0.82103),(0.514708,-0.106343,0.850745),(-0.993359,0.01427,-0.114165),(-0.993359,0.01427,-0.114165),(-0.992744,0.014914,-0.119318),(-0.992102,0.015558,-0.124467),(0.155332,-0.122529,0.980234),(0.071751,-0.123715,0.98972),(0.100428,-0.123408,0.987261),(0.181575,-0.121973,0.975783),(0.071751,-0.123715,0.98972),(-0.129426,-0.122991,0.983932),(-0.129426,-0.122991,0.983932),(0.100428,-0.123408,0.987261),(0.234505,-0.120576,0.964608),(0.155332,-0.122529,0.980234),(0.181575,-0.121973,0.975783),(0.261182,-0.119729,0.957835),(-0.109358,0.123291,-0.986327),(-0.109358,0.123291,-0.986327),(-0.133771,0.12292,-0.98336),(-0.158118,0.122474,-0.979795),(-0.129426,-0.122991,0.983932),(-0.129426,-0.122991,0.983932),(-0.298034,-0.118398,0.947184),(-0.298034,-0.118398,0.947184),(0.470865,-0.109424,0.875393),(0.538364,-0.104526,0.836205),(0.514708,-0.106343,0.850745),(0.450808,-0.110716,0.885728),(0.400289,-0.113664,0.909312),(0.470865,-0.109424,0.875393),(0.450808,-0.110716,0.885728),(0.369571,-0.115253,0.922027),(-0.0496,0.123882,-0.991057),(0.067001,0.123756,-0.990048),(0.034182,0.123962,-0.991698),(-0.0496,0.123882,-0.991057),(0.298306,-0.118387,0.9471),(0.400289,-0.113664,0.909312),(0.369571,-0.115253,0.922027),(0.257523,-0.119851,0.958811),(0.177869,-0.122057,0.976455),(0.298306,-0.118387,0.9471),(0.257523,-0.119851,0.958811),(0.139053,-0.12283,0.982638),(0.076414,-0.123672,0.989377),(0.177869,-0.122057,0.976455),(0.139053,-0.12283,0.982638),(0.052689,-0.123862,0.9909),(-0.038998,-0.12394,0.991523),(0.076414,-0.123672,0.989377),(0.052689,-0.123862,0.9909),(-0.038998,-0.12394,0.991523),(-0.145688,-0.122711,0.981691),(-0.184447,-0.121906,0.975253),(-0.038998,-0.12394,0.991523),(-0.038998,-0.12394,0.991523),(-0.264181,-0.119628,0.957025),(-0.305095,-0.118121,0.944968),(-0.184447,-0.121906,0.975253),(-0.145688,-0.122711,0.981691),(-0.373935,-0.115037,0.920293),(-0.402167,-0.113562,0.908496),(-0.305095,-0.118121,0.944968),(-0.264181,-0.119628,0.957025),(-0.463639,-0.109898,0.879182),(-0.496674,-0.107654,0.861235),(-0.402167,-0.113562,0.908496),(-0.373935,-0.115037,0.920293),(-0.566127,-0.102244,0.817953),(-0.602248,-0.099017,0.792144),(-0.496674,-0.107654,0.861235),(-0.463639,-0.109898,0.879182),(-0.672905,-0.091752,0.734016),(-0.707266,-0.087686,0.701488),(-0.602248,-0.099017,0.792144),(-0.566127,-0.102244,0.817953),(-0.788012,-0.076363,0.610906),(-0.831917,-0.068826,0.550615),(-0.707266,-0.087686,0.701488),(-0.672905,-0.091752,0.734016),(-0.897105,-0.0548,0.438407),(-0.920518,-0.04846,0.387682),(-0.831917,-0.068826,0.550615),(-0.788012,-0.076363,0.610906),(-0.966657,-0.031762,0.254097),(-0.985256,-0.02122,0.169763),(-0.920518,-0.04846,0.387682),(-0.897105,-0.0548,0.438407),(-1.0,-2.5E-5,2.02E-4),(-0.996324,0.010626,-0.085007),(-0.985256,-0.02122,0.169763),(-0.966657,-0.031762,0.254097),(-0.967689,0.031274,-0.250199),(-0.942999,0.041278,-0.330225),(-0.996324,0.010626,-0.085007),(-1.0,-2.5E-5,2.02E-4),(-0.8825,0.058335,-0.466681),(-0.849083,0.065522,-0.52418),(-0.942999,0.041278,-0.330225),(-0.967689,0.031274,-0.250199),(-0.772741,0.078727,-0.629819),(-0.730044,0.084765,-0.678123),(-0.849083,0.065522,-0.52418),(-0.8825,0.058335,-0.466681),(-0.652057,0.094039,-0.752315),(-0.618327,0.097481,-0.779852),(-0.730044,0.084765,-0.678123),(-0.772741,0.078727,-0.629819),(-0.550507,0.103548,-0.828384),(-0.516591,0.106202,-0.84962),(-0.618327,0.097481,-0.779852),(-0.652057,0.094039,-0.752315),(-0.446669,0.110974,-0.88779),(-0.410673,0.113093,-0.904742),(-0.516591,0.106202,-0.84962),(-0.550507,0.103548,-0.828384),(0.317686,-0.117609,0.940874),(0.234505,-0.120576,0.964608),(0.261182,-0.119729,0.957835),(0.347444,-0.116307,0.93046),(-0.342631,0.116527,-0.932215),(-0.310753,0.117894,-0.943151),(-0.410673,0.113093,-0.904742),(-0.446669,0.110974,-0.88779),(-0.246759,0.120199,-0.961594),(-0.214656,0.121143,-0.969148),(-0.310753,0.117894,-0.943151),(-0.342631,0.116527,-0.932215),(-0.158118,0.122474,-0.979795),(-0.133771,0.12292,-0.98336),(-0.214656,0.121143,-0.969148),(-0.246759,0.120199,-0.961594),(0.973971,0.028115,-0.224921),(0.985413,0.021108,-0.168867),(0.985413,0.021108,-0.168867),(0.95924,0.035051,-0.280411),(0.0,-0.124035,0.992278),(-0.610582,-0.098229,0.785838),(-0.610582,-0.098229,0.785838),(0.0,-0.124035,0.992278),(-0.610582,-0.098229,0.785838),(-0.610582,-0.098229,0.785838),(-0.934776,-0.044061,0.352495),(-0.891412,-0.056211,0.449694),(0.978391,-0.025645,0.205165),(0.943031,-0.041266,0.330135),(0.962811,-0.033511,0.268091),(0.978391,-0.025645,0.205165),(-0.373476,0.11506,-0.920476),(-0.746952,0.082468,-0.659744),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.918644,0.049004,-0.392035),(0.973971,0.028115,-0.224921),(0.95924,0.035051,-0.280411),(0.892282,0.055998,-0.447992),(0.827802,0.069586,-0.556689),(0.918644,0.049004,-0.392035),(0.892282,0.055998,-0.447992),(0.789332,0.076153,-0.609225),(-0.891412,-0.056211,0.449694),(-0.934776,-0.044061,0.352495),(-0.759139,-0.080737,0.645902),(-0.664696,-0.092668,0.741345),(0.701894,0.088347,-0.706781),(0.827802,0.069586,-0.556689),(0.789332,0.076153,-0.609225),(0.652795,0.09396,-0.751685),(0.547284,0.10381,-0.830484),(0.701894,0.088347,-0.706781),(0.652795,0.09396,-0.751685),(0.490939,0.108058,-0.864466),(-0.664696,-0.092668,0.741345),(-0.759139,-0.080737,0.645902),(-0.441604,-0.111285,0.890282),(-0.312205,-0.117835,0.942679),(0.375215,0.114972,-0.91978),(0.547284,0.10381,-0.830484),(0.490939,0.108058,-0.864466),(0.315991,0.117679,-0.941436),(0.198598,0.121564,-0.972513),(0.375215,0.114972,-0.91978),(0.315991,0.117679,-0.941436),(0.140559,0.122803,-0.982427),(-0.312205,-0.117835,0.942679),(-0.441604,-0.111285,0.890282),(-0.0356,-0.123956,0.991649),(-0.0356,-0.123956,0.991649),(-0.006024,0.124032,-0.99226),(0.198598,0.121564,-0.972513),(0.140559,0.122803,-0.982427),(-0.006024,0.124032,-0.99226),(-0.161353,0.122409,-0.979276),(-0.228032,0.120767,-0.966135),(-0.006024,0.124032,-0.99226),(-0.006024,0.124032,-0.99226),(-0.360836,0.115678,-0.925427),(-0.426805,0.11217,-0.89736),(-0.228032,0.120767,-0.966135),(-0.161353,0.122409,-0.979276),(0.943031,-0.041266,0.330135),(0.85801,-0.063708,0.509667),(0.890754,-0.056372,0.450976),(0.962811,-0.033511,0.268091),(-0.891202,0.056263,-0.450105),(-0.825837,0.069944,-0.559554),(-0.746952,0.082468,-0.659744),(-0.373476,0.11506,-0.920476),(0.85801,-0.063708,0.509667),(0.738376,-0.083647,0.669182),(0.781779,-0.077342,0.618741),(0.890754,-0.056372,0.450976),(-0.667904,0.092312,-0.7385),(-0.577616,0.101251,-0.810005),(-0.825837,0.069944,-0.559554),(-0.891202,0.056263,-0.450105),(0.738376,-0.083647,0.669182),(0.594471,-0.099738,0.797907),(0.644588,-0.094828,0.758626),(0.781779,-0.077342,0.618741),(0.594471,-0.099738,0.797907),(0.438318,-0.111485,0.891879),(0.491198,-0.10804,0.864322),(0.644588,-0.094828,0.758626),(-0.381055,0.114677,-0.917413),(-0.275148,0.119247,-0.953978),(-0.577616,0.101251,-0.810005),(-0.667904,0.092312,-0.7385),(0.438318,-0.111485,0.891879),(0.279707,-0.119084,0.952671),(0.332478,-0.116978,0.935828),(0.491198,-0.10804,0.864322),(0.279707,-0.119084,0.952671),(0.124767,-0.123065,0.984524),(0.175806,-0.122103,0.976823),(0.332478,-0.116978,0.935828),(-0.029298,0.123981,-0.991852),(-0.029298,0.123981,-0.991852),(-0.275148,0.119247,-0.953978),(-0.381055,0.114677,-0.917413),(0.124767,-0.123065,0.984524),(-0.010464,-0.124028,0.992224),(-0.010464,-0.124028,0.992224),(0.175806,-0.122103,0.976823),(-0.010464,-0.124028,0.992224),(-0.010464,-0.124028,0.992224),(-0.161804,-0.1224,0.979203),(-0.228782,-0.120745,0.96596),(-0.228782,-0.120745,0.96596),(-0.161804,-0.1224,0.979203),(-0.362374,-0.115604,0.924836),(-0.42882,-0.112052,0.896414),(-0.42882,-0.112052,0.896414),(-0.362374,-0.115604,0.924836),(-0.554616,-0.10321,0.825681),(-0.613913,-0.097909,0.783278),(-0.55174,0.103447,-0.827576),(-0.610661,0.098222,-0.785777),(-0.426805,0.11217,-0.89736),(-0.360836,0.115678,-0.925427),(-0.613913,-0.097909,0.783278),(-0.554616,-0.10321,0.825681),(-0.720155,-0.086056,0.688455),(-0.767336,-0.079536,0.636294),(-0.716516,0.086523,-0.692184),(-0.763663,0.080078,-0.640629),(-0.610661,0.098222,-0.785777),(-0.55174,0.103447,-0.827576),(-0.767336,-0.079536,0.636294),(-0.720155,-0.086056,0.688455),(-0.847262,-0.065884,0.527073),(-0.880507,-0.058796,0.470372),(-0.843929,0.066539,-0.532313),(-0.877497,0.059484,-0.475879),(-0.763663,0.080078,-0.640629),(-0.716516,0.086523,-0.692184),(-0.931123,0.045236,-0.36189),(-0.951724,0.038073,-0.304584),(-0.877497,0.059484,-0.475879),(-0.843929,0.066539,-0.532313),(-0.981204,0.023935,-0.191482),(-0.990589,0.016976,-0.135813),(-0.951724,0.038073,-0.304584),(-0.931123,0.045236,-0.36189),(-0.999619,0.003423,-0.027386),(-0.999674,-0.003167,0.025338),(-0.990589,0.016976,-0.135813),(-0.981204,0.023935,-0.191482),(-0.991002,-0.016601,0.132813),(-0.981977,-0.023442,0.187539),(-0.999674,-0.003167,0.025338),(-0.999619,0.003423,-0.027386),(-0.953393,-0.037425,0.299402),(-0.933271,-0.04455,0.3564),(-0.981977,-0.023442,0.187539),(-0.991002,-0.016601,0.132813),(-0.880507,-0.058796,0.470372),(-0.847262,-0.065884,0.527073),(-0.933271,-0.04455,0.3564),(-0.953393,-0.037425,0.299402),(-0.0356,-0.123956,0.991649),(0.268618,-0.119476,0.955809),(0.189111,-0.121797,0.974373),(-0.0356,-0.123956,0.991649),(0.268618,-0.119476,0.955809),(0.500897,-0.107353,0.858823),(0.424637,-0.112296,0.898373),(0.189111,-0.121797,0.974373),(0.500897,-0.107353,0.858823),(0.697799,-0.088845,0.710763),(0.637255,-0.095587,0.764702),(0.424637,-0.112296,0.898373),(0.697799,-0.088845,0.710763),(0.838323,-0.06762,0.540964),(0.797724,-0.074795,0.598366),(0.637255,-0.095587,0.764702),(0.838323,-0.06762,0.540964),(0.925399,-0.047008,0.376067),(0.901495,-0.05368,0.429448),(0.797724,-0.074795,0.598366),(0.925399,-0.047008,0.376067),(0.982008,-0.023422,0.187382),(0.966344,-0.031908,0.255268),(0.901495,-0.05368,0.429448),(0.982008,-0.023422,0.187382),(0.999309,0.004609,-0.036876),(0.99913,-0.005173,0.041386),(0.966344,-0.031908,0.255268),(0.999309,0.004609,-0.036876),(0.968073,0.031091,-0.248732),(0.983063,0.022731,-0.181853),(0.99913,-0.005173,0.041386),(0.968073,0.031091,-0.248732),(0.904996,0.052766,-0.422135),(0.928419,0.046083,-0.368667),(0.983063,0.022731,-0.181853),(0.904996,0.052766,-0.422135),(0.802168,0.07406,-0.592487),(0.842573,0.066803,-0.534424),(0.928419,0.046083,-0.368667),(0.802168,0.07406,-0.592487),(0.641308,0.095169,-0.761358),(0.702179,0.088312,-0.706502),(0.842573,0.066803,-0.534424),(0.641308,0.095169,-0.761358),(0.427022,0.112157,-0.897259),(0.503959,0.107132,-0.857058),(0.702179,0.088312,-0.706502),(0.189838,0.121779,-0.974234),(-0.029298,0.123981,-0.991852),(-0.029298,0.123981,-0.991852),(0.269823,0.119434,-0.955474),(0.427022,0.112157,-0.897259),(0.189838,0.121779,-0.974234),(0.269823,0.119434,-0.955474),(0.503959,0.107132,-0.857058),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.040217,-0.123934,0.991475),(0.040217,-0.123934,0.991475),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,0.124035,-0.992278),(0.060503,0.123807,-0.99046),(0.030251,0.123978,-0.991824),(0.0,0.124035,-0.992278),(-0.055447,-0.123844,0.990751),(-0.110895,-0.12327,0.986158),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.060503,0.123807,-0.99046),(0.225414,0.120842,-0.96674),(0.158255,0.122472,-0.979773),(0.030251,0.123978,-0.991824),(0.0,0.124035,-0.992278),(-0.039079,0.12394,-0.99152),(-0.039079,0.12394,-0.99152),(0.0,0.124035,-0.992278),(-0.259334,-0.119791,0.95833),(-0.351297,-0.116129,0.929034),(-0.110895,-0.12327,0.986158),(-0.055447,-0.123844,0.990751),(0.225414,0.120842,-0.96674),(0.43225,0.111849,-0.89479),(0.362569,0.115595,-0.92476),(0.158255,0.122472,-0.979773),(0.139067,-0.122829,0.982636),(0.040217,-0.123934,0.991475),(0.040217,-0.123934,0.991475),(0.197481,-0.121592,0.972737),(0.43225,0.111849,-0.89479),(0.627827,0.096542,-0.772342),(0.564971,0.102342,-0.818739),(0.362569,0.115595,-0.92476),(0.627827,0.096542,-0.772342),(0.786905,0.076538,-0.612309),(0.738607,0.083616,-0.668931),(0.564971,0.102342,-0.818739),(-0.039079,0.12394,-0.99152),(-0.039079,0.12394,-0.99152),(-0.14169,0.122783,-0.982267),(-0.204958,0.121401,-0.971213),(0.318705,-0.117567,0.940535),(0.139067,-0.122829,0.982636),(0.197481,-0.121592,0.972737),(0.381273,-0.114665,0.917324),(0.505742,-0.107003,0.856023),(0.318705,-0.117567,0.940535),(0.381273,-0.114665,0.917324),(0.567266,-0.102147,0.817175),(0.786905,0.076538,-0.612309),(0.897462,0.05471,-0.437685),(0.865882,0.062048,-0.496386),(0.738607,0.083616,-0.668931),(0.682243,-0.090684,0.72548),(0.505742,-0.107003,0.856023),(0.567266,-0.102147,0.817175),(0.735457,-0.084042,0.672339),(0.897462,0.05471,-0.437685),(0.96268,0.033569,-0.268553),(0.945344,0.040444,-0.323557),(0.865882,0.062048,-0.496386),(0.827296,-0.069678,0.557428),(0.682243,-0.090684,0.72548),(0.735457,-0.084042,0.672339),(0.866185,-0.061983,0.495865),(0.927194,-0.046461,0.37169),(0.827296,-0.069678,0.557428),(0.866185,-0.061983,0.495865),(0.950123,-0.038683,0.309467),(0.999586,-0.00357,0.02856),(0.981489,-0.023754,0.190039),(0.990963,-0.016637,0.133097),(0.999818,0.002369,-0.018952),(0.981489,-0.023754,0.190039),(0.927194,-0.046461,0.37169),(0.950123,-0.038683,0.309467),(0.990963,-0.016637,0.133097),(0.99321,0.014429,-0.115438),(0.999586,-0.00357,0.02856),(0.999818,0.002369,-0.018952),(0.98618,0.020549,-0.164399),(0.96268,0.033569,-0.268553),(0.99321,0.014429,-0.115438),(0.98618,0.020549,-0.164399),(0.945344,0.040444,-0.323557),(-0.504252,-0.107111,0.856888),(-0.566909,-0.102177,0.817419),(-0.351297,-0.116129,0.929034),(-0.259334,-0.119791,0.95833),(-0.684218,-0.090455,0.723646),(-0.738568,-0.083621,0.668972),(-0.566909,-0.102177,0.817419),(-0.504252,-0.107111,0.856888),(-0.831632,-0.068879,0.551039),(-0.870685,-0.061005,0.488043),(-0.738568,-0.083621,0.668972),(-0.684218,-0.090455,0.723646),(-0.416327,0.112774,-0.902194),(-0.342573,0.116529,-0.932236),(-0.561792,0.102611,-0.82089),(-0.632784,0.096043,-0.768349),(-0.632784,0.096043,-0.768349),(-0.561792,0.102611,-0.82089),(-0.756085,0.081177,-0.649419),(-0.808842,0.072935,-0.583485),(-0.808842,0.072935,-0.583485),(-0.756085,0.081177,-0.649419),(-0.889892,0.056581,-0.452648),(-0.92002,0.048605,-0.388846),(-0.92002,0.048605,-0.388846),(-0.889892,0.056581,-0.452648),(-0.967254,0.031481,-0.251849),(-0.9837,0.022303,-0.178428),(-0.9837,0.022303,-0.178428),(-0.967254,0.031481,-0.251849),(-0.998929,0.005738,-0.045904),(-0.999915,-0.00162,0.012966),(-0.999915,-0.00162,0.012966),(-0.998929,0.005738,-0.045904),(-0.991771,-0.015879,0.127034),(-0.982987,-0.022781,0.182254),(-0.982987,-0.022781,0.182254),(-0.991771,-0.015879,0.127034),(-0.953189,-0.037504,0.300039),(-0.930958,-0.045288,0.362307),(-0.930958,-0.045288,0.362307),(-0.953189,-0.037504,0.300039),(-0.870685,-0.061005,0.488043),(-0.831632,-0.068879,0.551039),(-0.204958,0.121401,-0.971213),(-0.14169,0.122783,-0.982267),(-0.342573,0.116529,-0.932236),(-0.416327,0.112774,-0.902194),(0.0,0.124035,-0.992278),(0.748651,0.08223,-0.657845),(0.374325,0.115017,-0.920137),(0.0,0.124035,-0.992278),(0.748651,0.08223,-0.657845),(0.374325,0.115017,-0.920137),(0.748651,0.08223,-0.657845),(0.374325,0.115017,-0.920137),(-0.581431,0.100914,-0.807313),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(-0.581431,0.100914,-0.807313),(-0.725689,0.085338,-0.68271),(-0.890046,0.056543,-0.452351),(-0.581431,0.100914,-0.807313),(-0.581431,0.100914,-0.807313),(0.935744,-0.043744,0.349958),(0.974682,-0.027733,0.221867),(0.974682,-0.027733,0.221867),(0.935744,-0.043744,0.349958),(-0.934,-0.044314,0.354515),(-0.934,-0.044314,0.354515),(-0.934,-0.044314,0.354515),(-0.934,-0.044314,0.354515),(0.374325,0.115017,-0.920137),(-0.890046,0.056543,-0.452351),(-0.725689,0.085338,-0.68271),(0.748651,0.08223,-0.657845),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.941571,0.041776,-0.334213),(0.962541,-0.03363,0.269044),(0.99927,-0.004738,0.037909),(0.941571,0.041776,-0.334213),(0.962541,-0.03363,0.269044),(0.913106,-0.050571,0.404575),(0.913106,-0.050571,0.404575),(0.99927,-0.004738,0.037909),(0.0,0.124035,-0.992278),(0.748651,0.08223,-0.657845),(0.374325,0.115017,-0.920137),(0.0,0.124035,-0.992278),(0.748651,0.08223,-0.657845),(0.374325,0.115017,-0.920137),(0.748651,0.08223,-0.657845),(0.374325,0.115017,-0.920137),(-0.581431,0.100914,-0.807313),(0.0,0.124035,-0.992278),(0.0,0.124035,-0.992278),(-0.581431,0.100914,-0.807313),(-0.725689,0.085338,-0.68271),(-0.890046,0.056543,-0.452351),(-0.581431,0.100914,-0.807313),(-0.581431,0.100914,-0.807313),(0.935744,-0.043744,0.349958),(0.974682,-0.027733,0.221867),(0.974682,-0.027733,0.221867),(0.935744,-0.043744,0.349958),(-0.934,-0.044314,0.354515),(-0.934,-0.044314,0.354515),(-0.934,-0.044314,0.354515),(-0.934,-0.044314,0.354515),(0.374325,0.115017,-0.920137),(-0.890046,0.056543,-0.452351),(-0.725689,0.085338,-0.68271),(0.748651,0.08223,-0.657845),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.0,-0.124035,0.992278),(0.941571,0.041776,-0.334213),(0.962541,-0.03363,0.269043),(0.99927,-0.004738,0.037909),(0.941571,0.041776,-0.334213),(0.962541,-0.03363,0.269043),(0.913106,-0.050571,0.404574),(0.913106,-0.050571,0.404574),(0.99927,-0.004738,0.037909),(-0.964443,-0.032781,0.26225),(-0.964443,-0.032781,0.26225),(-0.956869,-0.036034,0.288276),(-0.998662,-0.006413,0.051304),(-0.964443,-0.032781,0.26225),(-0.964443,-0.032781,0.262251),(-0.956869,-0.036034,0.288276),(-0.998662,-0.006413,0.051304),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(DEF='Orange-fx',diffuseColor=(0.95,0.66,0.07),shininess=0.78125,specularColor=(0.07,0.05,0.0))),
                geometry=IndexedFaceSet(coordIndex=[254,18,252,-1,252,18,16,-1,253,17,254,-1,254,17,18,-1,255,19,253,-1,253,19,17,-1,256,20,255,-1,255,20,19,-1,258,257,22,-1,22,257,21,-1,259,258,23,-1,23,258,22,-1,257,260,21,-1,21,260,24,-1,260,261,24,-1,24,261,25,-1,262,259,26,-1,26,259,23,-1,261,263,25,-1,25,263,27,-1,264,28,256,-1,256,28,20,-1,265,29,264,-1,264,29,28,-1,266,262,30,-1,30,262,26,-1,267,266,31,-1,31,266,30,-1,268,267,32,-1,32,267,31,-1,269,268,33,-1,33,268,32,-1,270,269,34,-1,34,269,33,-1,271,270,35,-1,35,270,34,-1,272,271,36,-1,36,271,35,-1,273,272,37,-1,37,272,36,-1,274,273,38,-1,38,273,37,-1,252,16,275,-1,275,16,39,-1,276,275,40,-1,40,275,39,-1,278,277,42,-1,42,277,41,-1,279,278,43,-1,43,278,42,-1,280,279,44,-1,44,279,43,-1,282,46,277,-1,277,46,41,-1,281,45,282,-1,282,45,46,-1,283,276,47,-1,47,276,40,-1,284,283,48,-1,48,283,47,-1,274,38,265,-1,265,38,29,-1,285,284,49,-1,49,284,48,-1,286,285,50,-1,50,285,49,-1,287,286,51,-1,51,286,50,-1,288,287,52,-1,52,287,51,-1,288,52,289,-1,289,52,53,-1,289,53,290,-1,290,53,54,-1,290,54,291,-1,291,54,55,-1,291,55,292,-1,292,55,56,-1,292,56,293,-1,293,56,57,-1,293,57,294,-1,294,57,58,-1,294,58,295,-1,295,58,59,-1,295,59,296,-1,296,59,60,-1,296,60,297,-1,297,60,61,-1,297,61,298,-1,298,61,62,-1,298,62,299,-1,299,62,63,-1,299,63,300,-1,300,63,64,-1,300,64,301,-1,301,64,65,-1,301,65,302,-1,302,65,66,-1,302,66,303,-1,303,66,67,-1,303,67,304,-1,304,67,68,-1,263,280,27,-1,27,280,44,-1,304,68,305,-1,305,68,69,-1,305,69,306,-1,306,69,70,-1,306,70,281,-1,281,70,45,-1,308,307,72,-1,72,307,71,-1,309,308,73,-1,73,308,72,-1,307,310,71,-1,71,310,74,-1,310,311,74,-1,74,311,75,-1,314,78,312,-1,312,78,76,-1,313,77,314,-1,314,77,78,-1,315,79,313,-1,313,79,77,-1,316,80,315,-1,315,80,79,-1,312,76,317,-1,317,76,81,-1,318,82,316,-1,316,82,80,-1,311,319,75,-1,75,319,83,-1,321,85,320,-1,320,85,84,-1,317,81,321,-1,321,81,85,-1,320,84,322,-1,322,84,86,-1,322,86,323,-1,323,86,87,-1,323,87,324,-1,324,87,88,-1,324,88,325,-1,325,88,89,-1,325,89,326,-1,326,89,90,-1,326,90,327,-1,327,90,91,-1,327,91,328,-1,328,91,92,-1,319,329,83,-1,83,329,93,-1,331,95,330,-1,330,95,94,-1,331,309,95,-1,95,309,73,-1,334,98,332,-1,332,98,96,-1,333,97,334,-1,334,97,98,-1,332,96,335,-1,335,96,99,-1,337,336,101,-1,101,336,100,-1,333,337,97,-1,97,337,101,-1,330,94,338,-1,338,94,102,-1,338,102,339,-1,339,102,103,-1,328,92,329,-1,329,92,93,-1,339,103,340,-1,340,103,104,-1,340,104,341,-1,341,104,105,-1,341,105,342,-1,342,105,106,-1,342,106,343,-1,343,106,107,-1,344,343,108,-1,108,343,107,-1,345,344,109,-1,109,344,108,-1,346,345,110,-1,110,345,109,-1,347,346,111,-1,111,346,110,-1,348,347,112,-1,112,347,111,-1,349,348,113,-1,113,348,112,-1,350,349,114,-1,114,349,113,-1,351,350,115,-1,115,350,114,-1,352,351,116,-1,116,351,115,-1,353,352,117,-1,117,352,116,-1,354,353,118,-1,118,353,117,-1,355,354,119,-1,119,354,118,-1,356,355,120,-1,120,355,119,-1,357,356,121,-1,121,356,120,-1,358,357,122,-1,122,357,121,-1,359,358,123,-1,123,358,122,-1,335,99,318,-1,318,99,82,-1,360,359,124,-1,124,359,123,-1,361,360,125,-1,125,360,124,-1,336,361,100,-1,100,361,125,-1,18,17,16,-1,253,254,252,-1,17,19,16,-1,255,253,252,-1,19,20,16,-1,256,255,252,-1,23,22,21,-1,258,259,257,-1,23,21,24,-1,257,259,260,-1,23,24,25,-1,260,259,261,-1,26,23,25,-1,259,262,261,-1,26,25,27,-1,261,262,263,-1,20,28,16,-1,264,256,252,-1,28,29,16,-1,265,264,252,-1,31,30,26,-1,266,267,262,-1,32,31,26,-1,267,268,262,-1,33,32,26,-1,268,269,262,-1,34,33,26,-1,269,270,262,-1,35,34,26,-1,270,271,262,-1,36,35,26,-1,271,272,262,-1,37,36,26,-1,272,273,262,-1,38,37,26,-1,273,274,262,-1,16,40,39,-1,276,252,275,-1,43,42,41,-1,278,279,277,-1,44,43,41,-1,279,280,277,-1,46,45,41,-1,281,282,277,-1,29,40,16,-1,276,265,252,-1,29,47,40,-1,283,265,276,-1,29,48,47,-1,284,265,283,-1,29,38,48,-1,274,265,284,-1,38,49,48,-1,285,274,284,-1,38,50,49,-1,286,274,285,-1,38,51,50,-1,287,274,286,-1,38,52,51,-1,288,274,287,-1,52,38,53,-1,274,288,289,-1,53,38,54,-1,274,289,290,-1,54,38,55,-1,274,290,291,-1,55,38,56,-1,274,291,292,-1,56,38,26,-1,274,292,262,-1,57,56,26,-1,292,293,262,-1,58,57,26,-1,293,294,262,-1,59,58,26,-1,294,295,262,-1,60,59,26,-1,295,296,262,-1,60,26,61,-1,262,296,297,-1,61,26,62,-1,262,297,298,-1,62,26,63,-1,262,298,299,-1,63,26,64,-1,262,299,300,-1,64,26,65,-1,262,300,301,-1,65,26,27,-1,262,301,263,-1,66,65,27,-1,301,302,263,-1,67,66,27,-1,302,303,263,-1,68,67,27,-1,303,304,263,-1,68,27,44,-1,263,304,280,-1,69,68,44,-1,304,305,280,-1,69,44,70,-1,280,305,306,-1,45,44,41,-1,280,281,277,-1,70,44,45,-1,280,306,281,-1,73,72,71,-1,308,309,307,-1,73,71,74,-1,307,309,310,-1,73,74,75,-1,310,309,311,-1,78,77,76,-1,313,314,312,-1,77,79,76,-1,315,313,312,-1,79,80,76,-1,316,315,312,-1,76,80,81,-1,316,312,317,-1,80,82,81,-1,318,316,317,-1,73,75,83,-1,311,309,319,-1,85,81,84,-1,317,321,320,-1,84,81,86,-1,317,320,322,-1,86,81,87,-1,317,322,323,-1,87,81,88,-1,317,323,324,-1,88,81,89,-1,317,324,325,-1,89,81,90,-1,317,325,326,-1,90,81,91,-1,317,326,327,-1,91,81,92,-1,317,327,328,-1,73,83,93,-1,319,309,329,-1,95,73,94,-1,309,331,330,-1,98,97,96,-1,333,334,332,-1,96,97,99,-1,333,332,335,-1,97,101,100,-1,337,333,336,-1,94,73,93,-1,309,330,329,-1,102,94,93,-1,330,338,329,-1,103,102,93,-1,338,339,329,-1,92,103,93,-1,339,328,329,-1,104,103,92,-1,339,340,328,-1,105,104,92,-1,340,341,328,-1,106,105,92,-1,341,342,328,-1,107,106,92,-1,342,343,328,-1,108,107,92,-1,343,344,328,-1,109,108,92,-1,344,345,328,-1,110,109,92,-1,345,346,328,-1,111,110,92,-1,346,347,328,-1,81,111,92,-1,347,317,328,-1,81,112,111,-1,348,317,347,-1,81,113,112,-1,349,317,348,-1,81,114,113,-1,350,317,349,-1,81,115,114,-1,351,317,350,-1,81,116,115,-1,352,317,351,-1,117,116,81,-1,352,353,317,-1,118,117,81,-1,353,354,317,-1,119,118,81,-1,354,355,317,-1,120,119,81,-1,355,356,317,-1,82,120,81,-1,356,318,317,-1,82,121,120,-1,357,318,356,-1,82,122,121,-1,358,318,357,-1,82,123,122,-1,359,318,358,-1,82,99,123,-1,335,318,359,-1,99,124,123,-1,360,335,359,-1,99,125,124,-1,361,335,360,-1,97,100,99,-1,336,333,335,-1,100,125,99,-1,361,336,335,-1],normalIndex=[55,56,54,-1,54,56,57,-1,59,60,58,-1,58,60,61,-1,63,64,62,-1,62,64,65,-1,67,68,66,-1,66,68,69,-1,71,72,70,-1,70,72,73,-1,75,76,74,-1,74,76,77,-1,79,80,78,-1,78,80,81,-1,83,84,82,-1,82,84,85,-1,87,88,86,-1,86,88,89,-1,91,92,90,-1,90,92,93,-1,95,96,94,-1,94,96,97,-1,99,100,98,-1,98,100,101,-1,103,104,102,-1,102,104,105,-1,107,108,106,-1,106,108,109,-1,111,112,110,-1,110,112,113,-1,115,116,114,-1,114,116,117,-1,119,120,118,-1,118,120,121,-1,123,124,122,-1,122,124,125,-1,127,128,126,-1,126,128,129,-1,131,132,130,-1,130,132,133,-1,135,136,134,-1,134,136,137,-1,139,140,138,-1,138,140,141,-1,143,144,142,-1,142,144,145,-1,147,148,146,-1,146,148,149,-1,151,152,150,-1,150,152,153,-1,155,156,154,-1,154,156,157,-1,159,160,158,-1,158,160,161,-1,163,164,162,-1,162,164,165,-1,167,168,166,-1,166,168,169,-1,171,172,170,-1,170,172,173,-1,175,176,174,-1,174,176,177,-1,179,180,178,-1,178,180,181,-1,183,184,182,-1,182,184,185,-1,187,188,186,-1,186,188,189,-1,191,192,190,-1,190,192,193,-1,195,196,194,-1,194,196,197,-1,199,200,198,-1,198,200,201,-1,203,204,202,-1,202,204,205,-1,207,208,206,-1,206,208,209,-1,211,212,210,-1,210,212,213,-1,215,216,214,-1,214,216,217,-1,219,220,218,-1,218,220,221,-1,223,224,222,-1,222,224,225,-1,227,228,226,-1,226,228,229,-1,231,232,230,-1,230,232,233,-1,235,236,234,-1,234,236,237,-1,239,240,238,-1,238,240,241,-1,243,244,242,-1,242,244,245,-1,247,248,246,-1,246,248,249,-1,251,252,250,-1,250,252,253,-1,255,256,254,-1,254,256,257,-1,259,260,258,-1,258,260,261,-1,263,264,262,-1,262,264,265,-1,267,268,266,-1,266,268,269,-1,271,272,270,-1,270,272,273,-1,275,276,274,-1,274,276,277,-1,279,280,278,-1,278,280,281,-1,283,284,282,-1,282,284,285,-1,287,288,286,-1,286,288,289,-1,291,292,290,-1,290,292,293,-1,295,296,294,-1,294,296,297,-1,299,300,298,-1,298,300,301,-1,303,304,302,-1,302,304,305,-1,307,308,306,-1,306,308,309,-1,311,312,310,-1,310,312,313,-1,315,316,314,-1,314,316,317,-1,319,320,318,-1,318,320,321,-1,323,324,322,-1,322,324,325,-1,327,328,326,-1,326,328,329,-1,331,332,330,-1,330,332,333,-1,335,336,334,-1,334,336,337,-1,339,340,338,-1,338,340,341,-1,343,344,342,-1,342,344,345,-1,347,348,346,-1,346,348,349,-1,351,352,350,-1,350,352,353,-1,355,356,354,-1,354,356,357,-1,359,360,358,-1,358,360,361,-1,363,364,362,-1,362,364,365,-1,367,368,366,-1,366,368,369,-1,371,372,370,-1,370,372,373,-1,375,376,374,-1,374,376,377,-1,379,380,378,-1,378,380,381,-1,383,384,382,-1,382,384,385,-1,387,388,386,-1,386,388,389,-1,391,392,390,-1,390,392,393,-1,395,396,394,-1,394,396,397,-1,399,400,398,-1,398,400,401,-1,403,404,402,-1,402,404,405,-1,407,408,406,-1,406,408,409,-1,411,412,410,-1,410,412,413,-1,415,416,414,-1,414,416,417,-1,419,420,418,-1,418,420,421,-1,423,424,422,-1,422,424,425,-1,427,428,426,-1,426,428,429,-1,431,432,430,-1,430,432,433,-1,435,436,434,-1,434,436,437,-1,439,440,438,-1,438,440,441,-1,443,444,442,-1,442,444,445,-1,447,448,446,-1,446,448,449,-1,451,452,450,-1,450,452,453,-1,455,456,454,-1,454,456,457,-1,459,460,458,-1,458,460,461,-1,463,464,462,-1,462,464,465,-1,467,468,466,-1,466,468,469,-1,471,472,470,-1,470,472,473,-1,475,476,474,-1,474,476,477,-1,479,480,478,-1,478,480,481,-1,483,484,482,-1,482,484,485,-1,487,488,486,-1,486,488,489,-1,491,492,490,-1,490,492,493,-1,998,999,1000,-1,1001,1002,1003,-1,1004,1005,1006,-1,1007,1008,1009,-1,1010,1011,1012,-1,1013,1014,1015,-1,1016,1017,1018,-1,1019,1020,1021,-1,1022,1023,1024,-1,1025,1026,1027,-1,1028,1029,1030,-1,1031,1032,1033,-1,1034,1035,1036,-1,1037,1038,1039,-1,1040,1041,1042,-1,1043,1044,1045,-1,1046,1047,1048,-1,1049,1050,1051,-1,1052,1053,1054,-1,1055,1056,1057,-1,1058,1059,1060,-1,1061,1062,1063,-1,1064,1065,1066,-1,1067,1068,1069,-1,1070,1071,1072,-1,1073,1074,1075,-1,1076,1077,1078,-1,1079,1080,1081,-1,1082,1083,1084,-1,1085,1086,1087,-1,1088,1089,1090,-1,1091,1092,1093,-1,1094,1095,1096,-1,1097,1098,1099,-1,1100,1101,1102,-1,1103,1104,1105,-1,1106,1107,1108,-1,1109,1110,1111,-1,1112,1113,1114,-1,1115,1116,1117,-1,1118,1119,1120,-1,1121,1122,1123,-1,1124,1125,1126,-1,1127,1128,1129,-1,1130,1131,1132,-1,1133,1134,1135,-1,1136,1137,1138,-1,1139,1140,1141,-1,1142,1143,1144,-1,1145,1146,1147,-1,1148,1149,1150,-1,1151,1152,1153,-1,1154,1155,1156,-1,1157,1158,1159,-1,1160,1161,1162,-1,1163,1164,1165,-1,1166,1167,1168,-1,1169,1170,1171,-1,1172,1173,1174,-1,1175,1176,1177,-1,1178,1179,1180,-1,1181,1182,1183,-1,1184,1185,1186,-1,1187,1188,1189,-1,1190,1191,1192,-1,1193,1194,1195,-1,1196,1197,1198,-1,1199,1200,1201,-1,1202,1203,1204,-1,1205,1206,1207,-1,1208,1209,1210,-1,1211,1212,1213,-1,1214,1215,1216,-1,1217,1218,1219,-1,1220,1221,1222,-1,1223,1224,1225,-1,1226,1227,1228,-1,1229,1230,1231,-1,1232,1233,1234,-1,1235,1236,1237,-1,1238,1239,1240,-1,1241,1242,1243,-1,1244,1245,1246,-1,1247,1248,1249,-1,1250,1251,1252,-1,1253,1254,1255,-1,1256,1257,1258,-1,1259,1260,1261,-1,1262,1263,1264,-1,1265,1266,1267,-1,1268,1269,1270,-1,1271,1272,1273,-1,1274,1275,1276,-1,1277,1278,1279,-1,1280,1281,1282,-1,1283,1284,1285,-1,1286,1287,1288,-1,1289,1290,1291,-1,1292,1293,1294,-1,1295,1296,1297,-1,1298,1299,1300,-1,1301,1302,1303,-1,1304,1305,1306,-1,1307,1308,1309,-1,1310,1311,1312,-1,1313,1314,1315,-1,1316,1317,1318,-1,1319,1320,1321,-1,1322,1323,1324,-1,1325,1326,1327,-1,1328,1329,1330,-1,1331,1332,1333,-1,1334,1335,1336,-1,1337,1338,1339,-1,1340,1341,1342,-1,1343,1344,1345,-1,1346,1347,1348,-1,1349,1350,1351,-1,1352,1353,1354,-1,1355,1356,1357,-1,1358,1359,1360,-1,1361,1362,1363,-1,1364,1365,1366,-1,1367,1368,1369,-1,1370,1371,1372,-1,1373,1374,1375,-1,1376,1377,1378,-1,1379,1380,1381,-1,1382,1383,1384,-1,1385,1386,1387,-1,1388,1389,1390,-1,1391,1392,1393,-1,1394,1395,1396,-1,1397,1398,1399,-1,1400,1401,1402,-1,1403,1404,1405,-1,1406,1407,1408,-1,1409,1410,1411,-1,1412,1413,1414,-1,1415,1416,1417,-1,1418,1419,1420,-1,1421,1422,1423,-1,1424,1425,1426,-1,1427,1428,1429,-1,1430,1431,1432,-1,1433,1434,1435,-1,1436,1437,1438,-1,1439,1440,1441,-1,1442,1443,1444,-1,1445,1446,1447,-1,1448,1449,1450,-1,1451,1452,1453,-1,1454,1455,1456,-1,1457,1458,1459,-1,1460,1461,1462,-1,1463,1464,1465,-1,1466,1467,1468,-1,1469,1470,1471,-1,1472,1473,1474,-1,1475,1476,1477,-1,1478,1479,1480,-1,1481,1482,1483,-1,1484,1485,1486,-1,1487,1488,1489,-1,1490,1491,1492,-1,1493,1494,1495,-1,1496,1497,1498,-1,1499,1500,1501,-1,1502,1503,1504,-1,1505,1506,1507,-1,1508,1509,1510,-1,1511,1512,1513,-1,1514,1515,1516,-1,1517,1518,1519,-1,1520,1521,1522,-1,1523,1524,1525,-1,1526,1527,1528,-1,1529,1530,1531,-1,1532,1533,1534,-1,1535,1536,1537,-1,1538,1539,1540,-1,1541,1542,1543,-1,1544,1545,1546,-1,1547,1548,1549,-1,1550,1551,1552,-1,1553,1554,1555,-1,1556,1557,1558,-1,1559,1560,1561,-1,1562,1563,1564,-1,1565,1566,1567,-1,1568,1569,1570,-1,1571,1572,1573,-1,1574,1575,1576,-1,1577,1578,1579,-1,1580,1581,1582,-1,1583,1584,1585,-1,1586,1587,1588,-1,1589,1590,1591,-1,1592,1593,1594,-1,1595,1596,1597,-1,1598,1599,1600,-1,1601,1602,1603,-1,1604,1605,1606,-1,1607,1608,1609,-1,1610,1611,1612,-1,1613,1614,1615,-1,1616,1617,1618,-1,1619,1620,1621,-1,1622,1623,1624,-1,1625,1626,1627,-1,1628,1629,1630,-1,1631,1632,1633,-1],
                  coord=Coordinate(USE='polySurfaceShape1-positions'),
                  normal=Normal(USE='polySurfaceShape1-normals')))])])])]),
      Transform(DEF='object1',
        children=[
        Transform(DEF='object1-rotateZ',
          children=[
          Transform(DEF='object1-rotateY',
            children=[
            Transform(DEF='object1-rotateX',rotation=(1.0,0.0,0.0,-1.5707964),
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(USE='Default-fx')),
                geometry=IndexedFaceSet(coordIndex=[0,36,270,-1,36,234,270,-1,36,198,234,-1,36,162,198,-1,36,126,162,-1,36,90,126,-1,36,54,90,-1,36,18,54,-1,36,271,18,-1,36,235,271,-1,36,199,235,-1,36,163,199,-1,36,127,163,-1,36,91,127,-1,36,55,91,-1,36,19,55,-1,36,287,19,-1,36,251,287,-1,36,215,251,-1,36,179,215,-1,36,143,179,-1,36,107,143,-1,36,71,107,-1,36,35,71,-1,36,252,35,-1,216,252,36,-1,180,216,36,-1,144,180,36,-1,108,144,36,-1,36,72,108,-1,252,253,251,-1,216,217,215,-1,180,181,179,-1,144,145,143,-1,108,109,107,-1,72,73,71,-1,36,37,35,-1,0,1,287,-1,271,269,270,-1,271,272,269,-1,235,233,234,-1,235,236,233,-1,199,197,198,-1,199,200,197,-1,163,161,162,-1,163,164,161,-1,127,125,126,-1,127,128,125,-1,91,89,90,-1,91,92,89,-1,55,53,54,-1,55,56,53,-1,19,17,18,-1,19,20,17,-1,272,268,269,-1,236,232,233,-1,200,196,197,-1,164,160,161,-1,128,124,125,-1,92,88,89,-1,56,52,53,-1,20,16,17,-1,1,286,287,-1,253,250,251,-1,217,214,215,-1,181,178,179,-1,145,142,143,-1,109,106,107,-1,73,70,71,-1,37,34,35,-1,272,273,268,-1,273,267,268,-1,236,237,232,-1,237,231,232,-1,200,201,196,-1,201,195,196,-1,164,165,160,-1,165,159,160,-1,128,129,124,-1,129,123,124,-1,92,93,88,-1,93,87,88,-1,56,57,52,-1,57,51,52,-1,20,21,16,-1,21,15,16,-1,253,254,250,-1,217,218,214,-1,181,182,178,-1,145,146,142,-1,109,110,106,-1,73,74,70,-1,37,38,34,-1,1,2,286,-1,273,266,267,-1,237,230,231,-1,201,194,195,-1,165,158,159,-1,129,122,123,-1,93,86,87,-1,57,50,51,-1,21,14,15,-1,273,265,266,-1,237,229,230,-1,201,193,194,-1,165,157,158,-1,129,121,122,-1,93,85,86,-1,57,49,50,-1,21,13,14,-1,286,2,285,-1,2,3,285,-1,250,254,249,-1,254,255,249,-1,214,218,213,-1,218,219,213,-1,178,182,177,-1,182,183,177,-1,142,146,141,-1,146,147,141,-1,106,110,105,-1,110,111,105,-1,70,74,69,-1,74,75,69,-1,34,38,33,-1,38,39,33,-1,255,256,249,-1,219,220,213,-1,183,184,177,-1,147,148,141,-1,111,112,105,-1,75,76,69,-1,39,40,33,-1,3,4,285,-1,273,264,265,-1,237,228,229,-1,201,192,193,-1,165,156,157,-1,129,120,121,-1,93,84,85,-1,57,48,49,-1,21,12,13,-1,256,257,249,-1,220,221,213,-1,184,185,177,-1,148,149,141,-1,112,113,105,-1,76,77,69,-1,40,41,33,-1,4,5,285,-1,263,264,273,-1,227,228,237,-1,191,192,201,-1,155,156,165,-1,119,120,129,-1,83,84,93,-1,47,48,57,-1,11,12,21,-1,249,257,258,-1,213,221,222,-1,177,185,186,-1,141,149,150,-1,105,113,114,-1,69,77,78,-1,33,41,42,-1,285,5,6,-1,249,258,259,-1,213,222,223,-1,177,186,187,-1,141,150,151,-1,105,114,115,-1,69,78,79,-1,33,42,43,-1,285,6,7,-1,259,260,261,-1,259,261,262,-1,259,262,263,-1,223,224,225,-1,223,225,226,-1,223,226,227,-1,187,188,189,-1,187,189,190,-1,187,190,191,-1,151,152,153,-1,151,153,154,-1,151,154,155,-1,115,116,117,-1,115,117,118,-1,115,118,119,-1,79,80,81,-1,79,81,82,-1,79,82,83,-1,43,44,45,-1,43,45,46,-1,43,46,47,-1,8,9,10,-1,7,8,10,-1,7,10,11,-1,274,263,273,-1,275,263,274,-1,276,263,275,-1,259,263,276,-1,238,227,237,-1,239,227,238,-1,240,227,239,-1,223,227,240,-1,202,191,201,-1,203,191,202,-1,204,191,203,-1,187,191,204,-1,166,155,165,-1,167,155,166,-1,168,155,167,-1,151,155,168,-1,130,119,129,-1,131,119,130,-1,132,119,131,-1,115,119,132,-1,94,83,93,-1,95,83,94,-1,96,83,95,-1,79,83,96,-1,58,47,57,-1,59,47,58,-1,60,47,59,-1,43,47,60,-1,22,11,21,-1,23,11,22,-1,24,11,23,-1,7,11,24,-1,284,285,7,-1,283,284,7,-1,282,283,7,-1,282,7,281,-1,281,7,280,-1,280,7,279,-1,279,7,278,-1,278,7,277,-1,248,249,259,-1,247,248,259,-1,246,247,259,-1,246,259,245,-1,245,259,244,-1,244,259,243,-1,243,259,242,-1,242,259,241,-1,212,213,223,-1,211,212,223,-1,210,211,223,-1,210,223,209,-1,209,223,208,-1,208,223,207,-1,207,223,206,-1,206,223,205,-1,176,177,187,-1,175,176,187,-1,174,175,187,-1,174,187,173,-1,173,187,172,-1,172,187,171,-1,171,187,170,-1,170,187,169,-1,140,141,151,-1,139,140,151,-1,138,139,151,-1,138,151,137,-1,137,151,136,-1,136,151,135,-1,135,151,134,-1,134,151,133,-1,104,105,115,-1,103,104,115,-1,102,103,115,-1,102,115,101,-1,101,115,100,-1,100,115,99,-1,99,115,98,-1,98,115,97,-1,68,69,79,-1,67,68,79,-1,66,67,79,-1,66,79,65,-1,65,79,64,-1,64,79,63,-1,63,79,62,-1,62,79,61,-1,32,33,43,-1,31,32,43,-1,30,31,43,-1,30,43,29,-1,29,43,28,-1,28,43,27,-1,27,43,26,-1,277,7,276,-1,241,259,276,-1,241,223,240,-1,205,223,204,-1,169,187,204,-1,169,151,168,-1,133,151,132,-1,97,115,132,-1,97,79,96,-1,61,79,60,-1,26,43,25,-1,25,43,60,-1,25,7,24,-1,7,241,276,-1,7,223,241,-1,223,7,204,-1,7,169,204,-1,7,151,169,-1,151,7,132,-1,7,97,132,-1,7,79,97,-1,79,7,60,-1,7,25,60,-1],normalIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,118,119,-1,120,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,149,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,159,160,161,-1,162,163,164,-1,165,166,167,-1,168,169,170,-1,171,172,173,-1,174,175,176,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,186,187,188,-1,189,190,191,-1,192,193,194,-1,195,196,197,-1,198,199,200,-1,201,202,203,-1,204,205,206,-1,207,208,209,-1,210,211,212,-1,213,214,215,-1,216,217,218,-1,219,220,221,-1,222,223,224,-1,225,226,227,-1,228,229,230,-1,231,232,233,-1,234,235,236,-1,237,238,239,-1,240,241,242,-1,243,244,245,-1,246,247,248,-1,249,250,251,-1,252,253,254,-1,255,256,257,-1,258,259,260,-1,261,262,263,-1,264,265,266,-1,267,268,269,-1,270,271,272,-1,273,274,275,-1,276,277,278,-1,279,280,281,-1,282,283,284,-1,285,286,287,-1,288,289,290,-1,291,292,293,-1,294,295,296,-1,297,298,299,-1,300,301,302,-1,303,304,305,-1,306,307,308,-1,309,310,311,-1,312,313,314,-1,315,316,317,-1,318,319,320,-1,321,322,323,-1,324,325,326,-1,327,328,329,-1,330,331,332,-1,333,334,335,-1,336,337,338,-1,339,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,355,356,-1,357,358,359,-1,360,361,362,-1,363,364,365,-1,366,367,368,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,387,388,389,-1,390,391,392,-1,393,394,395,-1,396,397,398,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,408,409,410,-1,411,412,413,-1,414,415,416,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,428,-1,429,430,431,-1,432,433,434,-1,435,436,437,-1,438,439,440,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,465,466,467,-1,468,469,470,-1,471,472,473,-1,474,475,476,-1,477,478,479,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,489,490,491,-1,492,493,494,-1,495,496,497,-1,498,499,500,-1,501,502,503,-1,504,505,506,-1,507,508,509,-1,510,511,512,-1,513,514,515,-1,516,517,518,-1,519,520,521,-1,522,523,524,-1,525,526,527,-1,528,529,530,-1,531,532,533,-1,534,535,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,547,548,-1,549,550,551,-1,552,553,554,-1,555,556,557,-1,558,559,560,-1,561,562,563,-1,564,565,566,-1,567,568,569,-1,570,571,572,-1,573,574,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,588,589,590,-1,591,592,593,-1,594,595,596,-1,597,598,599,-1,600,601,602,-1,603,604,605,-1,606,607,608,-1,609,610,611,-1,612,613,614,-1,615,616,617,-1,618,619,620,-1,621,622,623,-1,624,625,626,-1,627,628,629,-1,630,631,632,-1,633,634,635,-1,636,637,638,-1,639,640,641,-1,642,643,644,-1,645,646,647,-1,648,649,650,-1,651,652,653,-1,654,655,656,-1,657,658,659,-1,660,661,662,-1,663,664,665,-1,666,667,668,-1,669,670,671,-1,672,673,674,-1,675,676,677,-1,678,679,680,-1,681,682,683,-1,684,685,686,-1,687,688,689,-1,690,691,692,-1,693,694,695,-1,696,697,698,-1,699,700,701,-1,702,703,704,-1,705,706,707,-1,708,709,710,-1,711,712,713,-1,714,715,716,-1,717,718,719,-1,720,721,722,-1,723,724,725,-1,726,727,728,-1,729,730,731,-1,732,733,734,-1,735,736,737,-1,738,739,740,-1,741,742,743,-1,744,745,746,-1,747,748,749,-1,750,751,752,-1,753,754,755,-1,756,757,758,-1,759,760,761,-1,762,763,764,-1,765,766,767,-1,768,769,770,-1,771,772,773,-1,774,775,776,-1,777,778,779,-1,780,781,782,-1,783,784,785,-1,786,787,788,-1,789,790,791,-1,792,793,794,-1,795,796,797,-1,798,799,800,-1,801,802,803,-1,804,805,806,-1,807,808,809,-1,810,811,812,-1,813,814,815,-1,816,817,818,-1,819,820,821,-1,822,823,824,-1,825,826,827,-1,828,829,830,-1,831,832,833,-1,834,835,836,-1,837,838,839,-1,840,841,842,-1,843,844,845,-1,846,847,848,-1,849,850,851,-1,852,853,854,-1,855,856,857,-1,858,859,860,-1,861,862,863,-1,864,865,866,-1,867,868,869,-1,870,871,872,-1,873,874,875,-1,876,877,878,-1,879,880,881,-1,882,883,884,-1,885,886,887,-1,888,889,890,-1,891,892,893,-1,894,895,896,-1,897,898,899,-1,900,901,902,-1,903,904,905,-1,906,907,908,-1,909,910,911,-1,912,913,914,-1,915,916,917,-1,918,919,920,-1,921,922,923,-1,924,925,926,-1,927,928,929,-1,930,931,932,-1,933,934,935,-1,936,937,938,-1,939,940,941,-1,942,943,944,-1,945,946,947,-1],
                  coord=Coordinate(DEF='polySurfaceShape2-positions',point=[(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074),(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074),(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074),(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074),(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074),(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074),(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074),(1.43125,0.0,0.287481),(1.7402,0.0,0.287481),(1.80744,0.0,0.282017),(1.86927,0.0,0.265586),(1.92458,0.0,0.238129),(1.97229,0.0,0.199587),(2.0113,0.0,0.149901),(2.04051,0.0,0.089012),(2.05885,0.0,0.016863),(2.0652,0.0,-0.066605),(2.0602,0.0,-0.141781),(2.04517,0.0,-0.210783),(2.02002,0.0,-0.272424),(1.9847,0.0,-0.325517),(1.93912,0.0,-0.368878),(1.88323,0.0,-0.401319),(1.81695,0.0,-0.421653),(1.7402,0.0,-0.428695),(1.43125,0.0,-0.428695),(1.58874,0.0,-0.296313),(1.72916,0.0,-0.296313),(1.79557,0.0,-0.285058),(1.82577,0.0,-0.270179),(1.85267,0.0,-0.248412),(1.87529,0.0,-0.219216),(1.89265,0.0,-0.182052),(1.90378,0.0,-0.136378),(1.90771,0.0,-0.081653),(1.89743,0.0,0.016274),(1.88359,0.0,0.056726),(1.86308,0.0,0.090878),(1.83523,0.0,0.118259),(1.79939,0.0,0.138399),(1.7549,0.0,0.150827),(1.7011,0.0,0.155074),(1.58874,0.0,0.155074)]),
                  normal=Normal(DEF='polySurfaceShape2-normals',vector=[(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0)])))])])])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for ColladaLogo.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python ColladaLogo.py load and self-test diagnostics complete.")
