/**
 *<p>
 *	The VRML97 Specification was the second-generation predecessor specification that eventually led
 *      to the X3D Graphics International Standard, maintaining full compatibility with the X3D ClassicVRML Encoding.
 *</p>
 *<p>
 *	<b>Many 3D graphics systems support the Virtual Reality Modeling Language (VRML97).</b>
 *	These scenes support the 
 *	<a href="https://www.web3d.org/documents/specifications/14772/V2.0/part1/examples.html" target="_blank">Examples</a>
 *	section of the
 *	<a href="https://www.web3d.org/documents/specifications/14772/V2.0" target="_blank"> VRML97 specification</a>.
 *</p>
 *
 *<p>
 *	The baseline source kept under version control is in <code>.x3d</code> form, and the
 *	autogenerated products include versions using the VRML97 <code>.wrl</code> file extension.
 *	These examples are maintained for historic reasons and interoperability testing.
 *
 *	Backwards compatibility of scenes remains a significant strength of the
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/Architecture.html" target="_blank">X3D specification</a>,
 *	which includes a fully interoperable
 *	<a href="http://new.web3d.org/files/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html" target="_blank">ClassicVRML file encoding</a>
 *	as well as numerous
 *	<a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#Conversions" target="_blank">conversion and translation tools</a>.
 *</p>
 *
 *<p>
 *	Historic predecessor document references include the 
 *	<a href="../../../Vrml97Specification/VrmlScript/vrmlscript.html" target="_blank">VRML Script Node Authoring Interface</a>
 *	proposal of 6&nbsp;October&nbsp;1996, and the
 *	<a href="../../../Vrml97Specification/VRML1.specification.txt" target="_blank">Virtual Reality Modeling Language&nbsp;(VRML)&nbsp;1.0&nbsp;Specification</a>
 *	of 26&nbsp;May&nbsp;1995.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Vrml97Specification" target="_blank">X3D Basic: VRML97 Specification</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Vrml97Specification;

