####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Example17.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interactive',version='3.0',
  head=head(
    children=[
    meta(content='Example17.x3d',name='title'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='26 June 2000',name='created'),
    meta(content='28 October 2019',name='modified'),
    meta(content='X3D working group',name='creator'),
    meta(content="VRML 97 specification example: VRML provides control of the viewer's camera through use of a script. This is useful for things such as guided tours, merry-go-round rides, and transportation devices such as buses and elevators. These next two examples show a couple of ways to use this feature. This example is a simple guided tour through the world. Upon entry, a guide orb hovers in front of the viewer. Click on this and a tour through the world begins. The orb follows the user around on his tour. A ProximitySensor ensures that the tour is started only if the user is close to the initial starting point. Note that this is done without scripts thanks to the touchTime output of the TouchSensor.",name='description'),
    meta(content='originals/exampleD_17.wrl',name='reference'),
    meta(content='VRML 97, ISO/IEC 14772-1, Part 1: Functional specification and UTF-8 encoding, D.17 Guided tour',name='specificationSection'),
    meta(content='https://www.web3d.org/documents/specifications/14772/V2.0/part1/examples.html#D.17',name='specificationUrl'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Vrml97Specification/Example17.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='Example17.x3d'),
    Group(
      children=[
      Transform(translation=(0.0,-1.0,0.0),
        children=[
        Shape(
          geometry=Box(size=(30.0,0.2,30.0)),
          appearance=Appearance(
            material=Material(),))]),
      Transform(translation=(-1.0,0.0,0.0),
        children=[
        Shape(
          geometry=Cone(),
          appearance=Appearance(
            material=Material(diffuseColor=(0.5,0.8,0.0))))]),
      Transform(translation=(1.0,0.0,0.0),
        children=[
        Shape(
          geometry=Cylinder(),
          appearance=Appearance(
            material=Material(diffuseColor=(0.0,0.2,0.7))))]),
      Transform(DEF='GuideTransform',
        children=[
        Viewpoint(DEF='TourGuide',description='Tour Guide',jump=False),
        ProximitySensor(DEF='ProxSensor',size=(50.0,50.0,50.0)),
        TouchSensor(DEF='StartTour',description='touch to start guided tour'),
        Transform(translation=(0.6,0.4,8.0),
          children=[
          Shape(
            geometry=Sphere(radius=0.2),
            appearance=Appearance(
              material=Material(diffuseColor=(1.0,0.6,0.0))))])])]),
    PositionInterpolator(DEF='GuidePI',key=[0.0,0.2,0.3,0.5,0.6,0.8,0.9,1.0],keyValue=[(0.0,0.0,0.0),(0.0,0.0,-5.0),(2.0,0.0,-5.0),(2.0,6.0,-15.0),(-4.0,6.0,-15.0),(-4.0,0.0,-5.0),(0.0,0.0,-5.0),(0.0,0.0,0.0)]),
    OrientationInterpolator(DEF='GuideRI',key=[0.0,0.2,0.3,0.5,0.6,0.8,0.9,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,1.2),(0.0,1.0,0.0,3.0),(0.0,1.0,0.0,3.5),(0.0,1.0,0.0,5.0),(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,0.0)]),
    TimeSensor(DEF='TS',cycleInterval=30.0),
    ROUTE(fromField='isActive',fromNode='ProxSensor',toField='enabled',toNode='StartTour'),
    ROUTE(fromField='touchTime',fromNode='StartTour',toField='startTime',toNode='TS'),
    ROUTE(fromField='isActive',fromNode='TS',toField='set_bind',toNode='TourGuide'),
    ROUTE(fromField='fraction_changed',fromNode='TS',toField='set_fraction',toNode='GuidePI'),
    ROUTE(fromField='fraction_changed',fromNode='TS',toField='set_fraction',toNode='GuideRI'),
    ROUTE(fromField='value_changed',fromNode='GuidePI',toField='translation',toNode='GuideTransform'),
    ROUTE(fromField='value_changed',fromNode='GuideRI',toField='rotation',toNode='GuideTransform')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Example17.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Example17.py load and self-test diagnostics complete.")
