####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python ChopperRotor.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='ChopperRotor.x3d',name='title'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='26 June 2000',name='created'),
    meta(content='28 October 2019',name='modified'),
    meta(content='X3D working group',name='creator'),
    meta(content='VRML 97 specification example: Rotor node provides animation and serves as an ExternProtoDeclare example.',name='description'),
    meta(content='originals/chopperrotor.wrl',name='reference'),
    meta(content='VRML 97, ISO/IEC 14772-1, Part 1: Functional specification and UTF-8 encoding, D.16 Chopper',name='specificationSection'),
    meta(content='https://www.web3d.org/documents/specifications/14772/V2.0/part1/examples.html#D.16',name='specificationUrl'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Vrml97Specification/ChopperRotor.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='ChopperRotor.x3d'),
    Group(
      children=[
      Transform(rotation=(0.25098816,-0.6844724,0.6844724,2.64978),
        children=[
        Shape(
          geometry=Extrusion(creaseAngle=1.57,crossSection=[(0.4,0),(0.002653,0.097911),(-0.4,0),(-0.010374,-0.080121),(0.4,0)],orientation=[(0,-1,0,0.349065),(0,-1,0,0.261799),(0,-1,0,0.174532),(0,0,1,0),(0,0,1,0),(0,0,1,0),(0,1,0,0.087266),(0,1,0,0.174532),(0,1,0,0.261799)],scale=[(0.907089,0.2),(0.907088,0.6),(0.751411,0.6),(0.206542,0.4),(0.459517,0.8),(0.167623,0.4),(0.751412,0.6),(0.926548,0.6),(0.907089,0.2)],solid=False,spine=[(0,-1.6,0),(0,-1.44152,0),(0,-1.24754,0),(0,-0.229174,0),(0,-0.010952,0),(0,0.183023,0),(0,1.17715,0),(0,1.37112,0),(0,1.6,0)]),
          appearance=Appearance(
            material=Material(),))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for ChopperRotor.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python ChopperRotor.py load and self-test diagnostics complete.")
