/**
 *<p>
 *	The X3D Volume Rendering component represents a 3D portion of space with a renderable grid of
 *      voxel values for advanced visualization and presentation techniques.
 *</p>
 *<p>
 *	The Volume Rendering examples
 *	illustrate concepts and capabilities defined by the X3D version&nbsp;3.3 ISO specification for
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/volume.html" target="_blank">X3D Volume Rendering Component</a>,
 *	produced by the
 *	<a href="https://www.web3d.org/working-groups/medical" target="_blank">Web3D Medical Working Group</a>.
 *</p>
 *
 *<p>
 *	Volume data is typically encoded in the
 *	<a href="http://teem.sourceforge.net/nrrd" target="_blank">NRRD (Nearly Raw Raster Data)</a>
 *	format.
 *	Further information is found in this archive&apos;s
 *	<a href="https://www.web3d.org/x3d/content/examples/Basic/VolumeRendering/README.txt" target="_blank">README</a>
 *	file.  See
 *	<a href="../../../VolumeRendering/build.xml" target="_blank">build.xml</a>
 *        for 
 *	<a href="https://savage.nps.edu/Savage/VolumeRendering/datasets/nrrd/datasets.zip" target="_blank">datasets.zip</a>
 *        download support.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/VolumeRendering" target="_blank">X3D Basic: Volume Rendering</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.VolumeRendering;

