####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BlendedComposedVolumes.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=3,name='VolumeRendering'),
    component(level=2,name='Texturing3D'),
    meta(content='BlendedComposedVolumes.x3d',name='title'),
    meta(content='Composed and blended rendering of a human torso and internal structure',name='description'),
    meta(content='6 May 2013',name='created'),
    meta(content='29 March 2020',name='modified'),
    meta(content='Nicholas Polys, Andrew Wood: Virginia Tech',name='creator'),
    meta(content='BlendedComposedVolumes.png',name='Image'),
    meta(content='BlendedBodyInternals.x3d',name='reference'),
    meta(content='Datasets, http://snoid.sv.vt.edu/medical/X3DVolumes/examples/datasets/nrrd/body.nrrd',name='reference'),
    meta(content='Datasets, http://snoid.sv.vt.edu/medical/X3DVolumes/examples/datasets/nrrd/internals.x3d',name='reference'),
    meta(content='All datasets, http://snoid.sv.vt.edu/medical/X3DVolumes/examples/datasets/datasets.zip',name='reference'),
    meta(content='All datasets, https://savage.nps.edu/Savage/VolumeRendering/datasets/nrrd/datasets.zip',name='reference'),
    meta(content='Run the download target in the Ant build.xml file to install reference nrrd files locally.',name='reference'),
    meta(content='build.xml',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/VolumeRendering/BlendedComposedVolumes.x3d',name='identifier'),
    meta(content='Volume data obtained from http://pubimage.hcuge.ch:8080',name='reference'),
    meta(content='Volume data converted using Osirix, http://www.osirix-viewer.com',name='generator'),
    meta(content='Nrrd conversion utility located at http://teem.sourceforge.net/unrrdu',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BlendedComposedVolumes.x3d'),
    Group(
      children=[
      Viewpoint(DEF='VP',description='Blended Composed Volumes',orientation=(0.940022,0.208839,0.269711,1.71637),position=(0.108923,-0.189725,-0.0135375)),
      Background(DEF='BG'),
      Transform(scale=(0.000292969,0.000292969,0.000292969),
        children=[
        VolumeData(dimensions=(512,512,452),
          renderStyle=[
          ComposedVolumeStyle(
            renderStyle=[
            OpacityMapVolumeStyle(),
            SilhouetteEnhancementVolumeStyle(),
            BlendedVolumeStyle(weightConstant1=0.15,weightConstant2=0.85,
              renderStyle=[
              ComposedVolumeStyle(
                renderStyle=[
                SilhouetteEnhancementVolumeStyle(),
                CartoonVolumeStyle(),
                BoundaryEnhancementVolumeStyle(retainedOpacity=.8),
                ToneMappedVolumeStyle(),
                EdgeEnhancementVolumeStyle(),]),],
              voxels=ImageTexture3D(url=["datasets/nrrd/internals.nrrd","http://snoid.sv.vt.edu/medical/X3DVolumes/examples/datasets/nrrd/internals.nrrd","https://savage.nps.edu/Savage/VolumeRendering/datasets/nrrd/internals.nrrd"]))]),],
          voxels=ImageTexture3D(url=["datasets/nrrd/body.nrrd","http://snoid.sv.vt.edu/medical/X3DVolumes/examples/datasets/nrrd/body.nrrd","https://savage.nps.edu/Savage/VolumeRendering/datasets/nrrd/body.nrrd"]))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BlendedComposedVolumes.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BlendedComposedVolumes.py load and self-test diagnostics complete.")
