####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python space2.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.0',
  head=head(
    children=[
    meta(content='space2.x3d',name='title'),
    meta(content='Panoramic background for Universal Media, showing a stratospheric clouds, a mountain and reflective floating spheres.',name='description'),
    meta(content='Pamela Maloney, aka Imagica, copyright 1998',name='creator'),
    meta(content='Ernesto J. Salles, NPS MV 4470 Image Synthesis class',name='translator'),
    meta(content='30 May 2001',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='copyright.htm',name='rights'),
    meta(content='http://www.web3dmedia.com/UniversalMedia',name='reference'),
    meta(content='https://www.web3d.org/WorkingGroups/media',name='reference'),
    meta(content='indexOriginalPanoramas.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/space2.x3d',name='identifier'),
    meta(content='UniversalMedia background texture panorama',name='subject'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='space2.x3d'),
    Viewpoint(description='wide view',fieldOfView=1.5),
    Background(backUrl=["urn:web3d:media:textures/panoramas/space_2_back.jpg","space_2_back.jpg","space_2_back.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/space_2_back.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/space_2_back.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/space_2_back.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/space_2_back.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/space_2_back.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/space_2_back.jpg"],bottomUrl=["urn:web3d:media:textures/panoramas/space_2_bottom.jpg","space_2_bottom.jpg","space_2_bottom.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/space_2_bottom.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/space_2_bottom.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/space_2_bottom.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/space_2_bottom.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/space_2_bottom.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/space_2_bottom.jpg"],frontUrl=["urn:web3d:media:textures/panoramas/space_2_front.jpg","space_2_front.jpg","space_2_front.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/space_2_front.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/space_2_front.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/space_2_front.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/space_2_front.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/space_2_front.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/space_2_front.jpg"],groundAngle=[0.1,1.309,1.57],groundColor=[(0,0,0),(0,0.1,0.3),(0,0.2,0.5),(0,0.3,0.8)],leftUrl=["urn:web3d:media:textures/panoramas/space_2_left.jpg","space_2_left.jpg","space_2_left.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/space_2_left.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/space_2_left.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/space_2_left.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/space_2_left.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/space_2_left.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/space_2_left.jpg"],rightUrl=["urn:web3d:media:textures/panoramas/space_2_right.jpg","space_2_right.jpg","space_2_right.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/space_2_right.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/space_2_right.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/space_2_right.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/space_2_right.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/space_2_right.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/space_2_right.jpg"],skyAngle=[0.1,0.15,1.309,1.57],skyColor=[(0.4,0.4,0.1),(0.4,0.4,0.1),(0,0.1,0.3),(0,0.2,0.6),(0.8,0.8,0.8)],topUrl=["urn:web3d:media:textures/panoramas/space_2_top.jpg","space_2_top.jpg","space_2_top.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/space_2_top.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/space_2_top.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/space_2_top.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/space_2_top.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/space_2_top.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/space_2_top.jpg"])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for space2.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python space2.py load and self-test diagnostics complete.")
