/**
 *<p>
 *	Universal Media Panoramas are texture-mapped high-resolution Background nodes.
 *</p>
 *<p>
 *	These
 *	<a href="http://www.officetowers.com/UniversalMedia" target="_blank">Universal Media</a>
 *	examples provide a large suite of X3D/VRML Background nodes with customized images for easy author use.
 *	Visual scenes are provided for browsing and selection from each collection.
 *	Background nodes can be copied directly with multiple url site addresses included for each image texture in order to improve reliability.
 *</p>
 *
 *<p>
 *	Example use is further explained in the
 *	<a href="https://x3dGraphics.com" target="_blank">X3D for Web Authors</a>
 *	slideset        
 *	<a href="https://x3dGraphics.com/slidesets/X3dForWebAuthors/Chapter11-LightingEnvironment.pdf" target="_blank">Chapter 11 - Lighting and Environment</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas" target="_blank">X3D Basic: Universal Media Panoramas</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.UniversalMediaPanoramas;

