package Basic.UniversalMediaPanoramas;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Panoramic background for Universal Media, showing ocean and sky with a small island nearby. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaPanoramas/ocean1Index.html" target="_blank">ocean1</a>,  source <a href="../../../UniversalMediaPanoramas/ocean1.java">ocean1.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaPanoramas/ocean1.x3d">ocean1.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Panoramic background for Universal Media, showing ocean and sky with a small island nearby. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Pamela Maloney, aka Imagica, copyright 1998 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman and NPS MV4470 Image Synthesis Class </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 22 May 2001 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> rights </i> </td>
			<td> copyright.htm </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.web3dmedia.com/UniversalMedia" target="_blank">http://www.web3dmedia.com/UniversalMedia</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/WorkingGroups/media" target="_blank">https://www.web3d.org/WorkingGroups/media</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../UniversalMediaPanoramas/indexOriginalPanoramas.html">indexOriginalPanoramas.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean1.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean1.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> UniversalMedia background texture panorama </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaPanoramas/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Pamela Maloney, aka Imagica, copyright 1998
 */

public class ocean1
{
	/** Default constructor to create this object. */
	public ocean1 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("ocean1.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Panoramic background for Universal Media, showing ocean and sky with a small island nearby."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Pamela Maloney, aka Imagica, copyright 1998"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman and NPS MV4470 Image Synthesis Class"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("22 May 2001"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_RIGHTS     ).setContent("copyright.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.web3dmedia.com/UniversalMedia"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/WorkingGroups/media"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("indexOriginalPanoramas.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean1.x3d"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("UniversalMedia background texture panorama"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addComments(" Provide skyColor and groundColor values that look good if textures are not found. ")
    .addChild(new WorldInfo().setTitle("ocean1.x3d"))
    .addChild(new Background().setGroundAngle(new double[] {0.1,1.309,1.57}).setGroundColor(new MFColor(new double[] {0.0,0.0,0.0,0.0,0.1,0.3,0.0,0.2,0.5,0.0,0.3,0.8})).setSkyAngle(new double[] {0.1,0.15,1.309,1.57}).setSkyColor(new MFColor(new double[] {0.4,0.4,0.1,0.4,0.4,0.1,0.0,0.1,0.3,0.0,0.2,0.6,0.8,0.8,0.8})).setBackUrl(new String[] {"urn:web3d:media:textures/panoramas/ocean_1_back.jpg","ocean_1_back.jpg","ocean_1_back.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_1_back.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_1_back.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_1_back.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_1_back.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_1_back.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_1_back.jpg"}).setBottomUrl(new String[] {"urn:web3d:media:textures/panoramas/ocean_1_bottom.jpg","ocean_1_bottom.jpg","ocean_1_bottom.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_1_bottom.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_1_bottom.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_1_bottom.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_1_bottom.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_1_bottom.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_1_bottom.jpg"}).setFrontUrl(new String[] {"urn:web3d:media:textures/panoramas/ocean_1_front.jpg","ocean_1_front.jpg","ocean_1_front.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_1_front.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_1_front.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_1_front.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_1_front.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_1_front.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_1_front.jpg"}).setLeftUrl(new String[] {"urn:web3d:media:textures/panoramas/ocean_1_left.jpg","ocean_1_left.jpg","ocean_1_left.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_1_left.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_1_left.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_1_left.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_1_left.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_1_left.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_1_left.jpg"}).setRightUrl(new String[] {"urn:web3d:media:textures/panoramas/ocean_1_right.jpg","ocean_1_right.jpg","ocean_1_right.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_1_right.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_1_right.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_1_right.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_1_right.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_1_right.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_1_right.jpg"}).setTopUrl(new String[] {"urn:web3d:media:textures/panoramas/ocean_1_top.jpg","ocean_1_top.jpg","ocean_1_top.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_1_top.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_1_top.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_1_top.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_1_top.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_1_top.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_1_top.jpg"})));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return ocean1 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new ocean1().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaPanoramas.ocean1\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaPanoramas.ocean1 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaPanoramas/ocean1_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaPanoramas/ocean1_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaPanoramas/ocean1_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaPanoramas/ocean1_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
