/**
 *<p>
 *	Universal Media Materials provide numerous complex Material values
 *      to simplify scene authoring and improve geometry appearance.
 *</p>
 *<p>
 *	These
 *	<a href="http://www.officetowers.com/UniversalMedia" target="_blank">Universal Media</a>
 *	examples provide a large suite of color-coordinated X3D/VRML Materials for easy usage by authors.
 *	Visual scenes are provided for browsing and selection from each collection.
 *	Entries can be copied directly or used via (internal or external) prototype declarations.
 *</p>
 *
 *<p>
 *	This library of materials is originally converted from
 *	<a href="http://vrmlstuff.free.fr/materials" target="_blank">SGI's Open Inventor material examples</a>.
 *	Material library selections are also built into the
 *	<a href="https://savage.nps.edu/X3D-Edit" target="_blank">X3D-Edit</a>
 *	authoring tool.
 *	Example use is further explained in the
 *	<a href="https://x3dGraphics.com" target="_blank">X3D for Web Authors</a>
 *	slideset        
 *	<a href="https://x3dGraphics.com/slidesets/X3dForWebAuthors/Chapter05-AppearanceMaterialTextures.pdf" target="_blank">Chapter 5 - Appearance Material Textures</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials" target="_blank">X3D Basic: Universal Media Materials</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.UniversalMediaMaterials;

