package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/WinterPrototypesIndex.html" target="_blank">WinterPrototypes</a>,  source <a href="../../../UniversalMediaMaterials/WinterPrototypes.java">WinterPrototypes.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/WinterPrototypes.x3d">WinterPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/WinterPrototypes.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/WinterPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class WinterPrototypes
{
	/** Default constructor to create this object. */
	public WinterPrototypes ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("WinterPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/WinterPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("WinterPrototypes.x3d"))
    .addChild(new ProtoDeclare("Winter00").setName("Winter00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.248649).setDiffuseColor(0.986486,1.0,1.0).setShininess(0.524324).setSpecularColor(0.405259,0.410811,0.410811))))
    .addChild(new ProtoDeclare("Winter01").setName("Winter01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.230089).setDiffuseColor(0.610811,0.610811,0.610811).setShininess(0.897297).setSpecularColor(0.767568,0.756757,0.764964))))
    .addChild(new ProtoDeclare("Winter02").setName("Winter02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.236842).setDiffuseColor(0.205405,0.205405,0.205405).setShininess(1.0).setSpecularColor(0.686486,0.676818,0.684159))))
    .addChild(new ProtoDeclare("Winter03").setName("Winter03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.254237).setDiffuseColor(0.240246,0.261598,0.357576).setShininess(0.072727).setSpecularColor(0.220301,0.259507,0.290909))))
    .addChild(new ProtoDeclare("Winter04").setName("Winter04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.254237).setDiffuseColor(0.141299,0.145507,0.164421).setShininess(0.072727).setSpecularColor(0.394707,0.464951,0.521212))))
    .addChild(new ProtoDeclare("Winter05").setName("Winter05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.0).setDiffuseColor(0.0,0.0,0.0).setShininess(0.081633).setSpecularColor(0.293243,0.297387,0.290421))))
    .addChild(new ProtoDeclare("Winter06").setName("Winter06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .addComments(" computed conversion ambientIntensity=2.226234, normalized to 1.0 ")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(1.0).setDiffuseColor(0.331633,0.296582,0.279057).setShininess(0.096939).setSpecularColor(0.311224,0.25183,0.133042))))
    .addChild(new ProtoDeclare("Winter07").setName("Winter07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253968).setDiffuseColor(1.0,1.0,0.474361).setShininess(0.037838))))
    .addChild(new ProtoDeclare("Winter08").setName("Winter08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253968).setDiffuseColor(1.0,1.0,0.0).setShininess(0.681081).setSpecularColor(0.899871,0.893105,0.896821))))
    .addChild(new ProtoDeclare("Winter09").setName("Winter09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253968).setDiffuseColor(0.579759,1.0,0.474361).setShininess(1.0).setSpecularColor(0.809524,0.0,1.0))))
    .addChild(new ProtoDeclare("Winter10").setName("Winter10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253968).setDiffuseColor(0.0,0.309524,0.0).setShininess(0.081081).setSpecularColor(0.071925,0.677294,0.0))))
    .addChild(new ProtoDeclare("Winter11").setName("Winter11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.355876).setDiffuseColor(0.0,0.488636,0.0).setShininess(0.0))))
    .addChild(new ProtoDeclare("Winter12").setName("Winter12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253969).setDiffuseColor(0.0,0.122449,0.0).setShininess(0.081081).setSpecularColor(0.071925,0.356628,0.0))))
    .addChild(new ProtoDeclare("Winter13").setName("Winter13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253969).setDiffuseColor(0.0,0.122449,0.0).setShininess(0.789189).setSpecularColor(0.081633,0.404762,0.0))))
    .addChild(new ProtoDeclare("Winter14").setName("Winter14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253969).setDiffuseColor(0.0,0.122449,0.0).setShininess(0.081081).setSpecularColor(0.356628,0.356628,0.356628))))
    .addChild(new ProtoDeclare("Winter15").setName("Winter15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253969).setDiffuseColor(0.0,0.122449,0.0).setShininess(0.724324).setSpecularColor(0.87027,0.458816,0.87027))))
    .addChild(new ProtoDeclare("Winter16").setName("Winter16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.243243).setDiffuseColor(0.059538,0.070134,0.211314).setShininess(1.0).setSpecularColor(0.084549,0.099595,0.111647))))
    .addChild(new ProtoDeclare("Winter17").setName("Winter17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.24812).setDiffuseColor(0.082709,0.067989,0.348453).setShininess(0.684848).setSpecularColor(0.656314,0.773115,0.866667))))
    .addChild(new ProtoDeclare("Winter18").setName("Winter18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.251799).setDiffuseColor(0.442456,0.506497,0.842424).setShininess(0.524324).setSpecularColor(0.405259,0.410811,0.410811))))
    .addChild(new ProtoDeclare("Winter19").setName("Winter19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.251799).setDiffuseColor(0.23888,0.41719,0.842424).setShininess(0.524324).setSpecularColor(0.405259,0.410811,0.410811))))
    .addChild(new ProtoDeclare("Winter20").setName("Winter20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.434323,0.695804,0.788544).setShininess(0.094483).setSpecularColor(0.061688,0.098828,0.112))))
    .addChild(new ProtoDeclare("Winter21").setName("Winter21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.015119,0.331798,0.399133).setShininess(0.772973).setSpecularColor(0.017084,0.374932,0.451021))))
    .addChild(new ProtoDeclare("Winter22").setName("Winter22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.015119,0.331798,0.399133).setShininess(0.097297).setSpecularColor(0.004385,0.096221,0.115749))))
    .addChild(new ProtoDeclare("Winter23").setName("Winter23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.242424).setDiffuseColor(0.030858,0.393852,0.522917).setShininess(0.097297).setSpecularColor(0.013774,0.302289,0.363636))))
    .addChild(new ProtoDeclare("Winter24").setName("Winter24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.248648).setDiffuseColor(0.972789,0.619048,0.705085).setShininess(0.832432).setSpecularColor(0.610811,0.35315,0.373056))))
    .addChild(new ProtoDeclare("Winter25").setName("Winter25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.248648).setDiffuseColor(0.936975,0.092326,0.42843).setShininess(0.832432).setSpecularColor(0.805292,0.216986,0.36733))))
    .addChild(new ProtoDeclare("Winter26").setName("Winter26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.254054).setDiffuseColor(0.738397,0.092326,0.361345).setShininess(0.151351).setSpecularColor(0.526732,0.141928,0.240266))))
    .addChild(new ProtoDeclare("Winter27").setName("Winter27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.266839).setDiffuseColor(0.230477,0.106718,0.285207).setShininess(0.054054).setSpecularColor(0.551351,0.0,0.234225))))
    .addChild(new ProtoDeclare("Winter28").setName("Winter28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.266839).setDiffuseColor(0.230477,0.106718,0.285207).setShininess(0.740541).setSpecularColor(0.848649,0.0,0.360523))))
    .addChild(new ProtoDeclare("Winter29").setName("Winter29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.267858).setDiffuseColor(0.244615,0.113264,0.302703).setShininess(0.659459).setSpecularColor(0.690166,0.319568,0.854054))))
    .addChild(new ProtoDeclare("Winter30").setName("Winter30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.267858).setDiffuseColor(0.244615,0.113264,0.302703).setShininess(0.07027).setSpecularColor(0.253352,0.11731,0.313514))))
    .addChild(new ProtoDeclare("Winter31").setName("Winter31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.266839).setDiffuseColor(0.285207,0.0,0.0).setShininess(0.097297).setSpecularColor(0.110903,0.0,0.337957))))
    .addChild(new ProtoDeclare("Winter32").setName("Winter32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.266839).setDiffuseColor(0.285207,0.0,0.0).setShininess(0.740541).setSpecularColor(0.150101,0.0,0.457407))))
    .addChild(new ProtoDeclare("Winter33").setName("Winter33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.540541,0.0,0.0).setShininess(0.064865).setSpecularColor(0.092002,0.0,0.020119))))
    .addChild(new ProtoDeclare("Winter34").setName("Winter34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.540541,0.0,0.0).setShininess(0.772973).setSpecularColor(0.577569,0.0,0.126303))))
    .addChild(new Anchor().setDescription("click for examples").setParameter(new String[] {"target=_blank"}).setUrl(new String[] {"WinterExamples.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/WinterExamples.x3d","WinterExamples.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/WinterExamples.wrl"})
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.8,0.4,0.0)))
        .setGeometry(new Text().setString(new String[] {"WinterExamples.x3d","is a Materials Prototype declaration file.","","For an example scene using these node,","click this text and view","WinterExamples.x3d"})
          .setFontStyle(new FontStyle().setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.8))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return WinterPrototypes model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new WinterPrototypes().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.WinterPrototypes\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.WinterPrototypes self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/WinterPrototypes_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/WinterPrototypes_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/WinterPrototypes_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/WinterPrototypes_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
