package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/TropicalPrototypesIndex.html" target="_blank">TropicalPrototypes</a>,  source <a href="../../../UniversalMediaMaterials/TropicalPrototypes.java">TropicalPrototypes.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/TropicalPrototypes.x3d">TropicalPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class TropicalPrototypes
{
	/** Default constructor to create this object. */
	public TropicalPrototypes ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("TropicalPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("TropicalPrototypes.x3d"))
    .addChild(new ProtoDeclare("Tropical00").setName("Tropical00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.877539,0.904409,0.0).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical01").setName("Tropical01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.748014,0.62085,0.0).setShininess(0.939394).setSpecularColor(0.860606,0.860606,0.860599))))
    .addChild(new ProtoDeclare("Tropical02").setName("Tropical02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.904409,0.774741,0.083067).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical03").setName("Tropical03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.748016,0.555721,0.0).setShininess(0.606061).setSpecularColor(0.836364,0.836364,0.836364))))
    .addChild(new ProtoDeclare("Tropical04").setName("Tropical04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.904409,0.412258,0.0).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical05").setName("Tropical05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.748016,0.299537,0.0).setShininess(0.921212).setSpecularColor(0.836364,0.836364,0.836364))))
    .addChild(new ProtoDeclare("Tropical06").setName("Tropical06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.904409,0.283754,0.0).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical07").setName("Tropical07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.748016,0.139569,0.0).setShininess(0.478788).setSpecularColor(0.709091,0.709091,0.709091))))
    .addChild(new ProtoDeclare("Tropical08").setName("Tropical08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.904409,0.150314,0.0).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical09").setName("Tropical09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.877539,0.904409,0.0).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical10").setName("Tropical10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.904409,0.0,0.309851).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical11").setName("Tropical11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.748016,0.006259,0.251931).setShininess(0.933333).setSpecularColor(0.684848,0.684848,0.684848))))
    .addChild(new ProtoDeclare("Tropical12").setName("Tropical12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.904409,0.046947,0.496108).setShininess(0.078125).setSpecularColor(0.095591,0.095591,0.095591))))
    .addChild(new ProtoDeclare("Tropical13").setName("Tropical13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.748016,0.0,0.550351).setShininess(0.230303).setSpecularColor(0.672727,0.672727,0.672727))))
    .addChild(new ProtoDeclare("Tropical14").setName("Tropical14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.895967,0.0,0.691271).setShininess(0.078125).setSpecularColor(0.095591,0.086256,0.093458))))
    .addChild(new ProtoDeclare("Tropical15").setName("Tropical15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.624368,0.0,0.748016).setShininess(0.557576).setSpecularColor(0.951515,0.951515,0.951515))))
    .addChild(new ProtoDeclare("Tropical16").setName("Tropical16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.62178,0.020917,0.880181).setShininess(0.078125).setSpecularColor(0.087726,0.069438,0.095591))))
    .addChild(new ProtoDeclare("Tropical17").setName("Tropical17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.374008,0.0,0.748016).setShininess(0.406061).setSpecularColor(0.909091,0.909091,0.909091))))
    .addChild(new ProtoDeclare("Tropical18").setName("Tropical18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.279501,0.005142,0.845907).setShininess(0.078125).setSpecularColor(0.052278,0.031298,0.095591))))
    .addChild(new ProtoDeclare("Tropical19").setName("Tropical19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.002317,0.0,0.748016).setShininess(0.830303).setSpecularColor(0.884848,0.884848,0.884848))))
    .addChild(new ProtoDeclare("Tropical20").setName("Tropical20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.204955,0.845242).setShininess(0.078125).setSpecularColor(0.03017,0.046033,0.095591))))
    .addChild(new ProtoDeclare("Tropical21").setName("Tropical21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.020732,0.339645,0.748016).setShininess(0.927273).setSpecularColor(0.90303,0.90303,0.90303))))
    .addChild(new ProtoDeclare("Tropical22").setName("Tropical22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.596985,0.817956).setShininess(0.078125).setSpecularColor(0.0,0.069767,0.095591))))
    .addChild(new ProtoDeclare("Tropical23").setName("Tropical23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.631244,0.748016).setShininess(0.642424).setSpecularColor(0.915152,0.915152,0.915152))))
    .addChild(new ProtoDeclare("Tropical24").setName("Tropical24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.817956,0.553836).setShininess(0.078125).setSpecularColor(0.0,0.095591,0.064724))))
    .addChild(new ProtoDeclare("Tropical25").setName("Tropical25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.748016,0.469403).setShininess(0.818182).setSpecularColor(1.0,1.0,1.0))))
    .addChild(new ProtoDeclare("Tropical26").setName("Tropical26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.053153,0.817956,0.088018).setShininess(0.078125).setSpecularColor(0.006212,0.095591,0.010286))))
    .addChild(new ProtoDeclare("Tropical27").setName("Tropical27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.748016,0.176015).setShininess(0.721212).setSpecularColor(0.981818,0.981818,0.981818))))
    .addChild(new ProtoDeclare("Tropical28").setName("Tropical28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.355377,0.817956,0.015797).setShininess(0.078125).setSpecularColor(0.041531,0.095591,0.001846))))
    .addChild(new ProtoDeclare("Tropical29").setName("Tropical29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.381944,0.748016,0.0).setShininess(0.981818).setSpecularColor(0.963636,0.963636,0.963636))))
    .addChild(new ProtoDeclare("Tropical30").setName("Tropical30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.991732,0.939493,1.0).setShininess(0.0))))
    .addChild(new ProtoDeclare("Tropical31").setName("Tropical31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.425062,0.404868,0.426289).setShininess(0.90303).setSpecularColor(0.860606,0.860606,0.860606))))
    .addChild(new ProtoDeclare("Tropical32").setName("Tropical32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.249999).setDiffuseColor(0.424238,0.424238,0.424238).setShininess(0.153696).setSpecularColor(0.168,0.168,0.168))))
    .addChild(new ProtoDeclare("Tropical33").setName("Tropical33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.152381,0.145141,0.15282).setShininess(0.957576).setSpecularColor(0.745455,0.745455,0.745455))))
    .addChild(new ProtoDeclare("Tropical34").setName("Tropical34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.138667,0.138667,0.138667).setShininess(0.153696).setSpecularColor(0.168,0.168,0.168))))
    .addChild(new Anchor().setDescription("click for examples").setParameter(new String[] {"target=_blank"}).setUrl(new String[] {"TropicalExamples.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalExamples.x3d","TropicalExamples.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalExamples.wrl"})
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.8,0.4,0.0)))
        .setGeometry(new Text().setString(new String[] {"TropicalExamples.x3d","is a Materials Prototype declaration file.","","For an example scene using these node,","click this text and view","TropicalExamples.x3d"})
          .setFontStyle(new FontStyle().setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.8))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return TropicalPrototypes model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new TropicalPrototypes().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.TropicalPrototypes\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.TropicalPrototypes self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/TropicalPrototypes_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/TropicalPrototypes_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/TropicalPrototypes_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/TropicalPrototypes_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
