package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/TropicalExamplesIndex.html" target="_blank">TropicalExamples</a>,  source <a href="../../../UniversalMediaMaterials/TropicalExamples.java">TropicalExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/TropicalExamples.x3d">TropicalExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class TropicalExamples
{
	/** Default constructor to create this object. */
	public TropicalExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("TropicalExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("TropicalExamples.x3d"))
    .addChild(new ExternProtoDeclare("Tropical00").setName("Tropical00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical00","TropicalPrototypes.wrl#Tropical00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical00"}))
    .addChild(new ExternProtoDeclare("Tropical01").setName("Tropical01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical01","TropicalPrototypes.wrl#Tropical01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical01"}))
    .addChild(new ExternProtoDeclare("Tropical02").setName("Tropical02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical02","TropicalPrototypes.wrl#Tropical02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical02"}))
    .addChild(new ExternProtoDeclare("Tropical03").setName("Tropical03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical03","TropicalPrototypes.wrl#Tropical03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical03"}))
    .addChild(new ExternProtoDeclare("Tropical04").setName("Tropical04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical04","TropicalPrototypes.wrl#Tropical04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical04"}))
    .addChild(new ExternProtoDeclare("Tropical05").setName("Tropical05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical05","TropicalPrototypes.wrl#Tropical05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical05"}))
    .addChild(new ExternProtoDeclare("Tropical06").setName("Tropical06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical06","TropicalPrototypes.wrl#Tropical06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical06"}))
    .addChild(new ExternProtoDeclare("Tropical07").setName("Tropical07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical07","TropicalPrototypes.wrl#Tropical07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical07"}))
    .addChild(new ExternProtoDeclare("Tropical08").setName("Tropical08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical08","TropicalPrototypes.wrl#Tropical08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical08"}))
    .addChild(new ExternProtoDeclare("Tropical09").setName("Tropical09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical09","TropicalPrototypes.wrl#Tropical09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical09"}))
    .addChild(new ExternProtoDeclare("Tropical10").setName("Tropical10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical10","TropicalPrototypes.wrl#Tropical10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical10"}))
    .addChild(new ExternProtoDeclare("Tropical11").setName("Tropical11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical11","TropicalPrototypes.wrl#Tropical11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical11"}))
    .addChild(new ExternProtoDeclare("Tropical12").setName("Tropical12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical12","TropicalPrototypes.wrl#Tropical12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical12"}))
    .addChild(new ExternProtoDeclare("Tropical13").setName("Tropical13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical13","TropicalPrototypes.wrl#Tropical13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical13"}))
    .addChild(new ExternProtoDeclare("Tropical14").setName("Tropical14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical14","TropicalPrototypes.wrl#Tropical14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical14"}))
    .addChild(new ExternProtoDeclare("Tropical15").setName("Tropical15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical15","TropicalPrototypes.wrl#Tropical15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical15"}))
    .addChild(new ExternProtoDeclare("Tropical16").setName("Tropical16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical16","TropicalPrototypes.wrl#Tropical16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical16"}))
    .addChild(new ExternProtoDeclare("Tropical17").setName("Tropical17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical17","TropicalPrototypes.wrl#Tropical17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical17"}))
    .addChild(new ExternProtoDeclare("Tropical18").setName("Tropical18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical18","TropicalPrototypes.wrl#Tropical18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical18"}))
    .addChild(new ExternProtoDeclare("Tropical19").setName("Tropical19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical19","TropicalPrototypes.wrl#Tropical19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical19"}))
    .addChild(new ExternProtoDeclare("Tropical20").setName("Tropical20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical20","TropicalPrototypes.wrl#Tropical20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical20"}))
    .addChild(new ExternProtoDeclare("Tropical21").setName("Tropical21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical21","TropicalPrototypes.wrl#Tropical21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical21"}))
    .addChild(new ExternProtoDeclare("Tropical22").setName("Tropical22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical22","TropicalPrototypes.wrl#Tropical22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical22"}))
    .addChild(new ExternProtoDeclare("Tropical23").setName("Tropical23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical23","TropicalPrototypes.wrl#Tropical23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical23"}))
    .addChild(new ExternProtoDeclare("Tropical24").setName("Tropical24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical24","TropicalPrototypes.wrl#Tropical24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical24"}))
    .addChild(new ExternProtoDeclare("Tropical25").setName("Tropical25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical25","TropicalPrototypes.wrl#Tropical25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical25"}))
    .addChild(new ExternProtoDeclare("Tropical26").setName("Tropical26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical26","TropicalPrototypes.wrl#Tropical26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical26"}))
    .addChild(new ExternProtoDeclare("Tropical27").setName("Tropical27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical27","TropicalPrototypes.wrl#Tropical27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical27"}))
    .addChild(new ExternProtoDeclare("Tropical28").setName("Tropical28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical28","TropicalPrototypes.wrl#Tropical28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical28"}))
    .addChild(new ExternProtoDeclare("Tropical29").setName("Tropical29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical29","TropicalPrototypes.wrl#Tropical29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical29"}))
    .addChild(new ExternProtoDeclare("Tropical30").setName("Tropical30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical30","TropicalPrototypes.wrl#Tropical30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical30"}))
    .addChild(new ExternProtoDeclare("Tropical31").setName("Tropical31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical31","TropicalPrototypes.wrl#Tropical31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical31"}))
    .addChild(new ExternProtoDeclare("Tropical32").setName("Tropical32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical32","TropicalPrototypes.wrl#Tropical32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical32"}))
    .addChild(new ExternProtoDeclare("Tropical33").setName("Tropical33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical33","TropicalPrototypes.wrl#Tropical33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical33"}))
    .addChild(new ExternProtoDeclare("Tropical34").setName("Tropical34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"TropicalPrototypes.x3d#Tropical34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.x3d#Tropical34","TropicalPrototypes.wrl#Tropical34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.wrl#Tropical34"}))
    .addChild(new Group().setBboxSize(10.5,10.5,2.0)
      .addChild(new NavigationInfo().setHeadlight(false))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("Tropical00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"Tropical00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("Tropical01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("Tropical02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("Tropical03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("Tropical04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("Tropical05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("Tropical06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("Tropical07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("Tropical08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("Tropical09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("Tropical10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("Tropical11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("Tropical12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("Tropical13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("Tropical14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("Tropical15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("Tropical16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("Tropical17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("Tropical18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("Tropical19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("Tropical20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("Tropical21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("Tropical22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("Tropical23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Tropical23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("Tropical24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("Tropical25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("Tropical26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("Tropical27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("Tropical28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("Tropical29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Tropical29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("Tropical30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("Tropical31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("Tropical32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("Tropical33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("Tropical34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Tropical34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Tropical34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Tropical34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"TropicalPrototypes.html#ProtoDeclare_Tropical34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/TropicalPrototypes.html#ProtoDeclare_Tropical24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Tropical34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return TropicalExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new TropicalExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.TropicalExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.TropicalExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/TropicalExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/TropicalExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/TropicalExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/TropicalExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
