package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/SummerExamplesIndex.html" target="_blank">SummerExamples</a>,  source <a href="../../../UniversalMediaMaterials/SummerExamples.java">SummerExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/SummerExamples.x3d">SummerExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class SummerExamples
{
	/** Default constructor to create this object. */
	public SummerExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SummerExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SummerExamples.x3d"))
    .addChild(new ExternProtoDeclare("Summer00").setName("Summer00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer00","SummerPrototypes.wrl#Summer00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer00"}))
    .addChild(new ExternProtoDeclare("Summer01").setName("Summer01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer01","SummerPrototypes.wrl#Summer01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer01"}))
    .addChild(new ExternProtoDeclare("Summer02").setName("Summer02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer02","SummerPrototypes.wrl#Summer02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer02"}))
    .addChild(new ExternProtoDeclare("Summer03").setName("Summer03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer03","SummerPrototypes.wrl#Summer03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer03"}))
    .addChild(new ExternProtoDeclare("Summer04").setName("Summer04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer04","SummerPrototypes.wrl#Summer04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer04"}))
    .addChild(new ExternProtoDeclare("Summer05").setName("Summer05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer05","SummerPrototypes.wrl#Summer05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer05"}))
    .addChild(new ExternProtoDeclare("Summer06").setName("Summer06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer06","SummerPrototypes.wrl#Summer06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer06"}))
    .addChild(new ExternProtoDeclare("Summer07").setName("Summer07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer07","SummerPrototypes.wrl#Summer07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer07"}))
    .addChild(new ExternProtoDeclare("Summer08").setName("Summer08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer08","SummerPrototypes.wrl#Summer08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer08"}))
    .addChild(new ExternProtoDeclare("Summer09").setName("Summer09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer09","SummerPrototypes.wrl#Summer09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer09"}))
    .addChild(new ExternProtoDeclare("Summer10").setName("Summer10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer10","SummerPrototypes.wrl#Summer10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer10"}))
    .addChild(new ExternProtoDeclare("Summer11").setName("Summer11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer11","SummerPrototypes.wrl#Summer11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer11"}))
    .addChild(new ExternProtoDeclare("Summer12").setName("Summer12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer12","SummerPrototypes.wrl#Summer12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer12"}))
    .addChild(new ExternProtoDeclare("Summer13").setName("Summer13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer13","SummerPrototypes.wrl#Summer13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer13"}))
    .addChild(new ExternProtoDeclare("Summer14").setName("Summer14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer14","SummerPrototypes.wrl#Summer14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer14"}))
    .addChild(new ExternProtoDeclare("Summer15").setName("Summer15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer15","SummerPrototypes.wrl#Summer15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer15"}))
    .addChild(new ExternProtoDeclare("Summer16").setName("Summer16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer16","SummerPrototypes.wrl#Summer16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer16"}))
    .addChild(new ExternProtoDeclare("Summer17").setName("Summer17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer17","SummerPrototypes.wrl#Summer17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer17"}))
    .addChild(new ExternProtoDeclare("Summer18").setName("Summer18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer18","SummerPrototypes.wrl#Summer18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer18"}))
    .addChild(new ExternProtoDeclare("Summer19").setName("Summer19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer19","SummerPrototypes.wrl#Summer19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer19"}))
    .addChild(new ExternProtoDeclare("Summer20").setName("Summer20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer20","SummerPrototypes.wrl#Summer20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer20"}))
    .addChild(new ExternProtoDeclare("Summer21").setName("Summer21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer21","SummerPrototypes.wrl#Summer21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer21"}))
    .addChild(new ExternProtoDeclare("Summer22").setName("Summer22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer22","SummerPrototypes.wrl#Summer22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer22"}))
    .addChild(new ExternProtoDeclare("Summer23").setName("Summer23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer23","SummerPrototypes.wrl#Summer23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer23"}))
    .addChild(new ExternProtoDeclare("Summer24").setName("Summer24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer24","SummerPrototypes.wrl#Summer24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer24"}))
    .addChild(new ExternProtoDeclare("Summer25").setName("Summer25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer25","SummerPrototypes.wrl#Summer25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer25"}))
    .addChild(new ExternProtoDeclare("Summer26").setName("Summer26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer26","SummerPrototypes.wrl#Summer26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer26"}))
    .addChild(new ExternProtoDeclare("Summer27").setName("Summer27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer27","SummerPrototypes.wrl#Summer27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer27"}))
    .addChild(new ExternProtoDeclare("Summer28").setName("Summer28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer28","SummerPrototypes.wrl#Summer28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer28"}))
    .addChild(new ExternProtoDeclare("Summer29").setName("Summer29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer29","SummerPrototypes.wrl#Summer29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer29"}))
    .addChild(new ExternProtoDeclare("Summer30").setName("Summer30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer30","SummerPrototypes.wrl#Summer30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer30"}))
    .addChild(new ExternProtoDeclare("Summer31").setName("Summer31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer31","SummerPrototypes.wrl#Summer31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer31"}))
    .addChild(new ExternProtoDeclare("Summer32").setName("Summer32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer32","SummerPrototypes.wrl#Summer32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer32"}))
    .addChild(new ExternProtoDeclare("Summer33").setName("Summer33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer33","SummerPrototypes.wrl#Summer33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer33"}))
    .addChild(new ExternProtoDeclare("Summer34").setName("Summer34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SummerPrototypes.x3d#Summer34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.x3d#Summer34","SummerPrototypes.wrl#Summer34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.wrl#Summer34"}))
    .addChild(new Group().setBboxSize(10.5,10.5,2.0)
      .addChild(new NavigationInfo().setHeadlight(false))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("Summer00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Summer00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"Summer00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("Summer01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Summer01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("Summer02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Summer02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("Summer03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Summer03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("Summer04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Summer04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("Summer05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Summer05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("Summer06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Summer06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("Summer07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Summer07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("Summer08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Summer08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("Summer09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Summer09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("Summer10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Summer10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("Summer11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Summer11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("Summer12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Summer12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("Summer13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Summer13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("Summer14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Summer14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("Summer15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Summer15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("Summer16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Summer16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("Summer17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Summer17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("Summer18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Summer18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("Summer19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Summer19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("Summer20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Summer20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("Summer21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Summer21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("Summer22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Summer22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer2","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("Summer23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Summer23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("Summer24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Summer24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("Summer25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Summer25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("Summer26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Summer26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("Summer27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Summer27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("Summer28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Summer28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("Summer29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Summer29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("Summer30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Summer30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("Summer31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Summer31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("Summer32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Summer32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("Summer33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Summer33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("Summer34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Summer34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Summer34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Summer34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SummerPrototypes.html#ProtoDeclare_Summer34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SummerPrototypes.html#ProtoDeclare_Summer34"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Summer34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SummerExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SummerExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.SummerExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.SummerExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/SummerExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/SummerExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/SummerExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/SummerExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
