package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/SilkyExamplesIndex.html" target="_blank">SilkyExamples</a>,  source <a href="../../../UniversalMediaMaterials/SilkyExamples.java">SilkyExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/SilkyExamples.x3d">SilkyExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class SilkyExamples
{
	/** Default constructor to create this object. */
	public SilkyExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SilkyExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SilkyExamples.x3d"))
    .addChild(new ExternProtoDeclare("Silky00").setName("Silky00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky00","SilkyPrototypes.wrl#Silky00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky00"}))
    .addChild(new ExternProtoDeclare("Silky01").setName("Silky01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky01","SilkyPrototypes.wrl#Silky01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky01"}))
    .addChild(new ExternProtoDeclare("Silky02").setName("Silky02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky02","SilkyPrototypes.wrl#Silky02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky02"}))
    .addChild(new ExternProtoDeclare("Silky03").setName("Silky03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky03","SilkyPrototypes.wrl#Silky03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky03"}))
    .addChild(new ExternProtoDeclare("Silky04").setName("Silky04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky04","SilkyPrototypes.wrl#Silky04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky04"}))
    .addChild(new ExternProtoDeclare("Silky05").setName("Silky05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky05","SilkyPrototypes.wrl#Silky05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky05"}))
    .addChild(new ExternProtoDeclare("Silky06").setName("Silky06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky06","SilkyPrototypes.wrl#Silky06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky06"}))
    .addChild(new ExternProtoDeclare("Silky07").setName("Silky07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky07","SilkyPrototypes.wrl#Silky07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky07"}))
    .addChild(new ExternProtoDeclare("Silky08").setName("Silky08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky08","SilkyPrototypes.wrl#Silky08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky08"}))
    .addChild(new ExternProtoDeclare("Silky09").setName("Silky09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky09","SilkyPrototypes.wrl#Silky09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky09"}))
    .addChild(new ExternProtoDeclare("Silky10").setName("Silky10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky10","SilkyPrototypes.wrl#Silky10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky10"}))
    .addChild(new ExternProtoDeclare("Silky11").setName("Silky11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky11","SilkyPrototypes.wrl#Silky11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky11"}))
    .addChild(new ExternProtoDeclare("Silky12").setName("Silky12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky12","SilkyPrototypes.wrl#Silky12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky12"}))
    .addChild(new ExternProtoDeclare("Silky13").setName("Silky13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky13","SilkyPrototypes.wrl#Silky13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky13"}))
    .addChild(new ExternProtoDeclare("Silky14").setName("Silky14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky14","SilkyPrototypes.wrl#Silky14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky14"}))
    .addChild(new ExternProtoDeclare("Silky15").setName("Silky15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky15","SilkyPrototypes.wrl#Silky15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky15"}))
    .addChild(new ExternProtoDeclare("Silky16").setName("Silky16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky16","SilkyPrototypes.wrl#Silky16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky16"}))
    .addChild(new ExternProtoDeclare("Silky17").setName("Silky17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky17","SilkyPrototypes.wrl#Silky17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky17"}))
    .addChild(new ExternProtoDeclare("Silky18").setName("Silky18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky18","SilkyPrototypes.wrl#Silky18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky18"}))
    .addChild(new ExternProtoDeclare("Silky19").setName("Silky19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky19","SilkyPrototypes.wrl#Silky19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky19"}))
    .addChild(new ExternProtoDeclare("Silky20").setName("Silky20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky20","SilkyPrototypes.wrl#Silky20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky20"}))
    .addChild(new ExternProtoDeclare("Silky21").setName("Silky21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky21","SilkyPrototypes.wrl#Silky21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky20"}))
    .addChild(new ExternProtoDeclare("Silky22").setName("Silky22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky22","SilkyPrototypes.wrl#Silky22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky22"}))
    .addChild(new ExternProtoDeclare("Silky23").setName("Silky23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky23","SilkyPrototypes.wrl#Silky23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky23"}))
    .addChild(new ExternProtoDeclare("Silky24").setName("Silky24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky24","SilkyPrototypes.wrl#Silky24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky24"}))
    .addChild(new ExternProtoDeclare("Silky25").setName("Silky25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky25","SilkyPrototypes.wrl#Silky25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky25"}))
    .addChild(new ExternProtoDeclare("Silky26").setName("Silky26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky26","SilkyPrototypes.wrl#Silky26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky26"}))
    .addChild(new ExternProtoDeclare("Silky27").setName("Silky27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky27","SilkyPrototypes.wrl#Silky27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky27"}))
    .addChild(new ExternProtoDeclare("Silky28").setName("Silky28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky28","SilkyPrototypes.wrl#Silky28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky28"}))
    .addChild(new ExternProtoDeclare("Silky29").setName("Silky29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky29","SilkyPrototypes.wrl#Silky29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky29"}))
    .addChild(new ExternProtoDeclare("Silky30").setName("Silky30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky30","SilkyPrototypes.wrl#Silky30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky30"}))
    .addChild(new ExternProtoDeclare("Silky31").setName("Silky31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky31","SilkyPrototypes.wrl#Silky31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky31"}))
    .addChild(new ExternProtoDeclare("Silky32").setName("Silky32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky32","SilkyPrototypes.wrl#Silky32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky32"}))
    .addChild(new ExternProtoDeclare("Silky33").setName("Silky33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky33","SilkyPrototypes.wrl#Silky33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky33"}))
    .addChild(new ExternProtoDeclare("Silky34").setName("Silky34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SilkyPrototypes.x3d#Silky34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.x3d#Silky34","SilkyPrototypes.wrl#Silky34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.wrl#Silky34"}))
    .addChild(new Group().setBboxSize(10.5,10.5,2.0)
      .addChild(new NavigationInfo().setHeadlight(false))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("Silky00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Silky00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"Silky00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("Silky01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Silky01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("Silky02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Silky02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("Silky03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Silky03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("Silky04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Silky04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("Silky05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Silky05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("Silky06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Silky06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("Silky07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Silky07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("Silky08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Silky08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("Silky09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Silky09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("Silky10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Silky10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("Silky11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Silky11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("Silky12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Silky12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("Silky13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Silky13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky3","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("Silky14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Silky14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("Silky15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Silky15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("Silky16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Silky16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("Silky17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Silky17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("Silky18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Silky18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("Silky19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Silky19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("Silky20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Silky20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("Silky21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Silky21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("Silky22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Silky22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("Silky23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Silky23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("Silky24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Silky24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("Silky25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Silky25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("Silky26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Silky26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("Silky27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Silky27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("Silky28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Silky28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("Silky29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Silky29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("Silky30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Silky30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("Silky31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Silky31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("Silky32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Silky32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("Silky33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Silky33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("Silky34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Silky34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Silky34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Silky34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SilkyPrototypes.html#ProtoDeclare_Silky34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SilkyPrototypes.html#ProtoDeclare_Silky34"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Silky34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SilkyExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SilkyExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.SilkyExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.SilkyExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/SilkyExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/SilkyExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/SilkyExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/SilkyExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
