package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/SheenPrototypesIndex.html" target="_blank">SheenPrototypes</a>,  source <a href="../../../UniversalMediaMaterials/SheenPrototypes.java">SheenPrototypes.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/SheenPrototypes.x3d">SheenPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class SheenPrototypes
{
	/** Default constructor to create this object. */
	public SheenPrototypes ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SheenPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Prototype declarations defining values for X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SheenPrototypes.x3d"))
    .addChild(new ProtoDeclare("Sheen00").setName("Sheen00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.256).setDiffuseColor(0.029158,0.026292,0.026964).setShininess(0.061224).setSpecularColor(0.641609,0.0,0.979592))))
    .addChild(new ProtoDeclare("Sheen01").setName("Sheen01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.453153).setDiffuseColor(0.0,0.125353,0.262167).setShininess(0.157143).setSpecularColor(0.383952,0.0,0.607143))))
    .addChild(new ProtoDeclare("Sheen02").setName("Sheen02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.004294,0.314286).setShininess(0.636364).setSpecularColor(0.364672,0.833805,0.909091))))
    .addChild(new ProtoDeclare("Sheen03").setName("Sheen03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.12078,0.144113,0.314286).setShininess(0.157143).setSpecularColor(0.233325,0.278401,0.607143))))
    .addChild(new ProtoDeclare("Sheen04").setName("Sheen04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.001831,0.0,0.285714).setShininess(0.157143).setSpecularColor(0.15182,0.607143,0.173867))))
    .addChild(new ProtoDeclare("Sheen05").setName("Sheen05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.293167).setDiffuseColor(0.0,0.262167,0.262167).setShininess(0.157143).setSpecularColor(0.383952,0.0,0.607143))))
    .addChild(new ProtoDeclare("Sheen06").setName("Sheen06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.293166).setDiffuseColor(0.0,0.26801,0.265089).setShininess(0.157143).setSpecularColor(0.607143,0.132784,0.175795))))
    .addChild(new ProtoDeclare("Sheen07").setName("Sheen07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.0,0.282514,0.314286).setShininess(0.157143).setSpecularColor(0.233325,0.278401,0.607143))))
    .addChild(new ProtoDeclare("Sheen08").setName("Sheen08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.248982).setDiffuseColor(0.0,0.286882,0.261868).setShininess(0.066326).setSpecularColor(0.243549,0.556863,0.607143))))
    .addChild(new ProtoDeclare("Sheen09").setName("Sheen09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.248982).setDiffuseColor(0.0,0.286882,0.261868).setShininess(0.15).setSpecularColor(0.243549,0.556863,0.607143))))
    .addChild(new ProtoDeclare("Sheen10").setName("Sheen10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.255102).setDiffuseColor(0.024884,0.185628,0.002586).setShininess(0.127551).setSpecularColor(0.505305,0.463899,0.0))))
    .addChild(new ProtoDeclare("Sheen11").setName("Sheen11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.255102).setDiffuseColor(0.024884,0.423143,0.002586).setShininess(0.127551).setSpecularColor(0.505305,0.463899,0.0))))
    .addChild(new ProtoDeclare("Sheen12").setName("Sheen12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.314286,0.314286,0.0).setShininess(0.345455).setSpecularColor(0.367996,0.439089,0.957576))))
    .addChild(new ProtoDeclare("Sheen13").setName("Sheen13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.238213).setDiffuseColor(0.287218,0.299852,0.00588).setShininess(0.157143).setSpecularColor(0.15182,0.607143,0.173867))))
    .addChild(new ProtoDeclare("Sheen14").setName("Sheen14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.255102).setDiffuseColor(0.5,0.476914,0.187954).setShininess(0.081633).setSpecularColor(0.035776,0.591837,0.0))))
    .addChild(new ProtoDeclare("Sheen15").setName("Sheen15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.255102).setDiffuseColor(0.490091,0.5,0.217241).setShininess(0.107143).setSpecularColor(0.565306,0.591837,0.0))))
    .addChild(new ProtoDeclare("Sheen16").setName("Sheen16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.253165).setDiffuseColor(0.403061,0.395404,0.0).setShininess(0.157143).setSpecularColor(0.683673,0.099015,0.0))))
    .addChild(new ProtoDeclare("Sheen17").setName("Sheen17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.022727).setDiffuseColor(0.314286,0.218111,0.0).setShininess(0.157143).setSpecularColor(0.607143,0.53913,0.0))))
    .addChild(new ProtoDeclare("Sheen18").setName("Sheen18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.022727).setDiffuseColor(0.314286,0.139969,0.0).setShininess(0.157143).setSpecularColor(0.607143,0.53913,0.0))))
    .addChild(new ProtoDeclare("Sheen19").setName("Sheen19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.246753).setDiffuseColor(0.336937,0.0,0.111461).setShininess(0.064865).setSpecularColor(0.336183,0.372973,0.001264))))
    .addChild(new ProtoDeclare("Sheen20").setName("Sheen20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.247863).setDiffuseColor(0.42712,0.195852,0.009311).setShininess(0.157143).setSpecularColor(0.233325,0.607143,0.572339))))
    .addChild(new ProtoDeclare("Sheen21").setName("Sheen21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.314286,0.144113,0.006851).setShininess(0.157143).setSpecularColor(0.233325,0.278401,0.607143))))
    .addChild(new ProtoDeclare("Sheen22").setName("Sheen22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.314286,0.011163,0.006851).setShininess(0.8).setSpecularColor(0.381971,0.455764,0.993939))))
    .addChild(new ProtoDeclare("Sheen23").setName("Sheen23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.293166).setDiffuseColor(0.26801,0.0,0.0).setShininess(0.157143).setSpecularColor(0.607143,0.132784,0.175795))))
    .addChild(new ProtoDeclare("Sheen24").setName("Sheen24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.256).setDiffuseColor(0.029158,0.026292,0.026964).setShininess(0.061224).setSpecularColor(0.938776,0.055032,0.055032))))
    .addChild(new ProtoDeclare("Sheen25").setName("Sheen25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.256).setDiffuseColor(0.029158,0.026292,0.026964).setShininess(0.030303).setSpecularColor(0.981818,0.0,0.0))))
    .addChild(new ProtoDeclare("Sheen26").setName("Sheen26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.0).setDiffuseColor(0.262167,0.0,0.0).setShininess(0.157143).setSpecularColor(0.383952,0.0,0.607143))))
    .addChild(new ProtoDeclare("Sheen27").setName("Sheen27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.268711).setDiffuseColor(0.265081,0.0,0.265819).setShininess(0.157143).setSpecularColor(0.607143,0.607143,0.004963))))
    .addChild(new ProtoDeclare("Sheen28").setName("Sheen28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.231704).setDiffuseColor(0.308275,0.0,0.300584).setShininess(0.369697).setSpecularColor(0.236417,0.945455,0.270749))))
    .addChild(new ProtoDeclare("Sheen29").setName("Sheen29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.25).setDiffuseColor(0.273068,0.144113,0.314286).setShininess(0.157143).setSpecularColor(0.233325,0.278401,0.607143))))
    .addChild(new ProtoDeclare("Sheen30").setName("Sheen30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.293167).setDiffuseColor(0.262167,0.0,0.262167).setShininess(0.157143).setSpecularColor(0.383952,0.0,0.607143))))
    .addChild(new ProtoDeclare("Sheen31").setName("Sheen31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.410434).setDiffuseColor(0.348557,0.0,0.795918).setShininess(0.433673).setSpecularColor(0.448482,0.0,0.709184))))
    .addChild(new ProtoDeclare("Sheen32").setName("Sheen32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.2788).setDiffuseColor(0.187413,0.121184,0.25936).setShininess(0.122449).setSpecularColor(0.0,0.625,0.892857))))
    .addChild(new ProtoDeclare("Sheen33").setName("Sheen33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.243244).setDiffuseColor(0.119925,0.060701,0.183051).setShininess(0.086735).setSpecularColor(0.356263,0.383104,0.826531))))
    .addChild(new ProtoDeclare("Sheen34").setName("Sheen34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials")
      .setProtoBody(new ProtoBody()
        .addChild(new Material().setAmbientIntensity(0.243243).setDiffuseColor(0.135374,0.138095,0.183051).setShininess(0.07027).setSpecularColor(0.362217,0.369498,0.489785))))
    .addChild(new Anchor().setDescription("click for examples").setParameter(new String[] {"target=_blank"}).setUrl(new String[] {"SheenExamples.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenExamples.x3d","SheenExamples.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenExamples.wrl"})
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.8,0.4,0.0)))
        .setGeometry(new Text().setString(new String[] {"SantafeExamples.x3d","is a Materials Prototype declaration file.","","For an example scene using these node,","click this text and view","SantafeExamples.x3d"})
          .setFontStyle(new FontStyle().setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.8))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SheenPrototypes model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SheenPrototypes().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.SheenPrototypes\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.SheenPrototypes self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/SheenPrototypes_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/SheenPrototypes_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/SheenPrototypes_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/SheenPrototypes_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
