package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/SheenExamplesIndex.html" target="_blank">SheenExamples</a>,  source <a href="../../../UniversalMediaMaterials/SheenExamples.java">SheenExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/SheenExamples.x3d">SheenExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class SheenExamples
{
	/** Default constructor to create this object. */
	public SheenExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SheenExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SheenExamples.x3d"))
    .addChild(new ExternProtoDeclare("Sheen00").setName("Sheen00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen00","SheenPrototypes.wrl#Sheen00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen00"}))
    .addChild(new ExternProtoDeclare("Sheen01").setName("Sheen01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen01","SheenPrototypes.wrl#Sheen01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen01"}))
    .addChild(new ExternProtoDeclare("Sheen02").setName("Sheen02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen02","SheenPrototypes.wrl#Sheen02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen02"}))
    .addChild(new ExternProtoDeclare("Sheen03").setName("Sheen03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen03","SheenPrototypes.wrl#Sheen03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen03"}))
    .addChild(new ExternProtoDeclare("Sheen04").setName("Sheen04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen04","SheenPrototypes.wrl#Sheen04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen04"}))
    .addChild(new ExternProtoDeclare("Sheen05").setName("Sheen05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen05","SheenPrototypes.wrl#Sheen05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen05"}))
    .addChild(new ExternProtoDeclare("Sheen06").setName("Sheen06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen06","SheenPrototypes.wrl#Sheen06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen06"}))
    .addChild(new ExternProtoDeclare("Sheen07").setName("Sheen07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen07","SheenPrototypes.wrl#Sheen07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen07"}))
    .addChild(new ExternProtoDeclare("Sheen08").setName("Sheen08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen08","SheenPrototypes.wrl#Sheen08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen08"}))
    .addChild(new ExternProtoDeclare("Sheen09").setName("Sheen09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen09","SheenPrototypes.wrl#Sheen09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen09"}))
    .addChild(new ExternProtoDeclare("Sheen10").setName("Sheen10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen10","SheenPrototypes.wrl#Sheen10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen10"}))
    .addChild(new ExternProtoDeclare("Sheen11").setName("Sheen11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen11","SheenPrototypes.wrl#Sheen11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen11"}))
    .addChild(new ExternProtoDeclare("Sheen12").setName("Sheen12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen12","SheenPrototypes.wrl#Sheen12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen12"}))
    .addChild(new ExternProtoDeclare("Sheen13").setName("Sheen13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen13","SheenPrototypes.wrl#Sheen13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen13"}))
    .addChild(new ExternProtoDeclare("Sheen14").setName("Sheen14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen14","SheenPrototypes.wrl#Sheen14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen14"}))
    .addChild(new ExternProtoDeclare("Sheen15").setName("Sheen15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen15","SheenPrototypes.wrl#Sheen15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen15"}))
    .addChild(new ExternProtoDeclare("Sheen16").setName("Sheen16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen16","SheenPrototypes.wrl#Sheen16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen16"}))
    .addChild(new ExternProtoDeclare("Sheen17").setName("Sheen17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen17","SheenPrototypes.wrl#Sheen17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen17"}))
    .addChild(new ExternProtoDeclare("Sheen18").setName("Sheen18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen18","SheenPrototypes.wrl#Sheen18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen18"}))
    .addChild(new ExternProtoDeclare("Sheen19").setName("Sheen19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen19","SheenPrototypes.wrl#Sheen19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen19"}))
    .addChild(new ExternProtoDeclare("Sheen20").setName("Sheen20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen20","SheenPrototypes.wrl#Sheen20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen20"}))
    .addChild(new ExternProtoDeclare("Sheen21").setName("Sheen21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen21","SheenPrototypes.wrl#Sheen21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen21"}))
    .addChild(new ExternProtoDeclare("Sheen22").setName("Sheen22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen22","SheenPrototypes.wrl#Sheen22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen22"}))
    .addChild(new ExternProtoDeclare("Sheen23").setName("Sheen23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen23","SheenPrototypes.wrl#Sheen23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen23"}))
    .addChild(new ExternProtoDeclare("Sheen24").setName("Sheen24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen24","SheenPrototypes.wrl#Sheen24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen24"}))
    .addChild(new ExternProtoDeclare("Sheen25").setName("Sheen25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen25","SheenPrototypes.wrl#Sheen25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen25"}))
    .addChild(new ExternProtoDeclare("Sheen26").setName("Sheen26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen26","SheenPrototypes.wrl#Sheen26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen26"}))
    .addChild(new ExternProtoDeclare("Sheen27").setName("Sheen27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen27","SheenPrototypes.wrl#Sheen27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen27"}))
    .addChild(new ExternProtoDeclare("Sheen28").setName("Sheen28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen28","SheenPrototypes.wrl#Sheen28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen28"}))
    .addChild(new ExternProtoDeclare("Sheen29").setName("Sheen29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen29","SheenPrototypes.wrl#Sheen29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen29"}))
    .addChild(new ExternProtoDeclare("Sheen30").setName("Sheen30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen30","SheenPrototypes.wrl#Sheen30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen30"}))
    .addChild(new ExternProtoDeclare("Sheen31").setName("Sheen31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen31","SheenPrototypes.wrl#Sheen31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen31"}))
    .addChild(new ExternProtoDeclare("Sheen32").setName("Sheen32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen32","SheenPrototypes.wrl#Sheen32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen32"}))
    .addChild(new ExternProtoDeclare("Sheen33").setName("Sheen33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen33","SheenPrototypes.wrl#Sheen33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen33"}))
    .addChild(new ExternProtoDeclare("Sheen34").setName("Sheen34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SheenPrototypes.x3d#Sheen34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.x3d#Sheen34","SheenPrototypes.wrl#Sheen34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.wrl#Sheen34"}))
    .addChild(new Group()
      .addChild(new NavigationInfo().setHeadlight(false))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("Sheen00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"Sheen00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("Sheen01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("Sheen02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("Sheen03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("Sheen04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("Sheen05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("Sheen06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("Sheen07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("Sheen08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("Sheen09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("Sheen10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("Sheen11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("Sheen12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("Sheen13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("Sheen14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("Sheen15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("Sheen16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("Sheen17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("Sheen18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("Sheen19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("Sheen20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("Sheen21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("Sheen22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("Sheen23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Sheen23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("Sheen24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("Sheen25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("Sheen26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("Sheen27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("Sheen28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("Sheen29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Sheen29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("Sheen30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("Sheen31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("Sheen32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("Sheen33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("Sheen34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Sheen34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Sheen34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Sheen34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SheenPrototypes.html#ProtoDeclare_Sheen34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SheenPrototypes.html#ProtoDeclare_Sheen34"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Sheen34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SheenExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SheenExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.SheenExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.SheenExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/SheenExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/SheenExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/SheenExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/SheenExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
