package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/SantaFeExamplesIndex.html" target="_blank">SantaFeExamples</a>,  source <a href="../../../UniversalMediaMaterials/SantaFeExamples.java">SantaFeExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/SantaFeExamples.x3d">SantaFeExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFeExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFeExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class SantaFeExamples
{
	/** Default constructor to create this object. */
	public SantaFeExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SantaFeExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFeExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SantaFeExamples.x3d"))
    .addChild(new ExternProtoDeclare("SantaFe00").setName("SantaFe00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe00","SantaFePrototypes.wrl#SantaFe00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe00"}))
    .addChild(new ExternProtoDeclare("SantaFe01").setName("SantaFe01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe01","SantaFePrototypes.wrl#SantaFe01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe01"}))
    .addChild(new ExternProtoDeclare("SantaFe02").setName("SantaFe02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe02","SantaFePrototypes.wrl#SantaFe02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe02"}))
    .addChild(new ExternProtoDeclare("SantaFe03").setName("SantaFe03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe03","SantaFePrototypes.wrl#SantaFe03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe03"}))
    .addChild(new ExternProtoDeclare("SantaFe04").setName("SantaFe04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe04","SantaFePrototypes.wrl#SantaFe04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe04"}))
    .addChild(new ExternProtoDeclare("SantaFe05").setName("SantaFe05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe05","SantaFePrototypes.wrl#SantaFe05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe05"}))
    .addChild(new ExternProtoDeclare("SantaFe06").setName("SantaFe06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe06","SantaFePrototypes.wrl#SantaFe06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe06"}))
    .addChild(new ExternProtoDeclare("SantaFe07").setName("SantaFe07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe07","SantaFePrototypes.wrl#SantaFe07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe07"}))
    .addChild(new ExternProtoDeclare("SantaFe08").setName("SantaFe08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe08","SantaFePrototypes.wrl#SantaFe08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe08"}))
    .addChild(new ExternProtoDeclare("SantaFe09").setName("SantaFe09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe09","SantaFePrototypes.wrl#SantaFe09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe09"}))
    .addChild(new ExternProtoDeclare("SantaFe10").setName("SantaFe10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe10","SantaFePrototypes.wrl#SantaFe10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe10"}))
    .addChild(new ExternProtoDeclare("SantaFe11").setName("SantaFe11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe11","SantaFePrototypes.wrl#SantaFe11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe11"}))
    .addChild(new ExternProtoDeclare("SantaFe12").setName("SantaFe12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe12","SantaFePrototypes.wrl#SantaFe12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe12"}))
    .addChild(new ExternProtoDeclare("SantaFe13").setName("SantaFe13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe13","SantaFePrototypes.wrl#SantaFe13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe13"}))
    .addChild(new ExternProtoDeclare("SantaFe14").setName("SantaFe14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe14","SantaFePrototypes.wrl#SantaFe14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe14"}))
    .addChild(new ExternProtoDeclare("SantaFe15").setName("SantaFe15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe15","SantaFePrototypes.wrl#SantaFe15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe15"}))
    .addChild(new ExternProtoDeclare("SantaFe16").setName("SantaFe16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe16","SantaFePrototypes.wrl#SantaFe16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe16"}))
    .addChild(new ExternProtoDeclare("SantaFe17").setName("SantaFe17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe17","SantaFePrototypes.wrl#SantaFe17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe17"}))
    .addChild(new ExternProtoDeclare("SantaFe18").setName("SantaFe18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe18","SantaFePrototypes.wrl#SantaFe18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe18"}))
    .addChild(new ExternProtoDeclare("SantaFe19").setName("SantaFe19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe19","SantaFePrototypes.wrl#SantaFe19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe19"}))
    .addChild(new ExternProtoDeclare("SantaFe20").setName("SantaFe20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe20","SantaFePrototypes.wrl#SantaFe20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe20"}))
    .addChild(new ExternProtoDeclare("SantaFe21").setName("SantaFe21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe21","SantaFePrototypes.wrl#SantaFe21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe21"}))
    .addChild(new ExternProtoDeclare("SantaFe22").setName("SantaFe22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe22","SantaFePrototypes.wrl#SantaFe22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe22"}))
    .addChild(new ExternProtoDeclare("SantaFe23").setName("SantaFe23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe23","SantaFePrototypes.wrl#SantaFe23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe23"}))
    .addChild(new ExternProtoDeclare("SantaFe24").setName("SantaFe24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe24","SantaFePrototypes.wrl#SantaFe24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe24"}))
    .addChild(new ExternProtoDeclare("SantaFe25").setName("SantaFe25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe25","SantaFePrototypes.wrl#SantaFe25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe25"}))
    .addChild(new ExternProtoDeclare("SantaFe26").setName("SantaFe26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe26","SantaFePrototypes.wrl#SantaFe26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe26"}))
    .addChild(new ExternProtoDeclare("SantaFe27").setName("SantaFe27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe27","SantaFePrototypes.wrl#SantaFe27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe27"}))
    .addChild(new ExternProtoDeclare("SantaFe28").setName("SantaFe28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe28","SantaFePrototypes.wrl#SantaFe28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe28"}))
    .addChild(new ExternProtoDeclare("SantaFe29").setName("SantaFe29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe29","SantaFePrototypes.wrl#SantaFe29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe29"}))
    .addChild(new ExternProtoDeclare("SantaFe30").setName("SantaFe30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe30","SantaFePrototypes.wrl#SantaFe30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe30"}))
    .addChild(new ExternProtoDeclare("SantaFe31").setName("SantaFe31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe31","SantaFePrototypes.wrl#SantaFe31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe31"}))
    .addChild(new ExternProtoDeclare("SantaFe32").setName("SantaFe32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe32","SantaFePrototypes.wrl#SantaFe32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe32"}))
    .addChild(new ExternProtoDeclare("SantaFe33").setName("SantaFe33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe33","SantaFePrototypes.wrl#SantaFe33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe33"}))
    .addChild(new ExternProtoDeclare("SantaFe34").setName("SantaFe34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"SantaFePrototypes.x3d#SantaFe34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.x3d#SantaFe34","SantaFePrototypes.wrl#SantaFe34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.wrl#SantaFe34"}))
    .addChild(new Group()
      .addChild(new NavigationInfo().setHeadlight(false))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("SantaFe00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"SantaFe00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("SantaFe01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("SantaFe02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("SantaFe03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("SantaFe04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("SantaFe05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("SantaFe06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("SantaFe07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("SantaFe08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("SantaFe09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("SantaFe10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("SantaFe11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("SantaFe12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("SantaFe13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("SantaFe14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("SantaFe15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("SantaFe16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe6","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("SantaFe17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe7","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("SantaFe18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("SantaFe19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("SantaFe20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("SantaFe21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("SantaFe22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("SantaFe23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("SantaFe24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("SantaFe25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe5","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("SantaFe26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe6","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("SantaFe27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("SantaFe28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("SantaFe29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("SantaFe29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("SantaFe30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("SantaFe31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("SantaFe32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("SantaFe33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("SantaFe34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("SantaFe34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("SantaFe34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("SantaFe34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"SantaFePrototypes.html#ProtoDeclare_SantaFe34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/SantaFePrototypes.html#ProtoDeclare_SantaFe34"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"SantaFe34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SantaFeExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SantaFeExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.SantaFeExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.SantaFeExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/SantaFeExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/SantaFeExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/SantaFeExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/SantaFeExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
