package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/RococoExamplesIndex.html" target="_blank">RococoExamples</a>,  source <a href="../../../UniversalMediaMaterials/RococoExamples.java">RococoExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/RococoExamples.x3d">RococoExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class RococoExamples
{
	/** Default constructor to create this object. */
	public RococoExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("RococoExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("RococoExamples.x3d"))
    .addChild(new ExternProtoDeclare("Rococo00").setName("Rococo00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo00","RococoPrototypes.wrl#Rococo00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo00"}))
    .addChild(new ExternProtoDeclare("Rococo01").setName("Rococo01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo01","RococoPrototypes.wrl#Rococo01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo01"}))
    .addChild(new ExternProtoDeclare("Rococo02").setName("Rococo02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo02","RococoPrototypes.wrl#Rococo02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo02"}))
    .addChild(new ExternProtoDeclare("Rococo03").setName("Rococo03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo03","RococoPrototypes.wrl#Rococo03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo03"}))
    .addChild(new ExternProtoDeclare("Rococo04").setName("Rococo04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo04","RococoPrototypes.wrl#Rococo04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo04"}))
    .addChild(new ExternProtoDeclare("Rococo05").setName("Rococo05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo05","RococoPrototypes.wrl#Rococo05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo05"}))
    .addChild(new ExternProtoDeclare("Rococo06").setName("Rococo06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo06","RococoPrototypes.wrl#Rococo06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo06"}))
    .addChild(new ExternProtoDeclare("Rococo07").setName("Rococo07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo07","RococoPrototypes.wrl#Rococo07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo07"}))
    .addChild(new ExternProtoDeclare("Rococo08").setName("Rococo08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo08","RococoPrototypes.wrl#Rococo08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo08"}))
    .addChild(new ExternProtoDeclare("Rococo09").setName("Rococo09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo09","RococoPrototypes.wrl#Rococo09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo09"}))
    .addChild(new ExternProtoDeclare("Rococo10").setName("Rococo10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo10","RococoPrototypes.wrl#Rococo10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo10"}))
    .addChild(new ExternProtoDeclare("Rococo11").setName("Rococo11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo11","RococoPrototypes.wrl#Rococo11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo11"}))
    .addChild(new ExternProtoDeclare("Rococo12").setName("Rococo12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo12","RococoPrototypes.wrl#Rococo12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo12"}))
    .addChild(new ExternProtoDeclare("Rococo13").setName("Rococo13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo13","RococoPrototypes.wrl#Rococo13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo13"}))
    .addChild(new ExternProtoDeclare("Rococo14").setName("Rococo14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo14","RococoPrototypes.wrl#Rococo14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo14"}))
    .addChild(new ExternProtoDeclare("Rococo15").setName("Rococo15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo15","RococoPrototypes.wrl#Rococo15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo15"}))
    .addChild(new ExternProtoDeclare("Rococo16").setName("Rococo16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo16","RococoPrototypes.wrl#Rococo16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo16"}))
    .addChild(new ExternProtoDeclare("Rococo17").setName("Rococo17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo17","RococoPrototypes.wrl#Rococo17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo17"}))
    .addChild(new ExternProtoDeclare("Rococo18").setName("Rococo18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo18","RococoPrototypes.wrl#Rococo18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo18"}))
    .addChild(new ExternProtoDeclare("Rococo19").setName("Rococo19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo19","RococoPrototypes.wrl#Rococo19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo19"}))
    .addChild(new ExternProtoDeclare("Rococo20").setName("Rococo20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo20","RococoPrototypes.wrl#Rococo20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo20"}))
    .addChild(new ExternProtoDeclare("Rococo21").setName("Rococo21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo21","RococoPrototypes.wrl#Rococo21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo21"}))
    .addChild(new ExternProtoDeclare("Rococo22").setName("Rococo22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo22","RococoPrototypes.wrl#Rococo22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo22"}))
    .addChild(new ExternProtoDeclare("Rococo23").setName("Rococo23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo23","RococoPrototypes.wrl#Rococo23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo23"}))
    .addChild(new ExternProtoDeclare("Rococo24").setName("Rococo24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo24","RococoPrototypes.wrl#Rococo24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo24"}))
    .addChild(new ExternProtoDeclare("Rococo25").setName("Rococo25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo25","RococoPrototypes.wrl#Rococo25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo25"}))
    .addChild(new ExternProtoDeclare("Rococo26").setName("Rococo26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo26","RococoPrototypes.wrl#Rococo26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo26"}))
    .addChild(new ExternProtoDeclare("Rococo27").setName("Rococo27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo27","RococoPrototypes.wrl#Rococo27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo27"}))
    .addChild(new ExternProtoDeclare("Rococo28").setName("Rococo28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo28","RococoPrototypes.wrl#Rococo28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo28"}))
    .addChild(new ExternProtoDeclare("Rococo29").setName("Rococo29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo29","RococoPrototypes.wrl#Rococo29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo29"}))
    .addChild(new ExternProtoDeclare("Rococo30").setName("Rococo30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo30","RococoPrototypes.wrl#Rococo30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo30"}))
    .addChild(new ExternProtoDeclare("Rococo31").setName("Rococo31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo31","RococoPrototypes.wrl#Rococo31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo31"}))
    .addChild(new ExternProtoDeclare("Rococo32").setName("Rococo32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo32","RococoPrototypes.wrl#Rococo32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo32"}))
    .addChild(new ExternProtoDeclare("Rococo33").setName("Rococo33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo33","RococoPrototypes.wrl#Rococo33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo33"}))
    .addChild(new ExternProtoDeclare("Rococo34").setName("Rococo34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"RococoPrototypes.x3d#Rococo34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.x3d#Rococo34","RococoPrototypes.wrl#Rococo34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.wrl#Rococo34"}))
    .addChild(new Group()
      .addChild(new NavigationInfo().setHeadlight(false))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("Rococo00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"Rococo00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("Rococo01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("Rococo02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("Rococo03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("Rococo04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("Rococo05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("Rococo06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("Rococo07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("Rococo08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("Rococo09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("Rococo10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("Rococo11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("Rococo12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("Rococo13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("Rococo14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("Rococo15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("Rococo16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("Rococo17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("Rococo18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("Rococo19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("Rococo20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("Rococo21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo1","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("Rococo22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo2","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("Rococo23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Rococo23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("Rococo24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("Rococo25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("Rococo26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo6","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("Rococo27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("Rococo28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo8","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("Rococo29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Rococo29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("Rococo30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("Rococo31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("Rococo32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("Rococo33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("Rococo34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Rococo34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Rococo34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Rococo34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"RococoPrototypes.html#ProtoDeclare_Rococo34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/RococoPrototypes.html#ProtoDeclare_Rococo34"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Rococo34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return RococoExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new RococoExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.RococoExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.RococoExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/RococoExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/RococoExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/RococoExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/RococoExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
