package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/MetalsExamplesIndex.html" target="_blank">MetalsExamples</a>,  source <a href="../../../UniversalMediaMaterials/MetalsExamples.java">MetalsExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/MetalsExamples.x3d">MetalsExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class MetalsExamples
{
	/** Default constructor to create this object. */
	public MetalsExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MetalsExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MetalsExamples.x3d"))
    .addChild(new ExternProtoDeclare("Metal00").setName("Metal00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal00","MetalsPrototypes.wrl#Metal00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal00"}))
    .addChild(new ExternProtoDeclare("Metal01").setName("Metal01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal01","MetalsPrototypes.wrl#Metal01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal01"}))
    .addChild(new ExternProtoDeclare("Metal02").setName("Metal02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal02","MetalsPrototypes.wrl#Metal02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal02"}))
    .addChild(new ExternProtoDeclare("Metal03").setName("Metal03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal03","MetalsPrototypes.wrl#Metal03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal03"}))
    .addChild(new ExternProtoDeclare("Metal04").setName("Metal04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal04","MetalsPrototypes.wrl#Metal04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal04"}))
    .addChild(new ExternProtoDeclare("Metal05").setName("Metal05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal05","MetalsPrototypes.wrl#Metal05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal05"}))
    .addChild(new ExternProtoDeclare("Metal06").setName("Metal06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal06","MetalsPrototypes.wrl#Metal06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal06"}))
    .addChild(new ExternProtoDeclare("Metal07").setName("Metal07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal07","MetalsPrototypes.wrl#Metal07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal07"}))
    .addChild(new ExternProtoDeclare("Metal08").setName("Metal08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal08","MetalsPrototypes.wrl#Metal08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal08"}))
    .addChild(new ExternProtoDeclare("Metal09").setName("Metal09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal09","MetalsPrototypes.wrl#Metal09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal09"}))
    .addChild(new ExternProtoDeclare("Metal10").setName("Metal10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal10","MetalsPrototypes.wrl#Metal10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal10"}))
    .addChild(new ExternProtoDeclare("Metal11").setName("Metal11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal11","MetalsPrototypes.wrl#Metal11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal11"}))
    .addChild(new ExternProtoDeclare("Metal12").setName("Metal12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal12","MetalsPrototypes.wrl#Metal12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal12"}))
    .addChild(new ExternProtoDeclare("Metal13").setName("Metal13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal13","MetalsPrototypes.wrl#Metal13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal13"}))
    .addChild(new ExternProtoDeclare("Metal14").setName("Metal14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal14","MetalsPrototypes.wrl#Metal14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal14"}))
    .addChild(new ExternProtoDeclare("Metal15").setName("Metal15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal15","MetalsPrototypes.wrl#Metal15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal15"}))
    .addChild(new ExternProtoDeclare("Metal16").setName("Metal16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal16","MetalsPrototypes.wrl#Metal16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal16"}))
    .addChild(new ExternProtoDeclare("Metal17").setName("Metal17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal17","MetalsPrototypes.wrl#Metal17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal17"}))
    .addChild(new ExternProtoDeclare("Metal18").setName("Metal18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal18","MetalsPrototypes.wrl#Metal18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal18"}))
    .addChild(new ExternProtoDeclare("Metal19").setName("Metal19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal19","MetalsPrototypes.wrl#Metal19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal19"}))
    .addChild(new ExternProtoDeclare("Metal20").setName("Metal20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal20","MetalsPrototypes.wrl#Metal20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal20"}))
    .addChild(new ExternProtoDeclare("Metal21").setName("Metal21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal21","MetalsPrototypes.wrl#Metal21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal21"}))
    .addChild(new ExternProtoDeclare("Metal22").setName("Metal22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal22","MetalsPrototypes.wrl#Metal22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal22"}))
    .addChild(new ExternProtoDeclare("Metal23").setName("Metal23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal23","MetalsPrototypes.wrl#Metal23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal23"}))
    .addChild(new ExternProtoDeclare("Metal24").setName("Metal24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal24","MetalsPrototypes.wrl#Metal24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal24"}))
    .addChild(new ExternProtoDeclare("Metal25").setName("Metal25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal25","MetalsPrototypes.wrl#Metal25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal25"}))
    .addChild(new ExternProtoDeclare("Metal26").setName("Metal26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal26","MetalsPrototypes.wrl#Metal26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal26"}))
    .addChild(new ExternProtoDeclare("Metal27").setName("Metal27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal27","MetalsPrototypes.wrl#Metal27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal27"}))
    .addChild(new ExternProtoDeclare("Metal28").setName("Metal28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal28","MetalsPrototypes.wrl#Metal28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal28"}))
    .addChild(new ExternProtoDeclare("Metal29").setName("Metal29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal29","MetalsPrototypes.wrl#Metal29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal29"}))
    .addChild(new ExternProtoDeclare("Metal30").setName("Metal30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal30","MetalsPrototypes.wrl#Metal30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal30"}))
    .addChild(new ExternProtoDeclare("Metal31").setName("Metal31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal31","MetalsPrototypes.wrl#Metal31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal31"}))
    .addChild(new ExternProtoDeclare("Metal32").setName("Metal32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal32","MetalsPrototypes.wrl#Metal32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal32"}))
    .addChild(new ExternProtoDeclare("Metal33").setName("Metal33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal33","MetalsPrototypes.wrl#Metal33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal33"}))
    .addChild(new ExternProtoDeclare("Metal34").setName("Metal34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"MetalsPrototypes.x3d#Metal34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.x3d#Metal34","MetalsPrototypes.wrl#Metal34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.wrl#Metal34"}))
    .addChild(new Group()
      .addChild(new NavigationInfo().setHeadlight(false).setType("\"EXAMINE\""))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("Metal00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Metal00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"Metal00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("Metal01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Metal01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("Metal02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Metal02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("Metal03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Metal03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("Metal04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Metal04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("Metal05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Metal05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("Metal06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Metal06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("Metal07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Metal07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("Metal08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Metal08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("Metal09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Metal09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("Metal10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Metal10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("Metal11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Metal11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal1","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("Metal12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Metal12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal2","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("Metal13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Metal13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("Metal14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Metal14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("Metal15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Metal15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("Metal16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Metal16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal6","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("Metal17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Metal17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("Metal18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Metal18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("Metal19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Metal19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("Metal20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Metal20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("Metal21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Metal21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("Metal22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Metal22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal2","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("Metal23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Metal23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal3","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("Metal24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Metal24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("Metal25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Metal25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("Metal26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Metal26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("Metal27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Metal27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("Metal28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Metal28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("Metal29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Metal29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("Metal30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Metal30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("Metal31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Metal31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("Metal32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Metal32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("Metal33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Metal33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("Metal34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Metal34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Metal34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Metal34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"MetalsPrototypes.html#ProtoDeclare_Metal34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/MetalsPrototypes.html#ProtoDeclare_Metal34"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Metal34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MetalsExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MetalsExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.MetalsExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.MetalsExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/MetalsExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/MetalsExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/MetalsExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/MetalsExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
