package Basic.UniversalMediaMaterials;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </p>
 <p> Related links: Catalog page <a href="../../../UniversalMediaMaterials/GlassExamplesIndex.html" target="_blank">GlassExamples</a>,  source <a href="../../../UniversalMediaMaterials/GlassExamples.java">GlassExamples.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/GlassExamples.x3d">GlassExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David Roussel </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> James Harney, Don Brutzman NPS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 7 April 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 19 January 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://vrmlstuff.free.fr/materials" target="_blank">http://vrmlstuff.free.fr/materials</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> Universal Media Material Library </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassExamples.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassExamples.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../UniversalMediaMaterials/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David Roussel
 */

public class GlassExamples
{
	/** Default constructor to create this object. */
	public GlassExamples ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("GlassExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example ExternProtoDeclare/ProtoInstance usage of X3D/VRML materials, originally converted from SGI's Open Inventor material examples."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David Roussel"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("James Harney, Don Brutzman NPS"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("7 April 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("19 January 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://vrmlstuff.free.fr/materials"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("Universal Media Material Library"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassExamples.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("GlassExamples.x3d"))
    .addChild(new ExternProtoDeclare("Glass00").setName("Glass00").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass00","GlassPrototypes.wrl#Glass00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass00"}))
    .addChild(new ExternProtoDeclare("Glass01").setName("Glass01").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass01","GlassPrototypes.wrl#Glass01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass01"}))
    .addChild(new ExternProtoDeclare("Glass02").setName("Glass02").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass02","GlassPrototypes.wrl#Glass02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass02"}))
    .addChild(new ExternProtoDeclare("Glass03").setName("Glass03").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass03","GlassPrototypes.wrl#Glass03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass03"}))
    .addChild(new ExternProtoDeclare("Glass04").setName("Glass04").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass04","GlassPrototypes.wrl#Glass04","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass04"}))
    .addChild(new ExternProtoDeclare("Glass05").setName("Glass05").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass05","GlassPrototypes.wrl#Glass05","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass05"}))
    .addChild(new ExternProtoDeclare("Glass06").setName("Glass06").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass06","GlassPrototypes.wrl#Glass06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass06"}))
    .addChild(new ExternProtoDeclare("Glass07").setName("Glass07").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass07","GlassPrototypes.wrl#Glass07","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass07"}))
    .addChild(new ExternProtoDeclare("Glass08").setName("Glass08").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass08","GlassPrototypes.wrl#Glass08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass08"}))
    .addChild(new ExternProtoDeclare("Glass09").setName("Glass09").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass09","GlassPrototypes.wrl#Glass09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass09"}))
    .addChild(new ExternProtoDeclare("Glass10").setName("Glass10").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass10","GlassPrototypes.wrl#Glass10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass10"}))
    .addChild(new ExternProtoDeclare("Glass11").setName("Glass11").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass11","GlassPrototypes.wrl#Glass11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass11"}))
    .addChild(new ExternProtoDeclare("Glass12").setName("Glass12").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass12","GlassPrototypes.wrl#Glass12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass12"}))
    .addChild(new ExternProtoDeclare("Glass13").setName("Glass13").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass13","GlassPrototypes.wrl#Glass13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass13"}))
    .addChild(new ExternProtoDeclare("Glass14").setName("Glass14").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass14","GlassPrototypes.wrl#Glass14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass14"}))
    .addChild(new ExternProtoDeclare("Glass15").setName("Glass15").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass15","GlassPrototypes.wrl#Glass15","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass15"}))
    .addChild(new ExternProtoDeclare("Glass16").setName("Glass16").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass16","GlassPrototypes.wrl#Glass16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass16"}))
    .addChild(new ExternProtoDeclare("Glass17").setName("Glass17").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass17","GlassPrototypes.wrl#Glass17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass17"}))
    .addChild(new ExternProtoDeclare("Glass18").setName("Glass18").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass18","GlassPrototypes.wrl#Glass18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass18"}))
    .addChild(new ExternProtoDeclare("Glass19").setName("Glass19").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass19","GlassPrototypes.wrl#Glass19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass19"}))
    .addChild(new ExternProtoDeclare("Glass20").setName("Glass20").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass20","GlassPrototypes.wrl#Glass20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass20"}))
    .addChild(new ExternProtoDeclare("Glass21").setName("Glass21").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass21","GlassPrototypes.wrl#Glass21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass21"}))
    .addChild(new ExternProtoDeclare("Glass22").setName("Glass22").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass22","GlassPrototypes.wrl#Glass22","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass22"}))
    .addChild(new ExternProtoDeclare("Glass23").setName("Glass23").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass23","GlassPrototypes.wrl#Glass23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass23"}))
    .addChild(new ExternProtoDeclare("Glass24").setName("Glass24").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass24","GlassPrototypes.wrl#Glass24","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass24"}))
    .addChild(new ExternProtoDeclare("Glass25").setName("Glass25").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass25","GlassPrototypes.wrl#Glass25","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass25"}))
    .addChild(new ExternProtoDeclare("Glass26").setName("Glass26").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass26","GlassPrototypes.wrl#Glass26","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass26"}))
    .addChild(new ExternProtoDeclare("Glass27").setName("Glass27").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass27","GlassPrototypes.wrl#Glass27","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass27"}))
    .addChild(new ExternProtoDeclare("Glass28").setName("Glass28").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass28","GlassPrototypes.wrl#Glass28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass28"}))
    .addChild(new ExternProtoDeclare("Glass29").setName("Glass29").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass29","GlassPrototypes.wrl#Glass29","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass29"}))
    .addChild(new ExternProtoDeclare("Glass30").setName("Glass30").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass30","GlassPrototypes.wrl#Glass30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass30"}))
    .addChild(new ExternProtoDeclare("Glass31").setName("Glass31").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass31","GlassPrototypes.wrl#Glass31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass31"}))
    .addChild(new ExternProtoDeclare("Glass32").setName("Glass32").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass32","GlassPrototypes.wrl#Glass32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass32"}))
    .addChild(new ExternProtoDeclare("Glass33").setName("Glass33").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass33","GlassPrototypes.wrl#Glass33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass33"}))
    .addChild(new ExternProtoDeclare("Glass34").setName("Glass34").setAppinfo("UniversalMediaMaterials prototype").setDocumentation("https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials").setUrl(new String[] {"GlassPrototypes.x3d#Glass34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.x3d#Glass34","GlassPrototypes.wrl#Glass34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.wrl#Glass34"}))
    .addChild(new Group()
      .addChild(new NavigationInfo().setHeadlight(false))
      .addChild(new Viewpoint("Front").setDescription("Front view").setPosition(0.0,0.0,12.0))
      .addChild(new Viewpoint("PersRight").setDescription("Low Right").setOrientation(0.74291,0.30772,0.59447,1.2171).setPosition(6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("PersLeft").setDescription("Low Left").setOrientation(0.74291,-0.30772,-0.59447,1.2171).setPosition(-6.9282,-6.9282,6.9282))
      .addChild(new Viewpoint("Back").setDescription("Back view").setOrientation(0.0,1.0,0.0,3.1416).setPosition(0.0,0.0,-12.0))
      .addChild(new Transform("Close_travel")
        .addChild(new PositionInterpolator("Close_Mover").setKey(new double[] {0.0,0.25,0.5,0.75,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,2.5,0.0,0.0,0.0,0.0,0.0,-2.5,0.0,0.0,0.0,0.0,0.0,2.5,0.0})))
        .addChild(new TimeSensor("Close_Time").setCycleInterval(12.0).setLoop(true))
        .addChild(new Viewpoint("Close").setDescription("Close Front").setPosition(0.0,0.0,6.0)))
      .addChild(new DirectionalLight().setDirection(1.0,-1.0,-1.0))
      .addChild(new DirectionalLight().setDirection(0.0,1.0,-0.5).setIntensity(0.5))
      .addChild(new Anchor().setDescription("Return to front view").setUrl(new String[] {"#Front"})
        .addChild(new Transform().setTranslation(0.0,0.0,-0.5)
          .addChild(new Inline().setUrl(new String[] {"gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d","gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl"}))))
      .addChild(new Viewpoint("View00").setDescription("Glass00").setPosition(-3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Glass00 view").setUrl(new String[] {"#View00"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass00").setContainerField("material")))
            .setGeometry(new Sphere("Ball").setRadius(0.5))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass00 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass00","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass00"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("TextMat").setDiffuseColor(1.0,1.0,1.0)))
              .setGeometry(new Text().setString(new String[] {"Glass00"})
                .setFontStyle(new FontStyle("Style").setFamily(new String[] {"SANS"}).setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.3).setCssStyle("BOLD")))))))
      .addChild(new Viewpoint("View01").setDescription("Glass01").setPosition(-2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Glass01 view").setUrl(new String[] {"#View01"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass01").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass01 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass01","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass01"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass01"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View02").setDescription("Glass02").setPosition(-0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Glass02 view").setUrl(new String[] {"#View02"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass02").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass02 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass02","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass02"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass02"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View03").setDescription("Glass03").setPosition(0.75,3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Glass03 view").setUrl(new String[] {"#View03"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass03").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass03 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass03","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass03"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass03"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View04").setDescription("Glass04").setPosition(2.25,3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,3.75,0.0)
        .addChild(new Anchor().setDescription("Glass04 view").setUrl(new String[] {"#View04"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass04").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass04 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass4","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass04"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass04"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View05").setDescription("Glass05").setPosition(3.75,3.75,3.0))
      .addChild(new Transform().setTranslation(3.75,3.75,0.0)
        .addChild(new Anchor().setDescription("Glass05 view").setUrl(new String[] {"#View05"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass05").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass05 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass5","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass05"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass05"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View06").setDescription("Glass06").setPosition(-3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Glass06 view").setUrl(new String[] {"#View06"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass06").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass06 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass06","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass06"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass06"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View07").setDescription("Glass07").setPosition(-2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Glass07 view").setUrl(new String[] {"#View07"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass07").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass07 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass7","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass07"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass07"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View08").setDescription("Glass08").setPosition(-0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Glass08 view").setUrl(new String[] {"#View08"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass08").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass08 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass08","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass08"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass08"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View09").setDescription("Glass09").setPosition(0.75,2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Glass09 view").setUrl(new String[] {"#View09"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass09").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass09 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass09","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass09"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass09"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View10").setDescription("Glass10").setPosition(2.25,2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,2.25,0.0)
        .addChild(new Anchor().setDescription("Glass10 view").setUrl(new String[] {"#View10"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass10").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass10 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass10","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass10"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass10"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View11").setDescription("Glass11").setPosition(3.75,2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,2.25,0.0)
        .addChild(new Anchor().setDescription("Glass11 view").setUrl(new String[] {"#View11"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass11").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass11 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass11","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass11"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass11"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View12").setDescription("Glass12").setPosition(-3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Glass12 view").setUrl(new String[] {"#View12"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass12").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass12 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass12","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass12"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass12"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View13").setDescription("Glass13").setPosition(-2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Glass13 view").setUrl(new String[] {"#View13"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass13").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass13 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass13","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass13"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass13"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View14").setDescription("Glass14").setPosition(-0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Glass14 view").setUrl(new String[] {"#View14"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass14").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass14 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass14","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass14"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass14"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View15").setDescription("Glass15").setPosition(0.75,0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Glass15 view").setUrl(new String[] {"#View15"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass15").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass15 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass5","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass15"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass15"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View16").setDescription("Glass16").setPosition(2.25,0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,0.75,0.0)
        .addChild(new Anchor().setDescription("Glass16 view").setUrl(new String[] {"#View16"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass16").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass16 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass16","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass16"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass16"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View17").setDescription("Glass17").setPosition(3.75,0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,0.75,0.0)
        .addChild(new Anchor().setDescription("Glass17 view").setUrl(new String[] {"#View17"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass17").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass17 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass17","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass17"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass17"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View18").setDescription("Glass18").setPosition(-3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Glass18 view").setUrl(new String[] {"#View18"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass18").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass18 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass18","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass18"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass18"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View19").setDescription("Glass19").setPosition(-2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Glass19 view").setUrl(new String[] {"#View19"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass19").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass19 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass19","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass19"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass19"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View20").setDescription("Glass20").setPosition(-0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Glass20 view").setUrl(new String[] {"#View20"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass20").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass20 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass20","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass20"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass20"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View21").setDescription("Glass21").setPosition(0.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Glass21 view").setUrl(new String[] {"#View21"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass21").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass21 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass21","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass21"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass21"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View22").setDescription("Glass22").setPosition(2.25,-0.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-0.75,0.0)
        .addChild(new Anchor().setDescription("Glass22 view").setUrl(new String[] {"#View22"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass22").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass22 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass2","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass22"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass22"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View23").setDescription("Glass23").setPosition(3.75,-0.75,3.0))
      .addChild(new Transform().setTranslation(3.75,-0.75,0.0)
        .addChild(new Anchor().setDescription("Glass23 view").setUrl(new String[] {"#View23"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass23").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass23 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass23","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass23"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass23"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View24").setDescription("Glass24").setPosition(-3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Glass24 view").setUrl(new String[] {"#View24"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass24").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass24 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass4","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass24"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass24"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View25").setDescription("Glass25").setPosition(-2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(-2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Glass25 view").setUrl(new String[] {"#View25"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass25").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass25 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass5","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass25"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass25"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View26").setDescription("Glass26").setPosition(-0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(-0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Glass26 view").setUrl(new String[] {"#View26"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass26").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass26 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass6","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass26"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass26"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View27").setDescription("Glass27").setPosition(0.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(0.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Glass27 view").setUrl(new String[] {"#View27"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass27").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass27 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass7","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass27"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass27"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View28").setDescription("Glass28").setPosition(2.25,-2.25,3.0))
      .addChild(new Transform().setTranslation(2.25,-2.25,0.0)
        .addChild(new Anchor().setDescription("Glass28 view").setUrl(new String[] {"#View28"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass28").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass28 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass28","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass28"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass28"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View29").setDescription("Glass29").setPosition(3.75,-2.25,3.0))
      .addChild(new Transform().setTranslation(3.75,-2.25,0.0)
        .addChild(new Anchor().setDescription("Glass29 view").setUrl(new String[] {"#View29"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass29").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass29 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass9","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass29"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass29"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View30").setDescription("Glass30").setPosition(-3.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-3.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Glass30 view").setUrl(new String[] {"#View30"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass30").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass30 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass30","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass30"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass30"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View31").setDescription("Glass31").setPosition(-2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(-2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Glass31 view").setUrl(new String[] {"#View31"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass31").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass31 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass31","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass31"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass31"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View32").setDescription("Glass32").setPosition(-0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(-0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Glass32 view").setUrl(new String[] {"#View32"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass32").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass32 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass32","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass32"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass32"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View33").setDescription("Glass33").setPosition(0.75,-3.75,3.0))
      .addChild(new Transform().setTranslation(0.75,-3.75,0.0)
        .addChild(new Anchor().setDescription("Glass33 view").setUrl(new String[] {"#View33"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass33").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass33 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass33","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass33"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass33"})
                .setFontStyle(new FontStyle().setUSE("Style")))))))
      .addChild(new Viewpoint("View34").setDescription("Glass34").setPosition(2.25,-3.75,3.0))
      .addChild(new Transform().setTranslation(2.25,-3.75,0.0)
        .addChild(new Anchor().setDescription("Glass34 view").setUrl(new String[] {"#View34"})
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new ProtoInstance("Glass34").setContainerField("material")))
            .setGeometry(new Sphere().setUSE("Ball"))))
        .addChild(new Transform().setTranslation(0.0,0.3,0.5)
          .addChild(new Anchor().setDescription("Glass34 view source documentation").setParameter(new String[] {"target=_source"}).setUrl(new String[] {"GlassPrototypes.html#ProtoDeclare_Glass34","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/GlassPrototypes.html#ProtoDeclare_Glass34"})
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setUSE("TextMat")))
              .setGeometry(new Text().setString(new String[] {"Glass34"})
                .setFontStyle(new FontStyle().setUSE("Style"))))))))
    .addChild(new ROUTE().setFromNode("Close_Time").setFromField("fraction_changed").setToNode("Close_Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Close_Mover").setFromField("value_changed").setToNode("Close_travel").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return GlassExamples model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new GlassExamples().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.UniversalMediaMaterials.GlassExamples\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.UniversalMediaMaterials.GlassExamples self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // UniversalMediaMaterials/GlassExamples_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "UniversalMediaMaterials/GlassExamples_JavaExport.x3d"; 
                String filenameX3DV = "UniversalMediaMaterials/GlassExamples_JavaExport.x3dv"; 
                String filenameJSON = "UniversalMediaMaterials/GlassExamples_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
