/**
 *<p>
 *	Unit statements can redefine the base units of length/angle/force/mass values
 *      in an X3D scene from meters/radians/newtons/kilograms to other units of interest.
 *</p>
 *<p>
 *	These examples
 *	demonstrate use of the
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/concepts.html" target="_blank">X3D Units</a>
 *	statements proposed for X3D version 3.3.
 *	Unit statements define conversion factors from default units in order to simplify the creation of content using minimal data translation.
 *	The
 *	<a href="https://www.web3d.org/membership/login/memberwiki/index.php/X3D_Physical_Units_Proposal" target="_blank">original proposal</a>
 *	provides further detail.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Units" target="_blank">X3D Basic: Units</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Units;

