package Basic.Units;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Units component example for planet Saturn. </p>
 <p> Related links: Catalog page <a href="../../../Units/UnitSaturnIndex.html" target="_blank">UnitSaturn</a>,  source <a href="../../../Units/UnitSaturn.java">UnitSaturn.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Units/UnitSaturn.x3d">UnitSaturn.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Units component example for planet Saturn </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Myeong Won Lee </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 August 2009 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Units/UnitExamples.pdf">UnitExamples.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd" target="_blank">http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D UNIT statement </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Units/UnitSaturn.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Units/UnitSaturn.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Units/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Myeong Won Lee
 */

public class UnitSaturn
{
	/** Default constructor to create this object. */
	public UnitSaturn ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addUnit(new unit().setName("kilo").setCategory("length").setConversionFactor(1000.0))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("UnitSaturn.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Units component example for planet Saturn"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Myeong Won Lee"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 August 2009"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("UnitExamples.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D UNIT statement"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Units/UnitSaturn.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("UnitSaturn.x3d"))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setScale(1.174,1.174,1.174).setTranslation(-150.493,0.0,-1.939)
      .addChild(new Viewpoint().setDescription("Planet Saturn").setOrientation(0.0,1.0,0.0,-0.3491).setPosition(0.0,0.0,1.0))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.6157,0.3412,0.2353)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_20_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_20_point())))))
    .addChild(new Transform().setScale(0.8447,0.04225,0.8447).setTranslation(-150.493,0.0,-1.939)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.6196,0.2059,0.1294)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_26_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_26_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_20_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,2,3,-1,0,3,4,-1,0,4,5,-1,0,5,6,-1,0,6,7,-1,0,7,8,-1,0,8,9,-1,0,9,10,-1,0,10,11,-1,0,11,12,-1,0,12,13,-1,0,13,14,-1,0,14,15,-1,0,15,16,-1,0,16,17,-1,0,17,18,-1,0,18,19,-1,0,19,20,-1,0,20,21,-1,0,21,22,-1,0,22,23,-1,0,23,24,-1,0,24,1,-1,1,25,26,-1,1,26,2,-1,2,26,27,-1,2,27,3,-1,3,27,28,-1,3,28,4,-1,4,28,29,-1,4,29,5,-1,5,29,30,-1,5,30,6,-1,6,30,31,-1,6,31,7,-1,7,31,32,-1,7,32,8,-1,8,32,33,-1,8,33,9,-1,9,33,34,-1,9,34,10,-1,10,34,35,-1,10,35,11,-1,11,35,36,-1,11,36,12,-1,12,36,37,-1,12,37,13,-1,13,37,38,-1,13,38,14,-1,14,38,39,-1,14,39,15,-1,15,39,40,-1,15,40,16,-1,16,40,41,-1,16,41,17,-1,17,41,42,-1,17,42,18,-1,18,42,43,-1,18,43,19,-1,19,43,44,-1,19,44,20,-1,20,44,45,-1,20,45,21,-1,21,45,46,-1,21,46,22,-1,22,46,47,-1,22,47,23,-1,23,47,48,-1,23,48,24,-1,24,48,25,-1,24,25,1,-1,25,49,50,-1,25,50,26,-1,26,50,51,-1,26,51,27,-1,27,51,52,-1,27,52,28,-1,28,52,53,-1,28,53,29,-1,29,53,54,-1,29,54,30,-1,30,54,55,-1,30,55,31,-1,31,55,56,-1,31,56,32,-1,32,56,57,-1,32,57,33,-1,33,57,58,-1,33,58,34,-1,34,58,59,-1,34,59,35,-1,35,59,60,-1,35,60,36,-1,36,60,61,-1,36,61,37,-1,37,61,62,-1,37,62,38,-1,38,62,63,-1,38,63,39,-1,39,63,64,-1,39,64,40,-1,40,64,65,-1,40,65,41,-1,41,65,66,-1,41,66,42,-1,42,66,67,-1,42,67,43,-1,43,67,68,-1,43,68,44,-1,44,68,69,-1,44,69,45,-1,45,69,70,-1,45,70,46,-1,46,70,71,-1,46,71,47,-1,47,71,72,-1,47,72,48,-1,48,72,49,-1,48,49,25,-1,49,73,74,-1,49,74,50,-1,50,74,75,-1,50,75,51,-1,51,75,76,-1,51,76,52,-1,52,76,77,-1,52,77,53,-1,53,77,78,-1,53,78,54,-1,54,78,79,-1,54,79,55,-1,55,79,80,-1,55,80,56,-1,56,80,81,-1,56,81,57,-1,57,81,82,-1,57,82,58,-1,58,82,83,-1,58,83,59,-1,59,83,84,-1,59,84,60,-1,60,84,85,-1,60,85,61,-1,61,85,86,-1,61,86,62,-1,62,86,87,-1,62,87,63,-1,63,87,88,-1,63,88,64,-1,64,88,89,-1,64,89,65,-1,65,89,90,-1,65,90,66,-1,66,90,91,-1,66,91,67,-1,67,91,92,-1,67,92,68,-1,68,92,93,-1,68,93,69,-1,69,93,94,-1,69,94,70,-1,70,94,95,-1,70,95,71,-1,71,95,96,-1,71,96,72,-1,72,96,73,-1,72,73,49,-1,73,97,98,-1,73,98,74,-1,74,98,99,-1,74,99,75,-1,75,99,100,-1,75,100,76,-1,76,100,101,-1,76,101,77,-1,77,101,102,-1,77,102,78,-1,78,102,103,-1,78,103,79,-1,79,103,104,-1,79,104,80,-1,80,104,105,-1,80,105,81,-1,81,105,106,-1,81,106,82,-1,82,106,107,-1,82,107,83,-1,83,107,108,-1,83,108,84,-1,84,108,109,-1,84,109,85,-1,85,109,110,-1,85,110,86,-1,86,110,111,-1,86,111,87,-1,87,111,112,-1,87,112,88,-1,88,112,113,-1,88,113,89,-1,89,113,114,-1,89,114,90,-1,90,114,115,-1,90,115,91,-1,91,115,116,-1,91,116,92,-1,92,116,117,-1,92,117,93,-1,93,117,118,-1,93,118,94,-1,94,118,119,-1,94,119,95,-1,95,119,120,-1,95,120,96,-1,96,120,97,-1,96,97,73,-1,97,121,122,-1,97,122,98,-1,98,122,123,-1,98,123,99,-1,99,123,124,-1,99,124,100,-1,100,124,125,-1,100,125,101,-1,101,125,126,-1,101,126,102,-1,102,126,127,-1,102,127,103,-1,103,127,128,-1,103,128,104,-1,104,128,129,-1,104,129,105,-1,105,129,130,-1,105,130,106,-1,106,130,131,-1,106,131,107,-1,107,131,132,-1,107,132,108,-1,108,132,133,-1,108,133,109,-1,109,133,134,-1,109,134,110,-1,110,134,135,-1,110,135,111,-1,111,135,136,-1,111,136,112,-1,112,136,137,-1,112,137,113,-1,113,137,138,-1,113,138,114,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_2()
		{
			int[] value = {114,138,139,-1,114,139,115,-1,115,139,140,-1,115,140,116,-1,116,140,141,-1,116,141,117,-1,117,141,142,-1,117,142,118,-1,118,142,143,-1,118,143,119,-1,119,143,144,-1,119,144,120,-1,120,144,121,-1,120,121,97,-1,121,145,146,-1,121,146,122,-1,122,146,147,-1,122,147,123,-1,123,147,148,-1,123,148,124,-1,124,148,149,-1,124,149,125,-1,125,149,150,-1,125,150,126,-1,126,150,151,-1,126,151,127,-1,127,151,152,-1,127,152,128,-1,128,152,153,-1,128,153,129,-1,129,153,154,-1,129,154,130,-1,130,154,155,-1,130,155,131,-1,131,155,156,-1,131,156,132,-1,132,156,157,-1,132,157,133,-1,133,157,158,-1,133,158,134,-1,134,158,159,-1,134,159,135,-1,135,159,160,-1,135,160,136,-1,136,160,161,-1,136,161,137,-1,137,161,162,-1,137,162,138,-1,138,162,163,-1,138,163,139,-1,139,163,164,-1,139,164,140,-1,140,164,165,-1,140,165,141,-1,141,165,166,-1,141,166,142,-1,142,166,167,-1,142,167,143,-1,143,167,168,-1,143,168,144,-1,144,168,145,-1,144,145,121,-1,145,169,170,-1,145,170,146,-1,146,170,171,-1,146,171,147,-1,147,171,172,-1,147,172,148,-1,148,172,173,-1,148,173,149,-1,149,173,174,-1,149,174,150,-1,150,174,175,-1,150,175,151,-1,151,175,176,-1,151,176,152,-1,152,176,177,-1,152,177,153,-1,153,177,178,-1,153,178,154,-1,154,178,179,-1,154,179,155,-1,155,179,180,-1,155,180,156,-1,156,180,181,-1,156,181,157,-1,157,181,182,-1,157,182,158,-1,158,182,183,-1,158,183,159,-1,159,183,184,-1,159,184,160,-1,160,184,185,-1,160,185,161,-1,161,185,186,-1,161,186,162,-1,162,186,187,-1,162,187,163,-1,163,187,188,-1,163,188,164,-1,164,188,189,-1,164,189,165,-1,165,189,190,-1,165,190,166,-1,166,190,191,-1,166,191,167,-1,167,191,192,-1,167,192,168,-1,168,192,169,-1,168,169,145,-1,169,193,194,-1,169,194,170,-1,170,194,195,-1,170,195,171,-1,171,195,196,-1,171,196,172,-1,172,196,197,-1,172,197,173,-1,173,197,198,-1,173,198,174,-1,174,198,199,-1,174,199,175,-1,175,199,200,-1,175,200,176,-1,176,200,201,-1,176,201,177,-1,177,201,202,-1,177,202,178,-1,178,202,203,-1,178,203,179,-1,179,203,204,-1,179,204,180,-1,180,204,205,-1,180,205,181,-1,181,205,206,-1,181,206,182,-1,182,206,207,-1,182,207,183,-1,183,207,208,-1,183,208,184,-1,184,208,209,-1,184,209,185,-1,185,209,210,-1,185,210,186,-1,186,210,211,-1,186,211,187,-1,187,211,212,-1,187,212,188,-1,188,212,213,-1,188,213,189,-1,189,213,214,-1,189,214,190,-1,190,214,215,-1,190,215,191,-1,191,215,216,-1,191,216,192,-1,192,216,193,-1,192,193,169,-1,193,217,218,-1,193,218,194,-1,194,218,219,-1,194,219,195,-1,195,219,220,-1,195,220,196,-1,196,220,221,-1,196,221,197,-1,197,221,222,-1,197,222,198,-1,198,222,223,-1,198,223,199,-1,199,223,224,-1,199,224,200,-1,200,224,225,-1,200,225,201,-1,201,225,226,-1,201,226,202,-1,202,226,227,-1,202,227,203,-1,203,227,228,-1,203,228,204,-1,204,228,229,-1,204,229,205,-1,205,229,230,-1,205,230,206,-1,206,230,231,-1,206,231,207,-1,207,231,232,-1,207,232,208,-1,208,232,233,-1,208,233,209,-1,209,233,234,-1,209,234,210,-1,210,234,235,-1,210,235,211,-1,211,235,236,-1,211,236,212,-1,212,236,237,-1,212,237,213,-1,213,237,238,-1,213,238,214,-1,214,238,239,-1,214,239,215,-1,215,239,240,-1,215,240,216,-1,216,240,217,-1,216,217,193,-1,217,241,242,-1,217,242,218,-1,218,242,243,-1,218,243,219,-1,219,243,244,-1,219,244,220,-1,220,244,245,-1,220,245,221,-1,221,245,246,-1,221,246,222,-1,222,246,247,-1,222,247,223,-1,223,247,248,-1,223,248,224,-1,224,248,249,-1,224,249,225,-1,225,249,250,-1,225,250,226,-1,226,250,251,-1,226,251,227,-1,227,251,252,-1,227,252,228,-1,228,252,253,-1,228,253,229,-1,229,253,254,-1,229,254,230,-1,230,254,255,-1,230,255,231,-1,231,255,256,-1,231,256,232,-1,232,256,257,-1,232,257,233,-1,233,257,258,-1,233,258,234,-1,234,258,259,-1,234,259,235,-1,235,259,260,-1,235,260,236,-1,236,260,261,-1,236,261,237,-1,237,261,262,-1,237,262,238,-1,238,262,263,-1,238,263,239,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_3()
		{
			int[] value = {239,263,264,-1,239,264,240,-1,240,264,241,-1,240,241,217,-1,265,242,241,-1,265,243,242,-1,265,244,243,-1,265,245,244,-1,265,246,245,-1,265,247,246,-1,265,248,247,-1,265,249,248,-1,265,250,249,-1,265,251,250,-1,265,252,251,-1,265,253,252,-1,265,254,253,-1,265,255,254,-1,265,256,255,-1,265,257,256,-1,265,258,257,-1,265,259,258,-1,265,260,259,-1,265,261,260,-1,265,262,261,-1,265,263,262,-1,265,264,263,-1,265,241,264,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_20_point_1()
		{
			double[] value = {0.0,45.34,0.0,0.0,43.8,-11.74,-3.037,43.8,-11.34,-5.868,43.8,-10.16,-8.298,43.8,-8.298,-10.16,43.8,-5.868,-11.34,43.8,-3.037,-11.74,43.8,0.0,-11.34,43.8,3.037,-10.16,43.8,5.868,-8.298,43.8,8.298,-5.868,43.8,10.16,-3.037,43.8,11.34,0.0,43.8,11.74,3.037,43.8,11.34,5.868,43.8,10.16,8.298,43.8,8.298,10.16,43.8,5.868,11.34,43.8,3.037,11.74,43.8,0.0,11.34,43.8,-3.037,10.16,43.8,-5.868,8.298,43.8,-8.298,5.868,43.8,-10.16,3.037,43.8,-11.34,0.0,39.27,-22.67,-5.868,39.27,-21.9,-11.34,39.27,-19.63,-16.03,39.27,-16.03,-19.63,39.27,-11.34,-21.9,39.27,-5.868,-22.67,39.27,0.0,-21.9,39.27,5.868,-19.63,39.27,11.34,-16.03,39.27,16.03,-11.34,39.27,19.63,-5.868,39.27,21.9,0.0,39.27,22.67,5.868,39.27,21.9,11.34,39.27,19.63,16.03,39.27,16.03,19.63,39.27,11.34,21.9,39.27,5.868,22.67,39.27,0.0,21.9,39.27,-5.868,19.63,39.27,-11.34,16.03,39.27,-16.03,11.34,39.27,-19.63,5.868,39.27,-21.9,0.0,32.06,-32.06,-8.298,32.06,-30.97,-16.03,32.06,-27.77,-22.67,32.06,-22.67,-27.77,32.06,-16.03,-30.97,32.06,-8.298,-32.06,32.06,0.0,-30.97,32.06,8.298,-27.77,32.06,16.03,-22.67,32.06,22.67,-16.03,32.06,27.77,-8.298,32.06,30.97,0.0,32.06,32.06,8.298,32.06,30.97,16.03,32.06,27.77,22.67,32.06,22.67,27.77,32.06,16.03,30.97,32.06,8.298,32.06,32.06,0.0,30.97,32.06,-8.298,27.77,32.06,-16.03,22.67,32.06,-22.67,16.03,32.06,-27.77,8.298,32.06,-30.97,0.0,22.67,-39.27,-10.16,22.67,-37.93,-19.63,22.67,-34.01,-27.77,22.67,-27.77,-34.01,22.67,-19.63,-37.93,22.67,-10.16,-39.27,22.67,0.0,-37.93,22.67,10.16,-34.01,22.67,19.63,-27.77,22.67,27.77,-19.63,22.67,34.01,-10.16,22.67,37.93,0.0,22.67,39.27,10.16,22.67,37.93,19.63,22.67,34.01,27.77,22.67,27.77,34.01,22.67,19.63,37.93,22.67,10.16,39.27,22.67,0.0,37.93,22.67,-10.16,34.01,22.67,-19.63,27.77,22.67,-27.77,19.63,22.67,-34.01,10.16,22.67,-37.93,0.0,11.74,-43.8,-11.34,11.74,-42.3,-21.9,11.74,-37.93};
			return value;
		}
		private double[] getCoordinate_6_20_point_2()
		{
			double[] value = {-30.97,11.74,-30.97,-37.93,11.74,-21.9,-42.3,11.74,-11.34,-43.8,11.74,0.0,-42.3,11.74,11.34,-37.93,11.74,21.9,-30.97,11.74,30.97,-21.9,11.74,37.93,-11.34,11.74,42.3,0.0,11.74,43.8,11.34,11.74,42.3,21.9,11.74,37.93,30.97,11.74,30.97,37.93,11.74,21.9,42.3,11.74,11.34,43.8,11.74,0.0,42.3,11.74,-11.34,37.93,11.74,-21.9,30.97,11.74,-30.97,21.9,11.74,-37.93,11.34,11.74,-42.3,0.0,0.0,-45.34,-11.74,0.0,-43.8,-22.67,0.0,-39.27,-32.06,0.0,-32.06,-39.27,0.0,-22.67,-43.8,0.0,-11.74,-45.34,0.0,0.0,-43.8,0.0,11.74,-39.27,0.0,22.67,-32.06,0.0,32.06,-22.67,0.0,39.27,-11.74,0.0,43.8,0.0,0.0,45.34,11.74,0.0,43.8,22.67,0.0,39.27,32.06,0.0,32.06,39.27,0.0,22.67,43.8,0.0,11.74,45.34,0.0,0.0,43.8,0.0,-11.74,39.27,0.0,-22.67,32.06,0.0,-32.06,22.67,0.0,-39.27,11.74,0.0,-43.8,0.0,-11.74,-43.8,-11.34,-11.74,-42.3,-21.9,-11.74,-37.93,-30.97,-11.74,-30.97,-37.93,-11.74,-21.9,-42.3,-11.74,-11.34,-43.8,-11.74,0.0,-42.3,-11.74,11.34,-37.93,-11.74,21.9,-30.97,-11.74,30.97,-21.9,-11.74,37.93,-11.34,-11.74,42.3,0.0,-11.74,43.8,11.34,-11.74,42.3,21.9,-11.74,37.93,30.97,-11.74,30.97,37.93,-11.74,21.9,42.3,-11.74,11.34,43.8,-11.74,0.0,42.3,-11.74,-11.34,37.93,-11.74,-21.9,30.97,-11.74,-30.97,21.9,-11.74,-37.93,11.34,-11.74,-42.3,0.0,-22.67,-39.27,-10.16,-22.67,-37.93,-19.63,-22.67,-34.01,-27.77,-22.67,-27.77,-34.01,-22.67,-19.63,-37.93,-22.67,-10.16,-39.27,-22.67,0.0,-37.93,-22.67,10.16,-34.01,-22.67,19.63,-27.77,-22.67,27.77,-19.63,-22.67,34.01,-10.16,-22.67,37.93,0.0,-22.67,39.27,10.16,-22.67,37.93,19.63,-22.67,34.01,27.77,-22.67,27.77,34.01,-22.67,19.63,37.93,-22.67,10.16,39.27,-22.67,0.0,37.93,-22.67,-10.16,34.01,-22.67,-19.63,27.77,-22.67,-27.77,19.63,-22.67,-34.01,10.16,-22.67,-37.93,0.0,-32.06,-32.06,-8.298,-32.06,-30.97,-16.03,-32.06,-27.77,-22.67,-32.06,-22.67,-27.77,-32.06,-16.03,-30.97,-32.06,-8.298,-32.06,-32.06,0.0};
			return value;
		}
		private double[] getCoordinate_6_20_point_3()
		{
			double[] value = {-30.97,-32.06,8.298,-27.77,-32.06,16.03,-22.67,-32.06,22.67,-16.03,-32.06,27.77,-8.298,-32.06,30.97,0.0,-32.06,32.06,8.298,-32.06,30.97,16.03,-32.06,27.77,22.67,-32.06,22.67,27.77,-32.06,16.03,30.97,-32.06,8.298,32.06,-32.06,0.0,30.97,-32.06,-8.298,27.77,-32.06,-16.03,22.67,-32.06,-22.67,16.03,-32.06,-27.77,8.298,-32.06,-30.97,0.0,-39.27,-22.67,-5.868,-39.27,-21.9,-11.34,-39.27,-19.63,-16.03,-39.27,-16.03,-19.63,-39.27,-11.34,-21.9,-39.27,-5.868,-22.67,-39.27,0.0,-21.9,-39.27,5.868,-19.63,-39.27,11.34,-16.03,-39.27,16.03,-11.34,-39.27,19.63,-5.868,-39.27,21.9,0.0,-39.27,22.67,5.868,-39.27,21.9,11.34,-39.27,19.63,16.03,-39.27,16.03,19.63,-39.27,11.34,21.9,-39.27,5.868,22.67,-39.27,0.0,21.9,-39.27,-5.868,19.63,-39.27,-11.34,16.03,-39.27,-16.03,11.34,-39.27,-19.63,5.868,-39.27,-21.9,0.0,-43.8,-11.74,-3.037,-43.8,-11.34,-5.868,-43.8,-10.16,-8.298,-43.8,-8.298,-10.16,-43.8,-5.868,-11.34,-43.8,-3.037,-11.74,-43.8,0.0,-11.34,-43.8,3.037,-10.16,-43.8,5.868,-8.298,-43.8,8.298,-5.868,-43.8,10.16,-3.037,-43.8,11.34,0.0,-43.8,11.74,3.037,-43.8,11.34,5.868,-43.8,10.16,8.298,-43.8,8.298,10.16,-43.8,5.868,11.34,-43.8,3.037,11.74,-43.8,0.0,11.34,-43.8,-3.037,10.16,-43.8,-5.868,8.298,-43.8,-8.298,5.868,-43.8,-10.16,3.037,-43.8,-11.34,0.0,-45.34,0.0};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_26_coordIndex_1()
		{
			int[] value = {0,514,256,-1,256,513,0,-1,1,515,256,-1,256,514,1,-1,9,512,256,-1,256,515,9,-1,8,513,256,-1,256,512,8,-1,1,517,257,-1,257,515,1,-1,2,518,257,-1,257,517,2,-1,10,516,257,-1,257,518,10,-1,9,515,257,-1,257,516,9,-1,2,520,258,-1,258,518,2,-1,3,521,258,-1,258,520,3,-1,11,519,258,-1,258,521,11,-1,10,518,258,-1,258,519,10,-1,3,523,259,-1,259,521,3,-1,4,524,259,-1,259,523,4,-1,12,522,259,-1,259,524,12,-1,11,521,259,-1,259,522,11,-1,4,526,260,-1,260,524,4,-1,5,527,260,-1,260,526,5,-1,13,525,260,-1,260,527,13,-1,12,524,260,-1,260,525,12,-1,5,529,261,-1,261,527,5,-1,6,530,261,-1,261,529,6,-1,14,528,261,-1,261,530,14,-1,13,527,261,-1,261,528,13,-1,6,532,262,-1,262,530,6,-1,7,533,262,-1,262,532,7,-1,15,531,262,-1,262,533,15,-1,14,530,262,-1,262,531,14,-1,7,535,263,-1,263,533,7,-1,0,513,263,-1,263,535,0,-1,8,534,263,-1,263,513,8,-1,15,533,263,-1,263,534,15,-1,8,512,264,-1,264,537,8,-1,9,538,264,-1,264,512,9,-1,17,536,264,-1,264,538,17,-1,16,537,264,-1,264,536,16,-1,9,516,265,-1,265,538,9,-1,10,540,265,-1,265,516,10,-1,18,539,265,-1,265,540,18,-1,17,538,265,-1,265,539,17,-1,10,519,266,-1,266,540,10,-1,11,542,266,-1,266,519,11,-1,19,541,266,-1,266,542,19,-1,18,540,266,-1,266,541,18,-1,11,522,267,-1,267,542,11,-1,12,544,267,-1,267,522,12,-1,20,543,267,-1,267,544,20,-1,19,542,267,-1,267,543,19,-1,12,525,268,-1,268,544,12,-1,13,546,268,-1,268,525,13,-1,21,545,268,-1,268,546,21,-1,20,544,268,-1,268,545,20,-1,13,528,269,-1,269,546,13,-1,14,548,269,-1,269,528,14,-1,22,547,269,-1,269,548,22,-1,21,546,269,-1,269,547,21,-1,14,531,270,-1,270,548,14,-1,15,550,270,-1,270,531,15,-1,23,549,270,-1,270,550,23,-1,22,548,270,-1,270,549,22,-1,15,534,271,-1,271,550,15,-1,8,537,271,-1,271,534,8,-1,16,551,271,-1,271,537,16,-1,23,550,271,-1,271,551,23,-1,16,536,272,-1,272,553,16,-1,17,554,272,-1,272,536,17,-1,25,552,272,-1,272,554,25,-1,24,553,272,-1,272,552,24,-1,17,539,273,-1,273,554,17,-1,18,556,273,-1,273,539,18,-1,26,555,273,-1,273,556,26,-1,25,554,273,-1,273,555,25,-1,18,541,274,-1,274,556,18,-1,19,558,274,-1,274,541,19,-1,27,557,274,-1,274,558,27,-1,26,556,274,-1,274,557,26,-1,19,543,275,-1,275,558,19,-1,20,560,275,-1,275,543,20,-1,28,559,275,-1,275,560,28,-1,27,558,275,-1,275,559,27,-1,20,545,276,-1,276,560,20,-1,21,562,276,-1,276,545,21,-1,29,561,276,-1,276,562,29,-1,28,560,276,-1,276,561,28,-1,21,547,277,-1,277,562,21,-1,22,564,277,-1,277,547,22,-1,30,563,277,-1,277,564,30,-1,29,562,277,-1,277,563,29,-1,22,549,278,-1,278,564,22,-1,23,566,278,-1,278,549,23,-1,31,565,278,-1,278,566,31,-1,30,564,278,-1,278,565,30,-1,23,551,279,-1,279,566,23,-1,16,553,279,-1,279,551,16,-1,24,567,279,-1,279,553,24,-1,31,566,279,-1,279,567,31,-1,24,552,280,-1,280,569,24,-1,25,570,280,-1,280,552,25,-1,33,568,280,-1,280,570,33,-1,32,569,280,-1,280,568,32,-1,25,555,281,-1,281,570,25,-1,26,572,281,-1,281,555,26,-1,34,571,281,-1,281,572,34,-1,33,570,281,-1,281,571,33,-1,26,557,282,-1,282,572,26,-1,27,574,282,-1,282,557,27,-1,35,573,282,-1,282,574,35,-1,34,572,282,-1,282,573,34,-1,27,559,283,-1,283,574,27,-1,28,576,283,-1,283,559,28,-1,36,575,283,-1,283,576,36,-1,35,574,283,-1,283,575,35,-1,28,561,284,-1,284,576,28,-1,29,578,284,-1,284,561,29,-1,37,577,284,-1,284,578,37,-1,36,576,284,-1,284,577,36,-1,29,563,285,-1,285,578,29,-1,30,580,285,-1,285,563,30,-1,38,579,285,-1,285,580,38,-1,37,578,285,-1,285,579,37,-1,30,565,286,-1,286,580,30,-1,31,582,286,-1,286,565,31,-1,39,581,286,-1,286,582,39,-1,38,580,286,-1,286,581,38,-1,31,567,287,-1,287,582,31,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_2()
		{
			int[] value = {24,569,287,-1,287,567,24,-1,32,583,287,-1,287,569,32,-1,39,582,287,-1,287,583,39,-1,32,568,288,-1,288,585,32,-1,33,586,288,-1,288,568,33,-1,41,584,288,-1,288,586,41,-1,40,585,288,-1,288,584,40,-1,33,571,289,-1,289,586,33,-1,34,588,289,-1,289,571,34,-1,42,587,289,-1,289,588,42,-1,41,586,289,-1,289,587,41,-1,34,573,290,-1,290,588,34,-1,35,590,290,-1,290,573,35,-1,43,589,290,-1,290,590,43,-1,42,588,290,-1,290,589,42,-1,35,575,291,-1,291,590,35,-1,36,592,291,-1,291,575,36,-1,44,591,291,-1,291,592,44,-1,43,590,291,-1,291,591,43,-1,36,577,292,-1,292,592,36,-1,37,594,292,-1,292,577,37,-1,45,593,292,-1,292,594,45,-1,44,592,292,-1,292,593,44,-1,37,579,293,-1,293,594,37,-1,38,596,293,-1,293,579,38,-1,46,595,293,-1,293,596,46,-1,45,594,293,-1,293,595,45,-1,38,581,294,-1,294,596,38,-1,39,598,294,-1,294,581,39,-1,47,597,294,-1,294,598,47,-1,46,596,294,-1,294,597,46,-1,39,583,295,-1,295,598,39,-1,32,585,295,-1,295,583,32,-1,40,599,295,-1,295,585,40,-1,47,598,295,-1,295,599,47,-1,40,584,296,-1,296,601,40,-1,41,602,296,-1,296,584,41,-1,49,600,296,-1,296,602,49,-1,48,601,296,-1,296,600,48,-1,41,587,297,-1,297,602,41,-1,42,604,297,-1,297,587,42,-1,50,603,297,-1,297,604,50,-1,49,602,297,-1,297,603,49,-1,42,589,298,-1,298,604,42,-1,43,606,298,-1,298,589,43,-1,51,605,298,-1,298,606,51,-1,50,604,298,-1,298,605,50,-1,43,591,299,-1,299,606,43,-1,44,608,299,-1,299,591,44,-1,52,607,299,-1,299,608,52,-1,51,606,299,-1,299,607,51,-1,44,593,300,-1,300,608,44,-1,45,610,300,-1,300,593,45,-1,53,609,300,-1,300,610,53,-1,52,608,300,-1,300,609,52,-1,45,595,301,-1,301,610,45,-1,46,612,301,-1,301,595,46,-1,54,611,301,-1,301,612,54,-1,53,610,301,-1,301,611,53,-1,46,597,302,-1,302,612,46,-1,47,614,302,-1,302,597,47,-1,55,613,302,-1,302,614,55,-1,54,612,302,-1,302,613,54,-1,47,599,303,-1,303,614,47,-1,40,601,303,-1,303,599,40,-1,48,615,303,-1,303,601,48,-1,55,614,303,-1,303,615,55,-1,48,600,304,-1,304,617,48,-1,49,618,304,-1,304,600,49,-1,57,616,304,-1,304,618,57,-1,56,617,304,-1,304,616,56,-1,49,603,305,-1,305,618,49,-1,50,620,305,-1,305,603,50,-1,58,619,305,-1,305,620,58,-1,57,618,305,-1,305,619,57,-1,50,605,306,-1,306,620,50,-1,51,622,306,-1,306,605,51,-1,59,621,306,-1,306,622,59,-1,58,620,306,-1,306,621,58,-1,51,607,307,-1,307,622,51,-1,52,624,307,-1,307,607,52,-1,60,623,307,-1,307,624,60,-1,59,622,307,-1,307,623,59,-1,52,609,308,-1,308,624,52,-1,53,626,308,-1,308,609,53,-1,61,625,308,-1,308,626,61,-1,60,624,308,-1,308,625,60,-1,53,611,309,-1,309,626,53,-1,54,628,309,-1,309,611,54,-1,62,627,309,-1,309,628,62,-1,61,626,309,-1,309,627,61,-1,54,613,310,-1,310,628,54,-1,55,630,310,-1,310,613,55,-1,63,629,310,-1,310,630,63,-1,62,628,310,-1,310,629,62,-1,55,615,311,-1,311,630,55,-1,48,617,311,-1,311,615,48,-1,56,631,311,-1,311,617,56,-1,63,630,311,-1,311,631,63,-1,56,616,312,-1,312,633,56,-1,57,634,312,-1,312,616,57,-1,65,632,312,-1,312,634,65,-1,64,633,312,-1,312,632,64,-1,57,619,313,-1,313,634,57,-1,58,636,313,-1,313,619,58,-1,66,635,313,-1,313,636,66,-1,65,634,313,-1,313,635,65,-1,58,621,314,-1,314,636,58,-1,59,638,314,-1,314,621,59,-1,67,637,314,-1,314,638,67,-1,66,636,314,-1,314,637,66,-1,59,623,315,-1,315,638,59,-1,60,640,315,-1,315,623,60,-1,68,639,315,-1,315,640,68,-1,67,638,315,-1,315,639,67,-1,60,625,316,-1,316,640,60,-1,61,642,316,-1,316,625,61,-1,69,641,316,-1,316,642,69,-1,68,640,316,-1,316,641,68,-1,61,627,317,-1,317,642,61,-1,62,644,317,-1,317,627,62,-1,70,643,317,-1,317,644,70,-1,69,642,317,-1,317,643,69,-1,62,629,318,-1,318,644,62,-1,63,646,318,-1,318,629,63,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_3()
		{
			int[] value = {71,645,318,-1,318,646,71,-1,70,644,318,-1,318,645,70,-1,63,631,319,-1,319,646,63,-1,56,633,319,-1,319,631,56,-1,64,647,319,-1,319,633,64,-1,71,646,319,-1,319,647,71,-1,64,632,320,-1,320,649,64,-1,65,650,320,-1,320,632,65,-1,73,648,320,-1,320,650,73,-1,72,649,320,-1,320,648,72,-1,65,635,321,-1,321,650,65,-1,66,652,321,-1,321,635,66,-1,74,651,321,-1,321,652,74,-1,73,650,321,-1,321,651,73,-1,66,637,322,-1,322,652,66,-1,67,654,322,-1,322,637,67,-1,75,653,322,-1,322,654,75,-1,74,652,322,-1,322,653,74,-1,67,639,323,-1,323,654,67,-1,68,656,323,-1,323,639,68,-1,76,655,323,-1,323,656,76,-1,75,654,323,-1,323,655,75,-1,68,641,324,-1,324,656,68,-1,69,658,324,-1,324,641,69,-1,77,657,324,-1,324,658,77,-1,76,656,324,-1,324,657,76,-1,69,643,325,-1,325,658,69,-1,70,660,325,-1,325,643,70,-1,78,659,325,-1,325,660,78,-1,77,658,325,-1,325,659,77,-1,70,645,326,-1,326,660,70,-1,71,662,326,-1,326,645,71,-1,79,661,326,-1,326,662,79,-1,78,660,326,-1,326,661,78,-1,71,647,327,-1,327,662,71,-1,64,649,327,-1,327,647,64,-1,72,663,327,-1,327,649,72,-1,79,662,327,-1,327,663,79,-1,72,648,328,-1,328,665,72,-1,73,666,328,-1,328,648,73,-1,81,664,328,-1,328,666,81,-1,80,665,328,-1,328,664,80,-1,73,651,329,-1,329,666,73,-1,74,668,329,-1,329,651,74,-1,82,667,329,-1,329,668,82,-1,81,666,329,-1,329,667,81,-1,74,653,330,-1,330,668,74,-1,75,670,330,-1,330,653,75,-1,83,669,330,-1,330,670,83,-1,82,668,330,-1,330,669,82,-1,75,655,331,-1,331,670,75,-1,76,672,331,-1,331,655,76,-1,84,671,331,-1,331,672,84,-1,83,670,331,-1,331,671,83,-1,76,657,332,-1,332,672,76,-1,77,674,332,-1,332,657,77,-1,85,673,332,-1,332,674,85,-1,84,672,332,-1,332,673,84,-1,77,659,333,-1,333,674,77,-1,78,676,333,-1,333,659,78,-1,86,675,333,-1,333,676,86,-1,85,674,333,-1,333,675,85,-1,78,661,334,-1,334,676,78,-1,79,678,334,-1,334,661,79,-1,87,677,334,-1,334,678,87,-1,86,676,334,-1,334,677,86,-1,79,663,335,-1,335,678,79,-1,72,665,335,-1,335,663,72,-1,80,679,335,-1,335,665,80,-1,87,678,335,-1,335,679,87,-1,80,664,336,-1,336,681,80,-1,81,682,336,-1,336,664,81,-1,89,680,336,-1,336,682,89,-1,88,681,336,-1,336,680,88,-1,81,667,337,-1,337,682,81,-1,82,684,337,-1,337,667,82,-1,90,683,337,-1,337,684,90,-1,89,682,337,-1,337,683,89,-1,82,669,338,-1,338,684,82,-1,83,686,338,-1,338,669,83,-1,91,685,338,-1,338,686,91,-1,90,684,338,-1,338,685,90,-1,83,671,339,-1,339,686,83,-1,84,688,339,-1,339,671,84,-1,92,687,339,-1,339,688,92,-1,91,686,339,-1,339,687,91,-1,84,673,340,-1,340,688,84,-1,85,690,340,-1,340,673,85,-1,93,689,340,-1,340,690,93,-1,92,688,340,-1,340,689,92,-1,85,675,341,-1,341,690,85,-1,86,692,341,-1,341,675,86,-1,94,691,341,-1,341,692,94,-1,93,690,341,-1,341,691,93,-1,86,677,342,-1,342,692,86,-1,87,694,342,-1,342,677,87,-1,95,693,342,-1,342,694,95,-1,94,692,342,-1,342,693,94,-1,87,679,343,-1,343,694,87,-1,80,681,343,-1,343,679,80,-1,88,695,343,-1,343,681,88,-1,95,694,343,-1,343,695,95,-1,88,680,344,-1,344,697,88,-1,89,698,344,-1,344,680,89,-1,97,696,344,-1,344,698,97,-1,96,697,344,-1,344,696,96,-1,89,683,345,-1,345,698,89,-1,90,700,345,-1,345,683,90,-1,98,699,345,-1,345,700,98,-1,97,698,345,-1,345,699,97,-1,90,685,346,-1,346,700,90,-1,91,702,346,-1,346,685,91,-1,99,701,346,-1,346,702,99,-1,98,700,346,-1,346,701,98,-1,91,687,347,-1,347,702,91,-1,92,704,347,-1,347,687,92,-1,100,703,347,-1,347,704,100,-1,99,702,347,-1,347,703,99,-1,92,689,348,-1,348,704,92,-1,93,706,348,-1,348,689,93,-1,101,705,348,-1,348,706,101,-1,100,704,348,-1,348,705,100,-1,93,691,349,-1,349,706,93,-1,94,708,349,-1,349,691,94,-1,102,707,349,-1,349,708,102,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_4()
		{
			int[] value = {101,706,349,-1,349,707,101,-1,94,693,350,-1,350,708,94,-1,95,710,350,-1,350,693,95,-1,103,709,350,-1,350,710,103,-1,102,708,350,-1,350,709,102,-1,95,695,351,-1,351,710,95,-1,88,697,351,-1,351,695,88,-1,96,711,351,-1,351,697,96,-1,103,710,351,-1,351,711,103,-1,96,696,352,-1,352,713,96,-1,97,714,352,-1,352,696,97,-1,105,712,352,-1,352,714,105,-1,104,713,352,-1,352,712,104,-1,97,699,353,-1,353,714,97,-1,98,716,353,-1,353,699,98,-1,106,715,353,-1,353,716,106,-1,105,714,353,-1,353,715,105,-1,98,701,354,-1,354,716,98,-1,99,718,354,-1,354,701,99,-1,107,717,354,-1,354,718,107,-1,106,716,354,-1,354,717,106,-1,99,703,355,-1,355,718,99,-1,100,720,355,-1,355,703,100,-1,108,719,355,-1,355,720,108,-1,107,718,355,-1,355,719,107,-1,100,705,356,-1,356,720,100,-1,101,722,356,-1,356,705,101,-1,109,721,356,-1,356,722,109,-1,108,720,356,-1,356,721,108,-1,101,707,357,-1,357,722,101,-1,102,724,357,-1,357,707,102,-1,110,723,357,-1,357,724,110,-1,109,722,357,-1,357,723,109,-1,102,709,358,-1,358,724,102,-1,103,726,358,-1,358,709,103,-1,111,725,358,-1,358,726,111,-1,110,724,358,-1,358,725,110,-1,103,711,359,-1,359,726,103,-1,96,713,359,-1,359,711,96,-1,104,727,359,-1,359,713,104,-1,111,726,359,-1,359,727,111,-1,104,712,360,-1,360,729,104,-1,105,730,360,-1,360,712,105,-1,113,728,360,-1,360,730,113,-1,112,729,360,-1,360,728,112,-1,105,715,361,-1,361,730,105,-1,106,732,361,-1,361,715,106,-1,114,731,361,-1,361,732,114,-1,113,730,361,-1,361,731,113,-1,106,717,362,-1,362,732,106,-1,107,734,362,-1,362,717,107,-1,115,733,362,-1,362,734,115,-1,114,732,362,-1,362,733,114,-1,107,719,363,-1,363,734,107,-1,108,736,363,-1,363,719,108,-1,116,735,363,-1,363,736,116,-1,115,734,363,-1,363,735,115,-1,108,721,364,-1,364,736,108,-1,109,738,364,-1,364,721,109,-1,117,737,364,-1,364,738,117,-1,116,736,364,-1,364,737,116,-1,109,723,365,-1,365,738,109,-1,110,740,365,-1,365,723,110,-1,118,739,365,-1,365,740,118,-1,117,738,365,-1,365,739,117,-1,110,725,366,-1,366,740,110,-1,111,742,366,-1,366,725,111,-1,119,741,366,-1,366,742,119,-1,118,740,366,-1,366,741,118,-1,111,727,367,-1,367,742,111,-1,104,729,367,-1,367,727,104,-1,112,743,367,-1,367,729,112,-1,119,742,367,-1,367,743,119,-1,112,728,368,-1,368,745,112,-1,113,746,368,-1,368,728,113,-1,121,744,368,-1,368,746,121,-1,120,745,368,-1,368,744,120,-1,113,731,369,-1,369,746,113,-1,114,748,369,-1,369,731,114,-1,122,747,369,-1,369,748,122,-1,121,746,369,-1,369,747,121,-1,114,733,370,-1,370,748,114,-1,115,750,370,-1,370,733,115,-1,123,749,370,-1,370,750,123,-1,122,748,370,-1,370,749,122,-1,115,735,371,-1,371,750,115,-1,116,752,371,-1,371,735,116,-1,124,751,371,-1,371,752,124,-1,123,750,371,-1,371,751,123,-1,116,737,372,-1,372,752,116,-1,117,754,372,-1,372,737,117,-1,125,753,372,-1,372,754,125,-1,124,752,372,-1,372,753,124,-1,117,739,373,-1,373,754,117,-1,118,756,373,-1,373,739,118,-1,126,755,373,-1,373,756,126,-1,125,754,373,-1,373,755,125,-1,118,741,374,-1,374,756,118,-1,119,758,374,-1,374,741,119,-1,127,757,374,-1,374,758,127,-1,126,756,374,-1,374,757,126,-1,119,743,375,-1,375,758,119,-1,112,745,375,-1,375,743,112,-1,120,759,375,-1,375,745,120,-1,127,758,375,-1,375,759,127,-1,120,744,376,-1,376,761,120,-1,121,762,376,-1,376,744,121,-1,129,760,376,-1,376,762,129,-1,128,761,376,-1,376,760,128,-1,121,747,377,-1,377,762,121,-1,122,764,377,-1,377,747,122,-1,130,763,377,-1,377,764,130,-1,129,762,377,-1,377,763,129,-1,122,749,378,-1,378,764,122,-1,123,766,378,-1,378,749,123,-1,131,765,378,-1,378,766,131,-1,130,764,378,-1,378,765,130,-1,123,751,379,-1,379,766,123,-1,124,768,379,-1,379,751,124,-1,132,767,379,-1,379,768,132,-1,131,766,379,-1,379,767,131,-1,124,753,380,-1,380,768,124,-1,125,770,380,-1,380,753,125,-1,133,769,380,-1,380,770,133,-1,132,768,380,-1,380,769,132,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_5()
		{
			int[] value = {125,755,381,-1,381,770,125,-1,126,772,381,-1,381,755,126,-1,134,771,381,-1,381,772,134,-1,133,770,381,-1,381,771,133,-1,126,757,382,-1,382,772,126,-1,127,774,382,-1,382,757,127,-1,135,773,382,-1,382,774,135,-1,134,772,382,-1,382,773,134,-1,127,759,383,-1,383,774,127,-1,120,761,383,-1,383,759,120,-1,128,775,383,-1,383,761,128,-1,135,774,383,-1,383,775,135,-1,128,760,384,-1,384,777,128,-1,129,778,384,-1,384,760,129,-1,137,776,384,-1,384,778,137,-1,136,777,384,-1,384,776,136,-1,129,763,385,-1,385,778,129,-1,130,780,385,-1,385,763,130,-1,138,779,385,-1,385,780,138,-1,137,778,385,-1,385,779,137,-1,130,765,386,-1,386,780,130,-1,131,782,386,-1,386,765,131,-1,139,781,386,-1,386,782,139,-1,138,780,386,-1,386,781,138,-1,131,767,387,-1,387,782,131,-1,132,784,387,-1,387,767,132,-1,140,783,387,-1,387,784,140,-1,139,782,387,-1,387,783,139,-1,132,769,388,-1,388,784,132,-1,133,786,388,-1,388,769,133,-1,141,785,388,-1,388,786,141,-1,140,784,388,-1,388,785,140,-1,133,771,389,-1,389,786,133,-1,134,788,389,-1,389,771,134,-1,142,787,389,-1,389,788,142,-1,141,786,389,-1,389,787,141,-1,134,773,390,-1,390,788,134,-1,135,790,390,-1,390,773,135,-1,143,789,390,-1,390,790,143,-1,142,788,390,-1,390,789,142,-1,135,775,391,-1,391,790,135,-1,128,777,391,-1,391,775,128,-1,136,791,391,-1,391,777,136,-1,143,790,391,-1,391,791,143,-1,136,776,392,-1,392,793,136,-1,137,794,392,-1,392,776,137,-1,145,792,392,-1,392,794,145,-1,144,793,392,-1,392,792,144,-1,137,779,393,-1,393,794,137,-1,138,796,393,-1,393,779,138,-1,146,795,393,-1,393,796,146,-1,145,794,393,-1,393,795,145,-1,138,781,394,-1,394,796,138,-1,139,798,394,-1,394,781,139,-1,147,797,394,-1,394,798,147,-1,146,796,394,-1,394,797,146,-1,139,783,395,-1,395,798,139,-1,140,800,395,-1,395,783,140,-1,148,799,395,-1,395,800,148,-1,147,798,395,-1,395,799,147,-1,140,785,396,-1,396,800,140,-1,141,802,396,-1,396,785,141,-1,149,801,396,-1,396,802,149,-1,148,800,396,-1,396,801,148,-1,141,787,397,-1,397,802,141,-1,142,804,397,-1,397,787,142,-1,150,803,397,-1,397,804,150,-1,149,802,397,-1,397,803,149,-1,142,789,398,-1,398,804,142,-1,143,806,398,-1,398,789,143,-1,151,805,398,-1,398,806,151,-1,150,804,398,-1,398,805,150,-1,143,791,399,-1,399,806,143,-1,136,793,399,-1,399,791,136,-1,144,807,399,-1,399,793,144,-1,151,806,399,-1,399,807,151,-1,144,792,400,-1,400,809,144,-1,145,810,400,-1,400,792,145,-1,153,808,400,-1,400,810,153,-1,152,809,400,-1,400,808,152,-1,145,795,401,-1,401,810,145,-1,146,812,401,-1,401,795,146,-1,154,811,401,-1,401,812,154,-1,153,810,401,-1,401,811,153,-1,146,797,402,-1,402,812,146,-1,147,814,402,-1,402,797,147,-1,155,813,402,-1,402,814,155,-1,154,812,402,-1,402,813,154,-1,147,799,403,-1,403,814,147,-1,148,816,403,-1,403,799,148,-1,156,815,403,-1,403,816,156,-1,155,814,403,-1,403,815,155,-1,148,801,404,-1,404,816,148,-1,149,818,404,-1,404,801,149,-1,157,817,404,-1,404,818,157,-1,156,816,404,-1,404,817,156,-1,149,803,405,-1,405,818,149,-1,150,820,405,-1,405,803,150,-1,158,819,405,-1,405,820,158,-1,157,818,405,-1,405,819,157,-1,150,805,406,-1,406,820,150,-1,151,822,406,-1,406,805,151,-1,159,821,406,-1,406,822,159,-1,158,820,406,-1,406,821,158,-1,151,807,407,-1,407,822,151,-1,144,809,407,-1,407,807,144,-1,152,823,407,-1,407,809,152,-1,159,822,407,-1,407,823,159,-1,152,808,408,-1,408,825,152,-1,153,826,408,-1,408,808,153,-1,161,824,408,-1,408,826,161,-1,160,825,408,-1,408,824,160,-1,153,811,409,-1,409,826,153,-1,154,828,409,-1,409,811,154,-1,162,827,409,-1,409,828,162,-1,161,826,409,-1,409,827,161,-1,154,813,410,-1,410,828,154,-1,155,830,410,-1,410,813,155,-1,163,829,410,-1,410,830,163,-1,162,828,410,-1,410,829,162,-1,155,815,411,-1,411,830,155,-1,156,832,411,-1,411,815,156,-1,164,831,411,-1,411,832,164,-1,163,830,411,-1,411,831,163,-1,156,817,412,-1,412,832,156,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_6()
		{
			int[] value = {157,834,412,-1,412,817,157,-1,165,833,412,-1,412,834,165,-1,164,832,412,-1,412,833,164,-1,157,819,413,-1,413,834,157,-1,158,836,413,-1,413,819,158,-1,166,835,413,-1,413,836,166,-1,165,834,413,-1,413,835,165,-1,158,821,414,-1,414,836,158,-1,159,838,414,-1,414,821,159,-1,167,837,414,-1,414,838,167,-1,166,836,414,-1,414,837,166,-1,159,823,415,-1,415,838,159,-1,152,825,415,-1,415,823,152,-1,160,839,415,-1,415,825,160,-1,167,838,415,-1,415,839,167,-1,160,824,416,-1,416,841,160,-1,161,842,416,-1,416,824,161,-1,169,840,416,-1,416,842,169,-1,168,841,416,-1,416,840,168,-1,161,827,417,-1,417,842,161,-1,162,844,417,-1,417,827,162,-1,170,843,417,-1,417,844,170,-1,169,842,417,-1,417,843,169,-1,162,829,418,-1,418,844,162,-1,163,846,418,-1,418,829,163,-1,171,845,418,-1,418,846,171,-1,170,844,418,-1,418,845,170,-1,163,831,419,-1,419,846,163,-1,164,848,419,-1,419,831,164,-1,172,847,419,-1,419,848,172,-1,171,846,419,-1,419,847,171,-1,164,833,420,-1,420,848,164,-1,165,850,420,-1,420,833,165,-1,173,849,420,-1,420,850,173,-1,172,848,420,-1,420,849,172,-1,165,835,421,-1,421,850,165,-1,166,852,421,-1,421,835,166,-1,174,851,421,-1,421,852,174,-1,173,850,421,-1,421,851,173,-1,166,837,422,-1,422,852,166,-1,167,854,422,-1,422,837,167,-1,175,853,422,-1,422,854,175,-1,174,852,422,-1,422,853,174,-1,167,839,423,-1,423,854,167,-1,160,841,423,-1,423,839,160,-1,168,855,423,-1,423,841,168,-1,175,854,423,-1,423,855,175,-1,168,840,424,-1,424,857,168,-1,169,858,424,-1,424,840,169,-1,177,856,424,-1,424,858,177,-1,176,857,424,-1,424,856,176,-1,169,843,425,-1,425,858,169,-1,170,860,425,-1,425,843,170,-1,178,859,425,-1,425,860,178,-1,177,858,425,-1,425,859,177,-1,170,845,426,-1,426,860,170,-1,171,862,426,-1,426,845,171,-1,179,861,426,-1,426,862,179,-1,178,860,426,-1,426,861,178,-1,171,847,427,-1,427,862,171,-1,172,864,427,-1,427,847,172,-1,180,863,427,-1,427,864,180,-1,179,862,427,-1,427,863,179,-1,172,849,428,-1,428,864,172,-1,173,866,428,-1,428,849,173,-1,181,865,428,-1,428,866,181,-1,180,864,428,-1,428,865,180,-1,173,851,429,-1,429,866,173,-1,174,868,429,-1,429,851,174,-1,182,867,429,-1,429,868,182,-1,181,866,429,-1,429,867,181,-1,174,853,430,-1,430,868,174,-1,175,870,430,-1,430,853,175,-1,183,869,430,-1,430,870,183,-1,182,868,430,-1,430,869,182,-1,175,855,431,-1,431,870,175,-1,168,857,431,-1,431,855,168,-1,176,871,431,-1,431,857,176,-1,183,870,431,-1,431,871,183,-1,176,856,432,-1,432,873,176,-1,177,874,432,-1,432,856,177,-1,185,872,432,-1,432,874,185,-1,184,873,432,-1,432,872,184,-1,177,859,433,-1,433,874,177,-1,178,876,433,-1,433,859,178,-1,186,875,433,-1,433,876,186,-1,185,874,433,-1,433,875,185,-1,178,861,434,-1,434,876,178,-1,179,878,434,-1,434,861,179,-1,187,877,434,-1,434,878,187,-1,186,876,434,-1,434,877,186,-1,179,863,435,-1,435,878,179,-1,180,880,435,-1,435,863,180,-1,188,879,435,-1,435,880,188,-1,187,878,435,-1,435,879,187,-1,180,865,436,-1,436,880,180,-1,181,882,436,-1,436,865,181,-1,189,881,436,-1,436,882,189,-1,188,880,436,-1,436,881,188,-1,181,867,437,-1,437,882,181,-1,182,884,437,-1,437,867,182,-1,190,883,437,-1,437,884,190,-1,189,882,437,-1,437,883,189,-1,182,869,438,-1,438,884,182,-1,183,886,438,-1,438,869,183,-1,191,885,438,-1,438,886,191,-1,190,884,438,-1,438,885,190,-1,183,871,439,-1,439,886,183,-1,176,873,439,-1,439,871,176,-1,184,887,439,-1,439,873,184,-1,191,886,439,-1,439,887,191,-1,184,872,440,-1,440,889,184,-1,185,890,440,-1,440,872,185,-1,193,888,440,-1,440,890,193,-1,192,889,440,-1,440,888,192,-1,185,875,441,-1,441,890,185,-1,186,892,441,-1,441,875,186,-1,194,891,441,-1,441,892,194,-1,193,890,441,-1,441,891,193,-1,186,877,442,-1,442,892,186,-1,187,894,442,-1,442,877,187,-1,195,893,442,-1,442,894,195,-1,194,892,442,-1,442,893,194,-1,187,879,443,-1,443,894,187,-1,188,896,443,-1,443,879,188,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_7()
		{
			int[] value = {196,895,443,-1,443,896,196,-1,195,894,443,-1,443,895,195,-1,188,881,444,-1,444,896,188,-1,189,898,444,-1,444,881,189,-1,197,897,444,-1,444,898,197,-1,196,896,444,-1,444,897,196,-1,189,883,445,-1,445,898,189,-1,190,900,445,-1,445,883,190,-1,198,899,445,-1,445,900,198,-1,197,898,445,-1,445,899,197,-1,190,885,446,-1,446,900,190,-1,191,902,446,-1,446,885,191,-1,199,901,446,-1,446,902,199,-1,198,900,446,-1,446,901,198,-1,191,887,447,-1,447,902,191,-1,184,889,447,-1,447,887,184,-1,192,903,447,-1,447,889,192,-1,199,902,447,-1,447,903,199,-1,192,888,448,-1,448,905,192,-1,193,906,448,-1,448,888,193,-1,201,904,448,-1,448,906,201,-1,200,905,448,-1,448,904,200,-1,193,891,449,-1,449,906,193,-1,194,908,449,-1,449,891,194,-1,202,907,449,-1,449,908,202,-1,201,906,449,-1,449,907,201,-1,194,893,450,-1,450,908,194,-1,195,910,450,-1,450,893,195,-1,203,909,450,-1,450,910,203,-1,202,908,450,-1,450,909,202,-1,195,895,451,-1,451,910,195,-1,196,912,451,-1,451,895,196,-1,204,911,451,-1,451,912,204,-1,203,910,451,-1,451,911,203,-1,196,897,452,-1,452,912,196,-1,197,914,452,-1,452,897,197,-1,205,913,452,-1,452,914,205,-1,204,912,452,-1,452,913,204,-1,197,899,453,-1,453,914,197,-1,198,916,453,-1,453,899,198,-1,206,915,453,-1,453,916,206,-1,205,914,453,-1,453,915,205,-1,198,901,454,-1,454,916,198,-1,199,918,454,-1,454,901,199,-1,207,917,454,-1,454,918,207,-1,206,916,454,-1,454,917,206,-1,199,903,455,-1,455,918,199,-1,192,905,455,-1,455,903,192,-1,200,919,455,-1,455,905,200,-1,207,918,455,-1,455,919,207,-1,200,904,456,-1,456,921,200,-1,201,922,456,-1,456,904,201,-1,209,920,456,-1,456,922,209,-1,208,921,456,-1,456,920,208,-1,201,907,457,-1,457,922,201,-1,202,924,457,-1,457,907,202,-1,210,923,457,-1,457,924,210,-1,209,922,457,-1,457,923,209,-1,202,909,458,-1,458,924,202,-1,203,926,458,-1,458,909,203,-1,211,925,458,-1,458,926,211,-1,210,924,458,-1,458,925,210,-1,203,911,459,-1,459,926,203,-1,204,928,459,-1,459,911,204,-1,212,927,459,-1,459,928,212,-1,211,926,459,-1,459,927,211,-1,204,913,460,-1,460,928,204,-1,205,930,460,-1,460,913,205,-1,213,929,460,-1,460,930,213,-1,212,928,460,-1,460,929,212,-1,205,915,461,-1,461,930,205,-1,206,932,461,-1,461,915,206,-1,214,931,461,-1,461,932,214,-1,213,930,461,-1,461,931,213,-1,206,917,462,-1,462,932,206,-1,207,934,462,-1,462,917,207,-1,215,933,462,-1,462,934,215,-1,214,932,462,-1,462,933,214,-1,207,919,463,-1,463,934,207,-1,200,921,463,-1,463,919,200,-1,208,935,463,-1,463,921,208,-1,215,934,463,-1,463,935,215,-1,208,920,464,-1,464,937,208,-1,209,938,464,-1,464,920,209,-1,217,936,464,-1,464,938,217,-1,216,937,464,-1,464,936,216,-1,209,923,465,-1,465,938,209,-1,210,940,465,-1,465,923,210,-1,218,939,465,-1,465,940,218,-1,217,938,465,-1,465,939,217,-1,210,925,466,-1,466,940,210,-1,211,942,466,-1,466,925,211,-1,219,941,466,-1,466,942,219,-1,218,940,466,-1,466,941,218,-1,211,927,467,-1,467,942,211,-1,212,944,467,-1,467,927,212,-1,220,943,467,-1,467,944,220,-1,219,942,467,-1,467,943,219,-1,212,929,468,-1,468,944,212,-1,213,946,468,-1,468,929,213,-1,221,945,468,-1,468,946,221,-1,220,944,468,-1,468,945,220,-1,213,931,469,-1,469,946,213,-1,214,948,469,-1,469,931,214,-1,222,947,469,-1,469,948,222,-1,221,946,469,-1,469,947,221,-1,214,933,470,-1,470,948,214,-1,215,950,470,-1,470,933,215,-1,223,949,470,-1,470,950,223,-1,222,948,470,-1,470,949,222,-1,215,935,471,-1,471,950,215,-1,208,937,471,-1,471,935,208,-1,216,951,471,-1,471,937,216,-1,223,950,471,-1,471,951,223,-1,216,936,472,-1,472,953,216,-1,217,954,472,-1,472,936,217,-1,225,952,472,-1,472,954,225,-1,224,953,472,-1,472,952,224,-1,217,939,473,-1,473,954,217,-1,218,956,473,-1,473,939,218,-1,226,955,473,-1,473,956,226,-1,225,954,473,-1,473,955,225,-1,218,941,474,-1,474,956,218,-1,219,958,474,-1,474,941,219,-1,227,957,474,-1,474,958,227,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_8()
		{
			int[] value = {226,956,474,-1,474,957,226,-1,219,943,475,-1,475,958,219,-1,220,960,475,-1,475,943,220,-1,228,959,475,-1,475,960,228,-1,227,958,475,-1,475,959,227,-1,220,945,476,-1,476,960,220,-1,221,962,476,-1,476,945,221,-1,229,961,476,-1,476,962,229,-1,228,960,476,-1,476,961,228,-1,221,947,477,-1,477,962,221,-1,222,964,477,-1,477,947,222,-1,230,963,477,-1,477,964,230,-1,229,962,477,-1,477,963,229,-1,222,949,478,-1,478,964,222,-1,223,966,478,-1,478,949,223,-1,231,965,478,-1,478,966,231,-1,230,964,478,-1,478,965,230,-1,223,951,479,-1,479,966,223,-1,216,953,479,-1,479,951,216,-1,224,967,479,-1,479,953,224,-1,231,966,479,-1,479,967,231,-1,224,952,480,-1,480,969,224,-1,225,970,480,-1,480,952,225,-1,233,968,480,-1,480,970,233,-1,232,969,480,-1,480,968,232,-1,225,955,481,-1,481,970,225,-1,226,972,481,-1,481,955,226,-1,234,971,481,-1,481,972,234,-1,233,970,481,-1,481,971,233,-1,226,957,482,-1,482,972,226,-1,227,974,482,-1,482,957,227,-1,235,973,482,-1,482,974,235,-1,234,972,482,-1,482,973,234,-1,227,959,483,-1,483,974,227,-1,228,976,483,-1,483,959,228,-1,236,975,483,-1,483,976,236,-1,235,974,483,-1,483,975,235,-1,228,961,484,-1,484,976,228,-1,229,978,484,-1,484,961,229,-1,237,977,484,-1,484,978,237,-1,236,976,484,-1,484,977,236,-1,229,963,485,-1,485,978,229,-1,230,980,485,-1,485,963,230,-1,238,979,485,-1,485,980,238,-1,237,978,485,-1,485,979,237,-1,230,965,486,-1,486,980,230,-1,231,982,486,-1,486,965,231,-1,239,981,486,-1,486,982,239,-1,238,980,486,-1,486,981,238,-1,231,967,487,-1,487,982,231,-1,224,969,487,-1,487,967,224,-1,232,983,487,-1,487,969,232,-1,239,982,487,-1,487,983,239,-1,232,968,488,-1,488,985,232,-1,233,986,488,-1,488,968,233,-1,241,984,488,-1,488,986,241,-1,240,985,488,-1,488,984,240,-1,233,971,489,-1,489,986,233,-1,234,988,489,-1,489,971,234,-1,242,987,489,-1,489,988,242,-1,241,986,489,-1,489,987,241,-1,234,973,490,-1,490,988,234,-1,235,990,490,-1,490,973,235,-1,243,989,490,-1,490,990,243,-1,242,988,490,-1,490,989,242,-1,235,975,491,-1,491,990,235,-1,236,992,491,-1,491,975,236,-1,244,991,491,-1,491,992,244,-1,243,990,491,-1,491,991,243,-1,236,977,492,-1,492,992,236,-1,237,994,492,-1,492,977,237,-1,245,993,492,-1,492,994,245,-1,244,992,492,-1,492,993,244,-1,237,979,493,-1,493,994,237,-1,238,996,493,-1,493,979,238,-1,246,995,493,-1,493,996,246,-1,245,994,493,-1,493,995,245,-1,238,981,494,-1,494,996,238,-1,239,998,494,-1,494,981,239,-1,247,997,494,-1,494,998,247,-1,246,996,494,-1,494,997,246,-1,239,983,495,-1,495,998,239,-1,232,985,495,-1,495,983,232,-1,240,999,495,-1,495,985,240,-1,247,998,495,-1,495,999,247,-1,240,984,496,-1,496,1001,240,-1,241,1002,496,-1,496,984,241,-1,249,1000,496,-1,496,1002,249,-1,248,1001,496,-1,496,1000,248,-1,241,987,497,-1,497,1002,241,-1,242,1004,497,-1,497,987,242,-1,250,1003,497,-1,497,1004,250,-1,249,1002,497,-1,497,1003,249,-1,242,989,498,-1,498,1004,242,-1,243,1006,498,-1,498,989,243,-1,251,1005,498,-1,498,1006,251,-1,250,1004,498,-1,498,1005,250,-1,243,991,499,-1,499,1006,243,-1,244,1008,499,-1,499,991,244,-1,252,1007,499,-1,499,1008,252,-1,251,1006,499,-1,499,1007,251,-1,244,993,500,-1,500,1008,244,-1,245,1010,500,-1,500,993,245,-1,253,1009,500,-1,500,1010,253,-1,252,1008,500,-1,500,1009,252,-1,245,995,501,-1,501,1010,245,-1,246,1012,501,-1,501,995,246,-1,254,1011,501,-1,501,1012,254,-1,253,1010,501,-1,501,1011,253,-1,246,997,502,-1,502,1012,246,-1,247,1014,502,-1,502,997,247,-1,255,1013,502,-1,502,1014,255,-1,254,1012,502,-1,502,1013,254,-1,247,999,503,-1,503,1014,247,-1,240,1001,503,-1,503,999,240,-1,248,1015,503,-1,503,1001,248,-1,255,1014,503,-1,503,1015,255,-1,248,1000,504,-1,504,1016,248,-1,249,1017,504,-1,504,1000,249,-1,1,514,504,-1,504,1017,1,-1,0,1016,504,-1,504,514,0,-1,249,1003,505,-1,505,1017,249,-1,250,1018,505,-1,505,1003,250,-1,2,517,505,-1,505,1018,2,-1,1,1017,505,-1,505,517,1,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_9()
		{
			int[] value = {250,1005,506,-1,506,1018,250,-1,251,1019,506,-1,506,1005,251,-1,3,520,506,-1,506,1019,3,-1,2,1018,506,-1,506,520,2,-1,251,1007,507,-1,507,1019,251,-1,252,1020,507,-1,507,1007,252,-1,4,523,507,-1,507,1020,4,-1,3,1019,507,-1,507,523,3,-1,252,1009,508,-1,508,1020,252,-1,253,1021,508,-1,508,1009,253,-1,5,526,508,-1,508,1021,5,-1,4,1020,508,-1,508,526,4,-1,253,1011,509,-1,509,1021,253,-1,254,1022,509,-1,509,1011,254,-1,6,529,509,-1,509,1022,6,-1,5,1021,509,-1,509,529,5,-1,254,1013,510,-1,510,1022,254,-1,255,1023,510,-1,510,1013,255,-1,7,532,510,-1,510,1023,7,-1,6,1022,510,-1,510,532,6,-1,255,1015,511,-1,511,1023,255,-1,248,1016,511,-1,511,1015,248,-1,0,535,511,-1,511,1016,0,-1,7,1023,511,-1,511,535,7,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_26_point_1()
		{
			double[] value = {0.0,-3.922,-91.6,0.0,-31.38,-89.46,0.0,-58.84,-91.6,0.0,-62.76,-106.5,0.0,-58.84,-121.5,0.0,-31.38,-123.6,0.0,-3.922,-121.5,0.0,0.0,-106.5,17.87,-3.922,-89.84,17.45,-31.38,-87.74,17.87,-58.84,-89.84,20.78,-62.76,-104.5,23.7,-58.84,-119.1,24.12,-31.38,-121.2,23.7,-3.922,-119.1,20.78,0.0,-104.5,35.05,-3.922,-84.62,34.24,-31.38,-82.65,35.05,-58.84,-84.62,40.77,-62.76,-98.43,46.49,-58.84,-112.2,47.31,-31.38,-114.2,46.49,-3.922,-112.2,40.77,0.0,-98.43,50.89,-3.922,-76.16,49.7,-31.38,-74.38,50.89,-58.84,-76.16,59.19,-62.76,-88.58,67.49,-58.84,-101.0,68.68,-31.38,-102.8,67.49,-3.922,-101.0,59.19,0.0,-88.58,64.77,-3.922,-64.77,63.26,-31.38,-63.26,64.77,-58.84,-64.77,75.33,-62.76,-75.33,85.9,-58.84,-85.9,87.41,-31.38,-87.41,85.9,-3.922,-85.9,75.33,0.0,-75.33,76.16,-3.922,-50.89,74.38,-31.38,-49.7,76.16,-58.84,-50.89,88.58,-62.76,-59.19,101.0,-58.84,-67.49,102.8,-31.38,-68.68,101.0,-3.922,-67.49,88.58,0.0,-59.19,84.62,-3.922,-35.05,82.65,-31.38,-34.24,84.62,-58.84,-35.05,98.43,-62.76,-40.77,112.2,-58.84,-46.49,114.2,-31.38,-47.31,112.2,-3.922,-46.49,98.43,0.0,-40.77,89.84,-3.922,-17.87,87.74,-31.38,-17.45,89.84,-58.84,-17.87,104.5,-62.76,-20.78,119.1,-58.84,-23.7,121.2,-31.38,-24.12,119.1,-3.922,-23.7,104.5,0.0,-20.78,91.6,-3.922,0.0,89.46,-31.38,0.0,91.6,-58.84,0.0,106.5,-62.76,0.0,121.5,-58.84,0.0,123.6,-31.38,0.0,121.5,-3.922,0.0,106.5,0.0,0.0,89.84,-3.922,17.87,87.74,-31.38,17.45,89.84,-58.84,17.87,104.5,-62.76,20.78,119.1,-58.84,23.7,121.2,-31.38,24.12,119.1,-3.922,23.7,104.5,0.0,20.78,84.62,-3.922,35.05,82.65,-31.38,34.24,84.62,-58.84,35.05,98.43,-62.76,40.77,112.2,-58.84,46.49,114.2,-31.38,47.31,112.2,-3.922,46.49,98.43,0.0,40.77,76.16,-3.922,50.89,74.38,-31.38,49.7,76.16,-58.84,50.89,88.58,-62.76,59.19,101.0,-58.84,67.49,102.8,-31.38,68.68,101.0,-3.922,67.49,88.58,0.0,59.19,64.77,-3.922,64.77,63.26,-31.38,63.26,64.77,-58.84,64.77,75.33,-62.76,75.33};
			return value;
		}
		private double[] getCoordinate_6_26_point_2()
		{
			double[] value = {85.9,-58.84,85.9,87.41,-31.38,87.41,85.9,-3.922,85.9,75.33,0,75.33,50.89,-3.922,76.16,49.7,-31.38,74.38,50.89,-58.84,76.16,59.19,-62.76,88.58,67.49,-58.84,101,68.68,-31.38,102.8,67.49,-3.922,101,59.19,0,88.58,35.05,-3.922,84.62,34.24,-31.38,82.65,35.05,-58.84,84.62,40.77,-62.76,98.43,46.49,-58.84,112.2,47.31,-31.38,114.2,46.49,-3.922,112.2,40.77,0,98.43,17.87,-3.922,89.84,17.45,-31.38,87.74,17.87,-58.84,89.84,20.78,-62.76,104.5,23.7,-58.84,119.1,24.12,-31.38,121.2,23.7,-3.922,119.1,20.78,0,104.5,0,-3.922,91.6,0,-31.38,89.46,0,-58.84,91.6,0,-62.76,106.5,0,-58.84,121.5,0,-31.38,123.6,0,-3.922,121.5,0,0,106.5,-17.87,-3.922,89.84,-17.45,-31.38,87.74,-17.87,-58.84,89.84,-20.78,-62.76,104.5,-23.7,-58.84,119.1,-24.12,-31.38,121.2,-23.7,-3.922,119.1,-20.78,0,104.5,-35.05,-3.922,84.62,-34.24,-31.38,82.65,-35.05,-58.84,84.62,-40.77,-62.76,98.43,-46.49,-58.84,112.2,-47.31,-31.38,114.2,-46.49,-3.922,112.2,-40.77,0,98.43,-50.89,-3.922,76.16,-49.7,-31.38,74.38,-50.89,-58.84,76.16,-59.19,-62.76,88.58,-67.49,-58.84,101,-68.68,-31.38,102.8,-67.49,-3.922,101,-59.19,0,88.58,-64.77,-3.922,64.77,-63.26,-31.38,63.26,-64.77,-58.84,64.77,-75.33,-62.76,75.33,-85.9,-58.84,85.9,-87.41,-31.38,87.41,-85.9,-3.922,85.9,-75.33,0,75.33,-76.16,-3.922,50.89,-74.38,-31.38,49.7,-76.16,-58.84,50.89,-88.58,-62.76,59.19,-101,-58.84,67.49,-102.8,-31.38,68.68,-101,-3.922,67.49,-88.58,0,59.19,-84.62,-3.922,35.05,-82.65,-31.38,34.24,-84.62,-58.84,35.05,-98.43,-62.76,40.77,-112.2,-58.84,46.49,-114.2,-31.38,47.31,-112.2,-3.922,46.49,-98.43,0,40.77,-89.84,-3.922,17.87,-87.74,-31.38,17.45,-89.84,-58.84,17.87,-104.5,-62.76,20.78,-119.1,-58.84,23.7,-121.2,-31.38,24.12,-119.1,-3.922,23.7,-104.5,0,20.78,-91.6,-3.922,0,-89.46,-31.38,0,-91.6,-58.84,0,-106.5,-62.76,0,-121.5,-58.84,-1.097e-005,-123.6,-31.38,-1.115e-005,-121.5,-3.922,-1.109e-005,-106.5,0.0,0.0};
			return value;
		}
		private double[] getCoordinate_6_26_point_3()
		{
			double[] value = {-89.84,-3.922,-17.87,-87.74,-31.38,-17.45,-89.84,-58.84,-17.87,-104.5,-62.76,-20.78,-119.1,-58.84,-23.7,-121.2,-31.38,-24.12,-119.1,-3.922,-23.7,-104.5,0.0,-20.78,-84.62,-3.922,-35.05,-82.65,-31.38,-34.24,-84.62,-58.84,-35.05,-98.43,-62.76,-40.77,-112.2,-58.84,-46.49,-114.2,-31.38,-47.31,-112.2,-3.922,-46.49,-98.43,0.0,-40.77,-76.16,-3.922,-50.89,-74.38,-31.38,-49.7,-76.16,-58.84,-50.89,-88.58,-62.76,-59.19,-101.0,-58.84,-67.49,-102.8,-31.38,-68.68,-101.0,-3.922,-67.49,-88.58,0.0,-59.19,-64.77,-3.922,-64.77,-63.26,-31.38,-63.26,-64.77,-58.84,-64.77,-75.33,-62.76,-75.33,-85.9,-58.84,-85.9,-87.41,-31.38,-87.41,-85.9,-3.922,-85.9,-75.33,0.0,-75.33,-50.89,-3.922,-76.16,-49.7,-31.38,-74.38,-50.89,-58.84,-76.16,-59.19,-62.76,-88.58,-67.49,-58.84,-101.0,-68.68,-31.38,-102.8,-67.49,-3.922,-101.0,-59.19,0.0,-88.58,-35.05,-3.922,-84.62,-34.24,-31.38,-82.65,-35.05,-58.84,-84.62,-40.77,-62.76,-98.43,-46.49,-58.84,-112.2,-47.31,-31.38,-114.2,-46.49,-3.922,-112.2,-40.77,0.0,-98.43,-17.87,-3.922,-89.84,-17.45,-31.38,-87.74,-17.87,-58.84,-89.84,-20.78,-62.76,-104.5,-23.7,-58.84,-119.1,-24.12,-31.38,-121.2,-23.7,-3.922,-119.1,-20.78,0.0,-104.5,8.769,-15.69,-89.03,8.769,-47.07,-89.03,9.606,-62.76,-97.53,11.28,-62.76,-114.5,12.12,-47.07,-123.0,12.12,-15.69,-123.0,11.28,0.0,-114.5,9.606,0.0,-97.53,25.97,-15.69,-85.61,25.97,-47.07,-85.61,28.45,-62.76,-93.78,33.4,-62.76,-110.1,35.88,-47.07,-118.3,35.88,-15.69,-118.3,33.4,0.0,-110.1,28.45,0.0,-93.78,42.17,-15.69,-78.9,42.17,-47.07,-78.9,46.2,-62.76,-86.43,54.25,-62.76,-101.5,58.27,-47.07,-109.0,58.27,-15.69,-109.0,54.25,0.0,-101.5,46.2,0.0,-86.43,56.75,-15.69,-69.15,56.75,-47.07,-69.15,62.17,-62.76,-75.75,73.0,-62.76,-88.96,78.42,-47.07,-95.56,78.42,-15.69,-95.56,73.0,0.0,-88.96,62.17,0.0,-75.75,69.15,-15.69,-56.75,69.15,-47.07,-56.75,75.75,-62.76,-62.17,88.96,-62.76,-73.0,95.56,-47.07,-78.42,95.56,-15.69,-78.42,88.96,0.0,-73.0,75.75,0.0,-62.17,78.9,-15.69,-42.17,78.9,-47.07,-42.17,86.43,-62.76,-46.2,101.5,-62.76,-54.25};
			return value;
		}
		private double[] getCoordinate_6_26_point_4()
		{
			double[] value = {109.0,-47.07,-58.27,109.0,-15.69,-58.27,101.5,0.0,-54.25,86.43,0.0,-46.2,85.61,-15.69,-25.97,85.61,-47.07,-25.97,93.78,-62.76,-28.45,110.1,-62.76,-33.4,118.3,-47.07,-35.88,118.3,-15.69,-35.88,110.1,0.0,-33.4,93.78,0.0,-28.45,89.03,-15.69,-8.769,89.03,-47.07,-8.769,97.53,-62.76,-9.606,114.5,-62.76,-11.28,123.0,-47.07,-12.12,123.0,-15.69,-12.12,114.5,0.0,-11.28,97.53,0.0,-9.606,89.03,-15.69,8.769,89.03,-47.07,8.769,97.53,-62.76,9.606,114.5,-62.76,11.28,123.0,-47.07,12.12,123.0,-15.69,12.12,114.5,0.0,11.28,97.53,0.0,9.606,85.61,-15.69,25.97,85.61,-47.07,25.97,93.78,-62.76,28.45,110.1,-62.76,33.4,118.3,-47.07,35.88,118.3,-15.69,35.88,110.1,0.0,33.4,93.78,0.0,28.45,78.9,-15.69,42.17,78.9,-47.07,42.17,86.43,-62.76,46.2,101.5,-62.76,54.25,109.0,-47.07,58.27,109.0,-15.69,58.27,101.5,0.0,54.25,86.43,0.0,46.2,69.15,-15.69,56.75,69.15,-47.07,56.75,75.75,-62.76,62.17,88.96,-62.76,73.0,95.56,-47.07,78.42,95.56,-15.69,78.42,88.96,0.0,73.0,75.75,0.0,62.17,56.75,-15.69,69.15,56.75,-47.07,69.15,62.17,-62.76,75.75,73.0,-62.76,88.96,78.42,-47.07,95.56,78.42,-15.69,95.56,73.0,0.0,88.96,62.17,0.0,75.75,42.17,-15.69,78.9,42.17,-47.07,78.9,46.2,-62.76,86.43,54.25,-62.76,101.5,58.27,-47.07,109.0,58.27,-15.69,109.0,54.25,0.0,101.5,46.2,0.0,86.43,25.97,-15.69,85.61,25.97,-47.07,85.61,28.45,-62.76,93.78,33.4,-62.76,110.1,35.88,-47.07,118.3,35.88,-15.69,118.3,33.4,0.0,110.1,28.45,0.0,93.78,8.769,-15.69,89.03,8.769,-47.07,89.03,9.606,-62.76,97.53,11.28,-62.76,114.5,12.12,-47.07,123.0,12.12,-15.69,123.0,11.28,0.0,114.5,9.606,0.0,97.53,-8.769,-15.69,89.03,-8.769,-47.07,89.03,-9.606,-62.76,97.53,-11.28,-62.76,114.5,-12.12,-47.07,123.0,-12.12,-15.69,123.0,-11.28,0.0,114.5,-9.606,0.0,97.53,-25.97,-15.69,85.61,-25.97,-47.07,85.61,-28.45,-62.76,93.78,-33.4,-62.76,110.1,-35.88,-47.07,118.3,-35.88,-15.69,118.3,-33.4,0.0,110.1,-28.45,0.0,93.78};
			return value;
		}
		private double[] getCoordinate_6_26_point_5()
		{
			double[] value = {-42.17,-15.69,78.9,-42.17,-47.07,78.9,-46.2,-62.76,86.43,-54.25,-62.76,101.5,-58.27,-47.07,109.0,-58.27,-15.69,109.0,-54.25,0.0,101.5,-46.2,0.0,86.43,-56.75,-15.69,69.15,-56.75,-47.07,69.15,-62.17,-62.76,75.75,-73.0,-62.76,88.96,-78.42,-47.07,95.56,-78.42,-15.69,95.56,-73.0,0.0,88.96,-62.17,0.0,75.75,-69.15,-15.69,56.75,-69.15,-47.07,56.75,-75.75,-62.76,62.17,-88.96,-62.76,73.0,-95.56,-47.07,78.42,-95.56,-15.69,78.42,-88.96,0.0,73.0,-75.75,0.0,62.17,-78.9,-15.69,42.17,-78.9,-47.07,42.17,-86.43,-62.76,46.2,-101.5,-62.76,54.25,-109.0,-47.07,58.27,-109.0,-15.69,58.27,-101.5,0.0,54.25,-86.43,0.0,46.2,-85.61,-15.69,25.97,-85.61,-47.07,25.97,-93.78,-62.76,28.45,-110.1,-62.76,33.4,-118.3,-47.07,35.88,-118.3,-15.69,35.88,-110.1,0.0,33.4,-93.78,0.0,28.45,-89.03,-15.69,8.769,-89.03,-47.07,8.769,-97.53,-62.76,9.606,-114.5,-62.76,11.28,-123.0,-47.07,12.12,-123.0,-15.69,12.12,-114.5,0.0,11.28,-97.53,0.0,9.606,-89.03,-15.69,-8.769,-89.03,-47.07,-8.769,-97.53,-62.76,-9.606,-114.5,-62.76,-11.28,-123.0,-47.07,-12.12,-123.0,-15.69,-12.12,-114.5,0.0,-11.28,-97.53,0.0,-9.606,-85.61,-15.69,-25.97,-85.61,-47.07,-25.97,-93.78,-62.76,-28.45,-110.1,-62.76,-33.4,-118.3,-47.07,-35.88,-118.3,-15.69,-35.88,-110.1,0.0,-33.4,-93.78,0.0,-28.45,-78.9,-15.69,-42.17,-78.9,-47.07,-42.17,-86.43,-62.76,-46.2,-101.5,-62.76,-54.25,-109.0,-47.07,-58.27,-109.0,-15.69,-58.27,-101.5,0.0,-54.25,-86.43,0.0,-46.2,-69.15,-15.69,-56.75,-69.15,-47.07,-56.75,-75.75,-62.76,-62.17,-88.96,-62.76,-73.0,-95.56,-47.07,-78.42,-95.56,-15.69,-78.42,-88.96,0.0,-73.0,-75.75,0.0,-62.17,-56.75,-15.69,-69.15,-56.75,-47.07,-69.15,-62.17,-62.76,-75.75,-73.0,-62.76,-88.96,-78.42,-47.07,-95.56,-78.42,-15.69,-95.56,-73.0,0.0,-88.96,-62.17,0.0,-75.75,-42.17,-15.69,-78.9,-42.17,-47.07,-78.9,-46.2,-62.76,-86.43,-54.25,-62.76,-101.5,-58.27,-47.07,-109.0,-58.27,-15.69,-109.0,-54.25,0.0,-101.5,-46.2,0.0,-86.43,-25.97,-15.69,-85.61,-25.97,-47.07,-85.61,-28.45,-62.76,-93.78,-33.4,-62.76,-110.1};
			return value;
		}
		private double[] getCoordinate_6_26_point_6()
		{
			double[] value = {-35.88,-47.07,-118.3,-35.88,-15.69,-118.3,-33.4,0.0,-110.1,-28.45,0.0,-93.78,-8.769,-15.69,-89.03,-8.769,-47.07,-89.03,-9.606,-62.76,-97.53,-11.28,-62.76,-114.5,-12.12,-47.07,-123.0,-12.12,-15.69,-123.0,-11.28,0.0,-114.5,-9.606,0.0,-97.53,17.45,-15.69,-87.74,8.978,-3.922,-91.15,0.0,-15.69,-89.46,8.769,-31.38,-89.03,17.45,-47.07,-87.74,0.0,-47.07,-89.46,8.978,-58.84,-91.15,19.12,-62.76,-96.12,0.0,-62.76,-98.0,10.44,-62.76,-106.0,22.45,-62.76,-112.9,0.0,-62.76,-115.1,11.91,-58.84,-120.9,24.12,-47.07,-121.2,0.0,-47.07,-123.6,12.12,-31.38,-123.0,24.12,-15.69,-121.2,0.0,-15.69,-123.6,11.91,-3.922,-120.9,22.45,0.0,-112.9,0.0,0.0,-115.1,10.44,0.0,-106.0,19.12,0.0,-96.12,0.0,0.0,-98.0,34.24,-15.69,-82.65,26.59,-3.922,-87.65,25.97,-31.38,-85.61,34.24,-47.07,-82.65,26.59,-58.84,-87.65,37.5,-62.76,-90.54,30.93,-62.76,-101.9,44.04,-62.76,-106.3,35.26,-58.84,-116.2,47.31,-47.07,-114.2,35.88,-31.38,-118.3,47.31,-15.69,-114.2,35.26,-3.922,-116.2,44.04,0.0,-106.3,30.93,0.0,-101.9,37.5,0.0,-90.54,49.7,-15.69,-74.38,43.18,-3.922,-80.78,42.17,-31.38,-78.9,49.7,-47.07,-74.38,43.18,-58.84,-80.78,54.45,-62.76,-81.48,50.22,-62.76,-93.96,63.93,-62.76,-95.68,57.27,-58.84,-107.1,68.68,-47.07,-102.8,58.27,-31.38,-109.0,68.68,-15.69,-102.8,57.27,-3.922,-107.1,63.93,0.0,-95.68,50.22,0.0,-93.96,54.45,0.0,-81.48,63.26,-15.69,-63.26,58.11,-3.922,-70.8,56.75,-31.38,-69.15,63.26,-47.07,-63.26,58.11,-58.84,-70.8,69.3,-62.76,-69.3,67.59,-62.76,-82.35,81.37,-62.76,-81.37,77.07,-58.84,-93.91,87.41,-47.07,-87.41,78.42,-31.38,-95.56,87.41,-15.69,-87.41,77.07,-3.922,-93.91,81.37,0.0,-81.37,67.59,0.0,-82.35,69.3,0.0,-69.3,74.38,-15.69,-49.7,70.8,-3.922,-58.11,69.15,-31.38,-56.75,74.38,-47.07,-49.7,70.8,-58.84,-58.11,81.48,-62.76,-54.45,82.35,-62.76,-67.59,95.68,-62.76,-63.93,93.91,-58.84,-77.07,102.8,-47.07,-68.68,95.56,-31.38,-78.42,102.8,-15.69,-68.68,93.91,-3.922,-77.07,95.68,0.0,-63.93,82.35,0.0,-67.59,81.48,0.0,-54.45};
			return value;
		}
		private double[] getCoordinate_6_26_point_7()
		{
			double[] value = {82.65,-15.69,-34.24,80.78,-3.922,-43.18,78.9,-31.38,-42.17,82.65,-47.07,-34.24,80.78,-58.84,-43.18,90.54,-62.76,-37.5,93.96,-62.76,-50.22,106.3,-62.76,-44.04,107.1,-58.84,-57.27,114.2,-47.07,-47.31,109.0,-31.38,-58.27,114.2,-15.69,-47.31,107.1,-3.922,-57.27,106.3,0.0,-44.04,93.96,0.0,-50.22,90.54,0.0,-37.5,87.74,-15.69,-17.45,87.65,-3.922,-26.59,85.61,-31.38,-25.97,87.74,-47.07,-17.45,87.65,-58.84,-26.59,96.12,-62.76,-19.12,101.9,-62.76,-30.93,112.9,-62.76,-22.45,116.2,-58.84,-35.26,121.2,-47.07,-24.12,118.3,-31.38,-35.88,121.2,-15.69,-24.12,116.2,-3.922,-35.26,112.9,0.0,-22.45,101.9,0.0,-30.93,96.12,0.0,-19.12,89.46,-15.69,0.0,91.15,-3.922,-8.978,89.03,-31.38,-8.769,89.46,-47.07,0.0,91.15,-58.84,-8.978,98.0,-62.76,0.0,106.0,-62.76,-10.44,115.1,-62.76,0.0,120.9,-58.84,-11.91,123.6,-47.07,0.0,123.0,-31.38,-12.12,123.6,-15.69,0.0,120.9,-3.922,-11.91,115.1,0.0,0.0,106.0,0.0,-10.44,98.0,0.0,0.0,87.74,-15.69,17.45,91.15,-3.922,8.978,89.03,-31.38,8.769,87.74,-47.07,17.45,91.15,-58.84,8.978,96.12,-62.76,19.12,106.0,-62.76,10.44,112.9,-62.76,22.45,120.9,-58.84,11.91,121.2,-47.07,24.12,123.0,-31.38,12.12,121.2,-15.69,24.12,120.9,-3.922,11.91,112.9,0.0,22.45,106.0,0.0,10.44,96.12,0.0,19.12,82.65,-15.69,34.24,87.65,-3.922,26.59,85.61,-31.38,25.97,82.65,-47.07,34.24,87.65,-58.84,26.59,90.54,-62.76,37.5,101.9,-62.76,30.93,106.3,-62.76,44.04,116.2,-58.84,35.26,114.2,-47.07,47.31,118.3,-31.38,35.88,114.2,-15.69,47.31,116.2,-3.922,35.26,106.3,0.0,44.04,101.9,0.0,30.93,90.54,0.0,37.5,74.38,-15.69,49.7,80.78,-3.922,43.18,78.9,-31.38,42.17,74.38,-47.07,49.7,80.78,-58.84,43.18,81.48,-62.76,54.45,93.96,-62.76,50.22,95.68,-62.76,63.93,107.1,-58.84,57.27,102.8,-47.07,68.68,109.0,-31.38,58.27,102.8,-15.69,68.68,107.1,-3.922,57.27,95.68,0.0,63.93,93.96,0.0,50.22,81.48,0.0,54.45,63.26,-15.69,63.26,70.8,-3.922,58.11,69.15,-31.38,56.75,63.26,-47.07,63.26};
			return value;
		}
		private double[] getCoordinate_6_26_point_8()
		{
			double[] value = {70.8,-58.84,58.11,69.3,-62.76,69.3,82.35,-62.76,67.59,81.37,-62.76,81.37,93.91,-58.84,77.07,87.41,-47.07,87.41,95.56,-31.38,78.42,87.41,-15.69,87.41,93.91,-3.922,77.07,81.37,0.0,81.37,82.35,0.0,67.59,69.3,0.0,69.3,49.7,-15.69,74.38,58.11,-3.922,70.8,56.75,-31.38,69.15,49.7,-47.07,74.38,58.11,-58.84,70.8,54.45,-62.76,81.48,67.59,-62.76,82.35,63.93,-62.76,95.68,77.07,-58.84,93.91,68.68,-47.07,102.8,78.42,-31.38,95.56,68.68,-15.69,102.8,77.07,-3.922,93.91,63.93,0.0,95.68,67.59,0.0,82.35,54.45,0.0,81.48,34.24,-15.69,82.65,43.18,-3.922,80.78,42.17,-31.38,78.9,34.24,-47.07,82.65,43.18,-58.84,80.78,37.5,-62.76,90.54,50.22,-62.76,93.96,44.04,-62.76,106.3,57.27,-58.84,107.1,47.31,-47.07,114.2,58.27,-31.38,109.0,47.31,-15.69,114.2,57.27,-3.922,107.1,44.04,0.0,106.3,50.22,0.0,93.96,37.5,0.0,90.54,17.45,-15.69,87.74,26.59,-3.922,87.65,25.97,-31.38,85.61,17.45,-47.07,87.74,26.59,-58.84,87.65,19.12,-62.76,96.12,30.93,-62.76,101.9,22.45,-62.76,112.9,35.26,-58.84,116.2,24.12,-47.07,121.2,35.88,-31.38,118.3,24.12,-15.69,121.2,35.26,-3.922,116.2,22.45,0.0,112.9,30.93,0.0,101.9,19.12,0.0,96.12,0.0,-15.69,89.46,8.978,-3.922,91.15,8.769,-31.38,89.03,0.0,-47.07,89.46,8.978,-58.84,91.15,0.0,-62.76,98.0,10.44,-62.76,106.0,0.0,-62.76,115.1,11.91,-58.84,120.9,0.0,-47.07,123.6,12.12,-31.38,123.0,0.0,-15.69,123.6,11.91,-3.922,120.9,0.0,0.0,115.1,10.44,0.0,106.0,0.0,0.0,98.0,-17.45,-15.69,87.74,-8.978,-3.922,91.15,-8.769,-31.38,89.03,-17.45,-47.07,87.74,-8.978,-58.84,91.15,-19.12,-62.76,96.12,-10.44,-62.76,106.0,-22.45,-62.76,112.9,-11.91,-58.84,120.9,-24.12,-47.07,121.2,-12.12,-31.38,123.0,-24.12,-15.69,121.2,-11.91,-3.922,120.9,-22.45,0.0,112.9,-10.44,0.0,106.0,-19.12,0.0,96.12,-34.24,-15.69,82.65,-26.59,-3.922,87.65,-25.97,-31.38,85.61,-34.24,-47.07,82.65,-26.59,-58.84,87.65,-37.5,-62.76,90.54,-30.93,-62.76,101.9,-44.04,-62.76,106.3};
			return value;
		}
		private double[] getCoordinate_6_26_point_9()
		{
			double[] value = {-35.26,-58.84,116.2,-47.31,-47.07,114.2,-35.88,-31.38,118.3,-47.31,-15.69,114.2,-35.26,-3.922,116.2,-44.04,0,106.3,-30.93,0,101.9,-37.5,0,90.54,-49.7,-15.69,74.38,-43.18,-3.922,80.78,-42.17,-31.38,78.9,-49.7,-47.07,74.38,-43.18,-58.84,80.78,-54.45,-62.76,81.48,-50.22,-62.76,93.96,-63.93,-62.76,95.68,-57.27,-58.84,107.1,-68.68,-47.07,102.8,-58.27,-31.38,109,-68.68,-15.69,102.8,-57.27,-3.922,107.1,-63.93,0,95.68,-50.22,0,93.96,-54.45,0,81.48,-63.26,-15.69,63.26,-58.11,-3.922,70.8,-56.75,-31.38,69.15,-63.26,-47.07,63.26,-58.11,-58.84,70.8,-69.3,-62.76,69.3,-67.59,-62.76,82.35,-81.37,-62.76,81.37,-77.07,-58.84,93.91,-87.41,-47.07,87.41,-78.42,-31.38,95.56,-87.41,-15.69,87.41,-77.07,-3.922,93.91,-81.37,0,81.37,-67.59,0,82.35,-69.3,0,69.3,-74.38,-15.69,49.7,-70.8,-3.922,58.11,-69.15,-31.38,56.75,-74.38,-47.07,49.7,-70.8,-58.84,58.11,-81.48,-62.76,54.45,-82.35,-62.76,67.59,-95.68,-62.76,63.93,-93.91,-58.84,77.07,-102.8,-47.07,68.68,-95.56,-31.38,78.42,-102.8,-15.69,68.68,-93.91,-3.922,77.07,-95.68,0,63.93,-82.35,0,67.59,-81.48,0,54.45,-82.65,-15.69,34.24,-80.78,-3.922,43.18,-78.9,-31.38,42.17,-82.65,-47.07,34.24,-80.78,-58.84,43.18,-90.54,-62.76,37.5,-93.96,-62.76,50.22,-106.3,-62.76,44.04,-107.1,-58.84,57.27,-114.2,-47.07,47.31,-109,-31.38,58.27,-114.2,-15.69,47.31,-107.1,-3.922,57.27,-106.3,0,44.04,-93.96,0,50.22,-90.54,0,37.5,-87.74,-15.69,17.45,-87.65,-3.922,26.59,-85.61,-31.38,25.97,-87.74,-47.07,17.45,-87.65,-58.84,26.59,-96.12,-62.76,19.12,-101.9,-62.76,30.93,-112.9,-62.76,22.45,-116.2,-58.84,35.26,-121.2,-47.07,24.12,-118.3,-31.38,35.88,-121.2,-15.69,24.12,-116.2,-3.922,35.26,-112.9,0,22.45,-101.9,0,30.93,-96.12,0,19.12,-89.46,-15.69,0,-91.15,-3.922,8.978,-89.03,-31.38,8.769,-89.46,-47.07,0,-91.15,-58.84,8.978,-98,-62.76,0,-106,-62.76,10.44,-115.1,-62.76,-1.054e-005,-120.9,-58.84,11.91,-123.6,-47.07,-1.115e-005,-123.0,-31.38,12.12,-123.6,-15.69,-1.115e-005};
			return value;
		}
		private double[] getCoordinate_6_26_point_10()
		{
			double[] value = {-120.9,-3.922,11.91,-115.1,0,-1.054e-005,-106.0,0.0,10.44,-98.0,0.0,0.0,-87.74,-15.69,-17.45,-91.15,-3.922,-8.978,-89.03,-31.38,-8.769,-87.74,-47.07,-17.45,-91.15,-58.84,-8.978,-96.12,-62.76,-19.12,-106.0,-62.76,-10.44,-112.9,-62.76,-22.45,-120.9,-58.84,-11.91,-121.2,-47.07,-24.12,-123.0,-31.38,-12.12,-121.2,-15.69,-24.12,-120.9,-3.922,-11.91,-112.9,0.0,-22.45,-106.0,0.0,-10.44,-96.12,0.0,-19.12,-82.65,-15.69,-34.24,-87.65,-3.922,-26.59,-85.61,-31.38,-25.97,-82.65,-47.07,-34.24,-87.65,-58.84,-26.59,-90.54,-62.76,-37.5,-101.9,-62.76,-30.93,-106.3,-62.76,-44.04,-116.2,-58.84,-35.26,-114.2,-47.07,-47.31,-118.3,-31.38,-35.88,-114.2,-15.69,-47.31,-116.2,-3.922,-35.26,-106.3,0.0,-44.04,-101.9,0.0,-30.93,-90.54,0.0,-37.5,-74.38,-15.69,-49.7,-80.78,-3.922,-43.18,-78.9,-31.38,-42.17,-74.38,-47.07,-49.7,-80.78,-58.84,-43.18,-81.48,-62.76,-54.45,-93.96,-62.76,-50.22,-95.68,-62.76,-63.93,-107.1,-58.84,-57.27,-102.8,-47.07,-68.68,-109.0,-31.38,-58.27,-102.8,-15.69,-68.68,-107.1,-3.922,-57.27,-95.68,0.0,-63.93,-93.96,0.0,-50.22,-81.48,0.0,-54.45,-63.26,-15.69,-63.26,-70.8,-3.922,-58.11,-69.15,-31.38,-56.75,-63.26,-47.07,-63.26,-70.8,-58.84,-58.11,-69.3,-62.76,-69.3,-82.35,-62.76,-67.59,-81.37,-62.76,-81.37,-93.91,-58.84,-77.07,-87.41,-47.07,-87.41,-95.56,-31.38,-78.42,-87.41,-15.69,-87.41,-93.91,-3.922,-77.07,-81.37,0.0,-81.37,-82.35,0.0,-67.59,-69.3,0.0,-69.3,-49.7,-15.69,-74.38,-58.11,-3.922,-70.8,-56.75,-31.38,-69.15,-49.7,-47.07,-74.38,-58.11,-58.84,-70.8,-54.45,-62.76,-81.48,-67.59,-62.76,-82.35,-63.93,-62.76,-95.68,-77.07,-58.84,-93.91,-68.68,-47.07,-102.8,-78.42,-31.38,-95.56,-68.68,-15.69,-102.8,-77.07,-3.922,-93.91,-63.93,0.0,-95.68,-67.59,0.0,-82.35,-54.45,0.0,-81.48,-34.24,-15.69,-82.65,-43.18,-3.922,-80.78,-42.17,-31.38,-78.9,-34.24,-47.07,-82.65,-43.18,-58.84,-80.78,-37.5,-62.76,-90.54,-50.22,-62.76,-93.96,-44.04,-62.76,-106.3,-57.27,-58.84,-107.1,-47.31,-47.07,-114.2,-58.27,-31.38,-109.0,-47.31,-15.69,-114.2,-57.27,-3.922,-107.1,-44.04,0.0,-106.3,-50.22,0.0,-93.96,-37.5,0.0,-90.54};
			return value;
		}
		private double[] getCoordinate_6_26_point_11()
		{
			double[] value = {-17.45,-15.69,-87.74,-26.59,-3.922,-87.65,-25.97,-31.38,-85.61,-17.45,-47.07,-87.74,-26.59,-58.84,-87.65,-19.12,-62.76,-96.12,-30.93,-62.76,-101.9,-22.45,-62.76,-112.9,-35.26,-58.84,-116.2,-24.12,-47.07,-121.2,-35.88,-31.38,-118.3,-24.12,-15.69,-121.2,-35.26,-3.922,-116.2,-22.45,0.0,-112.9,-30.93,0.0,-101.9,-19.12,0.0,-96.12,-8.978,-3.922,-91.15,-8.769,-31.38,-89.03,-8.978,-58.84,-91.15,-10.44,-62.76,-106.0,-11.91,-58.84,-120.9,-12.12,-31.38,-123.0,-11.91,-3.922,-120.9,-10.44,0.0,-106.0};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #20, 2112 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_20_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_20_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_2()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_3()));
			return IndexedFaceSet_5_20_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #20, 798 total numbers made up of 266 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_20_point()
		{
			MFVec3f Coordinate_6_20_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_20_point_1()))
				.append(new MFVec3f(getCoordinate_6_20_point_2()))
				.append(new MFVec3f(getCoordinate_6_20_point_3()));
			return Coordinate_6_20_point;
		}
		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #26, 8192 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_26_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_26_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_2()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_3()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_4()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_5()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_6()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_7()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_8()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_9()));
			return IndexedFaceSet_5_26_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #26, 3072 total numbers made up of 1024 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_26_point()
		{
			MFVec3f Coordinate_6_26_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_26_point_1()))
				.append(new MFVec3f(getCoordinate_6_26_point_2()))
				.append(new MFVec3f(getCoordinate_6_26_point_3()))
				.append(new MFVec3f(getCoordinate_6_26_point_4()))
				.append(new MFVec3f(getCoordinate_6_26_point_5()))
				.append(new MFVec3f(getCoordinate_6_26_point_6()))
				.append(new MFVec3f(getCoordinate_6_26_point_7()))
				.append(new MFVec3f(getCoordinate_6_26_point_8()))
				.append(new MFVec3f(getCoordinate_6_26_point_9()))
				.append(new MFVec3f(getCoordinate_6_26_point_10()))
				.append(new MFVec3f(getCoordinate_6_26_point_11()));
			return Coordinate_6_26_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return UnitSaturn model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new UnitSaturn().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Units.UnitSaturn\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Units.UnitSaturn self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Units/UnitSaturn_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Units/UnitSaturn_JavaExport.x3d"; 
                String filenameX3DV = "Units/UnitSaturn_JavaExport.x3dv"; 
                String filenameJSON = "Units/UnitSaturn_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
